/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.TableCheckConstraintPropertyDialogOracle;

public abstract class TableCheckConstraintOracle
extends AbstractStorageObjectOracle {
    private TableProxyOracle table;
    private String deferrable = "NO";
    private static final String[] INITIALLY = new String[]{"IMMEDIATE", "DEFERRED"};
    private static Set initiallySet = null;
    private String initially = INITIALLY[0];
    private String enable = "YES";
    private String validate = "YES";
    private TableProxyOracle exceptionsTable = null;

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableCheckConstraintPropertyDialogOracle dialog = new TableCheckConstraintPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "TableCheckConstraint";
    }

    @Override
    public String getIDPrefix() {
        return "TCC";
    }

    @Override
    public String getName() {
        String name;
        if (this.isNameChanged() && !"".equals(name = super.getName())) {
            return name;
        }
        TableLevelConstraint tableConstraint = this.getTableConstraint();
        if (tableConstraint != null) {
            return tableConstraint.getName();
        }
        return "";
    }

    @Override
    public boolean setName(String name) {
        TableLevelConstraint tableConstraint;
        boolean result = true;
        if (!this.getName().equals(name)) {
            result = super.setName(name);
            if (result) {
                this.setNameChanged(true);
                this.setDirty(true);
            }
            this.fireDataFieldChange();
        }
        if (this.isNameChanged() && (tableConstraint = this.getTableConstraint()) != null && this.getName().equals(tableConstraint.getName())) {
            this.setNameChanged(false);
            this.setDirty(true);
        }
        return result;
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    public TableLevelConstraint getTableConstraint() {
        if (this.table != null) {
            for (TableLevelConstraint tlc : ((Table)this.table.getObject()).getCheckConstraints()) {
                if (!tlc.getObjectID().equals(this.getObjectID())) continue;
                return tlc;
            }
        }
        return null;
    }

    public String getRule() {
        TableLevelConstraint constr = this.getTableConstraint();
        if (constr != null) {
            return constr.getRule();
        }
        return "";
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setTable(TableProxyOracle table) {
        this.table = table;
        if (table != null) {
            table.addObject(this);
        }
        this.setPAC_Element(table);
    }

    public static String[] getInitiallyChoices() {
        return INITIALLY;
    }

    protected boolean checkInitially(String value) {
        if (initiallySet == null) {
            initiallySet = new HashSet();
            initiallySet.addAll(Arrays.asList(TableCheckConstraintOracle.getInitiallyChoices()));
        }
        return initiallySet.contains(value);
    }

    public void setInitially(String initially) {
        if (this.checkInitially(initially)) {
            this.initially = initially;
            this.fireDataFieldChange();
        }
    }

    public String getInitially() {
        return this.initially;
    }

    public void setDeferrable(String deferrable) {
        if (ConstantsOracle.checkYesNo(deferrable)) {
            this.deferrable = deferrable;
            this.fireDataFieldChange();
        }
    }

    public String getDeferrable() {
        return this.deferrable;
    }

    public void setEnable(String enable) {
        if (ConstantsOracle.checkYesNo(enable)) {
            this.enable = enable;
            this.fireDataFieldChange();
        }
    }

    public String getEnable() {
        return this.enable;
    }

    public void setValidate(String validate) {
        if (ConstantsOracle.checkYesNo(validate)) {
            this.validate = validate;
            this.fireDataFieldChange();
        }
    }

    public String getValidate() {
        return this.validate;
    }

    public TableProxyOracle getExceptionsTable() {
        return this.exceptionsTable;
    }

    public void setExceptionsTable(TableProxyOracle exceptionsTable) {
        this.exceptionsTable = exceptionsTable;
        this.fireDataFieldChange();
    }

    public String getConstraintID() {
        return this.getObjectID();
    }

    public void setConstraintID(String tableCCID) {
        this.setObjectID(tableCCID);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON", 16);
    }
}

