/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;

public class ColumnIdentityDB2v80
extends ColumnIdentityDB2 {
    private static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    protected String order = YES_NO_STATES[1];

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(value);
    }

    public String getOrder() {
        if (this.column != null && !((ColumnProxyDB2v80)this.column).isOrderChanged()) {
            boolean autoIncOrder = this.column.getColumn().isAutoIncrementOrder();
            return autoIncOrder ? YES_NO_STATES[0] : YES_NO_STATES[1];
        }
        return this.order;
    }

    public void setOrder(String order) {
        if (this.checkYesNo(order)) {
            this.order = order;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        ColumnIdentityDB2v80 identity = null;
        StorageObject storageObject = (StorageObject)((StorageDesignDB2v80)targetDesign).getColumnIdentitySet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                identity = (ColumnIdentityDB2v80)storageObject;
            }
        } else {
            identity = (ColumnIdentityDB2v80)((StorageDesignDB2v80)targetDesign).getColumnIdentitySet().createColumnIdentity();
        }
        if (identity != null) {
            identity.setName(this.getName());
            identity.setGenerate(this.getGenerate());
            identity.setStartWith(this.getStartWith());
            identity.setIncrementBy(this.getIncrementBy());
            identity.setCache(this.getCache());
            identity.setCycle(this.isCycle());
            identity.setMinValue(this.getMinValue());
            identity.setMaxValue(this.getMaxValue());
            identity.setOrder(this.getOrder());
            identity.setRawObject(false);
        }
    }
}

