/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v70;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v70.TriggerDB2v70;

public class TableProxyDB2v70
extends TableProxyDB2 {
    public TableProxyDB2v70(Table table, StorageDesign storage) {
        super(table, storage);
    }

    public TableProxyDB2v70(Design design, String id, String longName, StorageDesign storage) {
        super(design, id, longName, storage);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Table table = (Table)((StorageDesignDB2v70)targetDesign).getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxyDB2v70 tableProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignDB2v70)targetDesign).getTableProxySet().getProxy(table.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableProxy = (TableProxyDB2v70)storageObject;
        }
        if (tableProxy != null) {
            tableProxy.setName(this.getName());
            for (SynonymDB2 synonym : this.getSynonyms()) {
                SynonymDB2 targetSynonym = (SynonymDB2)((StorageDesignDB2v70)targetDesign).getSynonymSet().getByName(synonym.getName());
                if (targetSynonym == null) {
                    SynonymDB2 newSynonym = ((StorageDesignDB2v70)targetDesign).getSynonymSet().createSynonym();
                    newSynonym.setName(synonym.getName());
                    newSynonym.setRawObject(true);
                    newSynonym.setTable(tableProxy);
                    continue;
                }
                targetSynonym.setTable(tableProxy);
            }
            for (TriggerDB2v70 trigger : this.getTriggers()) {
                TriggerDB2v70 targetTrigger = (TriggerDB2v70)((StorageDesignDB2v70)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerDB2v70 newTrigger = (TriggerDB2v70)((StorageDesignDB2v70)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setTable(tableProxy);
                    tableProxy.addTriggersFromDesign(((StorageDesignDB2v70)targetDesign).getTriggerSet());
                    continue;
                }
                targetTrigger.setTable(tableProxy);
                tableProxy.addTriggersFromDesign(((StorageDesignDB2v70)targetDesign).getTriggerSet());
            }
            if (this.getOwner() != null) {
                Owner owner = (Owner)((StorageDesignDB2v70)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    Owner newOwner = (Owner)((StorageDesignDB2v70)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    tableProxy.setOwner(newOwner);
                } else {
                    tableProxy.setOwner(owner);
                }
            }
            if (this.getTableSpace() != null) {
                TableSpaceDB2 tblSpace = (TableSpaceDB2)((StorageDesignDB2v70)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tblSpace == null) {
                    TableSpaceDB2 newTblSpace = ((StorageDesignDB2v70)targetDesign).getTableSpaceSet().createTableSpace();
                    newTblSpace.setName(this.getTableSpace().getName());
                    newTblSpace.setRawObject(true);
                    tableProxy.setTableSpace(newTblSpace);
                } else {
                    tableProxy.setTableSpace(tblSpace);
                }
            }
            tableProxy.setObid(this.getObid());
            tableProxy.setEditProc(this.getEditProc());
            tableProxy.setValidProc(this.getValidProc());
            tableProxy.setAudit(this.getAudit());
            tableProxy.setDataCapture(this.getDataCapture());
            tableProxy.setDropRestrict(this.getDropRestrict());
            tableProxy.setCcsid(this.getCcsid());
            tableProxy.setLabel(this.getLabel());
            tableProxy.setComment(this.getComment());
            tableProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxy.setRawObject(false);
        }
    }
}

