/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.GroupRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKCreateEdit;

public class FKDiscoverer {
    public static int NAME_POLICY_REFERRED = 0;
    public static int NAME_POLICY_TEMPLATE = 1;
    public static int NAME_POLICY_REF_AND_TEMPLATE = 2;
    public static int NAME_POLICY_TEMPLATE_AND_REF = 3;
    public static int NAME_POLICY = NAME_POLICY_REF_AND_TEMPLATE;
    public static boolean IN_ONE_FK_ONLY = true;
    public static boolean LONGEST_KEYS_FIRST = true;
    private RelationalDesign rd;
    private List allFKeys = new ArrayList();
    private List allTables = new ArrayList();
    private List allPKeys = new ArrayList();
    private List allUKeys = new ArrayList();
    private List prepareList = new ArrayList();
    private static IndexComparator INDEX_COMPARATOR = new IndexComparator();
    private static IndexComparatorReverse INDEX_COMPARATOR_REVERSE = new IndexComparatorReverse();
    private static String PROPERTY_NAME = "createdByFKDiscoverer";
    private static String TRUE = "true";

    public static void main(String[] args) {
    }

    public FKDiscoverer(RelationalDesign rd) {
        this.rd = rd;
        this.init();
    }

    private void init() {
        this.allPKeys.clear();
        this.allUKeys.clear();
        this.allTables.clear();
        this.prepareList.clear();
        for (Index index : this.rd.getGlobalIndexSet()) {
            if (index.isPK()) {
                this.allPKeys.add(index);
                continue;
            }
            if (!index.isUnique()) continue;
            this.allUKeys.add(index);
        }
        Iterator it = this.rd.getTableSet().iterator();
        while (it.hasNext()) {
            this.allTables.add(it.next());
        }
        if (LONGEST_KEYS_FIRST) {
            Collections.sort(this.allPKeys, INDEX_COMPARATOR_REVERSE);
            Collections.sort(this.allUKeys, INDEX_COMPARATOR_REVERSE);
        } else {
            Collections.sort(this.allPKeys, INDEX_COMPARATOR);
            Collections.sort(this.allUKeys, INDEX_COMPARATOR);
        }
    }

    private Index getKey() {
        Index key = null;
        if (this.allPKeys.size() > 0) {
            key = (Index)this.allPKeys.get(0);
            key = this.getKey(key, this.allPKeys);
        }
        if (key == null && this.allUKeys.size() > 0) {
            key = (Index)this.allUKeys.get(0);
            key = this.getKey(key, this.allUKeys);
        }
        return key;
    }

    private Index getKey(Index key, List keys) {
        Index result = key;
        return result;
    }

    public List prepareFKs() {
        this.prepareList.clear();
        Index key = this.getKey();
        while (key != null) {
            this.removeKeyFromLists(key);
            this.processKey(key);
            key = this.getKey();
        }
        return this.prepareList;
    }

    private boolean isprocessingReferred() {
        return NAME_POLICY == NAME_POLICY_REF_AND_TEMPLATE || NAME_POLICY == NAME_POLICY_REFERRED || NAME_POLICY == NAME_POLICY_TEMPLATE_AND_REF;
    }

    private boolean isprocessingTempalte() {
        return NAME_POLICY == NAME_POLICY_REF_AND_TEMPLATE || NAME_POLICY == NAME_POLICY_TEMPLATE || NAME_POLICY == NAME_POLICY_TEMPLATE_AND_REF;
    }

    private boolean isReferenceColumnFirst() {
        return NAME_POLICY == NAME_POLICY_REF_AND_TEMPLATE || NAME_POLICY == NAME_POLICY_REFERRED;
    }

    private void processKey(Index key) {
        Column[] cols = (Column[])key.getColumns();
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        for (Table table : this.allTables) {
            list.clear();
            for (int i = 0; i < cols.length; ++i) {
                String fkColName;
                FKElement col = null;
                if (this.isReferenceColumnFirst()) {
                    if (this.isprocessingReferred()) {
                        col = table.getEquivelentColumn(cols[i], null, IN_ONE_FK_ONLY);
                    }
                    if (col == null && this.isprocessingTempalte()) {
                        fkColName = table.createFKColumnName(cols[i]);
                        col = table.getEquivelentColumn(cols[i], fkColName, IN_ONE_FK_ONLY);
                    }
                } else {
                    if (this.isprocessingTempalte()) {
                        fkColName = table.createFKColumnName(cols[i]);
                        col = table.getEquivelentColumn(cols[i], fkColName, IN_ONE_FK_ONLY);
                    }
                    if (col == null && this.isprocessingReferred()) {
                        col = table.getEquivelentColumn(cols[i], null, IN_ONE_FK_ONLY);
                    }
                }
                if (col == null) break;
                if (this.isFKColumn(col) && IN_ONE_FK_ONLY) continue;
                list.add(col);
            }
            if (list.size() != cols.length) continue;
            FKPrepare fkp = new FKPrepare();
            fkp.parentTable = key.getTable();
            fkp.referredKey = key;
            fkp.childTable = table;
            fkp.childColumns.addAll(list);
            this.prepareList.add(fkp);
        }
    }

    private boolean isFKColumn(FKElement column) {
        for (FKPrepare fkp : this.prepareList) {
            if (!fkp.childColumns.contains(column)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createForeignKeys() {
        CompoundEdit groupEdit = null;
        this.rd.getUndoManager().setLocked(true);
        try {
            for (FKPrepare fkp : this.prepareList) {
                if (fkp.selected) {
                    fkp.fk = fkp.childTable.addForeignKey(fkp.referredKey, fkp.childColumns);
                    if (fkp.fk == null) continue;
                    if (groupEdit == null) {
                        groupEdit = new GroupRemoveEdit(fkp.fk, "Create discovered Foreign keys", "Remove discovered Foreign keys");
                    }
                    fkp.fk.resetMandatoryUsingColumns();
                    fkp.fk.addToAllDPVs();
                    fkp.fk.resetEdgeParams();
                    fkp.fk.setProperty(PROPERTY_NAME, TRUE);
                    FKCreateEdit edit = new FKCreateEdit(fkp.fk);
                    edit.end();
                    groupEdit.addEdit(edit);
                    continue;
                }
                fkp.fk = null;
            }
        }
        finally {
            this.rd.getUndoManager().setLocked(false);
        }
        if (groupEdit != null) {
            groupEdit.end();
            this.rd.postUndoableEdit(groupEdit);
        }
    }

    private void removeKeyFromLists(Index key) {
        if (key.isPK()) {
            this.allPKeys.remove(key);
        } else {
            this.allUKeys.remove(key);
        }
    }

    public List getPrepareList() {
        return this.prepareList;
    }

    public void rescane() {
        this.init();
        this.prepareFKs();
    }

    static class IndexComparatorReverse
    implements Comparator {
        IndexComparatorReverse() {
        }

        public int compare(Object one, Object two) {
            int s1 = -1;
            int s2 = -1;
            if (one instanceof Index) {
                s1 = ((Index)one).getElementsCollection().size();
            }
            if (two instanceof Index) {
                s2 = ((Index)two).getElementsCollection().size();
            }
            if (s1 < s2) {
                return 1;
            }
            if (s2 < s1) {
                return -1;
            }
            return 0;
        }
    }

    static class IndexComparator
    implements Comparator {
        IndexComparator() {
        }

        public int compare(Object one, Object two) {
            int s1 = -1;
            int s2 = -1;
            if (one instanceof Index) {
                s1 = ((Index)one).getElementsCollection().size();
            }
            if (two instanceof Index) {
                s2 = ((Index)two).getElementsCollection().size();
            }
            if (s1 > s2) {
                return 1;
            }
            if (s2 > s1) {
                return -1;
            }
            return 0;
        }
    }

    public static class FKPrepare {
        public Table parentTable;
        public Table childTable;
        public Index referredKey;
        public List childColumns = new ArrayList();
        public boolean selected = true;
        public FKIndexAssociation fk;
    }
}

