/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class FK_RelationComparator
extends EngPropertiesComparator {
    private Relation rel;
    private FKIndexAssociation fk;
    private boolean mandatoryDefined = false;

    public FK_RelationComparator(FKIndexAssociation fk, Relation rel) {
        super(fk, rel);
        this.rel = rel;
        this.fk = fk;
        this.initPropertiesList();
    }

    public FK_RelationComparator(FKIndexAssociation fk, Relation rel, List filters) {
        this(fk, rel);
        this.applyCompareFilter(filters, fk.getDesign().getShowSelPropsOnly());
    }

    @Override
    protected void initNameProperty() {
        EngPropertyHolder ph = new EngPropertyHolder(NAME);
        ph.setLeftValue(this.fk != null ? this.fk.getName() : "");
        ph.setRightValue(this.rel != null ? this.rel.getName() : "");
        if (this.fk != null && this.rel != null && !this.fk.getName().equals(this.rel.getName())) {
            if (this.getDesign().isApplyNameStandardization()) {
                String tr_name = this.getDesign().transformNameFromRelationalToLogical(this.fk);
                if (!tr_name.equals(this.rel.getName())) {
                    String nt = this.getDesign().getDesignLevelSettings().getNamingStandardRule().getFkConstr();
                    if (nt.indexOf("{relationship}") < 0) {
                        this.translated_name = tr_name;
                        ph.setModified(true);
                        ph.setSelected(true);
                    } else {
                        String rev_tr_name = this.getDesign().transformNameFromLogicalToRelational(this.rel, this.fk, this.fk.getTable());
                        String rn = this.rel.getName();
                        String fn = this.fk.getName();
                        String rnInRel = "";
                        int ind1 = rev_tr_name.indexOf(rn);
                        if (ind1 > -1) {
                            int ind3;
                            String p1 = rev_tr_name.substring(0, ind1);
                            int ind2 = ind1 + rn.length();
                            String p2 = "";
                            if (ind2 < rev_tr_name.length()) {
                                p2 = rev_tr_name.substring(ind2);
                            }
                            rnInRel = "".equals(p1) ? fn : fn.substring(p1.length());
                            if (!"".equals(p2) && (ind3 = rnInRel.indexOf(p2)) > 0) {
                                rnInRel = rnInRel.substring(0, ind3);
                            }
                            if (!rn.equals(rnInRel)) {
                                this.translated_name = rnInRel;
                                ph.setModified(true);
                                ph.setSelected(true);
                            }
                        }
                    }
                }
            } else {
                NamingStandardRule namingRule = this.getDesign().getNamingStandardRule();
                char logSep = namingRule.getLogicalSeparatorChar();
                char relSep = namingRule.getRelationalSeparatorChar();
                String tr_name = AbstractEngineering.transformSeparatorFromLogical(this.fk.getName(), logSep, relSep);
                if (!tr_name.equals(this.rel.getName())) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            }
        }
        this.propertiesList.add(ph);
    }

    @Override
    protected void initNameTranslationProperty() {
        EngPropertyHolder name_ph;
        if ("".equals(this.translated_name)) {
            return;
        }
        if (this.rel != null && !this.translated_name.equals(this.rel.getName()) && (name_ph = this.getPropertyHolderByName(NAME)) != null) {
            name_ph.setModified(true);
            name_ph.setSelected(true);
        }
        EngPropertyHolder ph = new EngPropertyHolder(NAME_TRANSLATION);
        ph.setLeftValue(this.translated_name);
        ph.setModified(false);
        ph.setSelected(false);
        this.propertiesList.add(ph);
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            if (this.isMandatoryDefined() && this.rel != null && this.fk != null) {
                for (EngPropertyHolder ph : this.propertiesList) {
                    if (!ph.isSelected()) continue;
                    if (ph.getName().equals(MANDATORY)) {
                        String leftv = ph.getLeftValue();
                        try {
                            int[] pkends = this.rel.getPKProviderEndPoint();
                            if (pkends.length != 1) continue;
                            int endp = pkends[0];
                            int other = this.rel.getOtherEndPoint(endp);
                            boolean mandatory = Boolean.valueOf(leftv);
                            this.rel.setOptional(other, !mandatory);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (ph.getName().equals(DELETE_RULE)) {
                        this.rel.setDeleteRule(this.fk.getDeleteRule());
                        continue;
                    }
                    if (!ph.getName().equals(NAME)) continue;
                    if (!"".equals(this.translated_name)) {
                        this.rel.setName(this.translated_name);
                        continue;
                    }
                    if ("".equals(ph.getLeftValue())) continue;
                    this.rel.setName(ph.getLeftValue());
                }
            }
        }
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        if (this.getDesign().isApplyNameStandardization()) {
            this.initNameTranslationProperty();
        }
        this.initMandatory();
        this.initDeleteRule();
        this.initCommentsAndNotes();
    }

    private void initMandatory() {
        int[] pkends;
        this.mandatoryDefined = false;
        String leftv = "";
        if (this.fk != null) {
            leftv = String.valueOf(this.fk.isMandatory());
        }
        String rightv = "";
        if (this.rel != null && (pkends = this.rel.getPKProviderEndPoint()).length == 1) {
            int endp = pkends[0];
            int other = this.rel.getOtherEndPoint(endp);
            rightv = String.valueOf(!this.rel.isOptional(other));
            this.mandatoryDefined = true;
        }
        if (this.mandatoryDefined) {
            PropertyHolder ph = new PropertyHolder(MANDATORY);
            ph.setLeftValue(leftv);
            ph.setRightValue(rightv);
            if (!leftv.equalsIgnoreCase(rightv)) {
                if ("false".equals(leftv) && "true".equals(rightv) && this.rel.inArc()) {
                    ph.setModified(true);
                    ph.setSelected(false);
                    ph.setEditable(false);
                    ph.setFiltered(true);
                } else {
                    ph.setModified(true);
                    ph.setSelected(true);
                    ph.setEditable(true);
                }
            }
            this.propertiesList.add(ph);
        }
    }

    public boolean isMandatoryDefined() {
        return this.mandatoryDefined;
    }

    private void initDeleteRule() {
        boolean optional = true;
        String leftv = "";
        if (this.fk != null) {
            leftv = this.fk.getDeleteRule();
        }
        String rightv = "";
        if (this.rel != null) {
            rightv = this.rel.getDeleteRule();
        }
        PropertyHolder ph = new PropertyHolder(DELETE_RULE);
        ph.setLeftValue(leftv);
        ph.setRightValue(rightv);
        if (!leftv.equalsIgnoreCase(rightv)) {
            ph.setModified(optional);
            ph.setSelected(optional);
            ph.setEditable(optional);
        }
        this.propertiesList.add(ph);
    }
}

