/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.FWDEngineering;
import oracle.dbtools.crest.model.design.engineering.RelationFKComparator;
import oracle.dbtools.crest.model.design.engineering.ReverseEngineering;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.TVConnector;

public class FEEntityHierarchy {
    private String targetDesPartID;
    private RelationalDesign pdes;
    private FWDEngineering fwdEngineering;
    private ExtendedMap xmap;
    private Design design;
    private Map comparatorsMap;
    private static String _ID = "_ID";

    public FEEntityHierarchy(FWDEngineering fwdEngineering, Design design, RelationalDesign pdes) {
        this.fwdEngineering = fwdEngineering;
        this.targetDesPartID = pdes.getObjectID();
        this.pdes = pdes;
        this.design = design;
        this.xmap = design.getExtendedMap();
    }

    public void processInhEntity(Entity entity) {
        if (entity.isHierarchicalEntityType()) {
            if ("Single Table".equals(entity.getFwdEngineeringStrategyName())) {
                this.singleTableInheritance(entity);
            } else if ("Table per child".equals(entity.getFwdEngineeringStrategyName())) {
                this.tablePerChildInheritance(entity);
            } else if ("Table for each entity".equals(entity.getFwdEngineeringStrategyName())) {
                this.processEntity(entity, 3);
            }
        }
    }

    private void processKeys_Single(Entity entity, Table table, XtdMapping mapping) {
        Index ind;
        CandidateKey pk = (CandidateKey)entity.getPK();
        this.fwdEngineering.processKeys(entity, table, mapping);
        if (entity.isHierarchicalEntityType()) {
            int count = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < count; ++i) {
                Entity ch_ent = entity.getHierarchicalChild(i);
                XtdMapping ch_mapping = ch_ent.getMappingFor(table);
                if (ch_mapping == null) continue;
                this.processKeys_Single(ch_ent, table, ch_mapping);
            }
        }
        if (pk != null && (ind = pk.getEngIndex(this.pdes)) != null) {
            ind.setPK(true);
        }
    }

    public void processRoot(Entity root) {
        if (root.isHierarchicalRoot()) {
            if ("Single Table".equals(root.getFwdEngineeringStrategyName())) {
                this.processEntSingle(root);
            } else if ("Table per child".equals(root.getFwdEngineeringStrategyName())) {
                this.processEntLeaf(root);
            } else if ("Table for each entity".equals(root.getFwdEngineeringStrategyName())) {
                this.processEntAll(root);
            }
        }
    }

    private void processEntAll(Entity root) {
        ArrayList list = new ArrayList();
        this.addEntity(root, list);
        for (Entity entity : list) {
            this.deleteMappedTables(entity, 3);
        }
        for (Entity entity : list) {
            this.processEntity(entity, 3);
        }
    }

    private void processEntSingle(Entity root) {
        ArrayList list = new ArrayList();
        this.addEntity(root, list);
        for (Entity entity : list) {
            this.deleteMappedTables(entity, 1);
            if (entity == root) continue;
        }
        this.processEntity(root, 1);
    }

    private void processEntLeaf(Entity root) {
        ArrayList list = new ArrayList();
        ArrayList<Entity> leafs = new ArrayList<Entity>();
        this.addEntity(root, list);
        for (Entity entity : list) {
            this.deleteMappedTables(entity, 2);
            if (entity.hasHierarchicalChildren()) continue;
            leafs.add(entity);
        }
        for (Entity entity : leafs) {
            this.processEntity(entity, 2);
        }
    }

    private void addEntity(Entity entity, List list) {
        list.add(entity);
        int count = entity.getHierarchicalChildrenCount();
        for (int i = 0; i < count; ++i) {
            Entity ch_ent = entity.getHierarchicalChild(i);
            this.addEntity(ch_ent, list);
        }
    }

    private void singleTableInheritance(Entity entity) {
        if (entity.isHierarchicalEntityType()) {
            if (entity.isHierarchicalRoot()) {
                this.processEntity(entity, 1);
            } else {
                this.deleteMappedTables(entity, 1);
            }
        }
    }

    private void deleteMappedTables(Entity entity, int inh_type) {
        List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
        for (XtdMapping mapping : list) {
            Table tab;
            DesignObject obj;
            int type = mapping.getInheritanceType();
            if (type == 0 && entity.isHierarchicalRoot() && "Single Table".equals(entity.getFwdEngineeringStrategyName()) || type == inh_type || !((obj = mapping.getObjectMappedTo(entity)) instanceof Table) || (tab = (Table)obj) == null || !this.fwdEngineering.shouldDelete(tab)) continue;
            List tableMappings = this.xmap.getMappingsForDesignPart(tab, entity.getDesignPart().getObjectID());
            tableMappings.addAll(this.getMappingsOfAllElements(tab));
            tab.removeAllFKAssociations();
            tab.removeDependentFKAssociations();
            tab.remove();
            for (XtdMapping dmapping : tableMappings) {
                this.xmap.removeMapping(dmapping);
            }
        }
    }

    public void processInhEntityNew(Entity root) {
        if (root.isHierarchicalEntityType()) {
            this.processEntity(root);
            if (root.shouldBeEngineered()) {
                // empty if block
            }
            for (Entity ent : root.getHierarchicalChildren()) {
                this.processInhEntityNew(ent);
            }
        }
    }

    private void processEntity(Entity entity) {
        List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
        ArrayList<XtdMapping> directMapping = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : list) {
            if (!entity.shouldBeEngineered() || 3 != mapping.getInheritanceType() && 0 != mapping.getInheritanceType()) continue;
            directMapping.add(mapping);
        }
        if (directMapping.size() == 0 && entity.shouldBeEngineered()) {
            XtdMapping del_mapping;
            String newName = entity.getDesign().transformNameFromLogicalToRelational(entity);
            Table table = this.pdes.createTable(newName);
            this.fwdEngineering.newTables.put(table.getObjectID(), table);
            XtdMapping mapping = this.xmap.createMapping(entity, table);
            mapping.setInheritanceType(3);
            mapping.initializeContained();
            this.copyPropertiesFromEntityToTable(entity, table);
            if (this.design.isEngineerCoordinates()) {
                this.fwdEngineering.setGraphicalPropertiesOnNewObject(entity, table);
            }
            if ((del_mapping = entity.getDeletedMapping(table.getDesignPartId())) != null) {
                entity.updateDeletedMappings(del_mapping.getDeletedID(), table.getObjectID(), table.getDesignPartId());
                this.xmap.removeMapping(del_mapping);
            }
        }
        for (XtdMapping mapping : list) {
            Table table;
            if (entity.shouldBeEngineered()) {
                if (3 != mapping.getInheritanceType() || (table = (Table)mapping.getObjectMappedTo(entity)) == null) continue;
                EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(entity.getObjectID() + table.getObjectID());
                if (comp != null) {
                    comp.copySelectedProperties();
                }
                if (!this.design.isEngineerCoordinates()) continue;
                this.fwdEngineering.setGraphicalPropertiesOnNewObject(entity, table);
                continue;
            }
            if (3 != mapping.getInheritanceType() || (table = (Table)mapping.getObjectMappedTo(entity)) == null) continue;
            table.removeAllFKAssociations();
            table.removeAllKeys();
            table.removeAll();
            table.remove();
        }
    }

    private List getMappingsOfAllElements(Table table) {
        List list;
        String log_id = this.design.getLogicalDesign().getObjectID();
        ArrayList result = new ArrayList();
        for (Column column : table.getElementsCollection()) {
            List list2 = this.xmap.getMappingsForDesignPart(column, log_id);
            result.addAll(list2);
        }
        KeyObject[] keys = table.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Index index = (Index)keys[i];
            list = null;
            list = index.isFK() ? this.xmap.getMappingsForDesignPart(index.getFKAssociation(), log_id) : this.xmap.getMappingsForDesignPart(index, log_id);
            result.addAll(list);
        }
        Collection col = this.pdes.getFKIndexAssociationSet().getAssociationsWith(table);
        for (FKIndexAssociation fkass : col) {
            list = this.xmap.getMappingsForDesignPart(fkass, log_id);
            result.addAll(list);
        }
        return result;
    }

    private void tablePerChildInheritance(Entity entity) {
        if (entity.isHierarchicalEntityType()) {
            if (!entity.hasHierarchicalChildren()) {
                this.processEntity(entity, 2);
            } else {
                this.deleteMappedTables(entity, 2);
            }
        }
    }

    private void processEntity(Entity entity, int inh_type) {
        block9: {
            List list;
            block8: {
                XtdMapping del_mapping;
                list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
                if (list.size() != 0) break block8;
                if (!entity.shouldBeEngineered()) break block9;
                String newName = entity.getDesign().transformNameFromLogicalToRelational(entity);
                Table table = this.pdes.createTable(newName);
                this.fwdEngineering.newTables.put(table.getObjectID(), table);
                XtdMapping mapping = this.xmap.createMapping(entity, table);
                mapping.setInheritanceType(inh_type);
                mapping.initializeContained();
                this.copyPropertiesFromEntityToTable(entity, table);
                if (this.design.isEngineerCoordinates()) {
                    this.fwdEngineering.setGraphicalPropertiesOnNewObject(entity, table);
                }
                if ((del_mapping = entity.getDeletedMapping(table.getDesignPartId())) == null) break block9;
                entity.updateDeletedMappings(del_mapping.getDeletedID(), table.getObjectID(), table.getDesignPartId());
                this.xmap.removeMapping(del_mapping);
                break block9;
            }
            for (XtdMapping mapping : list) {
                Table table;
                if (inh_type == 3 && mapping.getInheritanceType() != 3 || inh_type == 2 && mapping.getInheritanceType() == 3) {
                    table = (Table)mapping.getObjectMappedTo(entity);
                    if (table != null) {
                        table.removeAllFKAssociations();
                        table.removeAllKeys();
                        table.removeAll();
                        mapping.initializeContained();
                    }
                } else {
                    table = (Table)mapping.getObjectMappedTo(entity);
                    if (table != null) {
                        EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(entity.getObjectID() + table.getObjectID());
                        if (comp != null) {
                            comp.copySelectedProperties();
                        }
                        if (this.design.isEngineerCoordinates()) {
                            this.fwdEngineering.setGraphicalPropertiesOnNewObject(entity, table);
                        }
                    }
                }
                mapping.setInheritanceType(inh_type);
            }
        }
    }

    private void copyPropertiesFromEntityToTable(Entity entity, Table table) {
        table.setGeneratorID(entity.getObjectID());
        table.setComment(entity.getComment());
        table.setNotes(entity.getNotes());
        table.setCommentInRDBMS(entity.getCommentInRDBMS());
        table.setTypeID(entity.getTypeID());
        table.getAdditionalClassificationTypes().clear();
        table.getAdditionalClassificationTypes().addAll(entity.getAdditionalClassificationTypes());
        table.setScope(entity.getScope());
        table.setBasedOnStructuredType(entity.getBasedOnStructuredType());
        this.copyVolumesProps(entity, table);
        table.setAbbreviation(entity.getShortName());
    }

    private void copyVolumesProps(Entity entity, Table table) {
        table.setMinVolumes(entity.getMinVolumes());
        table.setExpectedVolumes(entity.getExpectedVolumes());
        table.setMaxVolumes(entity.getMaxVolumes());
        table.setGrowthPercent(entity.getGrowthPercent());
        table.setGrowthType(entity.getGrowthType());
        table.setNormalForm(entity.getNormalForm());
        table.setAdequatelyNormalized(entity.getAdequatelyNormalized());
    }

    void inheritancePostProcessing(Object[] entities) {
        Entity ent;
        int i;
        for (i = 0; i < entities.length; ++i) {
            ent = (Entity)entities[i];
            List list = this.xmap.getMappingsForDesignPart(ent, this.targetDesPartID);
            for (XtdMapping mapping : list) {
                DesignObject obj = mapping.getObjectMappedTo(ent);
                if (obj == null || !(obj instanceof Table)) continue;
                Table table = (Table)obj;
                if (!ent.isHierarchicalEntityType()) continue;
                if ("Table for each entity".equals(ent.getFwdEngineeringStrategyName())) {
                    this.fwdEngineering.processAttributes(ent, table, mapping);
                    this.fwdEngineering.processKeys(ent, table, mapping);
                    continue;
                }
                if ("Single Table".equals(ent.getFwdEngineeringStrategyName())) {
                    if (!ent.isHierarchicalRoot()) continue;
                    this.processAttributes_Single(ent, table, mapping);
                    this.processKeys_Single(ent, table, mapping);
                    continue;
                }
                if (!"Table per child".equals(ent.getFwdEngineeringStrategyName()) || ent.hasHierarchicalChildren()) continue;
                this.processAttributes_Leaf(ent, table, mapping);
                this.processKeys_Leaf(ent, table, mapping);
            }
        }
        for (i = 0; i < entities.length; ++i) {
            ent = (Entity)entities[i];
            if (!ent.isHierarchicalEntityType() || !"Table for each entity".equals(ent.getFwdEngineeringStrategyName()) || !ent.isHierarchicalRoot()) continue;
            this.createFKeys(ent);
        }
    }

    private boolean hasChildWithNoEngineer(Entity ent) {
        for (Entity child : ent.getHierarchicalChildren()) {
            if (child.shouldBeEngineered()) continue;
            return true;
        }
        return false;
    }

    private boolean hasPathToLeafdWithNoEngineer(Entity ent) {
        for (Entity child : ent.getHierarchicalChildren()) {
            if (child.shouldBeEngineered()) continue;
            if (!child.hasHierarchicalChildren()) {
                return true;
            }
            boolean temp = this.hasPathToLeafdWithNoEngineer(child);
            if (!temp) continue;
            return true;
        }
        return false;
    }

    private void processDiscriminatorColumn(Entity ent, Table tab, List not_engineered_entities) {
        if (tab == null) {
            tab = ent.getEngTable(this.pdes, 3);
        }
        if (ent.isGenerateDiscriminatorColumn() && tab != null) {
            String name;
            Attribute dattr;
            Attribute attr = ent.getDiscriminatorAttribute();
            Column col = null;
            if (attr != null) {
                col = attr.getEngColumn(this.pdes, tab);
            }
            if (attr == null) {
                col = tab.getDiscriminatorColumn();
                if (col != null && (dattr = col.getEngAttribute(ent)) != null) {
                    col.setDiscriminatorColumn(false);
                    col = null;
                }
            } else if (col != null && attr != null) {
                dattr = null;
                Column coln = tab.getDiscriminatorColumn();
                if (coln != null) {
                    dattr = coln.getEngAttribute(ent);
                }
                if (dattr == null && coln != null) {
                    coln.setDiscriminatorColumn(false);
                    coln.remove();
                } else if (dattr != null && dattr != attr) {
                    coln.setDiscriminatorColumn(false);
                }
            }
            if ("".equals(name = ent.getDiscriminatorColumnName())) {
                name = ApplyNamingStandards.createDiscrimnator_Column_Name(tab.getName(), tab.getDesign().getDesignLevelSettings().getNamingStandardRule(), tab.getRelationalModel().getName(), tab.getAbbreviation());
            }
            if (col == null) {
                col = tab.createColumn(name);
            } else if (attr == null) {
                col.setName(name);
            }
            col.setDiscriminatorColumn(true);
            col.setMandatory(true);
            col.setUseDomainConstraints(false);
            String cnam = col.getConstraintName();
            if ("".equals(cnam)) {
                name = ent.getShortName();
                if ("".equals(name)) {
                    name = ent.getDesign().transformNameFromLogicalToRelational(ent);
                }
                cnam = "CH_INH_" + name;
            }
            col.setConstraintName(cnam);
            ConstraintEnumeration clist = col.getOwnValueList();
            if (clist == null) {
                clist = new ConstraintEnumeration();
                col.setValueList(clist);
            }
            clist.clearProperties();
            ArrayList<String> values = new ArrayList<String>();
            List list = null;
            list = ent.getAllHierarchicalChildren();
            list.add(0, ent);
            for (Entity hent : list) {
                if (hent.getHierarchicalChildrenCount() != 0 && hent.isCompleteSubtypes()) continue;
                String discrVal = Entity.generateDiscriminatorValue(hent);
                clist.add(discrVal, "entity " + hent.getName());
                values.add(discrVal);
            }
            this.setdiscrColumnType(attr, col, values);
            col.setDirty(true);
        }
    }

    private void setdiscrColumnType(Attribute attr, Column column, List values) {
        String expr = "((-|\\+)?[0-9]+(\\.[0-9]+)?)+";
        Pattern pattern = Pattern.compile(expr);
        boolean numeric = true;
        int length = 1;
        for (String value : values) {
            Matcher matcher;
            length = Math.max(length, value.length());
            if (!numeric || (matcher = pattern.matcher(value)).matches()) continue;
            numeric = false;
        }
        LogicalDatatype lt = null;
        if (attr != null && (lt = attr.getLogicalDatatype()) != null && lt.isNumeric() && numeric) {
            return;
        }
        LogicalDatatype ldt = null;
        if (numeric) {
            ldt = (LogicalDatatype)column.getDesign().getLogicalDatatypeSet().getByName("numeric");
        } else if (lt == null || lt.isNumeric() && !numeric) {
            ldt = (LogicalDatatype)column.getDesign().getLogicalDatatypeSet().getByName("varchar");
        }
        if (lt != null && !lt.isNumeric() && !numeric) {
            column.setDataTypeSize(String.valueOf(length));
        } else if (ldt != null) {
            column.setUse((short)1);
            column.setLogicalDatatype(ldt);
            if (!numeric) {
                column.setDataTypeSize(String.valueOf(length));
            }
        }
    }

    void inheritancePostProcessingNew(Object[] entities) {
        Entity root;
        int i;
        for (int i2 = 0; i2 < entities.length; ++i2) {
            Entity entity = (Entity)entities[i2];
            if (!entity.isHierarchicalEntityType() || !entity.shouldBeEngineered()) continue;
            List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
            for (XtdMapping mapping : list) {
                DesignObject obj = mapping.getObjectMappedTo(entity);
                if (obj == null || !(obj instanceof Table)) continue;
                Table table = (Table)obj;
                if (mapping.getInheritanceType() == 3 || 0 == mapping.getInheritanceType()) {
                    Entity hroot;
                    if (mapping.getInheritanceType() == 0) {
                        mapping.setInheritanceType(3);
                        mapping.setDirty(true);
                    }
                    if ((hroot = entity.getHierarchicalRoot()) != null) {
                        this.fwdEngineering.processPKAttributesw(hroot, table, mapping, 0);
                        this.fwdEngineering.processPrKey(hroot, table, mapping, entity);
                    }
                    this.processAttributes_Leaf_New(entity, table, mapping);
                    this.processKeys_Leaf_New(entity, table, mapping);
                    ArrayList not_engineered_entities = new ArrayList();
                    this.getEntities_Down_NotEngineer(entity, null, not_engineered_entities);
                    if (entity.isGenerateDiscriminatorColumn()) {
                        this.processDiscriminatorColumn(entity, table, not_engineered_entities);
                    } else {
                        Attribute engAttr;
                        Column col = table.getDiscriminatorColumn();
                        if (col != null && (engAttr = col.getEngAttribute(entity)) == null) {
                            col.remove();
                        }
                    }
                    for (Entity ch_ent : not_engineered_entities) {
                        XtdMapping par_mapping = ch_ent.getMappingFor(table, 1);
                        if (par_mapping == null) {
                            par_mapping = this.xmap.createMapping(ch_ent, table);
                            par_mapping.initializeContained();
                            par_mapping.setInheritanceType(1);
                        }
                        this.fwdEngineering.processAttributes(ch_ent, table, par_mapping);
                        this.fwdEngineering.processKeys(ch_ent, table, par_mapping);
                    }
                    Column discrColumn = table.getDiscriminatorColumn();
                    if (discrColumn == null) continue;
                    discrColumn.getDependentColumnDescriptors().clear();
                    Set values = discrColumn.getValues();
                    if (!entity.isCompleteSubtypes() && this.hasPathToLeafdWithNoEngineer(entity)) {
                        String discrVal = Entity.generateDiscriminatorValue(entity);
                        this.createExistenceDependncyDescriptors(entity, table, discrColumn, discrVal, true);
                    }
                    this.processDiscriminatorColumnConstraint(entity, null, table, discrColumn, values);
                    continue;
                }
                ContainedObject[] attrs = entity.getElements();
                for (int k = 0; k < attrs.length; ++k) {
                    Column col;
                    Attribute attr = (Attribute)attrs[k];
                    if (attr.isPKElement() || (col = attr.getEngColumn(this.pdes, table)) == null) continue;
                    col.remove();
                }
                KeyObject[] keys = entity.getKeys();
                for (int k = 0; k < keys.length; ++k) {
                    Index ind;
                    CandidateKey key = (CandidateKey)keys[k];
                    if (key.isPK() || (ind = key.getEngIndex(this.pdes, table)) == null) continue;
                    ind.remove();
                }
            }
        }
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (i = 0; i < entities.length; ++i) {
            root = (Entity)entities[i];
            Entity ent = root.getTopShouldEngineeredHierarchcalParent();
            if (ent == null || root == ent || list.contains(ent)) continue;
            list.add(ent);
        }
        for (i = 0; i < list.size(); ++i) {
            root = (Entity)list.get(i);
            if (!root.isHierarchicalEntityType()) continue;
            this.createFKeysNew(root);
        }
    }

    private void createFKeys(Entity root) {
        XtdMapping mapping;
        Table rootTable;
        List list = this.xmap.getMappingsForDesignPart(root, this.targetDesPartID);
        if (list.size() == 1 && (rootTable = (Table)(mapping = (XtdMapping)list.get(0)).getObjectMappedTo(root)) != null) {
            CandidateKey pkey = (CandidateKey)root.getPKorUnique();
            KeyObject key = null;
            if (pkey != null) {
                key = pkey.getEngIndex(this.pdes);
            }
            if (key == null && (key = rootTable.getPKorUnique()) == null) {
                key = this.createSurrogatePKandColumn(rootTable);
                if (pkey != null && key != null) {
                    XtdMapping pmapping = this.xmap.createMapping(pkey, key);
                    pmapping.setInheritanceType(3);
                    pmapping.setCreationTime(System.currentTimeMillis());
                }
            }
            int ch_count = root.getHierarchicalChildrenCount();
            for (int i = 0; i < ch_count; ++i) {
                Entity ent = root.getHierarchicalChild(i);
                this.createFKey(ent, pkey, key);
            }
        }
    }

    private void createFKeysNew(Entity entity) {
        Entity hroot = entity.getHierarchicalRoot();
        CandidateKey hpkey = null;
        if (hroot != null) {
            hpkey = (CandidateKey)hroot.getPK();
        }
        List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
        for (XtdMapping mapping : list) {
            FKIndexAssociation fk;
            Table table;
            if (mapping.getInheritanceType() != 3 || (table = (Table)mapping.getObjectMappedTo(entity)) == null) continue;
            if ("Identifying".equals(entity.getSubtypesRefType())) {
                this.processDiscriminatorColumn(entity, table, Collections.EMPTY_LIST);
                Column discrCol = table.getDiscriminatorColumn();
                Index key = null;
                boolean mappingExists = false;
                if (hpkey != null && (key = hpkey.getEngIndex(this.pdes, table)) != null) {
                    mappingExists = true;
                }
                if (key == null) {
                    key = table.getSurrogateKey();
                    if (key == null) {
                        key = this.createSurrogatePKandColumn(table, null, null);
                    }
                    if (hpkey != null && key != null && !mappingExists) {
                        XtdMapping pmapping = this.xmap.createMapping(hpkey, key);
                        pmapping.setInheritanceType(3);
                        pmapping.setCreationTime(System.currentTimeMillis());
                    }
                } else {
                    Index skey = table.getSurrogateKey();
                    if (skey != null) {
                        ContainedObject[] cols = skey.getColumns();
                        for (int i = 0; i < cols.length; ++i) {
                            ContainedObject col = cols[i];
                            if (!col.isSurrogateColumn()) continue;
                            col.remove();
                        }
                        skey.remove();
                    }
                }
                FKArc arc = null;
                ArrayList<FKIndexAssociation> fklist = new ArrayList<FKIndexAssociation>();
                List<Entity> ch_list = entity.getShouldEngineeredChildren();
                for (Entity child : ch_list) {
                    if (child == entity) continue;
                    fk = this.createFKeyHier(child, hpkey, key);
                    if (fk != null) {
                        fklist.add(fk);
                        if (arc == null && fk.getArc() != null && fk.getArc().isReverse()) {
                            arc = fk.getArc();
                        }
                        if (discrCol != null) {
                            fk.setDiscriminatorColumn(discrCol);
                            fk.setDiscriminatorValue(Entity.generateDiscriminatorValue(child));
                        }
                    }
                    this.createFKeysNew(child);
                }
                if (fklist.size() > 1) {
                    if (arc == null) {
                        arc = table.getRelationalModel().createArc(fklist.toArray());
                        arc.setReverse(true);
                    }
                    if (arc != null && discrCol != null) {
                        arc.setDiscriminatorColumn(discrCol);
                    }
                    arc.setMandatory(entity.isCompleteSubtypes());
                    for (FKIndexAssociation fkey : fklist) {
                        arc.addFkey(fkey);
                    }
                    continue;
                }
                if (arc == null) continue;
                arc.remove();
                continue;
            }
            if ("Arc implementation".equals(entity.getSubtypesRefType())) {
                ArrayList<FKIndexAssociation> fkeys = new ArrayList<FKIndexAssociation>();
                FKArc arc = null;
                List<Entity> ch_list = entity.getShouldEngineeredChildren();
                for (Entity child : ch_list) {
                    Table childTable = child.getEngTable(this.pdes, 3);
                    if (childTable == null) continue;
                    KeyObject key = null;
                    boolean mappingExists = false;
                    if (hpkey != null && (key = hpkey.getEngIndex(this.pdes, childTable)) != null) {
                        mappingExists = true;
                    }
                    if (key == null) {
                        key = childTable.getPKorUnique();
                        if (key == null) {
                            key = this.createSurrogatePKandColumn(childTable);
                        }
                        if (hpkey != null && key != null && !mappingExists) {
                            XtdMapping pmapping = this.xmap.createMapping(hpkey, key);
                            pmapping.setInheritanceType(3);
                            pmapping.setCreationTime(System.currentTimeMillis());
                        }
                    }
                    if ((fk = this.createFKeyForArc(entity, child, hpkey, key)) != null) {
                        fk.setMandatory(false);
                        fkeys.add(fk);
                        if (arc == null && fk.getArc() != null) {
                            arc = fk.getArc();
                        }
                    }
                    this.createFKeysNew(child);
                }
                if (fkeys.size() <= 1) continue;
                if (arc == null) {
                    arc = ((RelationalDesign)table.getDesignPart()).createArc();
                    table.addArc(arc);
                }
                arc.setMandatory(true);
                for (FKIndexAssociation fkey : fkeys) {
                    arc.addFkey(fkey);
                }
                continue;
            }
            if (!"None".equals(entity.getSubtypesRefType())) continue;
            List<Entity> ch_list = entity.getShouldEngineeredChildren();
            for (Entity child : ch_list) {
                this.createFKeysNew(child);
            }
        }
    }

    private Index createSurrogatePKandColumn(Table table) {
        Index index = table.createIndex();
        index.setPK(true);
        index.setSurrogateKey(true);
        Column col = table.createColumn();
        String colName = ApplyNamingStandards.createSurrogatePK_Column_Name(table.getName(), table.getDesign().getDesignLevelSettings().getNamingStandardRule(), table.getDesignPart().getName(), table);
        col.setName(colName);
        col.setMandatory(true);
        col.setSurrogateColumn(true);
        this.setSurrogateKeyDataType(col);
        String pkname = ApplyNamingStandards.createSurrogatePK_Name(table.getName(), table.getDesign().getDesignLevelSettings().getNamingStandardRule(), table.getDesignPart().getName(), table.getAbbreviation());
        index.setName(pkname);
        index.add(col);
        table.moveToIndex(col, 0);
        return index;
    }

    public Index createSurrogatePKandColumn(Table table, Index pk, Column fkCol) {
        Index realPK = (Index)table.getPK();
        Index index = pk;
        if (realPK != null && realPK.isPK() && realPK != index) {
            realPK.setIndexState("Unique Constraint");
            String ukname = ApplyNamingStandards.createUK_Name(realPK, 0, table.getDesign().getDesignLevelSettings().getNamingStandardRule(), table.getDesignPart().getName(), table.getName(), table.getAbbreviation());
            realPK.setName(ukname);
        }
        if (index == null) {
            index = table.createIndex();
        }
        index.setPK(true);
        index.setSurrogateKey(true);
        Column col = fkCol;
        if (col == null) {
            col = table.createColumn();
            String colName = ApplyNamingStandards.createSurrogatePK_Column_Name(table.getName(), table.getDesign().getDesignLevelSettings().getNamingStandardRule(), table.getDesignPart().getName(), table);
            col.setName(colName);
            col.setMandatory(true);
            this.setSurrogateKeyDataType(col);
            col.setAutoIncrementColumn(true);
            col.setIdentityColumn(true);
            col.setSurrogateColumn(true);
        }
        String pkname = ApplyNamingStandards.createSurrogatePK_Name(table.getName(), table.getDesign().getDesignLevelSettings().getNamingStandardRule(), table.getDesignPart().getName(), table.getAbbreviation());
        index.setName(pkname);
        index.add(col);
        table.moveToIndex(col, 0);
        return index;
    }

    private void setSurrogateKeyDataType(Column col) {
        Object obj = col.getAppView().getSettings().getSurrogateKeyDomain();
        if (obj != null && obj instanceof Domain) {
            Domain dom = (Domain)obj;
            col.setUse((short)0);
            col.setDomain(dom);
        } else {
            LogicalDatatype dt = (LogicalDatatype)col.getDesign().getLogicalDatatypeSet().getByName("Numeric", false);
            if (dt == null) {
                dt = col.getDesign().getLogicalDatatypeSet().getFirstNumberDataType();
            }
            if (dt != null) {
                col.setLogicalDatatype(dt);
                col.setUse((short)1);
                String prec = col.getAppView().getSettings().getSurrogateKeyLDTPrecision();
                if (!"".equals(prec.trim())) {
                    col.setDataTypePrecision(prec);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFKey(Entity ent, CandidateKey rootPK, KeyObject parentPK) {
        Table tab = ent.getEngTable(this.pdes, 3);
        if (tab != null) {
            InheritanceRelation inher = (InheritanceRelation)ent.getInheritanceRelation();
            List list = this.xmap.getMappingsForDesignPart(inher, this.targetDesPartID);
            if (list.size() == 0) {
                FKIndexAssociation fk = tab.getFKIndexAssociationFor(parentPK);
                if (fk == null) {
                    this.design.setPropagatePKChahges(true);
                    try {
                        fk = tab.addFK(parentPK, inher);
                    }
                    finally {
                        this.design.setPropagatePKChahges(false);
                    }
                }
                XtdMapping mapping = this.xmap.createMapping(inher, fk);
                mapping.setInheritanceType(4);
                mapping.setCreationTime(System.currentTimeMillis());
                for (Column column : fk.getLocalFKIndex().getElementsCollection()) {
                    Attribute attr;
                    FKElement delc = column.getDelegate();
                    if (delc == null || (attr = delc.getEngAttribute()) == null) continue;
                    Attribute orig = null;
                    if (attr.isFKAttribute()) {
                        orig = attr.getOriginatingAttribute();
                    }
                    mapping = orig != null ? this.xmap.createMapping(orig, column) : this.xmap.createMapping(attr, column);
                    mapping.setInheritanceType(5);
                }
            }
            if ((list = this.xmap.getMappingsForDesignPart(inher, this.targetDesPartID)).size() > 0) {
                XtdMapping mapping = (XtdMapping)list.get(0);
                FKIndexAssociation fk = tab.getFKIndexAssociationFor(parentPK);
                if (fk != null && fk == mapping.getObjectMappedTo(inher)) {
                    Index pkindex = this.synchronizeFKandSetPK(fk, (Index)parentPK, ent, rootPK);
                    int ch_count = ent.getHierarchicalChildrenCount();
                    for (int i = 0; i < ch_count; ++i) {
                        Entity ch_ent = ent.getHierarchicalChild(i);
                        CandidateKey pkey = (CandidateKey)ch_ent.getPK();
                        if (pkey != null) {
                            this.createFKey(ch_ent, pkey, pkindex);
                            continue;
                        }
                        this.createFKey(ch_ent, rootPK, pkindex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FKIndexAssociation createFKeyForArc(Entity parent, Entity child, CandidateKey rootPK, KeyObject parentPK) {
        FKIndexAssociation fk = null;
        Table tab = parent.getEngTable(this.pdes, 3);
        if (tab != null) {
            DesignObject obj;
            XtdMapping mapping2;
            InheritanceRelation inher = (InheritanceRelation)child.getInheritanceRelation();
            List list0 = this.xmap.getMappingsForDesignPart(inher, this.targetDesPartID);
            ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
            for (XtdMapping mapping2 : list0) {
                if (mapping2.getInheritanceType() == 6) {
                    list.add(mapping2);
                    continue;
                }
                obj = mapping2.getObjectMappedTo(inher);
                if (!(obj instanceof FKIndexAssociation)) continue;
                fk = (FKIndexAssociation)obj;
                fk.remove();
            }
            if (list.size() == 0) {
                fk = tab.getFKIndexAssociationFor(parentPK);
                if (fk == null) {
                    this.design.setPropagatePKChahges(true);
                    try {
                        fk = tab.addFK(parentPK, inher);
                        String fk_name = tab.getDesign().transformNameFromLogicalToRelational(inher, fk, tab);
                        fk.setName(fk_name);
                    }
                    finally {
                        this.design.setPropagatePKChahges(false);
                    }
                }
                mapping2 = this.xmap.createMapping(inher, fk);
                mapping2.setInheritanceType(6);
                mapping2.setCreationTime(System.currentTimeMillis());
                for (Column column : fk.getLocalFKIndex().getElementsCollection()) {
                    Attribute attr;
                    FKElement delc = column.getDelegate();
                    if (delc == null || (attr = delc.getEngAttribute()) == null) continue;
                    Attribute orig = null;
                    if (attr.isFKAttribute()) {
                        orig = attr.getOriginatingAttribute();
                    }
                    mapping2 = orig != null ? this.xmap.createMapping(orig, column) : this.xmap.createMapping(attr, column);
                    mapping2.setInheritanceType(7);
                    mapping2.setCreationTime(System.currentTimeMillis());
                }
            } else {
                mapping2 = (XtdMapping)list.get(0);
                obj = mapping2.getObjectMappedTo(inher);
                if (obj instanceof FKIndexAssociation) {
                    fk = (FKIndexAssociation)obj;
                }
            }
        }
        return fk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FKIndexAssociation createFKeyHier(Entity ent, CandidateKey hrootPK, KeyObject parentPK) {
        FKIndexAssociation fk = null;
        Table parentTable = (Table)parentPK.getContainerWithKeyObject();
        Table tab = ent.getEngTable(this.pdes, 3);
        if (tab != null) {
            XtdMapping mapping;
            DesignObject obj;
            InheritanceRelation inher = (InheritanceRelation)ent.getInheritanceRelation();
            if (inher == null) {
                return null;
            }
            List list = this.xmap.getMappingsForDesignPart(inher, this.targetDesPartID);
            if (list.size() == 0) {
                if (fk == null) {
                    this.design.setPropagatePKChahges(hrootPK == null);
                    try {
                        fk = tab.addFK(parentPK, inher);
                        String fk_name = tab.getDesign().transformNameFromLogicalToRelational(inher, fk, tab);
                        fk.setName(fk_name);
                    }
                    finally {
                        this.design.setPropagatePKChahges(false);
                    }
                }
                XtdMapping mapping2 = this.xmap.createMapping(inher, fk);
                mapping2.setInheritanceType(4);
                mapping2.setCreationTime(System.currentTimeMillis());
                if (hrootPK != null) {
                    for (Attribute attr : hrootPK.getElementsCollection()) {
                        Column col = attr.getEngColumn(this.pdes, tab);
                        Column delegate = attr.getEngColumn(this.pdes, parentTable);
                        if (col == null || fk.getLocalFKIndex().contains(col) || delegate == null) continue;
                        fk.getLocalFKIndex().add(col);
                        col.addFKAssociation(delegate, fk);
                        col.getParameters().clear();
                    }
                } else {
                    Column[] columns = (Column[])fk.getColumns();
                    if (columns.length == 1) {
                        this.createSurrogatePKandColumn(tab, null, columns[0]);
                    }
                }
            } else if (list.size() == 1 && (obj = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(inher)) instanceof FKIndexAssociation) {
                fk = (FKIndexAssociation)obj;
            }
            list = this.xmap.getMappingsForDesignPart(inher, this.targetDesPartID);
        }
        return fk;
    }

    private Index synchronizeFKandSetPK(FKIndexAssociation fk, Index pk, Entity engEnt, CandidateKey rootPK) {
        Table tab = (Table)fk.getContainerWithKeyObject();
        fk.synchronizeFKColumns();
        CandidateKey ent_pk = (CandidateKey)engEnt.getPK();
        Index pkey = null;
        if (ent_pk != null) {
            pkey = ent_pk.getEngIndex(this.pdes);
        } else if (rootPK != null) {
            pkey = rootPK.getEngIndex(this.pdes, tab);
        }
        if (pkey != null) {
            for (Column col : fk.getLocalFKIndex().getElementsCollection()) {
                if (pkey.contains(col)) continue;
                pkey.add(col);
            }
            return pkey;
        }
        pkey = (Index)tab.getPK();
        if (pkey == null) {
            pkey = tab.createIndex();
            pkey.setPK(true);
            String pkname = ApplyNamingStandards.createPK_Name(tab.getName(), tab.getDesign().getDesignLevelSettings().getNamingStandardRule(), tab.getDesignPart().getName(), tab.getAbbreviation());
            pkey.setName(pkname);
            pkey.getElementsCollection().addAll(fk.getLocalFKIndex().getElementsCollection());
            if (rootPK != null && pkey != null) {
                XtdMapping mapping = this.xmap.createMapping(rootPK, pkey);
                mapping.setInheritanceType(3);
                mapping.setCreationTime(System.currentTimeMillis());
            }
        } else {
            for (Column col : fk.getLocalFKIndex().getElementsCollection()) {
                if (pkey.contains(col)) continue;
                pkey.add(col);
            }
        }
        return pkey;
    }

    private void processAttributes_Single(Entity entity, Table table, XtdMapping mapping) {
        this.fwdEngineering.processAttributes(entity, table, mapping);
        if (entity.isHierarchicalEntityType()) {
            int count = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < count; ++i) {
                Entity ch_ent = entity.getHierarchicalChild(i);
                XtdMapping ch_mapping = ch_ent.getMappingFor(table);
                if (ch_mapping != null) {
                    this.processAttributes_Single(ch_ent, table, ch_mapping);
                    continue;
                }
                XtdMapping new_mapping = this.xmap.createMapping(ch_ent, table);
                new_mapping.initializeContained();
                new_mapping.setInheritanceType(1);
                this.processAttributes_Single(ch_ent, table, new_mapping);
            }
        }
    }

    private void getEntities_Down_NotEngineer(Entity root, Entity current, List list) {
        if (current == null) {
            current = root;
        }
        if (current.isHierarchicalEntityType()) {
            int count = current.getHierarchicalChildrenCount();
            for (int i = 0; i < count; ++i) {
                Entity ch_ent = current.getHierarchicalChild(i);
                if (ch_ent.shouldBeEngineered()) continue;
                if (ch_ent.hasHierarchicalChildren()) {
                    this.getEntities_Down_NotEngineer(root, ch_ent, list);
                    continue;
                }
                Entity temp = ch_ent;
                do {
                    if (list.contains(temp)) continue;
                    list.add(0, temp);
                } while ((temp = temp.getHierarchicalParent()) != null && root != temp);
            }
        }
    }

    private void processDiscriminatorColumnConstraint(Entity root, Entity current, Table table, Column discrColumn, Set dvalues) {
        if (discrColumn != null) {
            if (current == null) {
                current = root;
            }
            if (current.isHierarchicalEntityType()) {
                int count = current.getHierarchicalChildrenCount();
                for (int i = 0; i < count; ++i) {
                    Entity temp;
                    Entity ch_ent = current.getHierarchicalChild(i);
                    if (ch_ent.shouldBeEngineered()) continue;
                    String discrVal = Entity.generateDiscriminatorValue(ch_ent);
                    if (ch_ent.hasHierarchicalChildren()) {
                        if (!ch_ent.isCompleteSubtypes() && this.hasPathToLeafdWithNoEngineer(ch_ent)) {
                            temp = ch_ent;
                            do {
                                if (temp == root && temp.isCompleteSubtypes()) continue;
                                this.createExistenceDependncyDescriptors(temp, table, discrColumn, discrVal, temp == root);
                            } while ((temp = temp.getHierarchicalParent()) != null);
                        }
                        this.processDiscriminatorColumnConstraint(root, ch_ent, table, discrColumn, dvalues);
                        continue;
                    }
                    temp = ch_ent;
                    do {
                        if (temp == root && temp.isCompleteSubtypes()) continue;
                        this.createExistenceDependncyDescriptors(temp, table, discrColumn, discrVal, temp == root);
                    } while ((temp = temp.getHierarchicalParent()) != null);
                }
            }
        }
    }

    private void createExistenceDependncyDescriptors(Entity ent, Table table, Column discrColumn, String discrValue, boolean optionalOnly) {
        Map dependentColumnsMap = null;
        for (Attribute attr : ent.getElementsCollection()) {
            Column.DependentColumnDescriptor desc;
            Column column = attr.getEngColumn(this.pdes, table);
            if (column == null || optionalOnly && column.isMandatory()) continue;
            if (dependentColumnsMap == null) {
                dependentColumnsMap = discrColumn.getDependentColumnDescriptorsMap(discrValue);
            }
            if ((desc = (Column.DependentColumnDescriptor)dependentColumnsMap.get(column.getObjectID())) == null) {
                desc = discrColumn.createDependentColumnDescriptor();
                desc.setColumnID(column.getObjectID());
                desc.setDiscriminatorValue(discrValue);
                discrColumn.addDependentColumnDescriptor(desc);
                dependentColumnsMap.put(column.getObjectID(), desc);
            }
            if (attr.isMandatory()) {
                desc.setDependAsMandatory(true);
                continue;
            }
            desc.setDependAsMandatory(false);
            desc.setDependOnValue(true);
        }
    }

    public static void getEntities_Down_FirstEngineer(Entity current, List list) {
        if (current.isHierarchicalEntityType()) {
            int count = current.getHierarchicalChildrenCount();
            for (int i = 0; i < count; ++i) {
                Entity ch_ent = current.getHierarchicalChild(i);
                if (!ch_ent.shouldBeEngineered()) {
                    if (!ch_ent.hasHierarchicalChildren()) continue;
                    FEEntityHierarchy.getEntities_Down_FirstEngineer(ch_ent, list);
                    continue;
                }
                if (list.contains(ch_ent)) continue;
                list.add(ch_ent);
            }
        }
    }

    public static Entity getParentFirstEngineer(Entity ent) {
        Entity parent;
        if (ent.isHierarchicalEntityType() && (parent = ent.getHierarchicalParent()) != null) {
            if (parent.shouldBeEngineered()) {
                return parent;
            }
            return FEEntityHierarchy.getParentFirstEngineer(parent);
        }
        return null;
    }

    private void processAttributes_Leaf(Entity entity, Table table, XtdMapping mapping) {
        Entity par_ent;
        if (entity.isHierarchicalEntityType() && (par_ent = entity.getHierarchicalParent()) != null) {
            XtdMapping par_mapping = par_ent.getMappingFor(table);
            if (par_mapping != null) {
                this.processAttributes_Leaf(par_ent, table, par_mapping);
            } else {
                XtdMapping new_mapping = this.xmap.createMapping(par_ent, table);
                new_mapping.initializeContained();
                new_mapping.setInheritanceType(2);
                this.processAttributes_Leaf(par_ent, table, new_mapping);
            }
        }
        this.fwdEngineering.processAttributes(entity, table, mapping);
    }

    private void processAttributes_Leaf_New(Entity entity, Table table, XtdMapping mapping) {
        Entity par_ent;
        if (entity.isHierarchicalEntityType() && (par_ent = entity.getHierarchicalParent()) != null && (!par_ent.shouldBeEngineered() || "All atributes".equals(par_ent.getAttributeInherType()))) {
            XtdMapping par_mapping = par_ent.getMappingFor(table, 2);
            if (par_mapping != null) {
                this.processAttributes_Leaf_New(par_ent, table, par_mapping);
            } else {
                XtdMapping new_mapping = this.xmap.createMapping(par_ent, table);
                new_mapping.initializeContained();
                new_mapping.setInheritanceType(2);
                this.processAttributes_Leaf_New(par_ent, table, new_mapping);
            }
        }
        this.fwdEngineering.processAttributes(entity, table, mapping);
    }

    private void processKeys_Leaf(Entity entity, Table table, XtdMapping mapping) {
        XtdMapping par_mapping;
        Entity par_ent;
        this.fwdEngineering.processKeys(entity, table, mapping);
        if (entity.isHierarchicalEntityType() && (par_ent = entity.getHierarchicalParent()) != null && (par_mapping = par_ent.getMappingFor(table)) != null) {
            this.processKeys_Leaf(par_ent, table, par_mapping);
        }
    }

    private void processKeys_Leaf_New(Entity entity, Table table, XtdMapping mapping) {
        XtdMapping par_mapping;
        Entity par_ent;
        this.fwdEngineering.processKeys(entity, table, mapping);
        if (entity.isHierarchicalEntityType() && (par_ent = entity.getHierarchicalParent()) != null && (!par_ent.shouldBeEngineered() || "All atributes".equals(par_ent.getAttributeInherType())) && (par_mapping = par_ent.getMappingFor(table)) != null) {
            this.processKeys_Leaf_New(par_ent, table, par_mapping);
        }
        this.fwdEngineering.processKeys(entity, table, mapping);
    }

    private List getRelationMappingsFor(List mappings, Entity realSourceEntity, Entity realTargetEntity) {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : mappings) {
            if (!realSourceEntity.getObjectID().equals(mapping.getRealSourceEntityID()) || !realTargetEntity.getObjectID().equals(mapping.getRealTargetEntityID())) continue;
            list.add(mapping);
        }
        if (list.size() == 0) {
            for (XtdMapping mapping : mappings) {
                if (mapping.getRealSourceEntityID() != null || mapping.getRealTargetEntityID() != null) continue;
                list.add(mapping);
            }
        } else {
            return list;
        }
        if (list.size() != mappings.size()) {
            list.clear();
        }
        return list;
    }

    void processRelation(Relation relation) {
        ArrayList<Entity> seList = new ArrayList<Entity>();
        ArrayList<Entity> teList = new ArrayList<Entity>();
        Entity sEntity = relation.getSourceEntity();
        Entity tEntity = relation.getTargetEntity();
        int s_inh_type = 0;
        int t_inh_type = 0;
        int inh_type = 0;
        if (sEntity.isHierarchicalEntityType()) {
            if ("Table per child".equals(sEntity.getFwdEngineeringStrategyName())) {
                seList.addAll(sEntity.getHierarchicalLeaves());
                s_inh_type = 2;
            } else if ("Single Table".equals(sEntity.getFwdEngineeringStrategyName())) {
                seList.add(sEntity.getHierarchicalRoot());
                s_inh_type = 1;
            } else if ("Table for each entity".equals(sEntity.getFwdEngineeringStrategyName())) {
                seList.add(sEntity);
                s_inh_type = 3;
            }
        } else {
            seList.add(sEntity);
        }
        if (tEntity.isHierarchicalEntityType()) {
            if ("Table per child".equals(tEntity.getFwdEngineeringStrategyName())) {
                teList.addAll(tEntity.getHierarchicalLeaves());
                t_inh_type = 2;
            } else if ("Single Table".equals(tEntity.getFwdEngineeringStrategyName())) {
                teList.add(tEntity.getHierarchicalRoot());
                t_inh_type = 1;
            } else if ("Table for each entity".equals(tEntity.getFwdEngineeringStrategyName())) {
                teList.add(tEntity);
                t_inh_type = 3;
            }
        } else {
            teList.add(tEntity);
        }
        inh_type = s_inh_type != 0 ? s_inh_type : t_inh_type;
        List inlist = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
        this.clearPreviousIntermediateTables(relation, inlist, seList, teList);
        for (int i = 0; i < seList.size(); ++i) {
            Entity realSourceEntity = (Entity)seList.get(i);
            for (int j = 0; j < teList.size(); ++j) {
                Entity realTargetEntity = (Entity)teList.get(j);
                if (relation.isManyToMany()) {
                    this.processRelationManyToMany(relation, realSourceEntity, realTargetEntity, inh_type);
                }
                if (sEntity == tEntity) {
                    this.processRelation(relation, realSourceEntity, realSourceEntity, inh_type);
                    continue;
                }
                this.processRelation(relation, realSourceEntity, realTargetEntity, inh_type);
            }
        }
    }

    void processRelationNew(Relation relation) {
        int i;
        Entity parent;
        ArrayList list;
        Object[] old_fkeys = relation.getEngForeignKeys(this.pdes).toArray();
        ArrayList<Entity> seList = new ArrayList<Entity>();
        ArrayList<Entity> teList = new ArrayList<Entity>();
        Entity sEntity = relation.getSourceEntity();
        Entity tEntity = relation.getTargetEntity();
        int s_inh_type = 0;
        int t_inh_type = 0;
        int inh_type = 0;
        if (sEntity.isHierarchicalEntityType()) {
            if (sEntity.shouldBeEngineered()) {
                seList.add(sEntity);
                s_inh_type = 3;
            } else {
                list = new ArrayList();
                FEEntityHierarchy.getEntities_Down_FirstEngineer(sEntity, list);
                if (list.size() > 0) {
                    seList.addAll(list);
                    s_inh_type = 2;
                } else {
                    parent = FEEntityHierarchy.getParentFirstEngineer(sEntity);
                    if (parent != null) {
                        s_inh_type = 1;
                        seList.add(parent);
                    }
                }
            }
        } else {
            seList.add(sEntity);
        }
        if (tEntity.isHierarchicalEntityType()) {
            if (tEntity.shouldBeEngineered()) {
                teList.add(tEntity);
                t_inh_type = 3;
            } else {
                list = new ArrayList();
                FEEntityHierarchy.getEntities_Down_FirstEngineer(tEntity, list);
                if (list.size() > 0) {
                    teList.addAll(list);
                    t_inh_type = 2;
                } else {
                    parent = FEEntityHierarchy.getParentFirstEngineer(tEntity);
                    if (parent != null) {
                        t_inh_type = 1;
                        teList.add(parent);
                    }
                }
            }
        } else {
            teList.add(tEntity);
        }
        inh_type = s_inh_type != 0 ? s_inh_type : t_inh_type;
        ArrayList fkeys = new ArrayList();
        List inlist = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
        this.clearPreviousIntermediateTables(relation, inlist, seList, teList);
        this.clearPreviousInherFKeys(relation, inlist, seList, teList);
        for (i = 0; i < seList.size(); ++i) {
            Entity realSourceEntity = (Entity)seList.get(i);
            for (int j = 0; j < teList.size(); ++j) {
                Entity realTargetEntity = (Entity)teList.get(j);
                List list2 = null;
                if (relation.isManyToMany()) {
                    this.processRelationManyToMany(relation, realSourceEntity, realTargetEntity, inh_type);
                }
                if ((list2 = sEntity == tEntity ? this.processRelation(relation, realSourceEntity, realSourceEntity, inh_type) : this.processRelation(relation, realSourceEntity, realTargetEntity, inh_type)) == null) continue;
                for (Object obj : list2) {
                    if (fkeys.contains(obj)) continue;
                    fkeys.add(obj);
                }
            }
        }
        for (i = 0; i < old_fkeys.length; ++i) {
            FKIndexAssociation fk = (FKIndexAssociation)old_fkeys[i];
            if (fkeys.contains(fk)) continue;
            fk.remove();
        }
        if (s_inh_type != 0 || t_inh_type != 0) {
            HashMap<FKContainer, ArrayList<FKIndexAssociation>> map = new HashMap<FKContainer, ArrayList<FKIndexAssociation>>();
            for (FKIndexAssociation fk : fkeys) {
                ArrayList<FKIndexAssociation> list3 = (ArrayList<FKIndexAssociation>)map.get(fk.getTable());
                if (list3 == null) {
                    list3 = new ArrayList<FKIndexAssociation>();
                    map.put(fk.getTable(), list3);
                }
                list3.add(fk);
            }
            for (Table table : map.keySet()) {
                Entity ent = table.getEngEntity();
                boolean optional = false;
                boolean inarc = false;
                boolean gen_check = false;
                if (seList.contains(ent)) {
                    if (s_inh_type == 1) {
                        optional = true;
                        gen_check = true;
                    }
                    if (t_inh_type == 2) {
                        inarc = true;
                    }
                }
                if (teList.contains(ent)) {
                    if (t_inh_type == 1) {
                        optional = true;
                        gen_check = true;
                    }
                    if (s_inh_type == 2) {
                        inarc = true;
                    }
                }
                List list4 = (List)map.get(table);
                FKArc arc = null;
                if (list4 == null) continue;
                for (FKIndexAssociation fk : list4) {
                    if ((inarc || optional) && fk.isMandatory()) {
                        fk.setMandatory(false);
                        fk.setDirty(true);
                    }
                    if (!inarc || arc != null || fk.getArc() == null || fk.getArc().getTable() != table) continue;
                    arc = fk.getArc();
                }
                if (!inarc || list4.size() <= 1) continue;
                if (arc == null) {
                    arc = ((RelationalDesign)table.getDesignPart()).createArc();
                    table.addArc(arc);
                }
                arc.setMandatory(true);
                for (FKIndexAssociation fkey : list4) {
                    arc.addFkey(fkey);
                }
            }
        }
    }

    private void clearPreviousIntermediateTables(Relation relation, List mappings, List sList, List tList) {
        for (XtdMapping mapping : mappings) {
            DesignObject dobj = mapping.getObjectMappedTo(relation);
            if (dobj == null || 0 == mapping.getInheritanceType() || this.containsDesObject(sList, mapping.getRealSourceEntityID()) && this.containsDesObject(tList, mapping.getRealTargetEntityID()) || !this.fwdEngineering.shouldDelete(dobj) || !(dobj instanceof Table)) continue;
            dobj.remove();
            this.xmap.removeMapping(mapping);
        }
    }

    private void clearPreviousInherFKeys(Relation relation, List mappings, List sList, List tList) {
        for (XtdMapping mapping : mappings) {
            DesignObject dobj = mapping.getObjectMappedTo(relation);
            if (dobj == null || !(dobj instanceof FKIndexAssociation)) continue;
            FKIndexAssociation fk = (FKIndexAssociation)dobj;
            Table sTab = (Table)fk.getRemoteTable();
            Table tTab = (Table)fk.getTable();
            if (sTab != null && tTab != null) {
                Entity sEnt = sTab.getEngEntity();
                Entity tEnt = tTab.getEngEntity();
                if (!(sEnt == null || tEnt == null || 0 == mapping.getInheritanceType() || sList.contains(sEnt) && tList.contains(tEnt) || !this.fwdEngineering.shouldDelete(dobj))) {
                    dobj.remove();
                    this.xmap.removeMapping(mapping);
                }
            }
            if (0 == mapping.getInheritanceType() || this.containsDesObject(sList, mapping.getRealSourceEntityID()) && this.containsDesObject(tList, mapping.getRealTargetEntityID()) || !this.fwdEngineering.shouldDelete(dobj)) continue;
            dobj.remove();
            this.xmap.removeMapping(mapping);
        }
    }

    private boolean containsDesObject(List list, String id) {
        for (DesignObject dobj : list) {
            if (!dobj.getObjectID().equals(id)) continue;
            return true;
        }
        return false;
    }

    private void removeDeletedMapping(Relation alive, DesignObject deleted) {
        XtdMapping d_mapping = alive.getDeletedMapping(deleted.getDesignPartId(), deleted.getObjectID());
        if (d_mapping != null) {
            this.xmap.removeMapping(d_mapping);
        }
    }

    private void copyPropertiesFromRelationToTable(Relation relation, Table table) {
        table.setTemporaryWriteable(true);
        table.setComment(relation.getComment());
        table.setNotes(relation.getNotes());
        table.setCommentInRDBMS(relation.getCommentInRDBMS());
        table.setTemporaryWriteable(false);
    }

    private List getMatched(Relation relation, List relationMappings, Entity entity, List entityMappings) {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : relationMappings) {
            DesignObject obj = mapping.getObjectMappedTo(relation);
            if (obj == null || !(obj instanceof FKIndexAssociation)) continue;
            FKIndexAssociation fk = (FKIndexAssociation)obj;
            for (XtdMapping emapping : entityMappings) {
                DesignObject obj2 = emapping.getObjectMappedTo(entity);
                if (obj2 == null || !(obj2 instanceof Table) || obj2 != fk.getRemoteTable() && obj2 != fk.getContainerWithKeyObject()) continue;
                list.add(emapping);
            }
        }
        return list;
    }

    private List getMatchedNew(Relation relation, List relationMappings, Entity entity, List entityMappings) {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : relationMappings) {
            DesignObject obj = mapping.getObjectMappedTo(relation);
            if (obj == null || !(obj instanceof FKIndexAssociation)) continue;
            FKIndexAssociation fk = (FKIndexAssociation)obj;
            for (XtdMapping emapping : entityMappings) {
                DesignObject obj2 = emapping.getObjectMappedTo(entity);
                if (obj2 == null || !(obj2 instanceof Table) || obj2 != fk.getRemoteTable() && obj2 != fk.getContainerWithKeyObject()) continue;
                list.add(emapping);
            }
        }
        return list;
    }

    private List getMappingsForTables(Relation relation, List relationMappings, Table sourceTable, Table targetTable) {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : relationMappings) {
            FKIndexAssociation fk;
            DesignObject obj = mapping.getObjectMappedTo(relation);
            if (obj == null || !(obj instanceof FKIndexAssociation) || ((fk = (FKIndexAssociation)obj).getContainerWithKeyObject() != sourceTable || fk.getRemoteTable() != targetTable) && (fk.getContainerWithKeyObject() != targetTable || fk.getRemoteTable() != sourceTable)) continue;
            list.add(mapping);
        }
        return list;
    }

    private List processRelation(Relation relation, Entity realSourceEntity, Entity realTargetEntity, int inh_type) {
        ArrayList<FKIndexAssociation> result = new ArrayList<FKIndexAssociation>();
        List inlist = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
        Entity sourceEntity = relation.getSourceEntity();
        Entity targetEntity = relation.getTargetEntity();
        List elist = this.getRelationMappingsFor(inlist, realSourceEntity, realTargetEntity);
        Table sourceTable = null;
        Table targetTable = null;
        List aslist = realSourceEntity.getEngTables(this.pdes, 3);
        List atlist = realTargetEntity.getEngTables(this.pdes, 3);
        List slist = null;
        List tlist = null;
        if (elist.size() > 0) {
            slist = this.getMatched(relation, elist, realSourceEntity, aslist);
            tlist = this.getMatched(relation, elist, realTargetEntity, atlist);
            for (Object ob : aslist) {
                if (slist.contains(ob)) continue;
                slist.add(ob);
            }
            for (Object ob : atlist) {
                if (tlist.contains(ob)) continue;
                tlist.add(ob);
            }
        } else {
            slist = aslist;
            tlist = atlist;
        }
        for (int is = 0; is < slist.size(); ++is) {
            XtdMapping smapping = (XtdMapping)slist.get(is);
            sourceTable = (Table)smapping.getObjectMappedTo(realSourceEntity);
            for (int jt = 0; jt < tlist.size(); ++jt) {
                XtdMapping tmapping = (XtdMapping)tlist.get(jt);
                targetTable = (Table)tmapping.getObjectMappedTo(realTargetEntity);
                if (sourceTable != null && targetTable != null) {
                    Table pktab;
                    Entity ent;
                    DesignObject dobj;
                    XtdMapping mapping;
                    DesignObject dobj2;
                    int[] pkEndPoints = relation.getPKProviderEndPoint();
                    List list = this.getMappingsForTables(relation, elist, sourceTable, targetTable);
                    if (list.size() == 1 && (dobj2 = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(relation)) != null && dobj2 instanceof Table) {
                        dobj2.remove();
                        this.removeDeletedMapping(relation, dobj2);
                        list.clear();
                    }
                    if (list.size() > 0 && pkEndPoints.length == 0) {
                        ArrayList copy = new ArrayList(list);
                        for (XtdMapping mapping2 : copy) {
                            dobj = mapping2.getObjectMappedTo(relation);
                            if (dobj == null || !this.fwdEngineering.shouldDelete(dobj)) continue;
                            List indexes = null;
                            if (dobj instanceof FKIndexAssociation) {
                                ((FKIndexAssociation)dobj).setSilentRemove(true);
                                Table tab = (Table)((FKIndexAssociation)dobj).getTable();
                                indexes = tab.getIndexesWithRelationGeneratorID(relation.getObjectID());
                            }
                            dobj.remove();
                            this.removeDeletedMapping(relation, dobj);
                            list.remove(dobj);
                            this.checkAndRemoveIndexes(indexes);
                        }
                    } else if (list.size() == 2 && pkEndPoints.length == 1) {
                        ent = relation.getEntity(pkEndPoints[0]);
                        pktab = null;
                        if (ent == sourceEntity) {
                            pktab = sourceTable;
                        } else if (ent == targetEntity) {
                            pktab = targetTable;
                        }
                        for (int i = 0; i < list.size(); ++i) {
                            FKIndexAssociation fk;
                            Table pkTable;
                            XtdMapping mapping3 = (XtdMapping)list.get(i);
                            DesignObject dobj3 = mapping3.getObjectMappedTo(relation);
                            if (dobj3 == null || !(dobj3 instanceof FKIndexAssociation) || (pkTable = (Table)(fk = (FKIndexAssociation)dobj3).getRemoteTable()) == pktab) continue;
                            if (this.fwdEngineering.shouldDelete(fk)) {
                                List indexes = null;
                                fk.setSilentRemove(true);
                                Table tab = (Table)((FKIndexAssociation)dobj3).getTable();
                                indexes = tab.getIndexesWithRelationGeneratorID(relation.getObjectID());
                                fk.remove();
                                this.removeDeletedMapping(relation, fk);
                                this.checkAndRemoveIndexes(indexes);
                                continue;
                            }
                            result.add(fk);
                        }
                    } else if (list.size() == 1 && pkEndPoints.length == 2) {
                        mapping = (XtdMapping)list.get(0);
                        dobj2 = mapping.getObjectMappedTo(relation);
                        if (dobj2 != null && dobj2 instanceof FKIndexAssociation) {
                            FKIndexAssociation fk = (FKIndexAssociation)dobj2;
                            result.add(fk);
                            Table pkTable = (Table)fk.getRemoteTable();
                            for (int i = 0; i < pkEndPoints.length; ++i) {
                                Entity ent2 = relation.getEntity(pkEndPoints[i]);
                                Table pktab2 = null;
                                if (ent2 == sourceEntity) {
                                    pktab2 = sourceTable;
                                } else if (ent2 == targetEntity) {
                                    pktab2 = targetTable;
                                }
                                if (pkTable == pktab2) continue;
                                FKIndexAssociation fkass = this.createFK(relation, sourceEntity, targetEntity, sourceTable, targetTable, realSourceEntity, realTargetEntity, pkEndPoints[i], inh_type);
                                if (fkass != null) {
                                    result.add(fkass);
                                }
                                break;
                            }
                        }
                    } else if (list.size() == 1 && pkEndPoints.length == 1) {
                        ent = relation.getEntity(pkEndPoints[0]);
                        pktab = null;
                        if (ent == sourceEntity) {
                            pktab = sourceTable;
                        } else if (ent == targetEntity) {
                            pktab = targetTable;
                        }
                        XtdMapping mapping4 = (XtdMapping)list.get(0);
                        dobj = mapping4.getObjectMappedTo(relation);
                        if (dobj != null && dobj instanceof FKIndexAssociation) {
                            FKIndexAssociation fk = (FKIndexAssociation)dobj;
                            Table pkTable = (Table)fk.getRemoteTable();
                            if (pkTable != pktab) {
                                if (this.fwdEngineering.shouldDelete(fk)) {
                                    List indexes = null;
                                    fk.setSilentRemove(true);
                                    Table tab = (Table)((FKIndexAssociation)dobj).getTable();
                                    indexes = tab.getIndexesWithRelationGeneratorID(relation.getObjectID());
                                    fk.remove();
                                    this.removeDeletedMapping(relation, fk);
                                    this.checkAndRemoveIndexes(indexes);
                                }
                            } else {
                                result.add(fk);
                            }
                        }
                    }
                    if (list.size() == 0) {
                        for (int i = 0; i < pkEndPoints.length; ++i) {
                            FKIndexAssociation fkass = this.createFK(relation, sourceEntity, targetEntity, sourceTable, targetTable, realSourceEntity, realTargetEntity, pkEndPoints[i], inh_type);
                            if (fkass == null) continue;
                            result.add(fkass);
                        }
                    }
                    for (XtdMapping mapping5 : list) {
                        DesignObject dobj4 = mapping5.getObjectMappedTo(relation);
                        if (dobj4 == null) continue;
                        EngPropertiesComparator comp = (EngPropertiesComparator)this.comparatorsMap.get(relation.getObjectID() + dobj4.getObjectID());
                        RelationFKComparator rel_comp = null;
                        boolean mandatoryDefined = false;
                        if (comp != null) {
                            comp.copySelectedProperties();
                            if (comp instanceof RelationFKComparator && (rel_comp = (RelationFKComparator)comp) != null && rel_comp.isMandatoryDefined()) {
                                mandatoryDefined = true;
                            }
                        }
                        if (relation.isManyToMany()) continue;
                        for (int i = 0; i < pkEndPoints.length; ++i) {
                            this.synchronizeFKColumns(mapping5, relation, sourceEntity, targetEntity, sourceTable, targetTable, pkEndPoints[i], mandatoryDefined);
                        }
                    }
                }
                if (targetTable == null) continue;
                List indexes = targetTable.getIndexesWithRelationGeneratorID(relation.getObjectID());
                this.checkAndRemoveIndexes(indexes);
            }
            if (sourceTable == null) continue;
            List indexes = sourceTable.getIndexesWithRelationGeneratorID(relation.getObjectID());
            this.checkAndRemoveIndexes(indexes);
        }
        return result;
    }

    private void checkAndRemoveIndexes(List indexes) {
        if (indexes != null) {
            for (Index ind : indexes) {
                if (ind.getElementsCollection().size() != 0) continue;
                ind.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRelationManyToMany(Relation relation, Entity realSourceEntity, Entity realTargetEntity, int inh_type) {
        List inlist = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
        List list = this.getRelationMappingsFor(inlist, realSourceEntity, realTargetEntity);
        Table sourceTable = realSourceEntity.getEngTable(this.pdes);
        Table targetTable = realTargetEntity.getEngTable(this.pdes);
        if (sourceTable != null && targetTable != null && relation.isManyToMany()) {
            if (list.size() > 1) {
                for (XtdMapping mapping : list) {
                    DesignObject dobj = mapping.getObjectMappedTo(relation);
                    if (dobj == null || !this.fwdEngineering.shouldDelete(dobj)) continue;
                    dobj.remove();
                    this.removeDeletedMapping(relation, dobj);
                }
                list.clear();
            } else if (list.size() == 1) {
                XtdMapping mapping = (XtdMapping)list.get(0);
                DesignObject dobj = mapping.getObjectMappedTo(relation);
                if (dobj != null && !(dobj instanceof Table)) {
                    if (this.fwdEngineering.shouldDelete(dobj)) {
                        dobj.remove();
                        this.removeDeletedMapping(relation, dobj);
                    }
                    list.clear();
                } else if (dobj != null && dobj instanceof Table) {
                    EngPropertiesComparator comp;
                    Table intermediate = (Table)dobj;
                    this.synchronizeFK(sourceTable, targetTable, intermediate, relation);
                    if (intermediate != null && (comp = (EngPropertiesComparator)this.comparatorsMap.get(relation.getObjectID() + intermediate.getObjectID())) != null) {
                        comp.copySelectedProperties();
                    }
                }
            }
            if (list.size() == 0) {
                this.design.setPropagatePKChahges(true);
                try {
                    Table intermediate = this.pdes.createTable();
                    String newName = relation.getDesign().transformNameFromLogicalToRelational(relation);
                    intermediate.setName(newName);
                    this.copyPropertiesFromRelationToTable(relation, intermediate);
                    XtdMapping mapping = this.xmap.createMapping(relation, intermediate);
                    mapping.setRealSourceEntityID(realSourceEntity.getObjectID());
                    mapping.setRealTargetEntityID(realTargetEntity.getObjectID());
                    mapping.setInheritanceType(inh_type);
                    if (sourceTable.getPKorUnique() == null) {
                        this.createSurrogatePKandColumn(sourceTable, null, null);
                    }
                    if (targetTable.getPKorUnique() == null) {
                        this.createSurrogatePKandColumn(targetTable, null, null);
                    }
                    this.synchronizeFK(sourceTable, targetTable, intermediate, relation);
                }
                finally {
                    this.design.setPropagatePKChahges(false);
                }
            }
        }
    }

    private void synchronizeFKColumns(XtdMapping mapping, Relation relation, Entity sourceEntity, Entity targetEntity, Table sourceTable, Table targetTable, int endPoint, boolean mandatoryDefined) {
        DesignObject dobj = mapping.getObjectMappedTo(relation);
        if (dobj != null && dobj instanceof FKIndexAssociation) {
            FKIndexAssociation fk = (FKIndexAssociation)dobj;
            Entity ent = relation.getEntity(endPoint);
            Entity otherent = relation.getEntity(relation.getOtherEndPoint(endPoint));
            Table pktable = null;
            Table childTable = null;
            CandidateKey pkey = null;
            if (ent == sourceEntity) {
                pktable = sourceTable;
                childTable = targetTable;
                pkey = relation.getSourcePk();
            } else if (ent == targetEntity) {
                pktable = targetTable;
                childTable = sourceTable;
                pkey = relation.getTargetPk();
            }
            if (pktable != null && pktable == fk.getRemoteTable() && childTable != null && childTable == fk.getContainerWithKeyObject()) {
                ContainedObject[] cols;
                ContainedObject[] attributes = relation.getFKAttributes(otherent);
                Index pk = null;
                if (pkey == null) {
                    pkey = (CandidateKey)ent.getPKorUnique();
                }
                Entity hierpk_ent = null;
                if (relation.isUseSurrogateKey()) {
                    pk = this.createSurrogatePKandColumn(pktable, pktable.getSurrogateKey(), pktable.getSurrogateColumn());
                } else {
                    if (pkey == null && (pkey = (CandidateKey)ent.getHierarchicalPK()) != null) {
                        hierpk_ent = (Entity)pkey.getContainerWithKeyObject();
                    }
                    if (pkey != null) {
                        pk = pkey.getEngIndex(this.pdes, pktable);
                    }
                    if (pk == null) {
                        pk = (Index)pktable.getPKorUnique();
                    }
                }
                if (pk != null) {
                    cols = pk.getElements();
                    fk.getLocalFKIndex().getElementsCollection().clear();
                    for (int i = 0; i < cols.length; ++i) {
                        Column fkcol;
                        Column refColumn = (Column)cols[i];
                        Attribute attr = refColumn.getEngAttribute(ent);
                        Column usedFKColumn = (Column)childTable.getFKColumn(fk, refColumn);
                        if (usedFKColumn != null) {
                            fk.getLocalFKIndex().add(usedFKColumn);
                            continue;
                        }
                        Attribute fkattr = otherent.getAttributeForDelegate(attr, relation);
                        Column col = null;
                        if (fkattr != null && (col = fkattr.getEngColumn(this.pdes, childTable)) != null) {
                            col.addFKAssociation(refColumn, fk);
                            fk.getLocalFKIndex().add(col);
                            continue;
                        }
                        fk.addFKElement(refColumn);
                        if (attr != null) {
                            Attribute fkAttr;
                            Attribute delegate;
                            if (attr.isFKAttribute() && (delegate = attr.getDelegate()) != null && (fkcol = delegate.getEngColumn(this.pdes, childTable)) != null && fkcol.getContainer() == childTable) {
                                fkcol.addFKAssociation(refColumn, fk);
                                fk.getLocalFKIndex().add(fkcol);
                                continue;
                            }
                            if (usedFKColumn == null) {
                                fkAttr = this.getAttributeforDelegate(attributes, attr);
                                if (fkAttr == null || (fkcol = fkAttr.getEngColumn(this.pdes, childTable)) == null || fkcol.getContainer() != childTable) continue;
                                fkcol.addFKAssociation(refColumn, fk);
                                fk.getLocalFKIndex().add(fkcol);
                                continue;
                            }
                            fkAttr = this.getAttributeforDelegate(attributes, attr);
                            if (fkAttr == null) continue;
                            fkcol = fkAttr.getEngColumn(this.pdes, childTable);
                            if (fkcol != null && fkcol.getContainer() == childTable) {
                                fkcol.addFKAssociation(refColumn, fk);
                                fk.getLocalFKIndex().add(fkcol);
                                continue;
                            }
                            fk.getLocalFKIndex().add(usedFKColumn);
                            continue;
                        }
                        if (attr != null || hierpk_ent == null) continue;
                        Attribute orig = refColumn.getEngAttribute(hierpk_ent);
                        if (orig != null) {
                            attr = otherent.getFKAttributeForOriginating(orig, relation);
                        }
                        if (usedFKColumn == null && attr != null) {
                            fkcol = attr.getEngColumn(this.pdes, childTable);
                            if (fkcol == null || fkcol.getContainer() != childTable) continue;
                            fkcol.addFKAssociation(refColumn, fk);
                            fk.getLocalFKIndex().add(fkcol);
                            continue;
                        }
                        if (usedFKColumn == null) continue;
                        fk.getLocalFKIndex().add(usedFKColumn);
                    }
                }
                cols = childTable.getAllFKColumns(fk);
                Index ind = (Index)fk.getLocalFKIndex();
                for (int i = 0; i < cols.length; ++i) {
                    if (ind.contains(cols[i])) continue;
                    ((FKElement)cols[i]).removeFKAssociation(fk.getObjectID());
                }
            }
            if (fk != null) {
                if (!mandatoryDefined) {
                    int other = relation.getOtherEndPoint(endPoint);
                    if (relation.getArc() != null) {
                        fk.setMandatory(false);
                    } else {
                        fk.setMandatory(!relation.isOptional(other));
                    }
                }
                if (relation.isOneToOne()) {
                    Index index;
                    Table table = (Table)fk.getTable();
                    Column[] cols = (Column[])fk.getColumns();
                    if (cols.length > 0 && (index = table.getUniqueIndex_PK_UK(cols)) == null) {
                        index = table.getIndex(cols);
                        if (index == null) {
                            index = table.createIndex();
                            index.setRelationGeneratorID(relation.getObjectID());
                            for (int i = 0; i < cols.length; ++i) {
                                index.add(cols[i]);
                            }
                        }
                        index.setIndexState("Unique Plain Index");
                    }
                }
                this.fwdEngineering.synchronizeDeleteRule(relation, fk, endPoint);
                TVConnector tvc_t = (TVConnector)fk.getViewFor(fk.getDesignPart().getMainView());
                TVConnector tvc_s = (TVConnector)relation.getViewFor(relation.getDesignPart().getMainView());
                if (this.design.isEngineerCoordinates() && tvc_t != null && tvc_s != null) {
                    ReverseEngineering.copyConnectionPoints(tvc_s, tvc_t);
                }
            }
        }
    }

    private Attribute getAttributeforDelegate(ContainedObject[] attributes, Attribute delegate) {
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attr = (Attribute)attributes[i];
            if (!attr.isFKAttribute() || attr.getDelegate() != delegate) continue;
            return attr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FKIndexAssociation createFK(Relation relation, Entity sourceEntity, Entity targetEntity, Table sourceTable, Table targetTable, Entity realSourceEntity, Entity realTargetEntity, int endPoint, int inhType) {
        FKIndexAssociation fkAssociation = null;
        Entity ent = relation.getEntity(endPoint);
        Entity otherent = relation.getEntity(relation.getOtherEndPoint(endPoint));
        Table pktable = null;
        Table childTable = null;
        Entity childent = null;
        Entity pkent = null;
        boolean transferable = true;
        CandidateKey pkey = null;
        if (ent == sourceEntity) {
            pktable = sourceTable;
            childTable = targetTable;
            transferable = relation.isTargetTransferable();
            pkent = sourceEntity;
            childent = otherent;
            pkey = relation.getSourcePk();
        } else if (ent == targetEntity) {
            pktable = targetTable;
            childTable = sourceTable;
            transferable = relation.isSourceTransferable();
            pkent = otherent;
            childent = sourceEntity;
            pkey = relation.getTargetPk();
        }
        if (pktable != null) {
            Index pk = null;
            if (pkey == null) {
                pkey = (CandidateKey)ent.getPKorUnique();
            }
            if (relation.isUseSurrogateKey()) {
                pk = this.createSurrogatePKandColumn(pktable, pktable.getSurrogateKey(), pktable.getSurrogateColumn());
            } else {
                if (pkey == null) {
                    pkey = (CandidateKey)ent.getHierarchicalPK();
                }
                if (pkey != null) {
                    pk = pkey.getEngIndex(this.pdes, pktable);
                }
                if (pk == null) {
                    pk = (Index)pktable.getPKorUnique();
                }
                if (pk == null) {
                    pk = this.createSurrogatePKandColumn(pktable, null, null);
                }
            }
            if (pk != null) {
                Attribute attr;
                if (pkey == null) {
                    boolean old = pktable.getDesign().isPropagatePKChahges();
                    try {
                        pktable.getDesign().setPropagatePKChahges(true);
                        fkAssociation = childTable.addFK((KeyObject)pk, relation);
                    }
                    finally {
                        pktable.getDesign().setPropagatePKChahges(old);
                    }
                } else {
                    fkAssociation = childTable.addFK((KeyObject)pk, relation);
                }
                fkAssociation.setTransferable(transferable);
                String fname = relation.getName();
                fname = childTable.getDesign().transformNameFromLogicalToRelational(relation, fkAssociation, childTable);
                fkAssociation.setName(fname);
                XtdMapping mapping = this.xmap.createMapping(relation, fkAssociation);
                mapping.setRealSourceEntityID(realSourceEntity.getObjectID());
                mapping.setRealTargetEntityID(realTargetEntity.getObjectID());
                mapping.setInheritanceType(inhType);
                ContainedObject[] attributes = relation.getFKAttributes(otherent);
                if (attributes.length == 0 && ent == otherent) {
                    int ep = relation.getEndPointFor(ent);
                    ep = relation.getOtherEndPoint(ep);
                    attributes = relation.getFKAttributes(ep);
                }
                if (attributes.length == 0 && ent.getBasedOnStructuredType() != null && (attr = otherent.getExactRefToStructurtedType(ent.getBasedOnStructuredType(), ent)) != null) {
                    attributes = new Attribute[]{attr};
                }
                this.addFKColumns(attributes, ent, pk, childTable, fkAssociation, pkey, relation);
                int other = relation.getOtherEndPoint(endPoint);
                fkAssociation.setMandatory(!relation.isOptional(other));
                this.fwdEngineering.synchronizeDeleteRule(relation, fkAssociation, endPoint);
                this.fwdEngineering.copyPropertiesFromRelationToFK(relation, fkAssociation);
                if ((relation.isUseSurrogateKey() || pkent.isCreateSurrogateKey()) && relation.isIdentifying()) {
                    FKElement[] cols = childTable.getAllFKColumns(fkAssociation);
                    Index ch_pk = (Index)childTable.getPK();
                    if (ch_pk == null && childent != null && childent.isCreateSurrogateKey()) {
                        ch_pk = this.createSurrogatePKandColumn(childTable, null, null);
                    }
                    if (ch_pk != null && relation.isOneToOne() && ch_pk.isSurrogateKey() && cols.length == 1) {
                        Column col = childTable.getSurrogateColumn();
                        if (col != cols[0] && cols[0] instanceof Column) {
                            col.remove();
                            ((Column)cols[0]).setSurrogateColumn(true);
                            ch_pk.add(cols[0]);
                        }
                    } else if (ch_pk != null && !ch_pk.isSurrogateKey()) {
                        ch_pk.add(cols[0]);
                        if (ch_pk.getElementsCollection().size() > 1) {
                            ch_pk.moveToIndex(cols[0], 0);
                        }
                    }
                }
                TVConnector tvc_t = (TVConnector)fkAssociation.getViewFor(fkAssociation.getDesignPart().getMainView());
                TVConnector tvc_s = (TVConnector)relation.getViewFor(relation.getDesignPart().getMainView());
                if (this.design.isEngineerCoordinates() && tvc_t != null && tvc_s != null) {
                    ReverseEngineering.copyConnectionPoints(tvc_s, tvc_t);
                }
                mapping.setCreationTime(System.currentTimeMillis());
            }
        }
        return fkAssociation;
    }

    private void addFKFor(Table pkTable, Table otherTable, Table intermediate, Index pkIndex, Relation relation) {
        Index pk = (Index)pkTable.getPK();
        if (pk == null) {
            pk = (Index)pkTable.getPKorUnique();
        }
        if (pk != null) {
            FKIndexAssociation fkAssociation = null;
            if (pkTable == otherTable && intermediate.getNumberOfFKAssociationFor(pk) < 2 || pkTable != otherTable && !intermediate.hasFKAssociationFor(pk)) {
                fkAssociation = intermediate.addFK((KeyObject)pk, relation);
                FKElement[] columns = fkAssociation.getColumns();
                for (int k = 0; k < columns.length; ++k) {
                    pkIndex.add(columns[k]);
                }
            }
            if (fkAssociation == null) {
                fkAssociation = intermediate.getFKIndexAssociationFor(pk);
            }
            if (fkAssociation != null) {
                if (!"SET NULL".equals(relation.getDeleteRule())) {
                    fkAssociation.setDeleteRule(relation.getDeleteRule());
                } else {
                    fkAssociation.setDeleteRule("NO ACTION");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeFK(Table sourceTable, Table targetTable, Table intermediate, Relation relation) {
        FKIndexAssociation fk;
        Index pkIndex = (Index)intermediate.getPK();
        if (pkIndex == null) {
            pkIndex = intermediate.createIndex();
            pkIndex.makePK();
            String name = ApplyNamingStandards.createPK_Name(intermediate.getName(), targetTable.getDesign().getDesignLevelSettings().getNamingStandardRule(), targetTable.getRelationalModel().getName(), intermediate.getAbbreviation());
            pkIndex.setName(name);
        }
        this.design.setPropagatePKChahges(true);
        try {
            this.addFKFor(sourceTable, targetTable, intermediate, pkIndex, relation);
            this.addFKFor(targetTable, sourceTable, intermediate, pkIndex, relation);
        }
        finally {
            this.design.setPropagatePKChahges(false);
        }
        Index pk_un = (Index)sourceTable.getPKorUnique();
        if (pk_un != null && (fk = intermediate.getFKIndexAssociationFor(sourceTable.getPKorUnique())) != null) {
            fk.setTransferable(relation.isSourceTransferable());
            fk.synchronizeFKColumns();
            for (Column col : fk.getLocalFKIndex().getElementsCollection()) {
                if (pkIndex.contains(col)) continue;
                pkIndex.add(col);
            }
        }
        if ((pk_un = (Index)targetTable.getPKorUnique()) != null && (fk = intermediate.getFKIndexAssociationFor(pk_un)) != null) {
            fk.setTransferable(relation.isTargetTransferable());
            fk.synchronizeFKColumns();
            for (Column col : fk.getLocalFKIndex().getElementsCollection()) {
                if (pkIndex.contains(col)) continue;
                pkIndex.add(col);
            }
        }
    }

    private void addFKColumns(ContainedObject[] attributes, Entity pkEntity, Index pk, Table childTable, FKIndexAssociation fkAssociation, KeyObject originatingPK, Relation relation) {
        if (pk.isSurrogateKey()) {
            fkAssociation.synchronizeFKColumns();
            return;
        }
        ContainedObject[] cols = pk.getElements();
        for (int i = 0; i < cols.length; ++i) {
            Column fkcol;
            Attribute fkAttr;
            Column refColumn = (Column)cols[i];
            if (originatingPK == null) continue;
            Attribute attr = refColumn.getEngAttribute(pkEntity);
            if (attr == null) {
                attr = refColumn.getEngAttribute((Entity)originatingPK.getContainerWithKeyObject());
            }
            if (attr == null || (fkAttr = this.getAttributeforDelegate(attributes, attr)) == null || (fkcol = fkAttr.getEngColumn(this.pdes, childTable)) == null || fkcol.getContainer() != childTable) continue;
            if (fkcol.hasOtherFK_forRelation(fkAssociation, relation)) {
                Column col = (Column)childTable.createColumnFK((FKElement)refColumn, fkAssociation);
                col.setName(fkcol.getName());
                continue;
            }
            fkcol.addFKAssociation(refColumn, fkAssociation);
            String name = fkAttr.getDesign().transformNameFromLogicalToRelational(fkAttr, fkcol, childTable);
            fkcol.setName(name);
            fkAssociation.getLocalFKIndex().add(fkcol);
        }
    }

    public void setComparatorsMap(Map comparatorsMap) {
        this.comparatorsMap = comparatorsMap;
    }
}

