/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.constraint;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;

public class TableLevelConstraint
extends DesignObject {
    private String EMPTY;
    private String rule;
    private String generateInDDL;
    private Table table;
    boolean parsedForArcDef;
    private List arcDefList;
    public static final String TYPE_NAME = "Constraint";

    public TableLevelConstraint(DesignPart designPart) {
        super(designPart);
        this.rule = this.EMPTY = "";
        this.generateInDDL = "YES";
        this.table = null;
        this.parsedForArcDef = false;
        this.getDesign().addDesignObject(this);
    }

    public TableLevelConstraint(DesignPart designPart, String name, String rule) {
        super(designPart);
        this.rule = this.EMPTY = "";
        this.generateInDDL = "YES";
        this.table = null;
        this.parsedForArcDef = false;
        this.getDesign().addDesignObject(this);
        super.setName(name);
        this.rule = rule;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("chkconstr id prefix");
    }

    public String getRule() {
        if (this.rule == null) {
            return this.EMPTY;
        }
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
        this.parsedForArcDef = false;
    }

    public String getGenerateInDDL() {
        return this.generateInDDL;
    }

    public void setGenerateInDDL(String generateInDDL) {
        if (generateInDDL.equalsIgnoreCase("YES") || generateInDDL.equalsIgnoreCase("NO")) {
            this.generateInDDL = generateInDDL;
        }
    }

    public boolean isGenerateInDDL() {
        return this.generateInDDL.equalsIgnoreCase("YES");
    }

    public void setGenerateInDDL(boolean generateInDDL) {
        this.generateInDDL = generateInDDL ? "YES" : "NO";
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getID() {
        return this.getObjectID();
    }

    public void setID(String id) {
        this.setObjectID(id);
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public void remove() {
        if (this.table != null) {
            this.table.removeCheckConstraint(this);
        }
        this.getDesign().removeDesignObject(this);
        super.remove();
    }

    private void parseForArcDef() {
        if (this.table != null) {
            String[] groupsANDonly;
            boolean failed = false;
            String text = this.rule.replaceAll("[ )(\t\n\f\r\u000b]+", " ").toUpperCase().trim();
            ArcConstrPart lastPart = null;
            for (String gr : groupsANDonly = text.split(" OR ")) {
                String[] colParts = gr.split(" AND ");
                ArcConstrPart part = new ArcConstrPart();
                for (String coldef : colParts) {
                    String nnc;
                    String colname = Token.getFirstToken(coldef);
                    FKElement tcol = (FKElement)this.table.getElementByName(colname = Token.getName(colname));
                    if (tcol == null || !tcol.isFKColumn() || !(tcol instanceof Column)) {
                        failed = true;
                        break;
                    }
                    Column col = (Column)tcol;
                    FKIndexAssociation fk = col.getFKIndexAssociation();
                    if (!part.fkeys.contains(fk)) {
                        part.fkeys.add(fk);
                    }
                    if ("IS NOT NULL".equals(nnc = Token.getStringAfter(coldef, colname).trim())) {
                        part.notNullColumns.add(col);
                        continue;
                    }
                    if ("IS NULL".equals(nnc)) {
                        part.nullColumns.add(col);
                        continue;
                    }
                    failed = true;
                    break;
                }
                if (failed) break;
                if (part.fkeys.size() < 2) {
                    failed = true;
                    break;
                }
                if (lastPart != null) {
                    if (part.fkeys.size() != lastPart.fkeys.size() || part.notNullColumns.size() + part.nullColumns.size() != lastPart.notNullColumns.size() + lastPart.nullColumns.size()) {
                        failed = true;
                        break;
                    }
                    for (FKIndexAssociation fk : part.fkeys) {
                        if (lastPart.fkeys.contains(fk)) continue;
                        failed = true;
                        break;
                    }
                }
                if (!this.checkColumns(part)) {
                    failed = true;
                    break;
                }
                if (this.arcDefList == null) {
                    this.arcDefList = new ArrayList();
                }
                this.arcDefList.add(part);
                lastPart = part;
            }
            if (failed) {
                this.arcDefList = null;
            }
            this.parsedForArcDef = true;
        }
    }

    private boolean checkColumns(ArcConstrPart part) {
        if (part.nullColumns.isEmpty()) {
            return false;
        }
        int fkcnum = 0;
        for (FKIndexAssociation fk : part.fkeys) {
            fkcnum += fk.getNumberOfColumns();
        }
        if (fkcnum != part.notNullColumns.size() + part.nullColumns.size()) {
            return false;
        }
        for (FKIndexAssociation fk : part.fkeys) {
            for (Object obj : fk.getLocalFKIndex().getElementsCollection()) {
                if (part.notNullColumns.contains(obj) || part.nullColumns.contains(obj)) continue;
                return false;
            }
        }
        FKIndexAssociation lfk = null;
        for (Column col : part.notNullColumns) {
            FKIndexAssociation fk = col.getFKIndexAssociation();
            if (lfk != null && lfk != fk) {
                return false;
            }
            lfk = fk;
        }
        return true;
    }

    public boolean isArcConstraint() {
        if (!this.parsedForArcDef) {
            this.parseForArcDef();
        }
        return this.arcDefList != null && this.arcDefList.size() > 1;
    }

    public FKArc createArcFromConstraint() {
        FKArc arc = null;
        if (this.table != null && this.isArcConstraint()) {
            ArcConstrPart part = (ArcConstrPart)this.arcDefList.get(0);
            ArrayList<Table> list = new ArrayList<Table>();
            list.add(this.table);
            list.addAll(part.fkeys);
            arc = this.table.getArcForForeignKeys(part.fkeys);
            if (arc == null) {
                arc = this.table.getRelationalModel().createArc(list.toArray());
            } else {
                int count = arc.getFkeys().size();
                for (Object obj : part.fkeys) {
                    arc.addFkey((FKIndexAssociation)obj);
                }
                if (count != arc.getFkeys().size()) {
                    arc.setDirty(true);
                }
            }
            if (this.arcDefList.size() > part.fkeys.size()) {
                arc.setMandatory(false);
            } else {
                arc.setMandatory(true);
            }
        }
        return arc;
    }

    public class ArcConstrPart {
        List nullColumns = new ArrayList();
        List notNullColumns = new ArrayList();
        List fkeys = new ArrayList();
    }
}

