/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBCreateBitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBArcConstraintOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.AbstractCSSBOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBIndexOraclev10g;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.TableProxyOraclev12c;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class CSSBCreateTableOraclev10g
extends AbstractCSSBOraclev10g {
    private CSSBIndexOraclev10g cssbIndex = null;
    private CSSBArcConstraintOracle cssbArcConstraintOracle = null;
    private TableProxyOraclev10g tableProxy = null;
    private CompareObjectSelection tableObj;
    private SSBCreateBitmapJoinIndexOraclev10g ssbBJIndex = null;

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).canBeCreate() && ((CompareObjectSelection)object).getObject() instanceof Table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        Table table = null;
        this.tableObj = (CompareObjectSelection)object;
        if (object == null) {
            return;
        }
        if (!(this.tableObj.getObject() instanceof Table)) {
            return;
        }
        table = (Table)this.tableObj.getObject();
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
        this.tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (table != null) {
            if (table.getTypeSubstitution() == null) {
                for (Column column : table.getElementsCollection()) {
                    if (!column.isAutoIncrementColumn()) continue;
                    this.appendAutoIncrementSequence(oldbuffer, column, prettyPrint);
                }
                if (this.tableProxy != null && this.tableProxy.isCommentChanged()) {
                    this.appendComment(oldbuffer, this.tableProxy);
                } else {
                    this.appendComment(oldbuffer, table);
                }
                if (this.tableProxy != null && this.tableProxy.getName().length() > this.tableProxy.getMaxNameLength()) {
                    CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + this.tableProxy.getMaxNameLength() + ")");
                    CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    CDDLFileMaker.incrementErrors();
                }
                StringBuffer buffer = new StringBuffer();
                String advancedComment = "";
                if (this.tableProxy != null && this.tableProxy.getSnapshot() == null) {
                    this.appendBeforeCreateScript(oldbuffer, prettyPrint, table);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CREATE");
                    if ("YES".equalsIgnoreCase(this.tableProxy.getTemporary())) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TEMPORARY");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(this.tableProxy));
                        advancedComment = buffer.toString();
                        this.appendElementList(buffer, table, this.tableProxy, prettyPrint);
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ON");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMMIT");
                        if ("YES".equalsIgnoreCase(this.tableProxy.getTempPreserveRows())) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PRESERVE ROWS");
                        } else {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DELETE ROWS");
                        }
                        this.appendOid(buffer, table, null, prettyPrint);
                        TemporaryTablespaceOracle tablespace = this.tableProxy.getTemporaryTablespace();
                        if (tablespace != null && this.storageDesign instanceof StorageDesignOraclev11g && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tablespace));
                        }
                        if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CACHE");
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
                        }
                    } else {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(this.tableProxy));
                        advancedComment = buffer.toString();
                        this.appendElementList(buffer, table, this.tableProxy, prettyPrint);
                        this.appendOid(buffer, table, this.tableProxy, prettyPrint);
                        this.appendCluster(buffer, this.tableProxy, prettyPrint);
                        this.appendColumnProperties(buffer, table, this.tableProxy, prettyPrint);
                        this.appendPartitionList(buffer, this.tableProxy, prettyPrint);
                        if (this.tableProxy.getCluster() == null) {
                            if (!"INDEX".equals(this.tableProxy.getOrganization())) {
                                if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CACHE");
                                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
                                }
                            }
                            if ("YES".equalsIgnoreCase(this.tableProxy.getParallel())) {
                                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
                                if (!"".equals(this.tableProxy.getDegree())) {
                                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.tableProxy.getDegree());
                                }
                            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
                            }
                        }
                    }
                    this.appendRowDependency(buffer, this.tableProxy, prettyPrint);
                    this.appendRowMovement(buffer, this.tableProxy, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CDDLFileMaker.incrementCreateTable();
                    this.appendAfterCreateScript(oldbuffer, prettyPrint, table);
                }
                this.appendValidTimes(oldbuffer, table, this.tableProxy, prettyPrint);
                this.appendColumnCheckConstraints(oldbuffer, this.tableProxy, prettyPrint);
                this.appendTableLevelCheckConstraints(oldbuffer, this.tableProxy, prettyPrint);
                int arcsIndex = this.tableObj.getChildIndex(ModelIdObjectSelection.ARCS);
                if (arcsIndex > -1) {
                    for (CompareObjectSelection arcSel : this.tableObj.getChildObjects(arcsIndex)) {
                        if (!arcSel.isSelected()) continue;
                        if (this.cssbArcConstraintOracle == null) {
                            this.cssbArcConstraintOracle = new CSSBArcConstraintOracle();
                        }
                        this.cssbArcConstraintOracle.appendArcConstraint(oldbuffer, arcSel, prettyPrint);
                    }
                }
                if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendTableCommentOn(oldbuffer, this.tableObj, this.tableProxy, this.storageDesign, prettyPrint);
                }
                if (this.tableProxy != null) {
                    this.appendIndexes(oldbuffer, this.tableProxy, this.tableObj, prettyPrint);
                    DDLAdvancedGenerator oldg = DDLFileMaker.getddlAdvancedGenenerator();
                    try {
                        DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                        this.appendBitmapJoinIndexes(oldbuffer, this.tableProxy, prettyPrint);
                        this.appendAutoIncTriggers(oldbuffer, this.tableProxy, prettyPrint);
                    }
                    finally {
                        DDLFileMaker.setddlAdvancedGenenerator(oldg);
                    }
                    this.appendPermissions(oldbuffer, this.tableProxy, prettyPrint);
                }
                CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                if (table.isSpatialTable()) {
                    for (SpatialColumnDefObject spObjects : table.getSpatialDefinitions()) {
                        if (spObjects.getSpatialColumn() == null && !spObjects.isFunction()) continue;
                        this.appendRegisterSpatialTable(oldbuffer, table, spObjects, prettyPrint);
                    }
                }
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(oldbuffer, "-- table " + table.getName() + ": is a part of type substitution hierarchy");
                CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            }
        }
        this.tableProxy = null;
    }

    private void appendColumnProperties(StringBuffer buffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        Column[] cols = (Column[])table.getElements();
        for (int i = 0; i < cols.length; ++i) {
            Column column = cols[i];
            if (!column.shouldBeMerge() && !this.isRenamed()) continue;
            ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
            Datatype datatype = columnProxy.getDataType();
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (datatype instanceof CollectionType) {
                CollectionType cdatatype = (CollectionType)datatype;
                if (cdatatype.isArrayType()) {
                    this.appendVarrayColumnProp(buffer, columnProxy, prettyPrint);
                    continue;
                }
                this.appendNestedTableColumnProp(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (!(datatype instanceof StructuredType)) continue;
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, true);
        }
    }

    private void appendOid(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (table.isRoot()) {
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OBJECT");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "IDENTIFIER");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "IS");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            }
            if (!(tableProxy == null || tableProxy.getOidIndexSegment() == null && "".equalsIgnoreCase(tableProxy.getOidIndexName()))) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OIDINDEX");
                if (!"".equalsIgnoreCase(tableProxy.getOidIndexName())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getOidIndexName()));
                }
                if (tableProxy.getOidIndexSegment() != null) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    this.appendSegment(buffer, (SegmentOraclev10g)tableProxy.getOidIndexSegment(), false, prettyPrint, null, "");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
            }
        }
    }

    private void appendElementList(StringBuffer buffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        ContainedObject[] columns = (Column[])table.getElements();
        ContainedObject column = null;
        ColumnProxyOraclev10g columnProxy = null;
        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if (table.getBasedOnStructuredType() != null) {
            StructuredTypeProxyOracle typeProxy;
            StructuredType type;
            ModelIDObject typeOrProxy = type = table.getBasedOnStructuredType();
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OF");
            if (tableProxy != null && (typeProxy = (StructuredTypeProxyOracle)tableProxy.getStorageDesign().getProxy(type)) != null) {
                if (typeProxy.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    CSSBCreateTableOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
                    CSSBCreateTableOraclev10g.appendString(buffer, '.');
                }
                typeOrProxy = typeProxy;
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeOrProxy));
            String typeName = ((ModelObject)typeOrProxy).getName();
            if (typeName.equalsIgnoreCase("XMLTYPE")) {
                this.appendObjectTypeColProperties(buffer, table, tableProxy, prettyPrint);
                if (tableProxy != null) {
                    boolean storeAsBinaryXml = false;
                    String allowAnySchema = "";
                    String allowNonSchema = "";
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "XMLTYPE");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
                    if (tableProxy.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OBJECT RELATIONAL");
                    } else {
                        if (tableProxy instanceof TableProxyOraclev11g) {
                            if (((TableProxyOraclev11g)tableProxy).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                            } else if (((TableProxyOraclev11g)tableProxy).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                            }
                            allowAnySchema = ((TableProxyOraclev11g)tableProxy).getAllowAnySchema();
                            allowNonSchema = ((TableProxyOraclev11g)tableProxy).getAllowNonSchema();
                            storeAsBinaryXml = tableProxy.getStoreAs().equalsIgnoreCase("BINARY XML");
                        }
                        if (storeAsBinaryXml) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BINARY XML");
                        } else {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CLOB");
                        }
                        String lobSegmentName = tableProxy.getLobSegmentName();
                        if (lobSegmentName != null && lobSegmentName.length() > 0) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegmentName));
                        }
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        if (tableProxy.getXmlTypeTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getXmlTypeTableSpace()));
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (tableProxy.getChunk() > 0) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CHUNK");
                            this.appendStringWithSpace(buffer, tableProxy.getChunk());
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (tableProxy.getOldVersions().equalsIgnoreCase("RETENTION")) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "RETENTION");
                        } else {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PCTVERSION");
                            this.appendStringWithSpace(buffer, tableProxy.getPCTVersion());
                        }
                        if (tableProxy.getFreepools() > 0) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                            this.appendStringWithSpace(buffer, tableProxy.getFreepools());
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "1");
                        }
                        this.appendStorageInRow(buffer, tableProxy, tableProxy.getStorageInRow(), prettyPrint);
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, tableProxy.getXmlTypeCache());
                        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && (!"CACHE".equalsIgnoreCase(tableProxy.getXmlTypeCache()) || this.storageDesign instanceof StorageDesignOraclev12c)) {
                            String logging = tableProxy.getXmlTypeLogging();
                            if (logging.equalsIgnoreCase("YES")) {
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            } else if (logging.equalsIgnoreCase("NO")) {
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            } else if (logging.equalsIgnoreCase("FILESYSTEM_LIKE_LOGGING") && this.isSecureFile(((TableProxyOraclev11g)tableProxy).getLobStorageType())) {
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FILESYSTEM_LIKE_LOGGING");
                            }
                        }
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                    }
                    this.appendXMLSchemaSpec(buffer, tableProxy.getXmlSchemaUrl(), tableProxy.getXmlSchemaElement(), storeAsBinaryXml, allowAnySchema, allowNonSchema, prettyPrint);
                }
            } else {
                if (!table.isSubstitutable()) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOT");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "AT");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALL");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LEVELS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "AT");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALL");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LEVELS");
                }
                this.appendObjectTypeColProperties(buffer, table, tableProxy, prettyPrint);
            }
        } else if (this.hasNoMergeColumns(columns)) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "-- No Columns");
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        } else {
            HashMap<ContainedObject, ColumnProxyOraclev10g> map = new HashMap<ContainedObject, ColumnProxyOraclev10g>();
            int max = 0;
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                if (tableProxy == null) continue;
                columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
                String fname = this.storageDesign.getFormatedName(columnProxy);
                int l = fname.length();
                if (max < l) {
                    max = l;
                }
                map.put(column, columnProxy);
            }
            boolean first = true;
            for (int i = 0; i < columns.length; ++i) {
                RelationalObjectProxy proxy;
                column = columns[i];
                if (!column.shouldBeMerge() && !this.isRenamed() || column.isOid()) continue;
                if (first) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                if (tableProxy != null && (columnProxy = (ColumnProxyOraclev10g)map.get(column)) == null) {
                    columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
                }
                if (columnProxy.getName().length() > columnProxy.getMaxNameLength()) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxy.getMaxNameLength() + ")");
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    CDDLFileMaker.incrementErrors();
                }
                if (columnProxy.isCommentChanged() && !"".equalsIgnoreCase(columnProxy.getComment())) {
                    this.appendComment(buffer, columnProxy);
                } else if (!"".equalsIgnoreCase(columnProxy.getObject().getComment())) {
                    this.appendComment(buffer, columnProxy.getObject());
                }
                CSSBCreateTableOraclev10g.appendString(buffer, ' ');
                String fname = this.storageDesign.getFormatedName(columnProxy);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, fname, max - fname.length() + 1);
                String datatypeString = "";
                Datatype type = ((Column)column).getDataType();
                if ((type instanceof StructuredType || type instanceof CollectionType) && (proxy = this.storageDesign.getProxy(type)) != null) {
                    datatypeString = this.storageDesign.getFormatedLongNameDDL(proxy);
                    if (((ContainedObjectWithDomain)column).isReference() && type instanceof StructuredType) {
                        datatypeString = "REF " + datatypeString;
                    }
                }
                if (datatypeString.equals("") && (datatypeString = ((Column)column).getDatatypeString(this.storageDesign.getRDBMSType().getName())).equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    datatypeString = datatypeString + " (4000)";
                }
                this.appendDatatype(buffer, datatypeString, columnProxy, prettyPrint);
                if (tableProxy == null) continue;
                this.appendColumnOptions(buffer, tableProxy, (Column)column, columnProxy, prettyPrint);
                this.appendInlineRefConstraint(buffer, (Column)column, columnProxy, prettyPrint);
                CSSBCreateTableOraclev10g.appendColumnConstraints(buffer, (Column)column, columnProxy, prettyPrint);
            }
            this.appendNestedColumnNotNullChecks(buffer, table, tableProxy, prettyPrint, false);
            if ("INDEX".equalsIgnoreCase(tableProxy.getOrganization())) {
                this.appendPKDefinitionConstraint(buffer, tableProxy, prettyPrint);
            }
            this.appendTableConstraintsDefinition(buffer, tableProxy, prettyPrint, false);
            this.appendRefPartitionFK(buffer, tableProxy, prettyPrint);
            this.appendSupplementalLoggings(buffer, tableProxy, prettyPrint);
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendValidTimes(StringBuffer oldbuffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            List<ValidTimeDimension> validTimeDimensions = table.getValidTimeDimensions();
            for (int i = 0; i < validTimeDimensions.size(); ++i) {
                ValidTimeDimension validTimeDimension = validTimeDimensions.get(i);
                if (!validTimeDimension.shouldBeMerge()) continue;
                CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                StringBuffer buffer = new StringBuffer();
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                String advancedComment = buffer + "ADD period for " + validTimeDimension.getName();
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ADD");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                this.appendPeriodDefinition(buffer, validTimeDimension, tableProxy);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    private void appendPeriodDefinition(StringBuffer buffer, ValidTimeDimension validTimeDimension, TableProxyOraclev10g tableProxy) {
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PERIOD FOR");
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, validTimeDimension.getName());
        Column startCol = validTimeDimension.getStartTimeColumn();
        Column endCol = validTimeDimension.getEndTimeColumn();
        if (startCol != null && endCol != null) {
            ColumnProxy startColProxy = tableProxy.getColumnProxy(startCol.getObjectID());
            ColumnProxy endColProxy = tableProxy.getColumnProxy(endCol.getObjectID());
            if (startColProxy != null && endColProxy != null) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(startColProxy));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(endColProxy));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendRefPartitionFK(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
    }

    private boolean hasNoMergeColumns(ContainedObject[] objects) {
        if (this.isRenamed()) {
            return false;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (!objects[i].shouldBeMerge()) continue;
            return false;
        }
        return true;
    }

    public static void appendColumnConstraints(StringBuffer buffer, Column column, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        CSSBCreateTableOraclev10g.appendColumnConstraints(buffer, column, columnProxy, false, prettyPrint);
    }

    public static void appendColumnConstraints(StringBuffer buffer, Column column, ColumnProxyOracle columnProxy, boolean generateIfNamed, boolean prettyPrint) {
        String text;
        if (column.hasConstraintsDefinedForDDL() && column.isGenerateConstraintInDDL() && column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC() && !"".equals(text = column.getConstraintsText(columnProxy.getStorageDesign().getFormatedName(columnProxy)))) {
            String cname = column.getConstraintName();
            if (cname.length() > 30 || cname.toUpperCase().startsWith("SYS_")) {
                cname = "";
            }
            if (!"".equals(cname)) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getStorageDesign().getFormatedName(cname));
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CHECK");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendString(buffer, text);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBCreateTableOraclev10g.appendConstraintState(buffer, columnProxy, prettyPrint);
        }
    }

    public static void appendConstraintState(StringBuffer buffer, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        if (!"NO".equalsIgnoreCase(columnProxy.getDeferrable())) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(columnProxy.getInitially())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (columnProxy.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (columnProxy.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOT");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (columnProxy.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if ("YES".equalsIgnoreCase(columnProxy.getEnable())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(columnProxy.getValidate())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if ("NO".equalsIgnoreCase(columnProxy.getEnable())) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxy.getValidate())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if ("NO".equalsIgnoreCase(columnProxy.getValidate())) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (columnProxy.getExceptionsTable() != null) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "EXCEPTIONS");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INTO");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, columnProxy.getStorageDesign().getFormatedLongNameDDL(columnProxy.getExceptionsTable()));
        }
    }

    private PKProxyOraclev10g getPKProxy(TableProxyOraclev10g tableProxy) {
        KeyObject pk = ((Table)tableProxy.getObject()).getPK();
        if (pk != null) {
            return (PKProxyOraclev10g)((StorageDesignOraclev10g)tableProxy.getStorageDesign()).getPKProxySet().getProxy(pk.getObjectID());
        }
        return null;
    }

    private void appendPKDefinitionConstraint(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        PKProxyOraclev10g pk;
        if (tableProxy != null && (pk = this.getPKProxy(tableProxy)) != null) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendString(buffer, ' ');
            if (!pk.getName().startsWith("SYS_")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            StringBuffer columnList = this.getColumnsForRestore(this.tableObj, (Index)pk.getObject(), prettyPrint, false);
            this.appendStringWithSpace(buffer, columnList);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (!("NO".equalsIgnoreCase(pk.getUsingIndex()) || "INDEX".equalsIgnoreCase(tableProxy.getOrganization()) && "BY INDEX NAME".equalsIgnoreCase(pk.getUsingIndex()) && pk.getExistingIndex() != null)) {
                this.appendUsingIndex(buffer, pk, tableProxy, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
        }
    }

    private void appendSupplementalLoggings(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        if (tableProxy != null && !"".equalsIgnoreCase(tableProxy.getSuplementalLogGroupName())) {
            this.appendComma(buffer);
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUPPLEMENTAL");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOG");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GROUP");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getSuplementalLogGroupName()));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getSuplementalLogColumns()));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (tableProxy.getSuplementalLogConditions().equalsIgnoreCase("ALWAYS")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALWAYS");
            }
        }
    }

    private void appendUsingIndex(StringBuffer buffer, PKProxyOraclev10g pkProxy, TableProxyOracle tableProxy, boolean prettyPrint) {
        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = pkProxy.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(pkProxy.getUsingIndex()) && pkProxy.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(pkProxy.getIndex(), true)) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pkProxy.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pkProxy.getUsingIndex())) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, pkProxy.getCreateIndexStatement());
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOCAL");
                    this.getCSSBIndex().appendPartitionList(buffer, pkProxy, tableProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                    this.appendGlobalIndex(buffer, pkProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                    this.appendGlobalIndexByHashQuantity(buffer, pkProxy, prettyPrint);
                } else if (pkProxy.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                    this.appendGlobalIndexByHashList(buffer, pkProxy, prettyPrint);
                }
                if (pkProxy.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)pkProxy.getIndexSegment(), false, prettyPrint, pkProxy.getTableSpace(), pkProxy.getLogging());
                } else {
                    if (pkProxy.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkProxy.getTableSpace()));
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (pkProxy.getIndexSort().equalsIgnoreCase("NO")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOSORT");
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (pkProxy.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    }
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "REVERSE");
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (pkProxy.getComputeStatistics().equalsIgnoreCase("YES")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (this.storageDesign instanceof StorageDesignOraclev11g) {
                    if (pkProxy.getCompress() > 0) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        this.appendStringWithSpace(buffer, pkProxy.getCompress());
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                }
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer buffer, UniqueOraclev10g unique, TableProxyOracle tableProxy, boolean prettyPrint) {
        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = unique.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(unique.getUsingIndex()) && unique.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(unique.getIndex(), true)) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(unique.getUsingIndex())) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, unique.getCreateIndexStatement());
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL".equalsIgnoreCase(unique.getUsingIndex())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOCAL");
                    this.getCSSBIndex().appendPartitionList(buffer, unique, tableProxy, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                    this.appendUniqueGlobalIndex(buffer, unique, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                    this.appendGlobalIndexByHashQuantity(buffer, unique, prettyPrint);
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                    this.appendGlobalIndexByHashList(buffer, unique, prettyPrint);
                }
                if (unique.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)unique.getIndexSegment(), false, prettyPrint, unique.getTableSpace(), unique.getLogging());
                } else {
                    if (unique.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique.getTableSpace()));
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(unique.getLogging())) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(unique.getLogging())) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (unique.getIndexSort().equalsIgnoreCase("NO")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOSORT");
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (unique.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    }
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "REVERSE");
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SORT");
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (unique.getComputeStatistics().equalsIgnoreCase("YES")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                if (this.storageDesign instanceof StorageDesignOraclev11g) {
                    if (unique.getCompress() > 0) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        this.appendStringWithSpace(buffer, unique.getCompress());
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    }
                }
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, (IndexGlobalPartitionsListOraclev10g)unique.getUsingIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g partList = (IndexGlobalPartitionsListOraclev10g)unique.getUsingIndexGlobalPL();
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partList.getGlobalPartColumns()));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
            this.appendStringWithSpace(buffer, partList.getHashPQuantity());
            if (!"".equals(partList.getHashPTableSpaces())) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getHashPTableSpaces()));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
            if (!"".equals(partList.getIOTOverflowHashPTS())) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getIOTOverflowHashPTS()));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer buffer, UniqueOraclev10g unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendHashPartitions(buffer, (IndexGlobalPartitionsListOraclev10g)unique.getUsingIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalIndex(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, (IndexGlobalPartitionsListOraclev10g)pkProxy.getIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g partList = (IndexGlobalPartitionsListOraclev10g)pkProxy.getIndexGlobalPL();
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partList.getGlobalPartColumns()));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
            this.appendStringWithSpace(buffer, partList.getHashPQuantity());
            if (!"".equals(partList.getHashPTableSpaces())) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getHashPTableSpaces()));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
            if (!"".equals(partList.getIOTOverflowHashPTS())) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partList.getIOTOverflowHashPTS()));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer buffer, PKProxyOraclev10g pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "HASH");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendHashPartitions(buffer, (IndexGlobalPartitionsListOraclev10g)pkProxy.getIndexGlobalPL(), prettyPrint);
        }
    }

    private boolean appendHashPartitions(StringBuffer buffer, IndexGlobalPartitionsListOraclev10g partitionList, boolean prettyPrint) {
        boolean result = false;
        IndexHashPartitionSetOraclev10g hashPartitionSet = (IndexHashPartitionSetOraclev10g)((StorageDesignOraclev10g)partitionList.getStorageDesign()).getIndexHashPartitionSet();
        Iterator setIt = hashPartitionSet.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            IndexHashPartitionOraclev10g hashPartition = (IndexHashPartitionOraclev10g)setIt.next();
            if (hashPartition.getIndexGlobalPartList() == null || !hashPartition.getIndexGlobalPartList().toString().equalsIgnoreCase(partitionList.toString())) continue;
            if (first) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (hashPartition.getTableSpace() != null) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
                }
                if (hashPartition.getOverflowTableSpace() != null) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getOverflowTableSpace()));
                }
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, IndexHashPartitionOraclev10g hashPartition, boolean prettyPrint) {
        IndexHashPartitionLobItemSetOraclev10g hashPLobItemSet = (IndexHashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)hashPartition.getStorageDesign()).getIndexHashPartitionLobItemSet();
        for (IndexHashPartitionLobItemOraclev10g hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getIndexHashPartition() == null || !hashPLobItem.getIndexHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendGlobalPartitions(StringBuffer buffer, IndexGlobalPartitionsListOraclev10g globalPartitionList, boolean prettyPrint) {
        IndexGlobalPartitionSetOraclev10g globalPartitionSet = (IndexGlobalPartitionSetOraclev10g)((StorageDesignOraclev10g)globalPartitionList.getStorageDesign()).getIndexGlobalPartitionSet();
        Object[] globalPartitionsList = globalPartitionSet.toArray();
        Arrays.sort(globalPartitionsList, new GlobalPossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < globalPartitionsList.length; ++i) {
            sortedList.add(globalPartitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            IndexGlobalPartitionOraclev10g globalPartition = (IndexGlobalPartitionOraclev10g)setIt.next();
            if (globalPartition.getIndexGlobalPartList() == null || !globalPartition.getIndexGlobalPartList().toString().equalsIgnoreCase(globalPartitionList.toString())) continue;
            if (first) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!globalPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition));
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALUES LESS THAN");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, globalPartition.getValueList());
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (globalPartition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev10g)globalPartition.getSegment(), false, prettyPrint, globalPartition.getTableSpace(), globalPartition.getLogging());
                continue;
            }
            if (globalPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition.getTableSpace()));
            }
            if (!this.storageDesign.isOpen() || !this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(globalPartition.getLogging())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(globalPartition.getLogging())) continue;
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendPartitionList(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        PartitionListOraclev10g partitionList = (PartitionListOraclev10g)tableProxy.getPartitionList();
        if (partitionList != null) {
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOracle)tableProxy.getStorageDesign();
            }
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType) || "COMPOSITE BY HASH".equalsIgnoreCase(partitionType) || "COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "RANGE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                if (subpartitionType.equalsIgnoreCase("HASH")) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "HASH");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                    if ("NO".equals(partitionList.getUseSubpartStorageTemplate())) {
                        if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                            this.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                            if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                            }
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "1");
                        }
                    } else {
                        this.appendHashSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                    }
                } else if (subpartitionType.equalsIgnoreCase("LIST")) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LIST");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                    this.appendListSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                }
                boolean composite = !subpartitionType.equalsIgnoreCase("");
                this.appendPartitions(buffer, partitionList, true, composite, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "HASH");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
                this.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                if (!"".equals(partitionList.getHashPTableSpaces())) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "HASH");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendHashPartitions(buffer, tableProxy, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LIST");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendListPartitions(buffer, tableProxy, partitionList, prettyPrint);
            }
        }
    }

    protected void appendListSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        StorageObjectCollection templates = tableProxy.getListStorageTemplates();
        if (templates.size() > 0) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TEMPLATE");
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < templates.size(); ++i) {
                ListStorageTemplatePartitionOraclev10g temp = (ListStorageTemplatePartitionOraclev10g)templates.getElement(i);
                if (i > 0) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!temp.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(temp));
                }
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALUES");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                if (!"".equalsIgnoreCase(temp.getValueList())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, temp.getValueList());
                } else {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                }
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, temp, prettyPrint);
            }
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendHashSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        if (tableProxy.getListStorageTemplates().size() > 0) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TEMPLATE");
            Iterator setIt = tableProxy.getListStorageTemplates().iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                HashPartitionOraclev10g partition = (HashPartitionOraclev10g)setIt.next();
                if (first) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                this.appendPartStorage(buffer, partition, prettyPrint);
            }
            if (!first) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendPartStorage(StringBuffer buffer, AbstractStorageObjectOracle template, boolean prettyPrint) {
        TableSpaceOracle tableSpace = null;
        ModelIDObject overflowTableSpace = null;
        String dataSegmentCompression = "";
        StorageObjectCollection lobs = null;
        AbstractStorageObjectOracle owningPartition = null;
        if (template instanceof PartitionOraclev11g) {
            tableSpace = ((PartitionOraclev11g)template).getTableSpace();
            dataSegmentCompression = ((PartitionOraclev11g)template).getDataSegmentCompression();
            lobs = ((PartitionOraclev11g)template).getLobs();
            owningPartition = ((PartitionOraclev11g)template).getSubPartitionOf();
        } else if (template instanceof HashPartitionOraclev10g) {
            tableSpace = ((HashPartitionOraclev10g)template).getTableSpace();
            lobs = ((HashPartitionOraclev10g)template).getLobs();
            owningPartition = ((HashPartitionOraclev10g)template).getSubPartitionOf();
        } else if (template instanceof ListStorageTemplatePartitionOraclev10g) {
            tableSpace = ((ListStorageTemplatePartitionOraclev10g)template).getTablespace();
            dataSegmentCompression = ((ListStorageTemplatePartitionOraclev10g)template).getDataSegmentCompression();
            lobs = ((ListStorageTemplatePartitionOraclev10g)template).getLobs();
            owningPartition = ((ListStorageTemplatePartitionOraclev10g)template).getSubPartitionOf();
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            if (tableSpace != null) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (overflowTableSpace != null) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
            }
        }
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            if (dataSegmentCompression.equalsIgnoreCase("NO")) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (dataSegmentCompression.equalsIgnoreCase("YES")) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
        }
        if (lobs != null) {
            for (Object storageObject : lobs) {
                HashPartitionLobItemOraclev10g lobItem;
                if (storageObject instanceof LobStorageOraclev10g) {
                    LobStorageOraclev10g lobStorage = (LobStorageOraclev10g)storageObject;
                    if (lobStorage.getTableSpace() == null && lobStorage.getLobSegmentName().trim().equals("")) continue;
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    this.appendLobPartitioningStorage(buffer, lobStorage, lobStorage.getColumn(), lobStorage.getLobSegmentName(), lobStorage.getTableSpace(), prettyPrint);
                    continue;
                }
                if (!(storageObject instanceof HashPartitionLobItemOraclev10g) || (lobItem = (HashPartitionLobItemOraclev10g)storageObject).getTableSpace() == null) continue;
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                String lobSegName = lobItem.getName();
                if (owningPartition != null && (lobSegName.startsWith("SYS_LOB") || lobSegName.startsWith(lobItem.getIDPrefix()))) {
                    lobSegName = "";
                }
                this.appendLobPartitioningStorage(buffer, lobItem, lobItem.getLobColumn(), lobSegName, lobItem.getTableSpace(), prettyPrint);
            }
        }
    }

    protected void appendListPartitions(StringBuffer buffer, TableProxyOraclev10g tableProxy, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        Iterator it = tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Table table;
            ListPartitionOraclev10g partition = (ListPartitionOraclev10g)it.next();
            if (first) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALUES");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            if (!"".equalsIgnoreCase(partition.getColumns())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, partition.getColumns());
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (partition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev10g)partition.getSegment(), true, prettyPrint, partition.getTablespace(), partition.getLogging());
            }
            if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (partition.getSegment() == null) {
                if (partition.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTablespace()));
                }
                if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if (partition.getLogging().equalsIgnoreCase("YES")) {
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                    } else if (partition.getLogging().equalsIgnoreCase("NO")) {
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            if (!(table = (Table)tableProxy.getObject()).isSpatialTable()) {
                for (LobStorageOracle lob : partition.getLobStorages()) {
                    this.appendLobStorage(buffer, (LobStorageOraclev10g)lob, prettyPrint);
                }
            }
            if (partitionList.getSubpartitionType().length() <= 0) continue;
            this.appendSubPartitions(buffer, partition, partitionList, prettyPrint);
        }
        if (!first) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, boolean appendValueList, boolean composite, boolean prettyPrint) {
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)partitionList.getTable();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        if (partitions.size() > 0) {
            Object[] partitionsList = partitions.toArray();
            Arrays.sort(partitionsList, new PossitionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < partitionsList.length; ++i) {
                sortedList.add(partitionsList[i]);
            }
            Iterator setIt = sortedList.iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                Table table;
                Object partitionObj = setIt.next();
                if (!(partitionObj instanceof PartitionOracle)) continue;
                PartitionOracle partition = (PartitionOracle)partitionObj;
                if (first) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                if (appendValueList) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, partition.getValueList());
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if (partition.getSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev10g)partition.getSegment(), true, prettyPrint, partition.getTableSpace(), partition.getLogging());
                } else {
                    if (partition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTableSpace()));
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if (partition.getLogging().equalsIgnoreCase("NO")) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                        } else if (partition.getLogging().equalsIgnoreCase("YES")) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                        }
                    }
                }
                if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                }
                SegmentOracle overflowSegment = partition.getIOTOverflowSegment();
                if (overflowSegment != null) {
                    TableSpaceOracle overflowTableSpace = overflowSegment.getTableSpace();
                    if (overflowTableSpace == null) {
                        overflowTableSpace = partition.getTableSpace();
                    }
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    this.appendSegment(buffer, (SegmentOraclev10g)overflowSegment, true, prettyPrint, overflowTableSpace, partition.getLogging());
                }
                if (!(table = (Table)this.tableObj.getObject()).isSpatialTable()) {
                    for (LobStorageOracle lob : partition.getLobs()) {
                        this.appendLobStorage(buffer, (LobStorageOraclev10g)lob, prettyPrint);
                    }
                }
                if (!composite) continue;
                this.appendSubPartitions(buffer, partition, partitionList, prettyPrint);
            }
            if (!first) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendSubPartitions(StringBuffer buffer, AbstractStorageObjectOracle partition, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        if (partitionList.getSubpartitionType().equalsIgnoreCase("HASH")) {
            PartitionOraclev10g rangePartition;
            if (partition instanceof PartitionOraclev10g && !this.appendHashSubPartitions(buffer, (rangePartition = (PartitionOraclev10g)partition).getPartitions(), partitionList, prettyPrint) && rangePartition.getSubPartitionsQuantity() > 0) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                this.appendStringWithSpace(buffer, rangePartition.getSubPartitionsQuantity());
                if (!"".equalsIgnoreCase(rangePartition.getSubPartitionsTableSpaces())) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(rangePartition.getSubPartitionsTableSpaces()));
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("LIST") && partition instanceof PartitionOraclev10g) {
            this.appendListSubPartitions(buffer, ((PartitionOraclev10g)partition).getListPartitions(), prettyPrint);
        }
    }

    protected void appendListSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, boolean prettyPrint) {
        if (subpartitions.size() > 0) {
            boolean firstListPart = true;
            Iterator listSubpartitions = subpartitions.iterator();
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            while (listSubpartitions.hasNext()) {
                ListStorageTemplatePartitionOraclev10g listSubpartition = (ListStorageTemplatePartitionOraclev10g)listSubpartitions.next();
                if (!firstListPart) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                } else {
                    firstListPart = false;
                }
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!listSubpartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(listSubpartition));
                }
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALUES");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, listSubpartition.getValueList());
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, listSubpartition, prettyPrint);
            }
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected boolean appendHashSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        boolean result = false;
        if (!partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("YES")) {
            Iterator it = subpartitions.iterator();
            boolean first = true;
            while (it.hasNext()) {
                HashPartitionOraclev10g hashPartition = (HashPartitionOraclev10g)it.next();
                if (first) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                    result = true;
                } else {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ' ');
                }
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
                }
                this.appendPartStorage(buffer, hashPartition, prettyPrint);
            }
            if (!first) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
        return result;
    }

    protected boolean appendHashPartitions(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        boolean result = false;
        Iterator it = tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            HashPartitionOraclev10g hashPartition = (HashPartitionOraclev10g)it.next();
            if (first) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ',');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, HashPartitionOraclev10g hashPartition, boolean prettyPrint) {
        HashPartitionLobItemSetOraclev10g hashPLobItemSet = (HashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)hashPartition.getStorageDesign()).getHashPartitionLobItemSet();
        for (HashPartitionLobItemOraclev10g hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getHashPartition() == null || !hashPLobItem.getHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, Object column, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOB");
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
        if (column instanceof ColumnProxy) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((ColumnProxy)column));
        } else {
            String columnName = "";
            if (column != null) {
                columnName = column.toString();
            }
            if (columnName.length() > 0) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnName));
            } else {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("--  ERROR: Lob ");
                buffer.append(lobObject.getName());
                buffer.append(" has no Column specified");
                CDDLFileMaker.incrementErrors();
            }
        }
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
        if (lobObject instanceof LobStorageOraclev11g) {
            String lobStorageType = ((LobStorageOraclev11g)lobObject).getLobStorageType();
            if (lobStorageType.equalsIgnoreCase("SECUREFILE")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
            } else if (lobStorageType.equalsIgnoreCase("BASICFILE")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
            }
        }
        if (!lobSegName.equalsIgnoreCase("")) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendLobStorage(StringBuffer buffer, LobStorageOraclev10g lobStorage, boolean prettyPrint) {
        if (lobStorage != null) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOB");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getColumn()));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE AS");
            if (lobStorage instanceof LobStorageOraclev11g) {
                if (lobStorage.getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                } else if (lobStorage.getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                }
            }
            if (!lobStorage.getLobSegmentName().equalsIgnoreCase("")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getLobSegmentName()));
            }
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (lobStorage.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (lobStorage.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, lobStorage.getSCInitialExtent());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (lobStorage.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, lobStorage.getSCNextExtent());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, lobStorage.getSCPctIncrease());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCMinExtents());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCMaxExtents());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCFreeLists());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && lobStorage.getSCFreelistGroups() > 1) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCFreelistGroups());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getSCBufferPool());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (props) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getChunk() > 0) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CHUNK");
                this.appendStringWithSpace(buffer, lobStorage.getChunk());
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getOldVersions().equalsIgnoreCase("RETENTION")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "RETENTION");
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PCTVERSION");
                this.appendStringWithSpace(buffer, lobStorage.getPCTVersion());
            }
            if (lobStorage.getFreepools() > 0 && lobStorage.getSCFreelistGroups() <= 1) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                this.appendStringWithSpace(buffer, lobStorage.getFreepools());
            }
            this.appendStorageInRow(buffer, this.tableProxy, lobStorage.getStorageInRow(), prettyPrint);
            if (this.isSecureFile(lobStorage.getLobStorageType())) {
                if (lobStorage.getCompression().equalsIgnoreCase("YES")) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getCompressionType());
                }
                if (lobStorage.getDuplication().equalsIgnoreCase("DEDUPLICATE")) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEDUPLICATE");
                }
            }
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, lobStorage.getCache());
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && (!"CACHE".equalsIgnoreCase(lobStorage.getCache()) || this.storageDesign instanceof StorageDesignOraclev12c)) {
                String logging = lobStorage.getLogging();
                if (logging.equalsIgnoreCase("YES")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                } else if (logging.equalsIgnoreCase("NO")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else if (logging.equalsIgnoreCase("FILESYSTEM_LIKE_LOGGING") && this.isSecureFile(lobStorage.getLobStorageType())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FILESYSTEM_LIKE_LOGGING");
                }
            }
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOraclev10g segment, boolean pctUsed, boolean prettyPrint, TableSpaceOracle tableSpace, String logging) {
        if (segment != null) {
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PCTFREE");
                    this.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (pctUsed && this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PCTUSED");
                    this.appendStringWithSpace(buffer, segment.getPCTUsed());
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                    if (segment.getInitrans() > 1) {
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                        this.appendStringWithSpace(buffer, segment.getInitrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "1");
                    }
                    if (!(this.storageDesign instanceof StorageDesignOraclev11g)) {
                        if (segment.getMaxTrans() > 1) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                            this.appendStringWithSpace(buffer, segment.getMaxTrans());
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "255");
                        }
                    }
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (tableSpace != null) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
                } else if (segment.getTableSpace() != null) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(segment.getTableSpace()));
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && !"".equals(logging)) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                if (logging.equalsIgnoreCase("NO")) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                boolean props = false;
                if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, segment.getSCNextExtent());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, segment.getSCMinExtents());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, segment.getSCFreeLists());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, segment.getSCBufferPool());
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    props = true;
                }
                if (props) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
        }
    }

    private void appendOrganization(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        boolean indexOrg = "INDEX".equalsIgnoreCase(tableProxy.getOrganization());
        if (indexOrg) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ORGANIZATION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INDEX");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL() && !((Table)tableProxy.getObject()).isBST()) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ORGANIZATION");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "HEAP");
        }
        if (tableProxy.getSegment() != null) {
            this.appendSegment(buffer, (SegmentOraclev10g)tableProxy.getSegment(), !indexOrg, prettyPrint, tableProxy.getTableSpace(), tableProxy.getLogging());
        } else {
            TableSpaceOracle tableSpace;
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL() && (tableSpace = tableProxy.getTableSpace()) != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName())) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(tableProxy.getLogging())) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(tableProxy.getLogging())) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
        }
        if (indexOrg) {
            if (tableProxy.getIOTMappingTable().equalsIgnoreCase("YES")) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MAPPING TABLE");
            }
            if (tableProxy.getIotPctThreshold() > 0) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                this.appendStringWithSpace(buffer, tableProxy.getIotPctThreshold());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "50");
            }
            if (tableProxy.getIotCompress() > 0) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                this.appendStringWithSpace(buffer, tableProxy.getIotCompress());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            TableSpaceOracle overflowTableSpace = tableProxy.getIotOverflowTablespace();
            String overflowLogging = tableProxy.getIotOverflowLogging();
            SegmentOraclev10g overflowSegment = (SegmentOraclev10g)tableProxy.getIotOverflowSegment();
            ColumnProxy includingColumn = tableProxy.getIotIncluding();
            if (overflowTableSpace != null || !overflowLogging.equals("") || overflowSegment != null || includingColumn != null) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                if (includingColumn != null) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INCLUDING");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(includingColumn));
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                }
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                if (overflowTableSpace == null) {
                    overflowTableSpace = tableProxy.getTableSpace();
                }
                if (overflowLogging.equals("")) {
                    overflowLogging = tableProxy.getLogging();
                }
                if (overflowSegment != null) {
                    this.appendSegment(buffer, overflowSegment, true, prettyPrint, overflowTableSpace, overflowLogging);
                } else {
                    if (overflowTableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("NO".equalsIgnoreCase(overflowLogging)) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                        } else if ("YES".equalsIgnoreCase(overflowLogging)) {
                            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                        }
                    }
                }
            }
        } else {
            if (tableProxy.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                if (tableProxy instanceof TableProxyOraclev11g) {
                    String compressionType = ((TableProxyOraclev11g)tableProxy).getCompressionType();
                    if (compressionType.length() == 0) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    } else if (this.storageDesign instanceof StorageDesignOraclev12c) {
                        if (compressionType.equals("BASIC") || compressionType.equals("ADVANCED")) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ROW");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        } else {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "STORE");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FOR");
                        }
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, compressionType);
                    } else {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                        if (!compressionType.equals("BASIC")) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "FOR");
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, compressionType);
                        }
                    }
                }
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (tableProxy instanceof TableProxyOraclev12c) {
                TableProxyOraclev12c tableProxy12c = (TableProxyOraclev12c)tableProxy;
                String inMemory = tableProxy12c.getInMemory();
                if (inMemory.equals("YES")) {
                    String inMemoryDuplicate;
                    String inMemoryDistribute;
                    String inMemoryPriority;
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INMEMORY");
                    String inMemoryCompression = tableProxy12c.getInMemoryCompression();
                    if (!inMemoryCompression.isEmpty()) {
                        if (!inMemoryCompression.equals("NO MEMCOMPRESS")) {
                            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MEMCOMPRESS");
                        }
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, inMemoryCompression);
                    }
                    if (!(inMemoryPriority = tableProxy12c.getInMemoryPriority()).isEmpty()) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PRIORITY");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, inMemoryPriority);
                    }
                    if (!(inMemoryDistribute = tableProxy12c.getInMemoryDistribute()).isEmpty()) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DISTRIBUTE");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, inMemoryDistribute);
                    }
                    if (!(inMemoryDuplicate = tableProxy12c.getInMemoryDuplicate()).isEmpty()) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, inMemoryDuplicate);
                    }
                } else if (inMemory.equals("NO")) {
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NO");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INMEMORY");
                }
            }
        }
    }

    private void appendCluster(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        ClusterOraclev10g cluster = (ClusterOraclev10g)tableProxy.getCluster();
        if (cluster != null) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CLUSTER");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            if (!"".equalsIgnoreCase(tableProxy.getClusterColumns())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getClusterColumns()));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            }
        } else {
            this.appendOrganization(buffer, tableProxy, prettyPrint);
            Table table = (Table)this.tableObj.getObject();
            if (!table.isSpatialTable()) {
                for (int i = 0; i < tableProxy.getLobStorages().size(); ++i) {
                    this.appendLobStorage(buffer, (LobStorageOraclev10g)tableProxy.getLobStorages().getElement(i), prettyPrint);
                }
            }
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComments = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)tableProxy.getStorageDesign()).getPermissionsSet();
        for (PermissionsOraclev10g permissions : permissionsSet) {
            if (permissions.getTable() != null && permissions.getTable().equals(tableProxy)) {
                if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                    CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivileges(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                }
                if (!permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                    CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivilegesWithGrantOption(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    this.appendGrantOption(buffer, permissions);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                }
            }
            if (permissions.getColumnsTable() == null || !permissions.getColumnsTable().equals(tableProxy)) continue;
            for (int i = 0; i < 2; ++i) {
                List<String> colEntries = i == 0 ? permissions.getColumnEntries() : permissions.getColumnWithGrantOptionEntries();
                block2: for (String colEntry : colEntries) {
                    int commaIndex = colEntry.indexOf(44);
                    if (commaIndex <= -1) continue;
                    String colName = colEntry.substring(0, commaIndex).trim();
                    String colPriv = colEntry.substring(commaIndex + 1).trim();
                    if (colName.length() <= 0 || colPriv.length() <= 0) continue;
                    List columns = this.tableObj.getChildObjects(0);
                    for (CompareObjectSelection columnSel : columns) {
                        ModelIDObject column = columnSel.getObject();
                        if (column == null || !column.getName().equals(colName)) continue;
                        if (columnSel.canBeCreate() && !columnSel.isSelected()) continue block2;
                        CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                        CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "GRANT");
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, colPriv);
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, CSSBCreateTableOraclev10g.getFormattedSelectedName(columnSel, this.storageDesign));
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
                        this.appendObject(buffer, permissions, prettyPrint);
                        this.appendTo(buffer, permissions, this.storageDesign);
                        if (i > 0) {
                            this.appendGrantOption(buffer, permissions);
                        }
                        advancedComments = buffer.toString();
                        this.appendToBuffer(oldbuffer, buffer, advancedComments);
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        buffer.append(';');
                        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, advancedComments);
                        continue block2;
                    }
                }
            }
        }
    }

    private String getPermissionsTO(PermissionsOraclev10g permissions) {
        if (permissions.getUser() != null) {
            return permissions.getUser().getName();
        }
        if (permissions.getRole() != null) {
            return permissions.getRole().getName();
        }
        return "";
    }

    private String getPermissionsON(PermissionsOraclev10g permissions) {
        if (permissions.getTable() != null) {
            return permissions.getTable().getLongNameDDL();
        }
        if (permissions.getColumnsTable() != null) {
            return permissions.getColumnsTable().getLongNameDDL();
        }
        return "";
    }

    private void appendPrivileges(StringBuffer buffer, PermissionsOraclev10g permissions) {
        buffer.append(permissions.getPrivileges());
    }

    private void appendPrivilegesWithGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        buffer.append(permissions.getPrivilegesWithGrantOption());
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        TableProxyOracle tableProxy = permissions.getTable();
        if (tableProxy == null) {
            tableProxy = permissions.getColumnsTable();
        }
        if (tableProxy != null) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ON");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if (permissions.getRole() == null) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    private void appendIndexes(StringBuffer oldbuffer, TableProxyOracle tableProxy, CompareObjectSelection engObject, boolean prettyPrint) {
        this.appendIndexes(oldbuffer, engObject, tableProxy, prettyPrint);
        this.appendPKAndUK(oldbuffer, engObject, prettyPrint);
    }

    private void appendIndexes(StringBuffer oldbuffer, CompareObjectSelection table, TableProxyOracle tableProxy, boolean prettyPrint) {
        List chIndexes = table.getChildObjects(1);
        for (CompareObjectSelection index : chIndexes) {
            Index theIndex;
            if (index.canBeCreate() && !index.isSelected() || (theIndex = (Index)index.getObject()) == null) continue;
            StringBuffer columnList = this.getColumnsForRestore(table, theIndex, prettyPrint, true);
            CSSBIndexOraclev10g cssbIndex = this.getCSSBIndex();
            cssbIndex.setRenamed(this.isRenamed());
            cssbIndex.setRestoredColumns(columnList);
            cssbIndex.setRestoredExpression(theIndex.getIndexExpression());
            cssbIndex.setTableName(this.storageDesign.getFormatedLongNameDDL(tableProxy));
            cssbIndex.doAppend(oldbuffer, theIndex, prettyPrint);
        }
    }

    private void appendPKAndUK(StringBuffer oldbuffer, CompareObjectSelection table, boolean prettyPrint) {
        TableComparator comp = (TableComparator)table.getPropertiesComparator();
        Table sourceTable = comp.getSourceTable();
        TableProxyOraclev10g sourceTableProxy = (TableProxyOraclev10g)comp.getSourceTableProxy();
        List chIndexes = table.getChildObjects(2);
        for (CompareObjectSelection index : chIndexes) {
            StringBuffer columnList;
            if (index.canBeCreate() && !index.isSelected() || ((Index)index.getObject()).isOidKey()) continue;
            if (((Index)index.getObject()).isPK() && index.isSelected() && sourceTable.getBasedOnStructuredType() == null && !"INDEX".equalsIgnoreCase(sourceTableProxy.getOrganization())) {
                columnList = this.getColumnsForRestore(table, (Index)index.getObject(), prettyPrint, false);
                if (this.isNotEmpty(columnList.toString())) {
                    this.appendPKDefinition(oldbuffer, sourceTableProxy, (Index)index.getObject(), columnList, prettyPrint);
                } else {
                    this.appendError(oldbuffer, prettyPrint, "Index " + index.getObject().toString() + " without columns");
                }
            }
            if (!((Index)index.getObject()).isUnique() || !index.isSelected()) continue;
            columnList = this.getColumnsForRestore(table, (Index)index.getObject(), prettyPrint, false);
            if (this.isNotEmpty(columnList.toString())) {
                UniqueOraclev10g unique = (UniqueOraclev10g)sourceTableProxy.getUniqueKeys().getObjectByID(index.getObject().getObjectID());
                this.appendUniqueDefinition(oldbuffer, sourceTableProxy, unique, prettyPrint, columnList);
                continue;
            }
            this.appendError(oldbuffer, prettyPrint, "Index " + index.getObject().toString() + " without columns");
        }
    }

    private void appendError(StringBuffer oldbuffer, boolean prettyPrint, String errorMsg) {
        CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: ");
        CSSBCreateTableOraclev10g.appendString(oldbuffer, errorMsg);
        CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CDDLFileMaker.incrementErrors();
    }

    private void appendColumnCheckConstraints(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        ColumnProxy[] cols_pr = tableProxy.getColumnAndNestedColumnProxies();
        for (int i = 0; i < cols_pr.length; ++i) {
            ColumnProxy columnProxy = cols_pr[i];
            Column column = columnProxy.getColumn();
            if (!column.shouldBeMerge() || !column.hasConstraintsDefinedForDDL() || !column.isGenerateConstraintInDDL() || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) continue;
            String text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy));
            String cname = column.getConstraintName();
            if (cname.toUpperCase().startsWith("SYS_")) {
                cname = "";
            }
            if (cname.length() > tableProxy.getMaxNameLength()) {
                CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Column constraint name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementErrors();
            }
            if ("".equals(text)) continue;
            String formattedLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
            CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, formattedLongName);
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!"".equals(cname)) {
                cname = this.storageDesign.getFormatedName(cname);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, cname);
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CHECK");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBCreateTableOraclev10g.appendString(buffer, text);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBCreateTableOraclev10g.appendConstraintState(buffer, (ColumnProxyOracle)columnProxy, prettyPrint);
            String advancedComments = "Alter Table " + formattedLongName + " Add Constraint " + cname;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            CDDLFileMaker.incrementAlterTable();
        }
    }

    private void appendTableLevelCheckConstraints(StringBuffer oldbuffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        for (TableCheckConstraintOracle constraint : tableProxy.getTableCheckConstraints()) {
            TableLevelConstraint tlc = constraint.getTableConstraint();
            if (!tlc.shouldBeMerge() || !tlc.isGenerateInDDL()) continue;
            String rule = tlc.getRule();
            String cname = constraint.getName().toUpperCase();
            if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                cname = "";
            }
            if ("".equals(cname) || "".equals(rule)) continue;
            CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            if (cname.length() > tableProxy.getMaxNameLength()) {
                CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Table constraint name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementErrors();
            }
            String formatedConstraintName = this.storageDesign.getFormatedName(constraint);
            String formattedLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, formattedLongName);
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!"".equals(cname)) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, formatedConstraintName);
            }
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CHECK");
            CSSBCreateTableOraclev10g.appendString(buffer, '(');
            CSSBCreateTableOraclev10g.appendString(buffer, rule);
            CSSBCreateTableOraclev10g.appendString(buffer, ')');
            this.appendTableConstraintState(buffer, constraint, prettyPrint);
            String advancedComments = "Alter Table " + formattedLongName + " Add Constraint " + formatedConstraintName;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            CDDLFileMaker.incrementAlterTable();
        }
    }

    private StringBuffer getColumnsForRestore(CompareObjectSelection engObject, Index index, boolean prettyPrint, boolean getColumnSortOrder) {
        StringBuffer columnList = new StringBuffer();
        boolean notFirst = false;
        List sourceColumns = engObject.getChildObjects(0);
        block0: for (Column indexCol : index.getElementsCollection()) {
            for (CompareObjectSelection tableCol : sourceColumns) {
                ModelIDObject column = tableCol.getObject();
                if (column == null || !column.equals(indexCol)) continue;
                if (tableCol.canBeCreate() && !tableCol.isSelected() || tableCol.canBeDrop() && tableCol.getCorrespondentNode().isSelected()) continue block0;
                if (notFirst) {
                    columnList.append(',');
                    CSSBCreateTableOraclev10g.appendNewLine(columnList, prettyPrint, 1);
                    columnList.append(' ');
                }
                String formattedColumnName = tableCol.isSelected() ? CSSBCreateTableOraclev10g.getFormattedSelectedName(tableCol, this.storageDesign) : this.storageDesign.getFormatedName(tableCol.getCorrespondentNode().getObject());
                CSSBCreateTableOraclev10g.appendStringWithSpace(columnList, formattedColumnName);
                if (getColumnSortOrder) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(columnList, index.getColumnSortOrder(tableCol.getObject()));
                }
                notFirst = true;
                continue block0;
            }
        }
        return columnList;
    }

    private void appendPKDefinition(StringBuffer oldbuffer, TableProxyOraclev10g tableProxy, Index index, StringBuffer columnList, boolean prettyPrint) {
        Index pkInd;
        PKProxyOraclev10g pk;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (!(tableProxy == null || (pk = this.getPKProxy(tableProxy)) == null || pk.getObject() != index || !(pkInd = pk.getIndex()).shouldBeMerge() && !this.isRenamed() || this.hasNoMergeColumns(pkInd.getElements()) || "".equalsIgnoreCase(pk.getColumns()) && "".equals(pkInd.getIndexExpression()))) {
            CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            if (pk.isCommentChanged() && !"".equalsIgnoreCase(pk.getComment())) {
                this.appendComment(oldbuffer, pk);
            } else if (!"".equalsIgnoreCase(pk.getObject().getComment())) {
                this.appendComment(oldbuffer, pk.getObject());
            }
            String pkName = pk.getName();
            if (pkName.length() > tableProxy.getMaxNameLength()) {
                CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementErrors();
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!pkName.startsWith("SYS_")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            }
            advancedComment = buffer.toString();
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
            if (!"".equals(pkInd.getIndexExpression())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, pkInd.getIndexExpression());
            } else {
                this.appendStringWithSpace(buffer, columnList);
            }
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
            if (!"NO".equalsIgnoreCase(pk.getDeferrable())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(pk.getInitially())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOT");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            }
            if (!"NO".equalsIgnoreCase(pk.getUsingIndex())) {
                this.appendUsingIndex(buffer, pk, tableProxy, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.appendLineFinisher(buffer, prettyPrint);
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
            if (pk.getRely().equals("YES")) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                advancedComment = buffer.toString();
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "RELY");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
            }
            if (pk.getExceptionsTable() != null && "YES".equalsIgnoreCase(pk.getEnable())) {
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                advancedComment = buffer.toString();
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pk.getExceptionsTable()));
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer oldbuffer, TableProxyOracle tableProxy, UniqueOraclev10g unique, boolean prettyPrint, StringBuffer columnList) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        if (unique.isCommentChanged() && !"".equalsIgnoreCase(unique.getComment())) {
            this.appendComment(oldbuffer, unique);
        } else if (!"".equalsIgnoreCase(unique.getObject().getComment())) {
            this.appendComment(oldbuffer, unique.getObject());
        }
        String uniqueName = unique.getName();
        if (uniqueName.length() > tableProxy.getMaxNameLength()) {
            CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateTableOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
            CSSBCreateTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CDDLFileMaker.incrementErrors();
        }
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ADD");
        if (!uniqueName.startsWith("SYS_")) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
        }
        advancedComment = buffer.toString();
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "UNIQUE");
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, '(');
        this.appendString(buffer, columnList);
        CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, ')');
        if (!"NO".equalsIgnoreCase(unique.getDeferrable())) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(unique.getInitially())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOT");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (!"NO".equalsIgnoreCase(unique.getUsingIndex())) {
            this.appendUniqueUsingIndex(buffer, unique, tableProxy, prettyPrint);
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(unique.getEnable())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(unique.getValidate())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(unique.getEnable())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(unique.getValidate())) {
                    CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(unique.getValidate())) {
                CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendLineFinisher(buffer, prettyPrint);
        CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CDDLFileMaker.incrementAlterTable();
        if (unique.getRely().equals("YES")) {
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
            advancedComment = buffer.toString();
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "RELY");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
        }
        if (unique.getExceptionsTable() != null && "YES".equalsIgnoreCase(unique.getEnable())) {
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            advancedComment = buffer.toString();
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "MODIFY");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
            CSSBCreateTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExceptionsTable()));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
        }
    }

    private boolean isRenamed() {
        return false;
    }

    private void appendBitmapJoinIndexes(StringBuffer oldbuffer, TableProxyOraclev10g sourceProxy, boolean prettyPrint) {
        for (Object object : sourceProxy.getBjIndexes()) {
            BitmapJoinIndexOraclev10g index;
            if (this.ssbBJIndex == null) {
                this.ssbBJIndex = new SSBCreateBitmapJoinIndexOraclev10g();
            }
            if ((index = (BitmapJoinIndexOraclev10g)object).getIndexColumnSet().size() <= 0 || !this.ssbBJIndex.canHandle(object)) continue;
            this.ssbBJIndex.doAppendBJIndex(oldbuffer, object, prettyPrint);
        }
    }

    private void appendAutoIncTriggers(StringBuffer oldbuffer, TableProxyOraclev10g sourceProxy, boolean prettyPrint) {
        Table table = (Table)sourceProxy.getObject();
        for (Column column : table.getElementsCollection()) {
            if (!column.isAutoIncrementColumn()) continue;
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(oldbuffer, column, prettyPrint);
        }
    }

    protected CSSBIndexOraclev10g getCSSBIndex() {
        if (this.cssbIndex == null) {
            this.cssbIndex = new CSSBIndexOraclev10g();
            this.cssbIndex.setStorageDesign((StorageDesignOraclev10g)this.storageDesign);
        }
        return this.cssbIndex;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOraclev10g)one).getPosition() > ((PartitionOraclev10g)two).getPosition()) {
                return 1;
            }
            if (((PartitionOraclev10g)one).getPosition() < ((PartitionOraclev10g)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    static class GlobalPossitionComparator
    implements Comparator {
        GlobalPossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((IndexGlobalPartitionOraclev10g)one).getPosition() > ((IndexGlobalPartitionOraclev10g)two).getPosition()) {
                return 1;
            }
            if (((IndexGlobalPartitionOraclev10g)one).getPosition() < ((IndexGlobalPartitionOraclev10g)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

