/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBDropTableView
extends AbstractCSSBOracle {
    private StorageDesignOracle storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableView targetView = (TableView)((CompareObjectSelection)object).getCorrespondentNode().getObject();
        Design design = targetView.getDesign();
        RDBMSSite site = targetView.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site);
        this.apppendDropView(buffer, targetView, prettyPrint);
    }

    private void apppendDropView(StringBuffer oldbuffer, TableView targetView, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        TableViewProxyOracle viewProxy = (TableViewProxyOracle)this.storageDesign.getTableViewProxySet().getProxy(targetView.getObjectID());
        if (viewProxy != null) {
            CSSBDropTableView.appendNewLine(buffer, prettyPrint, 0);
            CSSBDropTableView.appendStringWithSpace(buffer, "DROP");
            CSSBDropTableView.appendStringWithSpace(buffer, "VIEW");
            CSSBDropTableView.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(viewProxy));
            String advancedComment = buffer.toString();
            CSSBDropTableView.appendStringWithSpace(buffer, "CASCADE");
            CSSBDropTableView.appendStringWithSpace(buffer, "CONSTRAINT");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBDropTableView.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            CSSBDropTableView.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementDropView();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof TableView;
    }
}

