/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;

public class EntityComparator
extends PropertiesComparator {
    private final Entity source;
    private final Entity tatget;
    private CompareCWDDesigns selectionObject;

    public EntityComparator(Entity source, Entity target) {
        super(source, target);
        this.source = source;
        this.tatget = target;
        this.initPropertiesList();
        this.initDynamicProperties();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(TEMP_TABLE_SCOPE);
        ph.setLeftValue(this.source != null ? this.source.getScope() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getScope() : "");
        if (this.isExcludedFromComparison(TEMP_TABLE_SCOPE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getScope().equals(this.tatget.getScope())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SHORT_NAME);
        ph.setLeftValue(this.source != null ? this.source.getShortName() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getShortName() : "");
        if (this.isExcludedFromComparison(SHORT_NAME)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getShortName().equals(this.tatget.getShortName())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(PREFERED_ABBR);
        ph.setLeftValue(this.source != null ? this.source.getPreferredAbbreviation() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getPreferredAbbreviation() : "");
        if (this.isExcludedFromComparison(PREFERED_ABBR)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getPreferredAbbreviation().equals(this.tatget.getPreferredAbbreviation())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SYNONYMS);
        ph.setLeftValue(this.source != null ? this.source.getSynonym() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getSynonym() : "");
        if (this.isExcludedFromComparison(SYNONYMS)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getSynonym().equals(this.tatget.getSynonym())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SYNONYM_TO_DISPLAY);
        ph.setLeftValue(this.source != null ? this.source.getSynonymToDisplay() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getSynonymToDisplay() : "");
        if (this.isExcludedFromComparison(SYNONYM_TO_DISPLAY)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getSynonymToDisplay().equals(this.tatget.getSynonymToDisplay())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(TABLE_TYPE);
        ph.setLeftValue(this.source != null ? this.source.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.source.getTypeID()) : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.tatget.getTypeID()) : "");
        if (this.isExcludedFromComparison(TABLE_TYPE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getTypeID().equals(this.tatget.getTypeID())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MIN_VOLUMES);
        ph.setLeftValue(this.source != null ? this.source.getMinVolumes() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getMinVolumes() : "");
        if (this.isExcludedFromComparison(MIN_VOLUMES)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getMinVolumes().equals(this.tatget.getMinVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(EXPECTED_VOLUMES);
        ph.setLeftValue(this.source != null ? this.source.getExpectedVolumes() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getExpectedVolumes() : "");
        if (this.isExcludedFromComparison(EXPECTED_VOLUMES)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getExpectedVolumes().equals(this.tatget.getExpectedVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MAX_VOLUMES);
        ph.setLeftValue(this.source != null ? this.source.getMaxVolumes() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getMaxVolumes() : "");
        if (this.isExcludedFromComparison(MAX_VOLUMES)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getMaxVolumes().equals(this.tatget.getMaxVolumes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(GROWTH_PERCENT);
        ph.setLeftValue(this.source != null ? this.source.getGrowthPercent() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getGrowthPercent() : "");
        if (this.isExcludedFromComparison(GROWTH_PERCENT)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getGrowthPercent().equals(this.tatget.getGrowthPercent())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(GROWTH_TYPE);
        ph.setLeftValue(this.source != null ? this.source.getGrowthType() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getGrowthType() : "");
        if (this.isExcludedFromComparison(GROWTH_TYPE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getGrowthType().equals(this.tatget.getGrowthType())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(NORMAL_FORM);
        ph.setLeftValue(this.source != null ? this.source.getNormalForm() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getNormalForm() : "");
        if (this.isExcludedFromComparison(NORMAL_FORM)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getNormalForm().equals(this.tatget.getNormalForm())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(ADEQUATELY_NORMALIZED);
        ph.setLeftValue(this.source != null ? this.source.getAdequatelyNormalized() : "");
        ph.setRightValue(this.tatget != null ? this.tatget.getAdequatelyNormalized() : "");
        if (this.isExcludedFromComparison(ADEQUATELY_NORMALIZED)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.tatget != null && !this.source.getAdequatelyNormalized().equals(this.tatget.getAdequatelyNormalized())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromEntityToEntity();
    }

    private void copyPropertiesFromEntityToEntity() {
        if (this.source != null && this.tatget != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(TEMP_TABLE_SCOPE)) {
                    this.tatget.setScope(this.source.getScope());
                    continue;
                }
                if (ph.getName().equals(TABLE_TYPE)) {
                    this.tatget.setTypeID(this.source.getTypeID());
                    continue;
                }
                if (ph.getName().equals(STRUCTURED_TYPE)) {
                    this.tatget.setBasedOnStructuredType(this.source.getBasedOnStructuredType());
                    continue;
                }
                if (ph.getName().equals(PREFERED_ABBR)) {
                    this.tatget.setPreferredAbbreviation(this.source.getPreferredAbbreviation());
                    continue;
                }
                if (ph.getName().equals(SHORT_NAME)) {
                    this.tatget.setShortName(this.source.getShortName());
                    continue;
                }
                if (ph.getName().equals(SYNONYMS)) {
                    this.tatget.setSynonym(this.source.getSynonym());
                    continue;
                }
                if (ph.getName().equals(SYNONYM_TO_DISPLAY)) {
                    this.tatget.setSynonymToDisplay(this.source.getSynonymToDisplay());
                    continue;
                }
                if (ph.getName().equals(MIN_VOLUMES)) {
                    this.tatget.setMinVolumes(this.source.getMinVolumes());
                    continue;
                }
                if (ph.getName().equals(EXPECTED_VOLUMES)) {
                    this.tatget.setExpectedVolumes(this.source.getExpectedVolumes());
                    continue;
                }
                if (ph.getName().equals(MAX_VOLUMES)) {
                    this.tatget.setMaxVolumes(this.source.getMaxVolumes());
                    continue;
                }
                if (ph.getName().equals(GROWTH_PERCENT)) {
                    this.tatget.setGrowthPercent(this.source.getGrowthPercent());
                    continue;
                }
                if (ph.getName().equals(GROWTH_TYPE)) {
                    this.tatget.setGrowthType(this.source.getGrowthType());
                    continue;
                }
                if (ph.getName().equals(NORMAL_FORM)) {
                    this.tatget.setNormalForm(this.source.getNormalForm());
                    continue;
                }
                if (ph.getName().equals(ADEQUATELY_NORMALIZED)) {
                    this.tatget.setAdequatelyNormalized(this.source.getAdequatelyNormalized());
                    continue;
                }
                if (!ph.getName().equals(ALLOW_TYPE_SUBSTITUTION)) continue;
                this.tatget.setAllowTypeSubstitution(this.source.isAllowTypeSubstitution());
            }
        }
    }

    public void presetAttributesOrder() {
        EngPropertyHolder ph = this.getPropertyHolderByName(COLUMNS_ORDER);
        if (ph != null) {
            if (this.getLeftSelectionObject() != null) {
                ph.setRightValue(this.tatget != null ? this.getElementsToString(this.tatget) : "");
                CompareCWDDesigns[] nodes = this.getAttributeNodes(this.getSelectionObject());
                ph.setLeftValue(this.source != null ? this.getElementsToString(nodes) : "");
                if (!this.equalAttributesOrderNew(this.source, this.tatget)) {
                    ph.setSelected(true);
                    ph.setModified(true);
                } else {
                    ph.setSelected(false);
                    ph.setModified(false);
                }
            } else {
                ph.setLeftValue(this.source != null ? this.getElementsToString(this.source) : "");
                ph.setRightValue(this.tatget != null ? this.getElementsToString(this.tatget) : "");
                if (!this.equalAttributesOrderNew(this.source, this.tatget)) {
                    ph.setSelected(true);
                    ph.setModified(true);
                }
            }
            if (!this.useColumnsOrder) {
                ph.setSelected(false);
            }
        }
    }

    private boolean isBeforeUnchangedAttribute(int index, CompareCWDDesigns[] attributes) {
        for (int i = index + 1; i < attributes.length; ++i) {
            if (attributes[i].getStatus() != 0) continue;
            return true;
        }
        return false;
    }

    private boolean equalAttributesOrderNew(Entity sourseEntity, Entity targetEntity) {
        if (this.getLeftSelectionObject() != null) {
            CompareCWDDesigns[] aNodes = this.getAttributeNodes(this.getSelectionObject());
            for (int i = 0; i < aNodes.length; ++i) {
                Attribute rAttribute;
                CompareCWDDesigns aNode = aNodes[i];
                if (aNode.getStatus() == 2 && this.isBeforeUnchangedAttribute(i, aNodes)) {
                    return false;
                }
                if (aNode.getStatus() != 0 && aNode.getStatus() != 1 || (rAttribute = (Attribute)aNode.getCorrespondentNode().getObject()) == null || i == rAttribute.getIndex()) continue;
                return false;
            }
            return true;
        }
        return this.equalAttributesOrder(sourseEntity, targetEntity);
    }

    private boolean equalAttributesOrder(Entity sourseEntity, Entity targetEntity) {
        if (sourseEntity == null || targetEntity == null) {
            return true;
        }
        ContainedObject[] sourseAttributes = sourseEntity.getElements();
        ContainedObject[] targetAttributes = targetEntity.getElements();
        for (int i = 0; i < sourseAttributes.length; ++i) {
            if (i > targetAttributes.length - 1) {
                return true;
            }
            Attribute sAttr = (Attribute)sourseAttributes[i];
            Attribute tAttr = (Attribute)targetAttributes[i];
            if (tAttr.getImportedId() != null && sAttr.getObjectID().equals(tAttr.getImportedId()) || tAttr.getName().equals(sAttr.getName()) || tAttr.getDataType().toString().equals(sAttr.getDataType().toString()) && sAttr.getContainer().getElementByName(tAttr.getName()) == null) continue;
            return false;
        }
        return true;
    }

    private CompareCWDDesigns[] getAttributeNodes(CompareCWDDesigns aNode) {
        ArrayList<CompareCWDDesigns> list = new ArrayList<CompareCWDDesigns>();
        CompareCWDDesigns columns = (CompareCWDDesigns)aNode.getChild(0);
        int nod_number = columns.getNumberOfChildren();
        for (int i = 0; i < nod_number; ++i) {
            CompareCWDDesigns cnode = (CompareCWDDesigns)columns.getChild(i);
            if (cnode.getStatus() == 3 || (!cnode.isSelected() || cnode.getStatus() != 2) && cnode.getStatus() == 2) continue;
            list.add(cnode);
        }
        return list.toArray(new CompareCWDDesigns[0]);
    }

    private String getElementsToString(Entity entity) {
        StringBuffer sb = new StringBuffer();
        Iterator<ContainedObject> it = Arrays.asList(entity.getElements()).iterator();
        boolean first = true;
        while (it.hasNext()) {
            ContainedObject co = it.next();
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName());
        }
        return sb.toString();
    }

    private String getElementsToString(CompareCWDDesigns[] nodes) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < nodes.length; ++i) {
            ContainedObject co = (ContainedObject)nodes[i].getObject();
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName());
        }
        return sb.toString();
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }

    @Override
    public String getLeftName() {
        return this.source != null ? MessageFormat.format(Messages.getString("EntityComparator.SourceEntity"), this.source.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.tatget != null ? MessageFormat.format(Messages.getString("EntityComparator.TargetEntity"), this.tatget.getName()) : "";
    }
}

