/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.AbstractMerging;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.MergingCWDDesigns;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StorageTemplateComparator;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.util.logging.Logger;

public class MergingModels
extends AbstractMerging {
    private static final Logger LOGGER = new Logger(MergingModels.class);
    private List fkeys = new ArrayList();
    private RelationalDesign sourceDesignPart;
    private RelationalDesign targetDesignPart;
    private static Map allObject;
    double shift = 0.0;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private int maxTablePerRow;
    private boolean notEmpty = false;
    private Map newTables = new HashMap();

    public MergingModels(Design design) {
        super(design);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DesignPart dp, Map comparatorsMap, Map physComparatorsMap, Map objectsMap) {
        this.comparatorsMap = comparatorsMap;
        AbstractMerging.physComparatorsMap = physComparatorsMap;
        AbstractMerging.objectsMap = objectsMap;
        this.design.setPropagatePKChahges(false);
        this.targetDesPartID = dp.getObjectID();
        this.targetDesignPart = this.design.getRelationalDesign();
        this.sourceDesignPart = (RelationalDesign)dp;
        try {
            this.targetDesignPart.getUndoManager().setLocked(true);
            this.design.setMerging(true);
            this.design.setCorrespondenceMap(objectsMap);
            this.sourceDesignPart.getDesign().loadDesignLevelSettings(false);
            Design.DesignStorageDesc desc = this.sourceDesignPart.getDesign().getDesignStorageDesc(this.sourceDesignPart.getDesign().getObjectID());
            if (desc == null) {
                this.sourceDesignPart.getDesign().addDesignStorageDesc(this.sourceDesignPart.getDesign());
            }
            this.sourceDesignPart.getDesign().copyDesignStorageDescriptors(this.targetDesignPart.getDesign());
            MergingModels.createUsedClassificationypes(this.sourceDesignPart, this.targetDesignPart);
            for (int i = 0; i < this.sourceDesignPart.getImportConnectionStamps().size(); ++i) {
                this.targetDesignPart.addImportConnectionStamp(this.sourceDesignPart.getImportConnectionStamp(i));
            }
            for (int j = 0; j < this.sourceDesignPart.getImportDDLFileStamps().size(); ++j) {
                this.targetDesignPart.addImportDDLFileStamp(this.sourceDesignPart.getImportDDLFileStamp(j));
            }
            MergingCWDDesigns mdes = new MergingCWDDesigns();
            mdes.processDataTypesDesign(this.sourceDesignPart, this.targetDesignPart, comparatorsMap, objectsMap);
            this.fkeys.clear();
            this.sourceDesignPart.getFKIndexAssociationSet().addAllElementsTo(this.fkeys);
            this.resetAllObjects();
            boolean empty = this.targetDesignPart.getMainView().getTopviewsList().size() == 0;
            this.processSchemaObjects();
            this.processTables();
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
            this.processTableViews();
            this.processForeignKeys();
            MergingCWDDesigns.processFKArcs(this.sourceDesignPart, this.targetDesignPart, objectsMap, comparatorsMap);
            this.reorderColumns();
            this.processTypeSubstitutionT();
            if (empty) {
                MergingCWDDesigns.copyDisplayTopViews(this.sourceDesignPart.getMainView(), this.targetDesignPart.getMainView(), objectsMap);
            }
            if (ModelChooserDialog.isSelectedDatabase) {
                StorageDesign sourceSD = this.sourceDesignPart.getStorageDesign();
                StorageDesign targetSD = this.targetDesignPart.getStorageDesign();
                ApplicationView.loading = true;
                XMLToObjectTransformer.checkShouldMerge = true;
                XMLToObjectTransformer.setSourceStorageDesign(sourceSD);
                sourceSD.cloneFromMemoryToAnotherSD_MD(targetSD, objectsMap, comparatorsMap, true);
                if (sourceSD instanceof StorageDesignOracle) {
                    this.processStorageTemplates();
                }
                targetSD.setOpen(true);
                targetSD.setTempModel(false);
                this.targetDesignPart.getStorageDesign(this.targetDesignPart.getSelectedRDBMSSite()).sortCollections();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("MergingModels.execute()", e);
        }
        finally {
            this.targetDesignPart.getUndoManager().setLocked(false);
            ApplicationView.loading = false;
            XMLToObjectTransformer.checkShouldMerge = false;
            XMLToObjectTransformer.setSourceStorageDesign(null);
            this.design.setPropagatePKChahges(true);
            this.design.setMerging(false);
            this.design.setCorrespondenceMap(null);
            AbstractMerging.physComparatorsMap = null;
            AbstractMerging.objectsMap = null;
        }
    }

    private void processStorageTemplates() {
        for (PropertiesComparator comp : this.comparatorsMap.values()) {
            StorageTemplateComparator templateComp = comp.getTemplateComparator();
            if (templateComp == null) continue;
            templateComp.copySelectedProperties();
        }
    }

    public static void createUsedClassificationypes(DesignPart sdp, DesignPart tdp) {
        DesignLevelSettings dls = tdp.getDesign().getDesignLevelSettings();
        List list = sdp.getUsedClassificationTypes();
        for (ClassificationType clt : list) {
            ClassificationType tclt = dls.getClassificationTypeByID(clt.getTypeID());
            if (tclt != null) continue;
            tclt = new ClassificationType(clt.getTypeName(), new Color(clt.getTypeColor().getRGB()), new Color(clt.getForegroundColor().getRGB()), clt.getTypeID(), clt.getTypePrefix());
            dls.getClassificationTypeList().add(tclt);
        }
    }

    private void processTables() {
        Table sourceTable;
        Iterator it = this.sourceDesignPart.getTableSet().iterator();
        while (it.hasNext()) {
            sourceTable = (Table)it.next();
            if (!sourceTable.shouldBeMerge()) continue;
            this.createNewTable(sourceTable);
        }
        it = this.sourceDesignPart.getTableSet().iterator();
        while (it.hasNext()) {
            sourceTable = (Table)it.next();
            Table targetTable = (Table)objectsMap.get(sourceTable.getObjectID());
            if (sourceTable.shouldBeMerge()) {
                targetTable = this.processTable(sourceTable, targetTable);
                boolean newTable = this.newTables.containsKey(targetTable);
                MergingModels.copySourceStamp(sourceTable, targetTable);
                this.processColumns(sourceTable, targetTable);
                if (sourceTable.getBasedOnStructuredType() != null) {
                    this.processST_Columns(sourceTable);
                }
                this.processIndexes(sourceTable);
                this.processConstraints(sourceTable);
                this.processTimeDimensions(sourceTable);
                targetTable.setSpatialTable(sourceTable.isSpatialTable());
                targetTable.getSpatialDefinitions().clear();
                for (SpatialColumnDefObject spCol : sourceTable.getSpatialDefinitions()) {
                    SpatialColumnDefObject t_spCol = new SpatialColumnDefObject(targetTable);
                    spCol.copyTo(t_spCol, objectsMap);
                    targetTable.addSpatialDefinition(t_spCol);
                }
                if (!PropertiesComparator.DDL_ONLY && newTable) {
                    targetTable.setBeforeDrop(sourceTable.getBeforeDrop());
                    targetTable.setBeforeCreate(sourceTable.getBeforeCreate());
                    targetTable.setAfterCreate(sourceTable.getAfterCreate());
                    targetTable.setEndOfScript(sourceTable.getEndOfScript());
                    targetTable.setShouldGenerateScript(sourceTable.getShouldGenerateScript());
                }
                if (!PropertiesComparator.DDL_ONLY) {
                    targetTable.getColumnGroupsSet().clear();
                    for (Table.ColumnGroup cgOld : sourceTable.getColumnGroupsSet()) {
                        Table.ColumnGroup cgNew = targetTable.createColumnGroup(cgOld.getName(), null);
                        targetTable.getColumnGroupsSet().add(cgNew);
                        cgOld.copy(cgNew, objectsMap);
                    }
                }
                targetTable.setOidIsPK(sourceTable.isOidIsPK());
                targetTable.setRedactionPolicyName(sourceTable.getRedactionPolicyName());
                targetTable.setRedactionPolicyDefaultExpression(sourceTable.getRedactionPolicyDefaultExpression());
                targetTable.setRedactionPolicyEnabled(sourceTable.isRedactionPolicyEnabled());
                targetTable.setRedactionPolicyGenerateInDDL(sourceTable.isRedactionPolicyGenerateInDDL());
                targetTable.setExistDependencyConstraintName(sourceTable.getExistDependencyConstraintName());
                targetTable.setExistDependencyGenerateInDDl(sourceTable.isExistDependencyGenerateInDDl());
                targetTable.setExistDependencyGenerationLevel(sourceTable.getExistDependencyGenerationLevel());
                targetTable.setShouldMerge(true);
                continue;
            }
            if (targetTable == null) continue;
            targetTable.setShouldMerge(false);
        }
    }

    private void reorderColumns() {
        Iterator it = this.sourceDesignPart.getTableSet().iterator();
        while (it.hasNext()) {
            Table sourceTable = (Table)it.next();
            if (!sourceTable.shouldBeMerge()) continue;
            ContainedObject[] sourceColumns = sourceTable.getElements();
            for (int i = 0; i < sourceColumns.length; ++i) {
                Column targetColumn;
                Column sourceColumn = (Column)sourceColumns[i];
                if (!sourceColumn.shouldBeMerge() || (targetColumn = (Column)objectsMap.get(sourceColumn.getObjectID())) == null) continue;
                targetColumn.moveToIndex(sourceColumn.getIndex());
            }
        }
    }

    private Table processTable(Table sourceTable, Table targetTable) {
        if (targetTable == null) {
            SchemaObject tsho;
            if (this.targetDesignPart.getTableSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            targetTable = this.targetDesignPart.createTable();
            targetTable.setImportedId(sourceTable.getObjectID());
            SchemaObject sho = sourceTable.getSchemaObject();
            if (sho != null && (tsho = (SchemaObject)objectsMap.get(sho.getObjectID())) != null) {
                targetTable.setSchemaObject(tsho);
            }
            targetTable.setName(sourceTable.getName());
            objectsMap.put(sourceTable.getObjectID(), targetTable);
            this.copyPropertiesFromTableToTable(sourceTable, targetTable);
            if (this.notEmpty) {
                this.moveGraphical(this.sourceDesignPart, this.targetDesignPart, targetTable, sourceTable);
            } else {
                ++this.count;
                this.setObjectBounds(sourceTable, targetTable);
            }
        } else if (this.newTables.containsKey(targetTable)) {
            if (this.notEmpty) {
                this.moveGraphical(this.sourceDesignPart, this.targetDesignPart, targetTable, sourceTable);
            } else {
                ++this.count;
                this.setObjectBounds(sourceTable, targetTable);
            }
        } else {
            PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceTable.getObjectID() + targetTable.getObjectID());
            if (prop != null) {
                prop.copySelectedProperties();
            }
        }
        return targetTable;
    }

    private void createNewTable(Table sourceTable) {
        Table targetTable = (Table)objectsMap.get(sourceTable.getObjectID());
        if (targetTable == null) {
            SchemaObject tsho;
            if (this.targetDesignPart.getTableSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            targetTable = this.targetDesignPart.createTable();
            targetTable.setImportedId(sourceTable.getObjectID());
            SchemaObject sho = sourceTable.getSchemaObject();
            if (sho != null && (tsho = (SchemaObject)objectsMap.get(sho.getObjectID())) != null) {
                targetTable.setSchemaObject(tsho);
            }
            targetTable.setName(sourceTable.getName());
            objectsMap.put(sourceTable.getObjectID(), targetTable);
            this.copyPropertiesFromTableToTable(sourceTable, targetTable);
            this.newTables.put(targetTable, targetTable);
        }
    }

    private void setObjectBounds(DesignObject sourceTable, DesignObject targetTable) {
        if (targetTable.getTopView().getCellView() != null && sourceTable.getTopView().getBounds() != null) {
            targetTable.getTopView().getCellView().setNewBounds(sourceTable.getTopView().getBounds());
        }
    }

    private void moveGraphical(RelationalDesign physical, RelationalDesign newPhysical, DesignObject newTable, DesignObject table) {
        float square = (float)Math.sqrt(physical.getTableSet().size());
        this.maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++this.maxTablePerRow;
        }
        ++this.maxTablePerRow;
        Rectangle2D rec = newPhysical.getMainView().getTopViewsBounds();
        TopView topView = newTable.getTopView();
        if (topView.getCellView() != null && rec != null) {
            Dimension dim = table.getTopView().getSize();
            if (this.count == 0) {
                this.top = (int)((double)((int)rec.getHeight()) + dim.getHeight());
                this.left = 20;
            }
            ++this.count;
            this.width = (int)dim.getWidth();
            this.height = (int)Math.max(dim.getHeight(), (double)this.height);
            topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), table.getTopView().getSize()));
        }
        this.left = this.left + this.width + 50;
        if (this.count == this.maxTablePerRow) {
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
        }
    }

    private void resetAllObjects() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.notEmpty = false;
        this.count = 0;
    }

    private static void copySourceStamp(ModelObject source, ModelObject target) {
        if (source != null && target != null) {
            if (!"".equals(source.getSourceConnName()) && "".equals(target.getSourceConnName()) && MergingModels.validTargetStamp(source, target)) {
                MergingModels.setTargetDesignStamp(source, target);
                target.setSourceConnName(source.getSourceConnName());
                target.setSourceObjName(source.getSourceObjName());
                target.setSourceObjSchema(source.getSourceObjSchema());
            }
            if (!"".equals(source.getSourceDDLFile()) && "".equals(target.getSourceDDLFile())) {
                target.setSourceDDLFile(source.getSourceDDLFile());
            }
        }
    }

    private static boolean validTargetStamp(ModelObject source, ModelObject target) {
        if (source instanceof DesignObject && target instanceof DesignObject ? ((DesignObject)source).getDesignPart().equals(((DesignObject)target).getDesignPart()) : source instanceof StorageObject && target instanceof StorageObject && ((StorageObject)source).getStorageDesign().getPhysicalDesign().equals(((StorageObject)target).getStorageDesign().getPhysicalDesign())) {
            return false;
        }
        Class<?> srcClass = source.getClass();
        String srcIndexState = "";
        if (source instanceof Index) {
            srcIndexState = ((Index)source).getIndexState();
        }
        String srcConnName = source.getSourceConnName();
        String srcObjName = source.getSourceObjName();
        String srcObjSchema = source.getSourceObjSchema();
        RelationalDesign tgtDes = null;
        if (target instanceof DesignObject) {
            tgtDes = (RelationalDesign)((DesignObject)target).getDesignPart();
        } else if (target instanceof StorageObject) {
            tgtDes = ((StorageObject)target).getStorageDesign().getPhysicalDesign();
        }
        List tgtObjs = tgtDes.getAllImportedObjects();
        for (int i = 0; i < tgtObjs.size(); ++i) {
            ModelObject tgtObj = (ModelObject)tgtObjs.get(i);
            if (!(source instanceof Index && tgtObj instanceof Index ? ((Index)tgtObj).getIndexState().equalsIgnoreCase(srcIndexState) && tgtObj.getSourceConnName().equalsIgnoreCase(srcConnName) && tgtObj.getSourceObjName().equalsIgnoreCase(srcObjName) && tgtObj.getSourceObjSchema().equalsIgnoreCase(srcObjSchema) : tgtObj.getClass().equals(srcClass) && tgtObj.getSourceConnName().equalsIgnoreCase(srcConnName) && tgtObj.getSourceObjName().equalsIgnoreCase(srcObjName) && tgtObj.getSourceObjSchema().equalsIgnoreCase(srcObjSchema))) continue;
            return false;
        }
        return true;
    }

    private static void setTargetDesignStamp(ModelObject source, ModelObject target) {
        String srcConnName = source.getSourceConnName();
        RelationalDesign srcDes = null;
        RelationalDesign tgtDes = null;
        if (source instanceof DesignObject && target instanceof DesignObject) {
            srcDes = (RelationalDesign)((DesignObject)source).getDesignPart();
            tgtDes = (RelationalDesign)((DesignObject)target).getDesignPart();
        } else if (source instanceof StorageObject && target instanceof StorageObject) {
            srcDes = ((StorageObject)source).getStorageDesign().getPhysicalDesign();
            tgtDes = ((StorageObject)target).getStorageDesign().getPhysicalDesign();
        }
        DBConnectionStamp stamp = srcDes.getImportConnectionStamp(srcDes.findImportConnectionStamp(srcConnName));
        if (stamp != null) {
            tgtDes.addImportConnectionStamp(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPropertiesFromTableToTable(Table sourceTable, Table targetTable) {
        DesignObject dobj;
        if (sourceTable.getGeneratorID() != null && !"User generated".equals(sourceTable.getGeneratorID()) && (dobj = (DesignObject)objectsMap.get(sourceTable.getGeneratorID())) != null && dobj instanceof Entity) {
            targetTable.setGeneratorID(dobj.getObjectID());
        }
        targetTable.setNameHasQuotes(sourceTable.getNameHasQuotes());
        targetTable.setMinVolumes(sourceTable.getMinVolumes());
        targetTable.setExpectedVolumes(sourceTable.getExpectedVolumes());
        targetTable.setMaxVolumes(sourceTable.getMaxVolumes());
        targetTable.setGrowthPercent(sourceTable.getGrowthPercent());
        targetTable.setGrowthType(sourceTable.getGrowthType());
        targetTable.setNormalForm(sourceTable.getNormalForm());
        targetTable.setAdequatelyNormalized(sourceTable.getAdequatelyNormalized());
        targetTable.setTypeID(sourceTable.getTypeID());
        targetTable.getAdditionalClassificationTypes().clear();
        targetTable.getAdditionalClassificationTypes().addAll(sourceTable.getAdditionalClassificationTypes());
        targetTable.setScope(sourceTable.getScope());
        StructuredType st = sourceTable.getBasedOnStructuredType();
        if (st != null) {
            StructuredType targetST = (StructuredType)objectsMap.get(st.getObjectID());
            if (targetST != null) {
                ApplicationView.loading = true;
                try {
                    targetTable.setBasedOnStructuredType(targetST);
                }
                finally {
                    ApplicationView.loading = false;
                }
            }
        } else {
            targetTable.setBasedOnStructuredType(null);
        }
        targetTable.setAllowTypeSubstitution(sourceTable.isAllowTypeSubstitution());
        targetTable.setComment(sourceTable.getComment());
        targetTable.setCommentInRDBMS(sourceTable.getCommentInRDBMS());
        targetTable.setNotes(sourceTable.getNotes());
        targetTable.setAbbreviation(sourceTable.getAbbreviation());
        sourceTable.copyAllRemoteObjectIDsAndPath(targetTable);
        targetTable.setEngineerToRelation(sourceTable.isEngineerToRelation());
        targetTable.setAllowColumnReorder(sourceTable.isAllowColumnReorder());
        targetTable.setShouldEngineer(sourceTable.getShouldEngineer());
        targetTable.setDeprecated(sourceTable.isDeprecated());
        targetTable.setUseDDLTransformationScript(sourceTable.isUseDDLTransformationScript());
        targetTable.setOnPrebuiltTable(sourceTable.isOnPrebuiltTable());
        targetTable.setMaterializedQueryTable(sourceTable.isMaterializedQueryTable());
        targetTable.setUserDefinedSQL(sourceTable.getUserDefinedSQL());
        targetTable.setIncludeSchemaNameInQuery(sourceTable.includeSchemaNameInQuery());
        targetTable.setSyntaxProvider(sourceTable.getSyntaxProvider());
        targetTable.setIncorrectSQL(sourceTable.isIncorrectSQL());
        targetTable.setORDSEnable(sourceTable.isORDSEnable());
        targetTable.setORDSAuth(sourceTable.isORDSAuth());
        targetTable.setORDSAlias(sourceTable.getORDSAlias());
        sourceTable.copyDynamicProperties(targetTable);
    }

    private void processColumns(Table sourceTable, Table targetTable) {
        ContainedObject[] sourceColumns = sourceTable.getElements();
        for (int i = 0; i < sourceColumns.length; ++i) {
            Column targetColumn;
            Column sourceColumn = (Column)sourceColumns[i];
            if (sourceColumn.shouldBeMerge()) {
                targetColumn = (Column)objectsMap.get(sourceColumn.getObjectID());
                if (targetColumn == null) {
                    targetColumn = targetTable.createColumn(sourceColumn.getName());
                    targetColumn.setImportedId(sourceColumn.getObjectID());
                    targetColumn.moveToIndex(sourceColumn.getIndex());
                    objectsMap.put(sourceColumn.getObjectID(), targetColumn);
                    MergingModels.copyPropertiesFromColumnToColumn(sourceColumn, targetColumn, objectsMap);
                    targetColumn.setStructAttributeID(sourceColumn.getStructAttributeID());
                    MergingModels.copySourceStamp(sourceColumn, targetColumn);
                } else {
                    ColumnComparator comp = (ColumnComparator)this.comparatorsMap.get(sourceColumn.getObjectID() + targetColumn.getObjectID());
                    if (comp != null) {
                        comp.copySelectedProperties();
                        targetColumn.moveToIndex(sourceColumn.getIndex());
                    }
                }
                targetColumn.setShouldMerge(true);
                continue;
            }
            if (!sourceTable.shouldBeMerge() || (targetColumn = (Column)objectsMap.get(sourceColumn.getObjectID())) == null) continue;
            targetColumn.moveToIndex(sourceColumn.getIndex());
            targetColumn.setShouldMerge(false);
        }
        for (Column sourceNestedCol : sourceTable.getNestedElements()) {
            Column targetNestedCol = (Column)this.getCorrespondingNestedColumn(targetTable, sourceNestedCol);
            if (targetNestedCol == null) continue;
            objectsMap.put(sourceNestedCol.getObjectID(), targetNestedCol);
            boolean shouldMerge = sourceNestedCol.getParentObject().shouldBeMerge();
            sourceNestedCol.setShouldMerge(shouldMerge);
            if (!shouldMerge) continue;
            MergingModels.copyPropertiesFromColumnToColumn(sourceNestedCol, targetNestedCol, objectsMap);
        }
        for (int i = 0; i < sourceColumns.length; ++i) {
            Column targetColumn;
            Column sourceColumn = (Column)sourceColumns[i];
            if (!sourceColumn.shouldBeMerge() || (targetColumn = (Column)objectsMap.get(sourceColumn.getObjectID())) == null || targetTable == null) continue;
            sourceColumn.copyDepenDendentColumnDescriptors(targetColumn, true, objectsMap);
        }
    }

    private ContainedObject getCorrespondingNestedColumn(ContainerObject targetTable, ContainedObject sourceColumn) {
        TypeElement targetStructAtt;
        ContainedObject targetParentColumn;
        ContainedObject sourceParentColumn = sourceColumn.getParentObject();
        if (sourceParentColumn != null && (targetParentColumn = (ContainedObject)objectsMap.get(sourceParentColumn.getObjectID())) != null && (targetStructAtt = (TypeElement)objectsMap.get(sourceColumn.getStructAttributeID())) != null) {
            String targetStructAttID = targetStructAtt.getObjectID();
            String targetParentColumnID = targetParentColumn.getObjectID();
            for (ContainedObject targetCol : targetTable.getNestedElements()) {
                ContainedObject parentCol;
                if (!targetCol.getStructAttributeID().equals(targetStructAttID) || (parentCol = targetCol.getParentObject()) == null || !parentCol.getObjectID().equals(targetParentColumnID)) continue;
                return targetCol;
            }
        }
        return null;
    }

    private void processST_Columns(Table sourceTable) {
        Table targetTable = (Table)objectsMap.get(sourceTable.getObjectID());
        if (targetTable != null) {
            for (Column column : sourceTable.getElementsCollectionImmutable()) {
                String te_id = column.getStructAttributeID();
                if (te_id == null) continue;
                ModelIDObject obj = (ModelIDObject)objectsMap.get(te_id);
                String id = te_id;
                if (obj != null) {
                    id = obj.getObjectID();
                }
                if (id == null) continue;
                Column targetCol = (Column)targetTable.getElementByStructAttributeID(te_id);
                if (targetCol == null) {
                    targetCol = (Column)targetTable.getElementByStructAttributeID(id);
                } else {
                    targetCol.setStructAttributeID(id);
                }
                if (targetCol == null) continue;
                objectsMap.put(column.getObjectID(), targetCol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyPropertiesFromColumnToColumn(FKElement sourceColumn, FKElement targetColumn, Map objectsMap) {
        try {
            DesignObject dobj;
            targetColumn.setTemporaryWriteable(true);
            if (sourceColumn.getGeneratorID() != null && !"User generated".equals(sourceColumn.getGeneratorID()) && (dobj = (DesignObject)objectsMap.get(sourceColumn.getGeneratorID())) != null && dobj instanceof Attribute) {
                targetColumn.setGeneratorID(dobj.getObjectID());
            }
            MergingModels.copyPropertiesFromCOWD_To_COWD(sourceColumn, targetColumn, objectsMap);
            if (sourceColumn instanceof Column && targetColumn instanceof Column) {
                MergingModels.copyColumnSpecificProperties((Column)sourceColumn, (Column)targetColumn);
            }
        }
        finally {
            targetColumn.setTemporaryWriteable(false);
        }
    }

    public static void copyDataTypeFromCOWD_To_COWD(ContainedObjectWithDomain source, ContainedObjectWithDomain target, boolean createDomain) {
        target.setUse(source.getUse());
        target.setSensitiveType(source.getSensitiveType());
        target.setSensitiveTypeDescription(source.getSensitiveTypeDescription());
        if (source.getUse() == 0) {
            if (source.getDomain() != null) {
                Domain sourceDomain = source.getDomain();
                DesignObject dobj = target.getDesign().getDesignObject(sourceDomain.getObjectID());
                boolean idUsed = false;
                Domain targetDomain = null;
                if (dobj != null) {
                    idUsed = true;
                    if (dobj instanceof Domain) {
                        targetDomain = (Domain)dobj;
                    }
                }
                if (targetDomain == null) {
                    targetDomain = (Domain)CompareModelToModel.getCorrespondingObject(target.getDesign().getDomainSet(), sourceDomain);
                }
                if (targetDomain != null) {
                    target.setDomain(targetDomain);
                } else if (createDomain) {
                    LogicalDatatype ldt;
                    targetDomain = target.getDesign().getDomainSet().createDomain();
                    targetDomain.setDesign(target.getDesign());
                    targetDomain.setOwnerDesign(target.getDesign());
                    sourceDomain.copyTo(targetDomain);
                    if (!idUsed) {
                        targetDomain.setObjectID(sourceDomain.getObjectID());
                    }
                    if ((ldt = (LogicalDatatype)CompareModelToModel.getCorrespondingObject(target.getDesign().getLogicalDatatypeSet(), sourceDomain.getLogicalDatatype())) != null) {
                        targetDomain.setLogicalDatatype(ldt);
                    }
                    targetDomain.setFileName(sourceDomain.getFileName());
                    targetDomain.setDirty(true);
                    target.setDomain(targetDomain);
                } else {
                    LogicalDatatype t_dt;
                    LogicalDatatype dt = source.getLogicalDatatype();
                    if (dt != null && (t_dt = (LogicalDatatype)target.getDesign().getLogicalDatatypeSet().getByName(dt.getName())) != null) {
                        target.setLogicalDatatype(t_dt);
                        target.setUse((short)1);
                    }
                }
            }
        } else if (source.getUse() == 1) {
            LogicalDatatype t_dt;
            LogicalDatatype dt = source.getLogicalDatatype();
            if (dt != null && (t_dt = (LogicalDatatype)target.getDesign().getLogicalDatatypeSet().getByName(dt.getName())) != null) {
                target.setLogicalDatatype(t_dt);
            }
        } else if (source.getUse() == 3) {
            target.setReference(source.isReference());
            StructuredType source_st = source.getStructuredType();
            StructuredType target_st = (StructuredType)CompareModelToModel.getCorrespondingObject(target.getDesign().getDataTypesDesign().getStructuredTypeSet(), source_st);
            if (target_st != null) {
                target.setStructuredType(target_st);
            }
            Iterator it = source.getPermittedSubTypes().iterator();
            List list = target.getPermittedSubTypes();
            list.clear();
            while (it.hasNext()) {
                StructuredType st = (StructuredType)it.next();
                target_st = (StructuredType)CompareModelToModel.getCorrespondingObject(target.getDesign().getDataTypesDesign().getStructuredTypeSet(), st);
                if (target_st == null) continue;
                list.add(target_st);
            }
        } else if (source.getUse() == 4) {
            CollectionType source_ct = source.getCollectionType();
            CollectionType target_ct = (CollectionType)CompareModelToModel.getCorrespondingObject(target.getDesign().getDataTypesDesign().getCollectionTypeSet(), source_ct);
            if (target_ct != null) {
                target.setCollectionType(target_ct);
            }
        } else if (source.getUse() == 2) {
            DistinctType source_dt = source.getDistinctType();
            DistinctType target_dt = (DistinctType)CompareModelToModel.getCorrespondingObject(target.getDesign().getDataTypesDesign().getDistinctTypeSet(), source_dt);
            if (target_dt != null) {
                target.setDistinctType(target_dt);
            }
        }
        target.setDataTypeParameter("size", source.getSize());
        target.setDataTypeParameter("precision", source.getPrecision());
        target.setDataTypeParameter("scale", source.getScale());
        target.copyParametersFrom(source);
        MergingModels.copySourceStamp(source, target);
    }

    public static void copyPropertiesFromCOWD_To_COWD(ContainedObjectWithDomain source, ContainedObjectWithDomain target, Map sourceToTarget) {
        target.setTemporaryWriteable(true);
        MergingModels.copyDataTypeFromCOWD_To_COWD(source, target, true);
        if (source.getScope() != null) {
            ContainerObject sourceTable = source.getScope();
            DesignObject targetTable = (DesignObject)sourceToTarget.get(sourceTable.getObjectID());
            if (targetTable == null) {
                if (sourceTable instanceof Table) {
                    targetTable = CompareModelToModel.getCorrespondingObject(target.getDesign().getRelationalDesign().getTableSet(), sourceTable);
                } else if (sourceTable instanceof Entity) {
                    targetTable = CompareModelToModel.getCorrespondingObject(target.getDesign().getLogicalDesign().getEntitySet(), sourceTable);
                }
            }
            if (targetTable != null) {
                target.setScopeId(targetTable.getObjectID());
            } else {
                target.setScopeId(null);
            }
        } else {
            target.setScopeId(null);
        }
        target.setAllowSubtypeSubstitution(source.isAllowSubtypeSubstitution());
        target.setRestrictedTypeSubstitution(source.isRestrictedTypeSubstitution());
        List list = target.getPermittedSubTypes();
        list.clear();
        list.addAll(source.getPermittedSubTypes());
        target.setNullsAllowed(source.getNullsAllowed());
        target.setConstraintName(source.getConstraintName());
        target.setDefaultValue(source.getDefaultValue());
        target.setUsesDefaultValue(source.getUsesDefaultValue());
        target.setCommentInRDBMS(source.getCommentInRDBMS());
        target.setComment(source.getComment());
        target.setNotes(source.getNotes());
        target.setSourceType(source.getSourceType());
        target.setFormulaDesc(source.getFormulaDesc());
        target.setShouldEngineer(source.getShouldEngineer());
        target.setDeprecated(source.isDeprecated());
        source.copyDynamicProperties(target);
        target.setTemporaryWriteable(false);
        target.setUseDomainConstraints(source.getUseDomainConstraints());
        if (!source.getUseDomainConstraints()) {
            EngCOPropertiesComparator.copyCheckConstraint(source, target);
            EngCOPropertiesComparator.copyRangeConstraint(source, target);
            EngCOPropertiesComparator.copyLOVConstraint(source, target);
        }
    }

    private static void copyColumnSpecificProperties(Column source, Column target) {
        target.setTemporaryWriteable(true);
        target.setAbbreviation(source.getAbbreviation());
        target.setComputed(source.isComputed());
        target.setNotNullConstraintName(source.getNotNullConstraintName());
        target.setGenerateConstraintInDDL(source.getGenerateConstraintInDDL());
        target.setDefaultLabel(source.getDefaultLabel());
        target.setDefaultFormatMask(source.getDefaultFormatMask());
        target.setDefaultFormDisplayWidth(source.getDefaultFormDisplayWidth());
        target.setDefaultFormMaximumWidth(source.getDefaultFormMaximumWidth());
        target.setDefaultFormHeight(source.getDefaultFormHeight());
        target.setDefaultHelpText(source.getDefaultHelpText());
        target.setDefaultReadOnly(source.isDefaultReadOnly());
        target.setDefaultDisplayedOnReports(source.isDefaultDisplayedOnReports());
        target.setDefaultDisplayedOnForms(source.isDefaultDisplayedOnForms());
        target.setDefaultDisplayAs(source.getDefaultDisplayAs());
        target.setOid(source.isOid());
        target.setNameHasQuotes(source.getNameHasQuotes());
        target.setContainsPII(source.isContainsPII());
        target.setContainsSensitiveInformation(source.isContainsSensitiveInformation());
        target.setMaskingType(source.getMaskingType());
        target.setMaskTemplate(source.getMaskTemplate());
        target.setSurrogateColumn(source.isSystemObject());
        target.setDiscriminatorColumn(source.isDiscriminatorColumn());
        target.setAutoIncrementColumn(source.isAutoIncrementColumn());
        target.setIdentityColumn(source.isIdentityColumn());
        target.setAutoIncrementGenerateAlways(source.isAutoIncrementGenerateAlways());
        target.setAutoIncrementStartWith(source.getAutoIncrementStartWith());
        target.setAutoIncrementIncrementBy(source.getAutoIncrementIncrementBy());
        target.setAutoIncrementMinValue(source.getAutoIncrementMinValue());
        target.setAutoIncrementMaxValue(source.getAutoIncrementMaxValue());
        target.setAutoIncrementCycle(source.isAutoIncrementCycle());
        target.setAutoIncrementDisableCache(source.isAutoIncrementDisableCache());
        target.setAutoIncrementCache(source.getAutoIncrementCache());
        target.setAutoIncrementOrder(source.isAutoIncrementOrder());
        target.setAutoIncrementSequenceName(source.getAutoIncrementSequenceName());
        target.setAutoIncrementTriggerName(source.getAutoIncrementTriggerName());
        target.setAutoIncrementGenerateTrigger(source.isAutoIncrementGenerateTrigger());
        source.copyAllRemoteObjectIDsAndPath(target);
        FKIndexAssociation fk = source.getDependOnForeignKey();
        if (fk != null) {
            FKIndexAssociation tfk = (FKIndexAssociation)objectsMap.get(fk.getObjectID());
            if (tfk != null) {
                target.setDependOnForeignKey(tfk);
            }
        } else {
            target.setDependOnForeignKey(null);
            target.setDependOnForeignKeyID("");
        }
        target.setDependOnFK_AsMandatory(source.isDependOnFK_AsMandatory());
        target.setTemporaryWriteable(false);
    }

    private void processIndexes(Table sourceTable) {
        Table targetTable = (Table)objectsMap.get(sourceTable.getObjectID());
        if (targetTable != null) {
            KeyObject[] sourceKeys = sourceTable.getKeys();
            for (int i = 0; i < sourceKeys.length; ++i) {
                KeyObject sourceKey = sourceKeys[i];
                if (sourceKey.isFK()) continue;
                Index index = (Index)objectsMap.get(sourceKey.getObjectID());
                if (sourceKey.shouldBeMerge()) {
                    if (index == null) {
                        SchemaObject tsho;
                        index = targetTable.createIndex();
                        index.setImportedId(sourceKey.getObjectID());
                        SchemaObject sho = sourceKey.getSchemaObject();
                        if (sho != null && (tsho = (SchemaObject)objectsMap.get(sho.getObjectID())) != null) {
                            index.setSchemaObject(tsho);
                        }
                        objectsMap.put(sourceKey.getObjectID(), index);
                        this.copyPropertiesFromIndexToIndex((Index)sourceKey, index);
                        index.setName(sourceKey.getName());
                        MergingModels.copySourceStamp(sourceKey, index);
                    } else {
                        PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceKey.getObjectID() + index.getObjectID());
                        if (comp != null) {
                            comp.copySelectedProperties();
                        }
                    }
                    index.setShouldMerge(true);
                    continue;
                }
                if (index == null) continue;
                index.setShouldMerge(false);
            }
        }
    }

    private void copyPropertiesFromIndexToIndex(Index sourceIndex, Index targetIndex) {
        DesignObject dobj;
        if (sourceIndex.getGeneratorID() != null && !"User generated".equals(sourceIndex.getGeneratorID()) && (dobj = (DesignObject)objectsMap.get(sourceIndex.getGeneratorID())) != null && dobj instanceof CandidateKey) {
            targetIndex.setGeneratorID(dobj.getObjectID());
        }
        targetIndex.setNameHasQuotes(sourceIndex.getNameHasQuotes());
        targetIndex.setCommentInRDBMS(sourceIndex.getCommentInRDBMS());
        targetIndex.setComment(sourceIndex.getComment());
        targetIndex.setNotes(sourceIndex.getNotes());
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        for (int j = 0; j < sourceColumns.length; ++j) {
            ContainedObject sourceColumn = sourceColumns[j];
            Column targetColumn = (Column)objectsMap.get(sourceColumn.getObjectID());
            if (targetColumn == null || targetColumn.getContainer() != targetIndex.getContainerObject()) continue;
            String sorder = sourceIndex.getColumnSortOrder(sourceColumn);
            targetIndex.add(targetColumn);
            targetIndex.setColumnSortOrder(targetColumn, sorder);
        }
        targetIndex.setIndexState(sourceIndex.getIndexState());
        targetIndex.setIndexExpression(sourceIndex.getIndexExpression());
        targetIndex.setSpatialIndex(sourceIndex.isSpatialIndex());
        targetIndex.setLayerType(sourceIndex.getLayerType());
        targetIndex.setDimensionsNumber(sourceIndex.getDimensionsNumber());
        targetIndex.setGeodetic(sourceIndex.getGeodetic());
        sourceIndex.copyAllRemoteObjectIDsAndPath(targetIndex);
        sourceIndex.copyDynamicProperties(targetIndex);
    }

    public static void synchronizeColumnsFromIndexToKey(KeyObject index, KeyObject key) {
        int i;
        ContainedObject[] columns = index.getElements();
        ArrayList<ContainedObject> list = new ArrayList<ContainedObject>();
        for (int i2 = 0; i2 < columns.length; ++i2) {
            ContainedObject sourcecolumn = columns[i2];
            ContainedObject targetcol = MergingModels.getTargetColumn(sourcecolumn);
            if (targetcol == null) continue;
            list.add(targetcol);
            key.add(targetcol);
            String sortOrder = index.getColumnSortOrder(sourcecolumn);
            key.setColumnSortOrder(targetcol, sortOrder);
        }
        ContainedObject[] cols = key.getElements();
        for (i = 0; i < cols.length; ++i) {
            if (list.contains(cols[i])) continue;
            key.remove(cols[i]);
        }
        for (i = 0; i < list.size(); ++i) {
            key.moveToIndex((ContainedObject)list.get(i), i);
        }
    }

    private void processViewIndexes(TableView sourceView) {
        TableView targetView = (TableView)objectsMap.get(sourceView.getObjectID());
        if (targetView != null) {
            KeyObject[] sourceKeys = sourceView.getKeys();
            for (int i = 0; i < sourceKeys.length; ++i) {
                KeyObject sourceKey = sourceKeys[i];
                if (sourceKey.isFK()) continue;
                ViewIndex index = (ViewIndex)objectsMap.get(sourceKey.getObjectID());
                if (sourceKey.shouldBeMerge()) {
                    if (index == null) {
                        SchemaObject tsho;
                        index = targetView.createIndex();
                        index.setImportedId(sourceKey.getObjectID());
                        SchemaObject sho = sourceKey.getSchemaObject();
                        if (sho != null && (tsho = (SchemaObject)objectsMap.get(sho.getObjectID())) != null) {
                            index.setSchemaObject(tsho);
                        }
                        objectsMap.put(sourceKey.getObjectID(), index);
                        this.copyPropertiesFromViewIndexToViewIndex((ViewIndex)sourceKey, index);
                        index.setName(sourceKey.getName());
                        MergingModels.copySourceStamp(sourceKey, index);
                    } else {
                        PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceKey.getObjectID() + index.getObjectID());
                        if (comp != null) {
                            comp.copySelectedProperties();
                        }
                    }
                    index.setShouldMerge(true);
                    continue;
                }
                if (index == null) continue;
                index.setShouldMerge(false);
            }
        }
    }

    private void copyPropertiesFromViewIndexToViewIndex(ViewIndex sourceIndex, ViewIndex targetIndex) {
        DesignObject dobj;
        if (sourceIndex.getGeneratorID() != null && !"User generated".equals(sourceIndex.getGeneratorID()) && (dobj = (DesignObject)objectsMap.get(sourceIndex.getGeneratorID())) != null && dobj instanceof CandidateKey) {
            targetIndex.setGeneratorID(dobj.getObjectID());
        }
        targetIndex.setNameHasQuotes(sourceIndex.getNameHasQuotes());
        targetIndex.setCommentInRDBMS(sourceIndex.getCommentInRDBMS());
        targetIndex.setComment(sourceIndex.getComment());
        targetIndex.setNotes(sourceIndex.getNotes());
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        for (int j = 0; j < sourceColumns.length; ++j) {
            ContainedObject sourceColumn = sourceColumns[j];
            ContainedObject targetColumn = (ContainedObject)objectsMap.get(sourceColumn.getObjectID());
            if (targetColumn == null || targetColumn.getContainer() != targetIndex.getContainerObject()) continue;
            String sorder = sourceIndex.getColumnSortOrder(sourceColumn);
            targetIndex.add(targetColumn);
            targetIndex.setColumnSortOrder(targetColumn, sorder);
        }
        targetIndex.setIndexState(sourceIndex.getIndexState());
        targetIndex.setIndexExpression(sourceIndex.getIndexExpression());
        sourceIndex.copyAllRemoteObjectIDsAndPath(targetIndex);
    }

    private static ContainedObject getTargetColumn(ContainedObject column) {
        ContainedObject targetcol = (ContainedObject)objectsMap.get(column.getObjectID());
        return targetcol;
    }

    private void processConstraints(Table sourceTable) {
        Table targetTable = (Table)objectsMap.get(sourceTable.getObjectID());
        if (targetTable != null) {
            List checkConstraints = sourceTable.getCheckConstraints();
            for (TableLevelConstraint sourceConstraint : checkConstraints) {
                TableLevelConstraint targetConstraint = (TableLevelConstraint)objectsMap.get(sourceConstraint.getObjectID());
                if (sourceConstraint.shouldBeMerge()) {
                    if (targetConstraint == null) {
                        targetConstraint = targetTable.createCheckConstraint(sourceConstraint.getName(), sourceConstraint.getRule());
                        targetConstraint.setNameHasQuotes(sourceConstraint.getNameHasQuotes());
                        targetConstraint.setGenerateInDDL(sourceConstraint.getGenerateInDDL());
                        targetConstraint.setImportedId(sourceConstraint.getObjectID());
                        targetTable.addCheckConstraint(targetConstraint);
                        objectsMap.put(sourceConstraint.getObjectID(), targetConstraint);
                        MergingModels.copySourceStamp(sourceConstraint, targetConstraint);
                    } else {
                        PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceConstraint.getObjectID() + targetConstraint.getObjectID());
                        if (comp != null) {
                            comp.copySelectedProperties();
                        }
                    }
                    targetConstraint.setShouldMerge(true);
                    continue;
                }
                if (targetConstraint == null) continue;
                targetConstraint.setShouldMerge(false);
            }
        }
    }

    private void processTimeDimensions(Table sourceTable) {
        Table targetTable = (Table)objectsMap.get(sourceTable.getObjectID());
        if (targetTable != null) {
            for (ValidTimeDimension sourceTimeDim : sourceTable.getValidTimeDimensions()) {
                ValidTimeDimension targetTimeDim = (ValidTimeDimension)objectsMap.get(sourceTimeDim.getObjectID());
                if (sourceTimeDim.shouldBeMerge()) {
                    if (targetTimeDim == null) {
                        Column sourceEndColumn;
                        targetTimeDim = targetTable.createValidTimeDimension();
                        targetTimeDim.setName(sourceTimeDim.getName());
                        targetTimeDim.setNameHasQuotes(sourceTimeDim.getNameHasQuotes());
                        Column sourceStartColumn = sourceTimeDim.getStartTimeColumn();
                        if (sourceStartColumn != null) {
                            Column targetStartColumn = (Column)objectsMap.get(sourceStartColumn.getObjectID());
                            targetTimeDim.setStartTimeColumn(targetStartColumn);
                        }
                        if ((sourceEndColumn = sourceTimeDim.getEndTimeColumn()) != null) {
                            Column targetEndColumn = (Column)objectsMap.get(sourceEndColumn.getObjectID());
                            targetTimeDim.setEndTimeColumn(targetEndColumn);
                        }
                        targetTimeDim.setImportedId(sourceTimeDim.getObjectID());
                        objectsMap.put(sourceTimeDim.getObjectID(), targetTimeDim);
                        MergingModels.copySourceStamp(sourceTimeDim, targetTimeDim);
                    } else {
                        PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(sourceTimeDim.getObjectID() + targetTimeDim.getObjectID());
                        if (comp != null) {
                            comp.copySelectedProperties();
                        }
                    }
                    targetTimeDim.setShouldMerge(true);
                    continue;
                }
                if (targetTimeDim == null) continue;
                targetTimeDim.setShouldMerge(false);
            }
        }
    }

    private void processForeignKeys() {
        for (int i = 0; i < this.fkeys.size(); ++i) {
            FKIndexAssociation fk = (FKIndexAssociation)this.fkeys.get(i);
            FKIndexAssociation targetfk = (FKIndexAssociation)objectsMap.get(fk.getObjectID());
            if (fk.getContainerWithKeyObject().shouldBeMerge()) {
                if (fk.shouldBeMerge()) {
                    if (targetfk == null) {
                        this.processFK(fk);
                    } else {
                        PropertiesComparator comp = (PropertiesComparator)this.comparatorsMap.get(fk.getObjectID() + targetfk.getObjectID());
                        if (comp != null) {
                            comp.copySelectedProperties();
                            this.synchronizeFKColumns(fk, targetfk);
                            targetfk.resetEdgeParams();
                        }
                    }
                    if (targetfk == null) continue;
                    targetfk.setShouldMerge(true);
                    targetfk.getLocalFKIndex().setShouldMerge(true);
                    continue;
                }
                if (targetfk == null) continue;
                targetfk.setShouldMerge(false);
                targetfk.getLocalFKIndex().setShouldMerge(false);
                continue;
            }
            if (targetfk == null) continue;
            targetfk.setShouldMerge(false);
            targetfk.getLocalFKIndex().setShouldMerge(false);
        }
    }

    public void processFK(FKIndexAssociation sourcefkAssociation) {
        FKContainer sourceTable = sourcefkAssociation.getRemoteTable();
        FKContainer targetTable = (FKContainer)sourcefkAssociation.getContainerWithKeyObject();
        FKContainer newsourceTable = (FKContainer)objectsMap.get(sourceTable.getObjectID());
        FKContainer newtargetTable = (FKContainer)objectsMap.get(targetTable.getObjectID());
        if (newsourceTable == null && newtargetTable != null) {
            newsourceTable = (FKContainer)newtargetTable.getDesign().getDesignObject(sourceTable.getObjectID());
        }
        if (newsourceTable != null && newtargetTable != null) {
            KeyObject remoteIndex = sourcefkAssociation.getRemoteIndex();
            KeyObject newRemoteIndex = (KeyObject)objectsMap.get(remoteIndex.getObjectID());
            if (newRemoteIndex == null) {
                newRemoteIndex = (KeyObject)newtargetTable.getDesign().getDesignObject(remoteIndex.getObjectID());
            }
            if (newRemoteIndex != null) {
                FKElement tcol;
                DesignObject dobj;
                FKIndexAssociation targetfkAssociation = newtargetTable.addFK(newRemoteIndex);
                objectsMap.put(sourcefkAssociation.getObjectID(), targetfkAssociation);
                objectsMap.put(sourcefkAssociation.getLocalFKIndex().getObjectID(), targetfkAssociation.getLocalFKIndex());
                if (sourcefkAssociation.getGeneratorID() != null && !"User generated".equals(sourcefkAssociation.getGeneratorID()) && (dobj = (DesignObject)objectsMap.get(sourcefkAssociation.getGeneratorID())) != null && dobj instanceof Relation) {
                    targetfkAssociation.setGeneratorID(dobj.getObjectID());
                }
                targetfkAssociation.setImportedId(sourcefkAssociation.getObjectID());
                targetfkAssociation.setName(sourcefkAssociation.getName());
                MergingModels.copySourceStamp(sourcefkAssociation, targetfkAssociation);
                this.synchronizeFKColumns(sourcefkAssociation, targetfkAssociation);
                targetfkAssociation.setDeleteRule(sourcefkAssociation.getDeleteRule());
                targetfkAssociation.setComment(sourcefkAssociation.getComment());
                targetfkAssociation.setCommentInRDBMS(sourcefkAssociation.getCommentInRDBMS());
                targetfkAssociation.setNotes(sourcefkAssociation.getNotes());
                targetfkAssociation.setMandatory(sourcefkAssociation.isMandatory());
                targetfkAssociation.setTransferable(sourcefkAssociation.isTransferable());
                targetfkAssociation.setRely(sourcefkAssociation.isRely());
                FKArc targetArc = null;
                FKArc sourceArc = sourcefkAssociation.getArc();
                if (sourceArc != null) {
                    targetArc = (FKArc)objectsMap.get(sourceArc.getObjectID());
                }
                targetfkAssociation.setArc(targetArc);
                sourcefkAssociation.copyAllRemoteObjectIDsAndPath(targetfkAssociation);
                sourcefkAssociation.copyDynamicProperties(targetfkAssociation);
                FKElement col = sourcefkAssociation.getDiscriminatorColumn();
                if (col != null && (tcol = (FKElement)objectsMap.get(col.getObjectID())) != null) {
                    targetfkAssociation.setDiscriminatorColumn(tcol);
                }
                targetfkAssociation.setDiscriminatorValue(sourcefkAssociation.getDiscriminatorValue());
                targetfkAssociation.getLocalFKIndex().setNameHasQuotes(sourcefkAssociation.getLocalFKIndex().getNameHasQuotes());
                targetfkAssociation.resetEdgeParams();
            }
        }
    }

    private void processTableViews() {
        Iterator it = this.sourceDesignPart.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView sourceTableView = (TableView)it.next();
            if (!sourceTableView.shouldBeMerge()) continue;
            TableView targetTableView = this.processTableView(sourceTableView);
            targetTableView.setShouldMerge(true);
            MergingModels.copySourceStamp(sourceTableView, targetTableView);
            this.processViewIndexes(sourceTableView);
        }
    }

    private TableView processTableView(TableView sourceTableView) {
        TableView targetTableView = (TableView)objectsMap.get(sourceTableView.getObjectID());
        if (targetTableView == null) {
            SchemaObject tsho;
            if (this.targetDesignPart.getTableViewSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            targetTableView = this.targetDesignPart.createTableView(sourceTableView.getName());
            targetTableView.setImportedId(sourceTableView.getObjectID());
            objectsMap.put(sourceTableView.getObjectID(), targetTableView);
            SchemaObject sho = sourceTableView.getSchemaObject();
            if (sho != null && (tsho = (SchemaObject)objectsMap.get(sho.getObjectID())) != null) {
                targetTableView.setSchemaObject(tsho);
            }
            this.copyPropertiesFromTableViewToTableView(sourceTableView, targetTableView);
            if (this.notEmpty) {
                this.moveGraphical(this.sourceDesignPart, this.targetDesignPart, targetTableView, sourceTableView);
            } else {
                ++this.count;
                this.setObjectBounds(sourceTableView, targetTableView);
            }
        } else {
            PropertiesComparator prop = (PropertiesComparator)this.comparatorsMap.get(sourceTableView.getObjectID() + targetTableView.getObjectID());
            if (prop != null) {
                prop.copySelectedProperties();
            }
        }
        return targetTableView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPropertiesFromTableViewToTableView(TableView sourceTableView, TableView targetTableView) {
        ColumnView col;
        DesignObject dobj;
        if (sourceTableView.getGeneratorID() != null && !"User generated".equals(sourceTableView.getGeneratorID()) && (dobj = (DesignObject)objectsMap.get(sourceTableView.getGeneratorID())) != null && dobj instanceof EntityView) {
            targetTableView.setGeneratorID(dobj.getObjectID());
        }
        targetTableView.setNameHasQuotes(sourceTableView.getNameHasQuotes());
        targetTableView.setComment(sourceTableView.getComment());
        targetTableView.setCommentInRDBMS(sourceTableView.getCommentInRDBMS());
        targetTableView.setNotes(sourceTableView.getNotes());
        targetTableView.setDeprecated(sourceTableView.isDeprecated());
        StructuredType st = sourceTableView.getBasedOnStructuredType();
        if (st != null) {
            StructuredType targetST = (StructuredType)objectsMap.get(st.getObjectID());
            if (targetST != null) {
                try {
                    targetTableView.setBasedOnStructuredType(targetST);
                }
                finally {
                    ApplicationView.loading = false;
                }
            }
        } else {
            targetTableView.setBasedOnStructuredType(null);
        }
        targetTableView.setIncludeSchemaNameInQuery(sourceTableView.includeSchemaNameInQuery());
        targetTableView.setSyntaxProvider(sourceTableView.getSyntaxProvider());
        targetTableView.setWhere(sourceTableView.getWhere());
        targetTableView.setGroupBy(sourceTableView.getGroupBy());
        targetTableView.setHaving(sourceTableView.getHaving());
        targetTableView.setUserDefined(sourceTableView.getUserDefined());
        targetTableView.setUserDefinedSQL(sourceTableView.getUserDefinedSQL());
        targetTableView.setOptimizerHints(sourceTableView.getOptimizerHints());
        targetTableView.setOidText(sourceTableView.getOidText());
        targetTableView.setAllowTypeSubstitution(sourceTableView.isAllowTypeSubstitution());
        targetTableView.setBeforeDrop(sourceTableView.getBeforeDrop());
        targetTableView.setBeforeCreate(sourceTableView.getBeforeCreate());
        targetTableView.setAfterCreate(sourceTableView.getAfterCreate());
        targetTableView.setEndOfScript(sourceTableView.getEndOfScript());
        targetTableView.setShouldGenerateScript(sourceTableView.getShouldGenerateScript());
        targetTableView.setORDSEnable(sourceTableView.isORDSEnable());
        targetTableView.setORDSAuth(sourceTableView.isORDSAuth());
        targetTableView.setORDSAlias(sourceTableView.getORDSAlias());
        sourceTableView.copyDynamicProperties(targetTableView);
        for (String alias : sourceTableView.getContainerMap().keySet()) {
            Table targetTable;
            String cID = sourceTableView.getContainerID(alias);
            Table table = (Table)this.sourceDesignPart.getTableSet().getObjectByID(cID);
            if (table == null || (targetTable = (Table)objectsMap.get(table.getObjectID())) == null) continue;
            targetTableView.addToContainers(targetTable, alias);
        }
        for (String id : sourceTableView.getOrderByMap().keySet()) {
            ColumnView key = (ColumnView)sourceTableView.getObjectByID(sourceTableView.getOrderByList(), id);
            if (key != null) {
                col = new ColumnView(targetTableView.getDesignPart());
                col.setDesign(targetTableView.getDesign());
                MergingModels.copyColumnToColumn(key, col);
                col.setView(targetTableView);
                targetTableView.addToOrderBy(col, (String)sourceTableView.getOrderByMap().get(id));
                objectsMap.put(key.getObjectID(), col);
                continue;
            }
            System.out.println("MergingModels.copyPropertiesFromTableViewToTableView: Unable to find ColumnView: " + id);
        }
        if (!sourceTableView.isBST()) {
            for (int i = 0; i < sourceTableView.getElements().length; ++i) {
                ColumnView scol = (ColumnView)sourceTableView.getElements()[i];
                ColumnView col2 = new ColumnView(targetTableView.getDesignPart());
                col2.setDesign(targetTableView.getDesign());
                MergingModels.copyColumnToColumn(scol, col2);
                col2.setView(targetTableView);
                col2.setContainer(targetTableView);
                targetTableView.add(col2);
                objectsMap.put(scol.getObjectID(), col2);
            }
        }
        for (int i = 0; i < sourceTableView.getGroupByList().size(); ++i) {
            col = (ColumnView)sourceTableView.getGroupByList().get(i);
            ColumnView tcol = (ColumnView)objectsMap.get(col.getObjectID());
            if (tcol == null) continue;
            targetTableView.addGroupByList(tcol);
        }
        sourceTableView.copyAllRemoteObjectIDsAndPath(targetTableView);
    }

    public static void copyColumnToColumn(ColumnView sourceColumnView, ColumnView targetColumnView) {
        DesignObject dobj;
        if (sourceColumnView.getGeneratorID() != null && !"User generated".equals(sourceColumnView.getGeneratorID()) && (dobj = (DesignObject)objectsMap.get(sourceColumnView.getGeneratorID())) != null && dobj instanceof AttributeView) {
            targetColumnView.setGeneratorID(dobj.getObjectID());
        }
        sourceColumnView.copyDefaults(targetColumnView);
        targetColumnView.setNameHasQuotes(sourceColumnView.getNameHasQuotes());
        targetColumnView.setTableAlias(sourceColumnView.getTableAlias());
        targetColumnView.setAlias(sourceColumnView.getAlias());
        targetColumnView.setHeaderAlias(sourceColumnView.getHeaderAlias());
        targetColumnView.setExpression(sourceColumnView.getExpression());
        targetColumnView.setDataType(sourceColumnView.getDataTypeString());
        if (sourceColumnView.getReferencedColumn() != null) {
            FKElement col = (FKElement)objectsMap.get(sourceColumnView.getReferencedColumn().getObjectID());
            targetColumnView.setReferencedColumn(col);
        }
        if (sourceColumnView.getTable() != null) {
            Table tTable = (Table)objectsMap.get(sourceColumnView.getTable().getObjectID());
            targetColumnView.setTable(tTable);
        }
        targetColumnView.setReference(sourceColumnView.isReference());
        targetColumnView.setStructuredType(sourceColumnView.getStructuredType());
    }

    public static boolean haveIdenticalColumnsAndSortType(KeyObject sourceIndex, KeyObject targetIndex, Map objectsMap, boolean isViewIndex) {
        if (sourceIndex.getElementsCollection().size() != targetIndex.getElementsCollection().size()) {
            return false;
        }
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        for (int j = 0; j < sourceColumns.length; ++j) {
            ContainedObject sourceColumn = sourceColumns[j];
            ContainedObject targetColumn = targetIndex.getElement(j);
            if (sourceIndex.getContainerObject().isBST() && targetIndex.getContainerObject().isBST() ? !targetColumn.getName().equals(sourceColumn.getName()) : (isViewIndex ? !targetColumn.getName().equalsIgnoreCase(sourceColumn.getName()) : !isViewIndex && !targetColumn.equals(objectsMap.get(sourceColumn.getObjectID())))) {
                return false;
            }
            if (sourceIndex.isPK() || sourceIndex.isUnique() || sourceIndex.getColumnSortOrder(sourceColumn).equals(targetIndex.getColumnSortOrder(targetColumn))) continue;
            return false;
        }
        return true;
    }

    public static Map getAllObject() {
        return allObject;
    }

    public static void setColumnScope(Column sourceColumn, Column targetColumn) {
        Table tTable;
        Table sTable = (Table)sourceColumn.getScope();
        if (sTable != null && (tTable = (Table)objectsMap.get(sTable.getObjectID())) != null) {
            targetColumn.setScopeId(tTable.getObjectID());
        }
    }

    public void synchronizeFKColumns(FKIndexAssociation sourcefkass, FKIndexAssociation targetfkass) {
        KeyObject sourceKeyObject = sourcefkass.getKeyObject();
        if (sourceKeyObject != null) {
            int i;
            FKElement[] sourcePKCols = (FKElement[])sourceKeyObject.getElements();
            FKContainer sourceTable = (FKContainer)sourcefkass.getContainerWithKeyObject();
            FKContainer targetTable = (FKContainer)targetfkass.getContainerWithKeyObject();
            ArrayList<FKElement> list = new ArrayList<FKElement>();
            for (i = 0; i < sourcePKCols.length; ++i) {
                FKElement sourceFKcol = sourceTable.getFKColumn(sourcefkass, sourcePKCols[i]);
                if (sourceFKcol == null) continue;
                FKElement targetFKcol = (FKElement)AbstractMerging.objectsMap.get(sourceFKcol.getObjectID());
                FKElement targetPKcol = null;
                if (targetFKcol != null) {
                    String scid = sourcePKCols[i].getObjectID();
                    targetPKcol = (FKElement)AbstractMerging.objectsMap.get(scid);
                    if (targetPKcol == null) {
                        targetPKcol = (FKElement)targetTable.getDesign().getDesignObject(scid);
                    }
                    if (targetPKcol == null) continue;
                    targetFKcol.addFKAssociation(targetPKcol, targetfkass);
                    targetfkass.getLocalFKIndex().add(targetFKcol);
                    list.add(targetFKcol);
                    continue;
                }
                targetPKcol = (FKElement)AbstractMerging.objectsMap.get(sourcePKCols[i].getObjectID());
                if (targetPKcol == null) continue;
                targetFKcol = targetTable.createColumnFK(targetPKcol, targetfkass);
                targetFKcol.setName(sourceFKcol.getName());
                MergingModels.copyPropertiesFromColumnToColumn(sourceFKcol, targetFKcol, objectsMap);
                MergingModels.copySourceStamp(sourceFKcol, targetFKcol);
                targetFKcol.moveToIndex(sourceFKcol.getIndex());
                targetfkass.getLocalFKIndex().add(targetFKcol);
                list.add(targetFKcol);
                AbstractMerging.objectsMap.put(sourceFKcol.getObjectID(), targetFKcol);
            }
            for (i = 0; i < list.size(); ++i) {
                targetfkass.getLocalFKIndex().moveToIndex((ContainedObject)list.get(i), i);
            }
        }
    }

    public static void synchronizeColumnsView(TableView sourceTableView, TableView targetTableView) {
        ColumnView col;
        targetTableView.removeAllFromElements();
        for (String alias : sourceTableView.getContainerMap().keySet()) {
            DesignObject targetTable;
            String cID = sourceTableView.getContainerID(alias);
            DesignObject table = sourceTableView.getDesign().getDesignObject(cID);
            if (table == null || (targetTable = (DesignObject)objectsMap.get(table.getObjectID())) == null || !(targetTable instanceof ContainerObject)) continue;
            targetTableView.addToContainers((ContainerObject)targetTable, alias);
        }
        targetTableView.removeAllElements();
        targetTableView.removeAllGroupByList();
        for (String id : sourceTableView.getOrderByMap().keySet()) {
            ColumnView key = (ColumnView)sourceTableView.getObjectByID(sourceTableView.getOrderByList(), id);
            if (key != null) {
                col = new ColumnView(targetTableView.getDesignPart());
                col.setDesign(targetTableView.getDesign());
                MergingModels.copyColumnToColumn(key, col);
                col.setView(targetTableView);
                targetTableView.addToOrderBy(col, (String)sourceTableView.getOrderByMap().get(id));
                objectsMap.put(key.getObjectID(), col);
                continue;
            }
            System.out.println("MergingModels.copyPropertiesFromTableViewToTableView: Unable to find ColumnView: " + id);
        }
        if (!sourceTableView.isBST()) {
            for (int i = 0; i < sourceTableView.getElements().length; ++i) {
                ColumnView scol = (ColumnView)sourceTableView.getElements()[i];
                ColumnView col2 = new ColumnView(targetTableView.getDesignPart());
                col2.setDesign(targetTableView.getDesign());
                MergingModels.copyColumnToColumn(scol, col2);
                col2.setView(targetTableView);
                col2.setContainer(targetTableView);
                targetTableView.add(col2);
                objectsMap.put(scol.getObjectID(), col2);
            }
        }
        targetTableView.removeAllFromOrderBy();
        for (int i = 0; i < sourceTableView.getGroupByList().size(); ++i) {
            col = (ColumnView)sourceTableView.getGroupByList().get(i);
            ColumnView tcol = (ColumnView)objectsMap.get(col.getObjectID());
            if (tcol == null) continue;
            targetTableView.addGroupByList(tcol);
        }
    }

    private void processSchemaObjects() {
        if (this.targetDesignPart.getSchemaObjectSet().size() > 0 && this.count == 0) {
            this.notEmpty = true;
        }
        Iterator it = this.sourceDesignPart.getSchemaObjectSet().iterator();
        while (it.hasNext()) {
            SchemaObject sourceSchemaObject = (SchemaObject)it.next();
            this.processSchemaObject(sourceSchemaObject);
        }
    }

    private void processSchemaObject(SchemaObject sourceSchemaObject) {
        SchemaObject targetSchemaObject = (SchemaObject)objectsMap.get(sourceSchemaObject.getObjectID());
        if (targetSchemaObject == null) {
            targetSchemaObject = (SchemaObject)this.targetDesignPart.getSchemaObjectSet().getByName(sourceSchemaObject.getName());
            if (targetSchemaObject == null) {
                targetSchemaObject = this.targetDesignPart.createSchemaObject(sourceSchemaObject.getName());
                targetSchemaObject.setNameHasQuotes(sourceSchemaObject.getNameHasQuotes());
            }
            if (!PropertiesComparator.DDL_ONLY) {
                targetSchemaObject.setComment(sourceSchemaObject.getComment());
                targetSchemaObject.setCommentInRDBMS(sourceSchemaObject.getCommentInRDBMS());
                targetSchemaObject.setNotes(sourceSchemaObject.getNotes());
                targetSchemaObject.setORDSDropSchema(sourceSchemaObject.isORDSDropSchema());
                targetSchemaObject.setORDSEnable(sourceSchemaObject.isORDSEnable());
                targetSchemaObject.setORDSAuth(sourceSchemaObject.isORDSAuth());
                targetSchemaObject.setORDSAlias(sourceSchemaObject.getORDSAlias());
                sourceSchemaObject.copyDynamicProperties(targetSchemaObject);
            }
            targetSchemaObject.setImportedId(sourceSchemaObject.getObjectID());
            objectsMap.put(sourceSchemaObject.getObjectID(), targetSchemaObject);
        }
    }

    private void processTypeSubstitutionT() {
        Iterator it = this.sourceDesignPart.getTableSet().iterator();
        while (it.hasNext()) {
            Table sourceTable = (Table)it.next();
            this.processTableTypeSubstitution(sourceTable);
        }
        it = this.sourceDesignPart.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView sourceTableView = (TableView)it.next();
            this.processTableTypeSubstitution(sourceTableView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTableTypeSubstitution(ContainerObject table) {
        ContainerObject target;
        TypeSubstitution sourceTS;
        if (table.shouldBeMerge() && (sourceTS = table.getTypeSubstitution()) != null && (target = (ContainerObject)objectsMap.get(table.getObjectID())) != null) {
            DesignPartView ldpv = target.getDesignPart().getMainView();
            ContainerObject tab = table.getTypeSubstitution().getParentContainerObject();
            ContainerObject ent = null;
            if (target.getTypeSubstitution() == null && (ent = (ContainerObject)objectsMap.get(tab.getObjectID())) != null) {
                boolean loading = ApplicationView.loading;
                try {
                    ApplicationView.loading = true;
                    TypeSubstitution ts = ((RelationalDesign)target.getDesignPart()).createTypeSubstitution();
                    objectsMap.put(sourceTS.getObjectID(), ts);
                    ContainerView childTV = (ContainerView)target.getFirstViewForDPV(ldpv);
                    ContainerView parentTV = (ContainerView)ent.getFirstViewForDPV(ldpv);
                    ts.setChildCV(childTV);
                    ts.setParentCV(parentTV);
                    ts.addToAllDPVs();
                }
                finally {
                    ApplicationView.loading = loading;
                }
            }
        }
    }
}

