/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;

public abstract class TypeSubstitution
extends DesignObject
implements ConnectionInterface {
    public static final String ID_PREFIX = "TYPESUBST";
    Collection dpvCol = new ArrayList();
    DesignPartView dpvPhysical;
    protected KeyObject keyObject = null;
    protected Map elementMap = new HashMap();
    private ContainerObject parentContainerObject;
    private ContainerObject childContainerObject;

    public TypeSubstitution(DesignPart designPart) {
        super(designPart);
    }

    public TypeSubstitution(DesignPart designPart, ContainerObject childCO, ContainerObject parentCO) {
        super(designPart);
        this.childContainerObject = childCO;
        this.parentContainerObject = parentCO;
    }

    @Override
    public String getIDPrefix() {
        return ID_PREFIX;
    }

    @Override
    public String getObjectTypeName() {
        return "TypeSubstitution";
    }

    @Override
    public void remove() {
        this.childContainerObject.clearTypeSubstitution(this);
        this.parentContainerObject.getSubTypeSubstitutions().remove(this);
        super.remove();
    }

    public void callRemoveListeners() {
        ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
        event.setAffected(this);
        this.fireChange(event);
        event.setAffected(null);
    }

    @Override
    public void setTopView(TopView view) {
        this.addTopView(view);
    }

    @Override
    public TopView getTopView() {
        for (DPVInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            return dpi.tv;
        }
        return null;
    }

    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        DPVInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv != null) {
            throw new RuntimeException("TypeSubstitution already exists");
        }
        inf.tv = view;
    }

    public ContainerObject getParentContainerObject() {
        return this.parentContainerObject;
    }

    @Override
    public void removeTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        DPVInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv == null) {
            return;
        }
        this.dpvCol.remove(inf);
        this.removeObjectListener(view);
    }

    @Override
    public void resetViewNumbers() {
    }

    public DPVInfo getDPVInfoFor(DesignPartView dpv) {
        DPVInfo dpi2;
        for (DPVInfo dpi2 : this.dpvCol) {
            if (dpi2.dpv != dpv) continue;
            return dpi2;
        }
        dpi2 = new DPVInfo();
        dpi2.dpv = dpv;
        this.dpvCol.add(dpi2);
        return dpi2;
    }

    @Override
    public TopView getViewFor(DesignPartView dpv) {
        DPVInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.tv;
    }

    public void setChildCV(ContainerView child) {
        DesignPartView dpv;
        if (this.childContainerObject == null) {
            this.setChildContainerObject((ContainerObject)child.getModel());
        }
        if (this.getChildCV(dpv = child.getDesignPartView()) != child) {
            DPVInfo dpi = this.getDPVInfoFor(dpv);
            if (dpi.childCV != null) {
                if (dpi.tv != null) {
                    ((TVTypeSubstitution)dpi.tv).removeConnection();
                }
                dpi.childCV.removeTopViewListener(this);
            }
            dpi.childCV = child;
            dpi.childCV.addTopViewListener(this);
            this.addTypeSubstitution(dpi);
        }
    }

    public void setParentCV(ContainerView parent) {
        DesignPartView dpv;
        if (this.parentContainerObject == null) {
            this.setParentContainerObject((ContainerObject)parent.getModel());
        }
        if (this.getParentCV(dpv = parent.getDesignPartView()) != parent) {
            DPVInfo dpi = this.getDPVInfoFor(dpv);
            if (dpi.parentCV != null) {
                if (dpi.tv != null) {
                    ((TVTypeSubstitution)dpi.tv).removeConnection();
                }
                dpi.parentCV.removeTopViewListener(this);
            }
            dpi.parentCV = parent;
            dpi.parentCV.addTopViewListener(this);
            this.addTypeSubstitution(dpi);
        }
    }

    public void addTypeSubstitution(DPVInfo dpi) {
        if (dpi.tv == null && dpi.childCV != null && dpi.parentCV != null && dpi.dpv != null) {
            TVTypeSubstitution tvr = new TVTypeSubstitution(this.getAppView(), dpi.dpv);
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpi.dpv.registerForTreemodel(tvr);
            if (dpi.dpv.isVisible() && !ApplicationView.loading) {
                tvr.addConnection();
            }
        } else if (dpi.tv != null && dpi.childCV != null && dpi.parentCV != null && dpi.dpv != null && ((TVTypeSubstitution)dpi.tv).getEdge() == null && !ApplicationView.loading) {
            ((TVTypeSubstitution)dpi.tv).addConnection();
        }
    }

    public void addToAllDPVs() {
        DesignPartView dpv;
        Collection targetDPVs = this.getChildContainerObject().getAffectedDPVs();
        Collection sourceDPVs = this.getParentContainerObject().getAffectedDPVs();
        Iterator tit = targetDPVs.iterator();
        Iterator sit = sourceDPVs.iterator();
        while (tit.hasNext()) {
            dpv = (DesignPartView)tit.next();
            this.getParentCV(dpv);
        }
        while (sit.hasNext()) {
            dpv = (DesignPartView)sit.next();
            this.getChildCV(dpv);
        }
    }

    public ContainerView getChildCV() {
        DesignPartView dpv = ApplicationView.loading ? this.getDesign().getRelationalDesign().getMainView() : this.getAppView().getCurrentDPV();
        return this.getChildCV(dpv);
    }

    public ContainerView getParentCV() {
        DesignPartView dpv = ApplicationView.loading ? this.getDesign().getRelationalDesign().getMainView() : this.getAppView().getCurrentDPV();
        return this.getParentCV(dpv);
    }

    public ContainerView getChildCV(DesignPartView dpv) {
        Collection c;
        DPVInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.childCV == null && this.getChildContainerObject() != null && !(c = this.getChildContainerObject().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.childCV = (ContainerView)it.next();
            dpi.childCV.addTopViewListener(this);
            this.addTypeSubstitution(dpi);
        }
        return dpi.childCV;
    }

    public ContainerView getParentCV(DesignPartView dpv) {
        Collection c;
        DPVInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.parentCV == null && this.getParentContainerObject() != null && !(c = this.getParentContainerObject().getAllViews(dpv)).isEmpty()) {
            Iterator it = c.iterator();
            dpi.parentCV = (ContainerView)it.next();
            dpi.parentCV.addTopViewListener(this);
            this.addTypeSubstitution(dpi);
        }
        return dpi.parentCV;
    }

    @Override
    public void changed(TopView tv, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView dpv = tv.getDesignPartView();
            dpv.removeViewFor(this);
            DPVInfo dpi = this.getDPVInfoFor(dpv);
            dpi.tv = null;
            if (dpi.childCV == tv) {
                dpi.childCV = null;
            }
            if (dpi.parentCV == tv) {
                dpi.parentCV = null;
            }
        }
    }

    public ContainerObject getChildContainerObject() {
        return this.childContainerObject;
    }

    @Override
    public boolean hasAliveGenerator() {
        RelationSet iset;
        DesignObject obj;
        RelationSet set = this.getDesign().getLogicalDesign().getRelationSet();
        return "User generated".equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null || (obj = (iset = this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            // empty if block
        }
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView dpv) {
        return this.getViewFor(dpv) != null;
    }

    public void setParentContainerObject(ContainerObject parentContainerObject) {
        this.parentContainerObject = parentContainerObject;
        if (parentContainerObject != null) {
            parentContainerObject.getSubTypeSubstitutions().add(this);
        }
    }

    public void setChildContainerObject(ContainerObject childContainerObject) {
        this.childContainerObject = childContainerObject;
        if (childContainerObject != null) {
            childContainerObject.setTypeSubstitution(this);
            this.setPAC_Element(childContainerObject);
        }
    }

    @Override
    public void setSourceTopView(TopView source) {
        this.setParentCV((ContainerView)source);
    }

    @Override
    public void setTargetTopView(TopView target) {
        this.setChildCV((ContainerView)target);
    }

    @Override
    public TopView getSourceTopView(DesignPartView dpv) {
        return this.getParentCV(dpv);
    }

    @Override
    public TopView getTargetTopView(DesignPartView dpv) {
        return this.getChildCV(dpv);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        return this.getViewFor(dpv);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getParentContainerObject();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getChildContainerObject();
    }

    @Override
    public List getAllViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (Flow.dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            col.add(dpi.tv);
        }
        return col;
    }

    @Override
    public void restoreTopView(TopView tv, TopView sourceTV, TopView targetTV) {
        tv.getDesignPartView().restoreTopview(tv, this);
        DPVInfo dpi = this.getDPVInfoFor(tv.getDesignPartView());
        if (dpi.tv == tv) {
            this.addObjectListener(tv);
            dpi.parentCV = (ContainerView)targetTV;
            dpi.parentCV.addTopViewListener(this);
            dpi.childCV = (ContainerView)sourceTV;
            dpi.childCV.addTopViewListener(this);
        }
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    private class DPVInfo {
        public ContainerView childCV;
        public ContainerView parentCV;
        public TopView tv;
        public DesignPartView dpv;

        DPVInfo() {
        }
    }
}

