/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.imports.var.process.RHProcessModelEvents;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.util.logging.Logger;

public class RHPersonEvent
extends RowHandler {
    public static final String OBJECT_TYPE = "PERSON_EVENT";
    private static final Logger LOGGER = new Logger(RHPersonEvent.class);

    public RHPersonEvent(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createEvent(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createEvent(VarFileLine line) {
        try {
            DataFlowDesign diagram;
            String eventID = this.getField(line, "general_id");
            String eventName = this.getField(line, "EVENT_NAME");
            String diagramID = this.getDiagramID(eventID);
            DesignObject event = null;
            if (!"".equalsIgnoreCase(diagramID) && (diagram = (DataFlowDesign)this.getAllCreatedObjects().get(diagramID)) != null) {
                event = diagram.getProcessModel().createEvent(2);
            }
            if (event != null) {
                event.setName(eventName);
                String comment = this.getComment(line);
                event.setComment(comment);
                ((AbstractProcessObject)event).setSynonym(this.getSynonym(line));
                event.setNotes(this.getNotes(line, "NOTE_PERSON_EVENT_ID"));
                ((Event)event).setText(this.getEventText(line));
                this.addCreatedObject(eventID, event);
                this.removeSelectedLine(line);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in RHPersonEvent.createEvent()", e);
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        String textID = this.getField(line, "EVENT_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getDiagramID(String eventID) {
        List pmEvents = this.getSpecificRowHandler(RHProcessModelEvents.class).getOwnLines();
        for (VarFileLine line : pmEvents) {
            if (!line.getType().equalsIgnoreCase("PROCESS_MODELPERSO") || !eventID.equalsIgnoreCase(this.getField(line, "DESTINATION_OBJECT_ID"))) continue;
            String diagramID = this.getField(line, "general_id");
            return diagramID;
        }
        return "";
    }

    private String getSynonym(VarFileLine line) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine synonymLine;
            String synID;
            String lineID;
            if (!selectedLine.getType().equalsIgnoreCase("PERSON_EVENTSYNONY") || !id.equalsIgnoreCase(lineID = this.getField(selectedLine, "general_id")) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT")) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }

    private String getEventText(VarFileLine line) {
        String comment = null;
        String soID = this.getField(line, "EVENT_EVENT_TEXT_ID");
        if (!"0".equalsIgnoreCase(soID)) {
            VarFileLine commentLine = this.getCommentLine(soID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }
}

