/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.datatype.sqlserver.MDXMLTypeSqlServer;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.ColumnProxySqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SecondaryXmlIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableSQLServerv2k5
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "TABLE";
    protected static final String COL_OBJECT_TYPE = "COLUMN";
    protected static final String SIZE = "size";
    protected static final String PRECISION = "precision";
    protected static final String SCALE = "scale";
    private static final Logger LOGGER = new Logger(MOHTableSQLServerv2k5.class);

    public MOHTableSQLServerv2k5(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList list = new ArrayList();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dbo = (DBUserSqlServer)dboNext;
            list.addAll(MOHTableSQLServerv2k5.extractByUser(sqlConnection, dbo));
        }
        return list;
    }

    private static List extractByUser(Connection sqlConnection, DBUserSqlServer dbUser) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        String uid = dbUser.getId();
        String db = dbUser.getDb();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append("TABLENAME").append(',').append(' ');
            buffer.append("ID").append(',').append(' ');
            buffer.append("UID").append(' ');
            buffer.append("USERID").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append('.').append("dbo.sysobjects").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("XTYPE").append(' ');
            buffer.append('=').append(' ');
            buffer.append('\'').append("U").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(uid).append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSQLServerv2k5.extractByUser():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String tableName = rs.getString(1);
                DBObjectSqlServer dboTable = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), tableName, OBJECT_TYPE, "");
                dboTable.setDb(db);
                dboTable.setSchema(dbUser.getName());
                list.add(dboTable);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }

    protected ResultSet getTables(DatabaseMetaData dbmd, DBObject dbo, boolean all) throws Exception {
        DBObjectSqlServer dboSql = (DBObjectSqlServer)dbo;
        if (all) {
            return dbmd.getTables(dbo.getName(), null, "%", new String[]{OBJECT_TYPE});
        }
        return dbmd.getTables(dboSql.getDb(), null, dbo.getName(), new String[]{OBJECT_TYPE});
    }

    protected ResultSet getColumns(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        DBObjectSqlServer dboSql = (DBObjectSqlServer)dboTable;
        return dbmd.getColumns(dboSql.getDb(), null, dboTable.getName(), "%");
    }

    protected ResultSet getPrimaryKeys(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        DBObjectSqlServer dboSql = (DBObjectSqlServer)dboTable;
        return dbmd.getPrimaryKeys(dboSql.getDb(), null, dboTable.getName());
    }

    protected ResultSet getIndexInfo(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        DBObjectSqlServer dboSql = (DBObjectSqlServer)dboTable;
        return dbmd.getIndexInfo(dboSql.getDb(), null, dboTable.getName(), false, false);
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Start Tables");
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String tableName = dbo.getName();
            String db = dbo.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("o").append('.').append("NAME").append(' ');
                buffer.append("TABLENAME").append(' ');
                buffer.append(',').append(' ');
                buffer.append("u").append('.').append("NAME").append(' ');
                buffer.append("SCHEMA_NAME").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o").append('.').append("ID").append(' ');
                buffer.append("TABLEID").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append('.').append("dbo.sysobjects o").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append('.').append("sys.schemas u").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("XTYPE").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append("U").append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o").append('.').append("UID").append(' ');
                buffer.append('=').append(' ');
                buffer.append("u").append('.').append("SCHEMA_ID").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o").append('.').append("NAME").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append(tableName).append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("u").append('.').append("NAME").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append(dbo.getSchema()).append('\'');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTableSqlServer.extract():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    String username = rs.getString(2);
                    String tableId = rs.getString(3);
                    if (!name.equals(tableName)) continue;
                    Table table = this.getDesign().getRelationalDesign().createTable();
                    table.setSchema(db + "_" + dbo.getSchema());
                    table.setName(name);
                    this.stampModelObject((ModelObject)table, dbo.getSchema(), name);
                    TreeMap columns = new TreeMap();
                    this.initColumns(sqlConnection, table, tableId, db, columns);
                    this.initIndexes(sqlConnection, table, tableId, db, dbo.getSchema());
                    this.initConstraints(sqlConnection, table, tableId, db, columns, dbo.getSchema());
                    this.initUniqueKeys(sqlConnection, table, tableId, db, dbo.getSchema());
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                        StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                        TableProxySqlServer tableProxy = (TableProxySqlServer)storage.getTableProxySet().getProxy(table.getObjectID());
                        if (tableProxy != null) {
                            DataBaseSqlServer database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                            if (database == null) {
                                database = storage.getDataBaseSet().createDataBase();
                                database.setName(db);
                                this.stampModelObject((ModelObject)database, "", db);
                            }
                            tableProxy.setDatabase(database);
                            this.setSchema(tableProxy, dbo.getSchema(), database);
                            this.setFilegroups(tableProxy, tableId, storage, database, sqlConnection);
                            this.setFileGroupsOrPartitionSchema(tableProxy, tableId, storage, (DataBaseSqlServerv2k5)database, sqlConnection);
                            this.initTriggers(sqlConnection, tableProxy, tableId, db, dbo.getSchema());
                            continue;
                        }
                        LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID());
                        continue;
                    }
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        TimeLog.log("End Tables");
    }

    private void setSchema(TableProxySqlServer tableProxy, String username, DataBaseSqlServer database) {
        SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)database.getSchemas().getByName(username);
        if (schema != null) {
            tableProxy.setSchema(schema);
            SchemaObject schemaObj = ((Table)tableProxy.getObject()).getSchemaObject();
            if (schemaObj != null) {
                schema.setSchemaObject(schemaObj);
            }
        }
    }

    private void setFileGroupsOrPartitionSchema(TableProxySqlServer tableProxy, String tableId, StorageDesignSqlServer storage, DataBaseSqlServerv2k5 database, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(database)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("tbl").append('.').append("NAME").append(' ');
            buffer.append("AS").append(' ').append("[").append("NAME").append("]").append(',');
            buffer.append("tbl").append('.').append("object_id").append(' ');
            buffer.append("AS").append(' ').append("[").append("ID").append("]").append(',');
            buffer.append("SCHEMA_NAME").append('(').append("tbl").append('.').append("schema_id").append(')');
            buffer.append(' ').append("AS").append(' ').append("[").append("SCHEMA").append("]").append(',');
            buffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'HasAfterTrigger') AS bit) AS [HasAfterTrigger], ");
            buffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'HasInsertTrigger') AS bit) AS [HasInsertTrigger], ");
            buffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'HasDeleteTrigger') AS bit) AS [HasDeleteTrigger], ");
            buffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'HasInsteadOfTrigger') AS bit) AS [HasInsteadOfTrigger], ");
            buffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'HasUpdateTrigger') AS bit) AS [HasUpdateTrigger], ");
            buffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'IsIndexed') AS bit) AS [HasIndex], ");
            buffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'IsIndexable') AS bit) AS [IsIndexable], ");
            buffer.append("CAST(CASE idx.index_id WHEN 1 THEN 1 ELSE 0 END AS bit) AS [HasClusteredIndex], ");
            buffer.append("ISNULL(dstext.name,N'') AS [TextFileGroup],dstext.data_space_id AS [TextFileGroup_ID], ");
            buffer.append("tbl.is_replicated AS [Replicated], ");
            buffer.append("ISNULL( ( select sum (spart.rows) from sys.partitions spart where ");
            buffer.append("spart.object_id = tbl.object_id and spart.index_id < 2), 0) AS [RowCount], ");
            buffer.append("tbl.uses_ansi_nulls AS [AnsiNullsStatus], ");
            buffer.append("CAST(OBJECTPROPERTY(tbl.object_id,N'IsQuotedIdentOn') AS bit) AS [QuotedIdentifierStatus], ");
            buffer.append("CAST(0 AS bit) AS [FakeSystemTable], ");
            buffer.append("CASE WHEN 'FG'=dsidx.type THEN dsidx.name ELSE N'' END AS [FileGroup], ");
            buffer.append("CASE WHEN 'PS'=dsidx.type THEN dsidx.name ELSE N'' END AS [PartitionScheme], ");
            buffer.append("CAST(CASE WHEN 'PS'=dsidx.type THEN 1 ELSE 0 END AS bit) AS [IsPartitioned], ");
            buffer.append("dsidx.data_space_id AS [FG_PS_dataspace_id], ");
            buffer.append("dstext.type as text_dataspace_type ");
            buffer.append("FROM").append(' ').append("sys.tables").append(' ').append("AS").append(' ').append("tbl ");
            buffer.append("INNER JOIN sys.indexes AS idx ON idx.object_id = tbl.object_id and idx.index_id < 2 ");
            buffer.append("LEFT OUTER JOIN sys.data_spaces AS dstext  ON tbl.lob_data_space_id = dstext.data_space_id ");
            buffer.append("LEFT OUTER JOIN sys.data_spaces AS dsidx ON dsidx.data_space_id = idx.data_space_id ");
            buffer.append("WHERE").append(' ').append("tbl.object_id ").append('=').append(' ').append(tableId);
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    FileGroupSqlServer group;
                    String textImageName = rs.getString(12);
                    String fileGroupName = rs.getString(19);
                    String partitionSchemaName = rs.getString(20);
                    String textImageType = rs.getString(23);
                    if (!fileGroupName.equals("")) {
                        group = (FileGroupSqlServer)database.getFilegroups().getByName(fileGroupName);
                        if (group == null) {
                            group = storage.getFileGroupSet().createFileGroup();
                            group.setName(fileGroupName);
                            group.setDataBase(database);
                            this.stampModelObject((ModelObject)group, database, fileGroupName);
                        }
                        tableProxy.setFilegroup(group);
                    }
                    if (!textImageName.equals("") && textImageType.equalsIgnoreCase("FG")) {
                        group = (FileGroupSqlServer)database.getFilegroups().getByName(textImageName);
                        if (group == null) {
                            group = storage.getFileGroupSet().createFileGroup();
                            group.setName(textImageName);
                            group.setDataBase(database);
                            this.stampModelObject((ModelObject)group, database, fileGroupName);
                        }
                        tableProxy.setTextImageFG(group);
                    }
                    if (partitionSchemaName.equals("")) continue;
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.setFileGroupsOrPartitionSchema():", e);
        }
    }

    private void setFilegroups(TableProxySqlServer tableProxy, String tableId, StorageDesignSqlServer storage, DataBaseSqlServer database, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("s").append('.').append("GROUPNAME").append(' ');
            buffer.append("filegroup").append(' ');
            buffer.append(',').append(' ');
            buffer.append("i").append('.').append("indid").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(database.getName())).append('.').append("dbo.sysfilegroups s").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(database.getName())).append('.').append("dbo.sysindexes i").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("i").append('.').append("ID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("(i.indid =0 or i.indid = 255)").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("i").append('.').append("GROUPID").append(' ');
            buffer.append('=').append(' ');
            buffer.append("s").append('.').append("GROUPID").append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    FileGroupSqlServer group;
                    String groupName = rs.getString(1);
                    int indid = rs.getInt(2);
                    if (indid == 0) {
                        group = (FileGroupSqlServer)database.getFilegroups().getByName(groupName);
                        if (group == null) {
                            group = storage.getFileGroupSet().createFileGroup();
                            group.setName(groupName);
                            group.setDataBase(database);
                            this.stampModelObject((ModelObject)group, database, groupName);
                        }
                        tableProxy.setFilegroup(group);
                        continue;
                    }
                    if (indid != 255) continue;
                    group = (FileGroupSqlServer)database.getFilegroups().getByName(groupName);
                    if (group == null) {
                        group = storage.getFileGroupSet().createFileGroup();
                        group.setName(groupName);
                        group.setDataBase(database);
                        this.stampModelObject((ModelObject)group, database, groupName);
                    }
                    tableProxy.setTextImageFG(group);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initFilegroups():", e);
        }
    }

    private void initColumns(Connection sqlConnection, Table table, String tableId, String db, Map columns) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("c").append('.');
            buffer.append("NAME").append(' ');
            buffer.append("colname").append(' ');
            buffer.append(',').append(' ');
            buffer.append("t").append('.');
            buffer.append("NAME").append(' ');
            buffer.append("typename").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("colid").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("length").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("prec").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append(SCALE).append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("isnullable").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("iscomputed").append(' ');
            buffer.append(',').append(' ');
            buffer.append("computed_expr = com.text").append(' ');
            buffer.append(',').append(' ');
            buffer.append("c").append('.');
            buffer.append("collation").append(' ');
            buffer.append(',').append(' ');
            buffer.append("identitycolumn = ");
            buffer.append("case c.colstat & 1 ");
            buffer.append("when 1 then 'YES' ");
            buffer.append("else 'NO' ");
            buffer.append("end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("ROWGUIDCOLL = ColumnProperty(c.id, c.name, 'IsRowGuidCol')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("default_value = def.text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append('.').append("dbo.systypes t").append(',');
            buffer.append('(').append(' ').append(MOHTableSQLServerv2k5.getFormattedName(db)).append('.');
            buffer.append("dbo.syscolumns c ");
            buffer.append("Left Outer Join ");
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append('.');
            buffer.append("dbo.syscomments com ");
            buffer.append("On com.id = c.id and com.number = c.colid ");
            buffer.append("Left Outer Join ");
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append('.');
            buffer.append("dbo.syscomments def ");
            buffer.append("On def.id = c.cdefault and c.cdefault > 0");
            buffer.append(')').append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("c.id ").append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("c.xusertype ").append('=').append(" t.xusertype").append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("c.colorder");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initColumns():", e);
        }
        RDBMSType dbtype = this.getStorageDesign().getRDBMSType();
        if (rs != null) {
            while (rs.next()) {
                StorageDesign storageDesign;
                LogicalDatatype lt;
                String colName = rs.getString(1);
                String colDatatype = rs.getString(2);
                String colId = rs.getString(3);
                int colSize = rs.getInt(4);
                int colPrecision = rs.getInt(5);
                int colScale = rs.getInt(6);
                int isNullable = rs.getInt(7);
                int isComputed = rs.getInt(8);
                String computedExpr = rs.getString(9);
                String collation = rs.getString(10);
                String identitycolumn = rs.getString(11);
                int rowgiudcoll = rs.getInt(12);
                String defaultValue = rs.getString(13);
                boolean isvarcharMax = false;
                if ((colDatatype.equalsIgnoreCase("varchar") || colDatatype.equalsIgnoreCase("nvarchar")) && colSize == -1) {
                    isvarcharMax = true;
                }
                if (colDatatype.equalsIgnoreCase("nchar") || colDatatype.equalsIgnoreCase("nvarchar")) {
                    colSize /= 2;
                }
                Column column = table.createColumn(colName);
                this.stampModelObject((ModelObject)column, table.getName(), colName);
                if (colId != null) {
                    columns.put(colId, column);
                }
                String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(colDatatype);
                LogicalDatatype logDatatype = null;
                if (isvarcharMax && (lt = this.getDesign().getLogicalDatatypeSet().getLogTypeForVarcharMax(colDatatype, this.getDbmeHandler().getRDBMSSite().getType().getName())) != null) {
                    logDatatype = lt;
                }
                NativeDBType nt = null;
                if (logDatatype == null && (nt = StandardDatatypeNames.getNativeDBType(dbtype, colDatatype)) != null) {
                    logDatatype = nt.getLogicalDatatype();
                }
                if (logDatatype == null) {
                    logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                }
                if (logDatatype == null) {
                    logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(colDatatype, this.getDbmeHandler().getRDBMSSite().getType().getName());
                }
                if (logDatatype != null && !"UNKNOWN".equalsIgnoreCase(usedDatatype)) {
                    column.setUse((short)1);
                    column.setLogicalDatatype(logDatatype);
                    if (isvarcharMax) {
                        column.setDataTypeParameter(SIZE, "max");
                    } else {
                        column.setDataTypeParameter(SIZE, String.valueOf(colSize));
                    }
                    column.setDataTypeParameter(PRECISION, String.valueOf(colPrecision));
                    column.setDataTypeParameter(SCALE, String.valueOf(colScale));
                } else {
                    DistinctType dt = (DistinctType)this.getDesign().getDataTypesDesign().getDistinctTypeSet().getByName(colDatatype);
                    if (dt != null) {
                        column.setUse((short)2);
                        column.setDistinctType(dt);
                    } else {
                        column.setUse((short)1);
                        column.setLogicalDatatype(logDatatype);
                        column.setDataTypeParameter(SIZE, String.valueOf(colSize));
                        column.setDataTypeParameter(PRECISION, String.valueOf(colPrecision));
                        column.setDataTypeParameter(SCALE, String.valueOf(colScale));
                        System.out.println("Unable to find logical datatype for: " + colDatatype);
                    }
                }
                column.setNullsAllowed(isNullable == 1);
                if (isComputed != 0) {
                    column.setComputed(true);
                    column.setFormulaDesc(computedExpr);
                }
                if (defaultValue != null) {
                    while (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
                        defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                    }
                    while (defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                        defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                    }
                    column.setDefaultValue(defaultValue);
                }
                if ((storageDesign = this.getStorageDesign()) != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                    ColumnProxySqlServerv2k5 columnProxy = (ColumnProxySqlServerv2k5)storage.getColumnProxySet().getProxy(column.getObjectID());
                    if (columnProxy != null) {
                        if (rowgiudcoll == 0) {
                            columnProxy.setRowGuidCol("NO");
                        } else {
                            columnProxy.setRowGuidCol("YES");
                        }
                        columnProxy.setAsIdentity("YES".equalsIgnoreCase(identitycolumn));
                        if ("YES".equalsIgnoreCase(identitycolumn)) {
                            this.processIdentityColumn(sqlConnection, table, tableId, colId, db, column, columnProxy);
                        }
                        columnProxy.setCollation(collation);
                        if (!(columnProxy.getDataType() instanceof MDXMLTypeSqlServer)) continue;
                        this.initXMLSchemaCollection(sqlConnection, db, tableId, colId, columnProxy, storage);
                        continue;
                    }
                    LOGGER.error("Unable to find ColumnProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void processIdentityColumn(Connection sqlConnection, Table table, String tableId, String colId, String db, Column col, ColumnProxySqlServer cp) {
        Statement statement;
        block15: {
            statement = null;
            try {
                statement = sqlConnection.createStatement();
            }
            catch (SQLException e1) {
                // empty catch block
            }
            ResultSet rs = null;
            try {
                String sql;
                if (statement == null || (rs = statement.executeQuery(sql = "select CONVERT(varchar(100),seed_value) seed_value,CONVERT(varchar(100),increment_value) increment_value,is_not_for_replication from " + MOHTableSQLServerv2k5.getFormattedName(db) + ".sys.identity_columns where object_id  = " + tableId + " and column_id = " + colId)) == null) break block15;
                if (rs.next()) {
                    String seed = rs.getString(1);
                    String incr = rs.getString(2);
                    String rep = rs.getString(3);
                    cp.setIdentitySeed(seed);
                    col.setIdentityColumn(true);
                    col.setAutoIncrementColumn(true);
                    col.setAutoIncrementStartWith(seed);
                    try {
                        int increment = Integer.parseInt(incr);
                        cp.setIdentityIncrement(increment);
                        col.setAutoIncrementIncrementBy(increment);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    boolean notForReplication = false;
                    try {
                        int nrep = Integer.parseInt(rep);
                        if (nrep == 1) {
                            notForReplication = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (notForReplication) {
                        cp.setIdentityForReplication("NO");
                    } else {
                        cp.setIdentityForReplication("YES");
                    }
                }
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void initXMLSchemaCollection(Connection sqlConnection, String db, String tableId, String colId, ColumnProxySqlServerv2k5 columnProxy, StorageDesignSqlServer storage) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("x.name xml_collection,s.name as [schema],x.schema_id, is_xml_document ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.columns c").append(' ');
            buffer.append("Left Join sys.xml_schema_collections as x on c.xml_collection_id = x.xml_collection_id  ");
            buffer.append("Left Join sys.schemas as s on x.schema_id = s.schema_id ");
            buffer.append("WHERE").append(' ');
            buffer.append("c.object_id ").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("c.column_id").append(' ').append('=').append(' ').append(colId).append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initXMLSchemaCollection():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String schema = rs.getString(2);
                String collectionType = rs.getString(3);
                String longName = schema + "." + name;
                XMLSchemaCollectionSqlServerv2k5 xmlCollection = this.getXmlCollectionByNameAndSchema(longName, storage);
                if (xmlCollection == null) continue;
                columnProxy.setXmlSchemaCollection(xmlCollection);
                if (!"1".equals(collectionType)) continue;
                columnProxy.setCollectionType("DOCUMENT");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private XMLSchemaCollectionSqlServerv2k5 getXmlCollectionByNameAndSchema(String longName, StorageDesignSqlServer storage) {
        for (XMLSchemaCollectionSqlServerv2k5 xmlCollection : ((StorageDesignSqlServerv2k5)storage).getXmlSchemaCollectionSet()) {
            if (!xmlCollection.getLongName().equals(longName)) continue;
            return xmlCollection;
        }
        return null;
    }

    protected void initIndexes(Connection sqlConnection, Table table, String tableId, String db, String dboSchema) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("i.name, i.index_id, i.type,i.type_desc,i.is_primary_key, ");
            buffer.append("i.is_unique_constraint,i.is_unique, ");
            buffer.append("i.ignore_dup_key,i.fill_factor,i.is_padded,i.allow_row_locks, ");
            buffer.append("i.allow_page_locks,i.data_space_id,ds.name ds_name,ds.type ds_type, ");
            buffer.append("s.no_recompute AS [NoAutomaticRecomputation] ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.indexes i INNER Join sys.data_spaces as ds ON i.data_space_id = ds.data_space_id ");
            buffer.append("LEFT OUTER JOIN sys.stats AS s ON s.stats_id = i.index_id AND  ");
            buffer.append("s.object_id = i.object_id ");
            buffer.append("WHERE").append(' ');
            buffer.append("i.object_id = ").append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("i.is_primary_key = 0 ");
            buffer.append("AND").append(' ');
            buffer.append("i.is_unique_constraint = 0 ");
            buffer.append("AND").append(' ');
            buffer.append("i.type<>3 and i.name is not null ");
            buffer.append("union select i.name, i.index_id, ");
            buffer.append("i.type,i.type_desc,i.is_primary_key,i.is_unique_constraint,i.is_unique, ");
            buffer.append("i.ignore_dup_key,i.fill_factor,i.is_padded,i.allow_row_locks, i.allow_page_locks, ");
            buffer.append("i.data_space_id,ds.name ds_name,ds.type ds_type,s.no_recompute AS [NoAutomaticRecomputation]  ");
            buffer.append("from sys.xml_indexes i INNER Join sys.data_spaces as ds ON i.data_space_id = ds.data_space_id ");
            buffer.append("LEFT OUTER JOIN sys.stats AS s ON s.stats_id = i.index_id AND ");
            buffer.append("s.object_id = i.object_id ");
            buffer.append("where  i.object_id = ").append(tableId).append(' ');
            buffer.append("and i.is_primary_key = 0 ");
            buffer.append("and i.is_unique_constraint = 0 ");
            buffer.append("and i.using_xml_index_id is null ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initIndexes():", e);
        }
        ArrayList<Properties> list = new ArrayList<Properties>();
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String indId = rs.getString(2);
                String clustered = rs.getString(4);
                String unique = rs.getString(7);
                String ignoreDupKeys = rs.getString(8);
                int fillFactor = rs.getInt(9);
                String isPadIndex = rs.getString(10);
                String allow_row_locks = rs.getString(11);
                String allow_page_locks = rs.getString(12);
                String ds_name = rs.getString(14);
                String ds_type = rs.getString(15);
                String statsNoRecompute = rs.getString(16);
                if (name != null) {
                    Properties props = new Properties();
                    props.setProperty("name", name);
                    props.setProperty("indId", indId);
                    props.setProperty("clustered", clustered);
                    props.setProperty("unique", unique);
                    props.setProperty("ignoreDupKeys", ignoreDupKeys);
                    props.setProperty("fillFactor", String.valueOf(fillFactor));
                    props.setProperty("isPadIndex", isPadIndex);
                    props.setProperty("allow_row_locks", allow_row_locks);
                    props.setProperty("allow_page_locks", allow_page_locks);
                    props.setProperty("ds_name", ds_name);
                    props.setProperty("ds_type", ds_type);
                    props.setProperty("statsNoRecompute", statsNoRecompute != null ? statsNoRecompute : "");
                    list.add(props);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
        }
        if (statement != null) {
            statement.close();
        }
        for (Properties props : list) {
            String name = props.getProperty("name");
            String indId = props.getProperty("indId");
            String clustered = props.getProperty("clustered");
            String unique = props.getProperty("unique");
            String ignoreDupKeys = props.getProperty("ignoreDupKeys");
            int fillFactor = Integer.parseInt(props.getProperty("fillFactor"));
            String isPadIndex = props.getProperty("isPadIndex");
            String allow_row_locks = props.getProperty("allow_row_locks");
            String allow_page_locks = props.getProperty("allow_page_locks");
            String ds_name = props.getProperty("ds_name");
            String ds_type = props.getProperty("ds_type");
            String statsNoRecompute = props.getProperty("statsNoRecompute");
            Index index = table.createIndex();
            index.setName(name);
            this.stampModelObject((ModelObject)index, dboSchema, name);
            if ("1".equalsIgnoreCase(unique)) {
                index.setIndexState("Unique Plain Index");
            }
            this.initKeyColumns(index, table, tableId, indId, db, sqlConnection);
            StorageDesign storageDesign = this.getStorageDesign();
            StorageDesign storage = null;
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                storage = (StorageDesignSqlServer)storageDesign;
            }
            if (storage != null) {
                IndexProxySqlServerv2k5 proxy = (IndexProxySqlServerv2k5)storage.getIndexProxySet().getProxy(index.getObjectID());
                if (proxy != null) {
                    PartitionSchemeSqlServerv2k5 partSchema;
                    if ("CLUSTERED".equalsIgnoreCase(clustered)) {
                        proxy.setClustered(true);
                    } else {
                        proxy.setClustered(false);
                    }
                    proxy.setFillFactor(fillFactor);
                    if ("1".equalsIgnoreCase(statsNoRecompute)) {
                        proxy.setRecomputeStatistics("ON");
                    } else {
                        proxy.setRecomputeStatistics("OFF");
                    }
                    proxy.setIgnoreDupKey(ignoreDupKeys);
                    if ("1".equalsIgnoreCase(isPadIndex)) {
                        proxy.setPadIndex("YES");
                    } else {
                        proxy.setPadIndex("NO");
                    }
                    DataBaseSqlServer database = (DataBaseSqlServer)((StorageDesignSqlServer)storage).getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = ((StorageDesignSqlServer)storage).getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                    if (ds_type.equalsIgnoreCase("FG")) {
                        FileGroupSqlServer group = (FileGroupSqlServer)database.getFilegroups().getByName(ds_name);
                        if (group == null) {
                            group = ((StorageDesignSqlServer)storage).getFileGroupSet().createFileGroup();
                            group.setName(ds_name);
                            group.setDataBase(database);
                            this.stampModelObject((ModelObject)group, proxy, ds_name);
                        }
                        proxy.setFilegroup(group);
                    }
                    if (ds_type.equalsIgnoreCase("PS") && (partSchema = this.getPartitionSchemaByName(ds_name, database)) != null) {
                        proxy.setPartitionScheme(partSchema);
                    }
                    if (proxy.isPrimaryXmlIndex()) {
                        this.initSecondaryXMLIndex(sqlConnection, db, tableId, indId, proxy);
                    }
                    if ("0".equals(allow_page_locks)) {
                        proxy.setAllowPageLocks("OFF");
                    }
                    if ("0".equals(allow_row_locks)) {
                        proxy.setAllowRowLocks("OFF");
                    }
                    this.initIncludeColumns(sqlConnection, db, tableId, indId, table, proxy);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
                continue;
            }
            LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
        }
    }

    protected void initIncludeColumns(Connection sqlConnection, String db, String tableId, String indId, Table table, IndexProxySqlServerv2k5 proxy) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("c.name column_name, ic.column_id ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.index_columns ic").append(' ');
            buffer.append(',').append("sys.columns c ");
            buffer.append("WHERE").append(' ');
            buffer.append("ic.object_id").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("is_included_column = 1 ");
            buffer.append("AND").append(' ');
            buffer.append("c.object_id = ic.object_id ");
            buffer.append("AND").append(' ');
            buffer.append("c.column_id = ic.column_id ");
            buffer.append("AND").append(' ');
            buffer.append("index_id =  ").append(indId);
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initSecondaryXMLIndex():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString(1);
                Column col = (Column)table.getElementByName(colName.trim());
                if (col == null) continue;
                proxy.setIncludeColumns(col.getObjectID());
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    protected void initSecondaryXMLIndex(Connection sqlConnection, String db, String tableId, String indId, IndexProxySqlServerv2k5 proxy) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("i.name, i.secondary_type_desc ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.xml_indexes i").append(' ');
            buffer.append(',').append("sys.data_spaces ds ");
            buffer.append("WHERE").append(' ');
            buffer.append("i.object_id").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("i.data_space_id = ds.data_space_id ");
            buffer.append("AND").append(' ');
            buffer.append("i.is_primary_key = 0 ");
            buffer.append("AND").append(' ');
            buffer.append("i.is_unique_constraint = 0 ");
            buffer.append("AND").append(' ');
            buffer.append("i.using_xml_index_id is not null  ");
            buffer.append("AND").append(' ');
            buffer.append("i.using_xml_index_id = ").append(indId);
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initSecondaryXMLIndex():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String type = rs.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                StorageDesignSqlServerv2k5 storage = null;
                if (storageDesign == null || !(storageDesign instanceof StorageDesignSqlServerv2k5)) continue;
                storage = (StorageDesignSqlServerv2k5)storageDesign;
                SecondaryXmlIndexSqlServerv2k5 secXMLInd = (SecondaryXmlIndexSqlServerv2k5)storage.getSecondaryXmlIndexSetv2k5().createXmlIndex();
                secXMLInd.setName(name);
                secXMLInd.setPrimaryXmlIndex(proxy);
                secXMLInd.setIndexType(type.trim().toUpperCase());
                this.stampModelObject((ModelObject)secXMLInd, proxy, name);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    protected PartitionSchemeSqlServerv2k5 getPartitionSchemaByName(String ds_name, DataBaseSqlServer database) {
        for (PartitionFunctionSqlServerv2k5 partFunc : ((DataBaseSqlServerv2k5)database).getPartitionFunction()) {
            PartitionSchemeSqlServerv2k5 partScheme = (PartitionSchemeSqlServerv2k5)partFunc.getPartitionScheme().getByName(ds_name);
            if (partScheme == null) continue;
            return partScheme;
        }
        return null;
    }

    private void initConstraints(Connection sqlConnection, Table table, String tableId, String db, Map columns, String dboSchema) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            String sql = "select name, parent_column_id,parent_object_id,type,definition,is_system_named from sys.check_constraints  where parent_object_id = " + tableId + " union" + " select name, parent_column_id,parent_object_id,type,definition,is_system_named from sys.default_constraints " + " where parent_object_id = " + tableId;
            rs = statement.executeQuery(sql);
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initConstraints():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                ModelObject constraint;
                String constrName = rs.getString(1);
                String col_id = rs.getString(2);
                String parent_id = rs.getString(3);
                String constrXtype = rs.getString(4).trim();
                String definition = rs.getString(5);
                Column col = (Column)columns.get(col_id);
                definition = Token.getValBetweenBrackets(definition);
                if (col != null) {
                    String unquotedName;
                    if ("C".equalsIgnoreCase(constrXtype)) {
                        if (col.getCheck() == null) {
                            constraint = new CheckConstraint();
                            constraint.setDesign(table.getDesign());
                            constraint.setName(constrName);
                            RDBMSType rdbmsType = StorageDesignSqlServerv2k5.RDBMS_TYPE;
                            if (this.getStorageDesign() != null) {
                                rdbmsType = this.getStorageDesign().getRDBMSType();
                            }
                            ((CheckConstraint)constraint).add(rdbmsType, definition);
                            this.stampModelObject(constraint, table.getName(), constrName);
                            if (col == null) continue;
                            col.setUseDomainConstraints(false);
                            col.setCheck((CheckConstraint)constraint);
                            col.setConstraintName(constrName);
                            continue;
                        }
                        constraint = table.createCheckConstraint(constrName, definition);
                        table.addCheckConstraint((TableLevelConstraint)constraint);
                        this.stampModelObject(constraint, dboSchema, constrName);
                        continue;
                    }
                    if (!"D".equalsIgnoreCase(constrXtype) || col == null) continue;
                    col.setUsesDefaultValue(true);
                    col.setDefaultValue(definition);
                    ColumnProxySqlServerv2k5 colProxy = (ColumnProxySqlServerv2k5)this.getStorageDesign().getColumnProxySet().getProxy(col.getObjectID());
                    if (!definition.toUpperCase().startsWith("NEXT")) continue;
                    String defValue = Token.getStringAfter(definition, "NEXT");
                    if (defValue.toUpperCase().startsWith("VALUE") && (defValue = Token.getStringAfter(defValue, "VALUE")).toUpperCase().startsWith("FOR")) {
                        defValue = Token.getStringAfter(defValue, "FOR");
                    }
                    if ((unquotedName = Token.getFirstName(defValue, '\"', '\"')).length() < defValue.length() - 4 || !(colProxy instanceof ColumnProxySqlServerv2k12)) continue;
                    col.setAutoIncrementColumn(true);
                    ((ColumnProxySqlServerv2k12)colProxy).setAutoIncrementDDL("DEFAULT_CLAUSE");
                    String seqName = unquotedName;
                    String userName = "";
                    int dotIndex = seqName.lastIndexOf(46);
                    if (dotIndex > -1) {
                        userName = seqName.substring(0, dotIndex);
                        seqName = seqName.substring(dotIndex + 1);
                    }
                    seqName = Token.getValBetweenDoubleQuotes(seqName);
                    seqName = Token.getValBetweenSquareBrackets(seqName);
                    col.setAutoIncrementSequenceName(seqName);
                    if (userName.equals("")) continue;
                    userName = Token.getValBetweenDoubleQuotes(userName);
                    userName = Token.getValBetweenSquareBrackets(userName);
                    SchemaSqlServerv2k5 autoIncSchema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)this.getStorageDesign()).getSchemaSet().getByName(userName);
                    ((ColumnProxySqlServerv2k12)colProxy).setAutoIncrementSchema(autoIncSchema);
                    continue;
                }
                constraint = table.createCheckConstraint(constrName, definition);
                table.addCheckConstraint((TableLevelConstraint)constraint);
                this.stampModelObject(constraint, dboSchema, constrName);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    protected void initUniqueKeys(Connection sqlConnection, Table table, String tableId, String db, String dboSchema) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("i").append('.');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("index_id ");
            buffer.append(',').append(' ');
            buffer.append("i").append('.');
            buffer.append("TYPE").append(' ');
            buffer.append(',').append(' ');
            buffer.append("i.type_desc,is_primary_key,is_unique_constraint,is_unique, ");
            buffer.append("ignore_dup_key,fill_factor,is_padded,allow_row_locks,allow_page_locks, ");
            buffer.append("i.data_space_id,ds.name ds_name,ds.type ds_type,s.no_recompute AS [NoAutomaticRecomputation] ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.indexes i").append(' ');
            buffer.append("INNER Join sys.data_spaces as ds ON i.data_space_id = ds.data_space_id ").append(' ');
            buffer.append("LEFT OUTER JOIN sys.stats AS s ON s.stats_id = i.index_id AND s.object_id = i.object_id ");
            buffer.append("WHERE").append(' ');
            buffer.append("i.object_id").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("(is_primary_key = 1 or is_unique_constraint = 1)");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initUniqueKeys():", e);
        }
        ArrayList<Properties> list = new ArrayList<Properties>();
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String indId = rs.getString(2);
                String clustered = rs.getString(4);
                String xtype = rs.getString(5);
                int fillFactor = rs.getInt(9);
                String is_padded = rs.getString(10);
                String allow_row_locks = rs.getString(11);
                String allow_page_locks = rs.getString(12);
                String ds_name = rs.getString(14);
                String ds_type = rs.getString(15);
                String StatRecompute = rs.getString(16);
                Properties props = new Properties();
                props.setProperty("name", name);
                props.setProperty("indId", indId);
                props.setProperty("clustered", clustered);
                props.setProperty("xtype", xtype);
                props.setProperty("fillFactor", String.valueOf(fillFactor));
                props.setProperty("is_padded", is_padded);
                props.setProperty("allow_row_locks", allow_row_locks);
                props.setProperty("allow_page_locks", allow_page_locks);
                props.setProperty("ds_name", ds_name);
                props.setProperty("ds_type", ds_type);
                props.setProperty("StatRecompute", StatRecompute != null ? StatRecompute : "");
                list.add(props);
            }
        }
        for (Properties props : list) {
            PartitionSchemeSqlServerv2k5 partSchema;
            FileGroupSqlServer group;
            DataBaseSqlServer database;
            IndexProxy proxy;
            String name = props.getProperty("name");
            String indId = props.getProperty("indId");
            String clustered = props.getProperty("clustered");
            String xtype = props.getProperty("xtype");
            int fillFactor = Integer.parseInt(props.getProperty("fillFactor"));
            String is_padded = props.getProperty("is_padded");
            String allow_row_locks = props.getProperty("allow_row_locks");
            String allow_page_locks = props.getProperty("allow_page_locks");
            String ds_name = props.getProperty("ds_name");
            String ds_type = props.getProperty("ds_type");
            String StatRecompute = props.getProperty("StatRecompute");
            Index key = table.createIndex();
            key.setName(name);
            this.stampModelObject((ModelObject)key, dboSchema, name);
            this.initKeyColumns(key, table, tableId, indId, db, sqlConnection);
            StorageDesign storageDesign = this.getStorageDesign();
            StorageDesignSqlServer storage = null;
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                storage = (StorageDesignSqlServer)storageDesign;
            }
            if ("1".equalsIgnoreCase(xtype)) {
                key.setIndexState("Primary Constraint");
                if (storage != null) {
                    proxy = (PKProxySqlServerv2k5)storage.getPKProxySet().getProxy(key.getObjectID());
                    if (proxy != null) {
                        if ("CLUSTERED".equalsIgnoreCase(clustered)) {
                            proxy.setClustered(true);
                        } else {
                            proxy.setClustered(false);
                        }
                        ((PKProxySqlServerv2k5)proxy).setFillFactor(fillFactor);
                        database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                        if (database == null) {
                            database = storage.getDataBaseSet().createDataBase();
                            database.setName(db);
                            this.stampModelObject((ModelObject)database, "", db);
                        }
                        if (ds_type.equalsIgnoreCase("FG")) {
                            group = (FileGroupSqlServer)database.getFilegroups().getByName(ds_name);
                            if (group == null) {
                                group = storage.getFileGroupSet().createFileGroup();
                                group.setName(ds_name);
                                group.setDataBase(database);
                                this.stampModelObject((ModelObject)group, proxy, ds_name);
                            }
                            ((PKProxySqlServer)proxy).setFilegroup(group);
                        }
                        if (ds_type.equalsIgnoreCase("PS") && (partSchema = this.getPartitionSchemaByName(ds_name, database)) != null) {
                            ((PKProxySqlServerv2k5)proxy).setPartitionScheme(partSchema);
                        }
                        if ("0".equals(allow_page_locks)) {
                            ((PKProxySqlServerv2k5)proxy).setAllowPageLocks("OFF");
                        }
                        if ("0".equals(allow_row_locks)) {
                            ((PKProxySqlServerv2k5)proxy).setAllowRowLocks("OFF");
                        }
                        if ("1".equals(is_padded)) {
                            ((PKProxySqlServerv2k5)proxy).setPadIndex("YES");
                        }
                        if (!"0".equals(StatRecompute)) continue;
                        ((PKProxySqlServerv2k5)proxy).setRecomputeStatistics("NO");
                        continue;
                    }
                    LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
                continue;
            }
            key.setIndexState("Unique Constraint");
            if (storage != null) {
                proxy = (UniqueProxySqlServerv2k5)storage.getUniqueProxySet().getProxy(key.getObjectID());
                if (proxy != null) {
                    if ("YES".equalsIgnoreCase(clustered)) {
                        proxy.setClustered(true);
                    } else {
                        proxy.setClustered(false);
                    }
                    ((UniqueProxySqlServerv2k5)proxy).setFillFactor(fillFactor);
                    database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = storage.getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                    if (ds_type.equalsIgnoreCase("FG")) {
                        group = (FileGroupSqlServer)database.getFilegroups().getByName(ds_name);
                        if (group == null) {
                            group = storage.getFileGroupSet().createFileGroup();
                            group.setName(ds_name);
                            group.setDataBase(database);
                            this.stampModelObject((ModelObject)group, proxy, ds_name);
                        }
                        ((UniqueProxySqlServer)proxy).setFilegroup(group);
                    }
                    if (ds_type.equalsIgnoreCase("PS") && (partSchema = this.getPartitionSchemaByName(ds_name, database)) != null) {
                        ((UniqueProxySqlServerv2k5)proxy).setPartitionScheme(partSchema);
                    }
                    if ("0".equals(allow_page_locks)) {
                        ((UniqueProxySqlServerv2k5)proxy).setAllowPageLocks("OFF");
                    }
                    if ("0".equals(allow_row_locks)) {
                        ((UniqueProxySqlServerv2k5)proxy).setAllowRowLocks("OFF");
                    }
                    if ("1".equals(is_padded)) {
                        ((UniqueProxySqlServerv2k5)proxy).setPadIndex("YES");
                    }
                    if (!"0".equals(StatRecompute)) continue;
                    ((UniqueProxySqlServerv2k5)proxy).setRecomputeStatistics("NO");
                    continue;
                }
                LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                continue;
            }
            LOGGER.error("Unable to find Storage Design!");
        }
        if (statement != null) {
            statement.close();
        }
    }

    protected void initKeyColumns(Index key, Table table, String tableId, String indId, String db, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("c.name column_name, ic.column_id ,ic.is_descending_key,ic.key_ordinal ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.index_columns ic").append(' ');
            buffer.append(',').append("sys.columns c ");
            buffer.append("WHERE").append(' ');
            buffer.append("ic.object_id").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("index_id").append(' ').append('=').append(' ').append(indId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("is_included_column = 0 ");
            buffer.append("AND").append(' ');
            buffer.append("c.object_id = ic.object_id  ");
            buffer.append("AND").append(' ');
            buffer.append("c.column_id = ic.column_id  ");
            buffer.append("ORDER BY").append(' ');
            buffer.append("ic.key_ordinal").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initKeyColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString(1);
                int sortOrder = rs.getInt(3);
                Column col = (Column)table.getElementByName(colName);
                if (col == null) continue;
                key.add(col);
                if (sortOrder == 0) {
                    key.setColumnSortOrder(col, "ASC");
                    continue;
                }
                key.setColumnSortOrder(col, "DESC");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initTriggers(Connection sqlConnection, TableProxySqlServer table, String tableId, String db, String dboSchema) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("trigger_name").append(' ');
            buffer.append('=').append(' ');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("o").append('.');
            buffer.append("ID").append(' ');
            buffer.append(',').append(' ');
            buffer.append("trigger_owner").append(' ');
            buffer.append('=').append(' ');
            buffer.append("user_name(uid)").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isupdate = ObjectProperty( o.id, 'ExecIsUpdateTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isdelete = ObjectProperty( o.id, 'ExecIsDeleteTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isinsert = ObjectProperty( o.id, 'ExecIsInsertTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isafter = ObjectProperty( o.id, 'ExecIsAfterTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isinsteadof = ObjectProperty( o.id, 'ExecIsInsteadOfTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isfirstupdate = ObjectProperty( o.id, 'ExecIsFirstUpdateTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isfirstdelete = ObjectProperty( o.id, 'ExecIsFirstDeleteTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isfirstinsert = ObjectProperty( o.id, 'ExecIsFirstInsertTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isLastupdate = ObjectProperty( o.id, 'ExecIsLastUpdateTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isLastdelete = ObjectProperty( o.id, 'ExecIsLastDeleteTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("isLastinsert = ObjectProperty( o.id, 'ExecIsLastInsertTrigger')").append(' ');
            buffer.append(',').append(' ');
            buffer.append("s.encrypted").append(' ');
            buffer.append(',').append(' ');
            buffer.append("s.text trigger_definition").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append('.').append("dbo.sysobjects o").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHTableSQLServerv2k5.getFormattedName(db)).append('.').append("dbo.syscomments s").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("parent_obj").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("type = 'TR'").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("o.id = s.id").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initTriggers():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String ownerName = rs.getString(3);
                int isUpdate = rs.getInt(4);
                int isDelete = rs.getInt(5);
                int isInsert = rs.getInt(6);
                int isAfter = rs.getInt(7);
                int isInsteadOf = rs.getInt(8);
                int isFirstUpdate = rs.getInt(9);
                int isFirstDelete = rs.getInt(10);
                int isFirstInsert = rs.getInt(11);
                int isLastUpdate = rs.getInt(12);
                int isLastDelete = rs.getInt(13);
                int isLastInsert = rs.getInt(14);
                int encripted = rs.getInt(15);
                String body = rs.getString(16);
                StorageDesignSqlServer storage = (StorageDesignSqlServer)table.getStorageDesign();
                TriggerSqlServer trigger = storage.getTriggerSet().createTrigger();
                trigger.setName(name);
                trigger.setTable(table);
                this.stampModelObject((ModelObject)trigger, dboSchema, name);
                SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)storage.getSchemaSet().getByName(db + "_" + ownerName);
                if (schema != null) {
                    trigger.setSchema(schema);
                }
                if (isUpdate == 1) {
                    trigger.setActions("UPDATE");
                }
                if (isDelete == 1) {
                    trigger.setActions("DELETE");
                }
                if (isInsert == 1) {
                    trigger.setActions("INSERT");
                }
                if (isAfter == 1) {
                    trigger.setTriggerTime("AFTER");
                } else if (isInsteadOf == 1) {
                    trigger.setTriggerTime("INSTEAD OF");
                }
                if (isFirstDelete == 1 || isFirstInsert == 1 || isFirstUpdate == 1) {
                    trigger.setExecutionOrder("FIRST");
                } else if (isLastDelete == 1 || isLastInsert == 1 || isLastUpdate == 1) {
                    trigger.setExecutionOrder("LAST");
                }
                if (encripted == 1) {
                    trigger.setEncription("YES");
                } else {
                    trigger.setEncription("NO");
                }
                trigger.setBody(body);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }
}

