/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPermissionsSqlServer
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "PERMISSIONS";
    private static final Logger LOGGER = new Logger(MOHPermissionsSqlServer.class);

    public MOHPermissionsSqlServer(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesignSqlServer storage = (StorageDesignSqlServer)this.getDesign().getRelationalDesign().getStorageDesign();
        for (DataBaseSqlServer db : storage.getDataBaseSet()) {
            if (db.getName().equalsIgnoreCase("[None]")) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("USE").append(' ');
                buffer.append(MOHPermissionsSqlServer.getFormattedName(db)).append(' ');
                buffer.append("SELECT").append(' ');
                buffer.append("p.id objectid").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o.name objectname").append(' ');
                buffer.append(',').append(' ');
                buffer.append("u.name ownername").append(' ');
                buffer.append(',').append(' ');
                buffer.append("o.xtype").append(' ');
                buffer.append(',').append(' ');
                buffer.append("PERMISSION = ");
                buffer.append("case p.action ");
                buffer.append("when 26 then 'REFERENCES' ");
                buffer.append("when 193 then 'SELECT' ");
                buffer.append("when 195 then 'INSERT' ");
                buffer.append("when 196 then 'DELETE' ");
                buffer.append("when 197 then 'UPDATE' ");
                buffer.append("when 224 then 'EXECUTE' ");
                buffer.append("end").append(' ');
                buffer.append(',').append(' ');
                buffer.append("WITH_GRAND_OPTION = ");
                buffer.append("case p.protecttype ");
                buffer.append("when 204 then 'YES' ");
                buffer.append("when 205 then 'NO' ");
                buffer.append("end ").append(' ');
                buffer.append(',').append(' ');
                buffer.append("p.columns").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHPermissionsSqlServer.getFormattedName(db)).append('.').append("dbo.sysprotects p").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHPermissionsSqlServer.getFormattedName(db)).append('.').append("dbo.sysobjects o").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHPermissionsSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers u").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("p.protecttype in (204,205)").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("p.action in (26,193,195,196,197,224)").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("p.uid = 16400").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("p.id = o.id").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("o.uid = u.uid").append(' ');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTableSqlServer.initForeignKeys():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    PermissionsSqlServer permissions;
                    String objectId = rs.getString(1);
                    String objectName = rs.getString(2).trim();
                    String ownerName = rs.getString(3).trim();
                    String xtype = rs.getString(4).trim();
                    String perm = rs.getString(5);
                    String withGrantOption = rs.getString(6);
                    String cols = rs.getString(7);
                    UserSqlServer user = (UserSqlServer)storage.getUserSet().getByName(ownerName);
                    RoleSqlServer role = null;
                    user = (UserSqlServer)db.getUsers().getByName(ownerName);
                    if (user == null) {
                        role = (RoleSqlServer)db.getRoles().getByName(ownerName);
                    }
                    TableProxySqlServer table = null;
                    TableViewProxySqlServer view = null;
                    if (xtype.equalsIgnoreCase("U")) {
                        StorageObjectPlaceHolder placeHolder = (StorageObjectPlaceHolder)db.getTables().getByName(objectName);
                        if (placeHolder != null) {
                            table = (TableProxySqlServer)placeHolder.getObject();
                        } else {
                            placeHolder = (StorageObjectPlaceHolder)db.getViews().getByName(ownerName);
                            if (placeHolder != null) {
                                view = (TableViewProxySqlServer)placeHolder.getObject();
                            }
                        }
                    }
                    int colPerm = 0;
                    try {
                        colPerm = new Integer(cols);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (user != null && table != null) {
                        permissions = this.getPermission(storage, user, table);
                        if (permissions == null) {
                            permissions = storage.getPermissionsSet().createPermissions();
                            permissions.setUser(user);
                            permissions.setTable(table);
                        }
                        if ("NO".equalsIgnoreCase(withGrantOption)) {
                            permissions.setPrivileges(perm);
                        } else {
                            permissions.setPrivilegesWithGrantOption(perm);
                        }
                        if (colPerm <= 0) continue;
                        this.setColumnPermissions(db.getName(), permissions, objectId, sqlConnection);
                        continue;
                    }
                    if (user != null && view != null) {
                        permissions = this.getPermission(storage, user, view);
                        if (permissions == null) {
                            permissions = storage.getPermissionsSet().createPermissions();
                            permissions.setUser(user);
                            permissions.setView(view);
                        }
                        if ("NO".equalsIgnoreCase(withGrantOption)) {
                            permissions.setPrivileges(perm);
                            continue;
                        }
                        permissions.setPrivilegesWithGrantOption(perm);
                        continue;
                    }
                    if (role != null && table != null) {
                        permissions = this.getPermission(storage, role, table);
                        if (permissions == null) {
                            permissions = storage.getPermissionsSet().createPermissions();
                            permissions.setRole(role);
                            permissions.setTable(table);
                        }
                        if ("NO".equalsIgnoreCase(withGrantOption)) {
                            permissions.setPrivileges(perm);
                            continue;
                        }
                        permissions.setPrivilegesWithGrantOption(perm);
                        continue;
                    }
                    if (role == null || view == null) continue;
                    permissions = this.getPermission(storage, role, view);
                    if (permissions == null) {
                        permissions = storage.getPermissionsSet().createPermissions();
                        permissions.setRole(role);
                        permissions.setView(view);
                    }
                    if ("NO".equalsIgnoreCase(withGrantOption)) {
                        permissions.setPrivileges(perm);
                        continue;
                    }
                    permissions.setPrivilegesWithGrantOption(perm);
                }
            }
            if (statement == null) continue;
            statement.close();
        }
    }

    private void setColumnPermissions(String db, PermissionsSqlServer permissions, String objectId, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHPermissionsSqlServer.getFormattedName(db)).append('.').append("dbo.syscolumns").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("ID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(objectId).append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("colid").append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    String column = rs.getString(1).trim();
                    column = column + ", ALL PRIVILEGES";
                    permissions.setColumnList(column);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHProcedureSqlServer.generate():", e);
        }
    }

    private PermissionsSqlServer getPermission(StorageDesignSqlServer storage, StorageObject user, StorageObject proxy) {
        for (PermissionsSqlServer perm : storage.getPermissionsSet()) {
            if (perm.getUser() != user && perm.getRole() != user || perm.getTable() != proxy && perm.getView() != proxy) continue;
            return perm;
        }
        return null;
    }
}

