/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHUndoTableSpaceOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "UNDO TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHUndoTableSpaceOraclev9i.class);
    protected boolean dbaUser;

    public MOHUndoTableSpaceOraclev9i(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            String filterCondition = this.getFilterConditionOracle("TABLESPACE_NAME");
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? DBA_TABLESPACES : USER_TABLESPACES).append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("NOT").append(' ').append("IN").append(' ');
            buffer.append('(').append('\'');
            buffer.append("SYSTEM").append('\'').append(')').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("CONTENTS").append('=').append('\'');
            buffer.append("UNDO").append('\'').append(' ');
            if (filterCondition != null) {
                buffer.append("AND").append(' ').append(filterCondition).append(' ');
            }
            buffer.append("ORDER BY").append(' ');
            buffer.append("TABLESPACE_NAME");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            System.out.println("MOHUndoTableSpaceOraclev9i.extract(): " + e.getMessage());
            LOGGER.error("MOHUndoTableSpaceOraclev9i.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String clusterName = rs.getString(1);
                DBObject dboSynonym = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), clusterName, OBJECT_TYPE);
                list.add(dboSynonym);
            }
            rs.close();
        }
        statement.close();
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign instanceof StorageDesignOraclev9i) {
                UndoTablespaceOracle tableSpace = ((StorageDesignOraclev9i)storageDesign).getUndoTablespaceSet().createTablespace();
                tableSpace.setName(dbo.getName());
                this.stampModelObject(tableSpace, dbo);
            } else {
                LOGGER.error("Unable to find Storage Design!");
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }
}

