/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHView;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableViewProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.dbtools.crest.util.string.StringUtilities;

public class MOHViewOracle
extends MOHView {
    protected static String SYSTEM_NAME_PREFIX = "SYS_";
    private final Map ukMap = new TreeMap();
    private final List fkTempList = new ArrayList();
    private static final Logger LOGGER = new Logger(MOHViewOracle.class);
    private List postProc;
    protected boolean dbaUser;
    protected MOHTableOracle tableHandlerOracle;

    public MOHViewOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHViewOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Views begin");
        this.ukMap.clear();
        this.fkTempList.clear();
        this.postProc = new ArrayList();
        ArrayList<DBObject> dbos = new ArrayList<DBObject>();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("a.").append("COLUMN_NAME").append(',');
        buffer.append("DATA_TYPE").append(',');
        buffer.append("DATA_LENGTH").append(',');
        buffer.append("DATA_PRECISION").append(',');
        buffer.append("DATA_SCALE").append(',');
        buffer.append("COMMENTS").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? DBA_TAB_COLUMNS : ALL_TAB_COLUMNS).append(' ').append("a").append(',');
        buffer.append(this.dbaUser ? DBA_COL_COMMENTS : ALL_COL_COMMENTS).append(' ').append("b").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("OWNER").append('=');
        buffer.append("b.").append("OWNER").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("TABLE_NAME").append('=');
        buffer.append("b.").append("TABLE_NAME").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("COLUMN_NAME").append('=');
        buffer.append("b.").append("COLUMN_NAME").append(' ');
        buffer.append("ORDER BY").append(' ').append("COLUMN_ID");
        String colsql = buffer.toString();
        PreparedStatement col_statement = sqlConnection.prepareStatement(colsql);
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("OWNER").append(',');
        buffer.append("TRIGGER_NAME").append(',');
        buffer.append("TRIGGER_TYPE").append(',');
        buffer.append("TRIGGERING_EVENT").append(',');
        buffer.append("REFERENCING_NAMES").append(',');
        buffer.append("WHEN_CLAUSE").append(',');
        buffer.append("TRIGGER_BODY").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_TRIGGERS : ALL_TRIGGERS).append(' ');
        buffer.append("WHERE").append(' ').append("TABLE_OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?');
        String trigsql = buffer.toString();
        PreparedStatement trig_statement = sqlConnection.prepareStatement(trigsql);
        boolean oracle11g = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("COMMENTS").append(',');
        if (oracle11g) {
            buffer.append("EDITIONING_VIEW").append(',');
        }
        buffer.append("TEXT").append(',');
        buffer.append("OID_TEXT").append(',');
        buffer.append("SUPERVIEW_NAME").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? DBA_VIEWS : ALL_VIEWS).append(' ').append("a").append(',');
        buffer.append(this.dbaUser ? DBA_TAB_COMMENTS : ALL_TAB_COMMENTS).append(' ').append("b").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("VIEW_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("VIEW_NAME").append('=').append("b.").append("TABLE_NAME").append(' ').append("(+)").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ').append("(+)");
        String sql = buffer.toString();
        PreparedStatement statement = sqlConnection.prepareStatement(sql);
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!"VIEW".equalsIgnoreCase(dbo.getType())) continue;
            String viewName = dbo.getName();
            String schemaName = dbo.getSchema();
            ResultSet rs = null;
            try {
                statement.setString(1, viewName);
                statement.setString(2, schemaName);
                rs = statement.executeQuery();
                if (rs != null) {
                    if (rs.next()) {
                        String editioning;
                        SchemaObjectSet schemaSet;
                        SchemaObject so;
                        TableView tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                        tableView.setCommentInRDBMS(rs.getString("COMMENTS"));
                        tableView.setSchema(schemaName);
                        String userName = schemaName;
                        UserOracle user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(userName);
                        TableViewProxyOracle vp = (TableViewProxyOracle)this.getStorageDesign().getTableViewProxySet().getProxy(tableView.getObjectID());
                        if (user == null) {
                            user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().createElement(null);
                            user.setName(userName);
                            this.stampModelObject((ModelObject)user, "", userName);
                        }
                        if ((so = (SchemaObject)(schemaSet = ((RelationalDesign)tableView.getDesignPart()).getSchemaObjectSet()).getByName(userName)) == null) {
                            so = schemaSet.createSchemaObject(null);
                            so.setName(userName);
                            this.stampModelObject((ModelObject)so, "", userName);
                        }
                        if (user != null) {
                            if (user.getSchemaObject() == null) {
                                user.setSchemaObject(so);
                            }
                            if (user.getSchemaObject() != so) {
                                vp.setUser(user);
                            }
                        }
                        tableView.setSchemaObject(so);
                        tableView.setName(viewName);
                        dbo.setTable(tableView);
                        dbos.add(dbo);
                        if (!viewName.equals(viewName.toUpperCase())) {
                            tableView.setNameHasQuotes(true);
                        }
                        if (oracle11g && (editioning = rs.getString("EDITIONING_VIEW")).equals("Y")) {
                            ((TableViewProxyOraclev10g)vp).setEditioning("YES");
                        }
                        if (dbo.getTypeName() != null) {
                            StructuredTypeProxyOracle stp = ((StructuredTypeProxySetOracle)this.getStorageDesign().getStructuredTypeProxySet()).getByLongName(dbo.getTypeName(), dbo.getTypeOwner());
                            if (stp != null && stp.getStructuredType() != null) {
                                tableView.setUserDefined(true);
                                tableView.setBasedOnStructuredType(stp.getStructuredType());
                                String view_def = rs.getString("TEXT");
                                String definition = "CREATE OR REPLACE VIEW " + viewName;
                                String superViewName = rs.getString("SUPERVIEW_NAME");
                                String oidText = rs.getString("OID_TEXT");
                                if (superViewName != null) {
                                    Temp temp = new Temp();
                                    temp.superViewName = superViewName;
                                    temp.tview = tableView;
                                    this.postProc.add(temp);
                                }
                                if (oidText != null) {
                                    tableView.setOidText(oidText);
                                    if (vp != null) {
                                        vp.setOidAttributes(oidText);
                                    }
                                }
                                if (view_def.startsWith("(")) {
                                    view_def = Token.getValBetweenBrackets(view_def);
                                }
                                tableView.setUserDefinedSQL(definition + "\nAS \n" + view_def);
                            }
                        } else {
                            tableView.setUserDefined(true);
                            String vdef = rs.getString("TEXT").trim();
                            int ind = StringUtilities.indexOf(vdef, "WITH READ ONLY");
                            String vend = "";
                            if (ind > -1) {
                                vend = vdef.substring(ind);
                                vdef = vdef.substring(0, ind);
                                vp.setViewReadOnly("YES");
                            } else {
                                ind = StringUtilities.indexOf(vdef, "WITH CHECK OPTION");
                                if (ind > -1) {
                                    vend = vdef.substring(ind);
                                    vdef = vdef.substring(0, ind);
                                    vp.setCheckOption(true);
                                }
                            }
                            if (!"".equals(vend)) {
                                // empty if block
                            }
                            if (vdef.startsWith("(")) {
                                vdef = Token.getValBetweenBrackets(vdef);
                            }
                            String definition = "CREATE OR REPLACE VIEW " + viewName + "\nAS \n" + vdef;
                            tableView.setUserDefinedSQL(definition);
                            ResultSet rs_col = null;
                            try {
                                col_statement.setString(1, viewName);
                                col_statement.setString(2, schemaName);
                                rs_col = col_statement.executeQuery();
                                if (rs_col != null) {
                                    while (rs_col.next()) {
                                        String col_name = rs_col.getString(1);
                                        String col_type = rs_col.getString(2);
                                        String dt_length = rs_col.getString(3);
                                        String dt_precision = rs_col.getString(4);
                                        String dt_scale = rs_col.getString(5);
                                        String col_comments = rs_col.getString(6);
                                        AbstractViewElement cvExp = tableView.createViewElement(tableView.getDesignPart());
                                        cvExp.setName(col_name);
                                        cvExp.setHeaderAlias(col_name);
                                        cvExp.setDataType(this.createDataTypeString(col_type, dt_length, dt_precision, dt_scale));
                                        cvExp.setDesign(tableView.getDesign());
                                        cvExp.setAlias(col_name);
                                        cvExp.setContainer(tableView);
                                        if (col_comments != null) {
                                            cvExp.setCommentInRDBMS(col_comments);
                                        }
                                        tableView.add(cvExp);
                                        if (!col_name.equals(col_name.toUpperCase())) {
                                            cvExp.setNameHasQuotes(true);
                                        }
                                        this.stampModelObject((ModelObject)cvExp, tableView.getName(), col_name);
                                    }
                                }
                            }
                            catch (Exception e) {
                                System.out.println(e.getMessage());
                                LOGGER.error("MOHViewOracle.generate() column names:", e);
                            }
                            if (rs_col != null) {
                                rs_col.close();
                            }
                        }
                        if (this.getDbmeHandler().isTriggers()) {
                            this.initViewTriggers(trig_statement, tableView, schemaName);
                        }
                        this.stampModelObject(tableView, dbo);
                    }
                    rs.close();
                }
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                LOGGER.error("MOHViewOracle.generate():", e);
            }
        }
        trig_statement.close();
        col_statement.close();
        statement.close();
        this.initUK_PK_FK_CHECK_Constraints(sqlConnection, dbos, this.ukMap, this.fkTempList);
        TimeLog.log("End Views");
    }

    private boolean isNotEmpty(String param) {
        return param != null && !"".equalsIgnoreCase(param) && !"0".equalsIgnoreCase(param);
    }

    private String createDataTypeString(String datatype, String length, String precision, String scale) {
        if (!(datatype.startsWith("TIMESTAMP") || datatype.startsWith("INTERVAL") || length == null && precision == null && scale == null)) {
            StringBuffer buffer = new StringBuffer();
            boolean needComma = false;
            if (!"NUMBER".equalsIgnoreCase(datatype) && this.isNotEmpty(length)) {
                buffer.append(length);
                needComma = true;
            }
            if (this.isNotEmpty(precision)) {
                if (needComma) {
                    buffer.append(',').append(' ');
                }
                buffer.append(precision);
                needComma = true;
            }
            if (this.isNotEmpty(scale)) {
                if (needComma) {
                    buffer.append(',').append(' ');
                }
                buffer.append(scale);
            }
            if (buffer.length() > 0) {
                buffer.append(')');
                return datatype + " (" + buffer.toString();
            }
        }
        return datatype;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract View begin");
        Statement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            String schemaName = dboNext.getName();
            if (statement == null) {
                String filterCondition = this.getFilterConditionOracle("VIEW_NAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("VIEW_NAME").append(',');
                buffer.append("VIEW_TYPE").append(',');
                buffer.append("VIEW_TYPE_OWNER").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_VIEWS : ALL_VIEWS).append(' ');
                buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                if (filterCondition != null) {
                    buffer.append("AND").append(' ').append(filterCondition).append(' ');
                }
                buffer.append("ORDER BY").append(' ').append("VIEW_NAME");
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHViewOracle.extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String viewName = rs.getString("VIEW_NAME");
                String viewType = rs.getString("VIEW_TYPE");
                String viewTypeOwner = rs.getString("VIEW_TYPE_OWNER");
                DBObject dboView = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), viewName, "VIEW", schemaName);
                dboView.setTypeName(viewType);
                dboView.setTypeOwner(viewTypeOwner);
                list.add(dboView);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        TimeLog.log("Extract View end");
        return list;
    }

    private void initViewTriggers(PreparedStatement trig_statement, TableView table, String ownerName) throws Exception {
        ResultSet rs = null;
        try {
            trig_statement.setString(1, ownerName);
            trig_statement.setString(2, table.getName());
            rs = trig_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHViewOracle.initViewTriggers():", e);
        }
        if (rs != null) {
            StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
            TableViewProxyOracle tableProxy = (TableViewProxyOracle)storage.getTableViewProxySet().getProxy(table.getObjectID());
            while (rs.next()) {
                String trigOwner = rs.getString("OWNER");
                String trigName = rs.getString("TRIGGER_NAME");
                String type = rs.getString("TRIGGER_TYPE");
                String event = rs.getString("TRIGGERING_EVENT");
                String refNames = rs.getString("REFERENCING_NAMES");
                String whenClause = rs.getString("WHEN_CLAUSE");
                String trBody = rs.getString("TRIGGER_BODY");
                TriggerOracle trigger = storage.getTriggerSet().createTrigger();
                UserOracle user = (UserOracle)storage.getUserSet().getByName(trigOwner);
                trigger.setOwner(user);
                trigger.setName(trigName);
                if (!trigName.equals(trigName.toUpperCase())) {
                    trigger.setNameHasQuotes(true);
                }
                trigger.setView(tableProxy);
                this.stampModelObject((ModelObject)trigger, tableProxy, trigName);
                if (type.indexOf("STATEMENT") > -1) {
                    trigger.setScope(TriggerOracle.SCOPE_TYPES[1]);
                } else {
                    trigger.setScope(TriggerOracle.SCOPE_TYPES[0]);
                }
                if (type.indexOf("BEFORE") > -1) {
                    trigger.setTriggerTime("BEFORE");
                } else if (type.indexOf("AFTER") > -1) {
                    trigger.setTriggerTime("AFTER");
                } else {
                    trigger.setTriggerTime(type);
                }
                if (event.indexOf("INSERT") > -1) {
                    trigger.setActions(Trigger.ACTION_TYPES[0]);
                }
                if (event.indexOf("UPDATE") > -1) {
                    trigger.setActions(Trigger.ACTION_TYPES[1]);
                }
                if (event.indexOf("DELETE") > -1) {
                    trigger.setActions(Trigger.ACTION_TYPES[2]);
                }
                String newref = "NEW";
                String oldref = "OLD";
                String parentref = "PARENT";
                if (refNames.indexOf("NEW AS") > -1 && !"NEW".equalsIgnoreCase(newref = Token.getFirstToken(Token.getStringAfter(refNames, "NEW AS")))) {
                    trigger.setRef_NEW_AS(newref);
                }
                if (refNames.indexOf("OLD AS") > -1 && !"OLD".equalsIgnoreCase(oldref = Token.getFirstToken(Token.getStringAfter(refNames, "OLD AS")))) {
                    trigger.setRef_OLD_AS(oldref);
                }
                if (refNames.indexOf("PARENT AS") > -1 && !"PARENT".equalsIgnoreCase(parentref = Token.getFirstToken(Token.getStringAfter(refNames, "PARENT AS")))) {
                    trigger.setRef_PARENT_AS(parentref);
                }
                if (whenClause != null) {
                    trigger.setCondition(whenClause);
                }
                trigger.setBody(trBody);
            }
            rs.close();
        }
    }

    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        this.createFKeys(sqlConnection, this.fkTempList, this.ukMap);
        this.fkTempList.clear();
        this.ukMap.clear();
        if (this.postProc != null) {
            TableViewSet vs = this.getDesign().getRelationalDesign().getTableViewSet();
            for (Temp temp : this.postProc) {
                TableView tview = (TableView)vs.getByName(temp.superViewName);
                if (tview == null || tview == temp.tview) continue;
                TypeSubstitution ts = this.getDesign().getRelationalDesign().createTypeSubstitution();
                ContainerView childTV = (ContainerView)temp.tview.getFirstViewForDPV(this.getDesign().getRelationalDesign().getMainView());
                ContainerView parentTV = (ContainerView)tview.getFirstViewForDPV(this.getDesign().getRelationalDesign().getMainView());
                ts.setChildCV(childTV);
                ts.setParentCV(parentTV);
                ts.addToAllDPVs();
            }
            this.postProc.clear();
        }
    }

    private void initUK_PK_FK_CHECK_Constraints(Connection sqlConnection, List dbos, Map ukMap, List fkTempList) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("CONSTRAINT_NAME").append(',');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("POSITION").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_CONS_COLUMNS : ALL_CONS_COLUMNS).append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME").append(',').append("POSITION").append(',').append("COLUMN_NAME");
        String ncol_sql = buffer.toString();
        Statement ncol_st = null;
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("CONSTRAINT_NAME").append(',');
        buffer.append("CONSTRAINT_TYPE").append(',');
        buffer.append("R_OWNER").append(',');
        buffer.append("R_CONSTRAINT_NAME").append(',');
        buffer.append("INDEX_NAME").append(',');
        buffer.append("GENERATED").append(',');
        buffer.append("RELY").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_CONSTRAINTS : ALL_CONSTRAINTS).append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("CONSTRAINT_TYPE").append(' ').append("IN").append(' ');
        buffer.append('(').append("'P','U','C','R'").append(')').append(' ');
        buffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME");
        String sql = buffer.toString();
        Statement statement = null;
        Iterator it = dbos.iterator();
        boolean first = true;
        TreeMap<String, ArrayList<String>> map = new TreeMap<String, ArrayList<String>>();
        while (it.hasNext()) {
            DBObject dbo = (DBObject)it.next();
            TableView view = (TableView)dbo.getTable();
            int uk_count = 0;
            String ownerName = dbo.getSchema();
            ResultSet rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
                first = true;
                if (rs == null) continue;
                while (rs.next()) {
                    String constrName = rs.getString(1);
                    String constrType = rs.getString(2);
                    if (first) {
                        ResultSet nrs = null;
                        first = false;
                        map.clear();
                        if (ncol_st == null) {
                            ncol_st = sqlConnection.prepareStatement(ncol_sql);
                        }
                        try {
                            ncol_st.setString(1, dbo.getSchema());
                            ncol_st.setString(2, dbo.getName());
                            nrs = ncol_st.executeQuery();
                        }
                        catch (Exception e) {
                            LOGGER.error("MOHViewOracle.initUK_PK_FK_CHECK_Constraints():", e);
                        }
                        if (nrs != null) {
                            while (nrs.next()) {
                                String cName = nrs.getString(1);
                                String colName = Token.removeQuotes(nrs.getString(2));
                                ArrayList<String> list = (ArrayList<String>)map.get(cName);
                                if (list == null) {
                                    list = new ArrayList<String>();
                                    map.put(cName, list);
                                }
                                list.add(colName);
                            }
                            nrs.close();
                        }
                    }
                    if ("R".equalsIgnoreCase(constrType)) {
                        FKTemp fktemp = new FKTemp();
                        fkTempList.add(fktemp);
                        fktemp.name = constrName;
                        fktemp.UK_Owner = rs.getString(3);
                        fktemp.UK_Name = rs.getString(4);
                        fktemp.view = (TableView)dbo.getTable();
                        fktemp.rely = rs.getString(7);
                        this.initFK_Columns(map, constrName, fktemp.columns);
                        continue;
                    }
                    if ("C".equalsIgnoreCase(constrType)) continue;
                    String ind_name = rs.getString(5);
                    String generated = rs.getString(6);
                    ViewIndex index = null;
                    if (ind_name != null) {
                        if (!generated.equalsIgnoreCase("USER NAME")) {
                            if (constrName.equals(ind_name)) {
                                index = view.getIndexByName(ind_name);
                            }
                        } else if (!constrName.equals(ind_name)) {
                            index = view.getIndexByName(constrName);
                        }
                    }
                    if ("P".equalsIgnoreCase(constrType) && view.isBST()) {
                        if (index != null) {
                            ViewIndex existingPK = (ViewIndex)view.getPK();
                            if (existingPK != null) {
                                existingPK.getElementsCollection().clear();
                                if (index != existingPK) {
                                    index.remove();
                                    index = existingPK;
                                }
                            }
                            if (generated.equalsIgnoreCase("USER NAME")) {
                                index.setName(constrName);
                            } else {
                                index.setName(ind_name);
                            }
                        } else {
                            ViewIndex pk = (ViewIndex)view.getPK();
                            if (pk == null) {
                                pk = view.createIndex();
                            }
                            String pkName = generated.equalsIgnoreCase("USER NAME") ? constrName : ind_name;
                            pk.setName(pkName);
                            if (!pkName.equals(pkName.toUpperCase())) {
                                pk.setNameHasQuotes(true);
                            }
                            this.stampModelObject((ModelObject)pk, view.getSchema(), pk.getName());
                            this.initPK_UK_Columns(pk, map, constrName);
                            if ("".equals(pk.getIndexExpression())) {
                                ColumnView col = (ColumnView)view.getOidElement();
                                if (col != null) {
                                    pk.remove(col);
                                }
                                ArrayList<String> colNames = new ArrayList<String>();
                                for (Column column : pk.getElementsCollection()) {
                                    colNames.add(column.getName());
                                }
                                ViewIndex idx = this.getIndexForColumnNames(view, colNames, pk);
                                if (idx != null) {
                                    idx.remove();
                                }
                            }
                        }
                    } else if (index == null) {
                        index = view.createIndex();
                    }
                    if (index == null) continue;
                    ukMap.put(ownerName + constrName, index);
                    if ("U".equalsIgnoreCase(constrType)) {
                        index.setIndexState("Unique Constraint");
                        ++uk_count;
                    } else if ("P".equalsIgnoreCase(constrType) && !view.isBST()) {
                        index.setIndexState("Primary Constraint");
                    }
                    boolean valid = true;
                    if (index.getElementsCollection().size() == 0) {
                        valid = this.initPK_UK_Columns(index, map, constrName);
                    }
                    if (!valid || view.isBST() && !"".equals(index.getIndexExpression())) {
                        ukMap.put(ownerName + constrName, index.getView());
                        index.remove();
                    }
                    if (index.isRemoved()) continue;
                    if (generated.equalsIgnoreCase("USER NAME")) {
                        index.setName(constrName);
                        if (!constrName.equals(constrName.toUpperCase())) {
                            index.setNameHasQuotes(true);
                        }
                        this.stampModelObject((ModelObject)index, view.getSchema(), index.getName());
                        continue;
                    }
                    if (DBMExtractionController.swapTargetModel) {
                        index.setName(constrName);
                        this.stampModelObject((ModelObject)index, view.getSchema(), constrName);
                        continue;
                    }
                    NamingStandardRule nsr = view.getDesign().getDesignLevelSettings().getNamingStandardRule();
                    String tname = view.getName();
                    String abbrname = view.getAbbreviation();
                    if (abbrname == null || "".equals(abbrname)) {
                        abbrname = tname;
                    }
                    if (constrName.toUpperCase().startsWith(SYSTEM_NAME_PREFIX) && !view.getAppView().getSettings().isReplaceSystemNamesDuringImport()) {
                        index.setName(constrName);
                    } else {
                        String constName = "P".equalsIgnoreCase(constrType) ? ApplyNamingStandards.applyToPK(index, nsr, tname, abbrname) : ApplyNamingStandards.createUK_Name(index, uk_count, nsr, view.getDesignPart().getName(), tname, abbrname);
                        index.setName(constName);
                    }
                    this.stampModelObject((ModelObject)index, view.getSchema(), constrName);
                }
                rs.close();
            }
            catch (Exception e) {
                LOGGER.error("MOHViewOracle.initUK_PK_FK_CHECK_Constraints():", e);
            }
        }
        if (ncol_st != null) {
            ncol_st.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initFK_Columns(Map map, String constrName, List columns) throws Exception {
        List list = (List)map.get(constrName);
        if (list != null) {
            columns.addAll(list);
        }
    }

    private boolean initPK_UK_Columns(ViewIndex index, Map map, String constrName) throws Exception {
        boolean valid = true;
        List list = (List)map.get(constrName);
        if (list != null) {
            String ind_expr = "";
            boolean expr = false;
            boolean first = true;
            TableView view = (TableView)index.getContainerWithKeyObject();
            for (int i = 0; i < list.size(); ++i) {
                String colName = (String)list.get(i);
                if (first) {
                    ind_expr = colName;
                    first = false;
                } else {
                    ind_expr = ind_expr + "," + colName;
                }
                ColumnView column = (ColumnView)view.getElementByName(colName);
                if (column != null) {
                    if (column.getCollectionType() != null || column.getStructuredType() != null) {
                        valid = false;
                    }
                    index.add(column);
                    continue;
                }
                if (colName.startsWith("SYS_NC")) {
                    valid = false;
                }
                expr = true;
            }
            if (expr) {
                index.getElementsCollection().clear();
                index.setIndexExpression(ind_expr);
            }
        }
        return valid;
    }

    private ViewIndex getIndexForColumnNames(TableView view, List names, ViewIndex notThis) {
        ViewIndex[] inds = (ViewIndex[])view.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (inds[i] == notThis || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(ViewIndex index, List names) {
        ColumnView[] columns = (ColumnView[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private void createFKeys(Connection sqlConnection, List fkTempList, Map ukMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("POSITION").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_CONS_COLUMNS : ALL_CONS_COLUMNS).append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("CONSTRAINT_NAME").append('=').append('?').append(' ');
        buffer.append("ORDER BY").append(' ').append("POSITION").append(',').append("COLUMN_NAME");
        String fk_sql = buffer.toString();
        Statement fk_statement = null;
        Map tukMap = null;
        for (FKTemp fkt : fkTempList) {
            try {
                KeyObject index;
                DesignObject ukMapObject = (DesignObject)ukMap.get(fkt.UK_Owner + fkt.UK_Name);
                if (ukMapObject == null) {
                    if (tukMap == null) {
                        tukMap = this.getTableHandlerOracle().getUkMap();
                    }
                    if (tukMap != null) {
                        ukMapObject = (DesignObject)tukMap.get(fkt.UK_Owner + fkt.UK_Name);
                    }
                }
                if ((index = ukMapObject instanceof TableView ? ((TableView)ukMapObject).getPK() : (ukMapObject instanceof Table ? ((Table)ukMapObject).getPK() : (KeyObject)ukMapObject)) == null) {
                    index = fkt.view.getIndexByName(fkt.UK_Name);
                    if (index == null) {
                        index = (Index)((RelationalDesign)fkt.view.getDesignPart()).getGlobalIndexSet().getBySchemaAndName(fkt.UK_Owner, fkt.UK_Name);
                        RelationalDesign rd = ((RelationalDesign)fkt.view.getDesignPart()).getRelatedSyncModel();
                        if (index == null && rd != null) {
                            index = (Index)rd.getGlobalIndexSet().getBySchemaAndName(fkt.UK_Owner, fkt.UK_Name);
                        }
                    }
                    if (index == null) {
                        ResultSet fk_rs = null;
                        if (fk_statement == null) {
                            fk_statement = sqlConnection.prepareStatement(fk_sql);
                        }
                        fk_statement.setString(1, fkt.UK_Owner);
                        fk_statement.setString(2, fkt.UK_Name);
                        fk_rs = fk_statement.executeQuery();
                        String refTable = null;
                        ArrayList<String> refColumns = new ArrayList<String>();
                        if (fk_rs != null) {
                            while (fk_rs.next()) {
                                refTable = fk_rs.getString(1);
                                refColumns.add(fk_rs.getString(2));
                            }
                        }
                        index = ((RelationalDesign)fkt.view.getDesignPart()).getViewIndexByMatchingColumns(fkt.UK_Owner, refTable, refColumns);
                    }
                }
                if (index == null) continue;
                FKIndexAssociation fk = fkt.view.addFK(index);
                fk.setName(fkt.name);
                this.stampModelObject((ModelObject)fk, fkt.view.getSchema(), fkt.name);
                KeyObject localFKIndex = fk.getLocalFKIndex();
                localFKIndex.setName(fkt.name);
                if (!fkt.name.equals(fkt.name.toUpperCase())) {
                    localFKIndex.setNameHasQuotes(true);
                }
                for (int i = 0; i < fkt.columns.size(); ++i) {
                    String colName = (String)fkt.columns.get(i);
                    ColumnView column = (ColumnView)fkt.view.getElementByName(colName);
                    FKElement refCol = null;
                    try {
                        refCol = (FKElement)index.getElement(i);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (column == null || refCol == null) continue;
                    column.addFKAssociation(refCol, fk);
                    localFKIndex.add(column);
                }
                if (fkt.rely != null && fkt.rely.equals("RELY")) {
                    fk.setRely(true);
                } else {
                    fk.setRely(false);
                }
                fk.resetMandatoryUsingColumns();
            }
            catch (Exception e) {
                LOGGER.error("MOHViewOracle.createFKeys(): " + fkt.name, e);
            }
        }
        if (fk_statement != null) {
            try {
                fk_statement.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    public MOHTableOracle getTableHandlerOracle() {
        return this.tableHandlerOracle;
    }

    public void setTableHandlerOracle(MOHTableOracle tableHandlerOracle) {
        this.tableHandlerOracle = tableHandlerOracle;
    }

    public Map getUkMap() {
        return this.ukMap;
    }

    class FKTemp {
        String name;
        String UK_Owner;
        String UK_Name;
        List columns = new ArrayList();
        TableView view;
        String rely;

        FKTemp() {
        }
    }

    class Temp {
        TableView tview;
        String superViewName;

        Temp() {
        }
    }
}

