/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHUserOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "USER";
    private static final Logger LOGGER = new Logger(MOHUserOracle.class);
    protected boolean dbaUser;
    PreparedStatement objectPrivilegesStmt = null;
    PreparedStatement columnPrivilegesStmt = null;
    PreparedStatement systemPrivilegesStmt = null;
    PreparedStatement rolesStmt = null;
    PreparedStatement quotasStmt = null;
    Set<String> allUserNames = new TreeSet<String>();

    public MOHUserOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHUserOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        boolean dba_users_ok = true;
        Statement statement = null;
        this.systemPrivilegesStmt = null;
        this.rolesStmt = null;
        this.quotasStmt = null;
        TreeMap<String, UserOracle> map = new TreeMap<String, UserOracle>();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            UserOracle user;
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String userName = dbo.getSchema();
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            if (userName != null && !"".equals(userName)) {
                user = (UserOracle)map.get(userName);
                if (user == null) {
                    if (storageDesign != null && (user = (UserOracle)storageDesign.getUserSet().getByName(userName)) == null) {
                        user = storageDesign.getUserSet().createUser();
                        user.setName(userName);
                        this.stampModelObject((ModelObject)user, "", userName);
                    }
                    if (user != null) {
                        map.put(userName, user);
                    }
                }
                if (user != null && !userName.equals(userName.toUpperCase())) {
                    user.setNameHasQuotes(true);
                }
            }
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            userName = dbo.getName();
            if (storageDesign != null) {
                user = (UserOracle)storageDesign.getUserSet().getByName(userName);
                if (user == null) {
                    user = storageDesign.getUserSet().createUser();
                    user.setName(userName);
                }
                this.stampModelObject((ModelObject)user, "", userName);
                if (dba_users_ok) {
                    ResultSet rs = null;
                    try {
                        if (statement == null) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ');
                            buffer.append(this.dbaUser ? PASSWORD : NULL).append(' ').append("AS").append(' ').append("PASSWORD").append(',');
                            buffer.append("DEFAULT_TABLESPACE").append(',');
                            buffer.append("TEMPORARY_TABLESPACE").append(',');
                            buffer.append(this.dbaUser ? PROFILE : NULL).append(' ').append("AS").append(' ').append("PROFILE").append(',');
                            buffer.append("EXTERNAL_NAME").append(' ');
                            buffer.append("FROM").append(' ');
                            buffer.append(this.dbaUser ? DBA_USERS : USER_USERS).append(' ');
                            buffer.append("WHERE").append(' ');
                            buffer.append("USERNAME").append('=').append('?');
                            statement = sqlConnection.prepareStatement(buffer.toString());
                        }
                        statement.setString(1, userName);
                        rs = statement.executeQuery();
                    }
                    catch (SQLException se) {
                        if (se.getMessage().startsWith("ORA-00942")) {
                            dba_users_ok = false;
                            System.out.println("MOHUserOracle.generate(): " + se.getMessage());
                            LOGGER.error("MOHUserOracle.generate(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_users" : "user_users"));
                        } else {
                            System.out.println("MOHUserOracle.generate(): " + se.getMessage());
                            LOGGER.error("MOHUserOracle.generate():", se);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("MOHUserOracle.generate(): " + e.getMessage());
                        LOGGER.error("MOHUserOracle.generate():", e);
                    }
                    if (rs != null) {
                        if (rs.next()) {
                            this.setProperties(user, storageDesign, rs);
                            this.setSystemPrivileges(user, sqlConnection);
                            this.setRoles(user, sqlConnection);
                            this.setQuotas(user, sqlConnection);
                        }
                        rs.close();
                    }
                }
            } else {
                LOGGER.error("Unable to find Storage Design");
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (this.rolesStmt != null) {
            this.rolesStmt.close();
            this.rolesStmt = null;
        }
        if (this.quotasStmt != null) {
            this.quotasStmt.close();
            this.quotasStmt = null;
        }
        if (this.systemPrivilegesStmt != null) {
            this.systemPrivilegesStmt.close();
            this.systemPrivilegesStmt = null;
        }
        if (statement != null) {
            statement.close();
        }
        map.clear();
    }

    private void setProperties(UserOracle user, StorageDesignOracle storageDesign, ResultSet resultSet) throws Exception {
        TemporaryTablespaceOracle tempTableSpace;
        TableSpaceOracle defTableSpace;
        String password = resultSet.getString("PASSWORD");
        String defaultTS = resultSet.getString("DEFAULT_TABLESPACE");
        String tempTS = resultSet.getString("TEMPORARY_TABLESPACE");
        String profile = resultSet.getString("PROFILE");
        String externalName = resultSet.getString("EXTERNAL_NAME");
        if (password != null) {
            if ("EXTERNAL".equalsIgnoreCase(password.trim())) {
                user.setAuthType("EXTERNALLY");
            } else if ("GLOBAL".equalsIgnoreCase(password.trim())) {
                user.setAuthType("GLOBALLY");
            }
        }
        if (defaultTS != null && !"".equalsIgnoreCase(defaultTS) && (defTableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(defaultTS)) != null) {
            user.setDefTableSpace(defTableSpace);
        }
        if (tempTS != null && !"".equalsIgnoreCase(tempTS) && (tempTableSpace = (TemporaryTablespaceOracle)storageDesign.getTemporaryTablespaceSet().getByName(tempTS)) != null) {
            user.setTempTableSpace(tempTableSpace);
        }
        if (profile != null) {
            user.setProfile(profile);
        }
        if (externalName != null) {
            user.setExternalName(externalName);
        }
    }

    private void setRoles(UserOracle user, Connection sqlConnection) throws Exception {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        if (storageDesign != null) {
            ResultSet rs = null;
            try {
                if (this.rolesStmt == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT");
                    buffer.append(' ').append("GRANTED_ROLE");
                    buffer.append(',').append("ADMIN_OPTION");
                    buffer.append(',').append("DEFAULT_ROLE");
                    buffer.append(' ').append("FROM").append(' ');
                    buffer.append(this.dbaUser ? DBA_ROLE_PRIVS : USER_ROLE_PRIVS).append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append(this.dbaUser ? GRANTEE : USERNAME).append('=').append('?');
                    this.rolesStmt = sqlConnection.prepareStatement(buffer.toString());
                }
                this.rolesStmt.setString(1, user.getName());
                rs = this.rolesStmt.executeQuery();
            }
            catch (SQLException se) {
                if (se.getMessage().startsWith("ORA-00942")) {
                    System.out.println("MOHUserOracle.setRoles(): " + se.getMessage());
                    LOGGER.error("MOHUserOracle.setRoles(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_role_privs" : "user_role_privs"));
                } else {
                    System.out.println("MOHUserOracle.setRoles(): " + se.getMessage());
                    LOGGER.error("MOHUserOracle.setRoles():", se);
                }
            }
            catch (Exception e) {
                LOGGER.error("MOHUserOracle.setRoles():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    RoleOracle role;
                    String grantedRoleName = rs.getString("GRANTED_ROLE");
                    String adminOption = rs.getString("ADMIN_OPTION");
                    if (grantedRoleName == null || "".equalsIgnoreCase(grantedRoleName) || (role = (RoleOracle)storageDesign.getRoleSet().getByName(grantedRoleName)) == null) continue;
                    if ("YES".equalsIgnoreCase(adminOption)) {
                        user.setRolesWithAdminOption(role.getObjectID());
                        continue;
                    }
                    user.setRoles(role.getObjectID());
                }
                rs.close();
            }
        }
    }

    private void setSystemPrivileges(UserOracle user, Connection sqlConnection) throws Exception {
        ResultSet rs = null;
        try {
            if (this.systemPrivilegesStmt == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("PRIVILEGE").append(',');
                buffer.append("ADMIN_OPTION").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? DBA_SYS_PRIVS : USER_SYS_PRIVS).append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append(this.dbaUser ? GRANTEE : USERNAME).append('=').append('?');
                this.systemPrivilegesStmt = sqlConnection.prepareStatement(buffer.toString());
            }
            this.systemPrivilegesStmt.setString(1, user.getName());
            rs = this.systemPrivilegesStmt.executeQuery();
        }
        catch (SQLException se) {
            if (se.getMessage().startsWith("ORA-00942")) {
                System.out.println("MOHUserOracle.setSystemPrivileges(): " + se.getMessage());
                LOGGER.error("MOHUserOracle.setSystemPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_sys_privs" : "user_sys_privs"));
            } else {
                System.out.println("MOHUserOracle.setSystemPrivileges(): " + se.getMessage());
                LOGGER.error("MOHUserOracle.setSystemPrivileges():", se);
            }
        }
        catch (Exception e) {
            System.out.println("MOHUserOracle.setSystemPrivileges(): " + e.getMessage());
            LOGGER.error("MOHUserOracle.setSystemPrivileges():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String privilege = rs.getString("PRIVILEGE");
                String adminOption = rs.getString("ADMIN_OPTION");
                if ("YES".equalsIgnoreCase(adminOption)) {
                    user.setPrivilegesWithAdminOption(privilege);
                    continue;
                }
                user.setPrivileges(privilege);
            }
            rs.close();
        }
    }

    private void setObjectPrivileges(DBObject dbo, Connection sqlConnection) throws Exception {
        ResultSet rs = null;
        String objectType = dbo.getType();
        if ("TABLE".equals(objectType) || "VIEW".equals(objectType) || "SEQUENCE".equals(objectType) || "FUNCTION".equals(objectType) || "PACKAGE".equals(objectType) || "PROCEDURE".equals(objectType) || "COLLECTION".equals(objectType) || "OBJECT".equals(objectType) || "EXTERNAL TABLE".equals(objectType) || "DIRECTORY".equals(objectType)) {
            try {
                if (this.objectPrivilegesStmt == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("GRANTEE").append(',');
                    buffer.append("PRIVILEGE").append(',');
                    buffer.append("GRANTABLE").append(',');
                    buffer.append("HIERARCHY").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? DBA_TAB_PRIVS : ALL_TAB_PRIVS).append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append(this.dbaUser ? OWNER : TABLE_SCHEMA).append('=').append('?').append(' ');
                    buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?');
                    this.objectPrivilegesStmt = sqlConnection.prepareStatement(buffer.toString());
                }
                String schema = dbo.getSchema();
                if ("DIRECTORY".equals(objectType)) {
                    schema = "SYS";
                }
                this.objectPrivilegesStmt.setString(1, schema);
                this.objectPrivilegesStmt.setString(2, dbo.getName());
                rs = this.objectPrivilegesStmt.executeQuery();
            }
            catch (SQLException se) {
                if (se.getMessage().startsWith("ORA-00942")) {
                    System.out.println("MOHUserOracle.setObjectPrivileges(): " + se.getMessage());
                    LOGGER.error("MOHUserOracle.setObjectPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_tab_privs" : "all_tab_privs"));
                } else {
                    System.out.println("MOHUserOracle.setObjectPrivileges(): " + se.getMessage());
                    LOGGER.error("MOHUserOracle.setObjectPrivileges():", se);
                }
            }
            catch (Exception e) {
                System.out.println("MOHUserOracle.setObjectPrivileges(): " + e.getMessage());
                LOGGER.error("MOHUserOracle.setObjectPrivileges():", e);
            }
            if (rs != null) {
                StorageObject storageObject = null;
                while (rs.next() && (storageObject != null || (storageObject = this.findStorageObject(dbo)) != null)) {
                    String grantee = rs.getString("GRANTEE");
                    String privilegeName = rs.getString("PRIVILEGE");
                    String withGrantOption = rs.getString("GRANTABLE");
                    String withHierarchyOption = rs.getString("HIERARCHY");
                    UserOracle user = null;
                    RoleOracle role = null;
                    if (grantee.equals("PUBLIC") || this.allUserNames.contains(grantee)) {
                        UserSetOracle userSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet();
                        user = (UserOracle)userSetOracle.getByName(grantee);
                        if (user == null) {
                            user = userSetOracle.createUser();
                            user.setName(grantee);
                            this.stampModelObject((ModelObject)user, "", grantee);
                        }
                    } else {
                        RoleSetOracle roleSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getRoleSet();
                        role = (RoleOracle)roleSetOracle.getByName(grantee);
                        if (role == null) {
                            role = roleSetOracle.createRole();
                            role.setName(grantee);
                            this.stampModelObject((ModelObject)role, "", grantee);
                        }
                    }
                    PermissionsOracle perm = this.getPermissionsObject(objectType, storageObject, user, role);
                    if (perm == null) {
                        perm = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
                        perm.setUser(user);
                        perm.setRole(role);
                        if ("TABLE".equals(objectType)) {
                            if (storageObject instanceof SnapshotOracle) {
                                perm.setSnapshot((SnapshotOracle)storageObject);
                            } else {
                                perm.setTable((TableProxyOracle)storageObject);
                            }
                        } else if ("VIEW".equals(objectType)) {
                            perm.setView((TableViewProxyOracle)storageObject);
                        } else if ("SEQUENCE".equals(objectType)) {
                            perm.setSequence((SequenceOracle)storageObject);
                        } else if ("FUNCTION".equals(objectType)) {
                            perm.setFunctionOracle((FunctionOracle)storageObject);
                        } else if ("PACKAGE".equals(objectType)) {
                            perm.setPackage((PackageOracle)storageObject);
                        } else if ("PROCEDURE".equals(objectType)) {
                            perm.setProc((StoredProcedureOracle)storageObject);
                        } else if ("COLLECTION".equals(objectType)) {
                            perm.setCollectionTypeOracle((CollectionTypeProxyOracle)storageObject);
                        } else if ("OBJECT".equals(objectType)) {
                            perm.setStructuredTypeOracle((StructuredTypeProxyOracle)storageObject);
                        } else if ("EXTERNAL TABLE".equals(objectType)) {
                            perm.setExternalTableOracle((ExternalTableOracle)storageObject);
                        } else if ("DIRECTORY".equals(objectType)) {
                            perm.setDirectoryOracle((DirectoryOracle)storageObject);
                        } else {
                            perm.remove(true);
                        }
                    }
                    if (withGrantOption.equals("YES")) {
                        perm.setPrivilegesWithGrantOption(privilegeName);
                    } else {
                        perm.setPrivileges(privilegeName);
                    }
                    if (!withHierarchyOption.equals("YES")) continue;
                    perm.setPrivilegesWithHierarchyOption(privilegeName);
                }
                rs.close();
            }
        }
    }

    private StorageObject findStorageObject(DBObject dbObject) {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        String objectType = dbObject.getType();
        String objectName = dbObject.getName();
        String owner = dbObject.getSchema();
        if ("TABLE".equals(objectType)) {
            SnapshotOracle snapshot;
            TableProxyOracle tableProxy = (TableProxyOracle)storageDesign.getTableProxySet().getByUserSchemaAndName(owner, objectName);
            if (tableProxy != null && (snapshot = tableProxy.getSnapshot()) != null) {
                return snapshot;
            }
            return tableProxy;
        }
        if ("VIEW".equals(objectType)) {
            return storageDesign.getTableViewProxySet().getBySchemaAndName(owner, objectName);
        }
        if ("SEQUENCE".equals(objectType)) {
            return (SequenceOracle)storageDesign.getSequenceSet().getByUserSchemaAndName(owner, objectName);
        }
        if ("FUNCTION".equals(objectType)) {
            return storageDesign.getFunctionSet().getByOwnerAndName(owner, objectName);
        }
        if ("PACKAGE".equals(objectType)) {
            return storageDesign.getPackageSet().getByOwnerAndName(owner, objectName);
        }
        if ("PROCEDURE".equals(objectType)) {
            return storageDesign.getStoredProcedureSet().getByOwnerAndName(owner, objectName);
        }
        if ("COLLECTION".equals(objectType)) {
            return storageDesign.getCollectionTypeProxySet().getByOwnerAndName(owner, objectName);
        }
        if ("OBJECT".equals(objectType)) {
            return storageDesign.getStructuredTypeProxySet().getBySchemaAndName(owner, objectName);
        }
        if ("EXTERNAL TABLE".equals(objectType)) {
            return storageDesign.getExternalTableSet().getByOwnerAndName(owner, objectName);
        }
        if ("DIRECTORY".equals(objectType)) {
            return (DirectoryOracle)storageDesign.getDirectorySet().getByName(objectName);
        }
        return null;
    }

    private void setColumnPrivileges(DBObject dbo, Connection sqlConnection) throws Exception {
        if ("TABLE".equals(dbo.getType())) {
            ResultSet rs = null;
            try {
                if (this.columnPrivilegesStmt == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("GRANTEE").append(',');
                    buffer.append("COLUMN_NAME").append(',');
                    buffer.append("PRIVILEGE").append(',');
                    buffer.append("GRANTABLE").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? DBA_COL_PRIVS : ALL_COL_PRIVS).append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append(this.dbaUser ? OWNER : TABLE_SCHEMA).append('=').append('?').append(' ');
                    buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?');
                    this.columnPrivilegesStmt = sqlConnection.prepareStatement(buffer.toString());
                }
                this.columnPrivilegesStmt.setString(1, dbo.getSchema());
                this.columnPrivilegesStmt.setString(2, dbo.getName());
                rs = this.columnPrivilegesStmt.executeQuery();
            }
            catch (SQLException se) {
                if (se.getMessage().startsWith("ORA-00942")) {
                    System.out.println("MOHUserOracle.setColumnPrivileges(): " + se.getMessage());
                    LOGGER.error("MOHUserOracle.setColumnPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_col_privs" : "all_col_privs"));
                } else {
                    System.out.println("MOHUserOracle.setColumnPrivileges(): " + se.getMessage());
                    LOGGER.error("MOHUserOracle.setColumnPrivileges():", se);
                }
            }
            catch (Exception e) {
                System.out.println("MOHUserOracle.setColumnPrivileges(): " + e.getMessage());
                LOGGER.error("MOHUserOracle.setColumnPrivileges():", e);
            }
            if (rs != null) {
                TableProxyOracle tableProxy = null;
                while (rs.next() && (tableProxy != null || (tableProxy = (TableProxyOracle)this.findStorageObject(dbo)) != null)) {
                    String grantee = rs.getString("GRANTEE");
                    String columnName = rs.getString("COLUMN_NAME");
                    String privilegeName = rs.getString("PRIVILEGE");
                    String withGrantOption = rs.getString("GRANTABLE");
                    UserOracle user = null;
                    RoleOracle role = null;
                    if (grantee.equals("PUBLIC") || this.allUserNames.contains(grantee)) {
                        UserSetOracle userSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet();
                        user = (UserOracle)userSetOracle.getByName(grantee);
                        if (user == null) {
                            user = userSetOracle.createUser();
                            user.setName(grantee);
                            this.stampModelObject((ModelObject)user, "", grantee);
                        }
                    } else {
                        RoleSetOracle roleSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getRoleSet();
                        role = (RoleOracle)roleSetOracle.getByName(grantee);
                        if (role == null) {
                            role = roleSetOracle.createRole();
                            role.setName(grantee);
                            this.stampModelObject((ModelObject)role, "", grantee);
                        }
                    }
                    PermissionsOracle perm = this.getColumnPermissionsObject(columnName, tableProxy, user, role);
                    if (perm == null) {
                        perm = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
                        perm.setUser(user);
                        perm.setRole(role);
                        perm.setColumnsTable(tableProxy);
                    }
                    String colNameAndPrivilege = columnName + ", " + privilegeName;
                    if (withGrantOption.equals("YES")) {
                        perm.setColumnListWithGrantOption(colNameAndPrivilege);
                        continue;
                    }
                    perm.setColumnList(colNameAndPrivilege);
                }
                rs.close();
            }
        }
    }

    private PermissionsOracle getColumnPermissionsObject(String columnName, TableProxyOracle tableProxy, UserOracle user, RoleOracle role) {
        for (PermissionsOracle perm : ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet()) {
            String permColumnName;
            if (perm.getColumnsTable() != tableProxy || perm.getUser() != user || perm.getRole() != role) continue;
            String permColumnList = perm.getColumnList();
            if (permColumnList.isEmpty()) {
                permColumnList = perm.getColumnWithGrantOptionList();
            }
            if (!(permColumnName = permColumnList.substring(0, permColumnList.indexOf(44))).equalsIgnoreCase(columnName)) continue;
            return perm;
        }
        return null;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract User begin");
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            String filterCondition = this.getFilterConditionOracle("USERNAME");
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("USERNAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? DBA_USERS : ALL_USERS).append(' ');
            if (filterCondition != null) {
                buffer.append("WHERE").append(' ').append(filterCondition).append(' ');
            }
            buffer.append("ORDER BY").append(' ').append("USERNAME");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            LOGGER.error("MOHUserOracle.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String userName = rs.getString(1);
                this.allUserNames.add(userName);
                DBObject dboUser = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), userName, OBJECT_TYPE);
                list.add(dboUser);
            }
            rs.close();
        }
        statement.close();
        TimeLog.log("Extract User end");
        return list;
    }

    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        try {
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            if (storageDesign != null) {
                UserSetOracle userSet = storageDesign.getUserSet();
                for (DBObject dbObj : this.handledObjects) {
                    UserOracle user;
                    if (dbObj == null || (user = (UserOracle)userSet.getByName(dbObj.getName())) == null) continue;
                    RelationalDesign rd = this.getDesign().getRelationalDesign();
                    SchemaObject so = (SchemaObject)rd.getSchemaObjectSet().getByName(user.getName());
                    if (so == null) {
                        so = rd.getSchemaObjectSet().createSchemaObject(null);
                        so.setName(user.getName());
                        if (!user.getName().equals(user.getName().toUpperCase())) {
                            so.setNameHasQuotes(true);
                        }
                        this.stampModelObject((ModelObject)so, "", user.getName());
                    }
                    user.setSchemaObject(so);
                }
                this.objectPrivilegesStmt = null;
                this.columnPrivilegesStmt = null;
                for (AbstractMOHandler mohObject : this.getDbmeHandler().getMOHObjects()) {
                    for (DBObject dbo : mohObject.getHandledObjects()) {
                        this.setObjectPrivileges(dbo, sqlConnection);
                        this.setColumnPrivileges(dbo, sqlConnection);
                    }
                }
                if (this.objectPrivilegesStmt != null) {
                    this.objectPrivilegesStmt.close();
                    this.objectPrivilegesStmt = null;
                }
                if (this.columnPrivilegesStmt != null) {
                    this.columnPrivilegesStmt.close();
                    this.columnPrivilegesStmt = null;
                }
                this.allUserNames.clear();
                Iterator it = this.getDesign().getRelationalDesign().getSchemaObjectSet().iterator();
                while (it.hasNext()) {
                    SchemaObject so = (SchemaObject)it.next();
                    UserOracle user = (UserOracle)userSet.getByName(so.getName());
                    if (user == null) continue;
                    user.setSchemaObject(so);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PermissionsOracle getPermissionsObject(String objectType, StorageObject storageObject, UserOracle user, RoleOracle role) {
        for (PermissionsOracle perm : ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet()) {
            if (perm.getUser() != user || perm.getRole() != role) continue;
            StorageObject permissionObject = null;
            if ("TABLE".equals(objectType)) {
                permissionObject = storageObject instanceof SnapshotOracle ? perm.getSnapshot() : perm.getTable();
            } else if ("VIEW".equals(objectType)) {
                permissionObject = perm.getView();
            } else if ("SEQUENCE".equals(objectType)) {
                permissionObject = perm.getSequence();
            } else if ("FUNCTION".equals(objectType)) {
                permissionObject = perm.getFunctionOracle();
            } else if ("PACKAGE".equals(objectType)) {
                permissionObject = perm.getPackage();
            } else if ("PROCEDURE".equals(objectType)) {
                permissionObject = perm.getProc();
            } else if ("COLLECTION".equals(objectType)) {
                permissionObject = perm.getCollectionTypeOracle();
            } else if ("OBJECT".equals(objectType)) {
                permissionObject = perm.getStructuredTypeOracle();
            } else if ("EXTERNAL TABLE".equals(objectType)) {
                permissionObject = perm.getExternalTableOracle();
            } else if ("DIRECTORY".equals(objectType)) {
                permissionObject = perm.getDirectoryOracle();
            }
            if (permissionObject != storageObject) continue;
            return perm;
        }
        return null;
    }

    private void setQuotas(UserOracle user, Connection sqlConnection) throws Exception {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        if (storageDesign != null) {
            ResultSet rs = null;
            try {
                if (this.quotasStmt == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT");
                    buffer.append(' ').append("TABLESPACE_NAME");
                    if (this.dbaUser) {
                        buffer.append(',').append("USERNAME");
                    }
                    buffer.append(',').append("MAX_BYTES");
                    buffer.append(' ').append("FROM").append(' ');
                    buffer.append(this.dbaUser ? DBA_TS_QUOTAS : USER_TS_QUOTAS).append(' ');
                    String whereKeyword = "WHERE";
                    if (storageDesign instanceof StorageDesignOraclev11g) {
                        buffer.append("WHERE").append(' ');
                        buffer.append("DROPPED").append('=').append("'").append("NO").append("'").append(' ');
                        whereKeyword = "AND";
                    }
                    if (this.dbaUser) {
                        buffer.append(whereKeyword).append(' ');
                        buffer.append("USERNAME").append('=').append('?');
                    }
                    this.quotasStmt = sqlConnection.prepareStatement(buffer.toString());
                }
                if (this.dbaUser) {
                    this.quotasStmt.setString(1, user.getName());
                }
                rs = this.quotasStmt.executeQuery();
            }
            catch (SQLException se) {
                if (se.getMessage().startsWith("ORA-00942")) {
                    System.out.println("MOHUserOracle.setQuotas(): " + se.getMessage());
                    LOGGER.error("MOHUserOracle.setQuotas(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_ts_quotas" : "user_ts_quotas"));
                } else {
                    System.out.println("MOHUserOracle.setQuotas(): " + se.getMessage());
                    LOGGER.error("MOHUserOracle.setQuotas():", se);
                }
            }
            catch (Exception e) {
                LOGGER.error("MOHUserOracle.setQuotas():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String tsName = rs.getString("TABLESPACE_NAME");
                    String maxBytes = rs.getString("MAX_BYTES");
                    if (maxBytes.trim().equals("-1")) {
                        maxBytes = "UNLIMITED";
                    }
                    QuotaItemOracle qi = storageDesign.getQuotaItemSet().createQuotaItem();
                    TableSpaceOracle tSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                    qi.setTableSpace(tSpace);
                    qi.setSize(maxBytes);
                    qi.setUser(user);
                }
                rs.close();
            }
        }
    }
}

