/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatafileOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DATAFILE";
    private static final Logger LOGGER = new Logger(MOHDatafileOracle.class);
    protected boolean dbaUser;

    public MOHDatafileOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHDatafileOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Data File begin");
        if (this.dbaUser) {
            Statement statement = null;
            Statement tstatement = null;
            for (StorageObject sto : this.getTablespaces()) {
                ResultSet rs;
                block29: {
                    String sql;
                    StringBuffer buffer;
                    rs = null;
                    if (sto instanceof TemporaryTablespaceOracle) {
                        if (tstatement == null) {
                            buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ');
                            buffer.append("FILE_NAME").append(',');
                            buffer.append("TABLESPACE_NAME").append(',');
                            buffer.append("BYTES").append(',');
                            buffer.append("AUTOEXTENSIBLE").append(',');
                            buffer.append("MAXBYTES").append(',');
                            buffer.append("INCREMENT_BY").append(' ');
                            buffer.append("FROM").append(' ');
                            buffer.append("dba_temp_files").append(' ');
                            buffer.append("WHERE").append(' ').append("TABLESPACE_NAME").append(' ');
                            buffer.append('=').append(' ').append('?').append(' ');
                            buffer.append("ORDER BY").append(' ');
                            buffer.append("relative_fno").append(',');
                            buffer.append("TABLESPACE_NAME");
                            sql = buffer.toString();
                            tstatement = sqlConnection.prepareStatement(sql);
                        }
                        try {
                            tstatement.setString(1, sto.getName());
                            rs = tstatement.executeQuery();
                        }
                        catch (Exception se) {
                            System.out.println("MOHDatafileOracle.generate(): " + se.getMessage());
                            if (se.getMessage().startsWith("ORA-00942")) {
                                LOGGER.error("MOHDatafileOracle.generate(): current connection user has no SELECT privilege on dba_temp_files");
                                break block29;
                            }
                            LOGGER.error("MOHDatafileOracle.generate():", se);
                        }
                    } else {
                        if (statement == null) {
                            buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ');
                            buffer.append("FILE_NAME").append(',');
                            buffer.append("TABLESPACE_NAME").append(',');
                            buffer.append("BYTES").append(',');
                            buffer.append("AUTOEXTENSIBLE").append(',');
                            buffer.append("MAXBYTES").append(',');
                            buffer.append("INCREMENT_BY").append(' ');
                            buffer.append("FROM").append(' ');
                            buffer.append("dba_data_files").append(' ');
                            buffer.append("WHERE").append(' ').append("TABLESPACE_NAME").append(' ');
                            buffer.append('=').append(' ').append('?').append(' ');
                            buffer.append("ORDER BY").append(' ');
                            buffer.append("relative_fno").append(',');
                            buffer.append("TABLESPACE_NAME");
                            sql = buffer.toString();
                            statement = sqlConnection.prepareStatement(sql);
                        }
                        try {
                            statement.setString(1, sto.getName());
                            rs = statement.executeQuery();
                        }
                        catch (Exception se) {
                            System.out.println("MOHDatafileOracle.generate(): " + se.getMessage());
                            if (se.getMessage().startsWith("ORA-00942")) {
                                LOGGER.error("MOHDatafileOracle.generate(): current connection user has no SELECT privilege on dba_data_files");
                            }
                            LOGGER.error("MOHDatafileOracle.generate():", se);
                        }
                    }
                }
                StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                if (rs == null) continue;
                while (rs.next()) {
                    long bytes;
                    String fileName = rs.getString("FILE_NAME");
                    String sBytes = rs.getString("BYTES");
                    try {
                        bytes = Long.parseLong(sBytes);
                    }
                    catch (Exception e1) {
                        LOGGER.error("MOHDatafileOracle.generate(): Error parsing \"BYTES\" - " + sBytes);
                        bytes = 1024L;
                    }
                    String autoextensible = rs.getString("AUTOEXTENSIBLE");
                    String maxBytes = rs.getString("MAXBYTES");
                    int incrementBy = rs.getInt("INCREMENT_BY");
                    String tsName = rs.getString("TABLESPACE_NAME");
                    DataFileOracle dataFile = storage.getDataFileSet().createDataFile();
                    dataFile.setFileName(fileName);
                    try {
                        File file = new File(fileName);
                        dataFile.setName(file.getName());
                    }
                    catch (Exception e) {
                        dataFile.setName(fileName);
                    }
                    this.stampModelObject((ModelObject)dataFile, "", fileName);
                    if (bytes % 1024L == 0L) {
                        dataFile.setSize(bytes / 1024L);
                        dataFile.setMeasureUnit("K");
                    } else {
                        dataFile.setSize(bytes);
                        dataFile.setMeasureUnit("");
                    }
                    if (maxBytes == null) {
                        dataFile.setMaxSize("-1");
                    } else if (!maxBytes.equalsIgnoreCase("34359721984")) {
                        try {
                            double maxSize = Double.parseDouble(maxBytes);
                            dataFile.setMaxSize(String.valueOf(maxSize / 1024.0));
                            dataFile.setMaxSizeUnit("K");
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if ("YES".equalsIgnoreCase(autoextensible)) {
                        dataFile.setAutoextend("ON");
                    } else if ("NO".equalsIgnoreCase(autoextensible)) {
                        dataFile.setAutoextend("OFF");
                    }
                    dataFile.setNextBlockSize(incrementBy * 8);
                    dataFile.setNextBlockSizeUnit("K");
                    this.assignToTablespace(dataFile, tsName, sto);
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (tstatement != null) {
                tstatement.close();
            }
        }
        TimeLog.log("Data File end");
    }

    private void assignToTablespace(DataFileOracle df, String tsName, StorageObject sto) {
        StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
        if (sto instanceof TableSpaceOracle) {
            df.setTableSpace((TableSpaceOracle)sto);
        } else if (storage instanceof StorageDesignOraclev9i) {
            if (sto instanceof TemporaryTablespaceOracle) {
                ((DataFileOraclev9i)df).setTemporaryTablespace((TemporaryTablespaceOraclev9i)sto);
                TemporaryTablespaceOraclev9i tbls = (TemporaryTablespaceOraclev9i)sto;
                tbls.setFilename(df.getFileName());
                tbls.setSize(df.getSize());
                tbls.setNextBlockSize(df.getNextBlockSize());
                tbls.setMaxSize(df.getMaxSize());
                tbls.setAutoextend(df.getAutoextend());
                df.remove();
            } else if (sto instanceof UndoTablespaceOracle) {
                ((DataFileOraclev9i)df).setUndoTablespace((UndoTablespaceOracle)sto);
            }
        } else if (storage instanceof StorageDesignOraclev10g) {
            if (sto instanceof TemporaryTablespaceOracle) {
                ((DataFileOraclev10g)df).setTemporaryTablespace((TemporaryTablespaceOraclev10g)sto);
            } else if (sto instanceof UndoTablespaceOracle) {
                ((DataFileOraclev10g)df).setUndoTablespace((UndoTablespaceOracle)sto);
            }
        }
    }

    private List getTablespaces() {
        ArrayList list = new ArrayList();
        StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
        storage.getTableSpaceSet().addAllElementsTo(list);
        storage.getTemporaryTablespaceSet().addAllElementsTo(list);
        storage.getUndoTablespaceSet().addAllElementsTo(list);
        return list;
    }
}

