/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableDB2
extends MOHTable {
    protected static final String DBADM = "DBADM";
    protected static final String DBCTRL = "DBCTRL";
    protected static final String DBMAINT = "DBMAINT";
    protected static final String CREATETAB = "CREATETAB";
    protected static final String CREATETS = "CREATETS";
    protected static final String DISPLAYDB = "DISPLAYDB";
    protected static final String DROP = "DROP";
    protected static final String IMAGCOMPY = "IMAGCOMPY";
    protected static final String LOAD = "LOAD";
    protected static final String RECOVERDB = "RECOVERDB";
    protected static final String REORG = "REORG";
    protected static final String REPAIR = "REPAIR";
    protected static final String STARTDB = "STARTDB";
    protected static final String STATS = "STATS";
    protected static final String STOPDB = "STOPDB";
    protected static final String Y = "Y";
    protected static final String G = "G";
    private static final Logger LOGGER = new Logger(MOHTableDB2.class);

    public MOHTableDB2(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT name from SYSIBM.SYSTABLES").append(' ');
                buffer.append("WHERE TYPE = 'T' and CREATOR = '");
                buffer.append(dboNext.getName()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHTableDB2.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String tablename = rs.getString(1);
                    DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablename, "TABLE", dboNext.getName());
                    list.add(dboTable);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String ownerName = dbo.getSchema();
            if (!"TABLE".equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TSNAME, DBNAME, OBID, EDPROC, VALPROC, ");
                buffer.append("AUDITING, DATACAPTURE, ENCODING_SCHEME, ");
                buffer.append("PCTROWCOMP, CREATEDBY, RECLENGTH, NPAGES, PCTPAGES ");
                buffer.append("from SYSIBM.SYSTABLES ");
                buffer.append("WHERE TYPE = 'T' and NAME = '");
                buffer.append(dbo.getName()).append("' and CREATOR = '").append(ownerName).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHTableDB2.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    String tsname = rs.getString(1);
                    String dbname = rs.getString(2);
                    int obid = rs.getInt(3);
                    String edproc = rs.getString(4);
                    String valproc = rs.getString(5);
                    String audit = rs.getString(6);
                    String datacapture = rs.getString(7);
                    String ccsid = rs.getString(8);
                    int rows = rs.getInt(9);
                    String createby = rs.getString(10);
                    int reclength = rs.getInt(11);
                    int npages = rs.getInt(12);
                    int pctpages = rs.getInt(13);
                    Table table = this.getDesign().getRelationalDesign().createTable();
                    table.setSchema(dbo.getSchema());
                    table.setName(name);
                    this.stampModelObject(table, dbo);
                    AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)this.getStorageDesign();
                    DataBaseDB2 db = (DataBaseDB2)storage.getDataBaseSet().getByName(dbname);
                    if (db == null) {
                        db = this.createDatabase(sqlConnection, dbname);
                    }
                    TableProxyDB2 proxy = (TableProxyDB2)storage.getTableProxySet().getProxy(table.getObjectID());
                    proxy.setName(name);
                    this.initColumns(sqlConnection, table, ownerName);
                    TableSpaceDB2 ts = (TableSpaceDB2)storage.getTableSpaceSet().getByName(tsname);
                    if (ts == null) {
                        ts = this.createTablespace(sqlConnection, tsname, dbname, ownerName);
                    }
                    proxy.setTableSpace(ts);
                    Owner owner = (Owner)storage.getOwnerSet().getByName(ownerName);
                    if (owner == null) {
                        owner = (Owner)storage.getOwnerSet().createElement(ownerName);
                        owner.setName(ownerName);
                        this.stampModelObject((ModelObject)owner, "", ownerName);
                    }
                    proxy.setOwner(owner);
                    proxy.setObid(obid);
                    proxy.setEditProc(edproc);
                    proxy.setValidProc(valproc);
                    if ("A".equalsIgnoreCase(audit)) {
                        proxy.setAudit("ALL");
                    } else if ("C".equalsIgnoreCase(audit)) {
                        proxy.setAudit("CHANGES");
                    }
                    if (Y.equalsIgnoreCase(datacapture)) {
                        proxy.setDataCapture(true);
                    } else {
                        proxy.setDataCapture(false);
                    }
                    if (ccsid.trim().equalsIgnoreCase("E")) {
                        proxy.setCcsid("EBCDIC");
                    } else if (ccsid.trim().equalsIgnoreCase("A")) {
                        proxy.setCcsid("ASCII");
                    } else if (ccsid.trim().equalsIgnoreCase("U")) {
                        proxy.setCcsid("UNICODE");
                    }
                    proxy.setNumberOfRows(rows);
                    proxy.setCreatedBy(createby);
                    proxy.setRecordLength(reclength);
                    proxy.setNumberOfPages(npages);
                    proxy.setPercentageOfPages(pctpages);
                    this.initColumnIdentity(sqlConnection, proxy, ownerName, storage);
                    this.initSynonyms(sqlConnection, proxy, ownerName);
                    this.initTriggers(sqlConnection, proxy, ownerName);
                    boolean partitioned = true;
                    if (ts != null) {
                        partitioned = ts.isPartitioned();
                    }
                    this.initIndexes(sqlConnection, table, ownerName, partitioned);
                    this.initUniqueConstraints(sqlConnection, table, ownerName);
                    this.initColumnConstraints(sqlConnection, table, ownerName);
                    this.initTableConstraints(sqlConnection, table, ownerName);
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private TableSpaceDB2 createTablespace(Connection sqlConnection, String tsname, String dbname, String ownername) throws Exception {
        TableSpaceDB2 ts = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT TYPE, PARTITIONS, ");
            buffer.append("DSSIZE, SEGSIZE, BPOOL, LOCKRULE, LOCKMAX, ");
            buffer.append("CLOSERULE, ENCODING_SCHEME, LOCKPART, MAXROWS, ");
            buffer.append("OBID, PSID, NACTIVE, CREATEDBY, SPACE ");
            buffer.append("from SYSIBM.SYSTABLESPACE").append(' ');
            buffer.append("WHERE NAME = '").append(tsname).append("'");
            buffer.append(" AND DBNAME = '").append(dbname).append("'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2v80.createTablespace():", e);
        }
        if (rs != null) {
            if (rs.next()) {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                    String type = rs.getString(1);
                    int partions = rs.getInt(2);
                    int dssize = rs.getInt(3);
                    int segsize = rs.getInt(4);
                    String bpool = rs.getString(5);
                    String lockrule = rs.getString(6);
                    int lockmax = rs.getInt(7);
                    String closerule = rs.getString(8);
                    String ccsid = rs.getString(9);
                    String lockpart = rs.getString(10);
                    int maxrows = rs.getInt(11);
                    int obid = rs.getInt(12);
                    int psid = rs.getInt(13);
                    int nactive = rs.getInt(14);
                    String createdby = rs.getString(15);
                    int space = rs.getInt(16);
                    DataBaseDB2 db = (DataBaseDB2)storage.getDataBaseSet().getByName(dbname);
                    if (db != null) {
                        ts = storage.getTableSpaceSet().createTableSpace();
                        ts.setName(tsname);
                        ts.setDataBase(db);
                        this.stampModelObject((ModelObject)ts, ownername, tsname);
                        if ("L".equalsIgnoreCase(type)) {
                            ts.setType("LOB");
                        }
                        ts.setDsSize(dssize / 0x100000 + " G");
                        ts.setSegSize("" + segsize);
                        BufferPoolDB2 bp = (BufferPoolDB2)storage.getBufferPoolSet().getByName(bpool);
                        if (bp != null) {
                            ts.setBufferPool(bp);
                        }
                        if ("A".equalsIgnoreCase(lockrule)) {
                            ts.setLockSize("ANY");
                        } else if ("L".equalsIgnoreCase(lockrule)) {
                            ts.setLockSize("LOB");
                        } else if ("P".equalsIgnoreCase(lockrule)) {
                            ts.setLockSize("PAGE");
                        } else if ("R".equalsIgnoreCase(lockrule)) {
                            ts.setLockSize("ROW");
                        } else if ("S".equalsIgnoreCase(lockrule)) {
                            ts.setLockSize("TABLESPACE");
                        } else if ("T".equalsIgnoreCase(lockrule)) {
                            ts.setLockSize("TABLE");
                        }
                        ts.setLockMax(lockmax);
                        if ("N".equalsIgnoreCase(closerule)) {
                            ts.setClose(false);
                        } else {
                            ts.setClose(true);
                        }
                        if (ccsid.trim().equalsIgnoreCase("E")) {
                            ts.setCcsid("EBCDIC");
                        } else if (ccsid.trim().equalsIgnoreCase("A")) {
                            ts.setCcsid("ASCII");
                        } else if (ccsid.trim().equalsIgnoreCase("U")) {
                            ts.setCcsid("UNICODE");
                        }
                        if (Y.equalsIgnoreCase(lockpart)) {
                            ts.setLockPart(true);
                        } else {
                            ts.setClose(false);
                        }
                        ts.setMaxRows(maxrows);
                        ts.setObid(obid);
                        ts.setPsid(psid);
                        ts.setNactive(nactive);
                        ts.setCreatedBy(createdby);
                        ts.setSpace(space);
                        ts.setNumParts(partions);
                        if (partions > 0) {
                            ts.setType("PARTITIONED");
                            this.initTablespacePartitions(sqlConnection, ts);
                        }
                    }
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        return ts;
    }

    private void initTablespacePartitions(Connection sqlConnection, TableSpaceDB2 ts) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT PARTITION, COMPRESS, ");
            buffer.append("VCATNAME, STORNAME, PQTY, SQTY, FREEPAGE, PCTFREE, GBPCACHE, TRACKMOD ");
            buffer.append("from SYSIBM.SYSTABLEPART ");
            buffer.append("WHERE TSNAME = '");
            buffer.append(ts.getName()).append("'");
            buffer.append("ORDER BY PARTITION");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTablespaceDB2.initTablespacePartitions():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                int partNumber = rs.getInt(1);
                String compress = rs.getString(2);
                String vcatName = rs.getString(3);
                String sgName = rs.getString(4).trim();
                int pqty = rs.getInt(5) * 4;
                int sqty = rs.getInt(6) * 4;
                int freepage = rs.getInt(7);
                int pctfree = rs.getInt(8);
                String gbcache = rs.getString(9);
                String track = rs.getString(10);
                if (partNumber <= 0) continue;
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 storage = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    StorageTemplateDB2 realst;
                    storage = (AbstractStorageDesignDB2)storageDesign;
                    ts.setType("PARTITIONED");
                    PartitionDB2 part = storage.getPartitionSet().createPartition();
                    part.setTableSpace(ts);
                    part.setPartNumber(partNumber);
                    if (Y.equalsIgnoreCase(compress)) {
                        part.setCompress(true);
                    } else {
                        part.setCompress(false);
                    }
                    StorageTemplateDB2 st = storage.getStorageTemplateSet().createStorageTemplate();
                    part.setStorageTemplate(st);
                    if (!"".equalsIgnoreCase(sgName)) {
                        StorageGroupDB2 sg = (StorageGroupDB2)storage.getStorageGroupSet().getByName(sgName);
                        if (sg != null) {
                            st.setStorageGroup(sg);
                        }
                    } else {
                        VCatDB2 vcat = (VCatDB2)storage.getVCatSet().getByName(vcatName);
                        if (vcat != null) {
                            st.setVCat(vcat);
                        }
                    }
                    st.setSgPriqty(pqty);
                    st.setSgSeqty(sqty);
                    st.setFreePage(freepage);
                    st.setPctFree(pctfree);
                    if ("A".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("ALL");
                    } else if ("N".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("NONE");
                    } else if ("S".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("SYSTEM");
                    } else if ("".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("CHANGED");
                    }
                    if ("N".equalsIgnoreCase(track)) {
                        st.setTrackMode(false);
                    } else {
                        st.setTrackMode(true);
                    }
                    if ((realst = storage.getStorageTemplateSet().removeIfExistEqual(st)) == part.getStorageTemplate()) continue;
                    part.setStorageTemplate(realst);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private DataBaseDB2 createDatabase(Connection sqlConnection, String dbname) throws Exception {
        DataBaseDB2 database = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT BPOOL, INDEXBP, TYPE, GROUP_MEMBER, STGROUP, ENCODING_SCHEME").append(' ');
            buffer.append("from SYSIBM.SYSDATABASE").append(' ');
            buffer.append("WHERE NAME = '").append(dbname).append("'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.createDatabase():", e);
        }
        if (rs != null) {
            if (rs.next()) {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                    String bpName = rs.getString(1);
                    String indexBp = rs.getString(2);
                    String type = rs.getString(3);
                    String member = rs.getString(4);
                    String stoGroupName = rs.getString(5);
                    String ccsid = rs.getString(6);
                    database = storage.getDataBaseSet().createDataBase();
                    database.setName(dbname);
                    this.stampModelObject((ModelObject)database, "", dbname);
                    BufferPoolDB2 bp = (BufferPoolDB2)storage.getBufferPoolSet().getByName(bpName);
                    if (bp != null) {
                        database.setBufferPool(bp);
                    }
                    if ((bp = (BufferPoolDB2)storage.getBufferPoolSet().getByName(indexBp)) != null) {
                        database.setIndexBufferPool(bp);
                    }
                    if (type.trim().equalsIgnoreCase("T")) {
                        database.setType("TEMP");
                    } else if (type.trim().equalsIgnoreCase("W")) {
                        database.setType("WORKFILE");
                    }
                    database.setMember(member);
                    if (!"".equalsIgnoreCase(stoGroupName.trim())) {
                        StorageGroupDB2 stoGroup = (StorageGroupDB2)storage.getStorageGroupSet().getByName(stoGroupName);
                        if (stoGroup == null) {
                            stoGroup = storage.getStorageGroupSet().createStorageGroup();
                            stoGroup.setName(stoGroupName);
                            this.stampModelObject((ModelObject)stoGroup, "", stoGroupName);
                        }
                        database.setStorageGroup(stoGroup);
                    }
                    if (ccsid.trim().equalsIgnoreCase("E")) {
                        database.setCcsid("EBCDIC");
                    } else if (ccsid.trim().equalsIgnoreCase("A")) {
                        database.setCcsid("ASCII");
                    } else if (ccsid.trim().equalsIgnoreCase("U")) {
                        database.setCcsid("UNICODE");
                    }
                    this.initDBPrivileges(sqlConnection, database, storage);
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        return database;
    }

    private void initDBPrivileges(Connection sqlConnection, DataBaseDB2 database, AbstractStorageDesignDB2 storage) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT GRANTOR, CREATETABAUTH, CREATETSAUTH, ");
            buffer.append("DBADMAUTH, DBCTRLAUTH, DBMAINTAUTH, DISPLAYDBAUTH, ");
            buffer.append("DROPAUTH, IMAGCOPYAUTH, LOADAUTH, REORGAUTH, ");
            buffer.append("RECOVERDBAUTH, REPAIRAUTH, STARTDBAUTH, STATSAUTH, STOPAUTH ");
            buffer.append("from SYSIBM.SYSDBAUTH ");
            buffer.append("WHERE NAME = '");
            buffer.append(database.getName()).append("'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHDatabaseDB2.initPrivileges():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String user = rs.getString(1).trim();
                String createtab = rs.getString(2);
                String createts = rs.getString(3);
                String dbaadm = rs.getString(4);
                String dbctrl = rs.getString(5);
                String dbmaint = rs.getString(6);
                String displaydb = rs.getString(7);
                String drop = rs.getString(8);
                String imagcopy = rs.getString(9);
                String load = rs.getString(10);
                String reorg = rs.getString(11);
                String recoverdb = rs.getString(12);
                String repair = rs.getString(13);
                String startdb = rs.getString(14);
                String stats = rs.getString(15);
                String stopdb = rs.getString(16);
                StringBuffer buffer = new StringBuffer();
                boolean grant = false;
                boolean first = true;
                if (createtab.equalsIgnoreCase(Y)) {
                    buffer.append(CREATETAB);
                    first = false;
                } else if (createtab.equalsIgnoreCase(G)) {
                    buffer.append(CREATETAB);
                    first = false;
                    grant = true;
                }
                if (createts.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(CREATETS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATETS);
                    }
                } else if (createts.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(CREATETS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATETS);
                    }
                    grant = true;
                }
                if (dbaadm.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DBADM);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBADM);
                    }
                } else if (dbaadm.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DBADM);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBADM);
                    }
                    grant = true;
                }
                if (dbctrl.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DBCTRL);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBCTRL);
                    }
                } else if (dbctrl.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DBCTRL);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBCTRL);
                    }
                    grant = true;
                }
                if (dbmaint.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DBMAINT);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBMAINT);
                    }
                } else if (dbmaint.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DBMAINT);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBMAINT);
                    }
                    grant = true;
                }
                if (displaydb.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DISPLAYDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DISPLAYDB);
                    }
                } else if (displaydb.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DISPLAYDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DISPLAYDB);
                    }
                    grant = true;
                }
                if (drop.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DROP);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DROP);
                    }
                } else if (drop.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DROP);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DROP);
                    }
                    grant = true;
                }
                if (imagcopy.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(IMAGCOMPY);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(IMAGCOMPY);
                    }
                } else if (imagcopy.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(IMAGCOMPY);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(IMAGCOMPY);
                    }
                    grant = true;
                }
                if (load.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(LOAD);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(LOAD);
                    }
                } else if (load.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(LOAD);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(LOAD);
                    }
                    grant = true;
                }
                if (recoverdb.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(RECOVERDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(RECOVERDB);
                    }
                } else if (recoverdb.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(RECOVERDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(RECOVERDB);
                    }
                    grant = true;
                }
                if (reorg.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(REORG);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(REORG);
                    }
                } else if (reorg.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(REORG);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(REORG);
                    }
                    grant = true;
                }
                if (repair.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(REPAIR);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(REPAIR);
                    }
                } else if (repair.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(REPAIR);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(REPAIR);
                    }
                    grant = true;
                }
                if (startdb.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(STARTDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STARTDB);
                    }
                } else if (repair.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(STARTDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STARTDB);
                    }
                    grant = true;
                }
                if (stats.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(STATS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STATS);
                    }
                } else if (stats.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(STATS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STATS);
                    }
                    grant = true;
                }
                if (stopdb.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(STOPDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STOPDB);
                    }
                } else if (stopdb.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(STOPDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STOPDB);
                    }
                    grant = true;
                }
                PrivilegesDB2 priv = storage.getPrivilegesSet().createPriv();
                priv.setDb(database);
                Owner owner = (Owner)storage.getOwnerSet().getByName(user);
                if (owner == null) {
                    owner = (Owner)storage.getOwnerSet().createElement(user);
                    owner.setName(user);
                    this.stampModelObject((ModelObject)owner, "", user);
                }
                priv.setUser(owner);
                priv.setSystemPrivileges(buffer.toString());
                if (grant) {
                    priv.setGrantOption("YES");
                    continue;
                }
                priv.setGrantOption("NO");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initColumns(Connection sqlConnection, Table table, String ownerName) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT NAME, COLTYPE, LENGTH, SCALE, ");
            buffer.append("NULLS, REMARKS, DEFAULT, DEFAULTVALUE, ");
            buffer.append("LABEL ");
            buffer.append("from SYSIBM.SYSCOLUMNS ");
            buffer.append("WHERE TBNAME = '");
            buffer.append(table.getName()).append("'");
            buffer.append(" AND TBCREATOR = '");
            buffer.append(ownerName).append("' ORDER BY COLNO");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString(1);
                String colDatatype = rs.getString(2).trim();
                int colSize = rs.getInt(3);
                int colScale = rs.getInt(4);
                String nulls = rs.getString(5);
                String remarks = rs.getString(6);
                String def = rs.getString(7);
                String defValue = rs.getString(8);
                String label = rs.getString(9);
                if ("TIMESTMP".equalsIgnoreCase(colDatatype)) {
                    colDatatype = "TIMESTAMP";
                } else if ("VARG".equalsIgnoreCase(colDatatype)) {
                    colDatatype = "VARGRAPHIC";
                } else if ("LONGVARG".equalsIgnoreCase(colDatatype)) {
                    colDatatype = "LONG VARGRAPHIC";
                } else if ("LONGVAR".equalsIgnoreCase(colDatatype)) {
                    colDatatype = "LONG VARCHAR";
                }
                Column column = table.createColumn(colName);
                this.stampModelObject((ModelObject)column, table.getName(), colName);
                LogicalDatatype logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(colDatatype, this.getDbmeHandler().getRDBMSSite().getType().getName());
                if (logDatatype != null) {
                    column.setUse((short)1);
                    column.setLogicalDatatype(logDatatype);
                    column.setDataTypeParameter("size", String.valueOf(colSize));
                    column.setDataTypeParameter("precision", String.valueOf(colSize));
                    column.setDataTypeParameter("scale", String.valueOf(colScale));
                } else {
                    System.out.println("Unable to find logical datatype for: " + colDatatype);
                }
                if (Y.equalsIgnoreCase(nulls)) {
                    column.setNullsAllowed(true);
                } else {
                    column.setNullsAllowed(false);
                }
                if ("N".equalsIgnoreCase(def)) {
                    column.setUsesDefaultValue(false);
                } else {
                    column.setUsesDefaultValue(true);
                    column.setDefaultValue(defValue);
                }
                column.setComment(remarks);
                column.setCommentInRDBMS(label);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initIndexes(Connection sqlConnection, Table table, String ownerName, boolean partitioned) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT i.NAME, i.UNIQUERULE, i.CLUSTERED, ");
            buffer.append("i.PGSIZE, i.BPOOL, i.CLOSERULE, i.COPY, i.CREATOR ");
            buffer.append("from SYSIBM.SYSINDEXES i ");
            buffer.append("WHERE i.TBNAME = '");
            buffer.append(table.getName()).append("'");
            buffer.append(" AND i.TBCREATOR = '");
            buffer.append(ownerName).append("'");
            buffer.append(" AND not exists (");
            buffer.append(" select 1 from sysibm.systabconst t ");
            buffer.append("where ");
            buffer.append("t.ixowner = i.creator and ");
            buffer.append("t.ixname = i.name)");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initIndexes():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String state = rs.getString(2);
                String clustered = rs.getString(3);
                int pieceSize = rs.getInt(4);
                String bpName = rs.getString(5);
                String close = rs.getString(6);
                String copy = rs.getString(7);
                String owner = rs.getString(8);
                Index index = table.createIndex();
                index.setName(name);
                this.stampModelObject((ModelObject)index, ownerName, name);
                boolean whereNotNull = false;
                if ("U".equalsIgnoreCase(state)) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(state)) {
                    index.setIndexState("Primary Constraint");
                } else if ("C".equalsIgnoreCase(state) || "R".equalsIgnoreCase(state)) {
                    index.setIndexState("Unique Constraint");
                } else if ("N".equalsIgnoreCase(state)) {
                    index.setIndexState("Unique Plain Index");
                    whereNotNull = true;
                }
                this.initKeyColumns(sqlConnection, index, name, table);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 storage = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storage = (AbstractStorageDesignDB2)storageDesign;
                    IndexProxyDB2 proxy = (IndexProxyDB2)storage.getIndexProxySet().getProxy(index.getObjectID());
                    if (proxy != null) {
                        Owner o = (Owner)storage.getOwnerSet().getByName(owner);
                        if (o != null) {
                            proxy.setOwner(o);
                        }
                        if (Y.equalsIgnoreCase(clustered)) {
                            proxy.setClusterType("CLUSTERED_PARTITIONED");
                        } else if ("N".equalsIgnoreCase(clustered)) {
                            proxy.setClusterType("CLUSTERED");
                        } else {
                            proxy.setClusterType("NONE");
                        }
                        proxy.setPieceSize(pieceSize + " K");
                        BufferPoolDB2 bp = (BufferPoolDB2)storage.getBufferPoolSet().getByName(bpName);
                        if (bp != null) {
                            proxy.setBufferPool(bp);
                        }
                        proxy.setWhereNotNull(whereNotNull);
                        if (Y.equalsIgnoreCase(close)) {
                            proxy.setClose(true);
                        } else {
                            proxy.setClose(false);
                        }
                        if (Y.equalsIgnoreCase(copy)) {
                            proxy.setCopy(true);
                        } else {
                            proxy.setCopy(false);
                        }
                        if (!partitioned) continue;
                        this.initIndexPartitions(sqlConnection, proxy);
                        continue;
                    }
                    LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initUniqueConstraints(Connection sqlConnection, Table table, String ownerName) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT t.constname, t.ixowner, t.ixname, ");
            buffer.append("i.uniquerule, i.CLUSTERED, i.PGSIZE, ");
            buffer.append("i.BPOOL, i.CLOSERULE, i.COPY ");
            buffer.append("FROM sysibm.systabconst t, sysibm.sysindexes i ");
            buffer.append("WHERE t.TBNAME = '");
            buffer.append(table.getName()).append("'");
            buffer.append(" AND t.tbcreator = '");
            buffer.append(ownerName).append("'");
            buffer.append(" AND t.ixowner = i.creator");
            buffer.append(" AND t.ixname = i.name");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initUniqueConstraints():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String constrName = rs.getString(1);
                String owner = rs.getString(2);
                String indName = rs.getString(3);
                String uniqueRule = rs.getString(4);
                String clustered = rs.getString(5);
                int pieceSize = rs.getInt(6);
                String bpName = rs.getString(7);
                String close = rs.getString(8);
                String copy = rs.getString(9);
                Index index = table.createIndex();
                index.setName(constrName);
                this.stampModelObject((ModelObject)index, ownerName, constrName);
                this.initKeyColumns(sqlConnection, index, indName, table);
                boolean whereNotNull = false;
                if ("U".equalsIgnoreCase(uniqueRule)) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(uniqueRule)) {
                    index.setIndexState("Primary Constraint");
                } else if ("C".equalsIgnoreCase(uniqueRule) || "R".equalsIgnoreCase(uniqueRule)) {
                    index.setIndexState("Unique Constraint");
                } else if ("N".equalsIgnoreCase(uniqueRule)) {
                    index.setIndexState("Unique Plain Index");
                    whereNotNull = true;
                }
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 storage = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storage = (AbstractStorageDesignDB2)storageDesign;
                    IndexProxyDB2 proxy = (IndexProxyDB2)storage.getIndexProxySet().getProxy(index.getObjectID());
                    if (proxy != null) {
                        proxy.setName(indName);
                        Owner o = (Owner)storage.getOwnerSet().getByName(owner);
                        if (o != null) {
                            proxy.setOwner(o);
                        }
                        if (Y.equalsIgnoreCase(clustered)) {
                            proxy.setClusterType("CLUSTERED_PARTITIONED");
                        } else if ("N".equalsIgnoreCase(clustered)) {
                            proxy.setClusterType("CLUSTERED");
                        } else {
                            proxy.setClusterType("NONE");
                        }
                        proxy.setPieceSize(pieceSize + " K");
                        BufferPoolDB2 bp = (BufferPoolDB2)storage.getBufferPoolSet().getByName(bpName);
                        if (bp != null) {
                            proxy.setBufferPool(bp);
                        }
                        proxy.setWhereNotNull(whereNotNull);
                        if (Y.equalsIgnoreCase(close)) {
                            proxy.setClose(true);
                        } else {
                            proxy.setClose(false);
                        }
                        if (Y.equalsIgnoreCase(copy)) {
                            proxy.setCopy(true);
                        } else {
                            proxy.setCopy(false);
                        }
                        this.initIndexPartitions(sqlConnection, proxy);
                        continue;
                    }
                    LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initKeyColumns(Connection sqlConnection, Index index, String indName, Table table) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT COLNAME, ORDERING ");
            buffer.append("from SYSIBM.SYSKEYS ");
            buffer.append("WHERE IXNAME = '");
            buffer.append(indName).append("'");
            buffer.append(" ORDER BY COLSEQ ");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initKeyColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString(1);
                String order = rs.getString(2);
                Column col = (Column)table.getElementByName(colName);
                if (col == null) continue;
                index.add(col);
                if ("A".equals(order)) {
                    index.setColumnSortOrder(col, "ASC");
                    continue;
                }
                index.setColumnSortOrder(col, "DESC");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initColumnIdentity(Connection sqlConnection, TableProxyDB2 table, String ownerName, AbstractStorageDesignDB2 storage) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select d.dcolname, ");
            buffer.append("s.START, s.INCREMENT, s.MINVALUE, ");
            buffer.append("s.MAXVALUE, s.CYCLE, s.CACHE ");
            buffer.append("from sysibm.syssequencesdep d, sysibm.syssequences s ");
            buffer.append("where ");
            buffer.append("d.dcreator = '").append(ownerName).append('\'');
            buffer.append(" and d.dname = '").append(table.getName()).append('\'');
            buffer.append(" and s.sequenceid = d.bsequenceid");
            buffer.append(" AND s.SEQTYPE = 'I'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initIdentityColumn():", e);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableDB2.initIdentityColumn():", e);
        }
        if (rs != null) {
            if (rs.next()) {
                String colName = rs.getString(1);
                String start = rs.getString(2);
                int increment = rs.getInt(3);
                int minvalue = rs.getInt(4);
                int maxvalue = rs.getInt(5);
                String cycle = rs.getString(6);
                int cache = rs.getInt(7);
                ColumnProxyDB2 column = table.getColumn(colName);
                if (column != null) {
                    ColumnIdentityDB2 identity = storage.getColumnIdentitySet().createColumnIdentity();
                    identity.setColumn(column);
                    identity.setStartWith(start);
                    identity.setIncrementBy(increment);
                    identity.setMinValue("" + minvalue);
                    identity.setMaxValue("" + maxvalue);
                    if ("N".equalsIgnoreCase(cycle)) {
                        identity.setCycle(false);
                    } else {
                        identity.setCycle(true);
                    }
                    identity.setCache(cache);
                    column.setColumnIdentity(identity);
                }
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initIndexPartitions(Connection sqlConnection, IndexProxyDB2 index) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT i.PARTITION, t.LIMITKEY, ");
            buffer.append("i.VCATNAME, i.STORNAME, i.PQTY, i.SQTY, ");
            buffer.append("i.FREEPAGE, i.PCTFREE, i.GBPCACHE, t.TRACKMOD ");
            buffer.append("from SYSIBM.SYSINDEXPART i, SYSIBM.SYSTABLEPART t ");
            buffer.append("WHERE i.IXNAME = '");
            buffer.append(index.getName()).append("'");
            buffer.append(" AND i.IXNAME = t.IXNAME ");
            buffer.append(" AND i.IXCREATOR = t.IXCREATOR ");
            buffer.append(" AND i.PARTITION = t.PARTITION ");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initIndexPartitions():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                int partNumber = rs.getInt(1);
                String cons = rs.getString(2);
                String vcatName = rs.getString(3);
                String sgName = rs.getString(4).trim();
                int pqty = rs.getInt(5) * 4;
                int sqty = rs.getInt(6) * 4;
                int freepage = rs.getInt(7);
                int pctfree = rs.getInt(8);
                String gbcache = rs.getString(9);
                String track = rs.getString(10);
                if (partNumber <= 0) continue;
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 storage = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    StorageTemplateDB2 realst;
                    storage = (AbstractStorageDesignDB2)storageDesign;
                    index.setClusterType("CLUSTERED_PARTITIONED");
                    IndexPartitionDB2 part = storage.getIndexPartitionSet().createIndexPartition();
                    part.setIndex(index);
                    part.setPartNumber(partNumber);
                    part.setPartConstants(cons);
                    StorageTemplateDB2 st = storage.getStorageTemplateSet().createStorageTemplate();
                    part.setStorageTemplate(st);
                    if (!"".equalsIgnoreCase(sgName)) {
                        StorageGroupDB2 sg = (StorageGroupDB2)storage.getStorageGroupSet().getByName(sgName);
                        if (sg != null) {
                            st.setStorageGroup(sg);
                        }
                    } else {
                        VCatDB2 vcat = (VCatDB2)storage.getVCatSet().getByName(vcatName);
                        if (vcat != null) {
                            st.setVCat(vcat);
                        }
                    }
                    st.setSgPriqty(pqty);
                    st.setSgSeqty(sqty);
                    st.setFreePage(freepage);
                    st.setPctFree(pctfree);
                    if ("A".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("ALL");
                    } else if ("N".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("NONE");
                    } else if ("S".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("SYSTEM");
                    } else if ("".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("CHANGED");
                    }
                    if ("N".equalsIgnoreCase(track)) {
                        st.setTrackMode(false);
                    } else {
                        st.setTrackMode(true);
                    }
                    if ((realst = storage.getStorageTemplateSet().removeIfExistEqual(st)) == part.getStorageTemplate()) continue;
                    part.setStorageTemplate(realst);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initColumnConstraints(Connection sqlConnection, Table table, String ownerName) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select c.checkname, c.checkcondition, p.colname ");
            buffer.append("from sysibm.syschecks c, sysibm.syscheckdep p ");
            buffer.append("where ");
            buffer.append("c.tbowner = '");
            buffer.append(ownerName).append("' and ");
            buffer.append("c.tbname = '");
            buffer.append(table.getName()).append("' and ");
            buffer.append("p.tbowner = c.tbowner and ");
            buffer.append("p.checkname = c.checkname and ");
            buffer.append("p.tbname = c.tbname and ");
            buffer.append("1=( ");
            buffer.append("select count(*) ");
            buffer.append("from sysibm.syscheckdep d ");
            buffer.append("where ");
            buffer.append("d.tbowner = c.tbowner and ");
            buffer.append("d.checkname = c.checkname and ");
            buffer.append("d.tbname = c.tbname )");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initColumnConstraints():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String constrName = rs.getString(1);
                String condition = rs.getString(2);
                String colName = rs.getString(3);
                CheckConstraint constraint = new CheckConstraint();
                constraint.setName(constrName);
                constraint.add(StorageDesignDB2v70.RDBMS_TYPE, condition);
                Column col = (Column)table.getElementByName(colName);
                if (col == null) continue;
                col.setUseDomainConstraints(false);
                col.setCheck(constraint);
                col.setConstraintName(constrName);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initTableConstraints(Connection sqlConnection, Table table, String ownerName) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select c.checkname, c.checkcondition ");
            buffer.append("from sysibm.syschecks c ");
            buffer.append("where ");
            buffer.append("c.tbowner = '");
            buffer.append(ownerName).append("' and ");
            buffer.append("c.tbname = '");
            buffer.append(table.getName()).append("' and ");
            buffer.append("1<( ");
            buffer.append("select count(*) ");
            buffer.append("from sysibm.syscheckdep d ");
            buffer.append("where ");
            buffer.append("d.tbowner = c.tbowner and ");
            buffer.append("d.checkname = c.checkname and ");
            buffer.append("d.tbname = c.tbname )");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initColumnConstraints():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String constrName = rs.getString(1);
                String condition = rs.getString(2);
                TableLevelConstraint constraint = table.createCheckConstraint(constrName, condition);
                table.addCheckConstraint(constraint);
                this.stampModelObject((ModelObject)constraint, ownerName, constrName);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initSynonyms(Connection sqlConnection, TableProxyDB2 table, String townerName) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT NAME, CREATOR ");
            buffer.append("from SYSIBM.SYSSYNONYMS ");
            buffer.append("WHERE TBNAME = '");
            buffer.append(table.getName()).append("'");
            buffer.append(" AND TBCREATOR = '");
            buffer.append(townerName).append("'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initSynonyms():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String ownerName = rs.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 storage = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storage = (AbstractStorageDesignDB2)storageDesign;
                    SynonymDB2 synonym = storage.getSynonymSet().createSynonym();
                    synonym.setName(name);
                    synonym.setTable(table);
                    this.stampModelObject((ModelObject)synonym, ownerName, name);
                    Owner owner = (Owner)storage.getOwnerSet().getByName(ownerName);
                    if (owner == null) {
                        owner = (Owner)storage.getOwnerSet().createElement(ownerName);
                        owner.setName(ownerName);
                        this.stampModelObject((ModelObject)owner, "", ownerName);
                    }
                    if (owner == null) continue;
                    synonym.setOwner(owner);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initTriggers(Connection sqlConnection, TableProxyDB2 table, String townerName) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT NAME, SCHEMA, TRIGTIME, TRIGEVENT, GRANULARITY, REMARKS ");
            buffer.append("from SYSIBM.SYSTRIGGERS ");
            buffer.append("WHERE TBNAME = '");
            buffer.append(table.getName()).append("'");
            buffer.append(" AND TBOWNER = '");
            buffer.append(townerName).append("'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initTriggers():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String ownerName = rs.getString(2);
                String trTime = rs.getString(3);
                String action = rs.getString(4);
                String scope = rs.getString(5);
                String remarks = rs.getString(6);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 storage = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storage = (AbstractStorageDesignDB2)storageDesign;
                    TriggerDB2 trigger = storage.getTriggerSet().createTrigger();
                    trigger.setName(name);
                    trigger.setTable(table);
                    this.stampModelObject((ModelObject)trigger, ownerName, name);
                    Owner owner = (Owner)storage.getOwnerSet().getByName(ownerName);
                    if (owner != null) {
                        trigger.setOwner(owner);
                    } else {
                        owner = (Owner)storage.getOwnerSet().createElement(ownerName);
                        owner.setName(ownerName);
                        trigger.setOwner(owner);
                        this.stampModelObject((ModelObject)owner, "", ownerName);
                    }
                    if ("A".equalsIgnoreCase(trTime)) {
                        trigger.setTriggerTime("AFTER");
                    } else {
                        trigger.setTriggerTime("NO CASCADE BEFORE");
                    }
                    if ("I".equalsIgnoreCase(action)) {
                        trigger.setActions("INSERT");
                    } else if ("D".equalsIgnoreCase(action)) {
                        trigger.setActions("DELETE");
                    } else {
                        trigger.setActions("UPDATE");
                    }
                    if ("R".equalsIgnoreCase(scope)) {
                        trigger.setScope("FOR EACH ROW");
                    } else {
                        trigger.setScope("FOR EACH STATEMENT");
                    }
                    trigger.setCommentInRDBMS(remarks);
                    this.initTriggerBody(sqlConnection, trigger);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initTriggerBody(Connection sqlConnection, TriggerDB2 trigger) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT TEXT ");
            buffer.append("FROM SYSIBM.SYSTRIGGERS ");
            buffer.append("WHERE SCHEMA = '");
            buffer.append(trigger.getOwner().getName()).append("'");
            buffer.append("AND NAME = '");
            buffer.append(trigger.getName()).append("'");
            buffer.append(" ORDER BY SEQNO ");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2.initTriggerBody():", e);
        }
        StringBuffer body = new StringBuffer();
        if (rs != null) {
            while (rs.next()) {
                String text = rs.getString(1);
                body.append(text);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        trigger.setBody(body.toString());
    }
}

