/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHAlterTableOraclev10g;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class MOHForeignKey
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "FOREIGN KEY";

    public MOHForeignKey(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected ResultSet getImportedKeys(DatabaseMetaData dbmd, Table table) throws Exception {
        return dbmd.getImportedKeys(null, table.getProperty("schema"), table.getName());
    }

    private FKHelper getFKHelperFor(Table pkTable, List<FKHelper> list, String fkName) {
        for (FKHelper next : list) {
            if (next.pkTable != pkTable) continue;
            if (fkName != null && !"".equals(fkName)) {
                if (!fkName.equalsIgnoreCase(next.fk_NAME)) continue;
                return next;
            }
            return next;
        }
        FKHelper fkHelper = new FKHelper();
        fkHelper.pkTable = pkTable;
        list.add(fkHelper);
        return fkHelper;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        DatabaseMetaData dbmd = sqlConnection.getMetaData();
        Object[] tables = this.getDesign().getRelationalDesign().getTableSet().toArray();
        for (int i = 0; i < tables.length; ++i) {
            Table table = (Table)tables[i];
            ResultSet rs = this.getImportedKeys(dbmd, table);
            ArrayList<FKHelper> fkHelpers = new ArrayList<FKHelper>();
            if (rs == null) continue;
            while (rs.next()) {
                String pkTABLE_NAME = rs.getString(3);
                String pkCOLUMN_NAME = rs.getString(4);
                String fkCOLUMN_NAME = rs.getString(8);
                String fkDELETE_RULE = rs.getString(11);
                String fk_NAME = rs.getString(12);
                String pk_NAME = rs.getString(13);
                String pkTableName = pkTABLE_NAME;
                Table pkTable = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(pkTableName);
                if (pkTable == null) continue;
                FKHelper fkHelper = this.getFKHelperFor(pkTable, fkHelpers, fk_NAME);
                fkHelper.fk_NAME = fk_NAME;
                fkHelper.pk_NAME = pk_NAME;
                fkHelper.fkDELETE_RULE = fkDELETE_RULE;
                if (fkCOLUMN_NAME != null) {
                    fkHelper.fkColNames.add(fkCOLUMN_NAME);
                    fkHelper.pkColNames.add(pkCOLUMN_NAME);
                    continue;
                }
                System.out.println("Unable to find FK column!");
            }
            rs.close();
            for (FKHelper next : fkHelpers) {
                Table pkTable = next.pkTable;
                if (pkTable == null) continue;
                Index index = null;
                index = next.pk_NAME == null ? SHAlterTableOraclev10g.getUniqueIndexForColumnNames(pkTable, next.pkColNames) : pkTable.getIndexByName(next.pk_NAME);
                FKIndexAssociation fkass = null;
                Column column = null;
                if (index != null) {
                    for (int f = 0; f < next.fkColNames.size(); ++f) {
                        String fkName;
                        String fkColumnName;
                        Column fkColumn;
                        String pkColumnName = (String)next.pkColNames.get(f);
                        if (pkColumnName != null && (column = (Column)pkTable.getElementByName(pkColumnName)) == null) {
                            column = pkTable.createColumn();
                            column.setName(pkColumnName);
                            this.stampModelObject((ModelObject)column, pkTable.getName(), pkColumnName);
                            index.add(column);
                        }
                        if ((fkColumn = (Column)table.getElementByName(fkColumnName = (String)next.fkColNames.get(f))) == null) {
                            fkColumn = table.createColumn();
                            fkColumn.setName(fkColumnName);
                            this.stampModelObject((ModelObject)column, table.getName(), fkColumnName);
                        }
                        if ((fkName = next.fk_NAME) != null) {
                            FKIndexAssociation[] fkis = table.getFKAssociations();
                            for (int j = 0; j < fkis.length; ++j) {
                                FKIndexAssociation fkia = fkis[j];
                                if (!fkia.getName().equalsIgnoreCase(fkName)) continue;
                                fkass = fkia;
                                break;
                            }
                        }
                        if (fkass == null) {
                            int deleteRule;
                            fkass = table.addFK(index);
                            if (fkName != null) {
                                fkass.setName(fkName);
                                fkass.getLocalFKIndex().setName(fkName);
                                this.stampModelObject((ModelObject)fkass, table.getSchema(), fkName);
                            }
                            try {
                                deleteRule = Integer.valueOf(next.fkDELETE_RULE);
                            }
                            catch (Exception e) {
                                deleteRule = 3;
                            }
                            switch (deleteRule) {
                                case 3: {
                                    fkass.setDeleteRule("NO ACTION");
                                    break;
                                }
                                case 0: {
                                    fkass.setDeleteRule("CASCADE");
                                    break;
                                }
                                case 2: {
                                    fkass.setDeleteRule("SET NULL");
                                    break;
                                }
                                case 1: {
                                    fkass.setDeleteRule("RESTRICT");
                                }
                            }
                        }
                        fkColumn.addFKAssociation(column, fkass);
                        fkass.getLocalFKIndex().add(fkColumn);
                    }
                }
                if (fkass == null) continue;
                fkass.resetMandatoryUsingColumns();
                fkass.resetEdgeParams();
            }
        }
    }

    private static class FKHelper {
        public List pkColNames = new ArrayList();
        public List fkColNames = new ArrayList();
        public String fkDELETE_RULE = "";
        public String fk_NAME = null;
        public String pk_NAME = null;
        public Table pkTable = null;

        private FKHelper() {
        }
    }
}

