/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateXMLCollectionSqlServerv2k5
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateXMLCollectionSqlServerv2k5.class);
    private RDBMSSite site;
    private StorageDesignSqlServerv2k5 stoDesign;
    private String schemaName = "";
    private String line = "";

    public SHCreateXMLCollectionSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        this.line = line;
        String statement = SHCreateXMLCollectionSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create xml schema collection")) {
            try {
                this.parseXmlCollection(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateXMLCollectionSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseXmlCollection(String statement) {
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
        this.schemaName = "";
        String name = this.initName();
        XMLSchemaCollectionSqlServerv2k5 xmlCollection = (XMLSchemaCollectionSqlServerv2k5)this.stoDesign.getXmlSchemaCollectionSet().createType();
        if (xmlCollection != null) {
            SchemaSqlServerv2k5 schema;
            xmlCollection.setName(name);
            xmlCollection.setDatabase(this.getCurrentDB());
            this.design.getRelationalDesign().stampModelObjectDDL(xmlCollection);
            if (!this.schemaName.equals("") && (schema = (SchemaSqlServerv2k5)xmlCollection.getDatabase().getSchemas().getByName(this.schemaName)) != null) {
                xmlCollection.setSchema(schema);
            }
            String expression = Token.getStringAfterToken(this.line, "AS");
            xmlCollection.setSchemaDefinition(SHCreateXMLCollectionSqlServerv2k5.FormatCR(expression, "\n"));
        }
    }

    private String initName() {
        String temp = Token.getTokenAfter(this.statement, "COLLECTION").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "COLLECTION", '[', ']').trim() : Token.getNameAfterToken(this.statement, "COLLECTION", '\"', '\"').trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.schemaName = Token.getValBeforeCharacter(name, '.');
            name = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "COLLECTION"), '.');
        }
        return name;
    }
}

