/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports;

import oracle.dbtools.crest.imports.metadata.DBMEncodedString;
import oracle.dbtools.thirdparty.db2.DMDB2ConnectionPanel;
import oracle.dbtools.thirdparty.udb.DMUDBConnectionPanel;

public class DBConnectionStamp {
    public static final int NOT_SELECTED_FOR_SYNCHRONIZE = 0;
    public static final int SELECTED_FOR_SYNCHRONIZE = 1;
    public static final int REDIRECT_CONNECTION = -1;
    private String connName = "";
    private String connUrl = "";
    private String connUser = "";
    private DBMEncodedString connPass = null;
    private int connType = -1;
    private int syncSelected = 0;

    public DBConnectionStamp() {
        this.connPass = null;
    }

    public DBConnectionStamp(String connName, String connUrl, String connUser, String connPass, int connType) {
        this.connName = connName;
        this.connUrl = connUrl;
        this.connUser = connUser;
        this.connPass = new DBMEncodedString("");
        this.connPass.encode(connPass);
        this.connType = connType;
    }

    public DBConnectionStamp(String connName, String connUrl, String connUser, int connType) {
        this.connName = connName;
        this.connUrl = connUrl;
        this.connUser = connUser;
        this.connPass = null;
        this.connType = connType;
    }

    public String toString() {
        return this.getConnName();
    }

    public String getConnName() {
        return this.connName;
    }

    public void setConnName(String connName) {
        this.connName = connName;
    }

    public String getConnUrl() {
        return this.connUrl;
    }

    public void setConnUrl(String connUrl) {
        this.connUrl = connUrl;
    }

    public String getConnUser() {
        return this.connUser;
    }

    public void setConnUser(String connUser) {
        this.connUser = connUser;
    }

    public String getConnPass() {
        if (this.connPass == null) {
            return null;
        }
        return this.connPass.decode();
    }

    public void setConnPass(String connPass) {
        if (connPass == null) {
            this.connPass = null;
        } else {
            this.connPass = new DBMEncodedString("");
            this.connPass.encode(connPass);
        }
    }

    public int getConnType() {
        return this.connType;
    }

    public void setConnType(int connType) {
        this.connType = connType;
    }

    public String getConnTypeDisplay() {
        if (this.connType == 1) {
            return "Oracle";
        }
        if (this.connType == 2) {
            return "Microsoft SQL Server";
        }
        if (this.connType == 3) {
            return DMDB2ConnectionPanel.CONNECTION_TYPE;
        }
        if (this.connType == 4) {
            return DMUDBConnectionPanel.CONNECTION_TYPE;
        }
        return "";
    }

    public int getSyncSelected() {
        return this.syncSelected;
    }

    public void setSyncSelected(int syncSelected) {
        this.syncSelected = syncSelected;
    }

    public DBConnectionStamp getCopy() {
        DBConnectionStamp copy = new DBConnectionStamp();
        copy.setConnName(this.getConnName());
        copy.setConnUrl(this.getConnUrl());
        copy.setConnUser(this.getConnUser());
        copy.setConnPass(this.getConnPass());
        copy.setConnType(this.getConnType());
        copy.setSyncSelected(this.getSyncSelected());
        return copy;
    }

    public boolean isSameAs(DBConnectionStamp stamp) {
        return stamp != null && stamp.getConnName().equalsIgnoreCase(this.getConnName()) && stamp.getConnUrl().equalsIgnoreCase(this.getConnUrl()) && stamp.getConnUser().equalsIgnoreCase(this.getConnUser()) && stamp.getConnType() == this.getConnType() && stamp.getSyncSelected() == this.getSyncSelected();
    }

    public boolean isSimilarAs(DBConnectionStamp stamp) {
        return stamp != null && stamp.getConnName().equalsIgnoreCase(this.getConnName()) && stamp.getConnUrl().equalsIgnoreCase(this.getConnUrl()) && stamp.getConnUser().equalsIgnoreCase(this.getConnUser()) && stamp.getConnType() == this.getConnType();
    }
}

