/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.BrowserDockable;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.log.LogManager;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryCommand;

public class SVNVersionHistoryCommand
extends VersionHistoryCommand {
    public static String HISTORY_COMMAND_ID = "oracle.jdeveloper.subversion.oracle.jdeveloper.vcs.action.HISTORY";
    public static final String COMMAND_ID = Extension.isDataModeler() ? HISTORY_COMMAND_ID : SVNVersionHistoryCommand.class.getName();
    public static final int HISTORY_CMD_ID = Ide.findOrCreateCmdID((String)COMMAND_ID);
    private static IdeAction ACTION = DataModelerAddin.overrideAction(COMMAND_ID, SVNVersionHistoryCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();
    protected JCheckBox chbSkipMessage = new JCheckBox(Messages.getString("SVNVersionTreeCommand.SkipMessage"));

    public SVNVersionHistoryCommand() {
        super(HISTORY_CMD_ID);
    }

    public static IdeAction getAction() {
        if (ACTION == null) {
            ACTION = DataModelerAddin.overrideAction(COMMAND_ID, SVNVersionHistoryCommand.class.getName());
        }
        return ACTION;
    }

    public boolean isAvailable() {
        if (this.context != null) {
            return this.getSelectedStorableObjectStatus() != null && SVN_CLIENT_HELPER.actionsEnabled(null, this.context, true, true, true, false, false, true, true, true);
        }
        return false;
    }

    protected int doitImpl() throws Exception {
        DisplayableLocatableNode[] selection = VCSClientHelper.getSelection(this.getContext().getView());
        if (selection != null && selection.length > 0) {
            URL url = selection[0].getURL();
            String versionPath = this.getVersionPath(url);
            File selectedFile = null;
            selectedFile = versionPath.startsWith("file://") && versionPath.charAt(7) != '/' ? new File(versionPath.substring(7)) : (versionPath.startsWith("file:/") && versionPath.charAt(6) != '/' ? new File(versionPath.substring(5)) : new File(versionPath));
            if (SVNClientHelper.getInstance().isVersioned(selectedFile)) {
                this.showSVNHistoryWindow();
                return 0;
            }
            String message = MessageFormat.format(Messages.getString("SVNVersionTreeCommand.NotWorkingCopy"), new File(selection[0].getURL().getFile()).getAbsolutePath());
            Object[] params = new Object[]{message, this.chbSkipMessage};
            if (!this.chbSkipMessage.isSelected()) {
                JOptionPane.showConfirmDialog(null, params, Messages.getString("SVNVersionTreeCommand.Error"), -1, 1);
            }
            return 1;
        }
        return 1;
    }

    protected String getVersionPath(URL url) {
        return url == null ? "" : url.toExternalForm();
    }

    protected void showSVNHistoryWindow() {
        DockStation dockStation = DockStation.getDockStation();
        SVNHistoryWindow svnHistoryWindow = (SVNHistoryWindow)dockStation.getDockable(SVNHistoryWindow.VIEW_ID);
        if (svnHistoryWindow == null) {
            svnHistoryWindow = SVNHistoryWindow.getInstance();
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition((Dockable)LogManager.getIdeLogWindow(), 4);
            dockStation.dock((Dockable)svnHistoryWindow, dockingParam);
        }
        this.init(svnHistoryWindow);
        svnHistoryWindow.show();
        dockStation.activateDockable((Dockable)svnHistoryWindow);
    }

    protected void init(SVNHistoryWindow svnHistoryWindow) {
        svnHistoryWindow.setStorableObjectStatus(this.getSelectedStorableObjectStatus());
    }

    private StorableObjectStatus getSelectedStorableObjectStatus() {
        StorableObjectStatus storableObjectStatus = null;
        View contextView = this.context.getView();
        if (contextView instanceof SVNChangeListWindow) {
            DataModelerChangeList dataModelerChangeList = (DataModelerChangeList)((SVNChangeListWindow)contextView).getContextChangeList();
            VersioningTreeNode selectedNode = dataModelerChangeList.getPanel().getSelectedNode();
            storableObjectStatus = selectedNode == null ? null : selectedNode.getStorableObjectStatus();
        } else if (contextView instanceof BrowserDockable) {
            StorableObject storableObject = (StorableObject)((BrowserPanel)((BrowserDockable)contextView).getBrowser()).getJTree().getLastSelectedPathComponent();
            storableObjectStatus = new SVNStorableObjectStatus(storableObject);
        } else if (contextView instanceof DMDiagramEditor) {
            Object[] selectedObjects = ((DMDiagramEditor)contextView).getDesignPartView().getSelectedObjects();
            if (selectedObjects != null && selectedObjects.length > 0) {
                if (selectedObjects.length == 1) {
                    StorableObject storableObject = (StorableObject)selectedObjects[0];
                    storableObjectStatus = new SVNStorableObjectStatus(storableObject);
                }
            } else {
                DesignPartView designPartView = ((DMDiagramEditor)contextView).getDesignPartView();
                if (!designPartView.isMasterDPV()) {
                    designPartView = designPartView.getMasterDPV();
                }
                storableObjectStatus = new SVNStorableObjectStatus(designPartView);
            }
        }
        return storableObjectStatus;
    }
}

