/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.io.File;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class SVNStorableObjectStatus
extends StorableObjectStatus {
    private ISVNStatus isvnStatus;
    private Long revision;
    private SVNStatus svnStatus;

    public SVNStorableObjectStatus(StorableObject storableObject) {
        super(storableObject);
    }

    public SVNStorableObjectStatus(Design design, File file, String textStatus, String propertyStatus, Long revision) {
        this.design = design;
        this.filePath = file;
        this.textStatus = textStatus;
        this.propertyStatus = propertyStatus;
        this.revision = revision;
        this.parse(file, null, null);
    }

    public SVNStorableObjectStatus(Design design, ISVNStatus svnStatus, boolean remoteStatus, boolean deletedDir) {
        this.design = design;
        this.isvnStatus = svnStatus;
        this.remoteStatus = remoteStatus;
        this.filePath = svnStatus.getFile();
        this.locked = svnStatus.getLockOwner() != null;
        this.textStatus = svnStatus.getTextStatus().toString();
        this.extractStatuses(svnStatus, remoteStatus, deletedDir);
        this.parse(this.filePath, (SVNUrl)(!remoteStatus && "A".equals(this.textStatus) ? null : svnStatus.getUrl()), null);
    }

    public SVNStorableObjectStatus(Design design, SVNStatus svnStatus, boolean remoteStatus, boolean deletedDir) {
        this.design = design;
        this.svnStatus = svnStatus;
        this.remoteStatus = remoteStatus;
        this.filePath = svnStatus.getFile();
        this.locked = svnStatus.getLocalLock() != null;
        this.extractStatusesSVN(svnStatus, remoteStatus, deletedDir);
        SVNURL surl = null;
        if (remoteStatus || !remoteStatus && svnStatus.getFile().exists()) {
            surl = svnStatus.getRemoteURL();
        }
        SVNUrl url = null;
        if (surl != null) {
            url = SVNUtil.toSVNUrl((SVNURL)surl);
        }
        this.parse(this.filePath, (SVNUrl)(!remoteStatus && "A".equals(this.textStatus) ? null : url), svnStatus);
    }

    protected void extractStatuses(ISVNStatus svnStatus, boolean remoteStatus, boolean deletedDir) {
        SVNStatusKind propStatusKind;
        SVNStatusKind textStatusKind;
        if (remoteStatus) {
            textStatusKind = svnStatus.getRepositoryTextStatus();
            propStatusKind = svnStatus.getRepositoryPropStatus();
            if (deletedDir && svnStatus.getRevision() != null) {
                this.textStatus = "D";
                return;
            }
        } else {
            textStatusKind = svnStatus.getTextStatus();
            propStatusKind = svnStatus.getPropStatus();
        }
        this.textStatus = this.extractStatus(svnStatus, textStatusKind, svnStatus.getRevision(), remoteStatus);
        this.propertyStatus = this.extractStatus(svnStatus, propStatusKind, svnStatus.getRevision(), remoteStatus);
    }

    protected String extractStatus(SVNStatusKind statusKind) {
        if (statusKind == SVNStatusKind.UNVERSIONED) {
            return "?";
        }
        if (statusKind == SVNStatusKind.MISSING) {
            return "MI";
        }
        if (statusKind == SVNStatusKind.ADDED) {
            return "A";
        }
        if (statusKind == SVNStatusKind.MODIFIED) {
            return "M";
        }
        if (statusKind == SVNStatusKind.DELETED) {
            return "D";
        }
        if (statusKind == SVNStatusKind.CONFLICTED) {
            return "C";
        }
        if (statusKind == SVNStatusKind.NORMAL) {
            return "";
        }
        return "?";
    }

    protected void extractStatusesSVN(SVNStatus svnStatus, boolean remoteStatus, boolean deletedDir) {
        if (remoteStatus && deletedDir && svnStatus.getRevision() != null) {
            this.textStatus = "D";
            return;
        }
        this.textStatus = this.getContentStatus(svnStatus, remoteStatus);
        this.propertyStatus = this.getPropStatus(svnStatus, remoteStatus);
    }

    private String getPropStatus(SVNStatus status, boolean remoteStatus) {
        SVNStatusType propertiesStatus = status.getPropertiesStatus();
        if (remoteStatus) {
            propertiesStatus = status.getRemotePropertiesStatus();
        }
        String propertiesChangeType = " ";
        if (propertiesStatus == SVNStatusType.STATUS_MODIFIED) {
            propertiesChangeType = "M";
        } else if (propertiesStatus == SVNStatusType.STATUS_CONFLICTED) {
            propertiesChangeType = "C";
        } else if (propertiesStatus == SVNStatusType.STATUS_DELETED) {
            propertiesChangeType = "D";
        } else if (propertiesStatus == SVNStatusType.STATUS_ADDED) {
            propertiesChangeType = "A";
        }
        return propertiesChangeType;
    }

    private String getContentStatus(SVNStatus status, boolean remoteStatus) {
        SVNStatusType contentsStatus = status.getNodeStatus();
        if (remoteStatus) {
            contentsStatus = status.getRemoteNodeStatus();
        }
        String pathChangeType = " ";
        if (contentsStatus == SVNStatusType.STATUS_MODIFIED) {
            pathChangeType = "M";
        } else if (contentsStatus == SVNStatusType.STATUS_CONFLICTED) {
            pathChangeType = "C";
        } else if (contentsStatus == SVNStatusType.STATUS_DELETED) {
            pathChangeType = "D";
        } else if (contentsStatus == SVNStatusType.STATUS_ADDED) {
            pathChangeType = "A";
        } else if (contentsStatus == SVNStatusType.STATUS_UNVERSIONED) {
            pathChangeType = "?";
        } else if (contentsStatus == SVNStatusType.STATUS_EXTERNAL) {
            pathChangeType = "X";
        } else if (contentsStatus == SVNStatusType.STATUS_IGNORED) {
            pathChangeType = "I";
        } else if (contentsStatus == SVNStatusType.STATUS_MISSING || contentsStatus == SVNStatusType.STATUS_INCOMPLETE) {
            pathChangeType = "!";
        } else if (contentsStatus == SVNStatusType.STATUS_OBSTRUCTED) {
            pathChangeType = "~";
        } else if (contentsStatus == SVNStatusType.STATUS_REPLACED) {
            pathChangeType = "R";
        } else if (contentsStatus == SVNStatusType.STATUS_NONE || contentsStatus == SVNStatusType.STATUS_NORMAL) {
            pathChangeType = " ";
        }
        SVNTreeConflictDescription trc = status.getTreeConflict();
        if (trc != null) {
            pathChangeType = "C";
        }
        return pathChangeType;
    }

    protected String extractStatus(ISVNStatus svnStatus, SVNStatusKind statusKind, SVNRevision.Number revNumber, boolean remote) {
        if (remote) {
            if (statusKind == SVNStatusKind.NONE && revNumber != null && revNumber.getNumber() > 0L) {
                return "D";
            }
            String s = this.extractStatus(statusKind);
            if (s.compareTo("") == 0) {
                s = "D";
            }
            return s;
        }
        if (statusKind == SVNStatusKind.MODIFIED && revNumber == null) {
            return "A";
        }
        if (statusKind == SVNStatusKind.NORMAL && svnStatus.getUrlCopiedFrom() != null && !"".equals(svnStatus.getUrlCopiedFrom())) {
            return "A";
        }
        if (statusKind == SVNStatusKind.NORMAL && svnStatus.getPropStatus() == SVNStatusKind.MODIFIED) {
            return "";
        }
        String s = this.extractStatus(statusKind);
        if (s.compareTo("") == 0) {
            s = "D";
        }
        return s;
    }

    @Override
    public Long getRevision() {
        if (this.revision != null) {
            return this.revision;
        }
        if (this.svnStatus != null) {
            SVNRevision und = SVNRevision.UNDEFINED;
            SVNRevision rev = this.svnStatus.getRemoteRevision();
            if (und.equals((Object)rev)) {
                rev = this.svnStatus.getRevision();
            }
            return rev != null ? Long.valueOf(rev.getNumber()) : null;
        }
        if (this.isvnStatus != null) {
            SVNRevision.Number svnStatusRevision = this.isvnStatus.getRevision();
            return svnStatusRevision != null ? Long.valueOf(svnStatusRevision.getNumber()) : null;
        }
        return null;
    }

    public ISVNStatus getISVNStatus() {
        return this.isvnStatus;
    }

    public SVNStatus getSVNStatus() {
        return this.svnStatus;
    }
}

