/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChooseActionDialog;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareDialog;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.metadata.XMLFromMapTransformer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.compare.CompareOptions;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class MergeConflictsDialog
extends ChooseActionDialog {
    private static final String ACTION_EDIT_CONFLICT = Messages.getString("MergeConflictsDialog.ActionEditConflict");
    private static final String ACTION_EDIT_CONFLICT_AS_TEXT = Messages.getString("MergeConflictsDialog.ActionEditConflictAsText");
    private static final String ACTION_RESOLVE_LATER = Messages.getString("MergeConflictsDialog.ActionResolveLater");
    private static final String ACTION_USE_LOCAL_VERSION = Messages.getString("MergeConflictsDialog.ActionUseLocalVersion");
    private static final String ACTION_USE_REMOTE_VERSION = Messages.getString("MergeConflictsDialog.ActionUseRemoteVersion");
    private static final String[] ACTIONS = new String[]{ACTION_EDIT_CONFLICT, ACTION_EDIT_CONFLICT_AS_TEXT, ACTION_RESOLVE_LATER, ACTION_USE_LOCAL_VERSION, ACTION_USE_REMOTE_VERSION};
    protected static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();
    private static final MergeConflictsDialog INSTANCE = new MergeConflictsDialog();
    private static final Logger LOGGER = new Logger(MergeConflictsDialog.class);
    private Map<MergeConflict, String> conflictActions = new HashMap<MergeConflict, String>();
    private List<MergeConflict> mergeConflicts;
    List<VersioningTreeNode> nodesForRefreshing = new ArrayList<VersioningTreeNode>();

    public static MergeConflictsDialog getInstance() {
        return INSTANCE;
    }

    @Override
    protected String getTitle() {
        return Messages.getString("MergeConflictsDialog.MergeConflicts");
    }

    public void checkForConflicts(Design design) {
        int option;
        if (!design.getDesignLevelSettings().getMergeConflicts().isEmpty() && (option = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("MergeConflictsDialog.ConflictFoundMessage"), Messages.getString("MergeConflictsDialog.ConflictFoundTitle"), 0, 2)) == 0) {
            this.processConflicts(design, null, null, false);
        }
    }

    @Override
    protected String[] getActions() {
        return ACTIONS;
    }

    @Override
    protected ActionListener getActionsActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object action = MergeConflictsDialog.this.actionsComboBox.getSelectedItem();
                    if (ACTION_EDIT_CONFLICT.equals(action) || ACTION_EDIT_CONFLICT_AS_TEXT.equals(action)) {
                        final MergeConflict mergeConflict = (MergeConflict)MergeConflictsDialog.this.mergeConflicts.get(MergeConflictsDialog.this.tbActions.getSelectedRow());
                        File localFile = mergeConflict.getLocalFile();
                        Design design = ApplicationView.getInstance().getCurrentDesign();
                        String leftFileRevision = mergeConflict.getRepositoryLabel();
                        FileInputStream leftFile = new FileInputStream(new File(localFile + leftFileRevision));
                        String rightFileRevision = Messages.getString("VCSHistoryWindow.LocalSaved");
                        FileInputStream rightFile = new FileInputStream(localFile);
                        File workingFile = new File(localFile + mergeConflict.getLocalLabel());
                        if (workingFile.exists()) {
                            rightFile = new FileInputStream(workingFile);
                        }
                        if (ACTION_EDIT_CONFLICT.equals(action)) {
                            XMLMetadataComparator comparator = new XMLMetadataComparator(design, null, leftFile, leftFileRevision, rightFile, rightFileRevision, true);
                            Map mergedMap = comparator.showModal();
                            if (mergedMap != null) {
                                XMLFromMapTransformer.transformMapToXMLFile(mergedMap, localFile.getPath(), design.isCompressedDesign());
                                MergeConflictsDialog.this.resolveConflict(mergeConflict);
                            }
                        } else {
                            CompareOptions.getInstance((PropertyStorage)Preferences.getPreferences()).setShowCharDifferences(true);
                            VCSTextCompareDialog textCompareDialog = new VCSTextCompareDialog((Window)Ide.getMainWindow(), localFile, leftFile, leftFileRevision, rightFile, rightFileRevision, true, false){

                                @Override
                                public void afterSave() {
                                    super.afterSave();
                                    MergeConflictsDialog.this.resolveConflict(mergeConflict);
                                }
                            };
                            textCompareDialog.setVisible(true);
                        }
                    }
                }
                catch (FileNotFoundException ex) {
                    LOGGER.error(ex);
                }
            }
        };
    }

    public List<MergeConflict> processConflicts() {
        return this.processConflicts(ApplicationView.getInstance().getCurrentDesign(), null, null, true);
    }

    public List<MergeConflict> processConflicts(Design design, List<MergeConflict> newMergeConflicts, List<VersioningTreeNode> nodesForRefreshing, boolean showEmptyDialog) {
        List<MergeConflict> allMergeConflicts = design.getDesignLevelSettings().getMergeConflicts();
        ArrayList<VersioningTreeNode> reallyMerged = new ArrayList<VersioningTreeNode>();
        reallyMerged.addAll(SVN_CLIENT_HELPER.getLastMergedObjects());
        if (newMergeConflicts != null) {
            block0: for (MergeConflict mergeConflict : newMergeConflicts) {
                File localFile = mergeConflict.getLocalFile();
                if (allMergeConflicts.contains(mergeConflict)) continue;
                allMergeConflicts.add(mergeConflict);
                for (VersioningTreeNode nodeForRefreshing : nodesForRefreshing) {
                    if (!nodeForRefreshing.getFilePath().equals(localFile)) continue;
                    mergeConflict.setNodeForRefreshing(nodeForRefreshing);
                    continue block0;
                }
            }
        }
        if (!allMergeConflicts.isEmpty() || showEmptyDialog) {
            this.mergeConflicts = allMergeConflicts;
            this.conflictActions.clear();
            this.tbActions.updateUI();
            this.conflictActionsUpdate();
            if (this.showDialog()) {
                for (MergeConflict mergeConflict : this.conflictActions.keySet()) {
                    String action = this.conflictActions.get(mergeConflict);
                    if (ACTION_USE_LOCAL_VERSION.equals(action)) {
                        this.resolveConflict(mergeConflict);
                        continue;
                    }
                    if (ACTION_USE_REMOTE_VERSION.equals(action)) {
                        VCSClientHelper.copyOverConflicted(mergeConflict.getLocalFile(), mergeConflict.getRepositoryLabel());
                        this.resolve(mergeConflict.getLocalFile(), SVNConflictChoice.THEIRS_CONFLICT);
                        continue;
                    }
                    if (!ACTION_RESOLVE_LATER.equals(action)) continue;
                    VCSClientHelper.copyOverConflicted(mergeConflict.getLocalFile(), mergeConflict.getLocalLabel());
                }
                if (nodesForRefreshing != null && nodesForRefreshing.size() > 0) {
                    for (VersioningTreeNode vtn : nodesForRefreshing) {
                        reallyMerged.add(vtn);
                    }
                }
                VersioningTreeNode.refresh(reallyMerged, false, true);
            }
            design.saveDesignLevelMergeConflicts();
        } else {
            VersioningTreeNode.refresh(reallyMerged, false, true);
        }
        return allMergeConflicts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve(File file, SVNConflictChoice resolution) {
        SVNClientManager clientManager = SVNClientManager.newInstance();
        try {
            SVNWCClient wcClient = clientManager.getWCClient();
            wcClient.doResolve(file, SVNDepth.FILES, resolution);
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
        finally {
            clientManager.dispose();
        }
    }

    private void resolveConflict(MergeConflict mergeConflict) {
        File localFile = mergeConflict.getLocalFile();
        VCS_CLIENT_HELPER.doResolved(localFile);
        this.mergeConflicts.remove(mergeConflict);
        this.tbActions.updateUI();
        VersioningTreeNode nodeForRefreshing = mergeConflict.getNodeForRefreshing();
        if (nodeForRefreshing != null) {
            this.nodesForRefreshing.add(nodeForRefreshing);
        }
    }

    @Override
    protected ChooseActionDialog.ActionsTableModel getActionsTableModel() {
        return new ChooseActionDialog.ActionsTableModel(){

            @Override
            public int getRowCount() {
                return MergeConflictsDialog.this.mergeConflicts == null ? 0 : MergeConflictsDialog.this.mergeConflicts.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (column == 0) {
                    return ((MergeConflict)MergeConflictsDialog.this.mergeConflicts.get(row)).getStorableObjectStatus();
                }
                if (column == 1) {
                    String action = (String)MergeConflictsDialog.this.conflictActions.get(MergeConflictsDialog.this.mergeConflicts.get(row));
                    return action == null ? ACTION_RESOLVE_LATER : action;
                }
                return super.getValueAt(row, column);
            }

            @Override
            public void setValueAt(Object action, int row, int column) {
                if (column == 1 && !ACTION_EDIT_CONFLICT.equals(action)) {
                    MergeConflict mergeConflict = (MergeConflict)MergeConflictsDialog.this.mergeConflicts.get(row);
                    MergeConflictsDialog.this.conflictActions.put(mergeConflict, (String)action);
                }
            }
        };
    }

    @Override
    protected String getActionsTableModelFirstColumnName() {
        return Messages.getString("MergeConflictsDialog.ChangedObject");
    }

    @Override
    protected DefaultTableCellRenderer getActionsCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                StorableObjectStatus storableObjectStatus = (StorableObjectStatus)value;
                this.setText(storableObjectStatus.getStorableObjectName());
                this.setIcon(VCSClientHelper.getIcon(storableObjectStatus.getObjectClass()));
                return this;
            }
        };
    }

    protected void conflictActionsUpdate() {
        for (int i = 0; i < this.tbActions.getRowCount(); ++i) {
            MergeConflict mC = this.mergeConflicts.get(i);
            this.conflictActions.put(mC, (String)this.tbActions.getModel().getValueAt(i, 1));
        }
    }
}

