/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerDB2;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerODBC;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerOracle;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerSQLServer;
import oracle.dbtools.crest.fcp.extension.Messages;
import oracle.dbtools.crest.fcp.extension.SubordinateTablesJDBC;
import oracle.dbtools.crest.fcp.extension.SubordinateTablesOracle;
import oracle.dbtools.crest.fcp.extension.SubordinateTablesReader;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.navigator.db.impl.DatabaseObjectTreeNode;
import oracle.dbtools.raptor.navigator.db.xml.AbstractNodeInstance;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.thirdparty.db2.DMDB2ConnectionPanel;
import oracle.dbtools.thirdparty.udb.DMUDBConnectionPanel;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ideimpl.explorer.dnd.MultiTransferable;

public class EXTDropHandler
implements DropTargetListener {
    private static final String DB_TYPE_ORACLE = "ORACLE";
    public static final String DB_TYPE_MS_SQL_SERVER = "MICROSOFT";
    private static final String DB_TYPE_DB2 = "DB2";
    private static final String DB_TYPE_JDBC = "JDBC";
    private static final String PROPERTY_SCHEMA = "SCHEMA";
    private static final String PROPERTY_CATALOG = "CATALOG";
    private static final String PROPERTY_TABLE_CATALOG = "TABLE_CATALOG";
    private static final String PROPERTY_OBJECT_NAME = "OBJECT_NAME";
    private static final String PROPERTY_TABLE_NAME = "TABLE_NAME";
    private static final String PROPERTY_DIRECTORY_NAME = "DIRECTORY_NAME";
    private static final String PROPERTY_SYNONYM_NAME = "SYNONYM_NAME";
    private static final String PROPERTY_NAME = "NAME";
    private static final String PROPERTY_TYPE = "TYPE";
    private static final String PROPERTY_UTYPES = "UTYPES";
    private static final String PROPERTY_TABLE = "TABLE";
    private static final String PROPERTY_VIEW = "VIEW";
    private static final String PROPERTY_MATERIALIZED_VIEW = "MATERIALIZED VIEW";
    private static final String PROPERTY_SYNONYM = "SYNONYM";
    private static final String PROPERTY_PUBLIC_SYNONYM = "PUBLIC_SYNONYM";
    private static final String PROPERTY_SEQUENCE = "SEQUENCE";
    private static final String PROPERTY_DIRECTORY = "DIRECTORY";
    private static final String PROPERTY_PROCEDURE = "PROCEDURE";
    private static final String PROPERTY_PROCEDURES = "PROCEDURES";
    private static final String PROPERTY_ALIASES = "ALIASES";
    private ApplicationView appView;
    private List selectedObjects = new ArrayList();
    private List droppedTables = new ArrayList();
    private List droppedViews = new ArrayList();
    private List droppedTypes = new ArrayList();
    private Connection currentConnection;
    private String currentConnectionName;
    private Point currentPoint;
    private List types;
    private PreparedStatement objectTypeStatement;
    private PreparedStatement objectTypeStatementUDB;
    private boolean copy_mode = false;
    private static final Logger LOGGER = new Logger(EXTDropHandler.class);

    public void setApplicationView(ApplicationView appView) {
        this.appView = appView;
        this.types = new ArrayList();
        this.types.add(PROPERTY_TABLE);
        this.types.add(PROPERTY_VIEW);
        this.types.add(PROPERTY_MATERIALIZED_VIEW);
        this.types.add(PROPERTY_SYNONYM);
        this.types.add(PROPERTY_PUBLIC_SYNONYM);
        this.types.add(PROPERTY_SEQUENCE);
        this.types.add(PROPERTY_DIRECTORY);
        this.types.add(PROPERTY_PROCEDURE);
        this.types.add(PROPERTY_PROCEDURES);
        this.types.add(PROPERTY_ALIASES);
    }

    private boolean isRelationalModelSelected() {
        return this.appView.getCurrentDPV().getDesignPart() instanceof RelationalDesign;
    }

    private boolean isDatatypeModelSelected() {
        return this.appView.getCurrentDPV().getDesignPart() instanceof DataTypesDesign;
    }

    private boolean isSupportedNode(Object data) {
        if (data != null && data instanceof DatabaseObjectTreeNode) {
            PlSqlNode on;
            Object type;
            DatabaseObjectTreeNode en = (DatabaseObjectTreeNode)data;
            Object usrObj = en.getUserObject();
            if (this.isRelationalModelSelected()) {
                ObjectFolder on2;
                Object type2;
                if (usrObj instanceof ObjectNode) {
                    ObjectNode on3 = (ObjectNode)usrObj;
                    Object type3 = on3.getProperty(PROPERTY_TYPE);
                    if (type3 != null) {
                        for (String next : this.types) {
                            if (!next.equalsIgnoreCase((String)type3)) continue;
                            return true;
                        }
                    }
                } else if (usrObj instanceof PlSqlNode) {
                    PlSqlNode on4 = (PlSqlNode)usrObj;
                    Object type4 = on4.getProperty(PROPERTY_TYPE);
                    if (type4 != null) {
                        for (String next : this.types) {
                            if (!next.equalsIgnoreCase((String)type4)) continue;
                            return true;
                        }
                    }
                } else if (usrObj instanceof ObjectFolder && (type2 = (on2 = (ObjectFolder)usrObj).getProperty(PROPERTY_TYPE)) != null) {
                    for (String next : this.types) {
                        if (!next.equalsIgnoreCase((String)type2)) continue;
                        return true;
                    }
                }
            } else if (this.isDatatypeModelSelected() && (usrObj instanceof PlSqlNode ? (type = (on = (PlSqlNode)usrObj).getProperty(PROPERTY_TYPE)) != null && PROPERTY_TYPE.equalsIgnoreCase((String)type) : (usrObj instanceof ObjectFolder ? (type = (on = (ObjectFolder)usrObj).getProperty(PROPERTY_TYPE)) != null && (PROPERTY_TYPE.equalsIgnoreCase((String)type) || PROPERTY_UTYPES.equalsIgnoreCase((String)type)) : usrObj instanceof ObjectNode && (type = (on = (ObjectNode)usrObj).getProperty(PROPERTY_TYPE)) != null && PROPERTY_UTYPES.equalsIgnoreCase((String)type)))) {
                return true;
            }
        }
        return false;
    }

    private boolean isDragFlavorSupported(DropTargetDragEvent e) {
        if (this.isRelationalModelSelected() || this.isDatatypeModelSelected()) {
            if (e.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
                try {
                    Object data = e.getTransferable().getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
                    boolean supported = this.isSupportedNode(data);
                    if (supported) {
                        return true;
                    }
                }
                catch (IOException ex) {
                }
                catch (UnsupportedFlavorException ex) {}
            } else if (e.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                try {
                    Object data = e.getTransferable().getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR);
                    if (data != null && data instanceof TransferablesList) {
                        TransferablesList tList = (TransferablesList)data;
                        for (Object obj : tList) {
                            Object tansferData;
                            boolean supported;
                            MultiTransferable mt;
                            if (!(obj instanceof MultiTransferable) || !(mt = (MultiTransferable)obj).isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) || !(supported = this.isSupportedNode(tansferData = mt.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR)))) continue;
                            return true;
                        }
                    }
                }
                catch (IOException ex) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private DataFlavor chooseDropFlavor(DropTargetDropEvent e) {
        DataFlavor chosen = null;
        if (e.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
            chosen = TransferableTreeNode.TREE_NODE_FLAVOR;
        } else if (e.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
            chosen = TransferablesList.TRANSFERABLE_LIST_FLAVOR;
        }
        return chosen;
    }

    private boolean isDragOk(DropTargetDragEvent e) {
        if (ApplicationView.IS_VIEWER && !this.appView.getCurrentDesign().isNewDesign()) {
            return false;
        }
        if (!this.isDragFlavorSupported(e)) {
            return false;
        }
        return (e.getDropAction() & 3) > 0 || (e.getDropAction() & 0x40000000) > 0;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (!this.isDragOk(e)) {
            e.rejectDrag();
        } else {
            e.acceptDrag(e.getDropAction());
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (!this.isDragOk(e)) {
            e.rejectDrag();
        } else {
            e.acceptDrag(e.getDropAction());
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        if (!this.isDragOk(e)) {
            e.rejectDrag();
        } else {
            e.acceptDrag(e.getDropAction());
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        DataFlavor chosen = this.chooseDropFlavor(e);
        if (chosen == null) {
            e.rejectDrop();
            return;
        }
        int sa = e.getDropAction();
        if ((sa & 3) == 0) {
            e.rejectDrop();
            return;
        }
        this.copy_mode = (sa & 1) != 0;
        Object data = null;
        try {
            e.acceptDrop(3);
            data = e.getTransferable().getTransferData(chosen);
            if (data == null) {
                return;
            }
        }
        catch (Throwable t) {
            e.dropComplete(false);
            return;
        }
        this.selectedObjects.clear();
        this.droppedTables.clear();
        this.droppedViews.clear();
        this.droppedTypes.clear();
        this.currentConnection = null;
        this.currentConnectionName = "";
        this.objectTypeStatement = null;
        this.objectTypeStatementUDB = null;
        this.currentPoint = e.getLocation();
        if (data instanceof DatabaseObjectTreeNode) {
            this.dropObject(data);
            this.addDesignConnectionStamp();
            new Thread(new Runner()).start();
        } else if (data instanceof TransferablesList) {
            try {
                TransferablesList tList = (TransferablesList)data;
                for (Object obj : tList) {
                    Object tansferData;
                    MultiTransferable mt;
                    if (!(obj instanceof MultiTransferable) || !(mt = (MultiTransferable)obj).isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) || (tansferData = mt.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR)) == null || !(tansferData instanceof DatabaseObjectTreeNode)) continue;
                    this.dropObject(tansferData);
                }
                this.addDesignConnectionStamp();
                new Thread(new Runner()).start();
            }
            catch (Exception ex) {}
        } else {
            e.dropComplete(false);
            return;
        }
        e.dropComplete(true);
        if (this.objectTypeStatement != null) {
            try {
                this.objectTypeStatement.close();
            }
            catch (SQLException e1) {
                LOGGER.error("EXTDropHandler.drop():", e1);
            }
            this.objectTypeStatement = null;
        }
        if (this.objectTypeStatementUDB != null) {
            try {
                this.objectTypeStatementUDB.close();
            }
            catch (SQLException e1) {
                LOGGER.error("EXTDropHandler.drop():", e1);
            }
            this.objectTypeStatementUDB = null;
        }
    }

    private void addDesignConnectionStamp() {
        RelationalDesign rel = this.appView.getCurrentDesign().getRelationalDesign();
        if (rel != null && this.currentConnection != null) {
            try {
                String name = this.currentConnectionName;
                if (name.toUpperCase().startsWith("IDECONNECTIONS%23")) {
                    name = name.substring(17);
                }
                String url = this.currentConnection.getMetaData().getURL();
                String user = this.currentConnection.getMetaData().getUserName();
                String prod = this.currentConnection.getMetaData().getDatabaseProductName();
                int type = 0;
                if ("Oracle".equalsIgnoreCase(prod)) {
                    type = 1;
                } else if ("Microsoft SQL Server".equalsIgnoreCase(prod)) {
                    type = 2;
                } else if (DMDB2ConnectionPanel.CONNECTION_TYPE.equalsIgnoreCase(prod)) {
                    type = 3;
                } else if (DMUDBConnectionPanel.CONNECTION_TYPE.equalsIgnoreCase(prod)) {
                    type = 4;
                }
                int index = rel.addImportConnectionStamp(new DBConnectionStamp(name, url, user, type));
                rel.setImportConnectionStampIndex(index);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean schemaExists(String schema) {
        for (DBObject next : this.selectedObjects) {
            if (!next.getSchema().equalsIgnoreCase(schema)) continue;
            return true;
        }
        return false;
    }

    private void clearImportedTables(RDBMSSite site) {
        ArrayList list = new ArrayList();
        list.addAll(this.selectedObjects);
        for (DBObject dbo : list) {
            if (!PROPERTY_TABLE.equalsIgnoreCase(dbo.getType())) continue;
            Table table = this.getTable(dbo.getSchema(), dbo.getName(), site);
            if (table != null) {
                this.droppedTables.remove(dbo.getName());
                this.selectedObjects.remove(dbo);
                continue;
            }
            if (this.droppedTables.contains(dbo.getName())) continue;
            this.droppedTables.add(dbo.getName());
        }
    }

    private Table getTable(String schema, String name, RDBMSSite site) {
        RelationalDesign rd = this.appView.getCurrentDesign().getRelationalDesign();
        if (rd != null) {
            StorageDesign sd = rd.getStorageDesign(site);
            Iterator it = sd.getTableProxySet().iterator();
            while (it.hasNext()) {
                TableProxy tp = (TableProxy)it.next();
                StorageObject so = tp.getUserSchema();
                String sch = "";
                if (so != null) {
                    sch = so.getName();
                }
                Table table = (Table)tp.getObject();
                if (so == null) {
                    sch = table.getProperty(PROPERTY_SCHEMA);
                }
                if ((sch == null || !sch.equalsIgnoreCase(schema) || !name.equalsIgnoreCase(tp.getName())) && (sch != null || !name.equalsIgnoreCase(tp.getName()))) continue;
                return table;
            }
        }
        return null;
    }

    private String getObjectTypeKind(String name, String schema) {
        if (this.currentConnection != null) {
            try {
                if (this.objectTypeStatement == null) {
                    String sql = " select typecode from sys.all_types where owner = ? and type_name = ?";
                    this.objectTypeStatement = this.currentConnection.prepareStatement(sql);
                }
                String result = "OBJECT";
                if (this.objectTypeStatement != null) {
                    ResultSet rs = null;
                    this.objectTypeStatement.setString(1, schema);
                    this.objectTypeStatement.setString(2, name);
                    rs = this.objectTypeStatement.executeQuery();
                    if (rs != null) {
                        if (rs.next()) {
                            result = rs.getString(1);
                        }
                        rs.close();
                        return result;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("EXTDropHandler.getObjectTypeKind():", e);
            }
        }
        return "OBJECT";
    }

    private String getObjectTypeKindUDB(String name, String schema) {
        if (this.currentConnection != null) {
            try {
                if (this.objectTypeStatementUDB == null) {
                    String sql = "select metatype from syscat.datatypes where typeschema = ? and typename = ?";
                    this.objectTypeStatementUDB = this.currentConnection.prepareStatement(sql);
                }
                String result = PROPERTY_TYPE;
                if (this.objectTypeStatementUDB != null) {
                    ResultSet rs = null;
                    this.objectTypeStatementUDB.setString(1, schema);
                    this.objectTypeStatementUDB.setString(2, name);
                    rs = this.objectTypeStatementUDB.executeQuery();
                    if (rs != null) {
                        if (rs.next()) {
                            String type = rs.getString(1);
                            result = type != null && "T".equalsIgnoreCase(type) ? "DATATYPE" : PROPERTY_TYPE;
                        }
                        rs.close();
                        return result;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("EXTDropHandler.getObjectTypeKindUDB():", e);
            }
        }
        return PROPERTY_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dropObject(Object data) {
        ObjectFolder objFolder;
        Object type;
        DatabaseObjectTreeNode en = (DatabaseObjectTreeNode)data;
        Object usrObj = en.getUserObject();
        if (usrObj == null) return;
        if (usrObj instanceof ObjectNode) {
            ObjectNode objNode = (ObjectNode)usrObj;
            Object type2 = objNode.getProperty(PROPERTY_TYPE);
            if (type2 == null) return;
            try {
                objNode.ensureOpen();
                try {
                    String dbType;
                    if (this.currentConnection == null) {
                        this.currentConnectionName = objNode.getConnectionName();
                        this.currentConnection = objNode.getNodeInstance().getObjectFactory().getConnection();
                        if (this.appView.getCurrentDPV().getDesignPart() instanceof RelationalDesign) {
                            this.appView.getCurrentDesign().setRelationalDesign((RelationalDesign)this.appView.getCurrentDPV().getDesignPart());
                        }
                    }
                    if ((dbType = this.currentConnection.getMetaData().getDatabaseProductName()) == null) return;
                    if (dbType.toUpperCase().contains(DB_TYPE_ORACLE)) {
                        String schema = (String)objNode.getNodeInstance().getProperty(PROPERTY_SCHEMA);
                        if (!this.schemaExists(schema)) {
                            DBObject dboUser = new DBObject(true, schema, "USER", schema);
                            this.selectedObjects.add(dboUser);
                        }
                        if (PROPERTY_TABLE.equalsIgnoreCase(String.valueOf(type2)) || PROPERTY_MATERIALIZED_VIEW.equalsIgnoreCase(String.valueOf(type2))) {
                            String tbName = objNode.getShortLabel();
                            if (tbName == null) return;
                            DBObject dboTable = new DBObject(true, tbName, PROPERTY_TABLE, schema);
                            this.selectedObjects.add(dboTable);
                            this.droppedTables.add(tbName);
                            return;
                        } else if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(type2))) {
                            String viewName = objNode.getShortLabel();
                            if (viewName == null) return;
                            DBObject dboView = new DBObject(true, viewName, PROPERTY_VIEW, schema);
                            this.selectedObjects.add(dboView);
                            this.droppedViews.add(viewName);
                            return;
                        } else if (PROPERTY_SEQUENCE.equalsIgnoreCase(String.valueOf(type2))) {
                            String seqName = objNode.getShortLabel();
                            if (seqName == null) return;
                            DBObject dboSeq = new DBObject(true, seqName, PROPERTY_SEQUENCE, schema);
                            this.selectedObjects.add(dboSeq);
                            return;
                        } else if (PROPERTY_SYNONYM.equalsIgnoreCase(String.valueOf(type2)) || PROPERTY_PUBLIC_SYNONYM.equalsIgnoreCase(String.valueOf(type2))) {
                            String synName = objNode.getShortLabel();
                            if (synName == null) return;
                            DBObject dboSyn = new DBObject(true, synName, PROPERTY_SYNONYM, schema);
                            this.selectedObjects.add(dboSyn);
                            return;
                        } else {
                            String dirName;
                            if (!PROPERTY_DIRECTORY.equalsIgnoreCase(String.valueOf(type2)) || (dirName = objNode.getShortLabel()) == null) return;
                            DBObject dboDir = new DBObject(true, dirName, PROPERTY_DIRECTORY, schema);
                            this.selectedObjects.add(dboDir);
                            return;
                        }
                    } else if (dbType.toUpperCase().contains(DB_TYPE_MS_SQL_SERVER)) {
                        String schema = (String)objNode.getNodeInstance().getProperty(PROPERTY_SCHEMA);
                        String catalog = (String)objNode.getNodeInstance().getProperty(PROPERTY_CATALOG);
                        if (catalog == null) {
                            catalog = "";
                        }
                        if (!this.schemaExists(schema)) {
                            DBUserSqlServer dboUser = new DBUserSqlServer(true, schema, "USER", schema);
                            dboUser.setDb(catalog);
                            this.selectedObjects.add(dboUser);
                        }
                        if (PROPERTY_TABLE.equalsIgnoreCase(String.valueOf(type2))) {
                            String tbName = objNode.getShortLabel();
                            if (tbName == null) return;
                            DBObjectSqlServer dboTable = new DBObjectSqlServer(true, tbName, PROPERTY_TABLE, schema);
                            dboTable.setDb(catalog);
                            this.selectedObjects.add(dboTable);
                            this.droppedTables.add(tbName);
                            return;
                        } else if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(type2))) {
                            String viewName = objNode.getShortLabel();
                            if (viewName == null) return;
                            DBObjectSqlServer dboView = new DBObjectSqlServer(true, viewName, PROPERTY_VIEW, schema);
                            dboView.setDb(catalog);
                            this.selectedObjects.add(dboView);
                            this.droppedViews.add(viewName);
                            return;
                        } else {
                            String procName;
                            if (!PROPERTY_PROCEDURES.equalsIgnoreCase(String.valueOf(type2)) || (procName = objNode.getShortLabel()) == null) return;
                            DBObjectSqlServer dboProc = new DBObjectSqlServer(true, procName, PROPERTY_PROCEDURE, schema);
                            dboProc.setDb(catalog);
                            this.selectedObjects.add(dboProc);
                            return;
                        }
                    } else if (dbType.toUpperCase().contains(DB_TYPE_DB2)) {
                        String typeName;
                        String schema = (String)objNode.getNodeInstance().getProperty(PROPERTY_SCHEMA);
                        if (schema != null) {
                            schema = schema.trim();
                        }
                        if (!this.schemaExists(schema)) {
                            DBObject dboUser = new DBObject(true, schema, PROPERTY_SCHEMA, schema);
                            this.selectedObjects.add(dboUser);
                        }
                        if (PROPERTY_TABLE.equalsIgnoreCase(String.valueOf(type2))) {
                            String tbName = objNode.getShortLabel();
                            if (tbName == null) return;
                            DBObject dboTable = new DBObject(true, tbName, PROPERTY_TABLE, schema);
                            this.selectedObjects.add(dboTable);
                            this.droppedTables.add(tbName);
                            return;
                        } else if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(type2))) {
                            String viewName = objNode.getShortLabel();
                            if (viewName == null) return;
                            DBObject dboView = new DBObject(true, viewName, PROPERTY_VIEW, schema);
                            this.selectedObjects.add(dboView);
                            this.droppedViews.add(viewName);
                            return;
                        } else if (PROPERTY_UTYPES.equalsIgnoreCase(String.valueOf(type2))) {
                            typeName = objNode.getShortLabel();
                            if (typeName == null) return;
                            String objectType = this.getObjectTypeKindUDB(typeName, schema);
                            DBObject dboType = new DBObject(true, typeName, objectType, schema);
                            this.selectedObjects.add(dboType);
                            this.droppedTypes.add(typeName);
                            return;
                        } else {
                            if (!PROPERTY_ALIASES.equalsIgnoreCase(String.valueOf(type2)) || (typeName = objNode.getShortLabel()) == null) return;
                            DBObject dboType = new DBObject(true, typeName, "ALIAS", schema);
                            this.selectedObjects.add(dboType);
                            this.droppedTypes.add(typeName);
                            return;
                        }
                    } else {
                        String schema = (String)objNode.getNodeInstance().getProperty(PROPERTY_SCHEMA);
                        if (schema != null) {
                            schema = schema.trim();
                        }
                        if (!this.schemaExists(schema)) {
                            DBObject dboUser = new DBObject(true, schema, PROPERTY_SCHEMA, schema);
                            this.selectedObjects.add(dboUser);
                        }
                        if (PROPERTY_TABLE.equalsIgnoreCase(String.valueOf(type2))) {
                            String tbName = objNode.getShortLabel();
                            if (tbName == null) return;
                            DBObject dboTable = new DBObject(true, tbName, PROPERTY_TABLE, schema);
                            this.selectedObjects.add(dboTable);
                            this.droppedTables.add(tbName);
                            return;
                        } else {
                            String viewName;
                            if (!PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(type2)) || (viewName = objNode.getShortLabel()) == null) return;
                            DBObject dboView = new DBObject(true, viewName, PROPERTY_VIEW, schema);
                            this.selectedObjects.add(dboView);
                            this.droppedViews.add(viewName);
                            return;
                        }
                    }
                }
                finally {
                    objNode.close();
                }
            }
            catch (Exception ex) {}
            return;
        }
        if (usrObj instanceof PlSqlNode) {
            PlSqlNode objNode = (PlSqlNode)usrObj;
            Object type3 = objNode.getProperty(PROPERTY_TYPE);
            if (type3 == null) return;
            try {
                objNode.ensureOpen();
                try {
                    String dbType;
                    if (this.currentConnection == null) {
                        this.currentConnectionName = objNode.getConnectionName();
                        this.currentConnection = objNode.getNodeInstance().getObjectFactory().getConnection();
                        if (this.isRelationalModelSelected()) {
                            this.appView.getCurrentDesign().setRelationalDesign((RelationalDesign)this.appView.getCurrentDPV().getDesignPart());
                        }
                    }
                    if (!(dbType = this.currentConnection.getMetaData().getDatabaseProductName()).toUpperCase().contains(DB_TYPE_ORACLE)) return;
                    String schema = (String)objNode.getNodeInstance().getProperty(PROPERTY_SCHEMA);
                    if (!this.schemaExists(schema)) {
                        DBObject dboUser = new DBObject(true, schema, "USER", schema);
                        this.selectedObjects.add(dboUser);
                    }
                    if (PROPERTY_TYPE.equalsIgnoreCase(String.valueOf(type3))) {
                        String typeName = objNode.getShortLabel();
                        if (typeName == null) return;
                        String objectType = this.getObjectTypeKind(typeName, schema);
                        DBObject dboType = new DBObject(true, typeName, objectType, schema);
                        this.selectedObjects.add(dboType);
                        this.droppedTypes.add(typeName);
                        return;
                    } else {
                        String procName;
                        if (!PROPERTY_PROCEDURE.equalsIgnoreCase(String.valueOf(type3)) || (procName = objNode.getShortLabel()) == null) return;
                        DBObject dboProc = new DBObject(true, procName, PROPERTY_PROCEDURE, schema);
                        this.selectedObjects.add(dboProc);
                        return;
                    }
                }
                finally {
                    objNode.close();
                }
            }
            catch (Exception ex) {}
            return;
        }
        if (!(usrObj instanceof ObjectFolder) || (type = (objFolder = (ObjectFolder)usrObj).getProperty(PROPERTY_TYPE)) == null) return;
        if (this.isRelationalModelSelected()) {
            try {
                List list;
                String dbType;
                if (this.currentConnection == null) {
                    this.currentConnectionName = objFolder.getConnectionName();
                    this.currentConnection = objFolder.getFolderInstance().getObjectFactory().getConnection();
                    if (this.appView.getCurrentDPV().getDesignPart() instanceof RelationalDesign) {
                        this.appView.getCurrentDesign().setRelationalDesign((RelationalDesign)this.appView.getCurrentDPV().getDesignPart());
                    }
                }
                if ((dbType = this.currentConnection.getMetaData().getDatabaseProductName()) == null) return;
                if (dbType.toUpperCase().contains(DB_TYPE_ORACLE)) {
                    List list2;
                    String schema = (String)objFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                    if (!this.schemaExists(schema)) {
                        DBObject dboUser = new DBObject(true, schema, "USER", schema);
                        this.selectedObjects.add(dboUser);
                    }
                    if (PROPERTY_TABLE.equalsIgnoreCase((String)type) || PROPERTY_MATERIALIZED_VIEW.equalsIgnoreCase(String.valueOf(type))) {
                        list2 = objFolder.getFolderInstance().listChildren();
                        for (AbstractNodeInstance xmlNode : list2) {
                            String objName = (String)xmlNode.getProperty(PROPERTY_OBJECT_NAME);
                            if (objName == null) {
                                objName = (String)xmlNode.getProperty(PROPERTY_NAME);
                            }
                            if (objName == null || "".equalsIgnoreCase(objName) || this.droppedTables.contains(objName)) continue;
                            DBObject dboTable = new DBObject(true, objName, PROPERTY_TABLE, schema);
                            this.selectedObjects.add(dboTable);
                            this.droppedTables.add(objName);
                        }
                        return;
                    }
                    if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(type))) {
                        list2 = objFolder.getFolderInstance().listChildren();
                        for (AbstractNodeInstance xmlNode : list2) {
                            String objName = (String)xmlNode.getProperty(PROPERTY_OBJECT_NAME);
                            if (objName == null || "".equalsIgnoreCase(objName) || this.droppedViews.contains(objName)) continue;
                            DBObject dboView = new DBObject(true, objName, PROPERTY_VIEW, schema);
                            this.selectedObjects.add(dboView);
                            this.droppedViews.add(objName);
                        }
                        return;
                    }
                    if (PROPERTY_SEQUENCE.equalsIgnoreCase(String.valueOf(type))) {
                        list2 = objFolder.getFolderInstance().listChildren();
                        for (AbstractNodeInstance xmlNode : list2) {
                            String objName = (String)xmlNode.getProperty(PROPERTY_OBJECT_NAME);
                            if (objName == null || "".equalsIgnoreCase(objName)) continue;
                            DBObject dboSeq = new DBObject(true, objName, PROPERTY_SEQUENCE, schema);
                            this.selectedObjects.add(dboSeq);
                        }
                        return;
                    }
                    if (PROPERTY_SYNONYM.equalsIgnoreCase(String.valueOf(type)) || PROPERTY_PUBLIC_SYNONYM.equalsIgnoreCase(String.valueOf(type))) {
                        list2 = objFolder.getFolderInstance().listChildren();
                        for (AbstractNodeInstance xmlNode : list2) {
                            String objName = (String)xmlNode.getProperty(PROPERTY_SYNONYM_NAME);
                            if (objName == null || "".equalsIgnoreCase(objName)) continue;
                            DBObject dboSyn = new DBObject(true, objName, PROPERTY_SYNONYM, schema);
                            this.selectedObjects.add(dboSyn);
                        }
                        return;
                    }
                    if (PROPERTY_DIRECTORY.equalsIgnoreCase(String.valueOf(type))) {
                        list2 = objFolder.getFolderInstance().listChildren();
                        for (AbstractNodeInstance xmlNode : list2) {
                            String objName = (String)xmlNode.getProperty(PROPERTY_DIRECTORY_NAME);
                            if (objName == null || "".equalsIgnoreCase(objName)) continue;
                            DBObject dboDir = new DBObject(true, objName, PROPERTY_DIRECTORY, schema);
                            this.selectedObjects.add(dboDir);
                        }
                        return;
                    }
                    if (!PROPERTY_PROCEDURE.equalsIgnoreCase(String.valueOf(type))) return;
                    list2 = objFolder.getFolderInstance().listChildren();
                    for (AbstractNodeInstance xmlNode : list2) {
                        String objName = (String)xmlNode.getProperty(PROPERTY_NAME);
                        if (objName == null || "".equalsIgnoreCase(objName)) continue;
                        DBObject dboProc = new DBObject(true, objName, PROPERTY_PROCEDURE, schema);
                        this.selectedObjects.add(dboProc);
                    }
                    return;
                }
                if (dbType.toUpperCase().contains(DB_TYPE_MS_SQL_SERVER)) {
                    List list3;
                    String schema = (String)objFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                    String catalog = (String)objFolder.getFolderInstance().getProperty(PROPERTY_CATALOG);
                    if (catalog == null) {
                        catalog = "";
                    }
                    if (!this.schemaExists(schema)) {
                        DBUserSqlServer dboUser = new DBUserSqlServer(true, schema, "USER", schema);
                        dboUser.setDb(catalog);
                        this.selectedObjects.add(dboUser);
                    }
                    if (PROPERTY_TABLE.equalsIgnoreCase(String.valueOf(type))) {
                        list3 = objFolder.getFolderInstance().listChildren();
                        for (AbstractNodeInstance xmlNode : list3) {
                            String objName = (String)xmlNode.getProperty(PROPERTY_TABLE_NAME);
                            if (objName == null || "".equalsIgnoreCase(objName)) continue;
                            DBObjectSqlServer dboTable = new DBObjectSqlServer(true, objName, PROPERTY_TABLE, schema);
                            if ("".equalsIgnoreCase(catalog)) {
                                catalog = (String)xmlNode.getProperty(PROPERTY_TABLE_CATALOG);
                            }
                            if (catalog == null) {
                                catalog = "";
                            }
                            dboTable.setDb(catalog);
                            this.selectedObjects.add(dboTable);
                            this.droppedTables.add(objName);
                        }
                        return;
                    }
                    if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(type))) {
                        list3 = objFolder.getFolderInstance().listChildren();
                        for (AbstractNodeInstance xmlNode : list3) {
                            String objName = (String)xmlNode.getProperty(PROPERTY_TABLE_NAME);
                            if (objName == null || "".equalsIgnoreCase(objName)) continue;
                            DBObjectSqlServer dboView = new DBObjectSqlServer(true, objName, PROPERTY_VIEW, schema);
                            if ("".equalsIgnoreCase(catalog)) {
                                catalog = (String)xmlNode.getProperty(PROPERTY_TABLE_CATALOG);
                            }
                            if (catalog == null) {
                                catalog = "";
                            }
                            dboView.setDb(catalog);
                            this.selectedObjects.add(dboView);
                            this.droppedViews.add(objName);
                        }
                        return;
                    }
                    if (!PROPERTY_PROCEDURES.equalsIgnoreCase(String.valueOf(type))) return;
                    list3 = objFolder.getFolderInstance().listChildren();
                    for (AbstractNodeInstance xmlNode : list3) {
                        String objName = (String)xmlNode.getProperty(PROPERTY_NAME);
                        if (objName == null || "".equalsIgnoreCase(objName)) continue;
                        DBObjectSqlServer dboProc = new DBObjectSqlServer(true, objName, PROPERTY_PROCEDURE, schema);
                        if ("".equalsIgnoreCase(catalog)) {
                            catalog = (String)xmlNode.getProperty(PROPERTY_TABLE_CATALOG);
                        }
                        if (catalog == null) {
                            catalog = "";
                        }
                        dboProc.setDb(catalog);
                        this.selectedObjects.add(dboProc);
                    }
                    return;
                }
                if (dbType.toUpperCase().contains(DB_TYPE_DB2)) {
                    List list4;
                    String schema = (String)objFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                    if (schema != null) {
                        schema = schema.trim();
                    }
                    if (!this.schemaExists(schema)) {
                        DBObject dboUser = new DBObject(true, schema, PROPERTY_SCHEMA, schema);
                        this.selectedObjects.add(dboUser);
                    }
                    if (PROPERTY_TABLE.equalsIgnoreCase((String)type)) {
                        list4 = objFolder.getFolderInstance().listChildren();
                        for (AbstractNodeInstance xmlNode : list4) {
                            String objName = (String)xmlNode.getProperty(PROPERTY_OBJECT_NAME);
                            if (objName == null) {
                                objName = (String)xmlNode.getProperty(PROPERTY_NAME);
                            }
                            if (objName == null || "".equalsIgnoreCase(objName) || this.droppedTables.contains(objName)) continue;
                            DBObject dboTable = new DBObject(true, objName, PROPERTY_TABLE, schema);
                            this.selectedObjects.add(dboTable);
                            this.droppedTables.add(objName);
                        }
                        return;
                    }
                    if (PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(type))) {
                        list4 = objFolder.getFolderInstance().listChildren();
                        for (AbstractNodeInstance xmlNode : list4) {
                            String objName = (String)xmlNode.getProperty(PROPERTY_OBJECT_NAME);
                            if (objName == null) {
                                objName = (String)xmlNode.getProperty(PROPERTY_NAME);
                            }
                            if (objName == null || "".equalsIgnoreCase(objName) || this.droppedViews.contains(objName)) continue;
                            DBObject dboView = new DBObject(true, objName, PROPERTY_VIEW, schema);
                            this.selectedObjects.add(dboView);
                            this.droppedViews.add(objName);
                        }
                        return;
                    }
                    if (!PROPERTY_ALIASES.equalsIgnoreCase(String.valueOf(type))) return;
                    list4 = objFolder.getFolderInstance().listChildren();
                    for (AbstractNodeInstance xmlNode : list4) {
                        String objName = (String)xmlNode.getProperty(PROPERTY_OBJECT_NAME);
                        if (objName == null) {
                            objName = (String)xmlNode.getProperty(PROPERTY_NAME);
                        }
                        if (objName == null || "".equalsIgnoreCase(objName) || this.droppedViews.contains(objName)) continue;
                        DBObject dboAlias = new DBObject(true, objName, "ALIAS", schema);
                        this.selectedObjects.add(dboAlias);
                        this.droppedViews.add(objName);
                    }
                    return;
                }
                String schema = (String)objFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                if (schema != null) {
                    schema = schema.trim();
                }
                if (!this.schemaExists(schema)) {
                    DBObject dboUser = new DBObject(true, schema, PROPERTY_SCHEMA, schema);
                    this.selectedObjects.add(dboUser);
                }
                if (PROPERTY_TABLE.equalsIgnoreCase((String)type)) {
                    list = objFolder.getFolderInstance().listChildren();
                    for (AbstractNodeInstance xmlNode : list) {
                        String objName = (String)xmlNode.getProperty(PROPERTY_OBJECT_NAME);
                        if (objName == null) {
                            objName = (String)xmlNode.getProperty(PROPERTY_NAME);
                        }
                        if (objName == null || "".equalsIgnoreCase(objName) || this.droppedTables.contains(objName)) continue;
                        DBObject dboTable = new DBObject(true, objName, PROPERTY_TABLE, schema);
                        this.selectedObjects.add(dboTable);
                        this.droppedTables.add(objName);
                    }
                    return;
                }
                if (!PROPERTY_VIEW.equalsIgnoreCase(String.valueOf(type))) return;
                list = objFolder.getFolderInstance().listChildren();
                for (AbstractNodeInstance xmlNode : list) {
                    String objName = (String)xmlNode.getProperty(PROPERTY_OBJECT_NAME);
                    if (objName == null) {
                        objName = (String)xmlNode.getProperty(PROPERTY_NAME);
                    }
                    if (objName == null || "".equalsIgnoreCase(objName) || this.droppedViews.contains(objName)) continue;
                    DBObject dboView = new DBObject(true, objName, PROPERTY_VIEW, schema);
                    this.selectedObjects.add(dboView);
                    this.droppedViews.add(objName);
                }
                return;
            }
            catch (Exception ex) {
                return;
            }
        }
        if (!this.isDatatypeModelSelected()) return;
        try {
            String dbType;
            if (this.currentConnection == null) {
                this.currentConnectionName = objFolder.getConnectionName();
                this.currentConnection = objFolder.getFolderInstance().getObjectFactory().getConnection();
            }
            if ((dbType = this.currentConnection.getMetaData().getDatabaseProductName()).toUpperCase().contains(DB_TYPE_ORACLE)) {
                String schema = (String)objFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                if (!this.schemaExists(schema)) {
                    DBObject dboUser = new DBObject(true, schema, "USER", schema);
                    this.selectedObjects.add(dboUser);
                }
                if (!PROPERTY_TYPE.equalsIgnoreCase(String.valueOf(type))) return;
                List list = objFolder.getFolderInstance().listChildren();
                for (AbstractNodeInstance xmlNode : list) {
                    String objName = (String)xmlNode.getProperty(PROPERTY_NAME);
                    if (objName == null || "".equalsIgnoreCase(objName)) continue;
                    DBObject dboType = new DBObject(true, objName, "OBJECT", schema);
                    this.selectedObjects.add(dboType);
                    this.droppedTypes.add(objName);
                }
                return;
            } else {
                if (!dbType.toUpperCase().contains(DB_TYPE_DB2)) return;
                String schema = (String)objFolder.getFolderInstance().getProperty(PROPERTY_SCHEMA);
                if (schema != null) {
                    schema = schema.trim();
                }
                if (!this.schemaExists(schema)) {
                    DBObject dboUser = new DBObject(true, schema, PROPERTY_SCHEMA, schema);
                    this.selectedObjects.add(dboUser);
                }
                if (!PROPERTY_UTYPES.equalsIgnoreCase(String.valueOf(type))) return;
                List list = objFolder.getFolderInstance().listChildren();
                for (AbstractNodeInstance xmlNode : list) {
                    String objName = (String)xmlNode.getProperty(PROPERTY_NAME);
                    if (objName == null || "".equalsIgnoreCase(objName)) continue;
                    DBObject dboType = new DBObject(true, objName, PROPERTY_TYPE, schema);
                    this.selectedObjects.add(dboType);
                    this.droppedTypes.add(objName);
                }
            }
            return;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private List getTopViews(List objects, DesignPartView dpv) {
        ArrayList<TopView> topViews = new ArrayList<TopView>();
        for (MultiShapedDesignObject msdo : objects) {
            TopView topView = msdo.getFirstViewForDPV(dpv);
            if (topView == null) continue;
            topViews.add(topView);
        }
        return topViews;
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImportLogger importLog = new ImportLogger();
            if (EXTDropHandler.this.appView.getCurrentDesign().getStorageDesign(EXTDropHandler.this.appView.getCurrentDesign().getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign) {
                StorageDesign.NullStorageDesign nsd = (StorageDesign.NullStorageDesign)EXTDropHandler.this.appView.getCurrentDesign().getStorageDesign(EXTDropHandler.this.appView.getCurrentDesign().getSelectedRDBMSSite());
                importLog.addError(nsd.getName());
                Iterator it = nsd.getMessage().iterator();
                while (it.hasNext()) {
                    importLog.addError((String)it.next());
                }
                return;
            }
            if (EXTDropHandler.this.currentConnection != null) {
                try (ProgressDialog monitor = new ProgressDialog(EXTDropHandler.this.appView, "", 0, 100);){
                    block48: {
                        monitor.setProgress(5);
                        monitor.setNote(Messages.getString("EXTDropHandler.DropObjects"));
                        int maxTopPointMainView = 20;
                        int maxTopPoint = 20;
                        if (EXTDropHandler.this.isRelationalModelSelected()) {
                            maxTopPointMainView = ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).getMaxTopPoint();
                            maxTopPoint = ((DPVRelational)EXTDropHandler.this.appView.getCurrentDPV()).getMaxTopPoint();
                        }
                        try {
                            EXTDropHandler.this.appView.getCurrentDesign().setPropagatePKChahges(false);
                            String dbType = EXTDropHandler.this.currentConnection.getMetaData().getDatabaseProductName();
                            String version = EXTDropHandler.this.currentConnection.getMetaData().getDatabaseProductVersion();
                            if (dbType != null) {
                                ArrayList selectedCopy;
                                SubordinateTablesReader sr;
                                AbstractDBMExtractionHandler dbmExtractionHandler;
                                boolean zos = false;
                                if (dbType.toUpperCase().contains(EXTDropHandler.DB_TYPE_DB2)) {
                                    if (version != null && (version.toUpperCase().contains("Z") || version.toUpperCase().contains("390"))) {
                                        zos = true;
                                    }
                                    if (dbType.toUpperCase().contains("Z") || dbType.toUpperCase().contains("390")) {
                                        zos = true;
                                    }
                                }
                                if (dbType.toUpperCase().contains(EXTDropHandler.DB_TYPE_ORACLE)) {
                                    dbmExtractionHandler = new ExtractionHandlerOracle(EXTDropHandler.this.appView);
                                    ((ExtractionHandlerOracle)dbmExtractionHandler).init(EXTDropHandler.this.currentConnection);
                                    EXTDropHandler.this.appView.getCurrentDesign().setSelectedRDBMSSite(((ExtractionHandlerOracle)dbmExtractionHandler).getRDBMSSite());
                                    sr = new SubordinateTablesOracle(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects);
                                    if (EXTDropHandler.this.copy_mode) {
                                        EXTDropHandler.this.selectedObjects = ((SubordinateTablesOracle)sr).getAllObjects(true);
                                    }
                                    EXTDropHandler.this.clearImportedTables(((ExtractionHandlerOracle)dbmExtractionHandler).getRDBMSSite());
                                    if (EXTDropHandler.this.selectedObjects.size() > 0) {
                                        selectedCopy = new ArrayList();
                                        selectedCopy.addAll(EXTDropHandler.this.selectedObjects);
                                        ((ExtractionHandlerOracle)dbmExtractionHandler).generateDesign(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects, importLog, monitor);
                                        ((SubordinateTablesOracle)sr).generateFKs_fromChilds(EXTDropHandler.this.currentConnection, selectedCopy, EXTDropHandler.this.appView.getCurrentDesign(), ((ExtractionHandlerOracle)dbmExtractionHandler).getRDBMSSite());
                                    }
                                } else if (dbType.toUpperCase().contains(EXTDropHandler.DB_TYPE_MS_SQL_SERVER)) {
                                    dbmExtractionHandler = new ExtractionHandlerSQLServer(EXTDropHandler.this.appView);
                                    ((ExtractionHandlerSQLServer)dbmExtractionHandler).init(EXTDropHandler.this.currentConnection);
                                    EXTDropHandler.this.appView.getCurrentDesign().setSelectedRDBMSSite(((ExtractionHandlerSQLServer)dbmExtractionHandler).getRDBMSSite());
                                    sr = new SubordinateTablesJDBC(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects);
                                    if (EXTDropHandler.this.copy_mode) {
                                        EXTDropHandler.this.selectedObjects = ((SubordinateTablesJDBC)sr).getAllObjects(true, EXTDropHandler.DB_TYPE_MS_SQL_SERVER);
                                    }
                                    EXTDropHandler.this.clearImportedTables(((ExtractionHandlerSQLServer)dbmExtractionHandler).getRDBMSSite());
                                    if (EXTDropHandler.this.selectedObjects.size() > 0) {
                                        selectedCopy = new ArrayList();
                                        selectedCopy.addAll(EXTDropHandler.this.selectedObjects);
                                        ((ExtractionHandlerSQLServer)dbmExtractionHandler).generateDesign(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects, importLog, monitor);
                                        ((SubordinateTablesJDBC)sr).generateFKs_fromChilds(EXTDropHandler.this.currentConnection, selectedCopy, EXTDropHandler.this.appView.getCurrentDesign(), ((ExtractionHandlerSQLServer)dbmExtractionHandler).getRDBMSSite());
                                    }
                                } else if (dbType.toUpperCase().contains(EXTDropHandler.DB_TYPE_DB2) && !zos) {
                                    dbmExtractionHandler = new ExtractionHandlerDB2(EXTDropHandler.this.appView);
                                    ((ExtractionHandlerDB2)dbmExtractionHandler).init(EXTDropHandler.this.currentConnection);
                                    EXTDropHandler.this.appView.getCurrentDesign().setSelectedRDBMSSite(((ExtractionHandlerDB2)dbmExtractionHandler).getRDBMSSite());
                                    sr = new SubordinateTablesJDBC(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects);
                                    if (EXTDropHandler.this.copy_mode) {
                                        EXTDropHandler.this.selectedObjects = ((SubordinateTablesJDBC)sr).getAllObjects(true, EXTDropHandler.DB_TYPE_DB2);
                                    }
                                    EXTDropHandler.this.clearImportedTables(((ExtractionHandlerDB2)dbmExtractionHandler).getRDBMSSite());
                                    if (EXTDropHandler.this.selectedObjects.size() > 0) {
                                        selectedCopy = new ArrayList();
                                        selectedCopy.addAll(EXTDropHandler.this.selectedObjects);
                                        ((ExtractionHandlerDB2)dbmExtractionHandler).generateDesign(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects, importLog, monitor);
                                        ((SubordinateTablesJDBC)sr).generateFKs_fromChilds(EXTDropHandler.this.currentConnection, selectedCopy, EXTDropHandler.this.appView.getCurrentDesign(), ((ExtractionHandlerDB2)dbmExtractionHandler).getRDBMSSite());
                                    }
                                } else {
                                    dbmExtractionHandler = new ExtractionHandlerODBC(EXTDropHandler.this.appView);
                                    ((ExtractionHandlerODBC)dbmExtractionHandler).init(EXTDropHandler.this.currentConnection);
                                    EXTDropHandler.this.appView.getCurrentDesign().setSelectedRDBMSSite(((ExtractionHandlerODBC)dbmExtractionHandler).getRDBMSSite());
                                    sr = new SubordinateTablesJDBC(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects);
                                    if (EXTDropHandler.this.copy_mode) {
                                        EXTDropHandler.this.selectedObjects = ((SubordinateTablesJDBC)sr).getAllObjects(true, EXTDropHandler.DB_TYPE_JDBC);
                                    }
                                    EXTDropHandler.this.clearImportedTables(((ExtractionHandlerODBC)dbmExtractionHandler).getRDBMSSite());
                                    if (EXTDropHandler.this.selectedObjects.size() > 0) {
                                        selectedCopy = new ArrayList();
                                        selectedCopy.addAll(EXTDropHandler.this.selectedObjects);
                                        ((ExtractionHandlerODBC)dbmExtractionHandler).generateDesign(EXTDropHandler.this.currentConnection, EXTDropHandler.this.selectedObjects, importLog, monitor);
                                        ((SubordinateTablesJDBC)sr).generateFKs_fromChilds(EXTDropHandler.this.currentConnection, selectedCopy, EXTDropHandler.this.appView.getCurrentDesign(), ((ExtractionHandlerODBC)dbmExtractionHandler).getRDBMSSite());
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                        }
                        finally {
                            EXTDropHandler.this.appView.getCurrentDesign().setPropagatePKChahges(false);
                        }
                        monitor.setNote(Messages.getString("EXTDropHandler.RearrangeObjects"));
                        monitor.setProgress(85);
                        try {
                            if (EXTDropHandler.this.isRelationalModelSelected()) {
                                DesignObject designObject;
                                ArrayList<DesignObject> tbList = new ArrayList<DesignObject>();
                                ArrayList<DesignObject> viewList = new ArrayList<DesignObject>();
                                if (EXTDropHandler.this.droppedTables.size() > 0) {
                                    for (String dropped : EXTDropHandler.this.droppedTables) {
                                        if (dropped == null || (designObject = EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getTableSet().getByName(dropped)) == null) continue;
                                        tbList.add(designObject);
                                    }
                                }
                                if (EXTDropHandler.this.droppedViews.size() > 0) {
                                    for (String dropped : EXTDropHandler.this.droppedViews) {
                                        if (dropped == null || (designObject = EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getTableViewSet().getByName(dropped)) == null) continue;
                                        viewList.add(designObject);
                                    }
                                }
                                try {
                                    EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().createArcsFromTableCheckConstraints();
                                }
                                catch (Exception e) {
                                    LOGGER.error("Error in creating Arcs from table Check constraints", e);
                                }
                                if (EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().isEmpty()) {
                                    if (EXTDropHandler.this.appView.getCurrentDPV() != EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()) {
                                        ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewDiagram();
                                        ((DPVRelational)EXTDropHandler.this.appView.getCurrentDPV()).rearrangeNewDiagram();
                                    } else {
                                        ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewDiagram();
                                    }
                                } else if (EXTDropHandler.this.appView.getCurrentDPV() != EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()) {
                                    ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewTables(EXTDropHandler.this.getTopViews(tbList, EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()), maxTopPointMainView);
                                    ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewViews(EXTDropHandler.this.getTopViews(viewList, EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()));
                                    ((DPVRelational)EXTDropHandler.this.appView.getCurrentDPV()).rearrangeNewTables(EXTDropHandler.this.getTopViews(tbList, EXTDropHandler.this.appView.getCurrentDPV()), maxTopPoint);
                                    ((DPVRelational)EXTDropHandler.this.appView.getCurrentDPV()).rearrangeNewViews(EXTDropHandler.this.getTopViews(viewList, EXTDropHandler.this.appView.getCurrentDPV()));
                                } else {
                                    ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewTables(EXTDropHandler.this.getTopViews(tbList, EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()), maxTopPointMainView);
                                    ((DPVRelational)EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()).rearrangeNewViews(EXTDropHandler.this.getTopViews(viewList, EXTDropHandler.this.appView.getCurrentDesign().getRelationalDesign().getMainView()));
                                }
                                break block48;
                            }
                            if (EXTDropHandler.this.isDatatypeModelSelected() && EXTDropHandler.this.droppedTypes.size() > 0) {
                                ArrayList<DesignObject> typeList = new ArrayList<DesignObject>();
                                for (String dropped : EXTDropHandler.this.droppedTypes) {
                                    DesignObject designObject;
                                    if (dropped == null || (designObject = EXTDropHandler.this.appView.getCurrentDesign().getDataTypesDesign().getStructuredTypeSet().getByName(dropped)) == null) continue;
                                    typeList.add(designObject);
                                }
                                EXTDropHandler.this.appView.getCurrentDesign().getDataTypesDesign().rearrangeTypes(typeList, EXTDropHandler.this.currentPoint);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    EXTDropHandler.this.appView.getCurrentDesign().setDirty(true);
                    EXTDropHandler.this.appView.getCurrentDesign().getStorageDesign(EXTDropHandler.this.appView.getCurrentDesign().getSelectedRDBMSSite()).setOpen(true);
                    EXTDropHandler.this.appView.getCurrentDesign().getStorageDesign(EXTDropHandler.this.appView.getCurrentDesign().getSelectedRDBMSSite()).setDirty(true);
                    EXTDropHandler.this.appView.getCurrentDesign().getStorageDesign(EXTDropHandler.this.appView.getCurrentDesign().getSelectedRDBMSSite()).setTempModel(false);
                    monitor.setProgress(100);
                    System.gc();
                }
            }
        }
    }
}

