/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.NodeGroupUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBNodeGroupUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;
    public static final String NODES = "NODES";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof NodeGroupUDBv71 && ((NodeGroupUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        NodeGroupUDBv71 nodeGroup = (NodeGroupUDBv71)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, nodeGroup);
        this.appendCreate(buffer, nodeGroup);
        this.appendNodes(buffer, nodeGroup, prettyPrint);
        SSBNodeGroupUDBv71.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateNodeGroup();
        if (nodeGroup.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, nodeGroup, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, NodeGroupUDBv71 nodeGroup, boolean prettyPrint) {
        SSBNodeGroupUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBNodeGroupUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
        SSBNodeGroupUDBv71.appendStringWithSpace(buffer, "NODEGROUP");
        SSBNodeGroupUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(nodeGroup.getLongNameDDL()));
        SSBNodeGroupUDBv71.appendStringWithSpace(buffer, "IS");
        SSBNodeGroupUDBv71.appendString(buffer, '\'');
        SSBNodeGroupUDBv71.appendString(buffer, nodeGroup.getCommentInRDBMS());
        SSBNodeGroupUDBv71.appendStringWithSpace(buffer, '\'');
        SSBNodeGroupUDBv71.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
    }

    protected void appendCreate(StringBuffer buffer, NodeGroupUDBv71 nodeGroup) {
        this.appendCreate(buffer);
        SSBNodeGroupUDBv71.appendStringWithSpace(buffer, "NODEGROUP");
        SSBNodeGroupUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(nodeGroup.getName()));
    }

    protected void appendNodes(StringBuffer buffer, NodeGroupUDBv71 nodeGroup, boolean prettyPrint) {
        SSBNodeGroupUDBv71.appendNewLine(buffer, prettyPrint, 1);
        if (nodeGroup.getScope().equalsIgnoreCase("ON ALL NODES")) {
            SSBNodeGroupUDBv71.appendStringWithSpace(buffer, "ON ALL NODES");
        } else {
            SSBNodeGroupUDBv71.appendStringWithSpace(buffer, "ON");
            SSBNodeGroupUDBv71.appendStringWithSpace(buffer, NODES);
            SSBNodeGroupUDBv71.appendStringWithSpace(buffer, '(');
            SSBNodeGroupUDBv71.appendStringWithSpace(buffer, nodeGroup.getNodeNumbers());
            SSBNodeGroupUDBv71.appendStringWithSpace(buffer, ')');
        }
    }
}

