/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.RuleSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBRuleSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        RuleSqlServerv2k rule = (RuleSqlServerv2k)object;
        this.storageDesign = rule.getStorageDesign();
        this.appendComment(buffer, rule);
        this.appendRule(buffer, rule, prettyPrint);
        this.appendBindRule(buffer, rule, prettyPrint);
    }

    private void appendRule(StringBuffer buffer, RuleSqlServerv2k rule, boolean prettyPrint) {
        if (!rule.getExpression().trim().equalsIgnoreCase("")) {
            this.appendDataBase(buffer, rule.getDatabase(), prettyPrint);
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, "CREATE");
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, "RULE");
            if (rule.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                SSBRuleSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(rule.getOwner().getName()));
                SSBRuleSqlServerv2k.appendString(buffer, '.');
            }
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(rule.getName()));
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, "AS");
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, rule.getExpression());
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateRule();
            if (rule.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendRuleComment(buffer, rule, prettyPrint);
            }
        } else {
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Error - Empty expression in rule ");
            buffer.append(this.storageDesign.getFormatedName(rule.getName()));
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendRuleComment(StringBuffer buffer, RuleSqlServerv2k rule, boolean prettyPrint) {
        String comment = rule.getCommentInRDBMS();
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBRuleSqlServerv2k.appendString(buffer, '\'');
            SSBRuleSqlServerv2k.appendString(buffer, comment);
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, ',');
            if (rule != null && rule.getOwner() != null) {
                SSBRuleSqlServerv2k.appendString(buffer, '\'');
                SSBRuleSqlServerv2k.appendString(buffer, "USER");
                SSBRuleSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBRuleSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBRuleSqlServerv2k.appendString(buffer, '\'');
                this.appendString(buffer, rule.getOwner());
                SSBRuleSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBRuleSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            SSBRuleSqlServerv2k.appendString(buffer, '\'');
            SSBRuleSqlServerv2k.appendString(buffer, "RULE");
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBRuleSqlServerv2k.appendString(buffer, '\'');
            SSBRuleSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(rule.getLongNameDDL()));
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k.appendString(buffer, "GO");
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendBindRule(StringBuffer buffer, RuleSqlServerv2k rule, boolean prettyPrint) {
        Iterator it = rule.getColumnSet().iterator();
        ColumnProxySetSqlServer colProxy = (ColumnProxySetSqlServer)rule.getStorageDesign().getColumnProxySet();
        ColumnProxySqlServer col = null;
        while (it.hasNext()) {
            String column = (String)it.next();
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, "sp_bindrule");
            SSBRuleSqlServerv2k.appendString(buffer, '\'');
            if (rule.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                SSBRuleSqlServerv2k.appendString(buffer, rule.getOwner().getName());
                SSBRuleSqlServerv2k.appendString(buffer, '.');
            }
            SSBRuleSqlServerv2k.appendString(buffer, rule.getName());
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, '\'');
            this.appendComma(buffer);
            SSBRuleSqlServerv2k.appendString(buffer, '\'');
            col = colProxy.getByName(column);
            SSBRuleSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(col.getTableProxy().getName()));
            SSBRuleSqlServerv2k.appendString(buffer, '.');
            SSBRuleSqlServerv2k.appendString(buffer, column);
            SSBRuleSqlServerv2k.appendString(buffer, '\'');
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBRuleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof RuleSqlServerv2k && ((RuleSqlServerv2k)object).getDatabase() != null && !((RuleSqlServerv2k)object).getDatabase().isNullInstance() && ((RuleSqlServerv2k)object).isMarkedGenerate();
    }
}

