/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RollbackSegmentOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBRollbackSegmentOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        RollbackSegmentOraclev9i segment = (RollbackSegmentOraclev9i)object;
        this.storageDesign = segment.getStorageDesign();
        this.appendComment(oldbuffer, segment);
        this.appendCreateSegment(buffer, segment);
        advancedComment = buffer.toString();
        this.appendTablespaces(buffer, segment, prettyPrint);
        this.appendStorage(buffer, segment, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBRollbackSegmentOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        SSBRollbackSegmentOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateRollbackSegment();
    }

    private void appendCreateSegment(StringBuffer buffer, RollbackSegmentOraclev9i segment) {
        this.appendCreate(buffer);
        if ("YES".equalsIgnoreCase(segment.getPub())) {
            SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "PUBLIC");
        }
        SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "ROLLBACK");
        SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "SEGMENT");
        SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(segment));
    }

    private void appendTablespaces(StringBuffer buffer, RollbackSegmentOraclev9i segment, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            for (int i = 0; i < segment.getTablespaceSet().size(); ++i) {
                TableSpaceOracle ts = (TableSpaceOracle)segment.getStorageDesignOracle().getTableSpaceSet().getById((String)segment.getTablespaceSet().elementAt(i));
                if (ts == null) continue;
                SSBRollbackSegmentOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, ts.getStorageDesign().getFormatedName(ts));
            }
        }
    }

    private void appendStorage(StringBuffer buffer, RollbackSegmentOraclev9i segment, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBRollbackSegmentOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "STORAGE");
            SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, '(');
            boolean props = false;
            if (segment.getSCInitialExtent() > 0 && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                SSBRollbackSegmentOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                this.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, segment.getInitialSizeUnit());
                props = true;
            }
            if (segment.getSCNextExtent() > 0 && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                SSBRollbackSegmentOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, segment.getSCNextExtent());
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, segment.getNextSizeUnit());
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                SSBRollbackSegmentOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                this.appendStringWithSpace(buffer, segment.getSCMinExtents());
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBRollbackSegmentOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeOptimalInDDL()) {
                SSBRollbackSegmentOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "OPTIMAL");
                if ("".equalsIgnoreCase(segment.getScOptimal().trim())) {
                    SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, "NULL");
                } else {
                    SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, segment.getScOptimal());
                }
                props = true;
            }
            if (props) {
                SSBRollbackSegmentOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBRollbackSegmentOraclev9i.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof RollbackSegmentOraclev9i && ((RollbackSegmentOraclev9i)object).isMarkedGenerate();
    }
}

