/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.Domain;

public class EHDomain
extends ExportHandler {
    public EHDomain(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Domain_ID").append(",");
        sb.append("Domain_Name").append(",");
        sb.append("Num_Domain_ID").append(",");
        sb.append("Synonyms").append(",");
        sb.append("Logical_Type_ID").append(",");
        sb.append("Num_Logical_Type_ID").append(",");
        sb.append("T_Size").append(",");
        sb.append("T_Precision").append(",");
        sb.append("T_Scale").append(",");
        sb.append("Native_Type").append(",");
        sb.append("LT_Name");
        lines.add(sb.toString());
        Iterator it = this.getDesign().getDomainSet().iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            sb = new StringBuffer();
            sb.append(domain.getObjectID()).append(",");
            sb.append(this.replaceAndQuoteString(domain.getName())).append(",");
            sb.append(domain.getNumID()).append(",");
            sb.append(this.quotedString(domain.getSynonym())).append(",");
            sb.append(domain.getLogicalDatatype().getObjectID()).append(",");
            sb.append(domain.getLogicalDatatype().getNumID()).append(",");
            sb.append(domain.getSize()).append(",");
            sb.append(domain.getPrecision()).append(",");
            sb.append(domain.getScale()).append(",");
            sb.append(domain.getDataType().getName()).append(",");
            sb.append(domain.getLogicalDatatype().getName()).append(",");
            lines.add(sb.toString());
            this.getCsvExporter().addNote(domain.getObjectID(), domain.getNumID(), "Domain", domain.getNotes());
            this.getCsvExporter().addComment(domain.getObjectID(), domain.getNumID(), "Domain", domain.getComment());
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Domains.csv";
    }
}

