/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.Reorderable;
import oracle.javatools.ui.ReorderableBar;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.ResizeScrollPaneLayout;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.TextLayer;
import oracle.javatools.ui.builders.BuiltList;
import oracle.javatools.ui.builders.ListBuilder;
import oracle.javatools.ui.list.EmptyListTextLayer;
import oracle.javatools.ui.list.SimpleListModel;

class BuiltListImpl<T>
implements BuiltList<T> {
    protected JList list;
    protected JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fill"));
    protected JScrollPane scrollPane = new JScrollPane();
    protected ComponentWithTitlebar componentWithTitlebar;
    protected EmptyListTextLayer<JScrollPane> emptyLayer;
    protected SuperLabel hint;

    protected BuiltListImpl(final JList list, ListBuilder.ListInstructions instructions) {
        JLayer<JScrollPane> emptyListLayer;
        this.list = list;
        this.scrollPane.setViewportView(list);
        this.emptyLayer = new EmptyListTextLayer(list, "");
        JComponent content = emptyListLayer = new JLayer<JScrollPane>(this.scrollPane, this.emptyLayer);
        if (instructions.titlebar) {
            content = this.createTitlebarComponent(content);
        }
        if (instructions.resize) {
            this.scrollPane.setLayout(new ResizeScrollPaneLayout());
            content = new ResizeComponent(content);
        }
        this.contentPanel.add(content, "grow");
        if (instructions.reorder) {
            final ReorderableBar reorderComp = new ReorderableBar(new ReorderableAdapter(list.getSelectionModel(), (SimpleListModel)list.getModel()), true);
            list.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    reorderComp.setEnabled(list.isEnabled());
                }
            });
            this.contentPanel.add((Component)reorderComp, "dock east");
        }
        if (instructions.labelText != null) {
            String text = StringUtils.stripMnemonic((String)instructions.labelText);
            int code = StringUtils.getMnemonicKeyCode((String)instructions.labelText);
            JLabel label = new JLabel(text);
            if (code != 0) {
                label.setDisplayedMnemonic(code);
            }
            label.setLabelFor(list);
            if (instructions.titlebar) {
                this.getComponentWithTitlebar().setLabel(label);
            } else {
                this.contentPanel.add((Component)label, "dock north, gap bottom 4");
            }
        }
        if (instructions.hint != null) {
            this.hint = new SuperLabel(instructions.hint);
            this.hint.setLabelOverride(true);
            this.hint.setForeground(Colors.HINT_TEXT);
            this.hint.setPreferredWrapWidth(200);
            list.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BuiltListImpl.this.hint.setEnabled(list.isEnabled());
                }
            });
            this.contentPanel.add((Component)this.hint, "dock south");
        }
    }

    @Override
    public final JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public final JComponent getGUI() {
        return this.contentPanel;
    }

    @Override
    public TextLayer getEmptyTextLayer() {
        return this.emptyLayer;
    }

    @Override
    public final ComponentWithTitlebar getComponentWithTitlebar() {
        return this.componentWithTitlebar;
    }

    protected ComponentWithTitlebar createTitlebarComponent(JComponent component) {
        this.componentWithTitlebar = new ComponentWithTitlebar<JComponent>(component, null, new ControlBar());
        return this.componentWithTitlebar;
    }

    @Override
    public final JList getJList() {
        return this.list;
    }

    @Override
    public T getSelectedValue() {
        return (T)this.list.getSelectedValue();
    }

    @Override
    public List<T> getSelectedValues() {
        return Arrays.asList(this.list.getSelectedValues());
    }

    @Override
    public List<T> getListModel() {
        SimpleListModel model = (SimpleListModel)this.list.getModel();
        return model.asList();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
    }

    private static class ReorderableAdapter
    implements Reorderable {
        private SimpleListModel model;
        private ListSelectionModel selectionModel;

        private ReorderableAdapter(ListSelectionModel selectionModel, SimpleListModel model) {
            this.model = model;
            this.selectionModel = selectionModel;
        }

        @Override
        public void addSelectionListener(ListSelectionListener listener) {
            this.selectionModel.addListSelectionListener(listener);
        }

        @Override
        public void removeSelectionListener(ListSelectionListener listener) {
            this.selectionModel.removeListSelectionListener(listener);
        }

        public boolean isSelectionTopMobile() {
            return this.selectionModel.getMinSelectionIndex() > 0;
        }

        public boolean isSelectionBottomMobile() {
            return this.selectionModel.getMaxSelectionIndex() > -1 && this.selectionModel.getMaxSelectionIndex() < this.model.getSize() - 1;
        }

        public void moveSelectionTop() {
            int i = this.selectionModel.getMinSelectionIndex();
            this.model.moveTop(i);
            this.selectionModel.setSelectionInterval(0, 0);
        }

        public void moveSelectionBottom() {
            int i = this.selectionModel.getMaxSelectionIndex();
            this.model.moveBottom(i);
            this.selectionModel.setSelectionInterval(this.model.getSize() - 1, this.model.getSize() - 1);
        }

        public boolean isSelectionUpwardlyMobile() {
            return this.selectionModel.getMinSelectionIndex() > 0;
        }

        public boolean isSelectionDownwardlyMobile() {
            return this.selectionModel.getMaxSelectionIndex() > -1 && this.selectionModel.getMaxSelectionIndex() < this.model.getSize() - 1;
        }

        public void moveSelectionUp() {
            int i = this.selectionModel.getMinSelectionIndex();
            this.model.moveUp(i--);
            this.selectionModel.setSelectionInterval(i, i);
        }

        public void moveSelectionDown() {
            int i = this.selectionModel.getMaxSelectionIndex();
            this.model.moveDown(i++);
            this.selectionModel.setSelectionInterval(i, i);
        }
    }
}

