/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.Hoverable;
import oracle.javatools.icons.IconScaler;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ColorIcon;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.EmptyIcon;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.ui.plaf.FlatTabbedPaneUI;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;

public final class StatusIndicator {
    public static final int SIZE = 10;
    private static final Icon BLANK_ICON = new EmptyIcon(Status.access$000(Status.OK, OkPolicy.SHOW));
    public static final String PROPERTY_STATUS_INDICATOR = "status-indicator";
    public static final String PROPERTY_STATUS = "status";
    private Collection<WeakReference<StatusComp>> weakComponents = new CopyOnWriteArrayList<WeakReference<StatusComp>>();
    private Template template;
    private Status status = Status.UNKNOWN;
    private final List<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.add(listener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        for (PropertyChangeListener l : this.propertyChangeListeners) {
            l.propertyChange(propertyChangeEvent);
        }
    }

    public void setStatus(Status status) {
        Status oldStatus = this.status;
        this.status = status;
        for (WeakReference<StatusComp> compRef : this.weakComponents) {
            StatusComp comp = (StatusComp)compRef.get();
            if (comp == null) {
                this.weakComponents.remove(compRef);
                continue;
            }
            comp.setIcon(this.getIcon(comp.okPolicy));
        }
        this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_STATUS, (Object)oldStatus, (Object)status));
    }

    public Status getStatus() {
        return this.status;
    }

    public Icon getIcon(OkPolicy okPolicy) {
        Icon icon = this.status.getIcon(okPolicy);
        return icon;
    }

    public JComponent configureStandalone(OkPolicy okPolicy) {
        return new StatusComp(okPolicy);
    }

    public void configureTab(final JTabbedPane tabbedPane, int tabIndex) {
        final JPanel tabComp = new JPanel(new BorderLayout(2, 0));
        tabComp.putClientProperty(PROPERTY_STATUS_INDICATOR, this);
        JLabel label = new JLabel(tabbedPane.getTitleAt(tabIndex)){

            @Override
            public boolean isEnabled() {
                int i = tabbedPane.indexOfTabComponent(tabComp);
                if (i > -1) {
                    return tabbedPane.isEnabledAt(i);
                }
                return true;
            }
        };
        label.setIcon(tabbedPane.getIconAt(tabIndex));
        tabComp.add((Component)label, "Before");
        tabComp.add((Component)this.configureStandalone(OkPolicy.REMOVE), "After");
        tabComp.setOpaque(false);
        tabbedPane.setTabComponentAt(tabIndex, tabComp);
    }

    public JComponent configureLabel(JLabel label, Location location) {
        JPanel comp = new JPanel((LayoutManager)new MigLayout("ins 0, hidemode 3, nogrid"));
        switch (location) {
            case LEADING: {
                comp.add((Component)this.configureStandalone(OkPolicy.REMOVE), "");
                comp.add((Component)label, "");
                comp.setOpaque(false);
                break;
            }
            case DEFAULT: {
                comp.add((Component)label, "");
                comp.add((Component)this.configureStandalone(OkPolicy.REMOVE), "");
                comp.setOpaque(false);
            }
        }
        comp.putClientProperty(PROPERTY_STATUS_INDICATOR, this);
        label.putClientProperty(PROPERTY_STATUS_INDICATOR, this);
        return comp;
    }

    public void setInfoTipContent(Template template) {
        this.template = template;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setSize(460, 620);
        f.setLocationRelativeTo(null);
        f.setLayout((LayoutManager)new MigLayout("ins 2, hidemode 2"));
        final JComboBox<Status> combo = new JComboBox<Status>(Status.values());
        final StatusIndicator statusIndicator = new StatusIndicator();
        JComponent labelLeadingComp = statusIndicator.configureLabel(new JLabel("JLabel (Leading)"), Location.LEADING);
        JComponent labelDefaultComp = statusIndicator.configureLabel(new JLabel("JLabel (Default)"), Location.DEFAULT);
        ComponentWithTitlebar<JTree> cwt = new ComponentWithTitlebar<JTree>(new JTree(), new JLabel("Tree"), null);
        cwt.setStatusIndicator(statusIndicator);
        ReorderableTableWithTitleBar table = new ReorderableTableWithTitleBar(new JTable(new String[][]{{"The Prisoner", "3:48"}, {"Prowler", "2:45"}, {"Aces High", "3:12"}}, new String[]{"Name", "Length"}), true, true);
        table.getTableToolbar().setStatusIndicator(statusIndicator);
        table.getTableToolbar().setLabel("Tracks");
        table.getTableToolbar().setAddVisible(true);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Live", new JPanel());
        tabbedPane.addTab("After", new JPanel());
        tabbedPane.addTab("Death", new JPanel());
        tabbedPane.addTab("Is", new JPanel());
        tabbedPane.addTab("Great", new JPanel());
        statusIndicator.configureTab(tabbedPane, 1);
        statusIndicator.configureTab(tabbedPane, 4);
        tabbedPane.setEnabledAt(3, false);
        tabbedPane.setEnabledAt(4, false);
        JTabbedPane flatPane = new JTabbedPane();
        FlatTabbedPaneUI flatUI = new FlatTabbedPaneUI();
        flatPane.setUI(flatUI);
        flatPane.addTab("Living", new JPanel());
        flatPane.addTab("After", new JPanel());
        flatPane.addTab("Midnight", new JPanel());
        statusIndicator.configureTab(flatPane, 1);
        HeaderPanel<JLabel> headerPanel = new HeaderPanel<JLabel>(new JLabel("Help! Help! I'm in a nutshell"));
        headerPanel.getHeader().setExpandable(true);
        headerPanel.getHeader().setText("That's me in a nutshell");
        headerPanel.getHeader().setStatusIndicator(statusIndicator);
        headerPanel.setBackground(Color.WHITE);
        headerPanel.setOpaque(true);
        f.add(combo);
        f.add((Component)new JLabel("Standalone (one for each OK policy):"), "newline");
        f.add((Component)statusIndicator.configureStandalone(OkPolicy.SHOW), "");
        f.add((Component)statusIndicator.configureStandalone(OkPolicy.REMOVE), "newline, skip");
        f.add((Component)statusIndicator.configureStandalone(OkPolicy.HIDE), "newline, skip");
        f.add((Component)new JLabel("JLabel (Leading):"), "newline");
        f.add(labelDefaultComp);
        f.add((Component)new JLabel("JLabel (Default):"), "newline");
        f.add(labelLeadingComp);
        f.add((Component)new JLabel("Component With Titlebar:"), "newline");
        f.add(cwt, "w 300, h 100");
        f.add((Component)new JLabel("TableToolbar:"), "newline");
        f.add((Component)table, "w 300, h 50");
        f.add((Component)new JLabel("JTabbedPane:"), "newline");
        f.add((Component)tabbedPane, "w 300");
        f.add((Component)new JLabel("FlatTabbedPaneUI:"), "newline");
        f.add((Component)flatPane, "w 300, h 100");
        f.add((Component)new JLabel("Header:"), "newline");
        f.add(headerPanel, "w 120");
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Status status = (Status)((Object)combo.getSelectedItem());
                statusIndicator.setStatus(status);
            }
        });
        combo.setSelectedItem((Object)Status.ERROR);
        f.setVisible(true);
    }

    private class StatusComp
    extends JLabel
    implements Hoverable {
        private final OkPolicy okPolicy;

        StatusComp(OkPolicy okPolicy) {
            this.okPolicy = okPolicy;
            this.putClientProperty(StatusIndicator.PROPERTY_STATUS_INDICATOR, StatusIndicator.this);
            this.setIcon(StatusIndicator.this.getIcon(okPolicy));
            StatusIndicator.this.weakComponents.add(new WeakReference<StatusComp>(this));
        }

        @Override
        public void setIcon(Icon icon) {
            if (StatusIndicator.this.status == Status.OK && this.okPolicy == OkPolicy.REMOVE) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
            super.setIcon(icon);
        }

        public Hover hover(Point p, List<HoverFlavor> flavors) {
            if (StatusIndicator.this.template == null) {
                return null;
            }
            InfoTipHover hover = new InfoTipHover(StatusIndicator.this.template, InfoTipStyles.DEFAULT, (JComponent)this, new Rectangle(0, 0, this.getWidth(), this.getHeight()), HoverFlavor.getFlavor((String)"info"));
            hover.showHover();
            return hover;
        }
    }

    public static enum Location {
        LEADING,
        DEFAULT;

    }

    public static enum Status {
        BUSY,
        OK,
        INCOMPLETE,
        WARNING,
        ERROR,
        UNKNOWN;

        static ColorIcon incompleteIcon;
        static ColorIcon okIcon;
        static ColorIcon unknownIcon;

        private Icon getIcon(OkPolicy okPolicy) {
            switch (this) {
                case BUSY: {
                    return OracleIcons.getIcon((String)"gutter/throbber_small.gif");
                }
                case ERROR: {
                    return IconScaler.scaleIcon((Icon)OracleIcons.getIcon((String)"error.png"), (int)10);
                }
                case WARNING: {
                    return IconScaler.scaleIcon((Icon)OracleIcons.getIcon((String)"warning.png"), (int)10);
                }
                case OK: {
                    return okPolicy == OkPolicy.SHOW ? okIcon : BLANK_ICON;
                }
                case INCOMPLETE: {
                    return incompleteIcon;
                }
                case UNKNOWN: {
                    return unknownIcon;
                }
            }
            throw new IllegalStateException(this.name());
        }

        static {
            incompleteIcon = new ColorIcon(new Color(232, 113, 209), new Dimension(10, 10));
            okIcon = new ColorIcon(Color.GREEN, new Dimension(10, 10));
            unknownIcon = new ColorIcon(Color.WHITE, new Dimension(10, 10));
        }
    }

    public static enum OkPolicy {
        SHOW,
        HIDE,
        REMOVE;

    }
}

