/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.GraphicsUtils;
import oracle.javatools.ui.internal.UICUtils;

public final class ButtonMenu {
    private ButtonMenu() {
    }

    public static JToggleButton createButtonMenu(String buttonText, Icon buttonIcon, List<JMenuItem> items) {
        return ButtonMenu.createButtonMenu(buttonText, buttonIcon, items, null);
    }

    public static JToggleButton createButtonMenu(String buttonText, Icon buttonIcon, List<JMenuItem> items, PopupMenuListener listener) {
        return new ButtonMenuImpl(buttonText, buttonIcon, items, listener);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        items.add(new JMenuItem("Item 1"));
        items.add(new JMenuItem("Item 2"));
        items.add(new JMenuItem("Item 3"));
        JPanel testPanel = new JPanel();
        testPanel.add(new JTextField(12));
        testPanel.add(ButtonMenu.createButtonMenu("Text", OracleIcons.getIcon((String)"action.png"), items));
        ArrayList<JMenuItem> items2 = new ArrayList<JMenuItem>();
        items2.add(new JMenuItem("Item 1"));
        items2.add(new JMenuItem("Item 2"));
        items2.add(new JMenuItem("Item 3"));
        testPanel.add(ButtonMenu.createButtonMenu("Text", null, items2));
        ArrayList<JMenuItem> items3 = new ArrayList<JMenuItem>();
        items3.add(new JMenuItem("Item 1"));
        items3.add(new JMenuItem("Item 2"));
        items3.add(new JMenuItem("Item 3"));
        testPanel.add(ButtonMenu.createButtonMenu(null, OracleIcons.getIcon((String)"action.png"), items3));
        UICUtils.runComponent(testPanel);
        ArrayList<JMenuItem> items4 = new ArrayList<JMenuItem>();
        items4.add(new JMenuItem("Item 1"));
        items4.add(new JMenuItem("Item 2"));
        items4.add(new JMenuItem("Item 3"));
        testPanel.add(ButtonMenu.createButtonMenu(null, null, items4));
        UICUtils.runComponent(testPanel);
    }

    private static class ButtonMenuImpl
    extends JToggleButton {
        private static final Insets ICON_INSETS = new Insets(0, 0, 0, 4);
        private static final Insets TEXT_INSETS = new Insets(0, 2, 0, 2);
        private final PopupMenuListener listener;
        private final JPopupMenu popup = new JPopupMenu();
        private final Icon dropIcon;
        private static final int dropIconGap = 2;
        private static final int dropTextGap = 4;
        private final List<JMenuItem> items;

        ButtonMenuImpl(String buttonText, Icon buttonIcon, List<JMenuItem> items, PopupMenuListener listener) {
            super(buttonText, buttonIcon);
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    if (listener != null) {
                        listener.popupMenuWillBecomeInvisible(new PopupMenuEvent(this));
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    if (listener != null) {
                        listener.popupMenuCanceled(new PopupMenuEvent(this));
                    }
                }
            });
            this.dropIcon = OracleIcons.getIcon((String)"extras/dropdown.png");
            this.items = items;
            this.listener = listener;
            this.setMargin(buttonText == null ? ICON_INSETS : TEXT_INSETS);
            this.setHorizontalAlignment(2);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.toggle();
                }
            });
        }

        private void toggle() {
            if (this.isSelected()) {
                this.popup.removeAll();
                if (this.listener != null) {
                    this.listener.popupMenuWillBecomeVisible(new PopupMenuEvent(this));
                }
                this.createPopup(this.items);
                this.popup.pack();
                Point p = GraphicsUtils.computePopupLocation(this.popup, this);
                this.popup.show(this, p.x, p.y);
            } else if (this.popup.isVisible()) {
                this.popup.setVisible(false);
                this.popup.removeAll();
            }
        }

        private void createPopup(List<JMenuItem> items) {
            for (JMenuItem item : items) {
                if (item == null) {
                    this.popup.addSeparator();
                    continue;
                }
                this.popup.add(item);
            }
            this.popup.addPropertyChangeListener("visible", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!popup.isVisible() && this.isSelected()) {
                        this.setSelected(false);
                    }
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.dropIcon.paintIcon(this, g, this.getWidth() - this.getInsets().right - this.dropIcon.getIconWidth(), this.getHeight() / 2 - this.dropIcon.getIconHeight() / 2);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = d.width + (this.dropIcon.getIconWidth() + (this.getText() == null ? 2 : 4));
            d.height = Math.max(d.height, 20);
            return d;
        }
    }
}

