/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.preferences.BuildTextPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.preferences.PreferencesLrb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.JCheckCombo;

public class TextSettingsPreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private boolean _isAdjusting = false;
    private boolean _isAllSelected = false;
    private boolean _isNoneSelected = false;
    private static String LANG_ALL = DialogsLrb.get("BUILDTEXT_LANGUAGE_ALL");
    private static String LANG_NONE = DialogsLrb.get("BUILDTEXT_LANGUAGE_NONE");
    private JLabel jCategoricalCutoffValueLabel;
    private JSpinner jCategoricalCutoffValueSpinner;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JCheckBox jStemmingCheckBox;
    private JComboBox jThemeLanguageComboBox;
    private JLabel jThemeLanguageLabel;
    private JLabel jThemeMaxAllDocsLabel;
    private JSpinner jThemeMaxAllDocsSpinner;
    private JComboBox jThemeStoplistComboBox;
    private JLabel jThemeStoplistLabel;
    private JLabel jThemeTokensLabel;
    private JCheckCombo jTokenLanguageComboBox;
    private JLabel jTokenLanguageLabel;
    private JLabel jTokenMaxAllDocsLabel;
    private JSpinner jTokenMaxAllDocsSpinner;
    private JComboBox jTokenStoplistComboBox;
    private JLabel jTokenStoplistLabel;
    private JLabel jTokenTokensLabel;
    private JComboBox jTransformTypeComboBox;
    private JLabel jTransformTypeLabel;

    public TextSettingsPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jCategoricalCutoffValueLabel = new JLabel();
        this.jCategoricalCutoffValueSpinner = new JSpinner();
        this.jTransformTypeLabel = new JLabel();
        this.jTransformTypeComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jTokenLanguageLabel = new JLabel();
        this.jTokenLanguageComboBox = new JCheckCombo();
        this.jStemmingCheckBox = new JCheckBox();
        this.jTokenStoplistLabel = new JLabel();
        this.jTokenStoplistComboBox = new JComboBox();
        this.jTokenTokensLabel = new JLabel();
        this.jTokenMaxAllDocsLabel = new JLabel();
        this.jTokenMaxAllDocsSpinner = new JSpinner();
        this.jPanel2 = new JPanel();
        this.jThemeLanguageLabel = new JLabel();
        this.jThemeLanguageComboBox = new JComboBox();
        this.jThemeStoplistLabel = new JLabel();
        this.jThemeStoplistComboBox = new JComboBox();
        this.jThemeTokensLabel = new JLabel();
        this.jThemeMaxAllDocsLabel = new JLabel();
        this.jThemeMaxAllDocsSpinner = new JSpinner();
        this.jCategoricalCutoffValueLabel.setText("Categorical cutoff value:");
        this.jTransformTypeLabel.setText("Default Transform Type:");
        this.jTransformTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Token Transform Settings"));
        this.jTokenLanguageLabel.setLabelFor((Component)this.jTokenLanguageComboBox);
        this.jTokenLanguageLabel.setText("Languages:");
        this.jTokenLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTokenLanguageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsPreferencesPanel.this.jTokenLanguageComboBoxActionPerformed(actionEvent);
            }
        });
        this.jStemmingCheckBox.setText("Stemming");
        this.jTokenStoplistLabel.setLabelFor(this.jTokenStoplistComboBox);
        this.jTokenStoplistLabel.setText("Stoplists:");
        this.jTokenStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTokenTokensLabel.setText("Tokens:");
        this.jTokenMaxAllDocsLabel.setLabelFor(this.jTokenMaxAllDocsSpinner);
        this.jTokenMaxAllDocsLabel.setText("Max number across all documents");
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jTokenLanguageLabel, -1, 104, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jTokenLanguageComboBox, -2, 160, -2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jStemmingCheckBox, -1, 82, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTokenStoplistLabel, -1, 104, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.jTokenStoplistComboBox, -2, 160, -2)).addComponent(this.jTokenTokensLabel, -1, 268, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jTokenMaxAllDocsLabel, -1, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokenMaxAllDocsSpinner, -2, 85, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTokenLanguageLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jTokenLanguageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jStemmingCheckBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTokenStoplistLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jTokenStoplistComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokenTokensLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTokenMaxAllDocsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jTokenMaxAllDocsSpinner, -2, -1, -2)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Theme Transform Settings"));
        this.jThemeLanguageLabel.setLabelFor(this.jThemeLanguageComboBox);
        this.jThemeLanguageLabel.setText("Languages:");
        this.jThemeLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jThemeStoplistLabel.setLabelFor(this.jThemeStoplistComboBox);
        this.jThemeStoplistLabel.setText("Stoplists:");
        this.jThemeStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jThemeTokensLabel.setText("Tokens:");
        this.jThemeMaxAllDocsLabel.setLabelFor(this.jThemeMaxAllDocsSpinner);
        this.jThemeMaxAllDocsLabel.setText("Max number across all documents");
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jThemeMaxAllDocsLabel, -1, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jThemeMaxAllDocsSpinner, -2, 85, -2)).addComponent(this.jThemeTokensLabel, -1, 268, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jThemeStoplistLabel, -1, 104, Short.MAX_VALUE).addComponent(this.jThemeLanguageLabel, -1, 104, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jThemeLanguageComboBox, GroupLayout.Alignment.TRAILING, -2, 160, -2).addComponent(this.jThemeStoplistComboBox, GroupLayout.Alignment.TRAILING, -2, 160, -2)))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jThemeLanguageLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jThemeLanguageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jThemeStoplistLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jThemeStoplistComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jThemeTokensLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jThemeMaxAllDocsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jThemeMaxAllDocsSpinner, -2, -1, -2)).addContainerGap()));
        GroupLayout groupLayout3 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel1, -2, -1, -2).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCategoricalCutoffValueLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jTransformTypeLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCategoricalCutoffValueSpinner, -2, 130, -2).addComponent(this.jTransformTypeComboBox, -2, 130, -2)))).addGap(25, 25, 25)));
        groupLayout3.linkSize(0, this.jCategoricalCutoffValueSpinner, this.jTransformTypeComboBox);
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCategoricalCutoffValueLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jCategoricalCutoffValueSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTransformTypeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jTransformTypeComboBox, -2, -1, -2)).addGap(38, 38, 38).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
    }

    private void jTokenLanguageComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void initUI() {
        this.jTransformTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.TextTransformType.toHuman("Token"), ServerConstants.TextTransformType.toHuman("Theme")}));
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("All"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("None"));
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG object2 : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG.values()) {
            defaultListModel.addElement(object2.value());
        }
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.addSelectionInterval(1, 1);
        CheckComboModel checkComboModel = new CheckComboModel(defaultListModel, (ListSelectionModel)defaultListSelectionModel);
        this.jTokenLanguageComboBox.setModel(checkComboModel);
        ListSelectionModel listSelectionModel = this.jTokenLanguageComboBox.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TextSettingsPreferencesPanel.this.jLanguageValueChanged(listSelectionEvent);
                }
            }
        });
        this.jTokenStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.StoplistLanguage.toHuman("Default"), ServerConstants.StoplistLanguage.toHuman("None")}));
        Vector<String> vector = new Vector<String>();
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG_SINGLE_BYTE bASIC_LEXER_LANG_SINGLE_BYTE : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG_SINGLE_BYTE.values()) {
            vector.add(bASIC_LEXER_LANG_SINGLE_BYTE.value());
        }
        this.jThemeLanguageComboBox.setModel(new DefaultComboBoxModel(vector));
        this.jThemeStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.StoplistLanguage.toHuman("Default"), ServerConstants.StoplistLanguage.toHuman("None")}));
    }

    private void jLanguageValueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray;
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        CheckComboModel checkComboModel = this.jTokenLanguageComboBox.getCheckModel();
        for (Object object : objectArray = checkComboModel.getSelectedItem()) {
            String string = (String)object;
            if (!this._isNoneSelected && string.equals(LANG_NONE)) {
                listSelectionModel.clearSelection();
                listSelectionModel.addSelectionInterval(1, 1);
                this._isNoneSelected = true;
                this._isAllSelected = false;
                break;
            }
            if (!this._isAllSelected && string.equals(LANG_ALL)) {
                listSelectionModel.removeSelectionInterval(1, 1);
                listSelectionModel.addSelectionInterval(2, checkComboModel.getSize() - 1);
                this._isAllSelected = true;
                this._isNoneSelected = false;
                break;
            }
            listSelectionModel.removeSelectionInterval(0, 0);
            this._isAllSelected = false;
            listSelectionModel.removeSelectionInterval(1, 1);
            this._isNoneSelected = false;
        }
        this._isAdjusting = false;
    }

    @Override
    public void initRes() {
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(PreferencesLrb.get("TEXT_TOKEN_TRANSFORM_SETTING")));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(PreferencesLrb.get("TEXT_THEME_TRANSFORM_SETTING")));
        this.jStemmingCheckBox.setText(PreferencesLrb.get("TEXT_STEMMING"));
        this.jTokenTokensLabel.setText(PreferencesLrb.get("TEXT_TOKENS"));
        this.jThemeTokensLabel.setText(PreferencesLrb.get("TEXT_THEMES"));
        ResourceUtils.resSpinner((JLabel)this.jCategoricalCutoffValueLabel, (JSpinner)this.jCategoricalCutoffValueSpinner, (String)PreferencesLrb.get("TEXT_CAT_CUTOFF_VALUE"));
        ResourceUtils.resLabel((JLabel)this.jTransformTypeLabel, (Component)this.jTransformTypeComboBox, (String)PreferencesLrb.get("TEXT_DEFAULT_TRANSFORM_TYPE"));
        ResourceUtils.resLabel((JLabel)this.jTokenLanguageLabel, (Component)this.jTokenLanguageComboBox, (String)PreferencesLrb.get("TEXT_LANGUAGES"));
        ResourceUtils.resLabel((JLabel)this.jTokenStoplistLabel, (Component)this.jTokenStoplistComboBox, (String)PreferencesLrb.get("TEXT_STOPLISTS"));
        ResourceUtils.resSpinner((JLabel)this.jTokenMaxAllDocsLabel, (JSpinner)this.jTokenMaxAllDocsSpinner, (String)PreferencesLrb.get("TEXT_MAX_NUM_ALL_DOCS"));
        ResourceUtils.resLabel((JLabel)this.jThemeLanguageLabel, (Component)this.jThemeLanguageComboBox, (String)PreferencesLrb.get("TEXT_LANGUAGES"));
        ResourceUtils.resLabel((JLabel)this.jThemeStoplistLabel, (Component)this.jThemeStoplistComboBox, (String)PreferencesLrb.get("TEXT_STOPLISTS"));
        ResourceUtils.resSpinner((JLabel)this.jThemeMaxAllDocsLabel, (JSpinner)this.jThemeMaxAllDocsSpinner, (String)PreferencesLrb.get("TEXT_MAX_NUM_ALL_DOCS"));
        this.setHelpID("preferences_text");
    }

    public void onEntry(TraversableContext traversableContext) {
        BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = TextSettingsPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this.jCategoricalCutoffValueSpinner.setModel(new SpinnerNumberModel(buildTextPreferencesPanelSettings.getCategoricalCutoffValue(), 1, 32000, 10));
        this.jTransformTypeComboBox.setSelectedItem(ServerConstants.TextTransformType.toHuman(buildTextPreferencesPanelSettings.getTransformType()));
        ListSelectionModel listSelectionModel = this.jTokenLanguageComboBox.getSelectionModel();
        listSelectionModel.clearSelection();
        CheckComboModel checkComboModel = this.jTokenLanguageComboBox.getCheckModel();
        boolean bl = false;
        for (String string : buildTextPreferencesPanelSettings.getTokenLanguages()) {
            for (int i = 0; i < checkComboModel.getSize(); ++i) {
                String string2 = (String)checkComboModel.getElementAt(i);
                if (!string2.equals(ServerConstants.StoplistLanguage.toHuman(string))) continue;
                listSelectionModel.addSelectionInterval(i, i);
                bl = true;
            }
        }
        if (!bl) {
            listSelectionModel.addSelectionInterval(1, 1);
        }
        this.jStemmingCheckBox.setSelected(buildTextPreferencesPanelSettings.useStemming());
        this.jTokenStoplistComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(buildTextPreferencesPanelSettings.getTokenStoplist()));
        this.jTokenMaxAllDocsSpinner.setModel(new SpinnerNumberModel(buildTextPreferencesPanelSettings.getTokenMaxNumAllDocs(), 1, 100000, 1000));
        this.jThemeLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(buildTextPreferencesPanelSettings.getThemeLanguages().get(0)));
        this.jThemeStoplistComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(buildTextPreferencesPanelSettings.getThemeStoplist()));
        this.jThemeMaxAllDocsSpinner.setModel(new SpinnerNumberModel(buildTextPreferencesPanelSettings.getThemeMaxNumAllDocs(), 1, 100000, 1000));
    }

    public void onExit(TraversableContext traversableContext) {
        BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = TextSettingsPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        buildTextPreferencesPanelSettings.setCategoricalCutoffValue((Integer)this.jCategoricalCutoffValueSpinner.getValue());
        buildTextPreferencesPanelSettings.setTransformType(ServerConstants.TextTransformType.toSchema((String)this.jTransformTypeComboBox.getSelectedItem()));
        CheckComboModel checkComboModel = this.jTokenLanguageComboBox.getCheckModel();
        Object[] objectArray = checkComboModel.getSelectedItem();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : objectArray) {
            String string = (String)object;
            if (string.equals(LANG_ALL) || string.equals(LANG_NONE)) continue;
            arrayList.add(ServerConstants.StoplistLanguage.toSchema(string));
        }
        if (arrayList.size() == 0) {
            arrayList.add(ServerConstants.StoplistLanguage.toSchema("ENGLISH"));
        }
        buildTextPreferencesPanelSettings.setTokenLanguages(arrayList);
        buildTextPreferencesPanelSettings.setStemming(this.jStemmingCheckBox.isSelected());
        buildTextPreferencesPanelSettings.setTokenStoplist(ServerConstants.StoplistLanguage.toSchema((String)this.jTokenStoplistComboBox.getSelectedItem()));
        buildTextPreferencesPanelSettings.setTokenMaxNumAllDocs((Integer)this.jTokenMaxAllDocsSpinner.getValue());
        arrayList.clear();
        arrayList.add(ServerConstants.StoplistLanguage.toSchema((String)this.jThemeLanguageComboBox.getSelectedItem()));
        buildTextPreferencesPanelSettings.setThemeLanguages(arrayList);
        buildTextPreferencesPanelSettings.setThemeStoplist(ServerConstants.StoplistLanguage.toSchema((String)this.jThemeStoplistComboBox.getSelectedItem()));
        buildTextPreferencesPanelSettings.setThemeMaxNumAllDocs((Integer)this.jThemeMaxAllDocsSpinner.getValue());
    }

    private static BuildTextPreferencesPanelSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return BuildTextPreferencesPanelSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

