/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.PredictionFunctionsHelper;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.DynamicHelper;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumns;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicPredictionNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetAttributes;
import oracle.ide.Context;

public class DynamicPredictionNode
extends DynamicNode {
    private static final Logger theLogger = Logger.getLogger(DynamicPredictionNode.class.getName());
    private String PREDICTION_TEMPLATE = null;
    public static final String PREDICTION_NODE_INPUT_COLUMNS = "PREDICTION_NODE_INPUT_COLUMNS";
    public static final String TARGETS_PREDICTIONS = "Target_Prediction";
    public static final String TARGETS_PREDICTIONS_COLUMNS = "target_columns";
    public static final String TARGETS_PREDICTIONS_PREDICTIONS = "predictions";
    public static final String TARGETS_PREDICTIONS_SUPPLEMENTAL = "target_derived_supplementals";
    public static final String MINING_TYPE_CHANGE = "Mining Type";
    public static final String INPUT_LIST_FOR_TARGET_ = "INPUT_LIST_FOR_TARGET_";
    private static String _ALL_TARGETS = "SELECT TARGET_ATTR, STR_VALUE, NUM_VALUE FROM ";
    private Map<String, Vector<Object>> results = null;

    public DynamicPredictionNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        this.PREDICTION_TEMPLATE = "SELECT " + (SQLHelper.generateSQLInlineHint(context) ? "/*+ inline */" : "") + "<SUPPLEMENTAL_DATA>" + "\n" + "<DYNAMIC_PREDICTION_CODE>" + "FROM {INPUT_SOURCE}\n";
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_DYNAMIC_PREDICTION_NODE_NAME");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_DYNAMIC_PREDICTION_NODE_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_DYNAMIC_PREDICTION_NODE_ICON"));
    }

    @Override
    public DynamicNodeBaseSettingsType getDynamicNodeBaseSettingsType() {
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        return dynamicPredictionNodeType.getDynamicNodeBaseSettings();
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = new DynamicNodeBaseSettingsType();
        PredictionAttributesType predictionAttributesType = new PredictionAttributesType();
        TargetAttributes targetAttributes = new TargetAttributes();
        targetAttributes.getMiningAttribute();
        predictionAttributesType.setTargetAttributes(targetAttributes);
        dynamicPredictionNodeType.setPredictionAttributes(predictionAttributesType);
        CaseAttributes caseAttributes = new CaseAttributes();
        caseAttributes.getAttribute();
        dynamicNodeBaseSettingsType.setCaseAttributes(caseAttributes);
        MiningAttributes miningAttributes = new MiningAttributes();
        miningAttributes.getMiningAttribute();
        miningAttributes.setAutoSpec(AutoSpecType.YES);
        dynamicNodeBaseSettingsType.setMiningAttributes(miningAttributes);
        PartitionExpressions partitionExpressions = new PartitionExpressions();
        partitionExpressions.getPartitionExpression();
        dynamicNodeBaseSettingsType.setPartitionExpressions(partitionExpressions);
        DynamicApplyOutputColumns dynamicApplyOutputColumns = new DynamicApplyOutputColumns();
        dynamicApplyOutputColumns.getDynamicApplyOutputColumn();
        dynamicNodeBaseSettingsType.setDynamicApplyOutputColumns(dynamicApplyOutputColumns);
        SupplementalAttributesType supplementalAttributesType = new SupplementalAttributesType();
        supplementalAttributesType.getAttribute();
        supplementalAttributesType.setAutoSpec(AutoSpecType.YES);
        dynamicNodeBaseSettingsType.setSupplementalAttributes(supplementalAttributesType);
        dynamicPredictionNodeType.setDynamicNodeBaseSettings(dynamicNodeBaseSettingsType);
        dynamicPredictionNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        dynamicPredictionNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        Object object;
        String string;
        AttributeType attributeType2;
        if (!(node instanceof DataProvider)) {
            return;
        }
        super.handleNewConnectionFrom(node);
        Attributes attributes = ((DataProvider)((Object)node)).getAttributes();
        List list = attributes.getAttribute();
        HashMap<Object, AttributeType> hashMap = new HashMap<Object, AttributeType>();
        for (AttributeType attributeType2 : list) {
            string = attributeType2.getAlias();
            object = string != null && string.trim().length() > 0 ? string : attributeType2.getName();
            hashMap.put(object, attributeType2);
        }
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        attributeType2 = this.getDynamicNodeBaseSettingsType();
        string = attributeType2.getMiningAttributes();
        object = string.getMiningAttribute();
        SupplementalAttributesType supplementalAttributesType = attributeType2.getSupplementalAttributes();
        supplementalAttributesType.getAttribute();
        CaseAttributes caseAttributes = attributeType2.getCaseAttributes();
        caseAttributes.getAttribute();
        PartitionExpressions partitionExpressions = attributeType2.getPartitionExpressions();
        partitionExpressions.getPartitionExpression();
        PredictionAttributesType predictionAttributesType = dynamicPredictionNodeType.getPredictionAttributes();
        TargetAttributes targetAttributes = predictionAttributesType.getTargetAttributes();
        targetAttributes.getMiningAttribute();
        if (object.isEmpty()) {
            string.setAutoSpec(AutoSpecType.YES);
            this.copyAttributes((List<MiningAttributeType>)object, list);
            DynamicPredictHelper dynamicPredictHelper = new DynamicPredictHelper((MiningAttributes)string, supplementalAttributesType, targetAttributes, caseAttributes, partitionExpressions);
            this.updateAllColumnsTxn(dynamicPredictHelper, new DynamicPredictHelper());
            this.validate(true);
        } else {
            DynamicPredictHelper dynamicPredictHelper = new DynamicPredictHelper((MiningAttributes)string, supplementalAttributesType, targetAttributes, caseAttributes, partitionExpressions);
            DynamicPredictHelper dynamicPredictHelper2 = this.copyPreviousState((MiningAttributes)string, supplementalAttributesType, targetAttributes, caseAttributes, partitionExpressions);
            this.updateStatusFromDataProvider();
            this.updateAllColumnsTxn(dynamicPredictHelper, dynamicPredictHelper2);
            this.validateSimple(true);
        }
    }

    private DynamicPredictHelper copyPreviousState(MiningAttributes miningAttributes, SupplementalAttributesType supplementalAttributesType, TargetAttributes targetAttributes, CaseAttributes caseAttributes, PartitionExpressions partitionExpressions) {
        Object object4;
        Object object22;
        Object object32;
        MiningAttributes miningAttributes2 = new MiningAttributes();
        miningAttributes2.setAutoSpec(miningAttributes.getAutoSpec());
        for (Object object32 : miningAttributes.getMiningAttribute()) {
            object22 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object32);
            miningAttributes2.getMiningAttribute().add(object22);
        }
        SupplementalAttributesType supplementalAttributesType2 = new SupplementalAttributesType();
        supplementalAttributesType2.setAutoSpec(supplementalAttributesType.getAutoSpec());
        for (Object object22 : supplementalAttributesType.getAttribute()) {
            object4 = (AttributeType)MetaDataHelper.copyMetadataObject(object22);
            supplementalAttributesType2.getAttribute().add(object4);
        }
        object32 = new TargetAttributes();
        for (Object object4 : targetAttributes.getMiningAttribute()) {
            Object object5 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object4);
            object32.getMiningAttribute().add(object5);
        }
        object22 = new CaseAttributes();
        for (Object object5 : caseAttributes.getAttribute()) {
            AttributeType attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(object5);
            object22.getAttribute().add(attributeType);
        }
        object4 = new PartitionExpressions();
        for (AttributeType attributeType : partitionExpressions.getPartitionExpression()) {
            PartitionExpressionType partitionExpressionType = (PartitionExpressionType)MetaDataHelper.copyMetadataObject(attributeType);
            object4.getPartitionExpression().add(partitionExpressionType);
        }
        return new DynamicPredictHelper(miningAttributes2, supplementalAttributesType2, (TargetAttributes)object32, (CaseAttributes)object22, (PartitionExpressions)object4);
    }

    @Override
    protected boolean performValidation() {
        boolean bl = true;
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        PredictionAttributesType predictionAttributesType = dynamicPredictionNodeType.getPredictionAttributes();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        if (predictionAttributesType.getTargetAttributes() == null || predictionAttributesType.getTargetAttributes().getMiningAttribute().isEmpty()) {
            bl = false;
            this.addMessage("DYNAMIC_PREDICTION_NODE_NO_TARGETS", MessageEnumType.ERROR, new String[0]);
        }
        if (bl) {
            if (!dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute().isEmpty()) {
                for (AttributeType attributeType : dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute()) {
                    if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                    bl = false;
                    this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_INPUT_ATTR", MessageEnumType.WARNING, new String[0]);
                    break;
                }
            } else {
                bl = false;
                this.addMessage("DYNAMIC_PREDICTION_NODE_NO_INPUTS", MessageEnumType.WARNING, new String[0]);
            }
        }
        if (bl) {
            for (AttributeType attributeType : dynamicNodeBaseSettingsType.getSupplementalAttributes().getAttribute()) {
                if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = false;
                this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_SUPPL_ATTR", MessageEnumType.WARNING, new String[0]);
                break;
            }
        }
        if (bl) {
            for (AttributeType attributeType : predictionAttributesType.getTargetAttributes().getMiningAttribute()) {
                if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = false;
                this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_TARGET_ATTR", MessageEnumType.WARNING, new String[0]);
                break;
            }
        }
        if (bl) {
            for (AttributeType attributeType : dynamicNodeBaseSettingsType.getCaseAttributes().getAttribute()) {
                if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = false;
                this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_CASE_ATTR", MessageEnumType.WARNING, new String[0]);
                break;
            }
        }
        if (bl) {
            for (AttributeType attributeType : dynamicNodeBaseSettingsType.getPartitionExpressions().getPartitionExpression()) {
                AttributeType attributeType2;
                if (null != attributeType.getSQLExpression() || (attributeType2 = attributeType.getPartitionAttribute()).getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = false;
                this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_PARTITION_ATTR", MessageEnumType.WARNING, new String[0]);
                break;
            }
        }
        return bl;
    }

    protected void convertNestedVarcharTypes() {
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        boolean bl = SQLHelper.isExtendedTypeEnabled(this.getContext());
        PredictionAttributesType predictionAttributesType = dynamicPredictionNodeType.getPredictionAttributes();
        if (predictionAttributesType.getTargetAttributes() != null && !predictionAttributesType.getTargetAttributes().getMiningAttribute().isEmpty()) {
            for (MiningAttributeType miningAttributeType : predictionAttributesType.getTargetAttributes().getMiningAttribute()) {
                if (!miningAttributeType.getDataType().equals("ODMR_NESTED_VARCHAR2") && !miningAttributeType.getDataType().equals("ODMR_NESTED_VARCHAR2_EX")) continue;
                this.convertExType((AttributeType)miningAttributeType, bl);
            }
        }
        this.convertNestedVarcharTypes(bl);
    }

    @Override
    public boolean validate(boolean bl) {
        boolean bl2 = super.validate(bl);
        this.convertNestedVarcharTypes();
        bl2 = this.performValidation();
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        PredictionAttributesType predictionAttributesType = dynamicPredictionNodeType.getPredictionAttributes();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        DynamicPredictHelper dynamicPredictHelper = this.copyPreviousState(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), predictionAttributesType.getTargetAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions());
        this.updateStatusFromDataProvider();
        DynamicPredictHelper dynamicPredictHelper2 = new DynamicPredictHelper(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), predictionAttributesType.getTargetAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions());
        this.updateAllColumnsTxn(dynamicPredictHelper2, dynamicPredictHelper);
        bl2 = this.performValidation();
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    @Override
    protected void updateStatusFromDataProvider() {
        Object object;
        Object object22;
        Object object3;
        List list;
        SupplementalAttributesType supplementalAttributesType2;
        List list2;
        PartitionExpressions partitionExpressions2;
        Object object4;
        List list3;
        Object object5;
        String string;
        String string2;
        AttributeType attributeType2;
        AbstractNode abstractNode = this.findParentNode();
        Attributes attributes = null;
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        if (dataProvider != null) {
            attributes = dataProvider.getAttributes();
        }
        List list4 = attributes != null ? attributes.getAttribute() : new ArrayList();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType2 : list4) {
            string2 = attributeType2.getAlias();
            string = string2 != null && string2.trim().length() > 0 ? string2 : attributeType2.getName();
            hashMap.put(string, attributeType2);
        }
        HashMap hashMap2 = new HashMap();
        attributeType2 = (DynamicPredictionNodeType)this.getData();
        string2 = this.getDynamicNodeBaseSettingsType();
        string = attributeType2.getPredictionAttributes();
        TargetAttributes targetAttributes = string.getTargetAttributes();
        if (!targetAttributes.getMiningAttribute().isEmpty()) {
            object5 = targetAttributes.getMiningAttribute().iterator();
            while (object5.hasNext()) {
                list3 = (MiningAttributeType)object5.next();
                hashMap2.put(list3.getName(), list3);
                object4 = (AttributeType)hashMap.get(list3.getName());
                if (null == object4) {
                    list3.setStatus(AttributeStatus.MISSING);
                    continue;
                }
                if (!AttributeTypeHelper.areCompatibleTypes(object4.getDataType(), list3.getDataType())) {
                    list3.setStatus(AttributeStatus.INVALID);
                    continue;
                }
                list3.setStatus(object4.getStatus());
            }
        }
        if (!(list3 = (object5 = string2.getCaseAttributes()).getAttribute()).isEmpty()) {
            for (PartitionExpressions partitionExpressions2 : list3) {
                hashMap2.put(partitionExpressions2.getName(), partitionExpressions2);
                list2 = (AttributeType)hashMap.get(partitionExpressions2.getName());
                if (null == list2) {
                    partitionExpressions2.setStatus(AttributeStatus.MISSING);
                    continue;
                }
                if (!AttributeTypeHelper.areCompatibleTypes(list2.getDataType(), partitionExpressions2.getDataType())) {
                    partitionExpressions2.setStatus(AttributeStatus.INVALID);
                    continue;
                }
                partitionExpressions2.setStatus(list2.getStatus());
            }
        }
        object4 = new HashMap();
        partitionExpressions2 = string2.getPartitionExpressions();
        list2 = partitionExpressions2.getPartitionExpression();
        if (!list2.isEmpty()) {
            for (SupplementalAttributesType supplementalAttributesType2 : list2) {
                list = supplementalAttributesType2.getPartitionAttribute();
                hashMap2.put(list.getName(), list);
                if (null != supplementalAttributesType2.getSQLExpression()) {
                    object4.put(list.getName(), supplementalAttributesType2.getSQLExpression());
                    continue;
                }
                object3 = (AttributeType)hashMap.get(list.getName());
                if (null == object3) {
                    list.setStatus(AttributeStatus.MISSING);
                    continue;
                }
                if (!AttributeTypeHelper.areCompatibleTypes(object3.getDataType(), list.getDataType())) {
                    list.setStatus(AttributeStatus.INVALID);
                    continue;
                }
                list.setStatus(object3.getStatus());
            }
        }
        ArrayList arrayList = new ArrayList();
        supplementalAttributesType2 = string2.getSupplementalAttributes();
        list = supplementalAttributesType2.getAttribute();
        if (!list.isEmpty()) {
            for (Object object22 : list) {
                object = (AttributeType)hashMap.get(object22.getName());
                if (null == object) {
                    if (null == hashMap2.get(object22.getName())) {
                        arrayList.add(object22);
                        continue;
                    }
                    if (null != object4.get(object22.getName())) continue;
                    object22.setStatus(AttributeStatus.INVALID);
                    continue;
                }
                if (!AttributeTypeHelper.areCompatibleTypes(object.getDataType(), object22.getDataType())) {
                    object22.setStatus(AttributeStatus.INVALID);
                    continue;
                }
                object22.setStatus(object.getStatus());
            }
        }
        if (!arrayList.isEmpty()) {
            this.removeMissingSupplColumns((DynamicNodeBaseSettingsType)string2, arrayList);
        }
        object3 = string2.getMiningAttributes().getMiningAttribute();
        object22 = new ArrayList();
        object = object3.iterator();
        while (object.hasNext()) {
            MiningAttributeType miningAttributeType = (MiningAttributeType)object.next();
            AttributeType attributeType3 = (AttributeType)hashMap.get(miningAttributeType.getName());
            if (null == attributeType3) {
                object22.add(miningAttributeType);
                continue;
            }
            if (!AttributeTypeHelper.areCompatibleTypes(attributeType3.getDataType(), miningAttributeType.getDataType())) {
                miningAttributeType.setStatus(AttributeStatus.INVALID);
                continue;
            }
            miningAttributeType.setStatus(attributeType3.getStatus());
            hashMap.remove(miningAttributeType.getName());
        }
        if (!object22.isEmpty()) {
            this.removeMissingInputColumns((DynamicNodeBaseSettingsType)string2, (List<MiningAttributeType>)object22);
        }
        object = new ArrayList(hashMap.values());
        this.copyAttributes((List<MiningAttributeType>)object3, (List<AttributeType>)object);
    }

    @Override
    public Object getProperty(String string) {
        HashMap<String, Object> hashMap = null;
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        if (string.equals(PREDICTION_NODE_INPUT_COLUMNS)) {
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("DynamicNodeBaseSettingsType", dynamicPredictionNodeType.getDynamicNodeBaseSettings());
            hashMap2.put("PredictionAttributesType", dynamicPredictionNodeType.getPredictionAttributes());
            hashMap = hashMap2;
        } else if (string.equals(ALL_COLUMNS)) {
            PredictionAttributesType predictionAttributesType = dynamicPredictionNodeType.getPredictionAttributes();
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicPredictionNodeType.getDynamicNodeBaseSettings();
            hashMap = new DynamicPredictHelper(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), predictionAttributesType.getTargetAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions());
        } else if (string.equals(TARGETS_PREDICTIONS)) {
            HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
            hashMap3.put(TARGETS_PREDICTIONS_COLUMNS, dynamicPredictionNodeType.getPredictionAttributes().getTargetAttributes());
            hashMap3.put(TARGETS_PREDICTIONS_PREDICTIONS, dynamicPredictionNodeType.getDynamicNodeBaseSettings().getDynamicApplyOutputColumns());
            hashMap3.put(TARGETS_PREDICTIONS_SUPPLEMENTAL, dynamicPredictionNodeType.getDynamicNodeBaseSettings().getSupplementalAttributes());
            hashMap = hashMap3;
        } else if (string.equals(MINING_TYPE_CHANGE)) {
            HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
            hashMap4.put(TARGETS_PREDICTIONS_COLUMNS, dynamicPredictionNodeType.getPredictionAttributes().getTargetAttributes());
            hashMap4.put(TARGETS_PREDICTIONS_PREDICTIONS, dynamicPredictionNodeType.getDynamicNodeBaseSettings().getDynamicApplyOutputColumns());
            hashMap = hashMap4;
        } else {
            return super.getProperty(string);
        }
        return hashMap;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(PREDICTION_NODE_INPUT_COLUMNS) || complexProperty.getPropertyName().equals(ALL_COLUMNS) || complexProperty.getPropertyName().equals("refactorSupplementalColumns") || complexProperty.getPropertyName().equals(TARGETS_PREDICTIONS) || complexProperty.getPropertyName().equals(MINING_TYPE_CHANGE) || complexProperty.getPropertyName().equals("Predictions Only") || complexProperty.getPropertyName().equals("OUTPUT_SUPPLEMENTAL") || complexProperty.getPropertyName().equals("PARTITIONS_EXPRESSIONS") || complexProperty.getPropertyName().equals("PARTITIONS_EXPRESSION_EDIT") || complexProperty.getPropertyName().equals("CASE_ATTRIBUTE") || complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        if (string.equals(PREDICTION_NODE_INPUT_COLUMNS)) {
            Map map = (Map)object;
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = (DynamicNodeBaseSettingsType)map.get("DynamicNodeBaseSettingsType");
            PredictionAttributesType predictionAttributesType = (PredictionAttributesType)map.get("PredictionAttributesType");
            dynamicPredictionNodeType.setDynamicNodeBaseSettings(dynamicNodeBaseSettingsType);
            dynamicPredictionNodeType.setPredictionAttributes(predictionAttributesType);
        } else if (string.equals(ALL_COLUMNS)) {
            PredictionAttributesType predictionAttributesType = dynamicPredictionNodeType.getPredictionAttributes();
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicPredictionNodeType.getDynamicNodeBaseSettings();
            DynamicPredictHelper dynamicPredictHelper = (DynamicPredictHelper)object;
            dynamicNodeBaseSettingsType.setMiningAttributes(dynamicPredictHelper.newInputAttributes);
            dynamicNodeBaseSettingsType.setSupplementalAttributes(dynamicPredictHelper.newSupplAttributes);
            dynamicNodeBaseSettingsType.setCaseAttributes(dynamicPredictHelper.newCaseAttributes);
            dynamicNodeBaseSettingsType.setPartitionExpressions(dynamicPredictHelper.newPartExpressions);
            predictionAttributesType.setTargetAttributes(dynamicPredictHelper.newTargetAttributes);
        } else if (string.equals(TARGETS_PREDICTIONS)) {
            Map map = (Map)object;
            TargetAttributes targetAttributes = (TargetAttributes)map.get(TARGETS_PREDICTIONS_COLUMNS);
            dynamicPredictionNodeType.getPredictionAttributes().setTargetAttributes(targetAttributes);
            DynamicApplyOutputColumns dynamicApplyOutputColumns = (DynamicApplyOutputColumns)map.get(TARGETS_PREDICTIONS_PREDICTIONS);
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicPredictionNodeType.getDynamicNodeBaseSettings();
            dynamicNodeBaseSettingsType.setDynamicApplyOutputColumns(dynamicApplyOutputColumns);
            SupplementalAttributesType supplementalAttributesType = (SupplementalAttributesType)map.get(TARGETS_PREDICTIONS_SUPPLEMENTAL);
            dynamicNodeBaseSettingsType.setSupplementalAttributes(supplementalAttributesType);
        } else if (string.equals(MINING_TYPE_CHANGE)) {
            Map map = (Map)object;
            TargetAttributes targetAttributes = (TargetAttributes)map.get(TARGETS_PREDICTIONS_COLUMNS);
            dynamicPredictionNodeType.getPredictionAttributes().setTargetAttributes(targetAttributes);
            DynamicApplyOutputColumns dynamicApplyOutputColumns = (DynamicApplyOutputColumns)map.get(TARGETS_PREDICTIONS_PREDICTIONS);
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicPredictionNodeType.getDynamicNodeBaseSettings();
            dynamicNodeBaseSettingsType.setDynamicApplyOutputColumns(dynamicApplyOutputColumns);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public String getHelpTopic() {
        return "dynamic_prediction_node";
    }

    @Override
    public Attributes getAttributes() {
        if (this._isEnableLegacyApplyOutputTypes == null) {
            this.detectDBVersion();
        }
        Attributes attributes = new Attributes();
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        if (null != this.getDynamicNodeBaseSettingsType().getSupplementalAttributes() && !this.getDynamicNodeBaseSettingsType().getSupplementalAttributes().getAttribute().isEmpty()) {
            attributes.getAttribute().addAll(this.getDynamicNodeBaseSettingsType().getSupplementalAttributes().getAttribute());
        }
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>();
        List list = dynamicPredictionNodeType.getPredictionAttributes().getTargetAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType : list) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        if (null != this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns() && null != this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn()) {
            for (MiningAttributeType miningAttributeType : this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn()) {
                MiningAttributeType miningAttributeType2;
                String string = null;
                String string2 = null;
                String string3 = miningAttributeType.getTargetAttributeName();
                if (null != miningAttributeType.getPrediction()) {
                    string2 = miningAttributeType.getPrediction().getColumn().getName();
                    miningAttributeType2 = (MiningAttributeType)hashMap.get(string3);
                    string = DynamicPredictionNode.getPredictionOutputColumnTypeManual(miningAttributeType2);
                } else if (null != miningAttributeType.getPredictionDetails()) {
                    string2 = miningAttributeType.getPredictionDetails().getColumn().getName();
                    string = "XMLTYPE";
                } else if (null != miningAttributeType.getPredictionProbability()) {
                    string2 = miningAttributeType.getPredictionProbability().getColumn().getName();
                    string = "BINARY_DOUBLE";
                } else if (null != miningAttributeType.getPredictionSet()) {
                    string2 = miningAttributeType.getPredictionSet().getColumn().getName();
                    string = this._isEnableLegacyApplyOutputTypes != false ? "ODMR_PREDICTION_SET_CAT" : "ODMR_PREDICTION_SET_CATPD";
                }
                miningAttributeType2 = new AttributeType();
                miningAttributeType2.setName(string2);
                miningAttributeType2.setDataType(string != null ? string : "UNKNOWN");
                miningAttributeType2.setStatus(AttributeStatus.VALID);
                attributes.getAttribute().add(miningAttributeType2);
            }
        }
        return attributes;
    }

    @Override
    public String generateSQLExpression() {
        Map<String, String> map = this.generateSQLExpressions();
        return map.get("CLIENT_SQL_EXPRESSION");
    }

    @Override
    public Map<String, String> generateSQLExpressions() {
        Object object2;
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        StringBuilder stringBuilder = new StringBuilder();
        List list = dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute();
        List list2 = dynamicPredictionNodeType.getPredictionAttributes().getTargetAttributes().getMiningAttribute();
        List list3 = dynamicNodeBaseSettingsType.getCaseAttributes().getAttribute();
        List list4 = dynamicNodeBaseSettingsType.getPartitionExpressions().getPartitionExpression();
        boolean bl = false;
        for (Object object2 : list) {
            bl = this.isTargetAttribute((MiningAttributeType)object2, list2) ? false : (this.isCaseIdAttribute((AttributeType)object2, list3) ? false : (this.isPartitionAttribute((MiningAttributeType)object2, list4) ? false : "Yes".equals(object2.getInput())));
            if (!bl) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"");
            stringBuilder.append(object2.getName());
            stringBuilder.append("\"");
        }
        Object object3 = this.generateSupplementalCode(this.PREDICTION_TEMPLATE);
        object2 = object3;
        Map<String, StringBuilder> map = this.generatePredictionSQL(stringBuilder.toString());
        object3 = StringUtils.getReplacedString((String)object3, "<DYNAMIC_PREDICTION_CODE>", map.get("CLIENT_SQL_EXPRESSION").toString());
        object2 = StringUtils.getReplacedString((String)object2, "<DYNAMIC_PREDICTION_CODE>", map.get("SERVER_SQL_EXPRESSION").toString());
        String string = this.wrapExpressionInWithClause((String)object3);
        String string2 = this.wrapExpressionInWithClause((String)object2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CLIENT_SQL_EXPRESSION", string);
        hashMap.put("SERVER_SQL_EXPRESSION", string2);
        return hashMap;
    }

    private Map<String, StringBuilder> generatePredictionSQL(String string) {
        HashMap<String, StringBuilder> hashMap;
        Object object;
        Object object22;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        List list = dynamicPredictionNodeType.getPredictionAttributes().getTargetAttributes().getMiningAttribute();
        HashMap<String, MiningAttributeType> hashMap2 = new HashMap<String, MiningAttributeType>();
        for (Object object22 : list) {
            hashMap2.put(object22.getName(), (MiningAttributeType)object22);
        }
        List list2 = this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn();
        object22 = new HashSet();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (DynamicApplyOutputColumnType)iterator.next();
            hashMap = object.getTargetAttributeName();
            ((HashSet)object22).add(hashMap);
        }
        iterator = !this.getDynamicNodeBaseSettingsType().getCaseAttributes().getAttribute().isEmpty() ? (AttributeType)this.getDynamicNodeBaseSettingsType().getCaseAttributes().getAttribute().get(0) : null;
        object = null;
        if (iterator != null) {
            object = !StringUtils.isDoubleQuotedString(iterator.getName()) ? StringUtils.addDoubleQuotes(iterator.getName()) : iterator.getName();
        }
        hashMap = list2.iterator();
        while (hashMap.hasNext()) {
            String string2;
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType = (DynamicApplyOutputColumnType)hashMap.next();
            String string3 = dynamicApplyOutputColumnType.getTargetAttributeName();
            MiningAttributeType miningAttributeType = (MiningAttributeType)hashMap2.get(string3);
            PredictionFunctionsHelper.Parameters parameters = DynamicApplyHelper.getPredictionFunctionParameters(dynamicApplyOutputColumnType, miningAttributeType.getDataType(), miningAttributeType.getMiningType(), null);
            String string4 = parameters.generateCode(this);
            String string5 = string2 = !StringUtils.isDoubleQuotedString(miningAttributeType.getName()) ? StringUtils.addDoubleQuotes(miningAttributeType.getName()) : miningAttributeType.getName();
            if (miningAttributeType.getMiningType().equals("Categorical") && !DatabaseMetadataUtils.isACharacterOracleDataType(miningAttributeType.getDataType())) {
                string2 = "TO_CHAR(" + string2 + ")";
            }
            String string6 = string4 = StringUtils.getReplacedString(string4, "<TARGET_COLUMN>", string2);
            String string7 = StringUtils.getReplacedString(miningAttributeType.getName(), " ", "_");
            string6 = StringUtils.getReplacedString(string6, "<INPUT_LIST>", INPUT_LIST_FOR_TARGET_ + string7);
            StringBuilder stringBuilder3 = new StringBuilder();
            Object object3 = ((HashSet)object22).iterator();
            while (object3.hasNext()) {
                String string8 = (String)object3.next();
                String string9 = !StringUtils.isDoubleQuotedString(string8) ? StringUtils.addDoubleQuotes(string8) : string8;
                if (string9.equals(string2) || string2.equals("TO_CHAR(" + string9 + ")") || object != null && string9.equals(object)) continue;
                if (stringBuilder3.length() > 0) {
                    stringBuilder3.append(",");
                }
                stringBuilder3.append("\"");
                stringBuilder3.append(string8);
                stringBuilder3.append("\"");
            }
            if (stringBuilder3.length() > 0 && string.length() > 0) {
                stringBuilder3.append(",");
            }
            stringBuilder3.append(string);
            string4 = StringUtils.getReplacedString(string4, "<INPUT_LIST>", stringBuilder3.toString());
            if (parameters instanceof PredictionFunctionsHelper.PredictionDetails) {
                object3 = this.generatePredictionDetails((PredictionFunctionsHelper.PredictionDetails)parameters, miningAttributeType.getMiningType());
                string4 = StringUtils.getReplacedString(string4, "<CLASS_VALUE> <TOP_N> <SORT_ORDER> ", (String)object3);
                string6 = StringUtils.getReplacedString(string6, "<CLASS_VALUE> <TOP_N> <SORT_ORDER> ", (String)object3);
            } else if (parameters instanceof PredictionFunctionsHelper.PredictionSet) {
                object3 = this.generatePredictionSet((PredictionFunctionsHelper.PredictionSet)parameters);
                string4 = StringUtils.getReplacedString(string4, "<TOP_N> <CUT_OFF> ", (String)object3);
                string6 = StringUtils.getReplacedString(string6, "<TOP_N> <CUT_OFF> ", (String)object3);
            } else if (parameters instanceof PredictionFunctionsHelper.PredictionProbability) {
                object3 = this.generatePredictionProbability((PredictionFunctionsHelper.PredictionProbability)parameters, miningAttributeType.getMiningType());
                string4 = StringUtils.getReplacedString(string4, "<CLASS_VALUE> ", (String)object3);
                string6 = StringUtils.getReplacedString(string6, "<CLASS_VALUE> ", (String)object3);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
            }
            stringBuilder.append(string4);
            stringBuilder2.append(string6);
        }
        hashMap = new HashMap<String, StringBuilder>();
        hashMap.put("CLIENT_SQL_EXPRESSION", stringBuilder);
        hashMap.put("SERVER_SQL_EXPRESSION", stringBuilder2);
        return hashMap;
    }

    private String generatePredictionSet(PredictionFunctionsHelper.PredictionSet predictionSet) {
        StringBuilder stringBuilder = new StringBuilder();
        if (predictionSet.isUseTopN()) {
            if (!predictionSet.getTopN().equals(PredictionFunctionsHelper.TOPN_VALUE)) {
                stringBuilder.append(", " + predictionSet.getTopN().toString());
            }
            if (predictionSet.getUseCostType().compareTo("Model") == 0) {
                if (predictionSet.isUseCostCutOff()) {
                    if (predictionSet.isUseTopN() && !predictionSet.getTopN().equals(PredictionFunctionsHelper.TOPN_VALUE)) {
                        stringBuilder.append(", " + predictionSet.getCostCutOff().toString());
                    } else {
                        stringBuilder.append(", null, " + predictionSet.getCostCutOff().toString());
                    }
                }
            } else if (predictionSet.isUseCutOff()) {
                if (predictionSet.isUseTopN() && !predictionSet.getTopN().equals(PredictionFunctionsHelper.TOPN_VALUE)) {
                    stringBuilder.append(", " + predictionSet.getCutOff().toString());
                } else {
                    stringBuilder.append(", null, " + predictionSet.getCutOff().toString());
                }
            }
        } else if (predictionSet.getUseCostType().compareTo("Model") == 0) {
            if (predictionSet.isUseCostCutOff()) {
                stringBuilder.append(", null, " + predictionSet.getCostCutOff().toString());
            }
        } else if (predictionSet.isUseCutOff()) {
            stringBuilder.append(", null, " + predictionSet.getCutOff().toString());
        }
        return stringBuilder.toString();
    }

    private String generatePredictionDetails(PredictionFunctionsHelper.PredictionDetails predictionDetails, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (predictionDetails.isUseTarget() && null != predictionDetails.getSelectedTarget()) {
            if (string.equals("Categorical")) {
                stringBuilder.append(", '" + StringUtils.escapeSingleQuotesForSQL((String)predictionDetails.getSelectedTarget()) + "'");
            } else {
                stringBuilder.append(", " + (String)predictionDetails.getSelectedTarget());
            }
            stringBuilder.append(" ");
        }
        if (predictionDetails.isUseTopN()) {
            if (null == predictionDetails.getSelectedTarget()) {
                stringBuilder.append(", NULL , " + predictionDetails.getTopN().toString());
            } else {
                stringBuilder.append(", " + predictionDetails.getTopN().toString());
            }
        }
        if (null != predictionDetails.getSort()) {
            stringBuilder.append(" " + ServerConstants.ApplyPredictionDetailsSort.toAlgorithm(predictionDetails.getSort()) + " ");
        }
        return stringBuilder.toString();
    }

    private String generatePredictionProbability(PredictionFunctionsHelper.PredictionProbability predictionProbability, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != predictionProbability.getSelectedTarget()) {
            if (string.equals("Categorical")) {
                stringBuilder.append(", '" + StringUtils.escapeSingleQuotesForSQL((String)predictionProbability.getSelectedTarget()) + "'");
            } else {
                stringBuilder.append(", " + (String)predictionProbability.getSelectedTarget());
            }
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    @Override
    public void refactorForApply() throws Exception {
    }

    public static TargetAttributes copyTargetAttributes(TargetAttributes targetAttributes) {
        TargetAttributes targetAttributes2 = new TargetAttributes();
        List list = targetAttributes.getMiningAttribute();
        List list2 = targetAttributes2.getMiningAttribute();
        for (MiningAttributeType miningAttributeType : list) {
            MiningAttributeType miningAttributeType2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(miningAttributeType);
            list2.add(miningAttributeType2);
        }
        return targetAttributes2;
    }

    public String getTargetMiningType(String string) {
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        MiningAttributeType miningAttributeType = null;
        for (MiningAttributeType miningAttributeType2 : dynamicPredictionNodeType.getPredictionAttributes().getTargetAttributes().getMiningAttribute()) {
            if (!miningAttributeType2.getName().equals(string)) continue;
            miningAttributeType = miningAttributeType2;
            break;
        }
        assert (miningAttributeType != null);
        return miningAttributeType.getMiningType();
    }

    public boolean isTargetAttribute(MiningAttributeType miningAttributeType, List<MiningAttributeType> list) {
        boolean bl = false;
        for (MiningAttributeType miningAttributeType2 : list) {
            if (!miningAttributeType2.getName().equals(miningAttributeType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static Vector<Object> getTargetValues(Map<String, Vector<Object>> map, String string) {
        if (map == null || map.isEmpty()) {
            return new Vector<Object>();
        }
        String string2 = StringUtils.isDoubleQuotedString(string) ? string : StringUtils.addDoubleQuotes(string);
        return map.get(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Vector<Object>> getAllTargetValues() {
        if (null != this.results && !this.results.isEmpty()) {
            return this.results;
        }
        this.results = new HashMap<String, Vector<Object>>();
        DynamicPredictionNodeType dynamicPredictionNodeType = (DynamicPredictionNodeType)this.getData();
        if (dynamicPredictionNodeType == null || dynamicPredictionNodeType.getPredictionAttributes() == null) {
            return this.results;
        }
        ResultType resultType = dynamicPredictionNodeType.getPredictionAttributes().getTargetValuesTable();
        if (resultType == null) {
            return this.results;
        }
        String string = resultType.getName();
        if (string == null || string.isEmpty()) {
            return this.results;
        }
        String string2 = string;
        boolean bl = false;
        String string3 = _ALL_TARGETS + "\"" + string2 + "\"";
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string4 = ConnectionFolder.getUserAccountName(this.getContext());
            bl = DatabaseMetadataUtils.datasourceExists(connectionFolder, string4, string);
            if (bl) {
                sQLHelper.conn = connectionFolder.getConnection();
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    String string5 = sQLHelper.rs.getString("TARGET_ATTR");
                    String string6 = sQLHelper.rs.getString("STR_VALUE");
                    String string7 = sQLHelper.rs.getString("NUM_VALUE");
                    String string8 = null;
                    string8 = string6 != null ? string6 : string7;
                    String string9 = StringUtils.isDoubleQuotedString(string5) ? string5 : StringUtils.addDoubleQuotes(string5);
                    Vector<Object> vector = this.results.get(string9);
                    if (vector == null) {
                        vector = new Vector();
                        this.results.put(string5, vector);
                    }
                    vector.add(string8);
                }
            } else {
                resultType.setName(null);
            }
        }
        return this.results;
    }

    private static class DynamicPredictHelper
    extends DynamicHelper {
        TargetAttributes newTargetAttributes;

        DynamicPredictHelper() {
            this.newTargetAttributes = new TargetAttributes();
            this.newTargetAttributes.getMiningAttribute();
        }

        DynamicPredictHelper(MiningAttributes miningAttributes, SupplementalAttributesType supplementalAttributesType, TargetAttributes targetAttributes, CaseAttributes caseAttributes, PartitionExpressions partitionExpressions) {
            super(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions);
            this.newTargetAttributes = targetAttributes;
        }
    }
}

