/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.feature;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CustomPIPopupListener;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.inspect.GeneralBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.ModelBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.feature.FeatureExtractionBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.feature.FeatureExtractionBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class FeatureExtractionBuildPIComponentTargetPanel
extends JPanel
implements GeneralBuildPIComponentGUI {
    private static final Logger theLogger = Logger.getLogger(FeatureExtractionBuildPIComponentTargetPanel.class.getName());
    private JComboBox jCaseCombo;
    private JLabel jLblCaseIds;
    private JLabel statusCaseIcon;
    private WorkflowNodePropertyProxyModel _model;
    private boolean _bLoading = false;
    private CaseEditRecord caseEdits;
    private List<ModelType> _models;
    private boolean _clearSearchState = true;

    public FeatureExtractionBuildPIComponentTargetPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLblCaseIds = new JLabel();
        this.jCaseCombo = new JComboBox();
        this.statusCaseIcon = new JLabel();
        this.jLblCaseIds.setText("Case IDs:");
        this.jLblCaseIds.setName("jLblCaseIds");
        this.jCaseCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCaseCombo.setName("jCaseCombo");
        this.statusCaseIcon.setText("warningIcon");
        this.statusCaseIcon.setName("statusCaseIcon");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLblCaseIds, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCaseCombo, -2, 169, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusCaseIcon).addContainerGap(99, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblCaseIds, -2, 14, -2).addComponent(this.jCaseCombo, -2, -1, -2).addComponent(this.statusCaseIcon)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    @Override
    public boolean isWritable() {
        return FeatureExtractionBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return FeatureExtractionBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return FeatureExtractionBuildPIComponentHelper.getContext(propertyModel);
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblCaseIds, (Component)this.jCaseCombo, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_CASE_IDS"));
        this.initIconResources();
    }

    private void enableControls() {
        this.jCaseCombo.setEnabled(this.isWritable());
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._bLoading = true;
        BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
        List list = buildNodeType.getMiningAttributes().getMiningAttribute();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this.loadCaseIdUI(buildNodeType);
        this.jCaseCombo.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                if (object instanceof CaseIdItem) {
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType = caseIdItem.item;
                    FeatureExtractionBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().clear();
                    FeatureExtractionBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().add(attributeType);
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        FeatureExtractionBuildPIComponentTargetPanel.this.statusCaseIcon.setVisible(true);
                    } else {
                        FeatureExtractionBuildPIComponentTargetPanel.this.statusCaseIcon.setVisible(false);
                    }
                    FeatureExtractionBuildPIComponentTargetPanel.this.setValue(FeatureExtractionBuildPIComponentTargetPanel.this.caseEdits);
                } else {
                    FeatureExtractionBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().clear();
                    FeatureExtractionBuildPIComponentTargetPanel.this.setValue(FeatureExtractionBuildPIComponentTargetPanel.this.caseEdits);
                }
            }
        });
        this.enableControls();
        this._bLoading = false;
    }

    public void reloadUI(PropertyModel propertyModel) {
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._bLoading = true;
        BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
        List list = buildNodeType.getMiningAttributes().getMiningAttribute();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this.loadCaseIdUI(buildNodeType);
        this.enableControls();
        this._bLoading = false;
    }

    private void initIconResources() {
        this.statusCaseIcon.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusCaseIcon.setText("");
    }

    private void loadCaseIdUI(BuildNodeType buildNodeType) {
        Object object;
        AttributeType attributeType3;
        AttributeType attributeType2;
        Object object2;
        List list = buildNodeType.getMiningAttributes().getMiningAttribute();
        if (this.caseEdits == null) {
            this.caseEdits = new CaseEditRecord(new CaseAttributes());
        } else {
            object2 = this.caseEdits.getCaseAttributes();
            if (object2 != null && (attributeType2 = this.caseEdits.getCaseAttributes().getAttribute()) != null) {
                attributeType2.clear();
            }
        }
        object2 = buildNodeType.getCaseAttributes().getAttribute();
        attributeType2 = object2.iterator();
        while (attributeType2.hasNext()) {
            attributeType3 = (AttributeType)attributeType2.next();
            object = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType3);
            this.caseEdits.getCaseAttributes().getAttribute().add(object);
        }
        this.jCaseCombo.removeAllItems();
        this.jCaseCombo.addItem("<None>");
        for (AttributeType attributeType3 : list) {
            if (!DatabaseMetadataUtils.isCaseIdDataTypeSupported(this.getContext((PropertyModel)this._model), attributeType3.getDataType())) continue;
            this.jCaseCombo.addItem(new CaseIdItem((MiningAttributeType)attributeType3));
        }
        attributeType2 = null;
        if (object2.size() != 0) {
            attributeType2 = (AttributeType)object2.get(0);
        } else {
            this.jCaseCombo.setSelectedIndex(0);
        }
        if (attributeType2 != null && attributeType2.getStatus().equals((Object)AttributeStatus.VALID)) {
            boolean bl = false;
            for (int i = 0; i < this.jCaseCombo.getItemCount(); ++i) {
                if (!(this.jCaseCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                CaseIdItem caseIdItem = (CaseIdItem)this.jCaseCombo.getItemAt(i);
                if (!attributeType2.getName().equals(caseIdItem.item.getName()) || !attributeType2.getDataType().equals(caseIdItem.item.getDataType())) continue;
                this.jCaseCombo.setSelectedIndex(i);
                bl = true;
            }
            if (!bl) {
                theLogger.log(Level.WARNING, "Could not find the case id value event though it is valid");
            } else {
                this.statusCaseIcon.setVisible(false);
            }
        } else if (attributeType2 != null && attributeType2.getStatus().equals((Object)AttributeStatus.INVALID)) {
            attributeType3 = MetaDataHelper.createMiningAttributeFrom(attributeType2);
            object = new CaseIdItem((MiningAttributeType)attributeType3);
            this.jCaseCombo.setEditable(true);
            this.jCaseCombo.setSelectedItem(object);
            this.jCaseCombo.setEditable(false);
            this.statusCaseIcon.setVisible(true);
        } else if (attributeType2 == null) {
            this.statusCaseIcon.setVisible(false);
        }
    }

    private void setValue(CaseEditRecord caseEditRecord) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        FeatureExtractionBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap);
        if (caseEditRecord != null && hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            CaseAttributes caseAttributes = new CaseAttributes();
            caseAttributes.getAttribute().addAll(caseEditRecord.getCaseAttributes().getAttribute());
            arrayList.add(new Property(String.valueOf(FeatureExtractionBuildNodePropertyModel.RowIndex.CASE_IDS), null, new ComplexProperty("caseAttributes", caseAttributes), null, null));
            arrayList.add(new Property(String.valueOf(FeatureExtractionBuildNodePropertyModel.RowIndex.MODELS_RERUN), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
            ModelBuildNodePropertyModel.updateCaseIdModelAttributes(buildNodeType, arrayList, FeatureExtractionBuildNodePropertyModel.RowIndex.MINING_ATTRIBUTE_SETTINGS, caseAttributes);
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void updateWorkFlow() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            Node node = workflowEditor.getSelectedDiagramNode();
            if (node != null) {
                workflowEditor.setSelected(workflowNode.getEngine(), node);
            }
        }
    }

    public void resetModelSettingsTable(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models.clear();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this.reloadUI(propertyModel);
    }

    class CaseIdItem {
        AttributeType item = new AttributeType();

        CaseIdItem(MiningAttributeType miningAttributeType) {
            this.item.setAlias(miningAttributeType.getAlias());
            this.item.setDataType(miningAttributeType.getDataType());
            this.item.setName(miningAttributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)miningAttributeType.getStatus().value()));
        }

        public String toString() {
            return this.item.getName();
        }
    }
}

