/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.dynamic.cluster;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyOutputDialog;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.cluster.ClusterPredictionLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.cluster.ClusterPredictionsTableModel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionEditorState;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.dynamic.DynamicLrb;
import oracle.dmt.dataminer.workflow.inspect.dynamic.DynamicNodePredictionPanel;
import oracle.dmt.dataminer.workflow.inspect.dynamic.cluster.ClusterPredictLrb;
import oracle.dmt.dataminer.workflow.inspect.dynamic.cluster.DynamicClusterInspectorState;
import oracle.dmt.dataminer.workflow.inspect.dynamic.cluster.WorkflowDynamicClusterNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.DynamicClusterNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterIdType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumns;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicClusterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class DynamicClusterNodePredictionPanel
extends DynamicNodePredictionPanel {
    private JTextField jClusterTextField;
    private JComboBox jComboBoxCaseId;
    private ComponentWithTitlebar<JComponent> jComponentClusters;
    private JLabel jLabelCaseId;
    private JLabel jLabelClusters;
    private DynamicClusterNode _targetNode;

    public DynamicClusterNodePredictionPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLabelCaseId = new JLabel();
        this.jComboBoxCaseId = new JComboBox();
        this.jLabelClusters = new JLabel();
        this.jClusterTextField = new NumberTextField();
        this.jComponentClusters = new ComponentWithTitlebar();
        this.jLabelCaseId.setText("Case ID:");
        this.jComboBoxCaseId.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabelClusters.setText("Number of Clusters to Compute:");
        ((NumberTextField)this.jClusterTextField).setDataType(Integer.class);
        ((NumberTextField)this.jClusterTextField).setSigned(false);
        this.jClusterTextField.setLocale(Locale.getDefault());
        this.jClusterTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicClusterNodePredictionPanel.this.jClusterTextFieldActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.jComponentClusters, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelCaseId, -2, 60, -2).addGap(12, 12, 12).addComponent(this.jComboBoxCaseId, -2, 121, -2)).addComponent(this.jLabelClusters, -1, 196, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jClusterTextField, -2, 59, -2).addContainerGap(250, Short.MAX_VALUE)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCaseId).addComponent(this.jComboBoxCaseId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jClusterTextField, -2, -1, -2).addComponent(this.jLabelClusters)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jComponentClusters, -1, 266, Short.MAX_VALUE)));
    }

    private void jClusterTextFieldActionPerformed(ActionEvent actionEvent) {
        JTextField jTextField = this.jClusterTextField;
        Number number = ((NumberTextField)jTextField).getNumber();
        Integer n = number.intValue();
        this.setClusterNumber(n);
    }

    @Override
    protected JComboBox getComboCaseID() {
        return this.jComboBoxCaseId;
    }

    @Override
    protected JLabel getLabelCaseID() {
        return this.jLabelCaseId;
    }

    public void updateUI(PropertyModel propertyModel) {
        if (!(propertyModel instanceof WorkflowDynamicClusterNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowDynamicClusterNodePropertyProxyModel)propertyModel;
        this._targetNode = (DynamicClusterNode)this.getTargetNode((PropertyModel)this._model);
        this.createNameGenerator();
        NodeType nodeType = this._targetNode.getData();
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)nodeType;
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        this.addPredOutputBtn.setEnabled(true);
        this.removePredOutputBtn.setEnabled(false);
        this.editPredOutputBtn.setEnabled(false);
        this.buildCaseIDCombo(dynamicClusterNodeType);
        ClusterIdType clusterIdType = dynamicClusterNodeType.getClusterId();
        if (null == clusterIdType) {
            clusterIdType = new ClusterIdType();
            ClusterIdType.Column column = new ClusterIdType.Column();
            column.setName(String.valueOf(10));
            clusterIdType.setColumn(column);
        }
        ((NumberTextField)this.jClusterTextField).setNumber((Number)Integer.parseInt(clusterIdType.getColumn().getName()));
        this.setupClusterPredictionOutputTable(dynamicNodeBaseSettingsType);
    }

    private void buildCaseIDCombo(DynamicClusterNodeType dynamicClusterNodeType) {
        Object object;
        Object object22;
        Object object3;
        PartitionExpressionType partitionExpressionType2;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (PartitionExpressionType partitionExpressionType2 : dynamicClusterNodeType.getDynamicNodeBaseSettings().getPartitionExpressions().getPartitionExpression()) {
            if (null != partitionExpressionType2.getSQLExpression()) continue;
            object3 = partitionExpressionType2.getPartitionAttribute();
            hashMap.put(object3.getName(), (AttributeType)object3);
        }
        Vector vector = new Vector();
        vector.add(PredictionEditorState._none);
        partitionExpressionType2 = dynamicClusterNodeType.getDynamicNodeBaseSettings();
        if (!partitionExpressionType2.getMiningAttributes().getMiningAttribute().isEmpty()) {
            for (Object object22 : partitionExpressionType2.getMiningAttributes().getMiningAttribute()) {
                if (!DatabaseMetadataUtils.isDynamicCaseIdDataTypeSupported(object22.getDataType()) || null != hashMap.get(object = object22.getAlias() != null ? object22.getAlias() : object22.getName())) continue;
                vector.add(object);
            }
            Collections.sort(vector);
        }
        object3 = new DefaultComboBoxModel(vector);
        object22 = null;
        object = partitionExpressionType2.getCaseAttributes().getAttribute();
        if (!object.isEmpty()) {
            object22 = ((AttributeType)object.get(0)).getName();
        }
        ((DefaultComboBoxModel)object3).setSelectedItem(object22 != null ? object22 : PredictionEditorState._none);
        this.jComboBoxCaseId.setModel(object3);
    }

    public void initUI(PropertyModel propertyModel) {
        Object object;
        this._model = (WorkflowDynamicClusterNodePropertyProxyModel)propertyModel;
        this._targetNode = (DynamicClusterNode)this.getTargetNode((PropertyModel)this._model);
        this.createNameGenerator();
        NodeType nodeType = this._targetNode.getData();
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)nodeType;
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jPredictionOutputsTable));
        this.jComponentClusters.setComponent((JComponent)jScrollPane);
        this.jComponentClusters.setLabel(new JLabel(ClusterPredictionLrb.get("CLUSTER_PREDICTION_EDITOR_PANEL_PREDICTION_OUTPUT_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.addPredOutputBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addPredOutputBtn.setToolTipText(ClusterPredictionLrb.get("CLUSTER_PREDICTION_EDITOR_TOOLTIP_ADD_PREDICTION_OUTPUT"));
        this.addPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicClusterNodePredictionPanel.this.hanldeAddClusterPredictionOutput();
            }
        });
        controlBar.add((Component)this.addPredOutputBtn);
        this.removePredOutputBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removePredOutputBtn.setToolTipText(ClusterPredictionLrb.get("CLUSTER_PREDICTION_EDITOR_TOOLTIP_REMOVE_PREDICTION_OUTPUT"));
        this.removePredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicClusterNodePredictionPanel.this.removeSelectedPredictionOutputs();
            }
        });
        controlBar.add((Component)this.removePredOutputBtn);
        this.editPredOutputBtn = new JButton(_editIcon);
        this.editPredOutputBtn.setToolTipText(ClusterPredictionLrb.get("CLUSTER_PREDICTION_EDITOR_TOOLTIP_EDIT_PREDICTION_OUTPUT"));
        this.editPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicClusterNodePredictionPanel.this.hanldeEditClusterPredictionOutput();
            }
        });
        controlBar.add((Component)this.editPredOutputBtn);
        this.jComponentClusters.setControlBar(controlBar);
        this._jPredictionOutputsTable.setFillsViewportHeight(true);
        this.addPredOutputBtn.setEnabled(true);
        this.removePredOutputBtn.setEnabled(false);
        this.editPredOutputBtn.setEnabled(false);
        this.buildCaseIDCombo(dynamicClusterNodeType);
        this.jComboBoxCaseId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicClusterNodePredictionPanel.this.handleCaseIDChange();
            }
        });
        ClusterIdType clusterIdType = dynamicClusterNodeType.getClusterId();
        if (null == clusterIdType) {
            clusterIdType = new ClusterIdType();
            object = new ClusterIdType.Column();
            object.setName(String.valueOf(10));
            clusterIdType.setColumn(object);
        }
        ((NumberTextField)this.jClusterTextField).setNumber((Number)Integer.parseInt(clusterIdType.getColumn().getName()));
        object = new ClusterNumberInputVerifier();
        ClusterNumberValidator clusterNumberValidator = new ClusterNumberValidator((ClusterNumberInputVerifier)object);
        this.jClusterTextField.addFocusListener(clusterNumberValidator);
        this.jClusterTextField.addKeyListener(clusterNumberValidator);
        this.jClusterTextField.setInputVerifier((InputVerifier)object);
        this.setupClusterPredictionOutputTable(dynamicNodeBaseSettingsType);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = DynamicClusterNodePredictionPanel.this._jPredictionOutputsTable.getSelectedRowInModel();
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    DynamicClusterNodePredictionPanel.this.hanldeEditClusterPredictionOutput();
                }
            }
        };
        this._jPredictionOutputsTable.addMouseListener(mouseAdapter);
        this.jLabelClusters.setText(ClusterPredictLrb.get("PI_TOTAL_CLUSTER_NUMBER"));
    }

    private void setupClusterPredictionOutputTable(DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType) {
        DynamicApplyOutputColumns dynamicApplyOutputColumns = dynamicNodeBaseSettingsType.getDynamicApplyOutputColumns();
        DynamicClusterInspectorState dynamicClusterInspectorState = new DynamicClusterInspectorState(this._targetNode, this._outputColumnNameGenerator);
        ClusterPredictionsTableModel clusterPredictionsTableModel = new ClusterPredictionsTableModel(dynamicApplyOutputColumns, dynamicClusterInspectorState.getNodeSpecificTargetValues(null));
        this._jPredictionOutputsTable.setModel((TableModel)((Object)clusterPredictionsTableModel));
        this._jPredictionOutputsTable.setShowGrid(true);
        this._jPredictionOutputsTable.setSorted(true);
        this._jPredictionOutputsTable.setSortColumn(ClusterPredictionsTableModel.FUNCTION, true);
        this._jPredictionOutputsTable.getSelectionModel().addListSelectionListener(new DynamicNodePredictionPanel.PredictionOutputsSelectionHandler());
    }

    @Override
    protected DynamicNodeBaseSettingsType getDynamicNodeBaseSettingsType() {
        NodeType nodeType = this._targetNode.getData();
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)nodeType;
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicClusterNodeType.getDynamicNodeBaseSettings();
        return dynamicNodeBaseSettingsType;
    }

    private void hanldeAddClusterPredictionOutput() {
        String string = DynamicNodesLrb.get("DYNAMIC_CLUSTER_APPLY_OUTPUT_ADD_DIALOG_TITLE");
        DynamicApplyOutputDialog dynamicApplyOutputDialog = new DynamicApplyOutputDialog(string);
        DynamicClusterInspectorState dynamicClusterInspectorState = new DynamicClusterInspectorState(this._targetNode, this._outputColumnNameGenerator);
        if (dynamicApplyOutputDialog.invoke(this.getContext((PropertyModel)this._model), dynamicClusterInspectorState, null)) {
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType = dynamicApplyOutputDialog.getApplyOutputColumn();
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            DynamicApplyOutputColumns dynamicApplyOutputColumns = dynamicNodeBaseSettingsType.getDynamicApplyOutputColumns();
            DynamicApplyOutputColumns dynamicApplyOutputColumns2 = new DynamicApplyOutputColumns();
            DynamicApplyOutputColumns dynamicApplyOutputColumns3 = new DynamicApplyOutputColumns();
            List list = _helper.makeListCopies(dynamicApplyOutputColumns.getDynamicApplyOutputColumn(), 2);
            dynamicApplyOutputColumns3.getDynamicApplyOutputColumn().addAll(list.get(0));
            dynamicApplyOutputColumns2.getDynamicApplyOutputColumn().addAll(list.get(1));
            dynamicApplyOutputColumns2.getDynamicApplyOutputColumn().add(dynamicApplyOutputColumnType);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("Predictions Only", dynamicApplyOutputColumns2);
            complexProperty.setOldData(dynamicApplyOutputColumns3);
            arrayList.add(new Property(String.valueOf(this._model.getRowMapping("PREDICTIONS_ONLY")), null, complexProperty, null, null));
            String string2 = DynamicLrb.get("PI_ADD_PREDICTION");
            this._model.setValueAt(string2, this._targetNode, arrayList);
        }
    }

    @Override
    protected Vector<DynamicApplyOutputColumnType> getDataVector() {
        ClusterPredictionsTableModel clusterPredictionsTableModel = (ClusterPredictionsTableModel)((Object)this._jPredictionOutputsTable.getModel());
        Vector<DynamicApplyOutputColumnType> vector = clusterPredictionsTableModel.getDataVector();
        return vector;
    }

    private void hanldeEditClusterPredictionOutput() {
        int[] nArray = this._jPredictionOutputsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length != 1) {
            return;
        }
        NodeType nodeType = this._targetNode.getData();
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)nodeType;
        ClusterPredictionsTableModel clusterPredictionsTableModel = (ClusterPredictionsTableModel)((Object)this._jPredictionOutputsTable.getModel());
        Vector<DynamicApplyOutputColumnType> vector = clusterPredictionsTableModel.getDataVector();
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType = vector.get(nArray[0]);
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType2 = (DynamicApplyOutputColumnType)MetaDataHelper.copyMetadataObject(dynamicApplyOutputColumnType);
        DynamicClusterInspectorState dynamicClusterInspectorState = new DynamicClusterInspectorState(this._targetNode, this._outputColumnNameGenerator);
        String string = DynamicNodesLrb.get("DYNAMIC_CLUSTER_APPLY_OUTPUT_EDIT_DIALOG_TITLE");
        DynamicApplyOutputDialog dynamicApplyOutputDialog = new DynamicApplyOutputDialog(string);
        if (dynamicApplyOutputDialog.invoke(this.getContext((PropertyModel)this._model), dynamicClusterInspectorState, dynamicApplyOutputColumnType2, null)) {
            String string2;
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType3 = dynamicApplyOutputDialog.getApplyOutputColumn();
            DynamicApplyOutputColumns dynamicApplyOutputColumns = new DynamicApplyOutputColumns();
            DynamicApplyOutputColumns dynamicApplyOutputColumns2 = new DynamicApplyOutputColumns();
            List list = _helper.makeListCopies(dynamicClusterNodeType.getDynamicNodeBaseSettings().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn(), 2);
            dynamicApplyOutputColumns2.getDynamicApplyOutputColumn().addAll(list.get(0));
            dynamicApplyOutputColumns.getDynamicApplyOutputColumn().addAll(list.get(1));
            String string3 = DynamicApplyHelper.getColumnName(dynamicApplyOutputColumnType);
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType4 = null;
            for (Object object : dynamicApplyOutputColumns.getDynamicApplyOutputColumn()) {
                string2 = DynamicApplyHelper.getColumnName((DynamicApplyOutputColumnType)object);
                if (!string2.equals(string3)) continue;
                dynamicApplyOutputColumnType4 = object;
                break;
            }
            if (dynamicApplyOutputColumnType4 != null) {
                Object object;
                dynamicApplyOutputColumns.getDynamicApplyOutputColumn().remove(dynamicApplyOutputColumnType4);
                dynamicApplyOutputColumns.getDynamicApplyOutputColumn().add(dynamicApplyOutputColumnType3);
                ArrayList arrayList = new ArrayList();
                object = new ComplexProperty("Predictions Only", dynamicApplyOutputColumns);
                ((ComplexProperty)object).setOldData(dynamicApplyOutputColumns2);
                arrayList.add(new Property(String.valueOf(this._model.getRowMapping("PREDICTIONS_ONLY")), null, object, null, null));
                string2 = DynamicLrb.get("PI_EDIT_PREDICTION");
                this._model.setValueAt(string2, this._targetNode, arrayList);
            }
        }
    }

    @Override
    public DynamicClusterNode getTargetNode() {
        return this._targetNode;
    }

    private void setClusterNumber(int n) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ClusterIdType clusterIdType = new ClusterIdType();
        ClusterIdType.Column column = new ClusterIdType.Column();
        column.setName(String.valueOf(n));
        clusterIdType.setColumn(column);
        NodeType nodeType = this._targetNode.getData();
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)nodeType;
        ComplexProperty complexProperty = new ComplexProperty("NUMBER_OF_CLUSTERS", clusterIdType);
        complexProperty.setOldData(dynamicClusterNodeType.getClusterId());
        arrayList.add(new Property(String.valueOf(this._model.getRowMapping("NUMBER_OF_CLUSTERS")), null, complexProperty, null, null));
        String string = ClusterPredictLrb.get("PI_NUMBER_OF_CLUSTERS");
        this._model.setValueAt(string, this._targetNode, arrayList);
    }

    class ClusterNumberValidator
    extends KeyAdapter
    implements FocusListener {
        boolean busy = false;
        ClusterNumberInputVerifier _verifier;

        public ClusterNumberValidator(ClusterNumberInputVerifier clusterNumberInputVerifier) {
            this._verifier = clusterNumberInputVerifier;
        }

        private void validateClusterNumber() {
            if (this.busy) {
                return;
            }
            try {
                this.busy = true;
                this._verifier.verify(DynamicClusterNodePredictionPanel.this.jClusterTextField);
            }
            finally {
                this.busy = false;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                this.validateClusterNumber();
            }
        }
    }

    class ClusterNumberInputVerifier
    extends InputVerifier {
        ClusterNumberInputVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = true;
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                Number number = ((NumberTextField)jTextField).getNumber();
                if (number == null) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)ClusterPredictLrb.get("PI_CLUSTER_NUMBER_INCORRECT"), (String)ClusterPredictLrb.get("PI_CLUSTER_NUMBER_VALIDATION_ERROR_TITLE"), null);
                    bl = false;
                }
                if (!bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NodeType nodeType = DynamicClusterNodePredictionPanel.this._targetNode.getData();
                            DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)nodeType;
                            ClusterIdType clusterIdType = dynamicClusterNodeType.getClusterId();
                            if (null == clusterIdType) {
                                clusterIdType = new ClusterIdType();
                                ClusterIdType.Column column = new ClusterIdType.Column();
                                column.setName(String.valueOf(10));
                                clusterIdType.setColumn(column);
                            }
                            ((NumberTextField)DynamicClusterNodePredictionPanel.this.jClusterTextField).setNumber((Number)Integer.parseInt(clusterIdType.getColumn().getName()));
                        }
                    });
                } else {
                    Integer n = number.intValue();
                    DynamicClusterNodePredictionPanel.this.setClusterNumber(n);
                }
            }
            return bl;
        }
    }
}

