/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.aggregate;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AddAggregationAttributePanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AddAggregationExpressionPanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditMainDialog;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationWizard;
import oracle.dmt.dataminer.workflow.dialog.aggregate.EditAggregationAttributePanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.EditAggregationExpressionPanel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.aggregate.AggregationNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.aggregate.AggregationPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.aggregate.WorkflowAggregationNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElements;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class AggregationNodeColumnsPIComponentPanel
extends PIComponentPanel {
    private static final Logger theLogger = Logger.getLogger(AggregationNodeColumnsPIComponentPanel.class.getName());
    private AbstractDataNode _targetNode;
    private List<AggregationElementType> _targetColumns = new ArrayList<AggregationElementType>();
    private DataMinerTable _jAttributesTable = new DataMinerTable();
    private static final String[] _columnNames = new String[]{AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_SOURCE_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_OUTPUT_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_FUNCTION_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_SUB_GROUP_BY_COLUMN")};
    private static Icon _editIcon;
    private JButton _wizBtn;
    private JButton _editBtn;
    private JButton _removeBtn;
    private JButton _addElementBtn;
    private JButton _addExpressionBtn;
    private static final int SOURCE = 0;
    private static final int OUTPUT = 1;
    private static final int FUNCTION = 2;
    private static final int SUB_GROUP_BY = 3;
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JButton jBtnGroupBy;
    private JLabel jLabelGroupBy;
    private JTextField jTxtGroupBy;

    public AggregationNodeColumnsPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLabelGroupBy = new JLabel();
        this.jTxtGroupBy = new JTextField();
        this.jBtnGroupBy = new JButton();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jLabelGroupBy.setText("Group By:");
        this.jBtnGroupBy.setText("Edit");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAttributesComponent, GroupLayout.Alignment.TRAILING, -1, 448, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelGroupBy, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTxtGroupBy, -1, 265, Short.MAX_VALUE).addGap(17, 17, 17).addComponent(this.jBtnGroupBy))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelGroupBy).addComponent(this.jTxtGroupBy, -2, -1, -2).addComponent(this.jBtnGroupBy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jAttributesComponent, -1, 267, Short.MAX_VALUE)));
    }

    public void initRes() {
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
        }
        ResourceUtils.resLabel((JLabel)this.jLabelGroupBy, (Component)this.jTxtGroupBy, (String)AggregateDialogsLrb.get("AGGREGATE_EDITOR_GROUP_BY"));
        this.jLabelGroupBy.setHorizontalTextPosition(2);
        this.jBtnGroupBy.setText(AggregateDialogsLrb.get("AGGREGATE_EDITOR_EIT_BUTTON"));
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._wizBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_VALUE_CLEAR));
        this._wizBtn.setToolTipText(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_CONFIGURE_TOOLTIP"));
        this._wizBtn.getAccessibleContext().setAccessibleName(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_CONFIGURE"));
        this._wizBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregationNode aggregationNode = (AggregationNode)AggregationNodeColumnsPIComponentPanel.this._targetNode;
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                AggregationNodeType aggregationNodeType = (AggregationNodeType)aggregationNode.getData();
                AggregationWizard aggregationWizard = new AggregationWizard();
                aggregationWizard.runWizard((Component)Ide.getMainWindow(), AggregationNodeColumnsPIComponentPanel.this.getContext((PropertyModel)AggregationNodeColumnsPIComponentPanel.this._model), aggregationNode, aggregationNodeType, (AbstractDataNode)abstractNode, true);
            }
        });
        controlBar.add((Component)this._wizBtn);
        this._editBtn = new JButton(_editIcon);
        this._editBtn.setToolTipText(InspectorArb.getString((int)25));
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                AggregationElementType aggregationElementType;
                AggregationNode aggregationNode = (AggregationNode)AggregationNodeColumnsPIComponentPanel.this._targetNode;
                AggregationNodeType aggregationNodeType = (AggregationNodeType)aggregationNode.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                Context context = AggregationNodeColumnsPIComponentPanel.this.getContext((PropertyModel)AggregationNodeColumnsPIComponentPanel.this._model);
                AggregationElements aggregationElements = aggregationNodeType.getAggregationElements();
                List list = aggregationElements.getAggregationElement();
                AggregationElements aggregationElements2 = new AggregationElements();
                List list2 = aggregationElements2.getAggregationElement();
                AttributeTypeHelper.copyAttributes(list2, list);
                AggregationElements aggregationElements3 = new AggregationElements();
                List list3 = aggregationElements3.getAggregationElement();
                AttributeTypeHelper.copyAttributes(list3, list);
                int[] nArray = AggregationNodeColumnsPIComponentPanel.this._jAttributesTable.getSelectedRowsInModel();
                assert (nArray.length == 1);
                GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeColumnsPIComponentPanel.this._jAttributesTable.getModel());
                AggregationElementType aggregationElementType2 = (AggregationElementType)generalAttributesTableModel.getSrcData().get(nArray[0]);
                int n = -1;
                for (int i = 0; i < list2.size(); ++i) {
                    aggregationElementType = (AggregationElementType)list2.get(i);
                    if (!aggregationElementType.getOutput().getName().equals(aggregationElementType2.getOutput().getName())) continue;
                    n = i;
                    break;
                }
                GroupingElementType groupingElementType = aggregationElementType2.getSource();
                aggregationElementType = null;
                if (null != groupingElementType.getExpression()) {
                    serializable = new EditAggregationExpressionPanel(context, aggregationNode, aggregationNodeType.getGroupingElement(), aggregationNodeType.getAggregationElements().getAggregationElement(), aggregationElementType2);
                    if (((DialogDisplayer)serializable).showAsDialog(AggregationNodeColumnsPIComponentPanel.this)) {
                        aggregationElementType = ((AddAggregationExpressionPanel)serializable).getNewAggregationElement();
                    }
                } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && ((DialogDisplayer)(serializable = new EditAggregationAttributePanel(context, aggregationNode, aggregationNodeType.getGroupingElement(), aggregationNodeType.getAggregationElements().getAggregationElement(), aggregationElementType2))).showAsDialog(AggregationNodeColumnsPIComponentPanel.this)) {
                    aggregationElementType = ((AddAggregationAttributePanel)serializable).getNewAggregationElement();
                }
                if (null != aggregationElementType) {
                    AttributeTypeHelper.copyAggregationElementType((AggregationElementType)list2.get(n), aggregationElementType);
                    serializable = new ArrayList();
                    ComplexProperty complexProperty = new ComplexProperty("sourceColumns", aggregationElements2);
                    complexProperty.setOldData(aggregationElements3);
                    serializable.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SOURCE_COLUMNS), null, complexProperty, null, null));
                    ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                    complexProperty2.setOldData(AggregationNodeColumnsPIComponentPanel.this._targetNode.getSQLExpression());
                    serializable.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty2, null, null));
                    AggregationNodeColumnsPIComponentPanel.this._model.setValueAt(AggregationPIPropertyLrb.get("PI_AGGREGATION_NODE_EDIT_AGGREGATION_ELEMENT"), AggregationNodeColumnsPIComponentPanel.this._targetNode, (List<Property>)((Object)serializable));
                }
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(AggregationPIPropertyLrb.get("PI_AGGREGATION_REMOVE_COLUMNS_TOOLTIP"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = AggregationNodeColumnsPIComponentPanel.this._jAttributesTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    List list;
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeColumnsPIComponentPanel.this._jAttributesTable.getModel());
                    AggregationNodeType aggregationNodeType = (AggregationNodeType)AggregationNodeColumnsPIComponentPanel.this._targetNode.getData();
                    AggregationElements aggregationElements = aggregationNodeType.getAggregationElements();
                    List list2 = aggregationElements.getAggregationElement();
                    AggregationElements aggregationElements2 = new AggregationElements();
                    List list3 = aggregationElements2.getAggregationElement();
                    AttributeTypeHelper.copyAttributes(list3, list2);
                    HashMap<String, AggregationElementType> hashMap = new HashMap<String, AggregationElementType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        list = (AggregationElementType)generalAttributesTableModel.getSrcData().get(nArray[i]);
                        hashMap.put(list.getOutput().getName(), (AggregationElementType)list);
                    }
                    AggregationElements aggregationElements3 = new AggregationElements();
                    list = aggregationElements3.getAggregationElement();
                    AttributeTypeHelper.copyAttributes(list, list2, hashMap);
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    ComplexProperty complexProperty = new ComplexProperty("sourceColumns", aggregationElements3);
                    complexProperty.setOldData(aggregationElements2);
                    arrayList.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SOURCE_COLUMNS), null, complexProperty, null, null));
                    ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                    complexProperty2.setOldData(AggregationNodeColumnsPIComponentPanel.this._targetNode.getSQLExpression());
                    arrayList.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty2, null, null));
                    AggregationNodeColumnsPIComponentPanel.this._model.setValueAt(AggregationPIPropertyLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_REMOVE_ELEMENT"), AggregationNodeColumnsPIComponentPanel.this._targetNode, arrayList);
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
        this._addElementBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addElementBtn.setToolTipText(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_ELEMENT"));
        this._addElementBtn.getAccessibleContext().setAccessibleName(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_ELEMENT_TOOLTIP"));
        this._addElementBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregationNodeType aggregationNodeType = (AggregationNodeType)AggregationNodeColumnsPIComponentPanel.this._targetNode.getData();
                List list = aggregationNodeType.getAggregationElements().getAggregationElement();
                AddAggregationAttributePanel addAggregationAttributePanel = new AddAggregationAttributePanel(AggregationNodeColumnsPIComponentPanel.this.getContext((PropertyModel)AggregationNodeColumnsPIComponentPanel.this._model), (AggregationNode)AggregationNodeColumnsPIComponentPanel.this._targetNode, aggregationNodeType.getGroupingElement(), aggregationNodeType.getAggregationElements().getAggregationElement());
                if (addAggregationAttributePanel.showAsDialog(AggregationNodeColumnsPIComponentPanel.this)) {
                    AggregationElementType aggregationElementType = addAggregationAttributePanel.getNewAggregationElement();
                    AggregationElements aggregationElements = new AggregationElements();
                    List list2 = aggregationElements.getAggregationElement();
                    AttributeTypeHelper.copyAttributes(list2, list);
                    AggregationElements aggregationElements2 = new AggregationElements();
                    List list3 = aggregationElements2.getAggregationElement();
                    AttributeTypeHelper.copyAttributes(list3, list);
                    list3.add(aggregationElementType);
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    ComplexProperty complexProperty = new ComplexProperty("sourceColumns", aggregationElements2);
                    complexProperty.setOldData(aggregationElements);
                    arrayList.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SOURCE_COLUMNS), null, complexProperty, null, null));
                    ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                    complexProperty2.setOldData(AggregationNodeColumnsPIComponentPanel.this._targetNode.getSQLExpression());
                    arrayList.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty2, null, null));
                    AggregationNodeColumnsPIComponentPanel.this._model.setValueAt(AggregationPIPropertyLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_ELEMENT"), AggregationNodeColumnsPIComponentPanel.this._targetNode, arrayList);
                }
            }
        });
        controlBar.add((Component)this._addElementBtn);
        this._addExpressionBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_VALUE_ADD_EXPRESSION));
        this._addExpressionBtn.setToolTipText(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_EXPRESSION"));
        this._addExpressionBtn.getAccessibleContext().setAccessibleName(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_EXPRESSION_TOOLTIP"));
        this._addExpressionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregationNodeType aggregationNodeType = (AggregationNodeType)AggregationNodeColumnsPIComponentPanel.this._targetNode.getData();
                GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
                if (null == groupingElementType.getExpression() && (null == groupingElementType || null == groupingElementType.getAttributes() || null == groupingElementType.getAttributes().getAttribute() || groupingElementType.getAttributes().getAttribute().isEmpty())) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)AggregateDialogsLrb.get("AGGREGATION_NODE_GROUP_COLUMNS_ADD_EXPRESSION_DETAIL"), (String)AggregateDialogsLrb.get("AGGREGATION_NODE_GROUP_COLUMNS_ADD_EXPRESSION_TITLE"), null);
                    return;
                }
                List list = aggregationNodeType.getAggregationElements().getAggregationElement();
                AddAggregationExpressionPanel addAggregationExpressionPanel = new AddAggregationExpressionPanel(AggregationNodeColumnsPIComponentPanel.this.getContext((PropertyModel)AggregationNodeColumnsPIComponentPanel.this._model), (AggregationNode)AggregationNodeColumnsPIComponentPanel.this._targetNode, aggregationNodeType.getGroupingElement(), aggregationNodeType.getAggregationElements().getAggregationElement());
                if (addAggregationExpressionPanel.showAsDialog(AggregationNodeColumnsPIComponentPanel.this)) {
                    AggregationElementType aggregationElementType = addAggregationExpressionPanel.getNewAggregationElement();
                    AggregationElements aggregationElements = new AggregationElements();
                    List list2 = aggregationElements.getAggregationElement();
                    AttributeTypeHelper.copyAttributes(list2, list);
                    AggregationElements aggregationElements2 = new AggregationElements();
                    List list3 = aggregationElements2.getAggregationElement();
                    AttributeTypeHelper.copyAttributes(list3, list);
                    list3.add(aggregationElementType);
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    ComplexProperty complexProperty = new ComplexProperty("sourceColumns", aggregationElements2);
                    complexProperty.setOldData(aggregationElements);
                    arrayList.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SOURCE_COLUMNS), null, complexProperty, null, null));
                    ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                    complexProperty2.setOldData(AggregationNodeColumnsPIComponentPanel.this._targetNode.getSQLExpression());
                    arrayList.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty2, null, null));
                    AggregationNodeColumnsPIComponentPanel.this._model.setValueAt(AggregationPIPropertyLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_ELEMENT"), AggregationNodeColumnsPIComponentPanel.this._targetNode, arrayList);
                }
            }
        });
        controlBar.add((Component)this._addExpressionBtn);
        ListSelectionModel listSelectionModel = this._jAttributesTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (AggregationNodeColumnsPIComponentPanel.this.isWritable()) {
                    AggregationNodeColumnsPIComponentPanel.this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
                    AggregationNodeColumnsPIComponentPanel.this._editBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex());
                } else {
                    AggregationNodeColumnsPIComponentPanel.this._removeBtn.setEnabled(false);
                    AggregationNodeColumnsPIComponentPanel.this._editBtn.setEnabled(false);
                }
            }
        });
        this.jBtnGroupBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AggregationNode aggregationNode = (AggregationNode)AggregationNodeColumnsPIComponentPanel.this._targetNode;
                    AggregationNodeType aggregationNodeType = (AggregationNodeType)AggregationNodeColumnsPIComponentPanel.this._targetNode.getData();
                    AbstractNode abstractNode = aggregationNode.findParentNode();
                    assert (abstractNode instanceof AbstractDataNode);
                    AggregateEditMainDialog aggregateEditMainDialog = new AggregateEditMainDialog(aggregationNodeType);
                    if (aggregateEditMainDialog.invoke(AggregationNodeColumnsPIComponentPanel.this.getContext((PropertyModel)AggregationNodeColumnsPIComponentPanel.this._model), aggregationNode, (AbstractDataNode)abstractNode)) {
                        GroupingElementType groupingElementType = aggregateEditMainDialog.getGroupByElement();
                        GroupingElementType groupingElementType2 = new GroupingElementType();
                        AttributeTypeHelper.copyGroupingElementType(groupingElementType2, aggregationNodeType.getGroupingElement());
                        ArrayList<Property> arrayList = new ArrayList<Property>();
                        ComplexProperty complexProperty = new ComplexProperty("mainGroupBy", groupingElementType);
                        complexProperty.setOldData(groupingElementType2);
                        arrayList.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.MAIN_GROUP_BY), null, complexProperty, null, null));
                        if (null != aggregationNodeType.getAggregationElements() && null != aggregationNodeType.getAggregationElements().getAggregationElement() && !aggregationNodeType.getAggregationElements().getAggregationElement().isEmpty()) {
                            ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                            complexProperty2.setOldData(AggregationNodeColumnsPIComponentPanel.this._targetNode.getSQLExpression());
                            arrayList.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty2, null, null));
                        }
                        AggregationNodeColumnsPIComponentPanel.this._model.setValueAt(AggregationPIPropertyLrb.get("PI_AGGREGATION_NODE_MAIN_GROUP_BY"), AggregationNodeColumnsPIComponentPanel.this._targetNode, arrayList);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
    }

    public void initUI(PropertyModel propertyModel) {
        Object object;
        this._jAttributesTable.setTooltipEnable(true);
        this._model = (WorkflowAggregationNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this._targetNode.getData();
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        List list = aggregationNodeType.getAggregationElements().getAggregationElement();
        if (list != null && !list.isEmpty()) {
            AttributeTypeHelper.copyAttributes(this._targetColumns, list);
            this.validateSourceColumn();
        }
        this.jTxtGroupBy.setEditable(false);
        this.jTxtGroupBy.setText(AttributeTypeHelper.convertGroupingElementTypetoString(groupingElementType));
        if (!this.isValidMainGroupBy(groupingElementType)) {
            this.jLabelGroupBy.setIcon(OracleIcons.getIcon((String)"warning.png"));
            this.jLabelGroupBy.setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_MAIN_GROUP_BY_INVALID"));
        } else {
            this.jLabelGroupBy.setIcon(null);
            this.jLabelGroupBy.setToolTipText(null);
        }
        GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(this._targetColumns);
        this.setupItemsTable(generalAttributesTableModel);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_GRID_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.installItemFilterActions(controlBar);
        this.jAttributesComponent.setControlBar(controlBar);
        this._jAttributesTable.setFillsViewportHeight(true);
        this._jAttributesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!AggregationNodeColumnsPIComponentPanel.this.isWritable()) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2) {
                    AggregationNode aggregationNode = (AggregationNode)AggregationNodeColumnsPIComponentPanel.this._targetNode;
                    AggregationNodeType aggregationNodeType = (AggregationNodeType)aggregationNode.getData();
                    AbstractNode abstractNode = aggregationNode.findParentNode();
                    assert (abstractNode instanceof AbstractDataNode);
                    ListSelectionModel listSelectionModel = AggregationNodeColumnsPIComponentPanel.this._jAttributesTable.getSelectionModel();
                    if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                        Serializable serializable;
                        AggregationElementType aggregationElementType;
                        Context context = AggregationNodeColumnsPIComponentPanel.this.getContext((PropertyModel)AggregationNodeColumnsPIComponentPanel.this._model);
                        AggregationElements aggregationElements = aggregationNodeType.getAggregationElements();
                        List list = aggregationElements.getAggregationElement();
                        AggregationElements aggregationElements2 = new AggregationElements();
                        List list2 = aggregationElements2.getAggregationElement();
                        AttributeTypeHelper.copyAttributes(list2, list);
                        AggregationElements aggregationElements3 = new AggregationElements();
                        List list3 = aggregationElements3.getAggregationElement();
                        AttributeTypeHelper.copyAttributes(list3, list);
                        int[] nArray = AggregationNodeColumnsPIComponentPanel.this._jAttributesTable.getSelectedRowsInModel();
                        assert (nArray.length == 1);
                        GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeColumnsPIComponentPanel.this._jAttributesTable.getModel());
                        AggregationElementType aggregationElementType2 = (AggregationElementType)generalAttributesTableModel.getSrcData().get(nArray[0]);
                        int n = -1;
                        for (int i = 0; i < list2.size(); ++i) {
                            aggregationElementType = (AggregationElementType)list2.get(i);
                            if (!aggregationElementType.getOutput().getName().equals(aggregationElementType2.getOutput().getName())) continue;
                            n = i;
                            break;
                        }
                        GroupingElementType groupingElementType = aggregationElementType2.getSource();
                        aggregationElementType = null;
                        if (null != groupingElementType.getExpression()) {
                            serializable = new EditAggregationExpressionPanel(context, aggregationNode, aggregationNodeType.getGroupingElement(), aggregationNodeType.getAggregationElements().getAggregationElement(), aggregationElementType2);
                            if (((DialogDisplayer)serializable).showAsDialog(AggregationNodeColumnsPIComponentPanel.this)) {
                                aggregationElementType = ((AddAggregationExpressionPanel)serializable).getNewAggregationElement();
                            }
                        } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && ((DialogDisplayer)(serializable = new EditAggregationAttributePanel(context, aggregationNode, aggregationNodeType.getGroupingElement(), aggregationNodeType.getAggregationElements().getAggregationElement(), aggregationElementType2))).showAsDialog(AggregationNodeColumnsPIComponentPanel.this)) {
                            aggregationElementType = ((AddAggregationAttributePanel)serializable).getNewAggregationElement();
                        }
                        if (null != aggregationElementType) {
                            AttributeTypeHelper.copyAggregationElementType((AggregationElementType)list2.get(n), aggregationElementType);
                            serializable = new ArrayList();
                            ComplexProperty complexProperty = new ComplexProperty("sourceColumns", aggregationElements2);
                            complexProperty.setOldData(aggregationElements3);
                            serializable.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SOURCE_COLUMNS), null, complexProperty, null, null));
                            ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                            complexProperty2.setOldData(AggregationNodeColumnsPIComponentPanel.this._targetNode.getSQLExpression());
                            serializable.add(new Property(String.valueOf(AggregationNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty2, null, null));
                            AggregationNodeColumnsPIComponentPanel.this._model.setValueAt(AggregationPIPropertyLrb.get("PI_AGGREGATION_NODE_EDIT_AGGREGATION_ELEMENT"), AggregationNodeColumnsPIComponentPanel.this._targetNode, (List<Property>)((Object)serializable));
                        }
                    }
                }
            }
        });
        AbstractNode abstractNode = this._targetNode.findParentNode();
        if (abstractNode != null && abstractNode instanceof DataProvider) {
            object = (DataProvider)((Object)abstractNode);
            if (null != object.getAttributes()) {
                boolean bl = null != object.getAttributes().getAttribute() && !object.getAttributes().getAttribute().isEmpty();
                this._addElementBtn.setEnabled(bl);
                this._addExpressionBtn.setEnabled(bl);
                this._wizBtn.setEnabled(bl);
                this.jBtnGroupBy.setEnabled(object != null && null != object.getAttributes() && null != object.getAttributes().getAttribute());
            }
        } else {
            this._addElementBtn.setEnabled(false);
            this._addExpressionBtn.setEnabled(false);
            this._wizBtn.setEnabled(false);
            this.jBtnGroupBy.setEnabled(false);
        }
        object = this._jAttributesTable.getSelectionModel();
        this._removeBtn.setEnabled(!object.isSelectionEmpty());
        this._editBtn.setEnabled(!object.isSelectionEmpty() && object.getMinSelectionIndex() == object.getMaxSelectionIndex());
        this.setWritableControls();
    }

    private void setWritableControls() {
        boolean bl = this.isWritable();
        if (!bl) {
            this._removeBtn.setEnabled(false);
            this._editBtn.setEnabled(false);
            this._addElementBtn.setEnabled(false);
            this._addExpressionBtn.setEnabled(false);
            this._wizBtn.setEnabled(false);
            this.jBtnGroupBy.setEnabled(false);
        }
        ((GeneralAttributesTableModel)((Object)this._jAttributesTable.getModel())).setWritable(bl);
    }

    public void updateUI(PropertyModel propertyModel) {
        Object object;
        TableColumnModel tableColumnModel;
        Object object2;
        if (!(propertyModel instanceof WorkflowAggregationNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowAggregationNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        this._targetColumns.clear();
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this._targetNode.getData();
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        List list = aggregationNodeType.getAggregationElements().getAggregationElement();
        if (list != null && !list.isEmpty()) {
            AttributeTypeHelper.copyAttributes(this._targetColumns, list);
            this.validateSourceColumn();
        }
        this.jTxtGroupBy.setEditable(false);
        this.jTxtGroupBy.setText(AttributeTypeHelper.convertGroupingElementTypetoString(groupingElementType));
        if (!this.isValidMainGroupBy(groupingElementType)) {
            this.jLabelGroupBy.setIcon(OracleIcons.getIcon((String)"warning.png"));
            this.jLabelGroupBy.setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_MAIN_GROUP_BY_INVALID"));
        } else {
            this.jLabelGroupBy.setIcon(null);
            this.jLabelGroupBy.setToolTipText(null);
        }
        int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
        HashMap<String, TableColumnModel> hashMap = null;
        if (nArray != null && nArray.length > 0) {
            object2 = (GeneralAttributesTableModel)((Object)this._jAttributesTable.getModel());
            hashMap = new HashMap<String, TableColumnModel>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                tableColumnModel = (AggregationElementType)((ODMrTableModel)((Object)object2)).getSrcData().get(nArray[i]);
                String string = tableColumnModel.getOutput().getName();
                hashMap.put(string, tableColumnModel);
            }
        }
        object2 = this._jAttributesTable.getVisibleRect();
        TableColumn tableColumn = null;
        tableColumnModel = this._jAttributesTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            nArray2[i] = tableColumn.getPreferredWidth();
        }
        GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(this._targetColumns);
        this.setupItemsTable(generalAttributesTableModel);
        if (hashMap != null) {
            Object object3;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            object = generalAttributesTableModel.getSrcData();
            for (int i = 0; i < object.size(); ++i) {
                object3 = (AggregationElementType)object.get(i);
                String string = object3.getOutput().getName();
                if (null == hashMap.get(string)) continue;
                arrayList.add(i);
            }
            if (!arrayList.isEmpty()) {
                Integer[] integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                object3 = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object3[i] = (AggregationElementType)integerArray[i];
                }
                this._jAttributesTable.setSelectedRowsInModel((int[])object3);
            }
        }
        this._jAttributesTable.scrollRectToVisible((Rectangle)object2);
        tableColumnModel = this._jAttributesTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        if (n == n2) {
            for (int i = 0; i < n2; ++i) {
                tableColumn = tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(nArray2[i]);
            }
        }
        if ((object = this._targetNode.findParentNode()) != null && object instanceof DataProvider) {
            DataProvider dataProvider = (DataProvider)object;
            if (null != dataProvider.getAttributes()) {
                boolean bl = null != dataProvider.getAttributes().getAttribute() && !dataProvider.getAttributes().getAttribute().isEmpty();
                this._addElementBtn.setEnabled(bl);
                this._addExpressionBtn.setEnabled(bl);
                this._wizBtn.setEnabled(bl);
                this.jBtnGroupBy.setEnabled(dataProvider != null && null != dataProvider.getAttributes() && null != dataProvider.getAttributes().getAttribute());
            }
        } else {
            this._addElementBtn.setEnabled(false);
            this._addExpressionBtn.setEnabled(false);
            this._wizBtn.setEnabled(false);
            this.jBtnGroupBy.setEnabled(false);
        }
        ListSelectionModel listSelectionModel = this._jAttributesTable.getSelectionModel();
        this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this._editBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex());
        this.setWritableControls();
    }

    private boolean isValidMainGroupBy(GroupingElementType groupingElementType) {
        AbstractNode abstractNode = this._targetNode.findParentNode();
        if (abstractNode != null && !(abstractNode instanceof DataProvider)) {
            return false;
        }
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        if (null == dataProvider || null == dataProvider.getAttributes() || dataProvider.getAttributes().getAttribute().isEmpty()) {
            return false;
        }
        boolean bl = true;
        List list = dataProvider.getAttributes().getAttribute();
        Attributes attributes = groupingElementType.getAttributes();
        if (null != attributes) {
            List list2 = attributes.getAttribute();
            for (AttributeType attributeType : list2) {
                boolean bl2 = false;
                for (AttributeType attributeType2 : list) {
                    if (!attributeType.getName().equals(attributeType2.getName())) continue;
                    attributeType.setStatus(attributeType2.getStatus());
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    attributeType.setStatus(AttributeStatus.MISSING);
                }
                if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void validateSourceColumn() {
        AbstractNode abstractNode = this._targetNode.findParentNode();
        if (abstractNode != null && !(abstractNode instanceof DataProvider)) {
            this.setStatusAllSourceColumns(this._targetColumns);
            return;
        }
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        if (null == dataProvider || null == dataProvider.getAttributes() || dataProvider.getAttributes().getAttribute().isEmpty()) {
            this.setStatusAllSourceColumns(this._targetColumns);
            return;
        }
        List list = dataProvider.getAttributes().getAttribute();
        for (AggregationElementType aggregationElementType : this._targetColumns) {
            this.validateSourceElement(list, aggregationElementType);
            this.validateSubGroupingBy(list, aggregationElementType);
        }
    }

    private void validateSourceElement(List<AttributeType> list, AggregationElementType aggregationElementType) {
        GroupingElementType groupingElementType = aggregationElementType.getSource();
        Attributes attributes = groupingElementType.getAttributes();
        if (null != attributes) {
            List list2 = attributes.getAttribute();
            for (AttributeType attributeType : list2) {
                boolean bl = false;
                for (AttributeType attributeType2 : list) {
                    if (!attributeType.getName().equals(attributeType2.getName())) continue;
                    attributeType.setStatus(attributeType2.getStatus());
                    aggregationElementType.getOutput().setStatus(attributeType2.getStatus());
                    bl = true;
                    break;
                }
                if (bl) continue;
                attributeType.setStatus(AttributeStatus.MISSING);
                aggregationElementType.getOutput().setStatus(AttributeStatus.MISSING);
            }
        }
    }

    private void validateSubGroupingBy(List<AttributeType> list, AggregationElementType aggregationElementType) {
        GroupingElementType groupingElementType = aggregationElementType.getSubGroupBy();
        Attributes attributes = groupingElementType.getAttributes();
        if (null != attributes) {
            List list2 = attributes.getAttribute();
            for (AttributeType attributeType : list2) {
                boolean bl = false;
                for (AttributeType attributeType2 : list) {
                    if (!attributeType.getName().equals(attributeType2.getName())) continue;
                    aggregationElementType.getOutput().setStatus(attributeType2.getStatus());
                    bl = true;
                    break;
                }
                if (!bl) {
                    aggregationElementType.getOutput().setStatus(AttributeStatus.MISSING);
                }
                if (!aggregationElementType.getOutput().getStatus().equals((Object)AttributeStatus.MISSING)) continue;
                break;
            }
        }
    }

    private void setStatusAllSourceColumns(List<AggregationElementType> list) {
        AttributeStatus attributeStatus = AttributeStatus.MISSING;
        for (AggregationElementType aggregationElementType : list) {
            Attributes attributes = aggregationElementType.getSource().getAttributes();
            if (null != attributes) {
                List list2 = attributes.getAttribute();
                for (AttributeType attributeType : list2) {
                    attributeType.setStatus(attributeStatus);
                }
            }
            aggregationElementType.getOutput().setStatus(attributeStatus);
        }
    }

    private void setupItemsTable(GeneralAttributesTableModel generalAttributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.setAutoResizeMode(4);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                AbstractNode abstractNode;
                boolean bl3 = false;
                GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeColumnsPIComponentPanel.this._jAttributesTable.getModel());
                int n3 = AggregationNodeColumnsPIComponentPanel.this._jAttributesTable.convertRowIndexToModel(n);
                AggregationElementType aggregationElementType = (AggregationElementType)generalAttributesTableModel.getSrcData().get(n3);
                Attributes attributes = aggregationElementType.getSource().getAttributes();
                if (null != attributes && null != attributes.getAttribute()) {
                    List list = attributes.getAttribute();
                    if (!list.isEmpty()) {
                        for (AttributeType attributeType : list) {
                            if (!attributeType.getName().equals(object.toString()) || 0 != attributeType.getStatus().compareTo((Enum)AttributeStatus.VALID)) continue;
                            bl3 = true;
                            break;
                        }
                    }
                } else if (null != aggregationElementType.getSource().getExpression() && (abstractNode = AggregationNodeColumnsPIComponentPanel.this._targetNode.findParentNode()) != null && abstractNode instanceof DataProvider) {
                    DataProvider dataProvider = (DataProvider)((Object)abstractNode);
                    bl3 = null != dataProvider && null != dataProvider.getAttributes() && !dataProvider.getAttributes().getAttribute().isEmpty();
                }
                return bl3 ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png");
            }
        });
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
    }

    private static class GeneralAttributesTableModel
    extends ODMrTableModel<AggregationElementType> {
        private boolean _writable = true;

        private GeneralAttributesTableModel(List<AggregationElementType> list) {
            super(_columnNames, list);
        }

        public void setWritable(boolean bl) {
            this._writable = true;
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AggregationElementType aggregationElementType = (AggregationElementType)this.srcData.get(n);
            String string = null;
            if (n2 == 0) {
                GroupingElementType groupingElementType = aggregationElementType.getSource();
                if (null == groupingElementType.getExpression()) {
                    List list = groupingElementType.getAttributes().getAttribute();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (AttributeType attributeType : list) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(attributeType.getName());
                    }
                    string = stringBuilder.toString();
                } else {
                    string = groupingElementType.getExpression();
                }
            } else if (n2 == 1) {
                AttributeType attributeType = aggregationElementType.getOutput();
                string = attributeType.getName();
            } else if (n2 == 2) {
                string = aggregationElementType.getAggregationFunction();
            } else if (n2 == 3) {
                GroupingElementType groupingElementType = aggregationElementType.getSubGroupBy();
                if (null != groupingElementType.getAttributes()) {
                    List list = groupingElementType.getAttributes().getAttribute();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (AttributeType attributeType : list) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(attributeType.getName());
                    }
                    string = stringBuilder.toString();
                } else {
                    string = groupingElementType.getExpression();
                }
            } else assert (false) : "Out of bounds column when accessing items";
            return string != null ? string : "";
        }

        @Override
        public Class getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

