/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dmt.dataminer.expressionbuilder.ComputeFieldContext;
import oracle.dmt.dataminer.expressionbuilder.DialogsLrb;
import oracle.dmt.dataminer.expressionbuilder.ExpressionBuilderDialog;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConnectionProperties;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditExpressionPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DBHelper;
import oracle.dmt.dataminer.workflow.dialog.rowFilter.FilterPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.CustomTransformationPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleCallableStatement;

public class CustomPanel
extends FilterPanel {
    private static final String newAttributeQuery2 = "SELECT {0} AS \"{1}\" FROM ( {2} )";
    private TransformationStatisticsState _state;
    private String _outputColumnName;
    private String _inputSQL;
    private CustomTransformationPanel _parent;
    private boolean _enableNameInput = true;

    public CustomPanel(Context context, CustomTransformationPanel customTransformationPanel, TransformationStatisticsState transformationStatisticsState, TransformationOutputAttribute transformationOutputAttribute, boolean bl) {
        super(context, null);
        this._state = transformationStatisticsState;
        this._parent = customTransformationPanel;
        this._enableNameInput = bl;
        TransformationNode transformationNode = this._state.getTransformationNode();
        this._inputSQL = transformationNode.getInputSQL(false);
        if (transformationOutputAttribute != null) {
            TransformationType.CustomTransformation customTransformation = transformationOutputAttribute.getTransformationElementType().getCustomTransformation();
            String string = transformationOutputAttribute.getTransformationElementType().getCustomTransformationEx();
            if (customTransformation != null && string == null) {
                this._filter = customTransformation.getValue();
            } else if (string != null) {
                this._filter = string;
            }
        }
        this.loadComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initUI() {
        super.initUI();
        this.setTitle(XformDialogsLrb.get("CUSTOM_TRANSFORMATION_TITLE"));
        this._filterTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CustomPanel.this.updateContent();
                CustomPanel.this.enableRemove();
                CustomPanel.this.enableValidateBtn();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CustomPanel.this.updateContent();
                CustomPanel.this.enableRemove();
                CustomPanel.this.enableValidateBtn();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CustomPanel.this.updateContent();
                CustomPanel.this.enableRemove();
                CustomPanel.this.enableValidateBtn();
            }
        });
    }

    public boolean isExpressionEmpty() {
        String string = this._filterTextArea.getText();
        return string.isEmpty();
    }

    private void enableValidateBtn() {
        String string = this._filterTextArea.getText();
        boolean bl = null != (string = string.trim()) && !string.isEmpty();
        this._parent.enableValidateBtn(bl);
    }

    @Override
    protected void processAdd() {
        String[] stringArray = null;
        TransformedAttributes transformedAttributes = this._state.getTransformedAttributes();
        if (transformedAttributes != null && transformedAttributes.getMapTransformedSourceType() != null && !transformedAttributes.getMapTransformedSourceType().isEmpty()) {
            stringArray = new String[transformedAttributes.getMapTransformedSourceType().size()];
            int n = 0;
            for (MapTransformedSource mapTransformedSource : transformedAttributes.getMapTransformedSourceType()) {
                stringArray[n++] = mapTransformedSource.getKey().getName();
            }
        }
        this._outputColumnName = this._parent.getCustomOutputName();
        ComputeFieldContext computeFieldContext = new ComputeFieldContext(this._inputSQL, this._state.getTransformationNode(), this._outputColumnName, this._filter, stringArray);
        ExpressionBuilderDialog expressionBuilderDialog = new ExpressionBuilderDialog(this._enableNameInput);
        if (expressionBuilderDialog.invoke(this.getContext(), computeFieldContext)) {
            this._filter = expressionBuilderDialog.getExpression();
            if (this._enableNameInput) {
                this._outputColumnName = expressionBuilderDialog.getAttributeName();
                this._parent.updateOutputName(this._outputColumnName);
            }
            this._filterTextArea.setText(this._filter);
            this._dirty = true;
        }
    }

    public String getExpression() {
        String string = this._filterTextArea.getText();
        string = string.trim();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validateExpression() {
        Object object;
        Object object2;
        String string = this._filterTextArea.getText();
        String string2 = this._parent.getCustomOutputName();
        this._outputColumnName = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        string = string.trim();
        String string3 = null;
        if (null == string || string.isEmpty()) {
            string3 = DialogsLrb.get("EXPBLDR_ERROR_EXPRESSION_EMPTY");
            return string3;
        }
        try {
            AggregateEditExpressionPanel.executeSQL(this._context, this._inputSQL);
        }
        catch (Exception exception) {
            object2 = this._state.getTransformationNode();
            object = ((AbstractNode)object2).findParentNode();
            boolean bl = ((AbstractNode)object).validateCompleteChain(true);
            string3 = bl ? exception.getLocalizedMessage() : DialogsLrb.get("EXPBLDR_PANEL_VALIDATE_RUN_PARENT");
        }
        if (string3 != null) {
            return string3;
        }
        StringBuffer stringBuffer = new StringBuffer(32000);
        stringBuffer.append(this.formNewAttributeQuery());
        object2 = new SQLHelper();
        try {
            ((SQLHelper)object2).conn = ConnectionFolder.getConnection(this._context, ConnectionProperties.ALTER_SESSION_FIXES);
            object = "";
            ((SQLHelper)object2).cstmt = (OracleCallableStatement)((SQLHelper)object2).conn.prepareCall("{call ODMR_UTIL.CLIENT_VALIDATE_SQL(?,?)}");
            ((SQLHelper)object2).cstmt.setCharacterStream(1, (Reader)new StringReader(stringBuffer.toString()), stringBuffer.length());
            ((SQLHelper)object2).cstmt.setString(2, (String)object);
            ((SQLHelper)object2).cstmt.registerOutParameter(2, 12);
            ((SQLHelper)object2).cstmt.execute();
        }
        catch (SQLException sQLException) {
            string3 = sQLException.getLocalizedMessage();
        }
        finally {
            ((SQLHelper)object2).close();
        }
        return string3;
    }

    public String validateExpression2() throws Exception {
        String string = this._filterTextArea.getText();
        string = string.trim();
        String string2 = null;
        if (null == string || string.isEmpty()) {
            string2 = DialogsLrb.get("EXPBLDR_ERROR_EXPRESSION_EMPTY");
            throw new Exception(string2);
        }
        try {
            AggregateEditExpressionPanel.executeSQL(this._context, this._inputSQL);
        }
        catch (Exception exception) {
            TransformationNode transformationNode = this._state.getTransformationNode();
            AbstractNode abstractNode = transformationNode.findParentNode();
            boolean bl = abstractNode.validateCompleteChain(true);
            if (bl) {
                throw exception;
            }
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("EXPBLDR_PANEL_VALIDATE_RUN_PARENT_CONFIRM"), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null)) {
                return "VARCHAR2";
            }
            throw new ProceedWithoutValidationException();
        }
        StringBuffer stringBuffer = new StringBuffer(32000);
        stringBuffer.append(this.formNewAttributeQuery());
        String string3 = DBHelper.clientValidate(this._context, stringBuffer);
        return string3;
    }

    private String formNewAttributeQuery() {
        Object[] objectArray = new Object[]{this._filter, this._outputColumnName, this._inputSQL};
        return MessageFormat.format(newAttributeQuery2, objectArray);
    }

    public void setOutputColumnName(String string) {
        this._outputColumnName = string;
    }

    public void setEnableNameInput(boolean bl) {
        this._enableNameInput = bl;
    }

    public static class ProceedWithoutValidationException
    extends Exception {
    }
}

