/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningCustomBase;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningCustomCategoric;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningCustomNumeric;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningDetailsNumeric;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningPanelSimple;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningPanelSimple2;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningPanelSimpleNumeric;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningPrepareCustomDefaults;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.BinGeneration;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.TransformNulls;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class BinningPanel
extends DialogDisplayer {
    private String selectedBinngType;
    private Integer bincount;
    private int dataType;
    private BinGeneration binGeneration;
    private BinLabels binLabels;
    private TransformNulls transformNulls;
    private Object customBinning;
    private boolean showCustom;
    private TransformationStatisticsState state;
    private String srcColumnName;
    private String srcColumnType;
    private boolean showTransformNULLsCheckBox = true;
    private TransformationType resultTransformationType;
    private JComboBox jComboBoxType;
    private JLabel jLabelType;
    private JPanel jPanelBinningDetails;
    private BinningPanelSimpleNumeric binningEqWidthpanel;
    private BinningPanelSimpleNumeric binningQuantilepanel;
    private BinningCustomBase binningCustompanel;
    private BinningDetailsNumeric activePanel;
    private Map<String, BinningDetailsNumeric> panels = new HashMap<String, BinningDetailsNumeric>();

    public BinningPanel(String string, String string2, TransformationStatisticsState transformationStatisticsState, String string3, int n, int n2, BinGeneration binGeneration, BinLabels binLabels, Object object, TransformNulls transformNulls) {
        this.srcColumnName = string;
        this.srcColumnType = string2;
        this.state = transformationStatisticsState;
        this.selectedBinngType = string3.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC()) || string3.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC()) || string3.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP()) || string3.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE()) ? TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM() : string3;
        this.bincount = n;
        this.dataType = n2;
        this.binGeneration = binGeneration;
        this.binLabels = binLabels;
        this.customBinning = object;
        this.transformNulls = transformNulls;
        this.showCustom = true;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public BinningPanel(TransformationStatisticsState transformationStatisticsState, String string, int n, int n2, BinGeneration binGeneration, BinLabels binLabels, Object object, TransformNulls transformNulls) {
        this.state = transformationStatisticsState;
        this.selectedBinngType = string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC()) || string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC()) || string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP()) || string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE()) ? TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM() : string;
        this.bincount = n;
        this.dataType = n2;
        this.binGeneration = binGeneration;
        this.binLabels = binLabels;
        this.transformNulls = transformNulls;
        this.customBinning = object;
        this.showCustom = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public BinningPanel(String string, String string2, TransformationStatisticsState transformationStatisticsState, int n) {
        this.srcColumnName = string;
        this.srcColumnType = string2;
        this.state = transformationStatisticsState;
        this.dataType = n;
        this.bincount = TransformationStatisticsState.DEFAULT_BIN_COUNT;
        this.binGeneration = new BinGeneration();
        this.binGeneration.setManual(new BinGeneration.Manual());
        this.binLabels = new BinLabels();
        this.binLabels.setRange(new BinLabels.Range());
        this.transformNulls = AttributeTypeHelper.cloneTransformNulls(null);
        this.showCustom = true;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public BinningPanel(TransformationStatisticsState transformationStatisticsState, int n) {
        this.state = transformationStatisticsState;
        this.dataType = n;
        this.bincount = TransformationStatisticsState.DEFAULT_BIN_COUNT;
        this.binGeneration = new BinGeneration();
        this.binGeneration.setManual(new BinGeneration.Manual());
        this.binLabels = new BinLabels();
        this.binLabels.setRange(new BinLabels.Range());
        this.transformNulls = AttributeTypeHelper.cloneTransformNulls(null);
        this.showCustom = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public BinningPanel(String string, String string2, TransformationStatisticsState transformationStatisticsState, int n, int n2, boolean bl) {
        this.srcColumnName = string;
        this.srcColumnType = string2;
        this.state = transformationStatisticsState;
        this.dataType = n;
        this.bincount = n2;
        this.binGeneration = new BinGeneration();
        this.binGeneration.setManual(new BinGeneration.Manual());
        this.binLabels = new BinLabels();
        this.binLabels.setRange(new BinLabels.Range());
        this.transformNulls = AttributeTypeHelper.cloneTransformNulls(null);
        this.showCustom = bl;
        this.showTransformNULLsCheckBox = false;
        this.initComponents();
        this.initRes();
        this.initUI2();
    }

    private void initComponents() {
        this.jComboBoxType = new JComboBox();
        this.jLabelType = new JLabel();
        this.jPanelBinningDetails = new JPanel();
        this.jComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabelType.setText("Binning Type:");
        this.jPanelBinningDetails.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelType, -2, 150, -2).addGap(18, 18, 18).addComponent(this.jComboBoxType, 0, 294, Short.MAX_VALUE)).addComponent(this.jPanelBinningDetails, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelType).addComponent(this.jComboBoxType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelBinningDetails, -1, 190, Short.MAX_VALUE).addContainerGap()));
    }

    public String getSelectedBinngType() {
        this.selectedBinngType = (String)this.jComboBoxType.getSelectedItem();
        boolean bl = this.isCustomNumericBinning();
        if (this.selectedBinngType.equals(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM())) {
            if (this.dataType == 1 || bl) {
                return TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC();
            }
            if (this.dataType == 2) {
                return TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC();
            }
            if (TransformationTypes.isDateOrTimestampDerived(this.dataType)) {
                if (this.dataType == 6) {
                    return TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE();
                }
                return TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP();
            }
        }
        return this.selectedBinngType;
    }

    public Integer getBincount() {
        return this.activePanel.getBinCount();
    }

    public boolean isCustomBinning() {
        if (this.activePanel instanceof BinningCustomBase) {
            return ((BinningCustomBase)this.activePanel).isCustomBinning();
        }
        return false;
    }

    public String getOtherName() {
        JTextField jTextField;
        if (this.activePanel instanceof BinningCustomBase && (jTextField = ((BinningCustomBase)this.activePanel).getJTextFieldOther()) != null) {
            return jTextField.getText();
        }
        return null;
    }

    public Object getCustomBinning() {
        if (this.activePanel instanceof BinningCustomBase) {
            return ((BinningCustomBase)this.activePanel).getCustomBinning();
        }
        return null;
    }

    public boolean isInvalidRange() {
        if (this.activePanel instanceof BinningCustomBase) {
            return ((BinningCustomBase)this.activePanel).isInvalidRange();
        }
        return true;
    }

    public TransformNulls getTransformNulls() {
        if (this.activePanel instanceof BinningDetailsNumeric || this.activePanel instanceof BinningCustomBase) {
            return this.activePanel.getResultTransformNulls();
        }
        return null;
    }

    public boolean isAuto() {
        if (this.activePanel instanceof BinningDetailsNumeric) {
            return this.activePanel.isAuto();
        }
        return false;
    }

    public boolean isLabels() {
        if (this.activePanel instanceof BinningDetailsNumeric) {
            return this.activePanel.isLabels();
        }
        return false;
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelType, (Component)this.jComboBoxType, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BINNING_TYPE"));
    }

    public boolean isCustomNumericBinning() {
        boolean bl = this.customBinning != null && this.customBinning instanceof TransformationType.Binning.CustomNumeric;
        return bl;
    }

    public boolean isCustomCategoricBinning() {
        boolean bl = this.customBinning != null && this.customBinning instanceof TransformationType.Binning.CustomCategorical;
        return bl;
    }

    @Override
    public void initUI() {
        Object object;
        DefaultComboBoxModel<Object> defaultComboBoxModel = null;
        boolean bl = this.isCustomNumericBinning();
        if (this.dataType == 1 || this.dataType == 0 || bl) {
            this.binningEqWidthpanel = new BinningPanelSimpleNumeric(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER(), this.bincount, this.binGeneration, this.binLabels, this.transformNulls, this.showTransformNULLsCheckBox);
            this.panels.put(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER(), this.binningEqWidthpanel);
            this.jPanelBinningDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER(), this.binningEqWidthpanel);
            this.binningQuantilepanel = new BinningPanelSimpleNumeric(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_QUANTILE(), this.bincount, this.binGeneration, this.binLabels, this.transformNulls, this.showTransformNULLsCheckBox);
            this.panels.put(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_QUANTILE(), this.binningQuantilepanel);
            this.jPanelBinningDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_QUANTILE(), this.binningQuantilepanel);
            if (this.showCustom) {
                this.binningCustompanel = new BinningCustomNumeric(this.srcColumnName, this.srcColumnType, this.state, TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.customBinning, 1, this.transformNulls);
                this.panels.put(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.binningCustompanel);
                this.jPanelBinningDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.binningCustompanel);
                defaultComboBoxModel = new DefaultComboBoxModel<String>(TransformationTypes.getBinningNumericTypes());
            } else {
                defaultComboBoxModel = new DefaultComboBoxModel<String>(TransformationTypes.getBinningNumericTypesNoCustom());
            }
        } else if (this.dataType == 2) {
            object = new BinningPanelSimple(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN(), this.bincount, this.transformNulls, this.showTransformNULLsCheckBox);
            this.panels.put(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN(), (BinningDetailsNumeric)object);
            this.jPanelBinningDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN(), (Component)object);
            if (this.showCustom) {
                this.binningCustompanel = new BinningCustomCategoric(this.srcColumnName, this.srcColumnType, this.state, TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.customBinning, 2, this.transformNulls);
                this.panels.put(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.binningCustompanel);
                this.jPanelBinningDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.binningCustompanel);
                defaultComboBoxModel = new DefaultComboBoxModel<String>(TransformationTypes.getBinningCategoricTypes());
            } else {
                defaultComboBoxModel = new DefaultComboBoxModel<String>(TransformationTypes.getBinningCategoricTypesNoCustom());
            }
        } else if (this.dataType == 3 || this.dataType == 4 || this.dataType == 6) {
            object = this.dataType == 6 ? TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_TIMESTAMP_WITH_TIMEZONE() : TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_DATE();
            this.binningEqWidthpanel = new BinningPanelSimpleNumeric((String)object, this.bincount, this.binGeneration, this.binLabels, this.transformNulls, this.showTransformNULLsCheckBox);
            this.panels.put((String)object, this.binningEqWidthpanel);
            this.jPanelBinningDetails.add((String)object, this.binningEqWidthpanel);
            if (this.showCustom) {
                this.binningCustompanel = new BinningCustomNumeric(this.srcColumnName, this.srcColumnType, this.state, TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.customBinning, this.dataType, this.transformNulls);
                this.panels.put(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.binningCustompanel);
                this.jPanelBinningDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.binningCustompanel);
                defaultComboBoxModel = new DefaultComboBoxModel<String>(this.dataType == 6 ? TransformationTypes.getBinningTimestampTZTypes() : TransformationTypes.getBinningDateTypes());
            } else {
                defaultComboBoxModel = new DefaultComboBoxModel<String>(this.dataType == 6 ? TransformationTypes.getBinningTimestampTimeZoneTypesNoCustom() : TransformationTypes.getBinningDateTypesNoCustom());
            }
        } else {
            defaultComboBoxModel = new DefaultComboBoxModel();
        }
        this.jComboBoxType.setModel(defaultComboBoxModel);
        if (this.selectedBinngType == null) {
            this.selectedBinngType = (String)this.jComboBoxType.getItemAt(0);
        }
        this.jComboBoxType.setSelectedItem(this.selectedBinngType);
        object = (String)this.jComboBoxType.getSelectedItem();
        this.jComboBoxType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)BinningPanel.this.jComboBoxType.getSelectedItem();
                BinningPanel.this.showPanel(string);
            }
        });
        this.showPanel((String)object);
    }

    public void initUI2() {
        Object object;
        DefaultComboBoxModel<Object> defaultComboBoxModel = null;
        if (this.dataType == 1 || this.dataType == 0) {
            object = new BinningPrepareCustomDefaults(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER(), this.bincount, this.binGeneration, this.binLabels);
            this.panels.put(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER(), (BinningDetailsNumeric)object);
            this.jPanelBinningDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER(), (Component)object);
            BinningPrepareCustomDefaults binningPrepareCustomDefaults = new BinningPrepareCustomDefaults(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_QUANTILE(), this.bincount, this.binGeneration, this.binLabels);
            this.panels.put(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_QUANTILE(), binningPrepareCustomDefaults);
            this.jPanelBinningDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_QUANTILE(), binningPrepareCustomDefaults);
            defaultComboBoxModel = new DefaultComboBoxModel<String>(TransformationTypes.getBinningNumericTypesNoCustom());
        } else if (this.dataType == 2) {
            object = new BinningPanelSimple2(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN(), this.bincount, this.transformNulls);
            this.panels.put(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN(), (BinningDetailsNumeric)object);
            this.jPanelBinningDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN(), (Component)object);
            if (this.showCustom) {
                this.binningCustompanel = new BinningCustomCategoric(this.srcColumnName, this.srcColumnType, this.state, TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.customBinning, 2, this.transformNulls);
                this.panels.put(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.binningCustompanel);
                this.jPanelBinningDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM(), this.binningCustompanel);
                defaultComboBoxModel = new DefaultComboBoxModel<String>(TransformationTypes.getBinningCategoricTypes());
            } else {
                defaultComboBoxModel = new DefaultComboBoxModel<String>(TransformationTypes.getBinningCategoricTypesNoCustom());
            }
        } else if (this.dataType == 3 || this.dataType == 4 || this.dataType == 6) {
            object = this.dataType == 6 ? TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_TIMESTAMP_WITH_TIMEZONE() : TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_DATE();
            BinningPrepareCustomDefaults binningPrepareCustomDefaults = new BinningPrepareCustomDefaults((String)object, this.bincount, this.binGeneration, this.binLabels);
            this.panels.put((String)object, binningPrepareCustomDefaults);
            this.jPanelBinningDetails.add((String)object, binningPrepareCustomDefaults);
            defaultComboBoxModel = new DefaultComboBoxModel<String>(this.dataType == 6 ? TransformationTypes.getBinningTimestampTimeZoneTypesNoCustom() : TransformationTypes.getBinningDateTypesNoCustom());
        } else {
            defaultComboBoxModel = new DefaultComboBoxModel();
        }
        this.jComboBoxType.setModel(defaultComboBoxModel);
        if (this.selectedBinngType == null) {
            this.selectedBinngType = (String)this.jComboBoxType.getItemAt(0);
        }
        this.jComboBoxType.setSelectedItem(this.selectedBinngType);
        object = (String)this.jComboBoxType.getSelectedItem();
        this.jComboBoxType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)BinningPanel.this.jComboBoxType.getSelectedItem();
                BinningPanel.this.showPanel(string);
            }
        });
        this.showPanel((String)object);
    }

    private void showPanel(String string) {
        CardLayout cardLayout = (CardLayout)this.jPanelBinningDetails.getLayout();
        cardLayout.show(this.jPanelBinningDetails, string);
        Integer n = null;
        boolean bl = false;
        boolean bl2 = false;
        if (this.activePanel != null && !(this.activePanel instanceof BinningCustomBase)) {
            n = this.activePanel.getBinCount();
            bl = this.activePanel.isAuto();
            bl2 = this.activePanel.isLabels();
        }
        this.activePanel = this.panels.get(string);
        if (n != null) {
            this.activePanel.setBinCount(n);
            this.activePanel.setAuto(bl);
            this.activePanel.setLabels(bl2);
            this.activePanel.activateDlg();
        }
    }

    @Override
    public boolean doWork() {
        String string = this.collectResults();
        if (string != null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
            return false;
        }
        return true;
    }

    public String collectResults() {
        String string = null;
        String string2 = (String)this.jComboBoxType.getSelectedItem();
        int n = this.getBincount();
        if (n < 2) {
            string = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_BIN_COUNT_INVALID_2");
            return string;
        }
        if (string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER()) || string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_DATE()) || string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_TIMESTAMP_WITH_TIMEZONE()) || string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_QUANTILE()) || string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN())) {
            if (n < 3 && string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN())) {
                string = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_BIN_COUNT_INVALID");
                return string;
            }
            this.resultTransformationType = TransformationTypes.initBinning(string2, n, this.isAuto(), this.isLabels(), this.getTransformNulls());
        }
        return string;
    }

    public TransformationType getResultTransformationType() {
        return this.resultTransformationType;
    }

    @Override
    protected String getDialogTitle() {
        return XformDialogsLrb.get("ADD_EDIT_BIN_ASSIGNMENT");
    }

    @Override
    protected String getHelpTopic() {
        return "dm_transform_generated_default_bins";
    }
}

