/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.workflow.dialog.transformations.AbstractAttributesTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.AbstractTransformationWizardPage;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddAttributesTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.ApplyTransformWizardModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditAttributesTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class ApplyTransformWizardStepTwo
extends AbstractTransformationWizardPage {
    private SearchField _searchField;
    private Component _findPane;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(XformDialogsLrb.get("STATISTIC_TAB_COLUMN_SRC_COLUMN"));
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JButton jButtonRevert;
    private JCheckBox jCheckBoxGenerate;
    private JLabel jLabelTitle;
    private DataMinerTable _jAttributesTable = new DataMinerTable();

    public ApplyTransformWizardStepTwo() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jButtonRevert = new JButton();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jCheckBoxGenerate = new JCheckBox();
        this.jLabelTitle.setText("Transformed Columns");
        this.jButtonRevert.setText("Revert to Original Names");
        this.jCheckBoxGenerate.setText("Generate Statistics on Finish");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTitle, -1, 380, Short.MAX_VALUE).addComponent(this.jButtonRevert, GroupLayout.Alignment.TRAILING, -2, 177, -2).addComponent(this.jCheckBoxGenerate, -2, 234, -2)).addContainerGap()).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 380, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRevert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 216, Short.MAX_VALUE).addComponent(this.jCheckBoxGenerate).addContainerGap()).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(75, 75, 75).addComponent((Component)this.jAttributesComponent, -1, 182, Short.MAX_VALUE).addGap(43, 43, 43))));
    }

    @Override
    public String getPageDirtyKey() {
        return "transformationsDirty";
    }

    @Override
    protected String getValidationMessage() {
        return XformDialogsLrb.get("TRANSFORMATION_WIZ_COLUMNS_PAGE_VALIDATION_MESSAGE");
    }

    @Override
    protected String getValidationTitle() {
        return XformDialogsLrb.get("TRANSFORMATION_WIZ_COLUMNS_PAGE_VALIDATE_TITLE");
    }

    @Override
    protected String getValidationFailedMessage() {
        return XformDialogsLrb.get("TRANSFORMATION_WIZ_COLUMNS_PAGE_VALIDATE_TITLE");
    }

    public void initRes(ApplyTransformWizardModel applyTransformWizardModel) {
        if (applyTransformWizardModel.isEditingMode()) {
            this.jLabelTitle.setText(XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_PAGE_TWO_HEADER_EDIT"));
            this.jButtonRevert.setText(XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_PAGE_TWO_HEADER_EDIT_REVERT"));
        } else {
            this.jLabelTitle.setText(XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_PAGE_TWO_HEADER_ADD"));
            this.jButtonRevert.setVisible(false);
        }
        if (applyTransformWizardModel.isCheckBoxVisible()) {
            this.jCheckBoxGenerate.setText(XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_PAGE_TWO_GENERATE_STATS"));
        } else {
            this.jCheckBoxGenerate.setVisible(false);
        }
    }

    @Override
    public void initUI() {
        this._jAttributesTable.setTooltipEnable(true);
        ApplyTransformWizardModel applyTransformWizardModel = this.getModel(this.getTraversableContext());
        this.initRes(applyTransformWizardModel);
        AbstractAttributesTableModel abstractAttributesTableModel = null;
        abstractAttributesTableModel = !applyTransformWizardModel.isEditingMode() ? new AddAttributesTableModel(applyTransformWizardModel) : new EditAttributesTableModel(applyTransformWizardModel);
        this.setupItemsTable(abstractAttributesTableModel, this._jAttributesTable);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this._jAttributesTable.setFillsViewportHeight(true);
        if (applyTransformWizardModel.isCheckBoxVisible()) {
            this.jCheckBoxGenerate.setSelected(applyTransformWizardModel.isGenerateStatsOnFinish());
            this.jCheckBoxGenerate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyTransformWizardStepTwo.this.getModel(ApplyTransformWizardStepTwo.this.getTraversableContext()).setGenerateStatsOnFinish(ApplyTransformWizardStepTwo.this.jCheckBoxGenerate.isSelected());
                }
            });
        }
        if (applyTransformWizardModel.isEditingMode()) {
            this.jButtonRevert.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditAttributesTableModel editAttributesTableModel = (EditAttributesTableModel)((Object)ApplyTransformWizardStepTwo.this._jAttributesTable.getModel());
                    editAttributesTableModel.revertNames();
                    editAttributesTableModel.fireTableDataChanged();
                }
            });
        }
        this._findPane = this.createFindPane(applyTransformWizardModel);
        ControlBar controlBar = new ControlBar();
        controlBar.addSeparator();
        controlBar.add(this._findPane);
        this.jAttributesComponent.setControlBar(controlBar);
    }

    private void setupItemsTable(GenericBaseTableModel genericBaseTableModel, GenericTable genericTable) {
        genericTable.setModel((TableModel)genericBaseTableModel);
        genericTable.setSorted(true);
        genericTable.setSortColumn(0, true);
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        ApplyTransformWizardModel applyTransformWizardModel = this.getModel(this.getTraversableContext());
        applyTransformWizardModel.prepareResultColumnsList((AbstractAttributesTableModel)((Object)this._jAttributesTable.getModel()));
        return true;
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                ApplyTransformWizardStepTwo.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                ApplyTransformWizardStepTwo.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                ApplyTransformWizardStepTwo.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                ApplyTransformWizardStepTwo.this.processFilter(string);
            }
        });
        return searchField;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    protected Component createFindPane(ApplyTransformWizardModel applyTransformWizardModel) {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl(applyTransformWizardModel);
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 250);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private void setupFilterCtl(ApplyTransformWizardModel applyTransformWizardModel) {
        this._currentSearchCategory = 0;
        this._searchField.addCategory(this._defaultSearchCategory);
        if (applyTransformWizardModel.isEditingMode()) {
            this._searchField.addCategory(new SearchCategory(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ORIGINAL_COLUMN")));
        }
        this._searchField.addCategory(new SearchCategory(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_OUTPUT_COLUMN")));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    @Override
    protected void onEntryAfterInit(TraversableContext traversableContext) {
        this.processFilter(this._searchField.getText());
    }

    private void processFilter(String string) {
        ApplyTransformWizardModel applyTransformWizardModel = this.getModel(this.getTraversableContext());
        try {
            AbstractAttributesTableModel abstractAttributesTableModel = null;
            abstractAttributesTableModel = !applyTransformWizardModel.isEditingMode() ? new AddAttributesTableModel(applyTransformWizardModel, string, this._currentSearchCategory) : new EditAttributesTableModel(applyTransformWizardModel, string, this._currentSearchCategory);
            this.setupItemsTable(abstractAttributesTableModel, this._jAttributesTable);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_FILTER_ERROR_TITLE"), (String)XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_FILTER_ERROR_MESSAGE"), null);
        }
    }

    private synchronized void translateSearchCategoryToConstant(SearchCategory searchCategory) {
        if (searchCategory.getLabel().equals(XformDialogsLrb.get("STATISTIC_TAB_COLUMN_SRC_COLUMN"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ORIGINAL_COLUMN"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_OUTPUT_COLUMN"))) {
            this._currentSearchCategory = 2;
        } else assert (false) : "Invalid Search Category Code";
    }
}

