/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.Compatibles;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.MiningFunctionOptions;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.EditModelNodePartitionDefPanel;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingsODM;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.ide.Context;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Version;

public class EditModelTableModel
extends GenericBaseTableModel {
    private Vector<TableRow> _data = new Vector(1000, 500);
    private String _ownerSchema = null;
    private Context _context;
    private int COLUMN_COUNT = 8;
    public static final int SCHEMA_MODEL_NAME = 0;
    public static final int FUNCTION = 1;
    public static final int ALGORITHM = 2;
    public static final int PARTITION_KEY = 3;
    public static final int TARGET_ATTRIBUTE = 4;
    public static final int TARGET_DATA_TYPE = 5;
    public static final int CREATION_DATE = 6;
    public static final int COMMENTS = 7;
    public static final int SCHEMA = 8;
    public static final int MODEL_NAME = 9;
    private boolean _filteredTableModel = false;
    private boolean _ownerOnly = true;
    private ArrayList<String> _columnNames = new ArrayList();
    private static final Logger theLogger = Logger.getLogger(EditModelNodePartitionDefPanel.class.getName());
    private static final String QUERY_MODELS = "SELECT A.OWNER             ,\n  A.MODEL_NAME              ,\n  A.MINING_FUNCTION         ,\n  A.ALGORITHM               ,\n  A.CREATION_DATE             ,\n  A.COMMENTS                   ,\n  B.ATTRIBUTE_NAME AS TARGET,\n  B.DATA_TYPE      AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE\n   FROM ALL_MINING_MODELS A,\n  ALL_MINING_MODEL_ATTRIBUTES B\n  WHERE A.OWNER        = B.OWNER(+)\nAND A.MODEL_NAME       = B.MODEL_NAME(+)\nAND A.MINING_FUNCTION IN ('CLASSIFICATION', 'REGRESSION')\nAND A.ALGORITHM != 'ADAPTIVE_BAYES_NETWORK' \nAND B.TARGET           = 'YES'\n  \n  UNION\n \n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET   ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE\n   FROM ALL_MINING_MODELS A\n  WHERE MINING_FUNCTION IN ('CLUSTERING', 'ASSOCIATION_RULES')\n  \n  UNION\n \n SELECT A.OWNER                           ,\n  A.MODEL_NAME                            ,\n  'ANOMALY_DETECTION' AS \"MINING_FUNCTION\",\n  A.ALGORITHM                             ,\n  A.CREATION_DATE             ,\n  A.COMMENTS                   ,\n  NULL AS TARGET                          ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE\n   FROM ALL_MINING_MODELS A,\n  ALL_MINING_MODEL_SETTINGS B\n  WHERE A.OWNER       = B.OWNER(+)\nAND A.MODEL_NAME      = B.MODEL_NAME(+)\nAND A.MINING_FUNCTION = 'CLASSIFICATION'\nAND A.ALGORITHM       = 'SUPPORT_VECTOR_MACHINES'\nAND B.SETTING_NAME    = 'SVMS_OUTLIER_RATE'\n\nUNION\n\n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET   ,\n  NULL AS TARGET_DATA_TYPE,\n  B.SETTING_VALUE AS SVDS_SCORING_MODE\n   FROM ALL_MINING_MODELS A,\n   ALL_MINING_MODEL_SETTINGS B\n  WHERE A.OWNER       = B.OWNER(+)\n    AND A.MODEL_NAME      = B.MODEL_NAME(+)\n    AND A.MINING_FUNCTION = 'FEATURE_EXTRACTION'\n    AND A.ALGORITHM      = 'SINGULAR_VALUE_DECOMP'\n    AND B.SETTING_NAME   = 'SVDS_SCORING_MODE'\n  UNION\n\n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET                          ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE\n   FROM ALL_MINING_MODELS A\n  WHERE  A.MINING_FUNCTION = 'FEATURE_EXTRACTION'\n         AND A.ALGORITHM      = 'NONNEGATIVE_MATRIX_FACTOR'";
    private static final String QUERY_MODELS_PARTITIONS = "WITH partition_keys as \n (SELECT DISTINCT model_name,column_name,position FROM ALL_MINING_MODEL_PARTITIONS),\n model_attributes as\n (SELECT model_name, attribute_name, data_type from ALL_MINING_MODEL_ATTRIBUTES)\nSELECT A.OWNER             ,\n  A.MODEL_NAME              ,\n  A.MINING_FUNCTION         ,\n  A.ALGORITHM               ,\n  A.CREATION_DATE             ,\n  A.COMMENTS                   ,\n  B.ATTRIBUTE_NAME AS TARGET,\n  B.DATA_TYPE      AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n FROM ALL_MINING_MODELS A,\n ALL_MINING_MODEL_ATTRIBUTES B\n WHERE A.OWNER        = B.OWNER(+)\nAND A.MODEL_NAME       = B.MODEL_NAME(+)\nAND A.MINING_FUNCTION IN ('CLASSIFICATION', 'REGRESSION')\nAND A.ALGORITHM != 'ADAPTIVE_BAYES_NETWORK' \nAND B.TARGET           = 'YES'\n  \n  UNION\n \n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET   ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n  FROM ALL_MINING_MODELS A\n  WHERE MINING_FUNCTION IN ('CLUSTERING', 'ASSOCIATION_RULES')\n  \n  UNION\n \n SELECT A.OWNER                           ,\n  A.MODEL_NAME                            ,\n  'ANOMALY_DETECTION' AS \"MINING_FUNCTION\",\n  A.ALGORITHM                             ,\n  A.CREATION_DATE             ,\n  A.COMMENTS                   ,\n  NULL AS TARGET                          ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n  FROM ALL_MINING_MODELS A,\n  ALL_MINING_MODEL_SETTINGS B\n  WHERE A.OWNER       = B.OWNER(+)\nAND A.MODEL_NAME      = B.MODEL_NAME(+)\nAND A.MINING_FUNCTION = 'CLASSIFICATION'\nAND A.ALGORITHM       = 'SUPPORT_VECTOR_MACHINES'\nAND B.SETTING_NAME    = 'SVMS_OUTLIER_RATE'\n\nUNION\n\n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET   ,\n  NULL AS TARGET_DATA_TYPE,\n  B.SETTING_VALUE AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n   FROM ALL_MINING_MODELS A,\n   ALL_MINING_MODEL_SETTINGS B\n  WHERE A.OWNER       = B.OWNER(+)\n    AND A.MODEL_NAME      = B.MODEL_NAME(+)\n    AND A.MINING_FUNCTION = 'FEATURE_EXTRACTION'\n    AND A.ALGORITHM      = 'SINGULAR_VALUE_DECOMP'\n    AND B.SETTING_NAME   = 'SVDS_SCORING_MODE'\n  UNION\n\n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET                          ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n FROM ALL_MINING_MODELS A\n  WHERE  A.MINING_FUNCTION = 'FEATURE_EXTRACTION'\n         AND A.ALGORITHM   = 'NONNEGATIVE_MATRIX_FACTOR'";

    private void addColumnIdentifiers() {
        if (this._columnNames.size() == 0) {
            this._columnNames.add(DialogsLrb.get("MODEL_NODE_MODEL_NAME"));
            this._columnNames.add(DialogsLrb.get("MODEL_NODE_FUNCTION"));
            this._columnNames.add(DialogsLrb.get("MODEL_NODE_MODEL_ALGORITHM"));
            this._columnNames.add(DialogsLrb.get("MODEL_NODE_PARTITION_KEYS"));
            this._columnNames.add(DialogsLrb.get("MODEL_NODE_TARGET"));
            this._columnNames.add(DialogsLrb.get("MODEL_NODE_TARGET_DATA_TYPE"));
            this._columnNames.add(DialogsLrb.get("MODEL_NODE_CREATION_DATE"));
            this._columnNames.add(DialogsLrb.get("MODEL_NODE_COMMENTS"));
        }
    }

    public EditModelTableModel(String string, Context context) {
        assert (string != null) : "Can not pass a null ownerSchema in to the constructor";
        assert (context != null) : "Can not pass a null context in to the constructor";
        this._ownerSchema = string;
        this._context = context;
        this.setRowCount(0);
        this.addColumnIdentifiers();
        this.setColumnIdentifiers(this._columnNames.toArray());
        this.setColumnCount(this.COLUMN_COUNT);
    }

    public EditModelTableModel(String string, Vector<TableRow> vector, Context context) {
        assert (string != null) : "Can not pass a null ownerSchema in to the constructor";
        this._context = context;
        this._ownerSchema = string;
        this._data = vector;
        this.setRowCount(vector.size());
        this.addColumnIdentifiers();
        this.setColumnIdentifiers(this._columnNames.toArray());
        this.setColumnCount(this.COLUMN_COUNT);
        this.isModelsFromOtherSchemas();
    }

    public EditModelTableModel(Context context) {
        this._context = context;
        this.setRowCount(0);
        this.addColumnIdentifiers();
        this.setColumnIdentifiers(this._columnNames.toArray());
        this.setColumnCount(this.COLUMN_COUNT);
    }

    public boolean isModelsFromOtherSchemas() {
        boolean bl = false;
        for (TableRow tableRow : this._data) {
            if (tableRow._schema.compareTo(this._ownerSchema) == 0) continue;
            bl = true;
            break;
        }
        this._ownerOnly = !bl;
        return bl;
    }

    public boolean areModelsValid() {
        boolean bl = true;
        for (TableRow tableRow : this._data) {
            if (tableRow.getStatus() != RefModelStatusType.INVALID) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public TableRow getRow(int n) {
        return this._data.get(n);
    }

    private void clear() {
        this._data.clear();
    }

    private void addDataItem(TableRow tableRow) {
        this._data.add(tableRow);
    }

    public void addRows(Vector<TableRow> vector) {
        for (TableRow tableRow : vector) {
            this.getDataVector().add(tableRow);
        }
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<TableRow> vector = new Vector<TableRow>();
        TableRow tableRow = null;
        for (int i = 0; i < nArray.length; ++i) {
            tableRow = this._data.elementAt(nArray[i]);
            vector.add(tableRow);
        }
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public boolean partitionKeysCompatible(int[] nArray) {
        boolean bl = true;
        TableRow tableRow = null;
        if (nArray.length > 1) {
            tableRow = this._data.elementAt(nArray[0]);
            String string = tableRow.getPartitionKey();
            String string2 = tableRow.getModelName();
            String string3 = tableRow.getSchema();
            for (int i = 1; i < nArray.length && (bl = this.areKeysCompatible(string3, string2, string, (tableRow = this._data.elementAt(nArray[i])).getSchema(), tableRow.getModelName(), tableRow.getPartitionKey())); ++i) {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areKeysCompatible(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WITH \n");
        stringBuilder.append("a AS (SELECT * FROM ALL_MINING_MODEL_ATTRIBUTES a), \n");
        stringBuilder.append("b AS (SELECT DISTINCT OWNER, MODEL_NAME, POSITION, COLUMN_NAME FROM ALL_MINING_MODEL_PARTITIONS b) \n");
        stringBuilder.append("SELECT b.OWNER, b.MODEL_NAME, b.COLUMN_NAME, b.POSITION, a.DATA_TYPE \n");
        stringBuilder.append("FROM a,b \n");
        stringBuilder.append("WHERE a.ATTRIBUTE_NAME=b.COLUMN_NAME AND a.OWNER=b.OWNER AND a.MODEL_NAME=b.MODEL_NAME \n");
        stringBuilder.append("and a.owner in (?,?) \n");
        stringBuilder.append("and a.model_name in (?,?) \n");
        stringBuilder.append("and a.ATTRIBUTE_NAME in (");
        Object[] objectArray = string3.split(",");
        Object[] objectArray2 = string6.split(",");
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        if (Arrays.equals(objectArray, objectArray2)) {
            try (SQLHelper sQLHelper = new SQLHelper();){
                int n;
                for (n = 0; n < objectArray.length; ++n) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("?");
                }
                stringBuilder.append(") ORDER BY b.OWNER, b.COLUMN_NAME, b.MODEL_NAME \n");
                sQLHelper.conn = ConnectionFolder.getConnection(this._context);
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(stringBuilder.toString());
                sQLHelper.pstmt.setString(1, string);
                sQLHelper.pstmt.setString(2, string4);
                sQLHelper.pstmt.setString(3, string2);
                sQLHelper.pstmt.setString(4, string5);
                for (n = 0; n < objectArray.length; ++n) {
                    sQLHelper.pstmt.setString(5 + n, (String)objectArray[n]);
                }
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                while (sQLHelper.rs.next()) {
                    string7 = sQLHelper.rs.getString("column_name");
                    string8 = sQLHelper.rs.getString("data_type");
                    if (string9.equals(string7)) {
                        if (string8.equals(string10)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    string9 = string7;
                    string10 = string8;
                }
            }
            return true;
        }
        return false;
    }

    public boolean validateSelectionIsCompatible(int[] nArray, Context context, boolean bl) throws MisMatchedTargetValues, Exception {
        boolean bl2 = true;
        String string = "";
        String string2 = "";
        String string3 = "";
        TableRow tableRow = null;
        if (nArray.length <= 1) {
            return true;
        }
        tableRow = this._data.elementAt(nArray[0]);
        string = tableRow.getFunction();
        string2 = tableRow.getTarget_name();
        string3 = tableRow.getTarget_data_type();
        for (int i = 0; i < nArray.length; ++i) {
            tableRow = this._data.elementAt(nArray[i]);
            if (tableRow.getFunction().compareTo(string) != 0) {
                bl2 = false;
                break;
            }
            if (MiningFunctions.CLASSIFICATION.toString().compareTo(string) != 0 && MiningFunctions.REGRESSION.toString().compareTo(string) != 0) continue;
            if (tableRow.getTarget_name().compareTo(string2) == 0 && this.isDataTypeCompatible(string3, tableRow.getTarget_data_type())) {
                bl2 = true;
                continue;
            }
            bl2 = false;
            break;
        }
        if (bl2 && bl && MiningFunctions.CLASSIFICATION.toString().compareTo(string) == 0) {
            this.areTargetValuesTheSame(nArray, context, null);
        }
        return bl2;
    }

    public boolean areTargetValuesTheSame(int[] nArray, Context context, String string) throws MisMatchedTargetValues, Exception {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        TableRow tableRow = null;
        for (int i = 0; i < nArray.length; ++i) {
            tableRow = this._data.elementAt(nArray[i]);
            arrayList.add(Model.getCombinedUserNameModelName(tableRow.getSchema(), tableRow.getModelName(), false));
        }
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        if (!Classification.areTargetValuesTheSame(connectionFolder, arrayList, string)) {
            throw new MisMatchedTargetValues("Classification target values do not match across model selections");
        }
        return bl;
    }

    public boolean isDataTypeCompatible(String string, String string2) {
        boolean bl = false;
        if (string.compareTo(string2) == 0) {
            bl = true;
        } else {
            List list = Compatibles.COLUMN_DATA_TYPES.get(string);
            for (Object e : list) {
                if (((String)e).compareTo(string2) != 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void addSelection(EditModelTableModel editModelTableModel, int[] nArray) {
        Vector<TableRow> vector = editModelTableModel.getDataVector();
        TableRow tableRow = null;
        for (int i = 0; i < nArray.length; ++i) {
            tableRow = vector.elementAt(nArray[i]);
            this._data.add(tableRow);
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public void setFailedStatus() {
        TableRow tableRow = new TableRow(DialogsLrb.get("MODEL_NODE_CHOOSER_FAILED_TO_LOAD"), "", "", "", "", "", null, "", null, "", null, false, "", "");
        this.clear();
        this.addDataItem(tableRow);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public void setLoadingStatus() {
        TableRow tableRow = new TableRow(DialogsLrb.get("MODEL_NODE_CHOOSER_LOADING"), "", "", "", "", "", null, "", null, "", null, false, "", "");
        this.clear();
        this.addDataItem(tableRow);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public EditModelTableModel getfilteredCopy(String string, int n, boolean bl, MiningFunctionOptions miningFunctionOptions, String string2, String string3) throws Exception {
        Vector<TableRow> vector = null;
        assert (string != null) : "name filter must be non null";
        assert (miningFunctionOptions != null) : "function option must be non null";
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Object object = this.getDataVector();
        vector = new Vector<TableRow>(1000, 500);
        Iterator<TableRow> iterator = ((Vector)object).iterator();
        TableRow tableRow = null;
        boolean bl2 = false;
        if (string2 != null && string3 != null && string2.length() > 0 && string3.length() > 0) {
            bl2 = true;
        }
        boolean bl3 = string.length() <= 0;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        while (iterator.hasNext()) {
            tableRow = iterator.next();
            if (bl) {
                bl4 = true;
            } else {
                boolean bl8 = bl4 = tableRow.getSchema().equals(this._ownerSchema);
            }
            bl6 = miningFunctionOptions == MiningFunctionOptions.ALL ? true : tableRow.getFunction().compareTo(miningFunctionOptions.toString()) == 0;
            if (bl2) {
                bl7 = tableRow.getTarget_name().compareTo(string2) == 0 && this.isDataTypeCompatible(tableRow.getTarget_data_type(), string3);
            }
            if (bl3) {
                bl5 = true;
            } else {
                String string4;
                switch (n) {
                    case 0: {
                        string4 = tableRow.getSchemaModelName();
                        break;
                    }
                    case 1: {
                        string4 = tableRow.getModelName();
                        break;
                    }
                    case 2: {
                        string4 = tableRow.getSchema();
                        break;
                    }
                    case 4: {
                        string4 = tableRow.getAlgorithm();
                        break;
                    }
                    case 3: {
                        string4 = tableRow.getFunction();
                        break;
                    }
                    case 5: {
                        string4 = tableRow.getTarget_name();
                        break;
                    }
                    case 6: {
                        string4 = tableRow.getTarget_data_type();
                        break;
                    }
                    case 7: {
                        string4 = tableRow.getComments() == null ? "" : tableRow.getComments();
                        break;
                    }
                    default: {
                        string4 = tableRow.getSchemaModelName();
                    }
                }
                bl5 = searchMatcher.matches((CharSequence)string4);
            }
            if (!bl4 || !bl5 || !bl6 || !bl7) continue;
            vector.add(tableRow);
        }
        object = new EditModelTableModel(this._ownerSchema, vector, this._context);
        ((EditModelTableModel)((Object)object)).setOwnerOnly(!bl);
        ((EditModelTableModel)((Object)object)).setFilteredTableModel(true);
        return object;
    }

    public void removeDuplicateRows(Vector<TableRow> vector, int[] nArray) {
        TableRow tableRow = null;
        for (int i = 0; i < nArray.length; ++i) {
            tableRow = vector.elementAt(nArray[i]);
            this._data.remove(tableRow);
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public void refreshModelStatus(Vector<TableRow> vector) {
        HashMap<String, TableRow> hashMap = new HashMap<String, TableRow>();
        for (TableRow tableRow : vector) {
            hashMap.put(tableRow.getSchemaModelName(), tableRow);
        }
        for (TableRow tableRow : this._data) {
            TableRow tableRow2 = (TableRow)hashMap.get(tableRow.getSchemaModelName());
            if (this.doModelsMatch(tableRow2, tableRow)) {
                tableRow.setStatus(RefModelStatusType.INVALID);
                continue;
            }
            tableRow.setStatus(RefModelStatusType.VALID);
        }
    }

    public Vector<TableRow> createMissingRowsBasedOnMatch(Vector<TableRow> vector) {
        HashMap<String, TableRow> hashMap = new HashMap<String, TableRow>();
        Vector<TableRow> vector2 = new Vector<TableRow>();
        for (TableRow tableRow : this._data) {
            hashMap.put(tableRow.getSchemaModelName(), tableRow);
        }
        for (TableRow tableRow : vector) {
            TableRow tableRow2;
            if (this.doModelsMatch(tableRow, tableRow2 = (TableRow)hashMap.get(tableRow.getSchemaModelName()))) continue;
            vector2.add(tableRow);
        }
        return vector2;
    }

    public void removeDuplicateRowsBasedOnMatch(Vector<TableRow> vector) {
        HashMap<String, TableRow> hashMap = new HashMap<String, TableRow>();
        for (TableRow tableRow : vector) {
            hashMap.put(tableRow.getSchemaModelName(), tableRow);
        }
        Iterator<TableRow> iterator = this._data.iterator();
        while (iterator.hasNext()) {
            TableRow tableRow;
            tableRow = iterator.next();
            TableRow tableRow2 = (TableRow)hashMap.get(tableRow.getSchemaModelName());
            if (!this.doModelsMatch(tableRow2, tableRow)) continue;
            iterator.remove();
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    private boolean doModelsMatch(TableRow tableRow, TableRow tableRow2) {
        return tableRow != null && tableRow2 != null && tableRow.getAlgorithm().equals(tableRow2.getAlgorithm()) && tableRow.getFunction().equals(tableRow2.getFunction()) && tableRow.getTarget_data_type().equals(tableRow2.getTarget_data_type()) && tableRow.getTarget_name().equals(tableRow2.getTarget_name());
    }

    public void removeAvailableDuplicateRows(Vector<TableRow> vector) {
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public void load(ConnectionManager connectionManager) throws SQLException {
        this.clear();
        this._ownerSchema = ConnectionFolder.getUserAccountName(this._context);
        this._ownerSchema = StringUtils.isDoubleQuotedString(this._ownerSchema) ? StringUtils.trimDoubleQuotes(this._ownerSchema) : this._ownerSchema.toUpperCase();
        this.loadModels(connectionManager);
        assert (this._data != null) : "failed to load accessible models, received a null collection";
        this.setRowCount(this._data.size());
    }

    private void loadModels(ConnectionManager connectionManager) throws SQLException {
        try (SQLHelper sQLHelper = new SQLHelper();){
            Version version = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
            boolean bl = ConfigUtils.isDatabaseVersion(DBVersions.V12_2_0_0, version, true);
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = bl ? sQLHelper.conn.prepareStatement(QUERY_MODELS_PARTITIONS) : sQLHelper.conn.prepareStatement(QUERY_MODELS);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            TableRow tableRow = null;
            String string = "";
            String string2 = "";
            while (sQLHelper.rs.next()) {
                String string3 = MiningFunctionOptions.translateFromODMServerFunction(sQLHelper.rs.getString("MINING_FUNCTION"));
                String string4 = MiningAlgorithms.translateFromODMServerAlgorithm(sQLHelper.rs.getString("ALGORITHM"), sQLHelper.rs.getString("SVDS_SCORING_MODE"));
                if (bl) {
                    string = sQLHelper.rs.getString("partition_key");
                    string2 = sQLHelper.rs.getString("data_types");
                }
                tableRow = new TableRow(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("MODEL_NAME"), string3, string4, sQLHelper.rs.getString("TARGET"), sQLHelper.rs.getString("TARGET_DATA_TYPE"), sQLHelper.rs.getDate("CREATION_DATE"), sQLHelper.rs.getString("COMMENTS"), RefModelStatusType.VALID, "", new ModelSettingsODM(), true, string, string2);
                this._data.add(tableRow);
            }
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        TableRow tableRow = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                if (this.isOwnerOnly()) {
                    if (this._ownerSchema != null) {
                        if (this._ownerSchema.compareTo(tableRow._schema) == 0) {
                            object = tableRow.getModelName();
                            break;
                        }
                        object = tableRow.getSchemaModelName();
                        break;
                    }
                    object = tableRow.getModelName();
                    break;
                }
                object = tableRow.getSchemaModelName();
                break;
            }
            case 8: {
                object = tableRow.getSchema();
                break;
            }
            case 1: {
                object = tableRow.getFunction();
                break;
            }
            case 2: {
                object = tableRow.getAlgorithm();
                break;
            }
            case 4: {
                object = tableRow.getTarget_name();
                break;
            }
            case 5: {
                object = tableRow.getTarget_data_type();
                break;
            }
            case 9: {
                object = tableRow.getModelName();
                break;
            }
            case 6: {
                object = tableRow.getCreation_date();
                break;
            }
            case 7: {
                object = tableRow.getComments();
                break;
            }
            case 3: {
                object = tableRow.getPartitionKey();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing table";
                break;
            }
        }
        return object;
    }

    public Vector<TableRow> getDataVector() {
        return this._data;
    }

    public void setOwnerOnly(boolean bl) {
        if (bl != this._ownerOnly) {
            this._ownerOnly = bl;
            this.fireTableDataChanged();
        }
    }

    public boolean isOwnerOnly() {
        return this._ownerOnly;
    }

    public boolean isFilteredTableModel() {
        return this._filteredTableModel;
    }

    public void setFilteredTableModel(boolean bl) {
        this._filteredTableModel = bl;
    }

    public static class MisMatchedTargetValues
    extends Exception {
        public MisMatchedTargetValues(String string) {
            super(string);
        }
    }

    public static class TableRow {
        private String _schema;
        private String _modelName;
        private String _function;
        private String _algorithm;
        private String _target_name;
        private String _target_data_type;
        private String _comments;
        private Date _creation_date;
        private String _modelId;
        private ModelSettingsODM _modelSettingsODM;
        private boolean _useForOutput;
        private String _partitionKey;
        private String _dataTypes;
        private RefModelStatusType _status;

        public TableRow(String string, String string2, String string3, String string4, String string5, String string6, Date date, String string7, RefModelStatusType refModelStatusType, String string8, ModelSettingsODM modelSettingsODM, boolean bl, String string9, String string10) {
            this._schema = string;
            this._modelName = string2;
            this._function = string3;
            this._algorithm = string4;
            this._comments = string7;
            this._creation_date = date;
            this._target_name = string5;
            this._target_data_type = string6;
            this._status = refModelStatusType;
            this._modelId = string8;
            this._modelSettingsODM = modelSettingsODM;
            this._useForOutput = bl;
            this._partitionKey = string9;
            this._dataTypes = string10;
        }

        public void setSchema(String string) {
            this._schema = string;
        }

        public String getSchema() {
            return this._schema;
        }

        public String getSchemaModelName() {
            return this.getSchema() + "." + this.getModelName();
        }

        public String getMungedSchemaModelName() {
            return this.getSchema() + this.getModelName();
        }

        public void setModelName(String string) {
            this._modelName = string;
        }

        public String getModelName() {
            return this._modelName;
        }

        public void setFunction(String string) {
            this._function = string;
        }

        public String getFunction() {
            return this._function;
        }

        public void setAlgorithm(String string) {
            this._algorithm = string;
        }

        public String getAlgorithm() {
            return this._algorithm;
        }

        public void setTarget_name(String string) {
            this._target_name = string;
        }

        public String getTarget_name() {
            if (this._target_name == null) {
                return "";
            }
            return this._target_name;
        }

        public void setTarget_data_type(String string) {
            this._target_data_type = string;
        }

        public String getTarget_data_type() {
            if (this._target_data_type == null) {
                return "";
            }
            return this._target_data_type;
        }

        public void setStatus(RefModelStatusType refModelStatusType) {
            this._status = refModelStatusType;
        }

        public RefModelStatusType getStatus() {
            return this._status;
        }

        public void setComments(String string) {
            this._comments = string;
        }

        public String getComments() {
            return this._comments;
        }

        public void setCreation_date(Date date) {
            this._creation_date = date;
        }

        public Date getCreation_date() {
            return this._creation_date;
        }

        public void setModelId(String string) {
            this._modelId = string;
        }

        public String getModelId() {
            return this._modelId;
        }

        public void setModelSettingsODM(ModelSettingsODM modelSettingsODM) {
            this._modelSettingsODM = modelSettingsODM;
        }

        public ModelSettingsODM getModelSettingsODM() {
            return this._modelSettingsODM;
        }

        public void setUseForOutput(boolean bl) {
            this._useForOutput = bl;
        }

        public boolean isUseForOutput() {
            return this._useForOutput;
        }

        public String getPartitionKey() {
            return this._partitionKey;
        }

        public void setPartitionKey(String string) {
            this._partitionKey = string;
        }

        public String getDataType() {
            return this._dataTypes;
        }

        public void setDataType(String string) {
            this._dataTypes = string;
        }
    }
}

