/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.anomaly;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyOutputDialog;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodeEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.anomaly.AnomalyEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.anomaly.AnomalyPredictionLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.anomaly.AnomalyPredictionsTableModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.DynamicAnomalyNode;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicAnomalyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class DynamicAnomalyEditorPanel
extends DynamicEditorPanel<DynamicAnomalyNode>
implements DataConsumerPanel {
    private AnomalyEditorState state;
    private DynamicAnomalyNodeType cachedNodeData;
    private Map<String, ModelHeuristicRules> modelRules;
    private JLabel jCaseIdLabel;
    private JComboBox jComboBoxCaseId;
    private ComponentWithTitlebar<JComponent> jComponentAnomalies;
    private JLabel jLabelCaseId;
    private JTabbedPane jMainTabPamel;
    private JPanel jPredictionTab;
    private DataMinerTable jPredictionOutputsTable = new DataMinerTable();
    private JButton addPredOutputBtn;
    private JButton removePredOutputBtn;
    private JButton editPredOutputBtn;

    public DynamicAnomalyEditorPanel(Context context, DynamicAnomalyNode dynamicAnomalyNode, Map<String, ModelHeuristicRules> map) {
        super(context, dynamicAnomalyNode);
        this.cachedNodeData = (DynamicAnomalyNodeType)MetaDataHelper.copyMetadataObject(dynamicAnomalyNode.getData());
        this.state = new AnomalyEditorState(context, dynamicAnomalyNode, this.cachedNodeData);
        this.modelRules = map;
        this.initComponents();
        this.createPartitionTab(this.jMainTabPamel, this.state);
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jMainTabPamel = new JTabbedPane();
        this.jPredictionTab = new JPanel();
        this.jLabelCaseId = new JLabel();
        this.jComboBoxCaseId = new JComboBox();
        this.jComponentAnomalies = new ComponentWithTitlebar();
        this.jCaseIdLabel = new JLabel();
        this.jLabelCaseId.setText("Case ID:");
        this.jComboBoxCaseId.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCaseIdLabel.setHorizontalAlignment(2);
        this.jCaseIdLabel.setHorizontalTextPosition(2);
        GroupLayout groupLayout = new GroupLayout(this.jPredictionTab);
        this.jPredictionTab.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelCaseId, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxCaseId, -2, 121, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCaseIdLabel, -2, 23, -2).addContainerGap(331, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jComponentAnomalies, -1, 538, Short.MAX_VALUE).addGap(11, 11, 11))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCaseIdLabel, -2, 20, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCaseId).addComponent(this.jComboBoxCaseId, -2, -1, -2))).addContainerGap(451, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(45, 45, 45).addComponent((Component)this.jComponentAnomalies, -1, 426, Short.MAX_VALUE).addContainerGap())));
        this.jMainTabPamel.addTab("Anomaly", this.jPredictionTab);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMainTabPamel, -1, 564, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMainTabPamel, -1, 510, Short.MAX_VALUE));
    }

    @Override
    protected String getFirstTabTitle() {
        return AnomalyPredictionLrb.get("ANOMALY_PREDICTION_EDITOR_FIRST_TAB_TITLE");
    }

    @Override
    protected DynamicNodeBaseSettingsType getOriginalDynamicNodeBaseSettings() {
        return this.cachedNodeData.getDynamicNodeBaseSettings();
    }

    private MiningAttributes getMiningAttributes() {
        return this.getOriginalDynamicNodeBaseSettings().getMiningAttributes();
    }

    @Override
    protected JComboBox getCaseIDCombo() {
        return this.jComboBoxCaseId;
    }

    @Override
    protected JLabel getCaseIDLabel() {
        return this.jCaseIdLabel;
    }

    @Override
    public DynamicNodeEditorState getState() {
        return this.state;
    }

    @Override
    public void initUI() {
        Object object2;
        ResourceUtils.resLabel((JLabel)this.jLabelCaseId, (Component)this.jComboBoxCaseId, (String)AnomalyPredictionLrb.get("ANOMALY_PREDICTION_EDITOR_PANEL_CASE_ID"));
        this.jPredictionOutputsTable.setTooltipEnable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.jPredictionOutputsTable));
        this.jComponentAnomalies.setComponent((JComponent)jScrollPane);
        this.jComponentAnomalies.setLabel(new JLabel(AnomalyPredictionLrb.get("ANOMALY_PREDICTION_EDITOR_PANEL_PREDICTION_OUTPUT_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.addPredOutputBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addPredOutputBtn.setToolTipText(AnomalyPredictionLrb.get("ANOMALY_PREDICTION_EDITOR_TOOLTIP_ADD_PREDICTION_OUTPUT"));
        this.addPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicAnomalyEditorPanel.this.hanldeAddAnomalyPredictionOutput();
            }
        });
        controlBar.add((Component)this.addPredOutputBtn);
        this.removePredOutputBtn = new JButton(AnomalyEditorState.getRemoveIcon());
        this.removePredOutputBtn.setToolTipText(AnomalyPredictionLrb.get("ANOMALY_PREDICTION_EDITOR_TOOLTIP_REMOVE_PREDICTION_OUTPUT"));
        this.removePredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicAnomalyEditorPanel.this.removeSelectedAnomalyPredictionOutputs();
            }
        });
        controlBar.add((Component)this.removePredOutputBtn);
        this.editPredOutputBtn = new JButton(AnomalyEditorState.getEditIcon());
        this.editPredOutputBtn.setToolTipText(AnomalyPredictionLrb.get("ANOMALY_PREDICTION_EDITOR_TOOLTIP_EDIT_PREDICTION_OUTPUT"));
        this.editPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicAnomalyEditorPanel.this.hanldeEditAnomalyPredictionOutput();
            }
        });
        controlBar.add((Component)this.editPredOutputBtn);
        this.jComponentAnomalies.setControlBar(controlBar);
        this.jPredictionOutputsTable.setFillsViewportHeight(true);
        this.addPredOutputBtn.setEnabled(true);
        this.removePredOutputBtn.setEnabled(false);
        this.editPredOutputBtn.setEnabled(false);
        Vector<String> vector = new Vector<String>();
        if (!this.getMiningAttributes().getMiningAttribute().isEmpty()) {
            for (Object object2 : this.getMiningAttributes().getMiningAttribute()) {
                if (!DatabaseMetadataUtils.isDynamicCaseIdDataTypeSupported(object2.getDataType())) continue;
                String string = object2.getAlias() != null ? object2.getAlias() : object2.getName();
                vector.add(string);
            }
            Collections.sort(vector);
        }
        vector.insertElementAt(DynamicNodeEditorState._none, 0);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        defaultComboBoxModel.setSelectedItem(this.state.getSelectedCaseAttribute() != null ? this.state.getSelectedCaseAttribute() : DynamicNodeEditorState._none);
        this.jComboBoxCaseId.setModel(defaultComboBoxModel);
        this.jComboBoxCaseId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)DynamicAnomalyEditorPanel.this.jComboBoxCaseId.getSelectedItem();
                DynamicAnomalyEditorPanel.this.setSelectedCaseAttribute(string);
            }
        });
        this.setupAnomalyPredictionOutputTable();
        object2 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = DynamicAnomalyEditorPanel.this.jPredictionOutputsTable.getSelectedRowInModel();
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    DynamicAnomalyEditorPanel.this.hanldeEditAnomalyPredictionOutput();
                }
            }
        };
        this.jPredictionOutputsTable.addMouseListener((MouseListener)object2);
        this.createTabs(this.state, this.jMainTabPamel, this.modelRules);
        super.initUI();
    }

    private void setupAnomalyPredictionOutputTable() {
        this.jPredictionOutputsTable.setModel((TableModel)((Object)this.state.getTableModelAnomalyOutputs()));
        this.jPredictionOutputsTable.setShowGrid(true);
        this.jPredictionOutputsTable.setSorted(true);
        this.jPredictionOutputsTable.setSortColumn(AnomalyPredictionsTableModel.FUNCTION, true);
        this.jPredictionOutputsTable.getSelectionModel().addListSelectionListener(new PredictionOutputsSelectionHandler());
    }

    private void removeSelectedAnomalyPredictionOutputs() {
        int[] nArray = this.jPredictionOutputsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Vector<DynamicApplyOutputColumnType> vector = this.state.getTableModelAnomalyOutputs().getDataVector();
        ArrayList<DynamicApplyOutputColumnType> arrayList = new ArrayList<DynamicApplyOutputColumnType>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((DynamicApplyOutputColumnType)vector.get(nArray[i]));
        }
        this.state.removePredictionOutputColumnsFromList(arrayList);
        this.setupAnomalyPredictionOutputTable();
    }

    private void hanldeEditAnomalyPredictionOutput() {
        int[] nArray = this.jPredictionOutputsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length != 1) {
            return;
        }
        Vector<DynamicApplyOutputColumnType> vector = this.state.getTableModelAnomalyOutputs().getDataVector();
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType = (DynamicApplyOutputColumnType)vector.get(nArray[0]);
        String string = DynamicNodesLrb.get("DYNAMIC_ANOMALY_APPLY_OUTPUT_EDIT_DIALOG_TITLE");
        DynamicApplyOutputDialog dynamicApplyOutputDialog = new DynamicApplyOutputDialog(string);
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType2 = (DynamicApplyOutputColumnType)MetaDataHelper.copyMetadataObject(dynamicApplyOutputColumnType);
        if (dynamicApplyOutputDialog.invoke(this.getContext(), this.state, dynamicApplyOutputColumnType2, null)) {
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType3 = dynamicApplyOutputDialog.getApplyOutputColumn();
            this.state.replacePredictionTarget(dynamicApplyOutputColumnType, dynamicApplyOutputColumnType3);
            this.setupAnomalyPredictionOutputTable();
        }
    }

    private void hanldeAddAnomalyPredictionOutput() {
        String string = DynamicNodesLrb.get("DYNAMIC_ANOMALY_APPLY_OUTPUT_ADD_DIALOG_TITLE");
        DynamicApplyOutputDialog dynamicApplyOutputDialog = new DynamicApplyOutputDialog(string);
        if (dynamicApplyOutputDialog.invoke(this.getContext(), this.state, null)) {
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType = dynamicApplyOutputDialog.getApplyOutputColumn();
            this.state.addApplyOutputColumn(dynamicApplyOutputColumnType);
            this.setupAnomalyPredictionOutputTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        if (this.isInputAttributesListEmpty()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DynamicNodesLrb.get("EDITOR_PANEL_ERROR_NO_INPUTS"), (String)AnomalyPredictionLrb.get("ANOMALY_NODE_PROPERTIES_DIALOG_FAILURE_TITLE"), null);
            return false;
        }
        CommandProcessor.getInstance().beginTrans(AnomalyPredictionLrb.get("ANOMALY_NODE_PROPERTIES_TRANSACTION_NAME"));
        try {
            HashMap<String, DynamicNodeBaseSettingsType> hashMap = new HashMap<String, DynamicNodeBaseSettingsType>();
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = (DynamicNodeBaseSettingsType)MetaDataHelper.copyMetadataObject(this.getOriginalDynamicNodeBaseSettings());
            hashMap.put("DynamicNodeBaseSettingsType", dynamicNodeBaseSettingsType);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("ANOMALY_NODE_INPUT_COLUMNS", null, hashMap, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            DynamicAnomalyNode dynamicAnomalyNode = (DynamicAnomalyNode)this.getData();
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)dynamicAnomalyNode.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(dynamicAnomalyNode, this._context, arrayList);
            dynamicAnomalyNode.validateSimple(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)AnomalyPredictionLrb.get("ANOMALY_NODE_PROPERTIES_DIALOG_FAILURE_TITLE"), (String)AnomalyPredictionLrb.get("ANOMALY_NODE_PROPERTIES_DIALOG_FAILURE_MSG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
        return true;
    }

    class PredictionOutputsSelectionHandler
    implements ListSelectionListener {
        PredictionOutputsSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = DynamicAnomalyEditorPanel.this.jPredictionOutputsTable.getSelectedRowsInModel();
            DynamicAnomalyEditorPanel.this.removePredOutputBtn.setEnabled(nArray != null && nArray.length > 0);
            DynamicAnomalyEditorPanel.this.editPredOutputBtn.setEnabled(nArray != null && nArray.length == 1);
        }
    }
}

