/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.anomaly.AnomalyEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.cluster.ClusterEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.feature.FeatureEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionLrb;
import oracle.dmt.dataminer.workflow.inspect.dynamic.anomaly.DynamicAnomalyInspectorState;
import oracle.dmt.dataminer.workflow.inspect.dynamic.cluster.DynamicClusterInspectorState;
import oracle.dmt.dataminer.workflow.inspect.dynamic.feature.DynamicFeatureInspectorState;
import oracle.dmt.dataminer.workflow.inspect.dynamic.predict.DynamicPredicInspectorState;
import oracle.dmt.dataminer.workflow.model.DynamicPredictionNode;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;

public class DynamicApplyOutputDialog {
    private static final Logger theLogger = Logger.getLogger(DynamicApplyOutputDialog.class.getName());
    protected JEWTDialog _dlg;
    protected DynamicApplyOutputPanel _panel;
    protected String wizName = "Edit dynamic apply node";
    private String title;
    private DynamicPredictionNode predictionNode;

    public DynamicApplyOutputDialog(String string, DynamicPredictionNode dynamicPredictionNode) {
        this.title = string;
        this.predictionNode = dynamicPredictionNode;
    }

    public DynamicApplyOutputDialog(String string) {
        this.title = string;
    }

    protected JEWTDialog buildDialog(Context context, DynamicState dynamicState, MiningAttributeType miningAttributeType) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        if (this.predictionNode != null) {
            this.getAllTargetValues(context, this.predictionNode);
        }
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        this._panel = new DynamicApplyOutputPanel(context, dynamicState, miningAttributeType);
        jEWTDialog.setContent((Component)this._panel);
        jEWTDialog.setTitle(this.title);
        this.registerAddHelp(dynamicState, jEWTDialog);
        return jEWTDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context, DynamicState dynamicState, MiningAttributeType miningAttributeType) {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(context, dynamicState, miningAttributeType);
            jEWTDialog.setMinimumSize(new Dimension(350, 350));
            jEWTDialog.setResizable(true);
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !DynamicApplyOutputDialog.this._panel.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)WorkflowDialogLrb.get("UNEXPECTED_ERROR_MESG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected JEWTDialog buildDialog(Context context, DynamicState dynamicState, DynamicApplyOutputColumnType dynamicApplyOutputColumnType, MiningAttributeType miningAttributeType) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        if (this.predictionNode != null) {
            this.getAllTargetValues(context, this.predictionNode);
        }
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        this._panel = new DynamicApplyOutputPanel(context, dynamicState, dynamicApplyOutputColumnType, miningAttributeType);
        jEWTDialog.setContent((Component)this._panel);
        jEWTDialog.setTitle(this.title);
        this.registerEditHelp(dynamicState, jEWTDialog);
        return jEWTDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context, DynamicState dynamicState, DynamicApplyOutputColumnType dynamicApplyOutputColumnType, MiningAttributeType miningAttributeType) {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(context, dynamicState, dynamicApplyOutputColumnType, miningAttributeType);
            jEWTDialog.setMinimumSize(new Dimension(350, 350));
            jEWTDialog.setResizable(true);
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !DynamicApplyOutputDialog.this._panel.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)WorkflowDialogLrb.get("UNEXPECTED_ERROR_MESG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected void cancel() {
    }

    protected void registerAddHelp(DynamicState dynamicState, JEWTDialog jEWTDialog) {
        String string = null;
        if (dynamicState instanceof ClusterEditorState || dynamicState instanceof DynamicClusterInspectorState) {
            string = "dynamic_cluster_node_add_cluster_funct";
        } else if (dynamicState instanceof AnomalyEditorState || dynamicState instanceof DynamicAnomalyInspectorState) {
            string = "dynamic_anomaly_node_edit_add_func";
        } else if (dynamicState instanceof FeatureEditorState || dynamicState instanceof DynamicFeatureInspectorState) {
            string = "dynamic_feature_node_edit_add_feature";
        } else if (dynamicState instanceof PredictionEditorState || dynamicState instanceof DynamicPredicInspectorState) {
            string = "dynamic_prediction_node_add_output_function";
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), string);
    }

    protected void registerEditHelp(DynamicState dynamicState, JEWTDialog jEWTDialog) {
        String string = null;
        if (dynamicState instanceof ClusterEditorState || dynamicState instanceof DynamicClusterInspectorState) {
            string = "dynamic_cluster_node_edit_cluster_func";
        } else if (dynamicState instanceof AnomalyEditorState || dynamicState instanceof DynamicAnomalyInspectorState) {
            string = "dynamic_anomaly_node_edit_func";
        } else if (dynamicState instanceof FeatureEditorState || dynamicState instanceof DynamicFeatureInspectorState) {
            string = "dynamic_feature_node_edit_feature";
        } else if (dynamicState instanceof PredictionEditorState || dynamicState instanceof DynamicPredicInspectorState) {
            string = "dynamic_prediction_node_edit_prediction_funct";
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), string);
    }

    public DynamicApplyOutputPanel getPanel() {
        return this._panel;
    }

    public DynamicApplyOutputColumnType getApplyOutputColumn() {
        return this._panel.getApplyOutputColumn();
    }

    public void getAllTargetValues(Context context, DynamicPredictionNode dynamicPredictionNode) {
        class GetTargetValues
        extends ProgressRunnable {
            DynamicPredictionNode dynamicPredNode;
            Context context;

            GetTargetValues(Context context, DynamicPredictionNode dynamicPredictionNode) {
                this.dynamicPredNode = dynamicPredictionNode;
                this.context = context;
            }

            protected Object doWork() throws Exception {
                return this.dynamicPredNode.getAllTargetValues();
            }
        }
        GetTargetValues getTargetValues = new GetTargetValues(context, dynamicPredictionNode);
        getTargetValues.setTitle(PredictionLrb.get("LOAD_AVAIL_ATTRS"));
        getTargetValues.setMessage(PredictionLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getTargetValues.setCancelable(false);
        try {
            getTargetValues.start(true);
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
    }

    public static enum MODE {
        ADD_TARGET,
        EDIT_TARGET;

    }
}

