/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelGLMBuildSettingsPanel;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ModelGLMBuildFeatureSelectPanel
extends JPanel
implements DataminerGUIPanel {
    private static final String GLMS_CAT_PRED_TREATMENT_ONE = AlgSettingsLrb.get("GLMS_CAT_PRED_TREATMENT_ONE");
    private static final String GLMS_CAT_PRED_TREATMENT_ALL = AlgSettingsLrb.get("GLMS_CAT_PRED_TREATMENT_ALL");
    private boolean isFeatureGenerationSelected;
    private HashMap<String, Object> cacheSettings;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JComboBox jCategoricalPredictorTreatmentComboBox;
    private JLabel jCategoricalPredictorTreatmentLabel;
    private JComboBox jFeatureAcceptanceComboBox;
    private JLabel jFeatureAcceptanceLabel;
    private JComboBox jFeatureSelectionCriteriaComboBox;
    private JLabel jFeatureSelectionCriteriaLabel;
    private JLabel jMaxNumberofFeaturesLabel;
    private JComboBox jPruneModelComboBox;
    private JLabel jPruneModelLabel;
    private JComboBox jSamplingFeatIdentComboBox;
    private JLabel jSamplingFeatIdentLabel;
    private JRadioButton jSystemDeterminedRadioButton;
    private JRadioButton jUserSpecifiedRadioButton;
    private JTextField jUserSpecifiedValue;

    public ModelGLMBuildFeatureSelectPanel(ModelGLMBuildSettingsPanel modelGLMBuildSettingsPanel) {
        this.cacheSettings = modelGLMBuildSettingsPanel.getCacheSettings();
        this.isFeatureGenerationSelected = modelGLMBuildSettingsPanel.isFeatureGenerationSelected();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jFeatureSelectionCriteriaLabel, (Component)this.jFeatureSelectionCriteriaComboBox, (String)AlgSettingsLrb.get("GLMS_FEATURE_SEL_CRIT"));
        ResourceUtils.resLabel((JLabel)this.jMaxNumberofFeaturesLabel, null, (String)AlgSettingsLrb.get("GLMS_MAX_NUM_FEATURES"));
        ResourceUtils.resButton((AbstractButton)this.jSystemDeterminedRadioButton, (String)AlgSettingsLrb.get("GLMS_MAX_NUM_FEATURES_SYSTEM"));
        ResourceUtils.resButton((AbstractButton)this.jUserSpecifiedRadioButton, (String)AlgSettingsLrb.get("GLMS_MAX_NUM_FEATURES_USER"));
        ResourceUtils.resLabel((JLabel)this.jFeatureAcceptanceLabel, (Component)this.jFeatureAcceptanceComboBox, (String)AlgSettingsLrb.get("GLMS_FEATURE_ACCEPTANCE"));
        ResourceUtils.resLabel((JLabel)this.jPruneModelLabel, (Component)this.jPruneModelComboBox, (String)AlgSettingsLrb.get("GLMS_PRUNE_MODEL"));
        ResourceUtils.resLabel((JLabel)this.jCategoricalPredictorTreatmentLabel, null, (String)AlgSettingsLrb.get("GLMS_CAT_PRED_TREATMENT_LABEL"));
        ResourceUtils.resLabel((JLabel)this.jSamplingFeatIdentLabel, null, (String)AlgSettingsLrb.get("GLMS_FTR_IDENTIFICATION_LABEL"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"glmc_feat_select_option");
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{CommonSettingDataObject.SYSTEM_DETERMINED, ServerConstants.GLMSettings.toHuman("GLMS_FTR_SEL_AIC"), ServerConstants.GLMSettings.toHuman("GLMS_FTR_SEL_SBIC"), ServerConstants.GLMSettings.toHuman("GLMS_FTR_SEL_RIC"), ServerConstants.GLMSettings.toHuman("GLMS_FTR_SEL_ALPHA_INV")});
        this.jFeatureSelectionCriteriaComboBox.setModel(defaultComboBoxModel);
        String string = (String)this.cacheSettings.get("GLMS_FTR_SEL_CRIT");
        if (string == null || string.isEmpty()) {
            this.jFeatureSelectionCriteriaComboBox.setSelectedItem(CommonSettingDataObject.SYSTEM_DETERMINED);
        } else {
            this.jFeatureSelectionCriteriaComboBox.setSelectedItem(ServerConstants.GLMSettings.toHuman(string));
        }
        this.jFeatureSelectionCriteriaLabel.setLabelFor(this.jFeatureSelectionCriteriaComboBox);
        this.jUserSpecifiedValue.setToolTipText(AlgSettingsLrb.get("GLMS_MAX_NUM_FEATURES_VALUE_TOOLTIP"));
        ((NumberTextField)this.jUserSpecifiedValue).setDataType(Integer.class);
        ((NumberTextField)this.jUserSpecifiedValue).setSigned(true);
        this.jUserSpecifiedValue.setLocale(Locale.getDefault());
        Number number = null;
        number = (Number)this.cacheSettings.get("GLMS_MAX_FEATURES");
        if (number != null) {
            ((NumberTextField)this.jUserSpecifiedValue).setNumber(number);
            this.jUserSpecifiedRadioButton.setSelected(true);
        } else {
            this.jSystemDeterminedRadioButton.setSelected(true);
        }
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(new String[]{CommonSettingDataObject.SYSTEM_DETERMINED, ServerConstants.GLMSettings.toHuman("GLMS_FTR_ACCEPTANCE_STRICT"), ServerConstants.GLMSettings.toHuman("GLMS_FTR_ACCEPTANCE_RELAXED")});
        this.jFeatureAcceptanceComboBox.setModel(defaultComboBoxModel2);
        string = (String)this.cacheSettings.get("GLMS_FTR_ACCEPTANCE");
        if (string == null || string.isEmpty()) {
            this.jFeatureAcceptanceComboBox.setSelectedItem(CommonSettingDataObject.SYSTEM_DETERMINED);
        } else {
            this.jFeatureAcceptanceComboBox.setSelectedItem(ServerConstants.GLMSettings.toHuman(string));
        }
        this.jFeatureAcceptanceLabel.setLabelFor(this.jFeatureAcceptanceComboBox);
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>(new String[]{ServerConstants.GLMSettings.toHuman("GLMS_PRUNE_MODEL_ENABLE"), ServerConstants.GLMSettings.toHuman("GLMS_PRUNE_MODEL_DISABLE")});
        this.jPruneModelComboBox.setModel(defaultComboBoxModel3);
        string = (String)this.cacheSettings.get("GLMS_PRUNE_MODEL");
        if (string == null || string.isEmpty()) {
            string = "GLMS_PRUNE_MODEL_ENABLE";
        }
        this.jPruneModelComboBox.setSelectedItem(ServerConstants.GLMSettings.toHuman(string));
        this.jPruneModelLabel.setLabelFor(this.jPruneModelComboBox);
        this.jCategoricalPredictorTreatmentComboBox.removeAllItems();
        if (this.isFeatureGenerationSelected) {
            this.jCategoricalPredictorTreatmentComboBox.addItem(GLMS_CAT_PRED_TREATMENT_ONE);
        } else {
            this.jCategoricalPredictorTreatmentComboBox.addItem(CommonSettingDataObject.SYSTEM_DETERMINED);
            this.jCategoricalPredictorTreatmentComboBox.addItem(GLMS_CAT_PRED_TREATMENT_ONE);
            this.jCategoricalPredictorTreatmentComboBox.addItem(GLMS_CAT_PRED_TREATMENT_ALL);
        }
        string = (String)this.cacheSettings.get("GLMS_SELECT_BLOCK");
        if ("GLMS_SELECT_BLOCK_DISABLE".equals(string)) {
            this.jCategoricalPredictorTreatmentComboBox.setSelectedItem(GLMS_CAT_PRED_TREATMENT_ONE);
        } else if ("GLMS_SELECT_BLOCK_ENABLE".equals(string)) {
            this.jCategoricalPredictorTreatmentComboBox.setSelectedItem(GLMS_CAT_PRED_TREATMENT_ALL);
        } else {
            this.jCategoricalPredictorTreatmentComboBox.setSelectedItem(CommonSettingDataObject.SYSTEM_DETERMINED);
        }
        DefaultComboBoxModel<String> defaultComboBoxModel4 = new DefaultComboBoxModel<String>(new String[]{CommonSettingDataObject.SYSTEM_DETERMINED, ServerConstants.GLMSettings.toHuman("GLMS_FTR_IDENTIFICATION_QUICK"), ServerConstants.GLMSettings.toHuman("GLMS_FTR_IDENTIFICATION_COMPLETE")});
        this.jSamplingFeatIdentComboBox.setModel(defaultComboBoxModel4);
        string = (String)this.cacheSettings.get("GLMS_FTR_IDENTIFICATION");
        if (string == null || string.isEmpty()) {
            this.jSamplingFeatIdentComboBox.setSelectedItem(CommonSettingDataObject.SYSTEM_DETERMINED);
        } else if (string.equals(CommonSettingDataObject.SYSTEM_DETERMINED)) {
            this.jSamplingFeatIdentComboBox.setSelectedItem(string);
        } else {
            this.jSamplingFeatIdentComboBox.setSelectedItem(ServerConstants.GLMSettings.toHuman(string));
        }
        this.jSamplingFeatIdentLabel.setLabelFor(this.jSamplingFeatIdentComboBox);
        this.enableControls();
    }

    private void enableControls() {
        this.jUserSpecifiedValue.setEnabled(this.jUserSpecifiedRadioButton.isSelected());
    }

    public boolean doWork() {
        Object object;
        String string = (String)this.jFeatureSelectionCriteriaComboBox.getSelectedItem();
        this.cacheSettings.put("GLMS_FTR_SEL_CRIT", string == CommonSettingDataObject.SYSTEM_DETERMINED ? null : ServerConstants.GLMSettings.toAlgorithm(string));
        if (this.jUserSpecifiedRadioButton.isSelected()) {
            object = ((NumberTextField)this.jUserSpecifiedValue).getNumber();
            if (object == null || ((Number)object).intValue() <= 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("GLMS_MAX_NUM_FEATURES_VALUE_INVALID"), (String)AlgSettingsLrb.get("GLMS_FEATURE_SELECTION_OPTION_DIALOG_TITLE"), null);
                return false;
            }
            this.cacheSettings.put("GLMS_MAX_FEATURES", object);
        } else {
            this.cacheSettings.put("GLMS_MAX_FEATURES", null);
        }
        object = (String)this.jFeatureAcceptanceComboBox.getSelectedItem();
        if (!(object == CommonSettingDataObject.SYSTEM_DETERMINED || string != CommonSettingDataObject.SYSTEM_DETERMINED && ServerConstants.GLMSettings.toAlgorithm(string).equals("GLMS_FTR_SEL_ALPHA_INV"))) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("GLMS_FTR_IDENTIFICATION_VALUE_INVALID"), (String)AlgSettingsLrb.get("GLMS_FEATURE_SELECTION_OPTION_DIALOG_TITLE"), null);
            return false;
        }
        this.cacheSettings.put("GLMS_FTR_ACCEPTANCE", CommonSettingDataObject.SYSTEM_DETERMINED.equals(object) ? null : ServerConstants.GLMSettings.toAlgorithm((String)object));
        String string2 = (String)this.jPruneModelComboBox.getSelectedItem();
        if (string2.equals(ServerConstants.GLMSettings.GLMS_PRUNE_MODEL_OPTION.GLMS_PRUNE_MODEL_ENABLE.value())) {
            string2 = "GLMS_PRUNE_MODEL_ENABLE";
        }
        if (string2.equals(ServerConstants.GLMSettings.GLMS_PRUNE_MODEL_OPTION.GLMS_PRUNE_MODEL_DISABLE.value())) {
            string2 = "GLMS_PRUNE_MODEL_DISABLE";
        }
        this.cacheSettings.put("GLMS_PRUNE_MODEL", string2);
        string2 = (String)this.jSamplingFeatIdentComboBox.getSelectedItem();
        string2 = string2.equals(ServerConstants.GLMSettings.GLMS_FTR_IDENTIFICATION_OPTION.GLMS_FTR_IDENTIFICATION_QUICK.value()) ? "GLMS_FTR_IDENTIFICATION_QUICK" : (string2.equals(ServerConstants.GLMSettings.GLMS_FTR_IDENTIFICATION_OPTION.GLMS_FTR_IDENTIFICATION_COMPLETE.value()) ? "GLMS_FTR_IDENTIFICATION_COMPLETE" : null);
        this.cacheSettings.put("GLMS_FTR_IDENTIFICATION", string2);
        string2 = (String)this.jCategoricalPredictorTreatmentComboBox.getSelectedItem();
        string2 = string2.equals(GLMS_CAT_PRED_TREATMENT_ONE) ? "GLMS_SELECT_BLOCK_DISABLE" : (string2.equals(GLMS_CAT_PRED_TREATMENT_ALL) ? "GLMS_SELECT_BLOCK_ENABLE" : CommonSettingDataObject.SYSTEM_DETERMINED);
        this.cacheSettings.put("GLMS_SELECT_BLOCK", string2);
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPruneModelLabel = new JLabel();
        this.jPruneModelComboBox = new JComboBox();
        this.jMaxNumberofFeaturesLabel = new JLabel();
        this.jSystemDeterminedRadioButton = new JRadioButton();
        this.jUserSpecifiedRadioButton = new JRadioButton();
        this.jUserSpecifiedValue = new NumberTextField();
        this.jCategoricalPredictorTreatmentLabel = new JLabel();
        this.jCategoricalPredictorTreatmentComboBox = new JComboBox();
        this.jFeatureSelectionCriteriaLabel = new JLabel();
        this.jFeatureSelectionCriteriaComboBox = new JComboBox();
        this.jFeatureAcceptanceLabel = new JLabel();
        this.jFeatureAcceptanceComboBox = new JComboBox();
        this.jSamplingFeatIdentLabel = new JLabel();
        this.jSamplingFeatIdentComboBox = new JComboBox();
        this.jPruneModelLabel.setLabelFor(this.jPruneModelComboBox);
        this.jPruneModelLabel.setText("Prune Model:");
        this.jPruneModelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Enable"}));
        this.jMaxNumberofFeaturesLabel.setText("Max Number of Features");
        this.buttonGroup1.add(this.jSystemDeterminedRadioButton);
        this.jSystemDeterminedRadioButton.setText("System determined");
        this.jSystemDeterminedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGLMBuildFeatureSelectPanel.this.jSystemDeterminedRadioButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jUserSpecifiedRadioButton);
        this.jUserSpecifiedRadioButton.setText("User specified:");
        this.jUserSpecifiedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGLMBuildFeatureSelectPanel.this.jUserSpecifiedRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jCategoricalPredictorTreatmentLabel.setLabelFor(this.jCategoricalPredictorTreatmentComboBox);
        this.jCategoricalPredictorTreatmentLabel.setText("Categorical Predictor Treatment:");
        this.jCategoricalPredictorTreatmentComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"System Determined"}));
        this.jFeatureSelectionCriteriaLabel.setLabelFor(this.jFeatureSelectionCriteriaComboBox);
        this.jFeatureSelectionCriteriaLabel.setText("Feature Selection Criteria:");
        this.jFeatureSelectionCriteriaComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"System Determined"}));
        this.jFeatureAcceptanceLabel.setLabelFor(this.jFeatureAcceptanceComboBox);
        this.jFeatureAcceptanceLabel.setText("Feature Acceptance:");
        this.jFeatureAcceptanceComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"System Determined"}));
        this.jSamplingFeatIdentLabel.setLabelFor(this.jFeatureAcceptanceComboBox);
        this.jSamplingFeatIdentLabel.setText("Sampling for Feature Identification:");
        this.jSamplingFeatIdentComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"System Determined"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jMaxNumberofFeaturesLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jFeatureSelectionCriteriaLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jFeatureAcceptanceLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jSamplingFeatIdentLabel, -1, 201, Short.MAX_VALUE).addComponent(this.jPruneModelLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jCategoricalPredictorTreatmentLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jUserSpecifiedRadioButton, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPruneModelComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jUserSpecifiedValue).addComponent(this.jCategoricalPredictorTreatmentComboBox, 0, 120, Short.MAX_VALUE).addComponent(this.jFeatureSelectionCriteriaComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jFeatureAcceptanceComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jSamplingFeatIdentComboBox, 0, -1, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jSystemDeterminedRadioButton, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPruneModelLabel).addComponent(this.jPruneModelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMaxNumberofFeaturesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSystemDeterminedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jUserSpecifiedRadioButton).addComponent(this.jUserSpecifiedValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCategoricalPredictorTreatmentComboBox, -2, -1, -2).addComponent(this.jCategoricalPredictorTreatmentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFeatureSelectionCriteriaLabel).addComponent(this.jFeatureSelectionCriteriaComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFeatureAcceptanceComboBox, -2, -1, -2).addComponent(this.jFeatureAcceptanceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSamplingFeatIdentComboBox, -2, -1, -2).addComponent(this.jSamplingFeatIdentLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jSystemDeterminedRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jUserSpecifiedRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }
}

