/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.model.IlvSDMLink;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Window;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.OdmrSDMSetPropertyCommand;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.LinkType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.ExceptionDialog;

public class OdmrSDMUndoFilter
extends SDMUndoFilter {
    private static final Logger theLogger = Logger.getLogger(OdmrSDMUndoFilter.class.getName());

    public OdmrSDMUndoFilter(IlvSDMModel ilvSDMModel) {
        super(ilvSDMModel);
    }

    public IlvSDMNode createNode(String string) {
        AbstractNode abstractNode = null;
        try {
            WorkflowModel workflowModel = (WorkflowModel)this.getFilteredModel();
            abstractNode = AbstractNode.createNode(string, workflowModel.getContext());
            NodeType nodeType = abstractNode.getData();
            abstractNode.setMetadataId(workflowModel.getNextNewIdString());
            if (!workflowModel.isInPaste()) {
                nodeType.setName(workflowModel.generateNextDistinctName(abstractNode.getDefaultName()));
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
        return abstractNode;
    }

    public IlvSDMLink createLink(String string) {
        assert (string.equals(GeneralLink.class.getSimpleName()));
        GeneralLink generalLink = null;
        try {
            WorkflowModel workflowModel = (WorkflowModel)this.getFilteredModel();
            generalLink = GeneralLink.createLink(string, workflowModel.getContext());
            LinkType linkType = generalLink.getData();
            generalLink.setMetadataId(workflowModel.getNextNewIdString());
            linkType.setName(generalLink.getDefaultName());
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
        return generalLink;
    }

    public void addObject(Object object, Object object2, Object object3) {
        super.addObject(object, object2, object3);
        this.refreshNavigatorTree();
    }

    public void removeObject(Object object) {
        super.removeObject(object);
        this.refreshNavigatorTree();
    }

    private void refreshNavigatorTree() {
        WorkflowModel workflowModel = (WorkflowModel)this.getFilteredModel();
        WorkflowNode workflowNode = (WorkflowNode)workflowModel.getContext().getNode();
        UpdateMessage.fireStructureChanged((Subject)workflowNode);
    }

    public void setNameProperty(Object object, String string) {
        WorkflowModel workflowModel = (WorkflowModel)this.getFilteredModel();
        Context context = workflowModel.getContext();
        AbstractNode abstractNode = (AbstractNode)object;
        List<GeneralLink> list = workflowModel.findLinksToNode((IlvSDMNode)abstractNode);
        for (GeneralLink generalLink : list) {
            String string2 = ((AbstractNode)generalLink.getFrom()).getData().getName();
            String string3 = GeneralLink.generateLinkName(string2, string);
            this.prepareUndo(generalLink, context, "label", string3);
        }
    }

    public void setObjectProperty(Object object, ComplexProperty complexProperty) {
        String string = complexProperty.getPropertyName();
        String string2 = complexProperty.getUndoPropertyName();
        Object object2 = null;
        if (string.equals(string2)) {
            object2 = this.getObjectProperty(object, complexProperty);
            if (!complexProperty.isForceUpdate() && OdmrSDMUndoFilter.areEqual(object2, complexProperty.getData())) {
                return;
            }
        } else {
            object2 = complexProperty.getData();
        }
        if (this.isCapturing(2)) {
            OdmrSDMSetPropertyCommand odmrSDMSetPropertyCommand = new OdmrSDMSetPropertyCommand(this.getFilteredModel(), object, string, string2, object2, complexProperty.getData());
            this.invokeCommand((Command)odmrSDMSetPropertyCommand);
        } else {
            super.setObjectProperty(object, string, complexProperty.getData());
        }
    }

    private Object getObjectProperty(Object object, ComplexProperty complexProperty) {
        Object object2 = null;
        if (object instanceof AbstractNode) {
            object2 = ((AbstractNode)object).getProperty(complexProperty);
        }
        return object2;
    }

    public void prepareUndoComplexPropertyList(final Object object, Context context, final List<ComplexProperty> list) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    for (ComplexProperty complexProperty : list) {
                        OdmrSDMUndoFilter.this.setObjectProperty(object, complexProperty);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        };
        this.captureUndo(context, runnable);
    }

    public void prepareUndoComplexPropertyList(final Object object, Context context, final List<ComplexProperty> list, int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    for (ComplexProperty complexProperty : list) {
                        OdmrSDMUndoFilter.this.setObjectProperty(object, complexProperty);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        };
        this.captureUndo(context, n, runnable);
    }

    public void prepareUndo(final Object object, Context context, final ComplexProperty complexProperty) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    OdmrSDMUndoFilter.this.setObjectProperty(object, complexProperty);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        };
        this.captureUndo(context, runnable);
    }

    public void prepareUndo(final Object object, Context context, final String string, final Object object2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    OdmrSDMUndoFilter.this.setObjectProperty(object, string, object2);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        };
        this.captureUndo(context, runnable);
    }

    public void prepareUndo(final Object object, Context context, final String string, final Object object2, int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    OdmrSDMUndoFilter.this.setObjectProperty(object, string, object2);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        };
        this.captureUndo(context, n, runnable);
    }

    public void prepareUndoPropertyList(final Object object, Context context, final List<Property> list) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    for (Property property : list) {
                        OdmrSDMUndoFilter.this.setObjectProperty(object, property.getId(), property.getValue());
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        };
        this.captureUndo(context, runnable);
    }

    protected static boolean areEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        return object != null && object2 != null && (object.equals(object2) || WorkflowUtils.areEqual(object, object2));
    }

    public int getNoUndoMask() {
        return 1;
    }
}

