/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CacheSettings;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicAnomalyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicClusterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicFeatureNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicPredictionNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExpectationMaximizationAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.ExpectationMaximizationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettings;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.dmt.dataminer.workflow.xmlschema.HeuristicResultType;
import oracle.dmt.dataminer.workflow.xmlschema.HeuristicSummaryResultType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningData;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.TestDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public class MetaDataHelper {
    private static final Logger theLogger = Logger.getLogger(MetaDataHelper.class.getName());
    public static final String INPUT = "Yes";
    public static final String IGNORE = "No";
    private static final String CUTOFF_FOR_NUMBER_FOR_CAT = "ODMR$CUTOFF_FOR_NUMBER_FOR_CAT";
    private static final String MAX_DISTINCT_CAT_CUTOFF = "ODMR$MAX_DISTINCT_CAT_CUTOFF";
    private static final String PERCENT_UNI_THRESHOLD_CAT = "ODMR$PERCENT_UNI_THRESHOLD_CAT";
    private static final String ATTRIBUTE_NAME = "ATTR";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String UNIQUE_COUNT = "DISTINCT_CNT";
    private static final String MAX_LENGTH = "MAX_DATA_LENGTH";
    private static final String CATEGORICAL_COUNT = "DISTINCT_CNT";
    private static final String CATEGORICAL_PERCENT = "DISTINCT_PERCENT";
    private static final String CUSTOM = "CUSTOM";
    private static final String STATISTICS_QUERY = "SELECT ATTR, DATA_TYPE, DISTINCT_CNT, MAX_DATA_LENGTH ,DISTINCT_CNT, DISTINCT_PERCENT, CUSTOM FROM {0}";

    public static HashMap<String, List<? extends NodeType>> getNodeCollectionMap(WorkflowProcess workflowProcess) {
        HashMap<String, List<? extends NodeType>> hashMap = new HashMap<String, List<? extends NodeType>>();
        hashMap.put(AggregationNodeType.class.getName(), workflowProcess.getNodes().getAggregation());
        hashMap.put(AnomalyDetectionBuildNodeType.class.getName(), workflowProcess.getNodes().getAnomalyDetectionBuild());
        hashMap.put(ApplyNodeType.class.getName(), workflowProcess.getNodes().getApply());
        hashMap.put(ApplyTextNodeType.class.getName(), workflowProcess.getNodes().getApplyText());
        hashMap.put(AssociationBuildNodeType.class.getName(), workflowProcess.getNodes().getAssociationBuild());
        hashMap.put(ClassificationBuildNodeType.class.getName(), workflowProcess.getNodes().getClassificationBuild());
        hashMap.put(ClusteringBuildNodeType.class.getName(), workflowProcess.getNodes().getClusteringBuild());
        hashMap.put(ColumnFilterNodeType.class.getName(), workflowProcess.getNodes().getColumnFilter());
        hashMap.put(DataProfileNodeType.class.getName(), workflowProcess.getNodes().getDataProfile());
        hashMap.put(DataSourceNodeType.class.getName(), workflowProcess.getNodes().getDataSource());
        hashMap.put(FeatureExtractionBuildNodeType.class.getName(), workflowProcess.getNodes().getFeatureExtractionBuild());
        hashMap.put(FilterDetailsDataNodeType.class.getName(), workflowProcess.getNodes().getFilterDetails());
        hashMap.put(JoinNodeType.class.getName(), workflowProcess.getNodes().getJoin());
        hashMap.put(ModelNodeType.class.getName(), workflowProcess.getNodes().getModel());
        hashMap.put(ModelDetailsDataNodeType.class.getName(), workflowProcess.getNodes().getModelDetails());
        hashMap.put(RegressionBuildNodeType.class.getName(), workflowProcess.getNodes().getRegressionBuild());
        hashMap.put(RowFilterNodeType.class.getName(), workflowProcess.getNodes().getRowFilter());
        hashMap.put(SampleNodeType.class.getName(), workflowProcess.getNodes().getSample());
        hashMap.put(TestNodeType.class.getName(), workflowProcess.getNodes().getTest());
        hashMap.put(TestDetailsDataNodeType.class.getName(), workflowProcess.getNodes().getTestDetails());
        hashMap.put(BuildTextNodeRefType.class.getName(), workflowProcess.getNodes().getBuildTextRef());
        hashMap.put(CreateTableNodeType.class.getName(), workflowProcess.getNodes().getCreateTable());
        hashMap.put(UpdateTableNodeType.class.getName(), workflowProcess.getNodes().getUpdateTable());
        hashMap.put(TransformationNodeType.class.getName(), workflowProcess.getNodes().getTransformation());
        hashMap.put(FeatureExtractionBuildNodeType.class.getName(), workflowProcess.getNodes().getFeatureExtractionBuild());
        hashMap.put(BuildTextNodeType.class.getName(), workflowProcess.getNodes().getBuildText());
        hashMap.put(DynamicPredictionNodeType.class.getName(), workflowProcess.getNodes().getDynamicPrediction());
        hashMap.put(DynamicFeatureNodeType.class.getName(), workflowProcess.getNodes().getDynamicFeature());
        hashMap.put(DynamicClusterNodeType.class.getName(), workflowProcess.getNodes().getDynamicCluster());
        hashMap.put(DynamicAnomalyNodeType.class.getName(), workflowProcess.getNodes().getDynamicAnomaly());
        hashMap.put(SQLQueryNodeType.class.getName(), workflowProcess.getNodes().getSQLQuery());
        hashMap.put(GraphNodeType.class.getName(), workflowProcess.getNodes().getGraph());
        hashMap.put(JSONQueryNodeType.class.getName(), workflowProcess.getNodes().getJSONQuery());
        return hashMap;
    }

    public static String getNodeTypeName(NodeType nodeType) {
        return MetaDataHelper.getNodeTypeNameMap().get(nodeType.getClass().getName());
    }

    public static HashMap<String, String> getNodeTypeParallelExcluded() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ModelNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_MODEL_NAME"));
        hashMap.put(BuildTextNodeRefType.class.getName(), WorkflowEditorLrb.get("PALETTE_BUILD_TEXT_NAME"));
        return hashMap;
    }

    public static HashMap<String, String> getNodeTypeNameMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(AggregationNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_AGGREGATION_NAME"));
        hashMap.put(AnomalyDetectionBuildNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_ANOMALY_DETECTION_NAME"));
        hashMap.put(ApplyNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_APPLY_NAME"));
        hashMap.put(ApplyTextNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_APPLY_TEXT_NAME"));
        hashMap.put(AssociationBuildNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_ASSOCIATION_NAME"));
        hashMap.put(ClassificationBuildNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_CLASSIFICATION_NAME"));
        hashMap.put(ClusteringBuildNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_CLUSTERING_NAME"));
        hashMap.put(ColumnFilterNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_NAME"));
        hashMap.put(DataProfileNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_DATA_PROFILE_NAME"));
        hashMap.put(DataSourceNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_DATA_SOURCE_NAME"));
        hashMap.put(FeatureExtractionBuildNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_FEATURE_EXTRACTION_NAME"));
        hashMap.put(FilterDetailsDataNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_DETAILS_NAME"));
        hashMap.put(JoinNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_JOIN_NAME"));
        hashMap.put(ModelNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_MODEL_NAME"));
        hashMap.put(ModelDetailsDataNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_MODEL_DETAILS_NAME"));
        hashMap.put(RegressionBuildNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_REGRESSION_NAME"));
        hashMap.put(RowFilterNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_ROW_FILTER_NAME"));
        hashMap.put(SampleNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_SAMPLE_NAME"));
        hashMap.put(TestNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_TEST_NAME"));
        hashMap.put(CreateTableNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_CREATE_TABLE_NAME"));
        hashMap.put(UpdateTableNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_UPDATE_TABLE_NAME"));
        hashMap.put(TransformationNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_TRANSFORMATION_NAME"));
        hashMap.put(FeatureExtractionBuildNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_FEATURE_EXTRACTION_NAME"));
        hashMap.put(BuildTextNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_BUILD_TEXT_NAME"));
        hashMap.put(DynamicPredictionNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_DYNAMIC_PREDICTION_NODE_NAME"));
        hashMap.put(DynamicFeatureNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_DYNAMIC_FEATURE_NODE_NAME"));
        hashMap.put(DynamicClusterNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_DYNAMIC_CLUSTER_NODE_NAME"));
        hashMap.put(DynamicAnomalyNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_DYNAMIC_ANOMALY_DETECTION_NODE_NAME"));
        hashMap.put(SQLQueryNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_SQL_QUERY_NAME"));
        hashMap.put(GraphNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_GRAPH_NODE_NAME"));
        hashMap.put(JSONQueryNodeType.class.getName(), WorkflowEditorLrb.get("PALETTE_JSON_QUERY_NAME"));
        return hashMap;
    }

    public static List<? extends NodeType> getNodeCollection(WorkflowProcess workflowProcess) {
        ArrayList<? extends NodeType> arrayList = new ArrayList<NodeType>();
        HashMap<String, List<? extends NodeType>> hashMap = MetaDataHelper.getNodeCollectionMap(workflowProcess);
        for (List<? extends NodeType> list : hashMap.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static List<StoplistType> getStoplistsCollection(BuildTextNodeType buildTextNodeType) {
        ArrayList<StoplistType> arrayList = new ArrayList<StoplistType>();
        TextNodeType.Stoplists stoplists = buildTextNodeType.getStoplists();
        arrayList.addAll(stoplists.getStoplist());
        return arrayList;
    }

    public static Map<String, StoplistType> getStoplistsCollection(WorkflowProcess workflowProcess) {
        HashMap<String, StoplistType> hashMap = new HashMap<String, StoplistType>();
        List list = workflowProcess.getNodes().getBuildText();
        for (BuildTextNodeType buildTextNodeType : list) {
            TextNodeType.Stoplists stoplists = buildTextNodeType.getStoplists();
            for (StoplistType stoplistType : stoplists.getStoplist()) {
                if (stoplistType.getName().equals("Default")) continue;
                hashMap.put(buildTextNodeType.getName(), stoplistType);
            }
        }
        return hashMap;
    }

    public static GraphType getGraphType(GraphSettingsType graphSettingsType) {
        Object var1_1 = null;
        return null;
    }

    public static Collection<String> getModelNames(BuildNodeType buildNodeType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        for (ModelType modelType : list) {
            arrayList.add(modelType.getName());
        }
        return arrayList;
    }

    public static List<ModelType> getModelsCollection(BuildNodeType buildNodeType) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType;
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
            if (classificationBuildNodeType.getModels() != null) {
                arrayList.addAll(classificationBuildNodeType.getModels().getCGeneralizedLinearModel());
                arrayList.addAll(classificationBuildNodeType.getModels().getCSupportVectorMachineModel());
                arrayList.addAll(classificationBuildNodeType.getModels().getDecisionTreeModel());
                arrayList.addAll(classificationBuildNodeType.getModels().getNaiveBayesModel());
            }
        } else if (buildNodeType instanceof RegressionBuildNodeType) {
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)buildNodeType;
            if (regressionBuildNodeType.getModels() != null) {
                arrayList.addAll(regressionBuildNodeType.getModels().getRGeneralizedLinearModel());
                arrayList.addAll(regressionBuildNodeType.getModels().getRSupportVectorMachineModel());
            }
        } else if (buildNodeType instanceof ClusteringBuildNodeType) {
            ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)buildNodeType;
            if (clusteringBuildNodeType.getModels() != null) {
                arrayList.addAll(clusteringBuildNodeType.getModels().getKMeansModel());
                arrayList.addAll(clusteringBuildNodeType.getModels().getOClusterModel());
                arrayList.addAll(clusteringBuildNodeType.getModels().getExpectationMaximizationModel());
            }
        } else if (buildNodeType instanceof AssociationBuildNodeType) {
            AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)buildNodeType;
            if (associationBuildNodeType.getModels() != null) {
                arrayList.addAll(associationBuildNodeType.getModels().getAprioriModel());
            }
        } else if (buildNodeType instanceof AnomalyDetectionBuildNodeType) {
            AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)buildNodeType;
            if (anomalyDetectionBuildNodeType.getModels() != null) {
                arrayList.addAll(anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel());
            }
        } else if (buildNodeType instanceof FeatureExtractionBuildNodeType && (featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)buildNodeType).getModels() != null) {
            arrayList.addAll(featureExtractionBuildNodeType.getModels().getNonNegativeMatrixFactorModel());
            arrayList.addAll(featureExtractionBuildNodeType.getModels().getPCAModel());
            arrayList.addAll(featureExtractionBuildNodeType.getModels().getSVDModel());
        }
        return arrayList;
    }

    public static Map<String, String> getWeightTablesCollection(BuildNodeType buildNodeType) {
        ClassificationBuildNodeType classificationBuildNodeType;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (buildNodeType instanceof ClassificationBuildNodeType && (classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType).getModels() != null) {
            String string;
            String string2;
            Object object;
            Object object2;
            Object object32;
            List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
            for (Object object32 : list) {
                object2 = object32.getPerformance().getBalanced();
                if (object2 == null) continue;
                object = object2.getWeightsTable();
                hashMap.put(object32.getId(), (String)object);
            }
            List list2 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
            object32 = list2.iterator();
            while (object32.hasNext()) {
                object2 = (CSupportVectorMachineModelType)object32.next();
                object = object2.getPerformance().getBalanced();
                if (object == null) continue;
                string2 = object.getWeightsTable();
                hashMap.put(object2.getId(), string2);
            }
            object32 = classificationBuildNodeType.getModels().getDecisionTreeModel();
            object2 = object32.iterator();
            while (object2.hasNext()) {
                object = (DecisionTreeModelType)object2.next();
                string2 = object.getPerformance().getBalanced();
                if (string2 == null) continue;
                string = string2.getWeightsTable();
                hashMap.put(object.getId(), string);
            }
            object2 = classificationBuildNodeType.getModels().getNaiveBayesModel();
            object = object2.iterator();
            while (object.hasNext()) {
                string2 = (NaiveBayesModelType)object.next();
                string = string2.getPerformance().getBalanced();
                if (string == null) continue;
                String string3 = string.getWeightsTable();
                hashMap.put(string2.getId(), string3);
            }
        }
        return hashMap;
    }

    public static List<RefModelType> createRefModelTypeCollection(MiningFunctionType miningFunctionType, List<? extends ModelType> list, String string, String string2) {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        for (ModelType modelType : list) {
            RefModelType refModelType = MetaDataHelper.createRefModelType(modelType, miningFunctionType, string2, string);
            arrayList.add(refModelType);
        }
        return arrayList;
    }

    public static RefModelType createRefModelType(ModelType modelType, MiningFunctionType miningFunctionType, String string, String string2) {
        RefModelType refModelType = new RefModelType();
        refModelType.setName(modelType.getName());
        refModelType.setMiningAlgorithm(MetaDataHelper.getMiningAlgorithmType(miningFunctionType, modelType));
        refModelType.setMiningFunction(miningFunctionType);
        refModelType.setModelId(modelType.getId());
        refModelType.setSchema(string);
        refModelType.setUseForOutput(modelType.isUseForOutput());
        if (modelType.getStatus().equals((Object)ModelStatusType.COMPLETE)) {
            refModelType.setIsModelBuilt(true);
        } else {
            refModelType.setIsModelBuilt(false);
        }
        refModelType.setNodeId(string2);
        refModelType.setStatus(RefModelStatusType.VALID);
        return refModelType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MiningAlgorithmType getMiningAlgorithmType(MiningFunctionType miningFunctionType, ModelType modelType) {
        MiningAlgorithmType miningAlgorithmType = null;
        if (miningFunctionType == MiningFunctionType.CLASSIFICATION) {
            if (modelType instanceof CGeneralizedLinearModelType) {
                return MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
            }
            if (modelType instanceof CSupportVectorMachineModelType) {
                return MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
            }
            if (modelType instanceof DecisionTreeModelType) {
                return MiningAlgorithmType.DECISION_TREE;
            }
            if (!(modelType instanceof NaiveBayesModelType)) throw new RuntimeException("Unknown ModelType, please add.");
            return MiningAlgorithmType.NAIVE_BAYES;
        }
        if (miningFunctionType == MiningFunctionType.REGRESSION) {
            if (modelType instanceof RGeneralizedLinearModelType) {
                return MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
            }
            if (!(modelType instanceof RSupportVectorMachineModelType)) throw new RuntimeException("Unknown ModelType, please add.");
            return MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
        }
        if (miningFunctionType == MiningFunctionType.CLUSTERING) {
            if (modelType instanceof KMeansModelType) {
                return MiningAlgorithmType.KMEANS;
            }
            if (modelType instanceof OClusterModelType) {
                return MiningAlgorithmType.O_CLUSTER;
            }
            if (!(modelType instanceof ExpectationMaximizationModelType)) throw new RuntimeException("Unknown ModelType, please add.");
            return MiningAlgorithmType.EXPECTATION_MAXIMIZATION;
        }
        if (miningFunctionType == MiningFunctionType.ASSOCIATION) {
            if (!(modelType instanceof AprioriModelType)) throw new RuntimeException("Unknown ModelType, please add.");
            return MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
        }
        if (miningFunctionType == MiningFunctionType.ANOMALY_DETECTION) {
            if (!(modelType instanceof AnomalyDetectionModelType)) throw new RuntimeException("Unknown ModelType, please add.");
            return MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
        }
        if (miningFunctionType != MiningFunctionType.FEATURE_EXTRACTION) throw new RuntimeException("Unknown MiningFunctionType, please add.");
        if (modelType instanceof NonNegativeMatrixFactorModelType) {
            return MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR;
        }
        if (modelType instanceof SVDModelType) {
            return MiningAlgorithmType.SINGULAR_VALUE_DECOMP;
        }
        if (!(modelType instanceof PCAModelType)) throw new RuntimeException("Unknown ModelType, please add.");
        return MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS;
    }

    public static MiningFunctionType getMiningFunctionType(BuildNodeType buildNodeType) {
        MiningFunctionType miningFunctionType = null;
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            miningFunctionType = MiningFunctionType.CLASSIFICATION;
        } else if (buildNodeType instanceof RegressionBuildNodeType) {
            miningFunctionType = MiningFunctionType.REGRESSION;
        } else if (buildNodeType instanceof ClusteringBuildNodeType) {
            miningFunctionType = MiningFunctionType.CLUSTERING;
        } else if (buildNodeType instanceof AssociationBuildNodeType) {
            miningFunctionType = MiningFunctionType.ASSOCIATION;
        } else if (buildNodeType instanceof AnomalyDetectionBuildNodeType) {
            miningFunctionType = MiningFunctionType.ANOMALY_DETECTION;
        } else if (buildNodeType instanceof FeatureExtractionBuildNodeType) {
            miningFunctionType = MiningFunctionType.FEATURE_EXTRACTION;
        } else {
            throw new RuntimeException("Unknown BuildNodeType, please add missing type");
        }
        return miningFunctionType;
    }

    public static List<RefModelType> getModelsCollection(BuildNodeType buildNodeType, Context context) throws Exception {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        return MetaDataHelper.getModelsCollection(buildNodeType, list, context);
    }

    public static List<RefModelType> getModelsCollection(BuildNodeType buildNodeType, List<ModelType> list, Context context) throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList();
        String string = ConnectionFolder.getUserAccountName(context);
        string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
        arrayList = MetaDataHelper.createRefModelTypeCollection(MetaDataHelper.getMiningFunctionType(buildNodeType), list, buildNodeType.getId(), string);
        return arrayList;
    }

    public static List<TestModelType.Model> getModelsCollection(TestNodeType testNodeType) {
        ArrayList<TestModelType.Model> arrayList = new ArrayList<TestModelType.Model>();
        if (testNodeType.getTestModels().getModel().size() > 0) {
            arrayList.addAll(testNodeType.getTestModels().getModel());
        }
        return arrayList;
    }

    public static List<ApplyOutputColumnsType.OutputColumn> getModelsCollection(ApplyNode applyNode) {
        ApplyNodeType applyNodeType;
        NodeType nodeType = applyNode.getData();
        ArrayList<ApplyOutputColumnsType.OutputColumn> arrayList = new ArrayList<ApplyOutputColumnsType.OutputColumn>();
        if (nodeType instanceof ApplyNodeType && (applyNodeType = (ApplyNodeType)nodeType).getOutputColumns() != null) {
            arrayList.addAll(applyNodeType.getOutputColumns().getOutputColumn());
        }
        return arrayList;
    }

    public static List<AttributeType> getSuppAttrsCollection(ApplyNode applyNode) {
        ApplyNodeType applyNodeType;
        NodeType nodeType = applyNode.getData();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (nodeType instanceof ApplyNodeType && (applyNodeType = (ApplyNodeType)nodeType).getSupplementalAttributes() != null) {
            arrayList.addAll(applyNodeType.getSupplementalAttributes().getAttribute());
        }
        return arrayList;
    }

    public static List<ClassificationResultType> getClassResultsCollection(AbstractBuildNode abstractBuildNode) {
        ClassificationBuildNodeType classificationBuildNodeType;
        NodeType nodeType = abstractBuildNode.getData();
        ArrayList<ClassificationResultType> arrayList = new ArrayList<ClassificationResultType>();
        if (nodeType instanceof ClassificationBuildNodeType && (classificationBuildNodeType = (ClassificationBuildNodeType)nodeType).getResults() != null) {
            arrayList.addAll(classificationBuildNodeType.getResults().getClassificationResult());
        }
        return arrayList;
    }

    public static List<ClassificationResultType> getClassResultsForTuningCollection(AbstractBuildNode abstractBuildNode) {
        ClassificationBuildNodeType classificationBuildNodeType;
        NodeType nodeType = abstractBuildNode.getData();
        ArrayList<ClassificationResultType> arrayList = new ArrayList<ClassificationResultType>();
        if (nodeType instanceof ClassificationBuildNodeType && (classificationBuildNodeType = (ClassificationBuildNodeType)nodeType).getResults() != null) {
            arrayList.addAll(classificationBuildNodeType.getResults().getClassificationResultForTuning());
        }
        return arrayList;
    }

    public static List<RegressionResultType> getRegressResultsCollection(AbstractBuildNode abstractBuildNode) {
        RegressionBuildNodeType regressionBuildNodeType;
        NodeType nodeType = abstractBuildNode.getData();
        ArrayList<RegressionResultType> arrayList = new ArrayList<RegressionResultType>();
        if (nodeType instanceof RegressionBuildNodeType && (regressionBuildNodeType = (RegressionBuildNodeType)nodeType).getResults() != null) {
            arrayList.addAll(regressionBuildNodeType.getResults().getRegressionResult());
        }
        return arrayList;
    }

    public static List<? extends MiningResultType> getResultsCollection(SuperviseBuildNodeType superviseBuildNodeType) {
        List list = new ArrayList();
        if (superviseBuildNodeType instanceof ClassificationBuildNodeType) {
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)superviseBuildNodeType;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            list = results.getClassificationResult();
        } else if (superviseBuildNodeType instanceof RegressionBuildNodeType) {
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)superviseBuildNodeType;
            RegressionBuildNodeType.Results results = regressionBuildNodeType.getResults();
            list = results.getRegressionResult();
        }
        return list;
    }

    public static List<? extends MiningResultType> getResultsCollection(SuperviseBuildNodeType superviseBuildNodeType, Collection<? extends ModelType> collection) {
        ArrayList<MiningResultType> arrayList = new ArrayList<MiningResultType>();
        HashMap<String, ModelType> hashMap = new HashMap<String, ModelType>();
        for (ModelType object2 : collection) {
            hashMap.put(object2.getId(), object2);
        }
        List<? extends MiningResultType> list = MetaDataHelper.getResultsCollection(superviseBuildNodeType);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MiningResultType miningResultType = (MiningResultType)iterator.next();
            if (!hashMap.containsKey(miningResultType.getModelId())) continue;
            arrayList.add(miningResultType);
        }
        return arrayList;
    }

    public static List<ClassificationResultType> getClassResultsCollection(TestNode testNode) {
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        ArrayList<ClassificationResultType> arrayList = new ArrayList<ClassificationResultType>();
        if (testNodeType.getResults().getClassificationResult().size() > 0) {
            arrayList.addAll(testNodeType.getResults().getClassificationResult());
        }
        return arrayList;
    }

    public static List<RegressionResultType> getRegressResultsCollection(TestNode testNode) {
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        ArrayList<RegressionResultType> arrayList = new ArrayList<RegressionResultType>();
        if (testNodeType.getResults().getRegressionResult().size() > 0) {
            arrayList.addAll(testNodeType.getResults().getRegressionResult());
        }
        return arrayList;
    }

    public static List<? extends MiningResultType> getResultsCollection(TestNode testNode) {
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        List<Object> list = new ArrayList();
        if (!testNodeType.getTestModels().getModel().isEmpty()) {
            if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                list = MetaDataHelper.getClassResultsCollection(testNode);
            } else if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                list = MetaDataHelper.getRegressResultsCollection(testNode);
            }
        }
        return list;
    }

    public static ModelType getModelType(AbstractBuildNode abstractBuildNode, String string) {
        ModelType modelType = null;
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        for (ModelType modelType2 : list) {
            if (modelType2.getName().compareTo(string) != 0) continue;
            modelType = modelType2;
            break;
        }
        return modelType;
    }

    public static ModelNodeType.Models.Model getModel(ModelNode modelNode, String string) {
        ModelNodeType.Models.Model model = null;
        List<ModelNodeType.Models.Model> list = MetaDataHelper.getModelsCollection((ModelNodeType)modelNode.getData());
        for (ModelNodeType.Models.Model model2 : list) {
            if (model2.getName().compareTo(string) != 0) continue;
            model = model2;
            break;
        }
        return model;
    }

    public static ModelNodeType.Models.Model getModelUsingId(ModelNode modelNode, String string) {
        ModelNodeType.Models.Model model = null;
        List<ModelNodeType.Models.Model> list = MetaDataHelper.getModelsCollection((ModelNodeType)modelNode.getData());
        for (ModelNodeType.Models.Model model2 : list) {
            if (!model2.getModelId().equals(string)) continue;
            model = model2;
            break;
        }
        return model;
    }

    public static List<ModelNodeType.Models.Model> getModelsCollection(ModelNodeType modelNodeType) {
        ModelNodeType modelNodeType2;
        List list = null;
        if (modelNodeType != null) {
            modelNodeType2 = modelNodeType;
            list = modelNodeType2.getModels().getModel();
        }
        assert (list != null) : "Unknown model node type!";
        modelNodeType2 = list;
        return modelNodeType2;
    }

    public static TestModelType.Model getModel(TestNode testNode, String string) {
        TestModelType.Model model = null;
        List<TestModelType.Model> list = MetaDataHelper.getModelsCollection((TestNodeType)testNode.getData());
        for (TestModelType.Model model2 : list) {
            if (model2.getName().compareTo(string) != 0) continue;
            model = model2;
            break;
        }
        return model;
    }

    public static TestModelType.Model getModelUsingId(TestNode testNode, String string) {
        TestModelType.Model model = null;
        List<TestModelType.Model> list = MetaDataHelper.getModelsCollection((TestNodeType)testNode.getData());
        for (TestModelType.Model model2 : list) {
            if (!model2.getModelId().equals(string)) continue;
            model = model2;
            break;
        }
        return model;
    }

    public static List<ModelType> getModelsCollectionForType(BuildNodeType buildNodeType, ModelType modelType) {
        Object object;
        List list = null;
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            object = (ClassificationBuildNodeType)buildNodeType;
            if (modelType instanceof NaiveBayesModelType) {
                list = object.getModels().getNaiveBayesModel();
            } else if (modelType instanceof DecisionTreeModelType) {
                list = object.getModels().getDecisionTreeModel();
            } else if (modelType instanceof CSupportVectorMachineModelType) {
                list = object.getModels().getCSupportVectorMachineModel();
            } else if (modelType instanceof CGeneralizedLinearModelType) {
                list = object.getModels().getCGeneralizedLinearModel();
            }
        } else if (buildNodeType instanceof RegressionBuildNodeType) {
            object = (RegressionBuildNodeType)buildNodeType;
            if (modelType instanceof RSupportVectorMachineModelType) {
                list = object.getModels().getRSupportVectorMachineModel();
            } else if (modelType instanceof RGeneralizedLinearModelType) {
                list = object.getModels().getRGeneralizedLinearModel();
            }
        } else if (buildNodeType instanceof ClusteringBuildNodeType) {
            object = (ClusteringBuildNodeType)buildNodeType;
            if (modelType instanceof KMeansModelType) {
                list = object.getModels().getKMeansModel();
            } else if (modelType instanceof OClusterModelType) {
                list = object.getModels().getOClusterModel();
            } else if (modelType instanceof ExpectationMaximizationModelType) {
                list = object.getModels().getExpectationMaximizationModel();
            }
        } else if (buildNodeType instanceof AssociationBuildNodeType) {
            object = (AssociationBuildNodeType)buildNodeType;
            list = object.getModels().getAprioriModel();
        } else if (buildNodeType instanceof AnomalyDetectionBuildNodeType) {
            object = (AnomalyDetectionBuildNodeType)buildNodeType;
            list = object.getModels().getAnomalyDetectionModel();
        } else if (buildNodeType instanceof FeatureExtractionBuildNodeType) {
            object = (FeatureExtractionBuildNodeType)buildNodeType;
            if (modelType instanceof NonNegativeMatrixFactorModelType) {
                list = object.getModels().getNonNegativeMatrixFactorModel();
            } else if (modelType instanceof SVDModelType) {
                list = object.getModels().getSVDModel();
            } else if (modelType instanceof PCAModelType) {
                list = object.getModels().getPCAModel();
            }
        }
        assert (list != null) : "Unknown model collection type!";
        object = list;
        return object;
    }

    public static boolean replaceModel(BuildNodeType buildNodeType, ModelType modelType, String string) {
        boolean bl = false;
        List<ModelType> list = MetaDataHelper.getModelsCollectionForType(buildNodeType, modelType);
        ModelType modelType2 = null;
        for (ModelType object : list) {
            if (!object.getName().equals(string)) continue;
            modelType2 = object;
            bl = true;
            break;
        }
        if (bl) {
            if (buildNodeType instanceof SuperviseBuildNodeType) {
                ArrayList arrayList = new ArrayList();
                arrayList.add(modelType2);
                List<? extends MiningResultType> list2 = MetaDataHelper.getResultsCollection((SuperviseBuildNodeType)buildNodeType, arrayList);
                for (MiningResultType miningResultType : list2) {
                    miningResultType.setStatus(ModelStatusType.READY);
                }
            }
            int n = list.indexOf(modelType2);
            list.remove(modelType2);
            modelType.setStatus(ModelStatusType.READY);
            list.add(n, modelType);
        }
        return bl;
    }

    public static boolean removeModel(BuildNodeType buildNodeType, ModelType modelType) {
        boolean bl = true;
        List<ModelType> list = null;
        list = MetaDataHelper.getModelsCollectionForType(buildNodeType, modelType);
        ModelType modelType2 = null;
        for (ModelType modelType3 : list) {
            if (!modelType3.getName().equals(modelType.getName())) continue;
            modelType2 = modelType3;
            break;
        }
        bl = list.remove(modelType2);
        return bl;
    }

    public static boolean removeModel(ModelNodeType modelNodeType, ModelNodeType.Models.Model model) {
        boolean bl = true;
        List<ModelNodeType.Models.Model> list = null;
        list = MetaDataHelper.getModelsCollection(modelNodeType);
        ModelNodeType.Models.Model model2 = null;
        for (ModelNodeType.Models.Model model3 : list) {
            if (!model3.getName().equals(model.getName())) continue;
            model2 = model3;
            break;
        }
        bl = list.remove(model2);
        return bl;
    }

    public static boolean addModel(ModelNodeType modelNodeType, ModelNodeType.Models.Model model) {
        boolean bl = true;
        List<ModelNodeType.Models.Model> list = null;
        list = MetaDataHelper.getModelsCollection(modelNodeType);
        bl = list.add(model);
        return bl;
    }

    public static boolean addModel(BuildNodeType buildNodeType, ModelType modelType) {
        boolean bl = true;
        boolean bl2 = false;
        List<ModelType> list = null;
        list = MetaDataHelper.getModelsCollectionForType(buildNodeType, modelType);
        for (ModelType modelType2 : list) {
            if (!modelType2.getId().equals(modelType.getId())) continue;
            bl2 = true;
        }
        if (!bl2) {
            bl = list.add(modelType);
        }
        return bl;
    }

    public static CSupportVectorMachineModelType createSVMClassificationModel() {
        CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = new CSupportVectorMachineAlgoType();
        cSupportVectorMachineAlgoType.setSVMSACTIVELEARNING("SVMS_AL_ENABLE");
        cSupportVectorMachineAlgoType.setSVMSCONVTOLERANCE(0.001);
        cSupportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(null);
        cSupportVectorMachineAlgoType.setSVMSKERNELFUNCTION(null);
        CSupportVectorMachineModelType cSupportVectorMachineModelType = new CSupportVectorMachineModelType();
        cSupportVectorMachineModelType.setCSupportVectorMachineAlgo(cSupportVectorMachineAlgoType);
        return cSupportVectorMachineModelType;
    }

    public static CGeneralizedLinearModelType createGLMClassificationModel() {
        CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType = new CGeneralizedLinearAlgoType();
        cGeneralizedLinearAlgoType.setGLMSCONFLEVEL(0.95);
        CGeneralizedLinearModelType cGeneralizedLinearModelType = new CGeneralizedLinearModelType();
        cGeneralizedLinearModelType.setCGeneralizedLinearAlgo(cGeneralizedLinearAlgoType);
        return cGeneralizedLinearModelType;
    }

    public static DecisionTreeModelType createDecisionTreeModel() {
        DecisionTreeAlgoType decisionTreeAlgoType = new DecisionTreeAlgoType();
        decisionTreeAlgoType.setTREEIMPURITYMETRIC("TREE_IMPURITY_GINI");
        decisionTreeAlgoType.setTREETERMMAXDEPTH(7);
        decisionTreeAlgoType.setTREETERMMINPCTNODE(0.05);
        decisionTreeAlgoType.setTREETERMMINPCTSPLIT(0.1);
        decisionTreeAlgoType.setTREETERMMINRECNODE(BigInteger.valueOf(10L));
        decisionTreeAlgoType.setTREETERMMINRECSPLIT(BigInteger.valueOf(20L));
        DecisionTreeModelType decisionTreeModelType = new DecisionTreeModelType();
        decisionTreeModelType.setDecisionTreeAlgo(decisionTreeAlgoType);
        return decisionTreeModelType;
    }

    public static NaiveBayesModelType createNaiveBayesModel() {
        NaiveBayesAlgoType naiveBayesAlgoType = new NaiveBayesAlgoType();
        naiveBayesAlgoType.setNABSPAIRWISETHRESHOLD(0.0);
        naiveBayesAlgoType.setNABSSINGLETONTHRESHOLD(0.0);
        NaiveBayesModelType naiveBayesModelType = new NaiveBayesModelType();
        naiveBayesModelType.setNaiveBayesAlgo(naiveBayesAlgoType);
        return naiveBayesModelType;
    }

    public static RGeneralizedLinearModelType createGLMRegressionModel() {
        RGeneralizedLinearAlgoType rGeneralizedLinearAlgoType = new RGeneralizedLinearAlgoType();
        rGeneralizedLinearAlgoType.setGLMSCONFLEVEL(0.95);
        rGeneralizedLinearAlgoType.setGLMSVIFFORRIDGE("GLMS_VIF_RIDGE_DISABLE");
        RGeneralizedLinearModelType rGeneralizedLinearModelType = new RGeneralizedLinearModelType();
        rGeneralizedLinearModelType.setRGeneralizedLinearModelAlgo(rGeneralizedLinearAlgoType);
        return rGeneralizedLinearModelType;
    }

    public static RSupportVectorMachineModelType createSVMRegressionModel() {
        RSupportVectorMachineAlgoType rSupportVectorMachineAlgoType = new RSupportVectorMachineAlgoType();
        rSupportVectorMachineAlgoType.setSVMSACTIVELEARNING("SVMS_AL_ENABLE");
        rSupportVectorMachineAlgoType.setSVMSCONVTOLERANCE(0.001);
        rSupportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(null);
        rSupportVectorMachineAlgoType.setSVMSKERNELFUNCTION(null);
        RSupportVectorMachineModelType rSupportVectorMachineModelType = new RSupportVectorMachineModelType();
        rSupportVectorMachineModelType.setRSupportVectorMachineAlgo(rSupportVectorMachineAlgoType);
        return rSupportVectorMachineModelType;
    }

    public static AnomalyDetectionModelType createSVMAnomalyModel() {
        AnomalyDetectionAlgoType anomalyDetectionAlgoType = new AnomalyDetectionAlgoType();
        anomalyDetectionAlgoType.setSVMSACTIVELEARNING("SVMS_AL_ENABLE");
        anomalyDetectionAlgoType.setSVMSCONVTOLERANCE(0.001);
        anomalyDetectionAlgoType.setSVMSKERNELCACHESIZE(null);
        anomalyDetectionAlgoType.setSVMSKERNELFUNCTION(null);
        anomalyDetectionAlgoType.setSVMSOUTLIERRATE(Double.valueOf(0.1));
        AnomalyDetectionModelType anomalyDetectionModelType = new AnomalyDetectionModelType();
        anomalyDetectionModelType.setAnomalyDetectionAlgo(anomalyDetectionAlgoType);
        return anomalyDetectionModelType;
    }

    public static KMeansModelType createKMeansModel(Context context) {
        Version version;
        KMeansAlgoType kMeansAlgoType = new KMeansAlgoType();
        kMeansAlgoType.setCLUSNUMCLUSTERS(BigInteger.valueOf(10L));
        kMeansAlgoType.setKMNSBLOCKGROWTH(2);
        kMeansAlgoType.setKMNSCONVTOLERANCE(0.01);
        kMeansAlgoType.setKMNSDISTANCE("KMNS_EUCLIDEAN");
        int n = 20;
        try {
            version = ConfigUtils.getDatabaseVersion(context);
            if (ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_4, version, true)) {
                n = 30;
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        kMeansAlgoType.setKMNSITERATIONS(BigInteger.valueOf(n));
        kMeansAlgoType.setKMNSMINPCTATTRSUPPORT(0.1);
        kMeansAlgoType.setKMNSNUMBINS(BigInteger.valueOf(10L));
        kMeansAlgoType.setKMNSSPLITCRITERION("KMNS_VARIANCE");
        version = new KMeansModelType();
        version.setKMeansAlgo(kMeansAlgoType);
        return version;
    }

    public static OClusterModelType createOClusterModel() {
        OClusterAlgoType oClusterAlgoType = new OClusterAlgoType();
        oClusterAlgoType.setCLUSNUMCLUSTERS(BigInteger.valueOf(10L));
        oClusterAlgoType.setOCLTMAXBUFFER(50000.0);
        oClusterAlgoType.setOCLTSENSITIVITY(0.5);
        OClusterModelType oClusterModelType = new OClusterModelType();
        oClusterModelType.setOClusterAlgo(oClusterAlgoType);
        return oClusterModelType;
    }

    public static ExpectationMaximizationModelType createEMModel() {
        ExpectationMaximizationAlgoType expectationMaximizationAlgoType = new ExpectationMaximizationAlgoType();
        expectationMaximizationAlgoType.setEMCSCLUSTERCOMPONENTS("EMCS_CLUSTER_COMP_ENABLE");
        expectationMaximizationAlgoType.setEMCSCLUSTERSTATISTICS("EMCS_CLUS_STATS_ENABLE");
        expectationMaximizationAlgoType.setEMCSCLUSTERTHRESH(Double.valueOf(2.0));
        expectationMaximizationAlgoType.setEMCSLINKAGEFUNCTION("EMCS_LINKAGE_SINGLE");
        expectationMaximizationAlgoType.setEMCSLOGLIKEIMPROVEMENT(0.001);
        expectationMaximizationAlgoType.setEMCSMAXNUMATTR2D(BigInteger.valueOf(50L));
        expectationMaximizationAlgoType.setEMCSMINPCTATTRSUPPORT(Double.valueOf(0.1));
        expectationMaximizationAlgoType.setEMCSNUMDISTRIBUTION("EMCS_NUM_DISTR_SYSTEM");
        expectationMaximizationAlgoType.setEMCSNUMEQUIWIDTHBINS(11);
        expectationMaximizationAlgoType.setEMCSNUMITERATIONS(BigInteger.valueOf(100L));
        expectationMaximizationAlgoType.setEMCSNUMPROJECTIONS(BigInteger.valueOf(50L));
        ExpectationMaximizationModelType expectationMaximizationModelType = new ExpectationMaximizationModelType();
        expectationMaximizationModelType.setExpectationMaximizationAlgo(expectationMaximizationAlgoType);
        return expectationMaximizationModelType;
    }

    public static NonNegativeMatrixFactorModelType createNMFModel() {
        NonNegativeMatrixFactorAlgoType nonNegativeMatrixFactorAlgoType = new NonNegativeMatrixFactorAlgoType();
        nonNegativeMatrixFactorAlgoType.setNMFSCONVTOLERANCE(0.05);
        nonNegativeMatrixFactorAlgoType.setNMFSNUMITERATIONS(50);
        nonNegativeMatrixFactorAlgoType.setNMFSRANDOMSEED(BigInteger.valueOf(-1L));
        NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType = new NonNegativeMatrixFactorModelType();
        nonNegativeMatrixFactorModelType.setNonNegativeMatrixFactorAlgo(nonNegativeMatrixFactorAlgoType);
        return nonNegativeMatrixFactorModelType;
    }

    public static SVDModelType createSVDModel() {
        SVDAlgoType sVDAlgoType = new SVDAlgoType();
        sVDAlgoType.setSVDSUMATRIXOUTPUT("SVDS_U_MATRIX_DISABLE");
        sVDAlgoType.setSVDSSCORINGMODE("SVDS_SCORING_SVD");
        SVDModelType sVDModelType = new SVDModelType();
        sVDModelType.setSVDAlgo(sVDAlgoType);
        return sVDModelType;
    }

    public static PCAModelType createPCAModel() {
        PCAAlgoType pCAAlgoType = new PCAAlgoType();
        pCAAlgoType.setSVDSUMATRIXOUTPUT("SVDS_U_MATRIX_DISABLE");
        pCAAlgoType.setSVDSSCORINGMODE("SVDS_SCORING_PCA");
        PCAModelType pCAModelType = new PCAModelType();
        pCAModelType.setPCAAlgo(pCAAlgoType);
        return pCAModelType;
    }

    public static AprioriModelType createAprioriModel() {
        AprioriAlgoType aprioriAlgoType = new AprioriAlgoType();
        aprioriAlgoType.setASSOMAXRULELENGTH(4);
        aprioriAlgoType.setASSOMINCONFIDENCE(0.1);
        aprioriAlgoType.setASSOMINSUPPORT(0.01);
        AprioriModelType aprioriModelType = new AprioriModelType();
        aprioriModelType.setAprioriAlgo(aprioriAlgoType);
        return aprioriModelType;
    }

    public static BigDecimal getObjectId(ModelType modelType) {
        return new BigDecimal(modelType.getId());
    }

    public static List<MiningAttributeType> getMiningAttributes(ModelType modelType) {
        InputMiningData inputMiningData = modelType.getInputMiningData();
        return inputMiningData.getMiningAttributes().getMiningAttribute();
    }

    public static MiningAttributeType findModelAttribute(MiningAttributeType miningAttributeType, ModelType modelType) {
        InputMiningData inputMiningData = modelType.getInputMiningData();
        List list = inputMiningData.getMiningAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType2 : list) {
            if (!miningAttributeType2.getName().equals(miningAttributeType.getName()) || !miningAttributeType2.getDataType().equals(miningAttributeType.getDataType())) continue;
            return miningAttributeType2;
        }
        return null;
    }

    public static MiningAttributeType findModelAttribute(AttributeType attributeType, ModelType modelType) {
        MiningAttributeType miningAttributeType = null;
        InputMiningData inputMiningData = modelType.getInputMiningData();
        List list = inputMiningData.getMiningAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType2 : list) {
            if (!miningAttributeType2.getName().equals(attributeType.getName()) || !miningAttributeType2.getDataType().equals(attributeType.getDataType())) continue;
            miningAttributeType = miningAttributeType2;
            break;
        }
        return miningAttributeType;
    }

    public static MiningAttributeType findModelAttribute(String string, ModelType modelType) {
        MiningAttributeType miningAttributeType = null;
        InputMiningData inputMiningData = modelType.getInputMiningData();
        List list = inputMiningData.getMiningAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType2 : list) {
            if (!miningAttributeType2.getName().equals(string)) continue;
            miningAttributeType = miningAttributeType2;
            break;
        }
        return miningAttributeType;
    }

    public static AttributeType getCaseId(BuildNodeType buildNodeType) {
        AttributeType attributeType = null;
        if (buildNodeType.getCaseAttributes().getAttribute().size() > 0) {
            attributeType = (AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0);
        }
        return attributeType;
    }

    public static boolean isAutomatic(ModelType modelType) {
        InputMiningData inputMiningData = modelType.getInputMiningData();
        return inputMiningData.getDataUsage().equals((Object)InputMiningDataType.AUTO);
    }

    public static boolean isAutomaticMiningType(ModelType modelType) {
        InputMiningData inputMiningData = modelType.getInputMiningData();
        return inputMiningData.getMiningUsage().equals((Object)InputMiningDataType.AUTO);
    }

    public static boolean isEqual(AttributeType attributeType, AttributeType attributeType2) {
        if (attributeType == null && attributeType2 == null) {
            return true;
        }
        if (attributeType == null || attributeType2 == null) {
            return false;
        }
        if (!attributeType.getName().equals(attributeType2.getName())) {
            return false;
        }
        if (attributeType.getAlias() != null && attributeType2.getAlias() != null && !attributeType.getAlias().equals(attributeType2.getAlias())) {
            return false;
        }
        if (!attributeType.getDataType().equals(attributeType2.getDataType())) {
            return false;
        }
        return attributeType.getDataTypeQualifier() == null || attributeType2.getDataTypeQualifier() == null || attributeType.getDataTypeQualifier().equals(attributeType2.getDataTypeQualifier());
    }

    public static boolean isEqual(CaseAttributes caseAttributes, CaseAttributes caseAttributes2) {
        List list = caseAttributes.getAttribute();
        List list2 = caseAttributes2.getAttribute();
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (MetaDataHelper.isEqual((AttributeType)list.get(i), (AttributeType)list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualTargetAndCaseID(BuildNodeType buildNodeType, BuildNodeType buildNodeType2) {
        CaseAttributes caseAttributes;
        CaseAttributes caseAttributes2;
        if (buildNodeType instanceof SuperviseBuildNodeType && !MetaDataHelper.isEqual((AttributeType)(caseAttributes2 = ((SuperviseBuildNodeType)buildNodeType).getTargetAttribute()), (AttributeType)(caseAttributes = ((SuperviseBuildNodeType)buildNodeType2).getTargetAttribute()))) {
            return false;
        }
        caseAttributes2 = buildNodeType.getCaseAttributes();
        return MetaDataHelper.isEqual(caseAttributes2, caseAttributes = buildNodeType2.getCaseAttributes());
    }

    public static boolean isEqualPartitionColumns(BuildNodeType buildNodeType, BuildNodeType buildNodeType2) {
        boolean bl = true;
        if (buildNodeType.getPartitionExpressions() != null && buildNodeType2.getPartitionExpressions() != null) {
            if (buildNodeType.getPartitionExpressions().getPartitionExpression().size() == buildNodeType2.getPartitionExpressions().getPartitionExpression().size()) {
                for (int i = 0; i < buildNodeType.getPartitionExpressions().getPartitionExpression().size(); ++i) {
                    AttributeType attributeType;
                    AttributeType attributeType2 = ((PartitionExpressionType)buildNodeType.getPartitionExpressions().getPartitionExpression().get(i)).getPartitionAttribute();
                    if (MetaDataHelper.isEqual(attributeType2, attributeType = ((PartitionExpressionType)buildNodeType2.getPartitionExpressions().getPartitionExpression().get(i)).getPartitionAttribute())) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = false;
            }
        } else {
            bl = buildNodeType.getPartitionExpressions() == null && buildNodeType2.getPartitionExpressions() == null;
        }
        if (buildNodeType.getMaxNumPartitions().compareTo(buildNodeType2.getMaxNumPartitions()) != 0) {
            bl = false;
        }
        return bl;
    }

    public static boolean isEqualAssociationSettings(BuildNodeType buildNodeType, BuildNodeType buildNodeType2) {
        assert (buildNodeType instanceof AssociationBuildNodeType);
        assert (buildNodeType2 instanceof AssociationBuildNodeType);
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)buildNodeType;
        AssociationBuildNodeType associationBuildNodeType2 = (AssociationBuildNodeType)buildNodeType2;
        if (!MetaDataHelper.isEqual(associationBuildNodeType.getItemValue(), associationBuildNodeType2.getItemValue())) {
            return false;
        }
        return MetaDataHelper.isEqual(associationBuildNodeType.getItemID(), associationBuildNodeType2.getItemID());
    }

    public static void setModelsStatus(BuildNodeType buildNodeType, Collection<ModelType> collection, ModelStatusType modelStatusType) {
        for (ModelType object : collection) {
            object.setStatus(modelStatusType);
        }
        if (buildNodeType instanceof SuperviseBuildNodeType) {
            List<? extends MiningResultType> list = MetaDataHelper.getResultsCollection((SuperviseBuildNodeType)buildNodeType, collection);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MiningResultType miningResultType = (MiningResultType)iterator.next();
                miningResultType.setStatus(modelStatusType);
            }
        }
    }

    public static void setModelsStatus(BuildNodeType buildNodeType, ModelStatusType modelStatusType) {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        MetaDataHelper.setModelsStatus(buildNodeType, list, modelStatusType);
    }

    public static void setModelsAttributeProperties(BuildNodeType buildNodeType, AttributeType attributeType, boolean bl, boolean bl2) {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        for (ModelType modelType : list) {
            MiningAttributeType miningAttributeType = MetaDataHelper.findModelAttribute(attributeType, modelType);
            if (miningAttributeType == null) continue;
            miningAttributeType.setAutoPrep(bl2 ? INPUT : IGNORE);
            miningAttributeType.setInput(bl ? INPUT : IGNORE);
        }
    }

    public static void setModelAttributeProperties(ModelType modelType, AttributeType attributeType, boolean bl, boolean bl2) {
        MiningAttributeType miningAttributeType = MetaDataHelper.findModelAttribute(attributeType, modelType);
        if (miningAttributeType != null) {
            miningAttributeType.setAutoPrep(bl2 ? INPUT : IGNORE);
            miningAttributeType.setInput(bl ? INPUT : IGNORE);
        }
    }

    public static void setModelsTargetPropertiesWithDefaults(BuildNodeType buildNodeType, AttributeType attributeType) {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        for (ModelType modelType : list) {
            MetaDataHelper.setModelTargetPropertiesWithDefaults(buildNodeType, modelType, attributeType);
        }
    }

    public static void setModelTargetPropertiesWithDefaults(BuildNodeType buildNodeType, ModelType modelType, AttributeType attributeType) {
        boolean bl = MetaDataHelper.isTargetAdpAllowed(buildNodeType, modelType);
        boolean bl2 = MetaDataHelper.isTargetInputAllowed(modelType);
        if (attributeType != null) {
            MetaDataHelper.setModelAttributeProperties(modelType, attributeType, bl2, bl);
        }
    }

    public static void replaceAttributeInModel(List list, MiningAttributeType miningAttributeType) {
        if (list == null || list.size() == 0 || !(list.get(0) instanceof ModelType)) {
            return;
        }
        try {
            List list2 = list;
            block2: for (ModelType modelType : list2) {
                MiningAttributes miningAttributes = modelType.getInputMiningData().getMiningAttributes();
                for (MiningAttributeType miningAttributeType2 : miningAttributes.getMiningAttribute()) {
                    if (!miningAttributeType2.getName().equals(miningAttributeType.getName())) continue;
                    MetaDataHelper.copyMiningAttributeType(miningAttributeType, miningAttributeType2, true);
                    continue block2;
                }
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public static void copyMiningAttributeType(MiningAttributeType miningAttributeType, MiningAttributeType miningAttributeType2, boolean bl) {
        miningAttributeType2.setDataType(miningAttributeType.getDataType());
        miningAttributeType2.setDataTypeQualifier(miningAttributeType.getDataTypeQualifier());
        if (bl) {
            miningAttributeType2.setInput(miningAttributeType.getInput());
            miningAttributeType2.setAutoPrep(miningAttributeType.getAutoPrep());
        }
        miningAttributeType2.setMiningType(miningAttributeType.getMiningType());
    }

    public static void setModelTargetPropertiesWithDefaultsFromModel(BuildNodeType buildNodeType, ModelType modelType) {
        if (modelType == null || modelType.getInputMiningData() == null || modelType.getInputMiningData().getMiningAttributes() == null) {
            return;
        }
        MiningAttributes miningAttributes = buildNodeType.getMiningAttributes();
        List list = modelType.getInputMiningData().getMiningAttributes().getMiningAttribute();
        block0: for (MiningAttributeType miningAttributeType : miningAttributes.getMiningAttribute()) {
            for (MiningAttributeType miningAttributeType2 : list) {
                if (!miningAttributeType2.getName().equals(miningAttributeType.getName())) continue;
                MetaDataHelper.copyMiningAttributeType(miningAttributeType, miningAttributeType2, true);
                continue block0;
            }
        }
    }

    public static void disableInvalidInputsInModel(ModelType modelType) {
        if (modelType == null || modelType.getInputMiningData() == null || modelType.getInputMiningData().getMiningAttributes() == null) {
            return;
        }
        if (modelType instanceof OClusterModelType) {
            MetaDataHelper.disableInputsWithMiningType(modelType.getInputMiningData().getMiningAttributes().getMiningAttribute(), "Text");
        } else if (modelType instanceof PCAModelType || modelType instanceof SVDModelType) {
            MetaDataHelper.disableInputsWithMiningAndDataType(modelType, "Categorical", "CHAR");
            MetaDataHelper.disableInputsWithMiningAndDataType(modelType, "Categorical", "VARCHAR2");
        }
    }

    public static void disableInputsWithMiningType(List<MiningAttributeType> list, String string) {
        if (list == null) {
            return;
        }
        for (MiningAttributeType miningAttributeType : list) {
            if (!miningAttributeType.getMiningType().equals(string)) continue;
            miningAttributeType.setInput(IGNORE);
        }
    }

    public static void disableModelInputsWithMiningType(List<OClusterModelType> list, String string) {
        if (list == null) {
            return;
        }
        for (ModelType modelType : list) {
            for (MiningAttributeType miningAttributeType : modelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                if (!miningAttributeType.getMiningType().equals(string)) continue;
                miningAttributeType.setInput(IGNORE);
            }
        }
    }

    public static void disableInputsWithMiningAndDataType(ModelType modelType, String string, String string2) {
        if (modelType == null) {
            return;
        }
        for (MiningAttributeType miningAttributeType : modelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
            if (!miningAttributeType.getMiningType().equals(string) || !miningAttributeType.getDataType().equals(string2)) continue;
            miningAttributeType.setInput(IGNORE);
        }
    }

    public static void setModelCaseIDsPropertiesWithDefaults(BuildNodeType buildNodeType, ModelType modelType, List<AttributeType> list) {
        boolean bl = MetaDataHelper.isTargetAdpAllowed(buildNodeType, modelType);
        boolean bl2 = MetaDataHelper.isCaseIdInputAllowed(modelType);
        for (AttributeType attributeType : list) {
            MetaDataHelper.setModelAttributeProperties(modelType, attributeType, bl2, bl);
        }
    }

    public static boolean isTargetAdpAllowed(BuildNodeType buildNodeType, ModelType modelType) {
        return buildNodeType instanceof RegressionBuildNodeType && (modelType instanceof RSupportVectorMachineModelType || modelType instanceof RGeneralizedLinearModelType) || buildNodeType instanceof ClassificationBuildNodeType;
    }

    public static boolean isTargetInputAllowed(ModelType modelType) {
        return true;
    }

    public static boolean isCaseIdInputAllowed(ModelType modelType) {
        return false;
    }

    public static boolean isCaseIdAdpAllowed(ModelType modelType) {
        return false;
    }

    public static boolean isCaseAttribute(AttributeType attributeType, CaseAttributes caseAttributes) {
        boolean bl = false;
        List list = caseAttributes.getAttribute();
        for (AttributeType attributeType2 : list) {
            if (!MetaDataHelper.isEqual(attributeType2, attributeType)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getFunctionName(MiningFunctionType miningFunctionType) {
        if (miningFunctionType == MiningFunctionType.ASSOCIATION) {
            return ServerConstants.MiningFunction.getUIFunctionName("ASSOCIATION");
        }
        if (miningFunctionType == MiningFunctionType.CLASSIFICATION) {
            return ServerConstants.MiningFunction.getUIFunctionName("CLASSIFICATION");
        }
        if (miningFunctionType == MiningFunctionType.CLUSTERING) {
            return ServerConstants.MiningFunction.getUIFunctionName("CLUSTERING");
        }
        if (miningFunctionType == MiningFunctionType.FEATURE_EXTRACTION) {
            return ServerConstants.MiningFunction.getUIFunctionName("FEATURE_EXTRACTION");
        }
        if (miningFunctionType == MiningFunctionType.REGRESSION) {
            return ServerConstants.MiningFunction.getUIFunctionName("REGRESSION");
        }
        if (miningFunctionType == MiningFunctionType.ANOMALY_DETECTION) {
            return ServerConstants.MiningFunction.getUIFunctionName("ANOMALY_DETECTION");
        }
        return null;
    }

    public static String getAlgorithmName(MiningAlgorithmType miningAlgorithmType) {
        if (miningAlgorithmType == MiningAlgorithmType.NAIVE_BAYES) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_NAIVE_BAYES");
        }
        if (miningAlgorithmType == MiningAlgorithmType.DECISION_TREE) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_DECISION_TREE");
        }
        if (miningAlgorithmType == MiningAlgorithmType.SUPPORT_VECTOR_MACHINES) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (miningAlgorithmType == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        if (miningAlgorithmType == MiningAlgorithmType.APRIORI_ASSOCIATION_RULES) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_APRIORI_ASSOCIATION_RULES");
        }
        if (miningAlgorithmType == MiningAlgorithmType.KMEANS) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_KMEANS");
        }
        if (miningAlgorithmType == MiningAlgorithmType.O_CLUSTER) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_O_CLUSTER");
        }
        if (miningAlgorithmType == MiningAlgorithmType.EXPECTATION_MAXIMIZATION) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_EXPECTATION_MAXIMIZATION");
        }
        if (miningAlgorithmType == MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_NONNEGATIVE_MATRIX_FACTOR");
        }
        if (miningAlgorithmType == MiningAlgorithmType.SINGULAR_VALUE_DECOMP) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_SINGULAR_VALUE_DECOMP");
        }
        if (miningAlgorithmType == MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_PRINCIPAL_COMPONENT_ANALYSIS");
        }
        return null;
    }

    public static String getAlgorithmName(ModelType modelType) {
        if (modelType instanceof NaiveBayesModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_NAIVE_BAYES");
        }
        if (modelType instanceof DecisionTreeModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_DECISION_TREE");
        }
        if (modelType instanceof CSupportVectorMachineModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (modelType instanceof CGeneralizedLinearModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        if (modelType instanceof RGeneralizedLinearModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        if (modelType instanceof RSupportVectorMachineModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (modelType instanceof KMeansModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_KMEANS");
        }
        if (modelType instanceof OClusterModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_O_CLUSTER");
        }
        if (modelType instanceof ExpectationMaximizationModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_EXPECTATION_MAXIMIZATION");
        }
        if (modelType instanceof AprioriModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_APRIORI_ASSOCIATION_RULES");
        }
        if (modelType instanceof AnomalyDetectionModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (modelType instanceof NonNegativeMatrixFactorModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_NONNEGATIVE_MATRIX_FACTOR");
        }
        if (modelType instanceof SVDModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_SINGULAR_VALUE_DECOMP");
        }
        if (modelType instanceof PCAModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_PRINCIPAL_COMPONENT_ANALYSIS");
        }
        return null;
    }

    public static String getAlgorithmType(ModelType modelType) {
        if (modelType instanceof NaiveBayesModelType) {
            return "ALGO_NAIVE_BAYES";
        }
        if (modelType instanceof DecisionTreeModelType) {
            return "ALGO_DECISION_TREE";
        }
        if (modelType instanceof CSupportVectorMachineModelType) {
            return "ALGO_SUPPORT_VECTOR_MACHINES";
        }
        if (modelType instanceof CGeneralizedLinearModelType) {
            return "ALGO_GENERALIZED_LINEAR_MODEL";
        }
        if (modelType instanceof RGeneralizedLinearModelType) {
            return "ALGO_GENERALIZED_LINEAR_MODEL";
        }
        if (modelType instanceof RSupportVectorMachineModelType) {
            return "ALGO_SUPPORT_VECTOR_MACHINES";
        }
        if (modelType instanceof KMeansModelType) {
            return "ALGO_KMEANS";
        }
        if (modelType instanceof OClusterModelType) {
            return "ALGO_O_CLUSTER";
        }
        if (modelType instanceof ExpectationMaximizationModelType) {
            return "ALGO_EXPECTATION_MAXIMIZATION";
        }
        if (modelType instanceof AprioriModelType) {
            return "ALGO_APRIORI_ASSOCIATION_RULES";
        }
        if (modelType instanceof AnomalyDetectionModelType) {
            return "ALGO_SUPPORT_VECTOR_MACHINES";
        }
        if (modelType instanceof NonNegativeMatrixFactorModelType) {
            return "ALGO_NONNEGATIVE_MATRIX_FACTOR";
        }
        if (modelType instanceof SVDModelType) {
            return "ALGO_SINGULAR_VALUE_DECOMP";
        }
        if (modelType instanceof PCAModelType) {
            return "ALGO_PRINCIPAL_COMPONENT_ANALYSIS";
        }
        return null;
    }

    public static MiningAttributes copyMiningAttributes(MiningAttributes miningAttributes) {
        MiningAttributes miningAttributes2 = new MiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        List list2 = miningAttributes2.getMiningAttribute();
        for (MiningAttributeType miningAttributeType : list) {
            MiningAttributeType miningAttributeType2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(miningAttributeType);
            list2.add(miningAttributeType2);
        }
        miningAttributes2.setAutoSpec(miningAttributes.getAutoSpec());
        return miningAttributes2;
    }

    public static CaseAttributes copyCaseAttributes(CaseAttributes caseAttributes) {
        CaseAttributes caseAttributes2 = new CaseAttributes();
        List list = caseAttributes.getAttribute();
        List list2 = caseAttributes2.getAttribute();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            list2.add(attributeType2);
        }
        return caseAttributes2;
    }

    public static BuildDataSource copyBuildDataSource(BuildDataSource buildDataSource) {
        BuildDataSource buildDataSource2 = new BuildDataSource();
        buildDataSource2.setSourceId(buildDataSource.getSourceId());
        return buildDataSource2;
    }

    public static CacheSettings copyCacheSettings(CacheSettings cacheSettings) {
        CacheSettings cacheSettings2 = new CacheSettings();
        cacheSettings2.setNumberOfRows(cacheSettings.getNumberOfRows());
        cacheSettings2.setPercentOfTotal(cacheSettings.getPercentOfTotal());
        CacheSettings.Method method = cacheSettings.getMethod();
        CacheSettings.Method method2 = new CacheSettings.Method();
        if (null != method.getRandom()) {
            CacheSettings.Method.Random random = new CacheSettings.Method.Random();
            random.setSeed(method.getRandom().getSeed());
            method2.setRandom(random);
        } else if (null != method.getStratified()) {
            CacheSettings.Method.Stratified stratified = new CacheSettings.Method.Stratified();
            stratified.setTargetAttr(method.getStratified().getTargetAttr());
            method2.setStratified(stratified);
        } else if (null != method.getTopN()) {
            CacheSettings.Method.TopN topN = new CacheSettings.Method.TopN();
            method2.setTopN(topN);
        }
        cacheSettings2.setMethod(method2);
        cacheSettings2.setGenerateCache(cacheSettings.isGenerateCache());
        cacheSettings2.setUseFullData(Boolean.valueOf(cacheSettings.isUseFullData()));
        cacheSettings2.setOutputTable(cacheSettings.getOutputTable());
        return cacheSettings2;
    }

    public static GraphSettings copyGraphSettings(GraphSettings graphSettings) {
        GraphSettings graphSettings2 = new GraphSettings();
        List list = graphSettings2.getGraphSetting();
        for (GraphSettingsType graphSettingsType : graphSettings.getGraphSetting()) {
            GraphSettingsType graphSettingsType2 = (GraphSettingsType)MetaDataHelper.copyMetadataObject(graphSettingsType);
            list.add(graphSettingsType2);
        }
        return graphSettings2;
    }

    public static TestDataSource copyTestDataSource(TestDataSource testDataSource) {
        TestDataSource testDataSource2 = new TestDataSource();
        testDataSource2.setBuildData(testDataSource.getBuildData());
        testDataSource2.setNone(testDataSource.getNone());
        testDataSource2.setSplitData(MetaDataHelper.copySplitData(testDataSource.getSplitData()));
        testDataSource2.setTestData(MetaDataHelper.copyTestData(testDataSource.getTestData()));
        return testDataSource2;
    }

    private static TestDataSource.TestData copyTestData(TestDataSource.TestData testData) {
        if (testData == null) {
            return null;
        }
        TestDataSource.TestData testData2 = new TestDataSource.TestData();
        testData2.setSourceId(testData.getSourceId());
        return testData2;
    }

    private static TestDataSource.SplitData copySplitData(TestDataSource.SplitData splitData) {
        if (splitData == null) {
            return null;
        }
        TestDataSource.SplitData splitData2 = new TestDataSource.SplitData();
        splitData2.setTestPercent(splitData.getTestPercent());
        return splitData2;
    }

    public static MiningAttributeType createMiningAttributeFrom(AttributeType attributeType) {
        MiningAttributeType miningAttributeType = new MiningAttributeType();
        miningAttributeType.setName(attributeType.getName());
        miningAttributeType.setAlias(attributeType.getAlias());
        miningAttributeType.setAutoPrep(attributeType instanceof MiningAttributeType ? ((MiningAttributeType)attributeType).getAutoPrep() : INPUT);
        miningAttributeType.setInput(attributeType instanceof MiningAttributeType ? ((MiningAttributeType)attributeType).getInput() : (attributeType.getDataTypeQualifier() != null && attributeType.getDataTypeQualifier().equalsIgnoreCase("JSON") ? IGNORE : INPUT));
        miningAttributeType.setDataType(attributeType.getDataType());
        miningAttributeType.setDataTypeQualifier(attributeType.getDataTypeQualifier());
        miningAttributeType.setStatus(attributeType.getStatus());
        miningAttributeType.setMiningType(DatabaseMetadataUtils.getDefaultMiningType(attributeType.getDataType()));
        return miningAttributeType;
    }

    public static AttributeType createAttributeFrom(MiningAttributeType miningAttributeType) {
        AttributeType attributeType = new AttributeType();
        attributeType.setDataType(miningAttributeType.getDataType());
        attributeType.setDataTypeQualifier(miningAttributeType.getDataTypeQualifier());
        attributeType.setName(miningAttributeType.getName());
        attributeType.setStatus(miningAttributeType.getStatus());
        return attributeType;
    }

    public static Object copyMetadataObject(Object object) {
        Marshaller marshaller;
        StringWriter stringWriter;
        if (object == null) {
            return null;
        }
        Object object2 = null;
        try {
            stringWriter = new StringWriter();
            marshaller = Workflow.createMarshaller();
            marshaller.marshal((Object)new JAXBElement(new QName(" ", "local"), Object.class, object), (Writer)stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            String string = stringBuffer.toString();
            StringReader stringReader = new StringReader(string);
            Unmarshaller unmarshaller = Workflow.createUnmarshaller();
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((Source)new StreamSource(stringReader));
            object2 = jAXBElement.getValue();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (object2 instanceof ModelType) {
            ((ModelType)object2).setStatus(ModelStatusType.READY);
        }
        if (object2 instanceof ClassificationModelType && (marshaller = (stringWriter = (ClassificationModelType)object2).getPerformance().getBalanced()) != null) {
            marshaller.setWeightsTable(null);
        }
        return object2;
    }

    public static ModelNodeType.Models.Model findModelByName(ModelNodeType modelNodeType, String string) {
        List list = modelNodeType.getModels().getModel();
        ModelNodeType.Models.Model model = null;
        for (ModelNodeType.Models.Model model2 : list) {
            String string2 = model2.getSchema() + "." + model2.getName();
            if (!string2.equals(string)) continue;
            model = model2;
            break;
        }
        return model;
    }

    public static ModelType findModelById(BuildNodeType buildNodeType, String string) {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        ModelType modelType = null;
        for (ModelType modelType2 : list) {
            if (!modelType2.getId().equals(string)) continue;
            modelType = modelType2;
            break;
        }
        return modelType;
    }

    public static ModelType findModelByName(BuildNodeType buildNodeType, String string) {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        ModelType modelType = null;
        for (ModelType modelType2 : list) {
            if (!modelType2.getName().equals(string)) continue;
            modelType = modelType2;
            break;
        }
        return modelType;
    }

    public static RefModelType getModelRefFromId(BuildNodeType buildNodeType, String string, Context context) throws Exception {
        RefModelType refModelType = null;
        String string2 = ConnectionFolder.getUserAccountName(context);
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        for (ModelType modelType : list) {
            if (!modelType.getId().equals(string)) continue;
            refModelType = MetaDataHelper.createRefModelType(modelType, MetaDataHelper.getMiningFunctionType(buildNodeType), string2, buildNodeType.getId());
            break;
        }
        return refModelType;
    }

    public static MiningResultType findResultById(SuperviseBuildNodeType superviseBuildNodeType, String string) {
        List<? extends MiningResultType> list = MetaDataHelper.getResultsCollection(superviseBuildNodeType);
        MiningResultType miningResultType = null;
        for (MiningResultType miningResultType2 : list) {
            if (!miningResultType2.getModelId().equals(string)) continue;
            miningResultType = miningResultType2;
            break;
        }
        return miningResultType;
    }

    public static Map<String, String> getHeuristicsRules(BuildNodeType buildNodeType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (buildNodeType == null || buildNodeType.getHeuristicSummaryResult() == null) {
            return hashMap;
        }
        for (HeuristicSummaryResultType.Attribute attribute : buildNodeType.getHeuristicSummaryResult().getAttribute()) {
            boolean bl = true;
            StringBuilder stringBuilder = new StringBuilder();
            for (HeuristicSummaryResultType.Attribute.Reason reason : attribute.getReason()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                switch (reason.getType()) {
                    case INPUT_NONE: {
                        stringBuilder.append(BuildEditorLrb.get("HEURISTIC_DETAILS_NODE_INPUT_NONE"));
                        break;
                    }
                    case INPUT_SOME: {
                        stringBuilder.append(BuildEditorLrb.get("HEURISTIC_DETAILS_NODE_INPUT_SOME"));
                        break;
                    }
                    case NUM_TO_CAT_MINING_TYPE: {
                        stringBuilder.append(BuildEditorLrb.get("HEURISTIC_DETAILS_NODE_NUM_TO_CAT_MINING_TYPE"));
                        break;
                    }
                    case CHAR_TO_TEXT_MINING_TYPE: {
                        stringBuilder.append(BuildEditorLrb.get("HEURISTIC_DETAILS_NODE_CHAR_TO_TEXT_MINING_TYPE"));
                    }
                }
            }
            hashMap.put(attribute.getName(), stringBuilder.toString());
        }
        return hashMap;
    }

    public static Map<String, ModelHeuristicRules> getHeuristicsRulesModels(Context context, BuildNodeType buildNodeType) {
        if (buildNodeType == null || buildNodeType.getHeuristicSummaryResult() == null) {
            return new HashMap<String, ModelHeuristicRules>();
        }
        int n = 0;
        if (buildNodeType.getTextSettings() != null) {
            n = buildNodeType.getTextSettings().getCategoricalCutOffValue();
        }
        String string = buildNodeType.getHeuristicSummaryResult().getStatisticTable();
        HashMap<Object, HeuristicResultType> hashMap = new HashMap<Object, HeuristicResultType>();
        for (ModelType modelType : MetaDataHelper.getModelsCollection(buildNodeType)) {
            hashMap.put(modelType, modelType.getInputMiningData().getHeuristicResult());
        }
        return MetaDataHelper.getHeuristicsRulesModels(context, string, hashMap, n);
    }

    public static Map<String, ModelHeuristicRules> getHeuristicsRulesModels(Context context, DynamicNode dynamicNode) {
        String string = null;
        HeuristicResultType heuristicResultType = dynamicNode.getDynamicNodeBaseSettingsType().getHeuristicResult();
        if (heuristicResultType == null) {
            return new HashMap<String, ModelHeuristicRules>();
        }
        string = heuristicResultType.getStatisticTable();
        HashMap<Object, HeuristicResultType> hashMap = new HashMap<Object, HeuristicResultType>();
        hashMap.put(dynamicNode, heuristicResultType);
        return MetaDataHelper.getHeuristicsRulesModels(context, string, hashMap, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ModelHeuristicRules> getHeuristicsRulesModels(Context context, String string, Map<Object, HeuristicResultType> map, int n) {
        Serializable serializable;
        Object object;
        Object object2;
        HashMap<String, ModelHeuristicRules> hashMap = new HashMap<String, ModelHeuristicRules>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        HashMap<Object, Object[]> hashMap2 = new HashMap<Object, Object[]>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(MessageFormat.format(STATISTICS_QUERY, string));
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString(ATTRIBUTE_NAME);
                if (CUTOFF_FOR_NUMBER_FOR_CAT.equals(string2)) {
                    n2 = sQLHelper.rs.getInt(CUSTOM);
                    continue;
                }
                if (MAX_DISTINCT_CAT_CUTOFF.equals(string2)) {
                    n3 = sQLHelper.rs.getInt(CUSTOM);
                    continue;
                }
                if (PERCENT_UNI_THRESHOLD_CAT.equals(string2)) {
                    n4 = sQLHelper.rs.getInt(CUSTOM);
                    continue;
                }
                String object3 = sQLHelper.rs.getString(DATA_TYPE);
                Integer n5 = sQLHelper.rs.getInt("DISTINCT_CNT");
                object2 = sQLHelper.rs.getInt(MAX_LENGTH);
                object = sQLHelper.rs.getInt("DISTINCT_CNT");
                serializable = Double.valueOf(sQLHelper.rs.getDouble(CATEGORICAL_PERCENT));
                hashMap2.put(string2, new Object[]{object3, n5, object2, object, serializable});
            }
        }
        for (Map.Entry<Object, HeuristicResultType> entry : map.entrySet()) {
            int n6 = 0;
            object2 = entry.getKey();
            object = new ModelHeuristicRules();
            serializable = new HashMap<String, String>();
            if (entry.getValue() == null) continue;
            for (HeuristicResultType.Attribute attribute : entry.getValue().getAttribute()) {
                Object[] objectArray = (Object[])hashMap2.get(attribute.getName());
                String string2 = objectArray[0].toString();
                Integer n7 = (Integer)objectArray[1];
                Integer n8 = (Integer)objectArray[2];
                Integer n9 = (Integer)objectArray[3];
                Double d = (Double)objectArray[4];
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = true;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                for (HeuristicResultType.Attribute.Reason reason : attribute.getReason()) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    switch (reason.getType()) {
                        case NUM_TO_CAT_MINING_TYPE: {
                            stringBuilder.append(MessageFormat.format(BuildEditorLrb.get("HEURISTIC_DETAILS_NUM_TO_CAT_MINING_TYPE"), n7, n2));
                            bl3 = true;
                            break;
                        }
                        case CHAR_TO_TEXT_MINING_TYPE: {
                            if (string2.equals("CLOB") || string2.equals("BLOB") || string2.equals("BFILE")) {
                                stringBuilder.append(MessageFormat.format(BuildEditorLrb.get("HEURISTIC_DETAILS_CLOB_TO_TEXT_MINING_TYPE"), string2));
                            } else {
                                stringBuilder.append(MessageFormat.format(BuildEditorLrb.get("HEURISTIC_DETAILS_CHAR_TO_TEXT_MINING_TYPE"), n8, n));
                            }
                            bl4 = true;
                            break;
                        }
                        case NULL_LIMIT: {
                            stringBuilder.append(BuildEditorLrb.get("HEURISTIC_DETAILS_NULL_LIMIT"));
                            if (bl2) break;
                            ++n6;
                            bl2 = true;
                            break;
                        }
                        case CONSTANT_LIMIT: {
                            stringBuilder.append(BuildEditorLrb.get("HEURISTIC_DETAILS_CONSTANT_LIMIT"));
                            if (bl2) break;
                            ++n6;
                            bl2 = true;
                            break;
                        }
                        case CAT_UNIQUE_COUNT_LIMIT: {
                            stringBuilder.append(MessageFormat.format(BuildEditorLrb.get("HEURISTIC_DETAILS_CAT_UNIQUE_COUNT_LIMIT"), n9, n3));
                            if (bl2) break;
                            ++n6;
                            bl2 = true;
                            break;
                        }
                        case CAT_UNIQUE_PERCENT_LIMIT: {
                            stringBuilder.append(MessageFormat.format(BuildEditorLrb.get("HEURISTIC_DETAILS_CAT_UNIQUE_PERCENT_LIMIT"), d, n4));
                            if (bl2) break;
                            ++n6;
                            bl2 = true;
                            break;
                        }
                        case DATA_TYPE_NOT_SUPPORT: {
                            if (bl3 && (object2 instanceof PCAModelType || object2 instanceof SVDModelType)) {
                                stringBuilder.append(BuildEditorLrb.get("HEURISTIC_DETAILS_VARCHAR2_DATA_TYPE_NOT_SUPPORT"));
                            } else if (bl4 && object2 instanceof OClusterModelType) {
                                stringBuilder.append(BuildEditorLrb.get("HEURISTIC_DETAILS_NESTED_NUM_DATA_TYPE_NOT_SUPPORT"));
                            } else {
                                stringBuilder.append(MessageFormat.format(BuildEditorLrb.get("HEURISTIC_DETAILS_DATA_TYPE_NOT_SUPPORT"), string2));
                            }
                            if (bl2) break;
                            ++n6;
                            bl2 = true;
                            break;
                        }
                    }
                }
                serializable.put((String)attribute.getName(), (String)stringBuilder.toString());
            }
            ((ModelHeuristicRules)object).countExcluded = n6;
            ((ModelHeuristicRules)object).modelRules = serializable;
            if (object2 instanceof ModelType) {
                hashMap.put(((ModelType)object2).getName(), (ModelHeuristicRules)object);
                continue;
            }
            if (!(object2 instanceof DynamicNode)) continue;
            hashMap.put(((DynamicNode)object2).getDefaultName(), (ModelHeuristicRules)object);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataGuideType getDataGuide(Context context, String string) {
        DataGuideType dataGuideType = null;
        String string2 = "SELECT PATH, TYPE FROM \"{0}\"";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(MessageFormat.format(string2, string));
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            dataGuideType = new DataGuideType();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString("PATH");
                String string4 = sQLHelper.rs.getString("TYPE");
                DataGuideType.Item item = new DataGuideType.Item();
                item.setPath(string3);
                item.setType(string4);
                dataGuideType.getItem().add(item);
            }
        }
        return dataGuideType;
    }
}

