/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.sql.ZONEIDMAP;

public class TimeUtils {
    private static final Logger theLogger = Logger.getLogger(TimeUtils.class.getName());
    public static final String GMT = UtilsLrb.get("GMT");
    private static final String NO_ZONE_FORMAT_SHORT = "yyyy-MM-dd HH:mm:ss";
    private static final String NO_ZONE_FORMAT_SHORT_RFC = "dd.MM.yyyy HH:mm:ss";
    private static final String NO_ZONE_FORMAT = "dd.MM.yyyy HH:mm:ss.SSSSSSSSS";
    private static final String ZONE_FORMAT_SHORT_GMT = "yyyy-MM-dd HH:mm:ss z";
    private static final String ZONE_FORMAT_SHORT_RFC = "dd.MM.yyyy HH:mm:ss z";
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;
    private static HashMap<String, TimeZone> _mapStringToTimeZone;
    private static Vector<String> _timezone_strings;

    public static SimpleDateFormat getShortSimpleDateFormat() {
        return new SimpleDateFormat(NO_ZONE_FORMAT_SHORT, Locale.getDefault());
    }

    public static SimpleDateFormat getShortSimpleDateFormatRFC() {
        return new SimpleDateFormat(NO_ZONE_FORMAT_SHORT, Locale.getDefault());
    }

    public static SimpleDateFormat getShortSimpleDateFormatZone() {
        return new SimpleDateFormat(ZONE_FORMAT_SHORT_GMT, Locale.getDefault());
    }

    public static SimpleDateFormat getShortSimpleDateFormatZoneRFCTZ() {
        return new SimpleDateFormat(ZONE_FORMAT_SHORT_RFC, Locale.getDefault());
    }

    public static SimpleDateFormat getShortSimpleDateFormatZoneRFC2() {
        return new SimpleDateFormat(NO_ZONE_FORMAT_SHORT_RFC, Locale.getDefault());
    }

    public static SimpleDateFormat getExplorerNodeFormatTimestampTimeZone() {
        return new SimpleDateFormat("yy-MMM-dd HH:mm:ss.SSSSSS a z", Locale.getDefault());
    }

    public static SimpleDateFormat getExplorerNodeTimestampFormat() {
        return new SimpleDateFormat("yy-MMM-dd HH:mm:ss.SSSSSS a", Locale.getDefault());
    }

    public static SimpleDateFormat getExplorerNodeDateFormat() {
        return new SimpleDateFormat("yy-MMM-dd", Locale.getDefault());
    }

    public static String getTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        return DateFormat.getInstance().format(calendar.getTime());
    }

    public static java.util.Date toDate1(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n, n + 5);
        String string4 = string.substring(n);
        n = string4.indexOf(" ");
        string4 = string4.substring(n);
        string4 = string4.replace(":", "");
        string = string2 + string3 + string4;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(NO_ZONE_FORMAT, Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        java.util.Date date = simpleDateFormat.parse(string, parsePosition);
        return date;
    }

    public static java.util.Date toDate2(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n, n + 5);
        String string4 = string.substring(n);
        n = string4.indexOf(" ");
        string4 = string4.substring(n);
        string4 = string4.replace(":", "");
        string = string2 + string3 + string4;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy hh.mm.ss.SSSSSSSSS a Z");
        ParsePosition parsePosition = new ParsePosition(0);
        java.util.Date date = simpleDateFormat.parse(string, parsePosition);
        return date;
    }

    public static String formatDate(XMLGregorianCalendar xMLGregorianCalendar) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        java.util.Date date = xMLGregorianCalendar.toGregorianCalendar().getTime();
        Date date2 = new Date(date.getTime());
        return dateFormat.format(date2);
    }

    public static XMLGregorianCalendar Date2XMLDate(Calendar calendar) {
        XMLGregorianCalendar xMLGregorianCalendar = null;
        try {
            xMLGregorianCalendar = TimeUtils.long2Gregorian(calendar);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            xMLGregorianCalendar = null;
        }
        return xMLGregorianCalendar;
    }

    private static XMLGregorianCalendar long2Gregorian(Calendar calendar) {
        DatatypeFactory datatypeFactory;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(datatypeConfigurationException);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(calendar.getTimeInMillis());
        gregorianCalendar.setTimeZone(calendar.getTimeZone());
        return datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
    }

    public static XMLGregorianCalendar SimpleDate2XMLDate(Calendar calendar, boolean bl) {
        XMLGregorianCalendar xMLGregorianCalendar = null;
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.clear();
            gregorianCalendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(10), calendar.get(12), calendar.get(13));
            xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            if (!bl) {
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
            }
            xMLGregorianCalendar.setFractionalSecond(null);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            xMLGregorianCalendar = null;
        }
        return xMLGregorianCalendar;
    }

    public static String getRegionName(byte[] byArray) {
        String string;
        if ((byArray[11] & REGIONIDBIT) != 0) {
            int n = TimeUtils.getHighOrderbits(byArray[11]);
            string = ZONEIDMAP.getRegion((int)(n += TimeUtils.getLowOrderbits(byArray[12])));
        } else {
            int n = byArray[11] - OFFSET_HOUR;
            int n2 = byArray[12] - OFFSET_MINUTE;
            StringBuffer stringBuffer = new StringBuffer(n < 0 ? "-" : "+");
            if (Math.abs(n) < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Math.abs(n));
            stringBuffer.append(":");
            string = stringBuffer.toString();
            string = n2 == 0 ? string + "00" : string + "" + n2;
        }
        return string;
    }

    private static int getHighOrderbits(int n) {
        return (n & 0x7F) << 6;
    }

    private static int getLowOrderbits(int n) {
        return (n & 0xFC) >> 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getTimeZoneStrings() {
        if (_timezone_strings != null) return _timezone_strings.toArray(new String[_timezone_strings.size()]);
        Class<TimeUtils> clazz = TimeUtils.class;
        synchronized (TimeUtils.class) {
            if (_timezone_strings != null) return _timezone_strings.toArray(new String[_timezone_strings.size()]);
            _timezone_strings = new Vector();
            _mapStringToTimeZone = new HashMap();
            boolean bl = false;
            for (int i = -12; i <= 14; ++i) {
                String string = GMT + (i < 0 ? "-" : "+") + Math.abs(i);
                TimeZone timeZone = TimeZone.getTimeZone(string);
                String string2 = timeZone.getID();
                _mapStringToTimeZone.put(string2, timeZone);
                _timezone_strings.add(string2);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _timezone_strings.toArray(new String[_timezone_strings.size()]);
        }
    }

    public static TimeZone toTimeZone(String string) {
        if (_mapStringToTimeZone == null) {
            TimeUtils.getTimeZoneStrings();
        }
        TimeZone timeZone = _mapStringToTimeZone.get(string);
        return timeZone;
    }

    public static TimeZone toTimeZoneFromZoneId(String string) {
        if (_mapStringToTimeZone == null) {
            TimeUtils.getTimeZoneStrings();
        }
        TimeZone timeZone = _mapStringToTimeZone.get(string);
        return timeZone;
    }

    public static String removeGMT(String string) {
        int n = string.indexOf(GMT);
        if (-1 == n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
        stringBuffer.append(string.substring(n + 3));
        return stringBuffer.toString();
    }
}

