/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.MessageDialog;

public class CommentValidator {
    private static final Logger theLogger = Logger.getLogger(CommentValidator.class.getName());
    private static int MAX_LENGTH = 4000;

    public static boolean validateComment(String string, Context context, boolean bl) {
        if (string == null) {
            return true;
        }
        if (string.length() > MAX_LENGTH && bl) {
            String string2 = MessageFormat.format(UtilsLrb.get("COMMENT_ERROR_NAME_TOO_LONG"), MAX_LENGTH);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)UtilsLrb.get("COMMENT_ERROR_TITLE"), null);
            return false;
        }
        if (StringUtils.hasMultibyteCharactes(string) && !CommentValidator.isCommentLengthValidInDB(string, context, bl)) {
            String string3 = MessageFormat.format(UtilsLrb.get("COMMENT_ERROR_NAME_TOO_LONG_FOR_DB"), MAX_LENGTH);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)UtilsLrb.get("COMMENT_ERROR_TITLE"), null);
            return false;
        }
        return true;
    }

    private static boolean executeCommentLengthValidInDB(String string, Context context, boolean bl) {
        boolean bl2 = false;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        bl2 = StringUtils.checkStringDBLengthMax(string, connectionFolder, MAX_LENGTH);
        if (!bl2 && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("NAME_ERROR_TITLE"), null);
        }
        return bl2;
    }

    public static boolean isCommentLengthValidInDB(final String string, final Context context, final boolean bl) {
        class Worker
        extends ProgressRunnable {
            protected boolean isValid = false;
            protected String errorText;

            Worker() {
            }

            protected Object doWork() throws Exception {
                this.isValid = CommentValidator.executeCommentLengthValidInDB(string, context, bl);
                return this.isValid;
            }
        }
        Worker worker = new Worker();
        worker.setTitle(UtilsLrb.get("COMMENT_VALIDATION_TITLE"));
        worker.setMessage(UtilsLrb.get("COMMENT_VALIDATION_DB_BYTES"));
        worker.setCancelable(true);
        try {
            worker.start(true);
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return worker.isValid;
    }
}

